#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
/*
 * ClusterController.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <iterator>
#include <map>
#include <memory>
#include <set>
#include <tuple>
#include <vector>

#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbrpc/Locality.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/ActorCollection.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/ApplyMetadataMutation.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/ClusterController.actor.h"
#include "fdbserver/ClusterRecovery.actor.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/DBCoreState.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/LeaderElection.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemConfig.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/SingletonRoles.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/LatencyBandConfig.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbserver/RecoveryState.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/Replication.h"
#include "fdbrpc/ReplicationUtils.h"
#include "fdbrpc/sim_validation.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/Util.h"

#include "metacluster/MetaclusterMetrics.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 80 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via getPreviousCoordinators()
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class GetPreviousCoordinatorsActor>
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActorState {
															#line 87 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActorState(ClusterControllerData* const& self) 
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(self->db.db)
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~GetPreviousCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("getPreviousCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(previousCoordinatorsKey);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*>(static_cast<GetPreviousCoordinatorsActor*>(this)));
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && previousCoordinators,int loopDepth) 
	{
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<GetPreviousCoordinatorsActor*>(this)->SAV<Optional<Value>>::futures) { (void)(previousCoordinators); this->~GetPreviousCoordinatorsActorState(); static_cast<GetPreviousCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<GetPreviousCoordinatorsActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(previousCoordinators);
		this->~GetPreviousCoordinatorsActorState();
		static_cast<GetPreviousCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(previousCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && previousCoordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(previousCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<GetPreviousCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<GetPreviousCoordinatorsActor*>(this)->ActorCallback< GetPreviousCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via getPreviousCoordinators()
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class GetPreviousCoordinatorsActor final : public Actor<Optional<Value>>, public ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< GetPreviousCoordinatorsActor, 1, Void >, public FastAllocated<GetPreviousCoordinatorsActor>, public GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor> {
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<GetPreviousCoordinatorsActor>::operator new;
	using FastAllocated<GetPreviousCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17840947182441262080UL, 16518518689564560640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< GetPreviousCoordinatorsActor, 1, Void >;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	GetPreviousCoordinatorsActor(ClusterControllerData* const& self) 
															#line 408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Optional<Value>>(),
		   GetPreviousCoordinatorsActorState<GetPreviousCoordinatorsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9522256357088947712UL, 3090868322878582016UL);
		ActorExecutionContextHelper __helper(static_cast<GetPreviousCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPreviousCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPreviousCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetPreviousCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Optional<Value>> getPreviousCoordinators( ClusterControllerData* const& self ) {
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Optional<Value>>(new GetPreviousCoordinatorsActor(self));
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 92 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

bool ClusterControllerData::processesInSameDC(const NetworkAddress& addr1, const NetworkAddress& addr2) const {
	return this->addr_locality.contains(addr1) && this->addr_locality.contains(addr2) &&
	       this->addr_locality.at(addr1).dcId().present() && this->addr_locality.at(addr2).dcId().present() &&
	       this->addr_locality.at(addr1).dcId().get() == this->addr_locality.at(addr2).dcId().get();
}

bool ClusterControllerData::transactionSystemContainsDegradedServers() {
	const ServerDBInfo& dbi = db.serverInfo->get();
	const Reference<ClusterRecoveryData> recoveryData = db.recoveryData;
	auto transactionWorkerInList = [&dbi, &recoveryData](const std::unordered_set<NetworkAddress>& serverList,
	                                                     bool skipSatellite,
	                                                     bool skipRemoteTLog,
	                                                     bool skipRemoteLogRouter) -> bool {
		for (const auto& server : serverList) {
			if (dbi.master.addresses().contains(server)) {
				return true;
			}

			// Getting the current log system config to check if any TLogs are degraded. recoveryData->logSystem has the
			// most up to date log system and we should use it whenever available.
			auto logSystemConfig = (recoveryData.isValid() && recoveryData->logSystem.isValid())
			                           ? recoveryData->logSystem->getLogSystemConfig()
			                           : dbi.logSystemConfig;
			for (const auto& logSet : logSystemConfig.tLogs) {
				if (skipSatellite && logSet.locality == tagLocalitySatellite) {
					continue;
				}

				if (!logSet.isLocal) {
					if (!skipRemoteTLog) {
						for (const auto& tlog : logSet.tLogs) {
							if (tlog.present() && tlog.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
					if (!skipRemoteLogRouter) {
						for (const auto& logRouter : logSet.logRouters) {
							if (logRouter.present() && logRouter.interf().addresses().contains(server)) {
								return true;
							}
						}
					}
				} else {
					for (const auto& tlog : logSet.tLogs) {
						if (tlog.present() && tlog.interf().addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			if (SERVER_KNOBS->GRAY_FAILURE_ENABLE_TLOG_RECOVERY_MONITORING && recoveryData.isValid() &&
			    recoveryData->recoveryState < RecoveryState::ACCEPTING_COMMITS) {
				// During recovery, TLogs may not be able to pull data from previous generation TLogs due to gray
				// failures. In this case, we rely on the latest recruitment information and see if any newly recruited
				// TLogs are degraded.
				for (const auto& tlog : recoveryData->primaryRecruitment.tLogs) {
					if (tlog.addresses().contains(server)) {
						return true;
					}
				}

				if (!skipSatellite) {
					for (const auto& satelliteLog : recoveryData->primaryRecruitment.satelliteTLogs) {
						if (satelliteLog.addresses().contains(server)) {
							return true;
						}
					}
				}
			}

			for (const auto& proxy : dbi.client.grvProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& proxy : dbi.client.commitProxies) {
				if (proxy.addresses().contains(server)) {
					return true;
				}
			}

			for (const auto& resolver : dbi.resolvers) {
				if (resolver.addresses().contains(server)) {
					return true;
				}
			}
		}
		return false;
	};

	// Check if transaction system contains degraded/disconnected servers. For satellite, we only
	// check for disconnection since the latency between prmary and satellite is across WAN and may not be very
	// stable.
	// TODO: Consider adding satellite latency degradation check and rely on
	//       SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY for accurate health signal
	return transactionWorkerInList(degradationInfo.degradedServers,
	                               /*skipSatellite=*/true,
	                               /*skipRemoteTLog=*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DEGRADATION_MONITORING),
	                               /*skipRemoteLogRouter*/
	                               !(SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY &&
	                                 SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DEGRADATION_MONITORING)) ||
	       transactionWorkerInList(
	           degradationInfo.disconnectedServers,
	           /*skipSatellite=*/false,
	           /*skipRemoteTLog=*/!SERVER_KNOBS->CC_ENABLE_REMOTE_TLOG_DISCONNECT_MONITORING,
	           /*skipRemoteLogRouter*/ !SERVER_KNOBS->CC_ENABLE_REMOTE_LOG_ROUTER_DISCONNECT_MONITORING);
}

bool ClusterControllerData::remoteTransactionSystemContainsDegradedServers() {
	if (db.config.usableRegions <= 1) {
		return false;
	}

	for (const auto& excludedServer : degradationInfo.degradedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	for (const auto& excludedServer : degradationInfo.disconnectedServers) {
		if (addressInDbAndRemoteDc(excludedServer, db.serverInfo)) {
			return true;
		}
	}

	return false;
}

															#line 580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterWatchDatabase()
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterWatchDatabaseActor>
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActorState {
															#line 587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActorState(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   db(db),
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   iMaster(),
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   addActor(),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recoveryCore()
															#line 604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterWatchDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterWatchDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterWatchDatabaseActorState();
		static_cast<ClusterWatchDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).log();
															#line 649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		try {
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			recoveryStart = now();
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			newMaster = MasterInterface();
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			collection = Future<Void>();
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).detail("Recruiting", "Master");
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = recruitNewMaster(cluster, db, std::addressof(newMaster));
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 1;
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 0, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			err = e;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCWDB", cluster->id).errorUnsuppressed(e).detail("Master", iMaster.id());
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_8 = delay(0.0);
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
				static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 5;
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 8, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.tenantMode = TenantAPI::tenantModeForClusterType(db->clusterType, db->config.tenantMode);
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.metaclusterName = db->metaclusterName;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		iMaster = newMaster;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->masterRegistrationCount = 0;
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryStalled = false;
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto dbInfo = ServerDBInfo();
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.master = iMaster;
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.id = deterministicRandom()->randomUniqueID();
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.infoGeneration = ++db->dbInfoCount;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.masterLifetime = db->serverInfo->get().masterLifetime;
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++dbInfo.masterLifetime;
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.clusterInterface = db->serverInfo->get().clusterInterface;
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.distributor = db->serverInfo->get().distributor;
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.ratekeeper = db->serverInfo->get().ratekeeper;
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.consistencyScan = db->serverInfo->get().consistencyScan;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.latencyBandConfig = db->serverInfo->get().latencyBandConfig;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.myLocality = db->serverInfo->get().myLocality;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client = ClientDBInfo();
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.tenantMode = TenantAPI::tenantModeForClusterType(db->clusterType, db->config.tenantMode);
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterId = db->serverInfo->get().client.clusterId;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.clusterType = db->clusterType;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		dbInfo.client.metaclusterName = db->metaclusterName;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id) .detail("NewMaster", dbInfo.master.id().toString()) .detail("Lifetime", dbInfo.masterLifetime.toString()) .detail("ChangeID", dbInfo.id);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(dbInfo);
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		spinDelay = delay( SERVER_KNOBS ->MASTER_SPIN_DELAY);
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCWDB", cluster->id).detail("Watching", iMaster.id());
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->recoveryData = makeReference<ClusterRecoveryData>(cluster, db->serverInfo, db->serverInfo->get().master, db->serverInfo->get().masterLifetime, coordinators, db->serverInfo->get().clusterInterface, ""_sr, addActor, db->forceRecovery);
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		collection = actorCollection(db->recoveryData->addActor.getFuture());
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore = clusterRecoveryCore(db->recoveryData);
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->recentHealthTriggeredRecoveryTime.push(now());
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide)
															#line 934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(restart_cluster_controller(), loopDepth);
															#line 938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cleanupRecoveryActorCollection(db->recoveryData, false);
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 3;
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 6, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = recoveryCore;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFailureClient( iMaster.waitFailure, db->masterRegistrationCount ? SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME : (now() - recoveryStart) * SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY, db->masterRegistrationCount ? -SERVER_KNOBS->MASTER_FAILURE_REACTION_TIME / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY : SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY) || db->forceMasterFailure.onTrigger();
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = db->serverInfo->onChange();
															#line 977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_4 = db->serverInfo->get().clusterInterface.notifyBackupWorkerDone.getFuture();
															#line 981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<BackupWorkerDoneRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<BackupWorkerDoneRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = collection;
															#line 986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when5(__when_expr_5.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 2;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 1, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 2, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 3, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 5, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest const& req,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 1063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 1067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 1075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when4(BackupWorkerDoneRequest && req,int loopDepth) 
	{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (db->recoveryData->logSystem.isValid() && db->recoveryData->logSystem->removeBackupWorker(req))
															#line 1084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->recoveryData->registrationTrigger.trigger();
															#line 1088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++db->recoveryData->backupWorkerDoneRequests;
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevDebug, "BackupWorkerDoneRequest", cluster->id).log();
															#line 1096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void const& _,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 1105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when5(Void && _,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 1113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 1, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 2, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 3, Void >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >::remove();
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,BackupWorkerDoneRequest && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_7 = spinDelay;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_7.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 4;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 7, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 1529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(true, "clusterWatchDatabase() master failed");
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevWarn, "DetectedFailedRecovery", cluster->id).detail("OldMaster", iMaster.id());
															#line 1540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		recoveryCore.cancel();
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_9 = cleanupRecoveryActorCollection(db->recoveryData, true);
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 6;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 9, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 1744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 1748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 1752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 1756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 1774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 1780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 1784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 1788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 1796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(addActor.isEmpty());
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRemoteRequestChecker.isValid())
															#line 1818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRemoteRequestChecker.cancel();
															#line 1822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->outstandingRequestChecker.isValid())
															#line 1826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->outstandingRequestChecker.cancel();
															#line 1830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_tlog_failed, "Terminated due to tLog failure");
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Terminated due to commit proxy failure");
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Terminated due to GRV proxy failure");
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Terminated due to resolver failure");
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Terminated due to backup worker failure");
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_operation_failed, "Terminated due to failed operation", probe::decoration::rare);
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		CODE_PROBE(err.code() == error_code_restart_cluster_controller, "Terminated due to cluster-controller restart.");
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (cluster->shouldCommitSuicide || err.code() == error_code_coordinators_changed)
															#line 1848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerTerminate", cluster->id).errorUnsuppressed(err);
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(restart_cluster_controller(), std::max(0, loopDepth - 1));
															#line 1854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (isNormalClusterRecoveryError(err))
															#line 1858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevWarn, "ClusterRecoveryRetrying", cluster->id).error(err);
															#line 1862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "ClusterWatchDatabaseRetrying", cluster->id).error(err);
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 1870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_10.get(), loopDepth); };
		static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 7;
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ClusterWatchDatabaseActor, 10, Void >*>(static_cast<ClusterWatchDatabaseActor*>(this)));
															#line 1881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterWatchDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterWatchDatabaseActor*>(this)->ActorCallback< ClusterWatchDatabaseActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ClusterWatchDatabaseActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface iMaster;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> recoveryCore;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double recoveryStart;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MasterInterface newMaster;
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> collection;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> spinDelay;
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Error err;
															#line 2070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via clusterWatchDatabase()
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterWatchDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterWatchDatabaseActor, 0, Void >, public ActorCallback< ClusterWatchDatabaseActor, 1, Void >, public ActorCallback< ClusterWatchDatabaseActor, 2, Void >, public ActorCallback< ClusterWatchDatabaseActor, 3, Void >, public ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >, public ActorCallback< ClusterWatchDatabaseActor, 5, Void >, public ActorCallback< ClusterWatchDatabaseActor, 6, Void >, public ActorCallback< ClusterWatchDatabaseActor, 7, Void >, public ActorCallback< ClusterWatchDatabaseActor, 8, Void >, public ActorCallback< ClusterWatchDatabaseActor, 9, Void >, public ActorCallback< ClusterWatchDatabaseActor, 10, Void >, public FastAllocated<ClusterWatchDatabaseActor>, public ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor> {
															#line 2075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<ClusterWatchDatabaseActor>::operator new;
	using FastAllocated<ClusterWatchDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16354995247916866304UL, 15972014393728437504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterWatchDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 1, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 2, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 3, Void >;
friend struct ActorSingleCallback< ClusterWatchDatabaseActor, 4, BackupWorkerDoneRequest >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 5, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 6, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 7, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 8, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 9, Void >;
friend struct ActorCallback< ClusterWatchDatabaseActor, 10, Void >;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterWatchDatabaseActor(ClusterControllerData* const& cluster,ClusterControllerData::DBInfo* const& db,ServerCoordinators const& coordinators) 
															#line 2102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterWatchDatabaseActorState<ClusterWatchDatabaseActor>(cluster, db, coordinators),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15084720662247522304UL, 7134482422509323520UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterWatchDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterWatchDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterWatchDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 7, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 8, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 9, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ClusterWatchDatabaseActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterWatchDatabase( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, ServerCoordinators const& coordinators ) {
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterWatchDatabaseActor(cluster, db, coordinators));
															#line 2141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 382 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 2146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterGetServerInfo()
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterGetServerInfoActor>
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActorState {
															#line 2153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActorState(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   knownServerInfoID(knownServerInfoID),
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   reply(reply)
															#line 2164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	~ClusterGetServerInfoActorState() 
	{
		fdb_probe_actor_destroy("clusterGetServerInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 2179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		reply.send(db->serverInfo->get());
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterGetServerInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterGetServerInfoActorState(); static_cast<ClusterGetServerInfoActor*>(this)->destroy(); return 0; }
															#line 2204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<ClusterGetServerInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterGetServerInfoActorState();
		static_cast<ClusterGetServerInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->serverInfo->get().id == knownServerInfoID))
															#line 2223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yieldedFuture(db->serverInfo->onChange());
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(300);
															#line 2235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 1;
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 0, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterGetServerInfoActor, 1, Void >*>(static_cast<ClusterGetServerInfoActor*>(this)));
															#line 2242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state > 0) static_cast<ClusterGetServerInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 0, Void >::remove();
		static_cast<ClusterGetServerInfoActor*>(this)->ActorCallback< ClusterGetServerInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterGetServerInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID knownServerInfoID;
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReplyPromise<ServerDBInfo> reply;
															#line 2417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via clusterGetServerInfo()
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterGetServerInfoActor final : public Actor<Void>, public ActorCallback< ClusterGetServerInfoActor, 0, Void >, public ActorCallback< ClusterGetServerInfoActor, 1, Void >, public FastAllocated<ClusterGetServerInfoActor>, public ClusterGetServerInfoActorState<ClusterGetServerInfoActor> {
															#line 2422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<ClusterGetServerInfoActor>::operator new;
	using FastAllocated<ClusterGetServerInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8106796369488168448UL, 265852425952525056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterGetServerInfoActor, 0, Void >;
friend struct ActorCallback< ClusterGetServerInfoActor, 1, Void >;
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterGetServerInfoActor(ClusterControllerData::DBInfo* const& db,UID const& knownServerInfoID,ReplyPromise<ServerDBInfo> const& reply) 
															#line 2440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterGetServerInfoActorState<ClusterGetServerInfoActor>(db, knownServerInfoID, reply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8722247202050210304UL, 18223546808676413184UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterGetServerInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterGetServerInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterGetServerInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterGetServerInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterGetServerInfo( ClusterControllerData::DBInfo* const& db, UID const& knownServerInfoID, ReplyPromise<ServerDBInfo> const& reply ) {
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterGetServerInfoActor(db, knownServerInfoID, reply));
															#line 2473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 397 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 2478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via clusterOpenDatabase()
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class ClusterOpenDatabaseActor>
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActorState {
															#line 2485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActorState(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db),
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 2494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClusterOpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clusterOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->clientStatus[req.reply.getEndpoint().getPrimaryAddress()] = std::make_pair(now(), req);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (db->clientStatus.size() > 10000)
															#line 2511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyClientStatusEntries").suppressFor(1.0);
															#line 2515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 2519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(db->clientInfo->get());
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<ClusterOpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClusterOpenDatabaseActorState(); static_cast<ClusterOpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 2544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<ClusterOpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClusterOpenDatabaseActorState();
		static_cast<ClusterOpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(db->clientInfo->get().id == req.knownClientInfoID))
															#line 2563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->clientInfo->onChange();
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(SERVER_KNOBS->COORDINATOR_REGISTER_INTERVAL);
															#line 2575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 0, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClusterOpenDatabaseActor, 1, Void >*>(static_cast<ClusterOpenDatabaseActor*>(this)));
															#line 2582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClusterOpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 0, Void >::remove();
		static_cast<ClusterOpenDatabaseActor*>(this)->ActorCallback< ClusterOpenDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClusterOpenDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	OpenDatabaseRequest req;
															#line 2755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via clusterOpenDatabase()
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class ClusterOpenDatabaseActor final : public Actor<Void>, public ActorCallback< ClusterOpenDatabaseActor, 0, Void >, public ActorCallback< ClusterOpenDatabaseActor, 1, Void >, public FastAllocated<ClusterOpenDatabaseActor>, public ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor> {
															#line 2760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<ClusterOpenDatabaseActor>::operator new;
	using FastAllocated<ClusterOpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4672961044548123136UL, 17161609222086196736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClusterOpenDatabaseActor, 0, Void >;
friend struct ActorCallback< ClusterOpenDatabaseActor, 1, Void >;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterOpenDatabaseActor(ClusterControllerData::DBInfo* const& db,OpenDatabaseRequest const& req) 
															#line 2778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   ClusterOpenDatabaseActorState<ClusterOpenDatabaseActor>(db, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4479359797486159872UL, 7876825679301567232UL);
		ActorExecutionContextHelper __helper(static_cast<ClusterOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clusterOpenDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clusterOpenDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClusterOpenDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> clusterOpenDatabase( ClusterControllerData::DBInfo* const& db, OpenDatabaseRequest const& req ) {
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new ClusterOpenDatabaseActor(db, req));
															#line 2811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 416 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRecruitmentRequests.size(); i++) {
		Reference<RecruitWorkersInfo> info = self->outstandingRecruitmentRequests[i];
		try {
			info->rep = self->findWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingRemoteRecruitmentRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingRemoteRecruitmentRequests.size(); i++) {
		Reference<RecruitRemoteWorkersInfo> info = self->outstandingRemoteRecruitmentRequests[i];
		try {
			info->rep = self->findRemoteWorkersForConfiguration(info->req);
			if (info->dbgId.present()) {
				TraceEvent("CheckOutstandingRemoteRecruitment", info->dbgId.get())
				    .detail("Request", info->req.configuration.toString());
			}
			info->waitForCompletion.trigger();
			swapAndPop(&self->outstandingRemoteRecruitmentRequests, i--);
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers || e.code() == error_code_operation_failed) {
				TraceEvent(SevWarn, "RecruitRemoteTLogMatchingSetNotAvailable", self->id).error(e);
			} else {
				TraceEvent(SevError, "RecruitRemoteTLogsRequestError", self->id).error(e);
				throw;
			}
		}
	}
}

void checkOutstandingStorageRequests(ClusterControllerData* self) {
	for (int i = 0; i < self->outstandingStorageRequests.size(); i++) {
		auto& req = self->outstandingStorageRequests[i];
		try {
			if (req.second < now()) {
				req.first.reply.sendError(timed_out());
				swapAndPop(&self->outstandingStorageRequests, i--);
			} else {
				if (!self->gotProcessClasses && !req.first.criticalRecruitment)
					throw no_more_servers();

				auto worker = self->getStorageWorker(req.first);
				RecruitStorageReply rep;
				rep.worker = worker.interf;
				rep.processClass = worker.processClass;
				req.first.reply.send(rep);
				swapAndPop(&self->outstandingStorageRequests, i--);
			}
		} catch (Error& e) {
			if (e.code() == error_code_no_more_servers) {
				TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
				    .errorUnsuppressed(e)
				    .suppressFor(1.0)
				    .detail("OutstandingReq", i)
				    .detail("IsCriticalRecruitment", req.first.criticalRecruitment);
			} else {
				TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
				throw;
			}
		}
	}
}

// Finds and returns a new process for role
WorkerDetails findNewProcessForSingleton(ClusterControllerData* self,
                                         const ProcessClass::ClusterRole role,
                                         std::map<Optional<Standalone<StringRef>>, int>& id_used) {
	// find new process in cluster for role
	WorkerDetails newWorker =
	    self->getWorkerForRoleInDatacenter(
	            self->clusterControllerDcId, role, ProcessClass::NeverAssign, self->db.config, id_used, {}, true)
	        .worker;

	// check if master's process is actually better suited for role
	if (self->onMasterIsBetter(newWorker, role)) {
		newWorker = self->id_worker[self->masterProcessId.get()].details;
	}

	// acknowledge that the pid is now potentially used by this role as well
	id_used[newWorker.interf.locality.processId()]++;

	return newWorker;
}

// Return best possible fitness for singleton. Note that lower fitness is better.
ProcessClass::Fitness findBestFitnessForSingleton(const ClusterControllerData* self,
                                                  const WorkerDetails& worker,
                                                  const ProcessClass::ClusterRole& role) {
	auto bestFitness = worker.processClass.machineClassFitness(role);
	// If the process has been marked as excluded, we take the max with ExcludeFit to ensure its fit
	// is at least as bad as ExcludeFit. This assists with successfully offboarding such processes
	// and removing them from the cluster.
	if (self->db.config.isExcludedServer(worker.interf.addresses(), worker.interf.locality)) {
		bestFitness = std::max(bestFitness, ProcessClass::ExcludeFit);
	}
	return bestFitness;
}

// Returns true iff the singleton is healthy. "Healthy" here means that
// the singleton is stable (see below) and doesn't need to be rerecruited.
// Side effects: (possibly) initiates recruitment
template <class SingletonClass>
bool isHealthySingleton(ClusterControllerData* self,
                        const WorkerDetails& newWorker,
                        const SingletonClass& singleton,
                        const ProcessClass::Fitness& bestFitness,
                        const Optional<UID> recruitingID) {
	// A singleton is stable if it exists in cluster, has not been killed off of proc and is not being recruited
	bool isStableSingleton = singleton.isPresent() &&
	                         self->id_worker.contains(singleton.getInterface().locality.processId()) &&
	                         (!recruitingID.present() || (recruitingID.get() == singleton.getInterface().id()));

	if (!isStableSingleton) {
		return false; // not healthy because unstable
	}

	auto& currWorker = self->id_worker[singleton.getInterface().locality.processId()];
	auto currFitness = currWorker.details.processClass.machineClassFitness(singleton.getClusterRole());
	if (currWorker.priorityInfo.isExcluded) {
		currFitness = ProcessClass::ExcludeFit;
	}
	// If any of the following conditions are met, we will switch the singleton's process:
	// - if the current proc is used by some non-master, non-singleton role
	// - if the current fitness is less than optimal (lower fitness is better)
	// - if currently at peak fitness but on same process as master, and the new worker is on different process
	bool shouldRerecruit =
	    self->isUsedNotMaster(currWorker.details.interf.locality.processId()) || bestFitness < currFitness ||
	    (currFitness == bestFitness && currWorker.details.interf.locality.processId() == self->masterProcessId &&
	     newWorker.interf.locality.processId() != self->masterProcessId);
	if (g_network->isSimulated() && singleton.getRole() == Role::DATA_DISTRIBUTOR &&
	    SERVER_KNOBS->CC_ENFORCE_USE_UNFIT_DD_IN_SIM) {
		// It is possible that DD location is not optimal in the simulation.
		// This can cause the simulation stuck if it always halts DD.
		// TODO(BulkLoad): this is a work around. We should figure out why DD can be repeatedly
		// terminated by CC throughout the simulation.
		shouldRerecruit = false;
	}
	if (shouldRerecruit) {
		std::string roleAbbr = singleton.getRole().abbreviation;
		TraceEvent(("CCHalt" + roleAbbr).c_str(), self->id)
		    .detail(roleAbbr + "ID", singleton.getInterface().id())
		    .detail("Excluded", currWorker.priorityInfo.isExcluded)
		    .detail("Fitness", currFitness)
		    .detail("BestFitness", bestFitness)
		    .detail("MasterProcessId", self->masterProcessId)
		    .detail("CurrentWorkerProcessId", currWorker.details.interf.locality.processId())
		    .detail("NewWorkerProcessId", newWorker.interf.locality.processId())
		    .detail("IsUsedNotMaster", self->isUsedNotMaster(currWorker.details.interf.locality.processId()));
		singleton.recruit(*self); // SIDE EFFECT: initiating recruitment
		return false; // not healthy since needed to be rerecruited
	} else {
		return true; // healthy because doesn't need to be rerecruited
	}
}

// Returns a mapping from pid->pidCount for pids
std::map<Optional<Standalone<StringRef>>, int> getColocCounts(
    const std::vector<Optional<Standalone<StringRef>>>& pids) {
	std::map<Optional<Standalone<StringRef>>, int> counts;
	for (const auto& pid : pids) {
		if (pid.present()) {
			++counts[pid];
		}
	}
	return counts;
}

// Checks if there exists a better process for each singleton (e.g. DD) compared
// to the process it is currently on.
// When adding new singletons, just follow the ratekeeper/data distributor examples.
void checkBetterSingletons(ClusterControllerData* self) {
	if (!self->masterProcessId.present() ||
	    self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS) {
		return;
	}

	// note: this map doesn't consider pids used by existing singletons
	std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();

	// We prefer spreading out other roles more than separating singletons on their own process
	// so we artificially amplify the pid count for the processes used by non-singleton roles.
	// In other words, we make the processes used for other roles less desirable to be used
	// by singletons as well.
	for (auto& it : id_used) {
		it.second *= PID_USED_AMP_FOR_NON_SINGLETON;
	}

	// Try to find a new process for each singleton.
	WorkerDetails newRKWorker = findNewProcessForSingleton(self, ProcessClass::Ratekeeper, id_used);
	WorkerDetails newDDWorker = findNewProcessForSingleton(self, ProcessClass::DataDistributor, id_used);
	WorkerDetails newCSWorker = findNewProcessForSingleton(self, ProcessClass::ConsistencyScan, id_used);

	WorkerDetails newEKPWorker;
	EncryptionAtRestMode encryptMode = self->db.config.encryptionAtRestMode;
	const bool enableKmsCommunication =
	    encryptMode.isEncryptionEnabled() || SERVER_KNOBS->ENABLE_REST_KMS_COMMUNICATION;
	if (enableKmsCommunication) {
		newEKPWorker = findNewProcessForSingleton(self, ProcessClass::EncryptKeyProxy, id_used);
	}

	// Find best possible fitnesses for each singleton.
	auto bestFitnessForRK = findBestFitnessForSingleton(self, newRKWorker, ProcessClass::Ratekeeper);
	auto bestFitnessForDD = findBestFitnessForSingleton(self, newDDWorker, ProcessClass::DataDistributor);
	auto bestFitnessForCS = findBestFitnessForSingleton(self, newCSWorker, ProcessClass::ConsistencyScan);

	ProcessClass::Fitness bestFitnessForEKP;
	if (enableKmsCommunication) {
		bestFitnessForEKP = findBestFitnessForSingleton(self, newEKPWorker, ProcessClass::EncryptKeyProxy);
	}

	auto& db = self->db.serverInfo->get();
	auto rkSingleton = RatekeeperSingleton(db.ratekeeper);
	auto ddSingleton = DataDistributorSingleton(db.distributor);
	ConsistencyScanSingleton csSingleton(db.consistencyScan);
	EncryptKeyProxySingleton ekpSingleton(db.client.encryptKeyProxy);

	// Check if the singletons are healthy.
	// side effect: try to rerecruit the singletons to more optimal processes
	bool rkHealthy = isHealthySingleton<RatekeeperSingleton>(
	    self, newRKWorker, rkSingleton, bestFitnessForRK, self->recruitingRatekeeperID);

	bool ddHealthy = isHealthySingleton<DataDistributorSingleton>(
	    self, newDDWorker, ddSingleton, bestFitnessForDD, self->recruitingDistributorID);

	bool csHealthy = isHealthySingleton<ConsistencyScanSingleton>(
	    self, newCSWorker, csSingleton, bestFitnessForCS, self->recruitingConsistencyScanID);

	bool ekpHealthy = true;
	if (enableKmsCommunication) {
		ekpHealthy = isHealthySingleton<EncryptKeyProxySingleton>(
		    self, newEKPWorker, ekpSingleton, bestFitnessForEKP, self->recruitingEncryptKeyProxyID);
	}
	// if any of the singletons are unhealthy (rerecruited or not stable), then do not
	// consider any further re-recruitments
	if (!(rkHealthy && ddHealthy && ekpHealthy && csHealthy)) {
		return;
	}

	// if we reach here, we know that the singletons are healthy so let's
	// check if we can colocate the singletons in a more optimal way
	Optional<Standalone<StringRef>> currRKProcessId = rkSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currDDProcessId = ddSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> currCSProcessId = csSingleton.getInterface().locality.processId();
	Optional<Standalone<StringRef>> newRKProcessId = newRKWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newDDProcessId = newDDWorker.interf.locality.processId();
	Optional<Standalone<StringRef>> newCSProcessId = newCSWorker.interf.locality.processId();

	Optional<Standalone<StringRef>> currEKPProcessId, newEKPProcessId;
	if (enableKmsCommunication) {
		currEKPProcessId = ekpSingleton.getInterface().locality.processId();
		newEKPProcessId = newEKPWorker.interf.locality.processId();
	}

	std::vector<Optional<Standalone<StringRef>>> currPids = { currRKProcessId, currDDProcessId, currCSProcessId };
	std::vector<Optional<Standalone<StringRef>>> newPids = { newRKProcessId, newDDProcessId, newCSProcessId };
	if (enableKmsCommunication) {
		currPids.emplace_back(currEKPProcessId);
		newPids.emplace_back(newEKPProcessId);
	}

	auto currColocMap = getColocCounts(currPids);
	auto newColocMap = getColocCounts(newPids);

	// if the knob is disabled, the EKP coloc counts should have no affect on the coloc counts check below
	if (!enableKmsCommunication) {
		ASSERT(currColocMap[currEKPProcessId] == 0);
		ASSERT(newColocMap[newEKPProcessId] == 0);
	}

	// if the new coloc counts are collectively better (i.e. each singleton's coloc count has not increased)
	if (newColocMap[newRKProcessId] <= currColocMap[currRKProcessId] &&
	    newColocMap[newDDProcessId] <= currColocMap[currDDProcessId] &&
	    newColocMap[newEKPProcessId] <= currColocMap[currEKPProcessId] &&
	    newColocMap[newCSProcessId] <= currColocMap[currCSProcessId]) {
		// rerecruit the singleton for which we have found a better process, if any
		if (newColocMap[newRKProcessId] < currColocMap[currRKProcessId]) {
			rkSingleton.recruit(*self);
		} else if (newColocMap[newDDProcessId] < currColocMap[currDDProcessId]) {
			ddSingleton.recruit(*self);
		} else if (enableKmsCommunication && newColocMap[newEKPProcessId] < currColocMap[currEKPProcessId]) {
			ekpSingleton.recruit(*self);
		} else if (newColocMap[newCSProcessId] < currColocMap[currCSProcessId]) {
			csSingleton.recruit(*self);
		}
	}
}

															#line 3117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRequestsActor>
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActorState {
															#line 3124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActorState(ClusterControllerData* const& self) 
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 3131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 1;
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 3154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRequestsActorState(); static_cast<DoCheckOutstandingRequestsActor*>(this)->destroy(); return 0; }
															#line 3183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoCheckOutstandingRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRequestsActorState();
		static_cast<DoCheckOutstandingRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 3196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 3200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRecruitmentRequests(self);
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingStorageRequests(self);
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkBetterSingletons(self);
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->checkRecoveryStalled();
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->betterMasterExists())
															#line 3317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.forceMasterFailure.trigger();
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("MasterRegistrationKill", self->id).detail("MasterId", self->db.serverInfo->get().master.id());
															#line 3323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY || !self->goodRecruitmentTime.isReady()))
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (now() - self->lastRecruitTime < SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY)
															#line 3346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->SINGLETON_RECRUIT_BME_DELAY + 0.001 - (now() - self->lastRecruitTime));
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 2;
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 3357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->goodRecruitmentTime.isReady())
															#line 3384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->goodRecruitmentTime;
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 3;
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*>(static_cast<DoCheckOutstandingRequestsActor*>(this)));
															#line 3395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 3600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via doCheckOutstandingRequests()
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >, public ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >, public FastAllocated<DoCheckOutstandingRequestsActor>, public DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor> {
															#line 3605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10154384780948652800UL, 8326727644974511872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >;
friend struct ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >;
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRequestsActor(ClusterControllerData* const& self) 
															#line 3624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   DoCheckOutstandingRequestsActorState<DoCheckOutstandingRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18376869144156441344UL, 10196932547024268032UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoCheckOutstandingRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRequests( ClusterControllerData* const& self ) {
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRequestsActor(self));
															#line 3659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 748 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 3664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoCheckOutstandingRemoteRequestsActor>
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActorState {
															#line 3671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActorState(ClusterControllerData* const& self) 
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 3678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	~DoCheckOutstandingRemoteRequestsActorState() 
	{
		fdb_probe_actor_destroy("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->CHECK_OUTSTANDING_INTERVAL);
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 1;
															#line 751 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 3701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoCheckOutstandingRemoteRequestsActorState(); static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->destroy(); return 0; }
															#line 3730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoCheckOutstandingRemoteRequestsActorState();
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 3743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevError, "CheckOutstandingError").error(e);
															#line 3747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 3772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		checkOutstandingRemoteRecruitmentRequests(self);
															#line 3856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->goodRemoteRecruitmentTime.isReady()))
															#line 3872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->goodRemoteRecruitmentTime;
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 2;
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*>(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)));
															#line 3885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state > 0) static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 4005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via doCheckOutstandingRemoteRequests()
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoCheckOutstandingRemoteRequestsActor final : public Actor<Void>, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >, public ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >, public FastAllocated<DoCheckOutstandingRemoteRequestsActor>, public DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor> {
															#line 4010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator new;
	using FastAllocated<DoCheckOutstandingRemoteRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8215803877822569216UL, 12608630358695996928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >;
friend struct ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >;
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoCheckOutstandingRemoteRequestsActor(ClusterControllerData* const& self) 
															#line 4028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   DoCheckOutstandingRemoteRequestsActorState<DoCheckOutstandingRemoteRequestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11202796549843407360UL, 6198894268515362560UL);
		ActorExecutionContextHelper __helper(static_cast<DoCheckOutstandingRemoteRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doCheckOutstandingRemoteRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doCheckOutstandingRemoteRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoCheckOutstandingRemoteRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doCheckOutstandingRemoteRequests( ClusterControllerData* const& self ) {
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoCheckOutstandingRemoteRequestsActor(self));
															#line 4062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 764 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

void checkOutstandingRequests(ClusterControllerData* self) {
	if (self->outstandingRemoteRequestChecker.isReady()) {
		self->outstandingRemoteRequestChecker = doCheckOutstandingRemoteRequests(self);
	}

	if (self->outstandingRequestChecker.isReady()) {
		self->outstandingRequestChecker = doCheckOutstandingRequests(self);
	}
}

															#line 4077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via rebootAndCheck()
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RebootAndCheckActor>
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActorState {
															#line 4084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActorState(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cluster(cluster),
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   processID(processID)
															#line 4093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	~RebootAndCheckActorState() 
	{
		fdb_probe_actor_destroy("rebootAndCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(processID.present());
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto watcher = cluster->id_worker.find(processID);
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(watcher != cluster->id_worker.end());
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots++;
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(g_network->isSimulated() ? SERVER_KNOBS->SIM_SHUTDOWN_TIMEOUT : SERVER_KNOBS->SHUTDOWN_TIMEOUT);
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 1;
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RebootAndCheckActor, 0, Void >*>(static_cast<RebootAndCheckActor*>(this)));
															#line 4124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto watcher = cluster->id_worker.find(processID);
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (watcher != cluster->id_worker.end())
															#line 4151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				watcher->second.reboots--;
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (watcher->second.reboots < 2)
															#line 4157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					checkOutstandingRequests(cluster);
															#line 4161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RebootAndCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RebootAndCheckActorState(); static_cast<RebootAndCheckActor*>(this)->destroy(); return 0; }
															#line 4167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RebootAndCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RebootAndCheckActorState();
		static_cast<RebootAndCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RebootAndCheckActor*>(this)->actor_wait_state > 0) static_cast<RebootAndCheckActor*>(this)->actor_wait_state = 0;
		static_cast<RebootAndCheckActor*>(this)->ActorCallback< RebootAndCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RebootAndCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RebootAndCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Standalone<StringRef>> processID;
															#line 4266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via rebootAndCheck()
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RebootAndCheckActor final : public Actor<Void>, public ActorCallback< RebootAndCheckActor, 0, Void >, public FastAllocated<RebootAndCheckActor>, public RebootAndCheckActorState<RebootAndCheckActor> {
															#line 4271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<RebootAndCheckActor>::operator new;
	using FastAllocated<RebootAndCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11967462652165479168UL, 16114896608178381568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RebootAndCheckActor, 0, Void >;
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RebootAndCheckActor(ClusterControllerData* const& cluster,Optional<Standalone<StringRef>> const& processID) 
															#line 4288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   RebootAndCheckActorState<RebootAndCheckActor>(cluster, processID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17703883454640654592UL, 13640791943228081920UL);
		ActorExecutionContextHelper __helper(static_cast<RebootAndCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rebootAndCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rebootAndCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RebootAndCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> rebootAndCheck( ClusterControllerData* const& cluster, Optional<Standalone<StringRef>> const& processID ) {
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RebootAndCheckActor(cluster, processID));
															#line 4321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 796 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 4326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via workerAvailabilityWatch()
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class WorkerAvailabilityWatchActor>
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActorState {
															#line 4333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActorState(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : worker(worker),
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   startingClass(startingClass),
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cluster(cluster),
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   failed((worker.address() == g_network->getLocalAddress()) ? Never() : waitFailureClient(worker.waitFailure, SERVER_KNOBS->WORKER_FAILURE_TIME))
															#line 4346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	~WorkerAvailabilityWatchActorState() 
	{
		fdb_probe_actor_destroy("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->updateWorkerList.set(worker.locality.processId(), ProcessData(worker.locality, startingClass, worker.stableAddress()));
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 1;
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 4370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 4402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = IFailureMonitor::failureMonitor().onStateEqual( worker.storage.getEndpoint(), FailureStatus( IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable()));
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = failed;
															#line 4499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 2;
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*>(static_cast<WorkerAvailabilityWatchActor*>(this)));
															#line 4506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 4521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 4527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (IFailureMonitor::failureMonitor().getState(worker.storage.getEndpoint()).isAvailable())
															#line 4537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->ac.add(rebootAndCheck(cluster, worker.locality.processId()));
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(cluster);
															#line 4543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 823 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 4555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 4559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 4563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 4567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 4577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 4583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 4587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 4594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerInfo& failedWorkerInfo = cluster->id_worker[worker.locality.processId()];
															#line 823 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!failedWorkerInfo.reply.isSet())
															#line 4608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			failedWorkerInfo.reply.send( RegisterWorkerReply(failedWorkerInfo.details.processClass, failedWorkerInfo.priorityInfo));
															#line 4612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 827 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (worker.locality.processId() == cluster->masterProcessId)
															#line 4616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->masterProcessId = Optional<Key>();
															#line 4620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ClusterControllerWorkerFailed", cluster->id) .detail("ProcessId", worker.locality.processId()) .detail("ProcessClass", failedWorkerInfo.details.processClass.toString()) .detail("Address", worker.address());
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->removedDBInfoEndpoints.insert(worker.updateServerDBInfo.getEndpoint());
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->id_worker.erase(worker.locality.processId());
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 4630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			cluster->addr_locality.erase(worker.address());
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.secondaryAddress().present())
															#line 4636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				cluster->addr_locality.erase(worker.secondaryAddress().get());
															#line 4640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		cluster->updateWorkerList.set(worker.locality.processId(), Optional<ProcessData>());
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<WorkerAvailabilityWatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerAvailabilityWatchActorState(); static_cast<WorkerAvailabilityWatchActor*>(this)->destroy(); return 0; }
															#line 4647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<WorkerAvailabilityWatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerAvailabilityWatchActorState();
		static_cast<WorkerAvailabilityWatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state > 0) static_cast<WorkerAvailabilityWatchActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 1, Void >::remove();
		static_cast<WorkerAvailabilityWatchActor*>(this)->ActorCallback< WorkerAvailabilityWatchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WorkerAvailabilityWatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerInterface worker;
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ProcessClass startingClass;
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* cluster;
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> failed;
															#line 4784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via workerAvailabilityWatch()
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class WorkerAvailabilityWatchActor final : public Actor<Void>, public ActorCallback< WorkerAvailabilityWatchActor, 0, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 1, Void >, public ActorCallback< WorkerAvailabilityWatchActor, 2, Void >, public FastAllocated<WorkerAvailabilityWatchActor>, public WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor> {
															#line 4789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<WorkerAvailabilityWatchActor>::operator new;
	using FastAllocated<WorkerAvailabilityWatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15457967308880993536UL, 8831346043081841664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerAvailabilityWatchActor, 0, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 1, Void >;
friend struct ActorCallback< WorkerAvailabilityWatchActor, 2, Void >;
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerAvailabilityWatchActor(WorkerInterface const& worker,ProcessClass const& startingClass,ClusterControllerData* const& cluster) 
															#line 4808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerAvailabilityWatchActorState<WorkerAvailabilityWatchActor>(worker, startingClass, cluster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10692884594389689856UL, 3271400941493304320UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerAvailabilityWatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerAvailabilityWatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerAvailabilityWatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerAvailabilityWatchActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> workerAvailabilityWatch( WorkerInterface const& worker, ProcessClass const& startingClass, ClusterControllerData* const& cluster ) {
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new WorkerAvailabilityWatchActor(worker, startingClass, cluster));
															#line 4842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 850 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

struct FailureStatusInfo {
	FailureStatus status;
	double lastRequestTime;
	double penultimateRequestTime;

	FailureStatusInfo() : lastRequestTime(0), penultimateRequestTime(0) {}

	void insertRequest(double now) {
		penultimateRequestTime = lastRequestTime;
		lastRequestTime = now;
	}

	double latency(double now) const {
		return std::max(now - lastRequestTime, lastRequestTime - penultimateRequestTime);
	}
};

															#line 4864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via requireAll()
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RequireAllActor>
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActorState {
															#line 4871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActorState(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : in(in),
															#line 869 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   out(),
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   i()
															#line 4882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("requireAll", reinterpret_cast<unsigned long>(this));

	}
	~RequireAllActorState() 
	{
		fdb_probe_actor_destroy("requireAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			i = 0;
															#line 4897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RequireAllActor*>(this)->SAV<std::vector<TLogInterface>>::futures) { (void)(out); this->~RequireAllActorState(); static_cast<RequireAllActor*>(this)->destroy(); return 0; }
															#line 4920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RequireAllActor*>(this)->SAV< std::vector<TLogInterface> >::value()) std::vector<TLogInterface>(std::move(out)); // state_var_RVO
		this->~RequireAllActorState();
		static_cast<RequireAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(i < in.size()))
															#line 4939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Optional<std::vector<TLogInterface>>> __when_expr_0 = in[i];
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<RequireAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RequireAllActor*>(this)->actor_wait_state = 1;
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*>(static_cast<RequireAllActor*>(this)));
															#line 4952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 4974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 4978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 4984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!x.present())
															#line 4993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(recruitment_failed(), std::max(0, loopDepth - 1));
															#line 4997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		out.insert(out.end(), x.get().begin(), x.get().end());
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		i++;
															#line 5003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> const& x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(x, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<TLogInterface>> && x,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(x), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequireAllActor*>(this)->actor_wait_state > 0) static_cast<RequireAllActor*>(this)->actor_wait_state = 0;
		static_cast<RequireAllActor*>(this)->ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >::remove();

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> const& value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Optional<std::vector<TLogInterface>> && value) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*,Error err) 
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<Future<Optional<std::vector<TLogInterface>>>> in;
															#line 869 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<TLogInterface> out;
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int i;
															#line 5089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via requireAll()
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RequireAllActor final : public Actor<std::vector<TLogInterface>>, public ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >, public FastAllocated<RequireAllActor>, public RequireAllActorState<RequireAllActor> {
															#line 5094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<RequireAllActor>::operator new;
	using FastAllocated<RequireAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15637375376612894976UL, 17972536732225404928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<TLogInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RequireAllActor(std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in) 
															#line 5111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<std::vector<TLogInterface>>(),
		   RequireAllActorState<RequireAllActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("requireAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16593527381228025088UL, 9468838150300793600UL);
		ActorExecutionContextHelper __helper(static_cast<RequireAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("requireAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("requireAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequireAllActor, 0, Optional<std::vector<TLogInterface>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<std::vector<TLogInterface>> requireAll( std::vector<Future<Optional<std::vector<TLogInterface>>>> const& in ) {
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<std::vector<TLogInterface>>(new RequireAllActor(in));
															#line 5144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 879 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

void clusterRecruitStorage(ClusterControllerData* self, RecruitStorageRequest req) {
	try {
		if (!self->gotProcessClasses && !req.criticalRecruitment)
			throw no_more_servers();
		auto worker = self->getStorageWorker(req);
		RecruitStorageReply rep;
		rep.worker = worker.interf;
		rep.processClass = worker.processClass;
		req.reply.send(rep);
	} catch (Error& e) {
		if (e.code() == error_code_no_more_servers) {
			self->outstandingStorageRequests.emplace_back(req, now() + SERVER_KNOBS->RECRUITMENT_TIMEOUT);
			TraceEvent(SevWarn, "RecruitStorageNotAvailable", self->id)
			    .error(e)
			    .detail("IsCriticalRecruitment", req.criticalRecruitment);
		} else {
			TraceEvent(SevError, "RecruitStorageError", self->id).error(e);
			throw; // Any other error will bring down the cluster controller
		}
	}
}

void clusterRegisterMaster(ClusterControllerData* self, RegisterMasterRequest const& req) {
	req.reply.send(Void());

	TraceEvent("MasterRegistrationReceived", self->id)
	    .detail("MasterId", req.id)
	    .detail("Master", req.mi.toString())
	    .detail("Tlogs", describe(req.logSystemConfig.tLogs))
	    .detail("Resolvers", req.resolvers.size())
	    .detail("RecoveryState", (int)req.recoveryState)
	    .detail("RegistrationCount", req.registrationCount)
	    .detail("CommitProxies", req.commitProxies.size())
	    .detail("GrvProxies", req.grvProxies.size())
	    .detail("RecoveryCount", req.recoveryCount)
	    .detail("Stalled", req.recoveryStalled)
	    .detail("OldestBackupEpoch", req.logSystemConfig.oldestBackupEpoch);

	// make sure the request comes from an active database
	auto db = &self->db;
	if (db->serverInfo->get().master.id() != req.id || req.registrationCount <= db->masterRegistrationCount) {
		TraceEvent("MasterRegistrationNotFound", self->id)
		    .detail("MasterId", req.id)
		    .detail("ExistingId", db->serverInfo->get().master.id())
		    .detail("RegCount", req.registrationCount)
		    .detail("ExistingRegCount", db->masterRegistrationCount);
		return;
	}

	if (req.recoveryState == RecoveryState::FULLY_RECOVERED) {
		self->db.unfinishedRecoveries = 0;
		ASSERT(!req.logSystemConfig.oldTLogs.size());
	}

	db->masterRegistrationCount = req.registrationCount;
	db->recoveryStalled = req.recoveryStalled;
	if (req.configuration.present()) {
		db->config = req.configuration.get();

		if (req.recoveryState >= RecoveryState::ACCEPTING_COMMITS) {
			self->gotFullyRecoveredConfig = true;
			db->fullyRecoveredConfig = req.configuration.get();
			for (auto& it : self->id_worker) {
				bool isExcludedFromConfig = db->fullyRecoveredConfig.isExcludedServer(
				    it.second.details.interf.addresses(), it.second.details.interf.locality);
				if (it.second.priorityInfo.isExcluded != isExcludedFromConfig) {
					it.second.priorityInfo.isExcluded = isExcludedFromConfig;
					if (!it.second.reply.isSet()) {
						it.second.reply.send(
						    RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
					}
				}
			}
		}
	}

	bool isChanged = false;
	auto dbInfo = self->db.serverInfo->get();

	if (dbInfo.recoveryState != req.recoveryState) {
		dbInfo.recoveryState = req.recoveryState;
		isChanged = true;
	}

	if (dbInfo.priorCommittedLogServers != req.priorCommittedLogServers) {
		dbInfo.priorCommittedLogServers = req.priorCommittedLogServers;
		isChanged = true;
	}

	// Construct the client information
	if (db->clientInfo->get().commitProxies != req.commitProxies ||
	    db->clientInfo->get().grvProxies != req.grvProxies ||
	    db->clientInfo->get().tenantMode != db->config.tenantMode ||
	    db->clientInfo->get().clusterId != db->serverInfo->get().client.clusterId ||
	    db->clientInfo->get().clusterType != db->clusterType ||
	    db->clientInfo->get().metaclusterName != db->metaclusterName) {
		TraceEvent("PublishNewClientInfo", self->id)
		    .detail("Master", dbInfo.master.id())
		    .detail("GrvProxies", db->clientInfo->get().grvProxies)
		    .detail("ReqGrvProxies", req.grvProxies)
		    .detail("CommitProxies", db->clientInfo->get().commitProxies)
		    .detail("GlobalConfigHistorySize", db->clientInfo->get().history.size())
		    .detail("ReqCPs", req.commitProxies)
		    .detail("TenantMode", db->clientInfo->get().tenantMode.toString())
		    .detail("ReqTenantMode", db->config.tenantMode.toString())
		    .detail("ClusterId", db->serverInfo->get().client.clusterId)
		    .detail("ClientClusterId", db->clientInfo->get().clusterId)
		    .detail("ClusterType", db->clientInfo->get().clusterType)
		    .detail("ReqClusterType", db->clusterType)
		    .detail("MetaclusterName", db->clientInfo->get().metaclusterName)
		    .detail("ReqMetaclusterName", db->metaclusterName);
		isChanged = true;
		// TODO why construct a new one and not just copy the old one and change proxies + id?
		ClientDBInfo clientInfo;
		clientInfo.encryptKeyProxy = db->serverInfo->get().client.encryptKeyProxy;
		clientInfo.id = deterministicRandom()->randomUniqueID();
		clientInfo.commitProxies = req.commitProxies;
		clientInfo.grvProxies = req.grvProxies;
		clientInfo.history = db->clientInfo->get().history;
		clientInfo.tenantMode = TenantAPI::tenantModeForClusterType(db->clusterType, db->config.tenantMode);
		clientInfo.clusterId = db->serverInfo->get().client.clusterId;
		clientInfo.clusterType = db->clusterType;
		clientInfo.metaclusterName = db->metaclusterName;
		db->clientInfo->set(clientInfo);
		dbInfo.client = db->clientInfo->get();
	}

	if (!dbInfo.logSystemConfig.isEqual(req.logSystemConfig)) {
		isChanged = true;
		dbInfo.logSystemConfig = req.logSystemConfig;
	}

	if (dbInfo.resolvers != req.resolvers) {
		isChanged = true;
		dbInfo.resolvers = req.resolvers;
	}

	if (dbInfo.recoveryCount != req.recoveryCount) {
		isChanged = true;
		dbInfo.recoveryCount = req.recoveryCount;
	}

	if (isChanged) {
		dbInfo.id = deterministicRandom()->randomUniqueID();
		dbInfo.infoGeneration = ++self->db.dbInfoCount;
		self->db.serverInfo->set(dbInfo);
	}

	checkOutstandingRequests(self);
}

// Halts the registering (i.e. requesting) singleton if one is already in the process of being recruited
// or, halts the existing singleton in favour of the requesting one
template <class SingletonClass>
void haltRegisteringOrCurrentSingleton(ClusterControllerData* self,
                                       const WorkerInterface& worker,
                                       const SingletonClass& currSingleton,
                                       const SingletonClass& registeringSingleton,
                                       const Optional<UID> recruitingID) {
	ASSERT(currSingleton.getRole() == registeringSingleton.getRole());
	const UID registeringID = registeringSingleton.getInterface().id();
	const std::string roleName = currSingleton.getRole().roleName;
	const std::string roleAbbr = currSingleton.getRole().abbreviation;

	// halt the requesting singleton if it isn't the one currently being recruited
	if ((recruitingID.present() && recruitingID.get() != registeringID) ||
	    self->clusterControllerDcId != worker.locality.dcId()) {
		TraceEvent(("CCHaltRegistering" + roleName).c_str(), self->id)
		    .detail(roleAbbr + "ID", registeringID)
		    .detail("DcID", printable(self->clusterControllerDcId))
		    .detail("ReqDcID", printable(worker.locality.dcId()))
		    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
		registeringSingleton.halt(*self, worker.locality.processId());
	} else if (!recruitingID.present()) {
		// if not currently recruiting, then halt previous one in favour of requesting one
		TraceEvent(("CCRegister" + roleName).c_str(), self->id).detail(roleAbbr + "ID", registeringID);
		if (currSingleton.isPresent() && currSingleton.getInterface().id() != registeringID &&
		    self->id_worker.contains(currSingleton.getInterface().locality.processId())) {
			TraceEvent(("CCHaltPrevious" + roleName).c_str(), self->id)
			    .detail(roleAbbr + "ID", currSingleton.getInterface().id())
			    .detail("DcID", printable(self->clusterControllerDcId))
			    .detail("ReqDcID", printable(worker.locality.dcId()))
			    .detail("Recruiting" + roleAbbr + "ID", recruitingID.present() ? recruitingID.get() : UID());
			currSingleton.halt(*self, currSingleton.getInterface().locality.processId());
		}
		// set the curr singleton if it doesn't exist or its different from the requesting one
		if (!currSingleton.isPresent() || currSingleton.getInterface().id() != registeringID) {
			registeringSingleton.setInterfaceToDbInfo(*self);
		}
	}
}

															#line 5341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via registerWorker()
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class RegisterWorkerActor>
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActorState {
															#line 5348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActorState(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : req(req),
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   cs(cs),
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster)
															#line 5361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerActorState() 
	{
		fdb_probe_actor_destroy("registerWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = cs.tryResolveHostnames();
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 1;
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*>(static_cast<RegisterWorkerActor*>(this)));
															#line 5383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1079 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 5408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1087 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 5416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 5436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 5450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 5456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 5460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 5464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1136 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1137 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 5491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
															#line 1153 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1155 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 5520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1158 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 5526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 5530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 5536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 5540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 5544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 5548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1186 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 5565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 5569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1195 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1196 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 5577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 5581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 5586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1202 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 5590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1204 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 5594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 5598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 5606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1215 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 5616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 5620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1218 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1221 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1222 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1223 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1225 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1227 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 5640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1233 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 5650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1236 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 5654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1237 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1238 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 5660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1240 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 5664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 5668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1247 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 5672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 5678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 5683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1257 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 5691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1262 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 5695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1265 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 5703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 5707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1270 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1272 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 5715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1276 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 5719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 5727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1284 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 5731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1285 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 5735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1288 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 5739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const WorkerInterface& w = req.wi;
															#line 1079 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.clusterId.present() && self->clusterId->get().present() && req.clusterId != self->clusterId->get() && req.processClass != ProcessClass::TesterClass)
															#line 5753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "WorkerBelongsToExistingCluster", self->id) .detail("WorkerClusterId", req.clusterId) .detail("ClusterControllerClusterId", self->clusterId->get()) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId());
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(invalid_cluster_id());
															#line 1087 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 5761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RegisterWorkerActorState();
			static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ProcessClass newProcessClass = req.processClass;
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto info = self->id_worker.find(w.locality.processId());
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ClusterControllerPriorityInfo newPriorityInfo = req.priorityInfo;
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool isCoordinator = (std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.address()) != coordinatorAddresses.end()) || (w.secondaryAddress().present() && std::find(coordinatorAddresses.begin(), coordinatorAddresses.end(), w.secondaryAddress().get()) != coordinatorAddresses.end());
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : req.incompatiblePeers ) {
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->db.incompatibleConnections[it] = now() + SERVER_KNOBS->INCOMPATIBLE_PEERS_LOGGING_INTERVAL;
															#line 5781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->removedDBInfoEndpoints.erase(w.updateServerDBInfo.getEndpoint());
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerActualWorkers", self->id) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->goodRemoteRecruitmentTime = lowPriorityDelay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 5795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("ClusterControllerWorkerAlreadyRegistered", self->id) .suppressFor(1.0) .detail("WorkerId", w.id()) .detail("ProcessId", w.locality.processId()) .detail("ZoneId", w.locality.zoneId()) .detail("DataHall", w.locality.dataHallId()) .detail("PClass", req.processClass.toString()) .detail("Workers", self->id_worker.size()) .detail("Degraded", req.degraded) .detail("RecoveredDiskFiles", req.recoveredDiskFiles);
															#line 5801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (w.address() == g_network->getLocalAddress())
															#line 5805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->changingDcIds.get().first)
															#line 5809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1136 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1137 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changingDcIds.get().first)
															#line 5836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changingDcIds.get().second.present())
															#line 5840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changingDcIds.get().second.get());
															#line 5844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
			else
			{
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (self->changedDcIds.get().second.present())
															#line 5851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newPriorityInfo.dcFitness = ClusterControllerPriorityInfo::calculateDCFitness( w.locality.dcId(), self->changedDcIds.get().second.get());
															#line 5855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
		}
															#line 1153 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end() || info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1155 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotProcessClasses)
															#line 5865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.locality.processId());
															#line 1158 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || req.initialClass.classType() == ProcessClass::UnsetClass))
															#line 5871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 5875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = req.initialClass;
															#line 5881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 5885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1167 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->gotFullyRecoveredConfig)
															#line 5889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				newPriorityInfo.isExcluded = self->db.fullyRecoveredConfig.isExcludedServer(w.addresses(), w.locality);
															#line 5893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (info == self->id_worker.end())
															#line 5898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_worker[w.locality.processId()] = WorkerInfo(workerAvailabilityWatch(w, newProcessClass, self), req.reply, req.generation, w, req.initialClass, newProcessClass, newPriorityInfo, req.degraded, req.recoveredDiskFiles, req.issues);
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->CC_ONLY_CONSIDER_INTRA_DC_LATENCY)
															#line 5904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1186 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				const bool addrDcChanged = self->addr_locality.contains(w.address()) && self->addr_locality[w.address()].dcId() != w.locality.dcId();
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (addrDcChanged)
															#line 5910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					TraceEvent(SevWarn, "AddrDcChanged") .detail("Addr", w.address()) .detail("ExistingLocality", self->addr_locality[w.address()].toString()) .detail("NewLocality", w.locality.toString());
															#line 5914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT_WE_THINK(!addrDcChanged);
															#line 1195 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addr_locality[w.address()] = w.locality;
															#line 1196 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (w.secondaryAddress().present())
															#line 5922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addr_locality[w.secondaryAddress().get()] = w.locality;
															#line 5926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
			}
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->masterProcessId.present() && w.locality.processId() == self->db.serverInfo->get().master.locality.processId())
															#line 5931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1202 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->masterProcessId = w.locality.processId();
															#line 5935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1204 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 5939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), self->id_worker[w.locality.processId()].watcher, isCoordinator));
															#line 5943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->updateDBInfo.trigger();
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 5951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (info->second.details.interf.id() != w.id() || req.generation >= info->second.gen)
															#line 5957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1215 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!info->second.reply.isSet())
															#line 5961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1216 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.reply.send(Never());
															#line 5965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1218 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.reply = req.reply;
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.processClass = newProcessClass;
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.priorityInfo = newPriorityInfo;
															#line 1221 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.initialClass = req.initialClass;
															#line 1222 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.degraded = req.degraded;
															#line 1223 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.details.recoveredDiskFiles = req.recoveredDiskFiles;
															#line 1224 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.gen = req.generation;
															#line 1225 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				info->second.issues = req.issues;
															#line 1227 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (info->second.details.interf.id() != w.id())
															#line 5985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->removedDBInfoEndpoints.insert(info->second.details.interf.updateServerDBInfo.getEndpoint());
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.details.interf = w;
															#line 1233 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher.cancel();
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					info->second.watcher = workerAvailabilityWatch(w, newProcessClass, self);
															#line 5995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1236 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (req.requestDbInfo)
															#line 5999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1237 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfoEndpoints.insert(w.updateServerDBInfo.getEndpoint());
															#line 1238 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->updateDBInfo.trigger();
															#line 6005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1240 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (configBroadcaster != nullptr && req.lastSeenKnobVersion.present() && req.knobConfigClassSet.present())
															#line 6009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					self->addActor.send(configBroadcaster->registerNode(req.configBroadcastInterface, req.lastSeenKnobVersion.get(), req.knobConfigClassSet.get(), info->second.watcher, isCoordinator));
															#line 6013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1247 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 6017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				CODE_PROBE(true, "Received an old worker registration request.", probe::decoration::rare);
															#line 6023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.distributorInterf.present())
															#line 6028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = DataDistributorSingleton(self->db.serverInfo->get().distributor);
															#line 1257 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = DataDistributorSingleton(req.distributorInterf);
															#line 1258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<DataDistributorSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingDistributorID);
															#line 6036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1262 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.ratekeeperInterf.present())
															#line 6040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = RatekeeperSingleton(self->db.serverInfo->get().ratekeeper);
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = RatekeeperSingleton(req.ratekeeperInterf);
															#line 1265 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<RatekeeperSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingRatekeeperID);
															#line 6048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1269 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.config.encryptionAtRestMode.isEncryptionEnabled() && req.encryptKeyProxyInterf.present())
															#line 6052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1270 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = EncryptKeyProxySingleton(self->db.serverInfo->get().client.encryptKeyProxy);
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = EncryptKeyProxySingleton(req.encryptKeyProxyInterf);
															#line 1272 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<EncryptKeyProxySingleton>( self, w, currSingleton, registeringSingleton, self->recruitingEncryptKeyProxyID);
															#line 6060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1276 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.consistencyScanInterf.present())
															#line 6064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto currSingleton = ConsistencyScanSingleton(self->db.serverInfo->get().consistencyScan);
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto registeringSingleton = ConsistencyScanSingleton(req.consistencyScanInterf);
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			haltRegisteringOrCurrentSingleton<ConsistencyScanSingleton>( self, w, currSingleton, registeringSingleton, self->recruitingConsistencyScanID);
															#line 6072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1284 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!req.reply.isSet() && newPriorityInfo != req.priorityInfo)
															#line 6076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1285 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.send(RegisterWorkerReply(newProcessClass, newPriorityInfo));
															#line 6080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1288 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<RegisterWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterWorkerActorState(); static_cast<RegisterWorkerActor*>(this)->destroy(); return 0; }
															#line 6084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<RegisterWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterWorkerActorState();
		static_cast<RegisterWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> const& coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(coordinatorAddresses, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<NetworkAddress> && coordinatorAddresses,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(coordinatorAddresses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerActor*>(this)->ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerRequest req;
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterConnectionString cs;
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster* configBroadcaster;
															#line 6175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via registerWorker()
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class RegisterWorkerActor final : public Actor<Void>, public ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >, public FastAllocated<RegisterWorkerActor>, public RegisterWorkerActorState<RegisterWorkerActor> {
															#line 6180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<RegisterWorkerActor>::operator new;
	using FastAllocated<RegisterWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11958722248462926080UL, 9229998790604983552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >;
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RegisterWorkerActor(RegisterWorkerRequest const& req,ClusterControllerData* const& self,ClusterConnectionString const& cs,ConfigBroadcaster* const& configBroadcaster) 
															#line 6197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterWorkerActorState<RegisterWorkerActor>(req, self, cs, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14446594949420451840UL, 3262990831982615808UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> registerWorker( RegisterWorkerRequest const& req, ClusterControllerData* const& self, ClusterConnectionString const& cs, ConfigBroadcaster* const& configBroadcaster ) {
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new RegisterWorkerActor(req, self, cs, configBroadcaster));
															#line 6230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1290 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

#define TIME_KEEPER_VERSION "1"_sr

															#line 6237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperSetVersionActor>
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActorState {
															#line 6244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActorState(ClusterControllerData* const& self) 
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1294 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx))
															#line 6253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperSetVersionActorState() 
	{
		fdb_probe_actor_destroy("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 6268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1308 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TimeKeeperSetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TimeKeeperSetVersionActorState(); static_cast<TimeKeeperSetVersionActor*>(this)->destroy(); return 0; }
															#line 6291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<TimeKeeperSetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TimeKeeperSetVersionActorState();
		static_cast<TimeKeeperSetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1297 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1299 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->set(timeKeeperVersionKey, TIME_KEEPER_VERSION);
															#line 1301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 1301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 1;
															#line 1301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 0, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 6326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1304 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 1304 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 2;
															#line 1304 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperSetVersionActor, 1, Void >*>(static_cast<TimeKeeperSetVersionActor*>(this)));
															#line 6368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperSetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperSetVersionActor*>(this)->ActorCallback< TimeKeeperSetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperSetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1294 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 6557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via timeKeeperSetVersion()
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperSetVersionActor final : public Actor<Void>, public ActorCallback< TimeKeeperSetVersionActor, 0, Void >, public ActorCallback< TimeKeeperSetVersionActor, 1, Void >, public FastAllocated<TimeKeeperSetVersionActor>, public TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor> {
															#line 6562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<TimeKeeperSetVersionActor>::operator new;
	using FastAllocated<TimeKeeperSetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8169394747095609600UL, 13687415134486455808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperSetVersionActor, 0, Void >;
friend struct ActorCallback< TimeKeeperSetVersionActor, 1, Void >;
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperSetVersionActor(ClusterControllerData* const& self) 
															#line 6580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   TimeKeeperSetVersionActorState<TimeKeeperSetVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15389618584066260224UL, 624794717111917056UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperSetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeperSetVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeperSetVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperSetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeperSetVersion( ClusterControllerData* const& self ) {
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperSetVersionActor(self));
															#line 6614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1310 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// This actor periodically gets read version and writes it to cluster with current timestamp as key. To avoid
// running out of space, it limits the max number of entries and clears old entries on each update. This mapping is
// used from backup and restore to get the version information for a timestamp.
															#line 6622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via timeKeeper()
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TimeKeeperActor>
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActorState {
															#line 6629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActorState(ClusterControllerData* const& self) 
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   versionMap(timeKeeperPrefixRange.begin)
															#line 6638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	~TimeKeeperActorState() 
	{
		fdb_probe_actor_destroy("timeKeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1317 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperStarted").log();
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeKeeperSetVersion(self);
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 1;
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 0, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TimeKeeperActorState();
		static_cast<TimeKeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1322 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(self->cx);
															#line 1323 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 6787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->TIME_KEEPER_DELAY);
															#line 1359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 5;
															#line 1359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 4, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1325 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			debugID = deterministicRandom()->randomUniqueID();
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!g_network->isSimulated())
															#line 6822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1330 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				tr->debugTransaction(debugID);
															#line 6826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1333 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1334 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(timeKeeperDisableKey);
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 2;
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 1, Optional<Value> >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TimeKeeperActor*>(this)->actor_wait_state = 4;
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 3, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> const& disableValue,int loopDepth) 
	{
															#line 1337 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 6900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1342 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1344 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 6912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1345 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 6916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 6922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 6926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Optional<Value> && disableValue,int loopDepth) 
	{
															#line 1337 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (disableValue.present())
															#line 6946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Version v = tr->getReadVersion().get();
															#line 1342 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t currentTime = (int64_t)now();
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		versionMap.set(tr, currentTime, v);
															#line 1344 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!g_network->isSimulated())
															#line 6958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1345 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("TimeKeeperCommit", debugID).detail("Version", v);
															#line 6962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		int64_t ttl = currentTime - SERVER_KNOBS->TIME_KEEPER_DELAY * SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES;
															#line 1348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ttl > 0)
															#line 6968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionMap.erase(tr, 0, ttl);
															#line 6972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TimeKeeperActor*>(this)->actor_wait_state = 3;
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TimeKeeperActor, 2, Void >*>(static_cast<TimeKeeperActor*>(this)));
															#line 6983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> const& disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(disableValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Optional<Value> && disableValue,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(disableValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TimeKeeperActor*>(this)->actor_wait_state > 0) static_cast<TimeKeeperActor*>(this)->actor_wait_state = 0;
		static_cast<TimeKeeperActor*>(this)->ActorCallback< TimeKeeperActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TimeKeeperActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TimeKeeperActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1315 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedMap<int64_t, Version> versionMap;
															#line 1322 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1325 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID debugID;
															#line 7332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via timeKeeper()
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TimeKeeperActor final : public Actor<Void>, public ActorCallback< TimeKeeperActor, 0, Void >, public ActorCallback< TimeKeeperActor, 1, Optional<Value> >, public ActorCallback< TimeKeeperActor, 2, Void >, public ActorCallback< TimeKeeperActor, 3, Void >, public ActorCallback< TimeKeeperActor, 4, Void >, public FastAllocated<TimeKeeperActor>, public TimeKeeperActorState<TimeKeeperActor> {
															#line 7337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<TimeKeeperActor>::operator new;
	using FastAllocated<TimeKeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18212932477988292096UL, 5389386320947358720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TimeKeeperActor, 0, Void >;
friend struct ActorCallback< TimeKeeperActor, 1, Optional<Value> >;
friend struct ActorCallback< TimeKeeperActor, 2, Void >;
friend struct ActorCallback< TimeKeeperActor, 3, Void >;
friend struct ActorCallback< TimeKeeperActor, 4, Void >;
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TimeKeeperActor(ClusterControllerData* const& self) 
															#line 7358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   TimeKeeperActorState<TimeKeeperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("timeKeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10218480498489324032UL, 15738055826982653184UL);
		ActorExecutionContextHelper __helper(static_cast<TimeKeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("timeKeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("timeKeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TimeKeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TimeKeeperActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TimeKeeperActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TimeKeeperActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TimeKeeperActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> timeKeeper( ClusterControllerData* const& self ) {
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TimeKeeperActor(self));
															#line 7395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1362 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 7400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via statusServer()
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StatusServerActor>
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActorState {
															#line 7407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActorState(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : requests(requests),
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   self(self),
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   coordinators(coordinators),
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   configBroadcaster(configBroadcaster),
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   last_request_time(0.0),
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   requests_batch()
															#line 7424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("statusServer", reinterpret_cast<unsigned long>(this));

	}
	~StatusServerActorState() 
	{
		fdb_probe_actor_destroy("statusServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 7439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusServerActorState();
		static_cast<StatusServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto __when_expr_0 = requests;
															#line 7470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<StatusRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<StatusRequest>>::value, "invalid type");
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<StatusServerActor*>(this)->actor_wait_state = 1;
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< StatusServerActor, 0, StatusRequest >*>(static_cast<StatusServerActor*>(this)));
															#line 7479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1467 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevError, "StatusServerError").error(e);
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest const& req,int loopDepth) 
	{
															#line 1377 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1384 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 7532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StatusRequest && req,int loopDepth) 
	{
															#line 1377 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		++self->statusRequests;
															#line 1378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.push_back(req);
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double next_allowed_request_time = last_request_time + SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS;
															#line 1384 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		double minwait = std::max(next_allowed_request_time - now(), 0.0);
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(minwait);
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 2;
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 1, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 7556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StatusRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorSingleCallback< StatusServerActor, 0, StatusRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,StatusRequest && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< StatusServerActor, 0, StatusRequest >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 7644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 7650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1401 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 7656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1406 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1407 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1409 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1410 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1411 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 7669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 7673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1416 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1417 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 7682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 7686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1422 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 7694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->db.metaclusterRegistration, self->db.metaclusterMetrics, self->excludedDegradedServers));
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 7706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(;requests.isReady();) {
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto req = requests.pop();
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS > 0.0 && requests_batch.size() + 1 > SERVER_KNOBS->STATUS_MIN_TIME_BETWEEN_REQUESTS * SERVER_KNOBS->MAX_STATUS_REQUESTS_PER_SECOND)
															#line 7719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarnAlways, "TooManyStatusRequests") .suppressFor(1.0) .detail("BatchSize", requests_batch.size());
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				req.reply.sendError(server_overloaded());
															#line 7725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1401 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.push_back(req);
															#line 7731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1406 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<WorkerDetails> workers;
															#line 1407 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<ProcessIssues> workerIssues;
															#line 1409 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1410 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			workers.push_back(it.second.details);
															#line 1411 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it.second.issues.size())
															#line 7744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				workerIssues.emplace_back(it.second.details.interf.address(), it.second.issues);
															#line 7748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1416 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::vector<NetworkAddress> incompatibleConnections;
															#line 1417 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for(auto it = self->db.incompatibleConnections.begin();it != self->db.incompatibleConnections.end();) {
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (it->second < now())
															#line 7757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it = self->db.incompatibleConnections.erase(it);
															#line 7761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				incompatibleConnections.push_back(it->first);
															#line 1422 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				it++;
															#line 7769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<StatusReply>> __when_expr_2 = errorOr(clusterGetStatus(self->db.serverInfo, self->cx, workers, workerIssues, self->storageStatusInfos, &self->db.clientStatus, coordinators, incompatibleConnections, self->datacenterVersionDifference, self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference, configBroadcaster, self->db.metaclusterRegistration, self->db.metaclusterMetrics, self->excludedDegradedServers));
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 3;
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*>(static_cast<StatusServerActor*>(this)));
															#line 7781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1442 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError() && result.getError().code() == error_code_actor_cancelled)
															#line 7865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			return a_body1loopBody1Catch1(result.getError(), loopDepth);
															#line 7869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1447 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		last_request_time = now();
															#line 1449 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus = Optional<StatusReply>();
															#line 1450 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 7877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> const& __result,int loopDepth) 
	{
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		result = __result;
															#line 7886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(ErrorOr<StatusReply> && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,ErrorOr<StatusReply> && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		faultToleranceRelatedStatus.reset();
															#line 7965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 1450 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!requests_batch.empty()))
															#line 7981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1451 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (result.isError())
															#line 7987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1452 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			requests_batch.back().reply.sendError(result.getError());
															#line 7991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (requests_batch.back().statusField.empty())
															#line 7997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1454 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(result.get());
															#line 8001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1456 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(requests_batch.back().statusField == "fault_tolerance");
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!faultToleranceRelatedStatus.present())
															#line 8009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					faultToleranceRelatedStatus = clusterGetFaultToleranceStatus(result.get().statusStr);
															#line 8013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				requests_batch.back().reply.send(faultToleranceRelatedStatus.get());
															#line 8017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1462 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		requests_batch.pop_back();
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StatusServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StatusServerActor*>(this)->actor_wait_state = 4;
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusServerActor, 3, Void >*>(static_cast<StatusServerActor*>(this)));
															#line 8031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusServerActor*>(this)->actor_wait_state > 0) static_cast<StatusServerActor*>(this)->actor_wait_state = 0;
		static_cast<StatusServerActor*>(this)->ActorCallback< StatusServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	FutureStream<StatusRequest> requests;
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ServerCoordinators coordinators;
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ConfigBroadcaster const* configBroadcaster;
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double last_request_time;
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StatusRequest> requests_batch;
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ErrorOr<StatusReply> result;
															#line 1449 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<StatusReply> faultToleranceRelatedStatus;
															#line 8165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via statusServer()
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StatusServerActor final : public Actor<Void>, public ActorSingleCallback< StatusServerActor, 0, StatusRequest >, public ActorCallback< StatusServerActor, 1, Void >, public ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >, public ActorCallback< StatusServerActor, 3, Void >, public FastAllocated<StatusServerActor>, public StatusServerActorState<StatusServerActor> {
															#line 8170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<StatusServerActor>::operator new;
	using FastAllocated<StatusServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4760924598070621696UL, 9776270243930954240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< StatusServerActor, 0, StatusRequest >;
friend struct ActorCallback< StatusServerActor, 1, Void >;
friend struct ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >;
friend struct ActorCallback< StatusServerActor, 3, Void >;
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StatusServerActor(FutureStream<StatusRequest> const& requests,ClusterControllerData* const& self,ServerCoordinators const& coordinators,ConfigBroadcaster const* const& configBroadcaster) 
															#line 8190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   StatusServerActorState<StatusServerActor>(requests, self, coordinators, configBroadcaster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7571137253636277504UL, 14171083556526699776UL);
		ActorExecutionContextHelper __helper(static_cast<StatusServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< StatusServerActor, 0, StatusRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusServerActor, 2, ErrorOr<StatusReply> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> statusServer( FutureStream<StatusRequest> const& requests, ClusterControllerData* const& self, ServerCoordinators const& coordinators, ConfigBroadcaster const* const& configBroadcaster ) {
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StatusServerActor(requests, self, coordinators, configBroadcaster));
															#line 8226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1472 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 8231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorProcessClasses()
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorProcessClassesActor>
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActorState {
															#line 8238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActorState(ClusterControllerData* const& self) 
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1475 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   trVer(self->db.db)
															#line 8247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	~MonitorProcessClassesActorState() 
	{
		fdb_probe_actor_destroy("monitorProcessClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1476 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 8262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorProcessClassesActorState();
		static_cast<MonitorProcessClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1478 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = trVer.get(processClassVersionKey);
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 1;
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = trVer.onError(e);
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 4;
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 3, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 1483 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 8370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 1483 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (val.present())
															#line 8392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = trVer.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 2;
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1487 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1491 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1492 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 8499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && processClasses,int loopDepth) 
	{
															#line 1487 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.clear(processClassKeys);
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		trVer.set(processClassVersionKey, processClassVersionValue);
															#line 1491 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto it : processClasses ) {
															#line 1492 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			UID processUid = decodeProcessClassKeyOld(it.key);
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			trVer.set(processClassKeyFor(processUid.toString()), it.value);
															#line 8529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = trVer.commit();
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 3;
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 2, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1497 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 8624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1497 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ProcessClassUpgrade").log();
															#line 8633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(self->db.db);
															#line 1507 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 8813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1510 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1511 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_4 = tr.getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1511 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 5;
															#line 1511 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 8;
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 7, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult const& processClasses,int loopDepth) 
	{
															#line 1512 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1514 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 8906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1516 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1518 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1519 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 8918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1522 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1523 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1524 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1526 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 8928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1529 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 8932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1531 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 8938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1534 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 8942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1535 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1536 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 8950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 8954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 8964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 8977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(RangeResult && processClasses,int loopDepth) 
	{
															#line 1512 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!processClasses.more && processClasses.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1514 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (processClasses != self->lastProcessClasses || !self->gotProcessClasses)
															#line 8988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->id_class.clear();
															#line 1516 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for(int i = 0;i < processClasses.size();i++) {
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto c = decodeProcessClassValue(processClasses[i].value);
															#line 1518 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ASSERT(c.classSource() != ProcessClass::CommandLineSource);
															#line 1519 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->id_class[decodeProcessClassKey(processClasses[i].key)] = c;
															#line 9000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1522 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& w : self->id_worker ) {
															#line 1523 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto classIter = self->id_class.find(w.first);
															#line 1524 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ProcessClass newProcessClass;
															#line 1526 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (classIter != self->id_class.end() && (classIter->second.classSource() == ProcessClass::DBSource || w.second.initialClass.classType() == ProcessClass::UnsetClass))
															#line 9010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1529 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = classIter->second;
															#line 9014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
				else
				{
															#line 1531 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					newProcessClass = w.second.initialClass;
															#line 9020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
															#line 1534 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (newProcessClass != w.second.details.processClass)
															#line 9024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1535 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.details.processClass = newProcessClass;
															#line 1536 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					w.second.priorityInfo.processClassFitness = newProcessClass.machineClassFitness(ProcessClass::ClusterController);
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!w.second.reply.isSet())
															#line 9032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						w.second.reply.send( RegisterWorkerReply(w.second.details.processClass, w.second.priorityInfo));
															#line 9036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->lastProcessClasses = processClasses;
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->gotProcessClasses = true;
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 9046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr.watch(processClassChangeKey);
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = tr.commit();
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 6;
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 5, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult const& processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(processClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult && processClasses,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(processClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_6 = watchFuture;
															#line 1552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 7;
															#line 1552 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MonitorProcessClassesActor, 6, Void >*>(static_cast<MonitorProcessClassesActor*>(this)));
															#line 9166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state > 0) static_cast<MonitorProcessClassesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProcessClassesActor*>(this)->ActorCallback< MonitorProcessClassesActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< MonitorProcessClassesActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1475 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction trVer;
															#line 1505 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 9428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorProcessClasses()
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorProcessClassesActor final : public Actor<Void>, public ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >, public ActorCallback< MonitorProcessClassesActor, 1, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 2, Void >, public ActorCallback< MonitorProcessClassesActor, 3, Void >, public ActorCallback< MonitorProcessClassesActor, 4, RangeResult >, public ActorCallback< MonitorProcessClassesActor, 5, Void >, public ActorCallback< MonitorProcessClassesActor, 6, Void >, public ActorCallback< MonitorProcessClassesActor, 7, Void >, public FastAllocated<MonitorProcessClassesActor>, public MonitorProcessClassesActorState<MonitorProcessClassesActor> {
															#line 9433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorProcessClassesActor>::operator new;
	using FastAllocated<MonitorProcessClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10589194281378446080UL, 5998003210414766080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorProcessClassesActor, 1, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 2, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 3, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 4, RangeResult >;
friend struct ActorCallback< MonitorProcessClassesActor, 5, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 6, Void >;
friend struct ActorCallback< MonitorProcessClassesActor, 7, Void >;
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorProcessClassesActor(ClusterControllerData* const& self) 
															#line 9457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorProcessClassesActorState<MonitorProcessClassesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11588372557279712768UL, 7971599830169234176UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProcessClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorProcessClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorProcessClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< MonitorProcessClassesActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorProcessClasses( ClusterControllerData* const& self ) {
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorProcessClassesActor(self));
															#line 9497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1560 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 9502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorServerInfoConfigActor>
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActorState {
															#line 9509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 9516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorServerInfoConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1562 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 9531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorServerInfoConfigActorState();
		static_cast<MonitorServerInfoConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1564 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 9563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1566 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 1570 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(latencyBandConfigKey);
															#line 1570 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 1;
															#line 1570 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 9636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 4;
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 3, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& configVal,int loopDepth) 
	{
															#line 1571 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1572 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 9658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 9662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1577 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 9668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 9680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && configVal,int loopDepth) 
	{
															#line 1571 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		Optional<LatencyBandConfig> config;
															#line 1572 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (configVal.present())
															#line 9704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			config = LatencyBandConfig::parse(configVal.get());
															#line 9708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto serverInfo = db->serverInfo->get();
															#line 1577 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (config != serverInfo.latencyBandConfig)
															#line 9714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("LatencyBandConfigChanged").detail("Present", config.present());
															#line 1579 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			serverInfo.latencyBandConfig = config;
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			db->serverInfo->set(serverInfo);
															#line 9726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		configChangeFuture = tr.watch(latencyBandConfigKey);
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 2;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 1, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(configVal, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && configVal,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(configVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = configChangeFuture;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 3;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorServerInfoConfigActor, 2, Void >*>(static_cast<MonitorServerInfoConfigActor*>(this)));
															#line 9846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorServerInfoConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorServerInfoConfigActor*>(this)->ActorCallback< MonitorServerInfoConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorServerInfoConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> configChangeFuture;
															#line 10106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorServerInfoConfig()
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorServerInfoConfigActor final : public Actor<Void>, public ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorServerInfoConfigActor, 1, Void >, public ActorCallback< MonitorServerInfoConfigActor, 2, Void >, public ActorCallback< MonitorServerInfoConfigActor, 3, Void >, public FastAllocated<MonitorServerInfoConfigActor>, public MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor> {
															#line 10111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorServerInfoConfigActor>::operator new;
	using FastAllocated<MonitorServerInfoConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8760504284340775936UL, 9533083515429698048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 1, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 2, Void >;
friend struct ActorCallback< MonitorServerInfoConfigActor, 3, Void >;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorServerInfoConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 10131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorServerInfoConfigActorState<MonitorServerInfoConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7361646417378993920UL, 12905750869672403968UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorServerInfoConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorServerInfoConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorServerInfoConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorServerInfoConfigActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorServerInfoConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorServerInfoConfigActor(db));
															#line 10167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1597 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors storage metadata changes and updates to storage servers.
															#line 10173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorStorageMetadata()
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorStorageMetadataActor>
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActorState {
															#line 10180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActorState(ClusterControllerData* const& self) 
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   metadataMap(serverMetadataKeys.begin, IncludeVersion()),
															#line 1602 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(self->cx)),
															#line 1603 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   servers()
															#line 10193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	~MonitorStorageMetadataActorState() 
	{
		fdb_probe_actor_destroy("monitorStorageMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1604 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 10208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorStorageMetadataActorState();
		static_cast<MonitorStorageMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.clear();
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 1;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1640 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 1640 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 5;
															#line 1640 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 4, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1611 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1613 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		servers.reserve(serverList.size());
															#line 1614 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto ss : serverList ) {
															#line 1615 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			servers.push_back(StorageServerMetaInfo(decodeServerListValue(ss.value)));
															#line 10304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr->getRange(serverMetadataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 2;
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __serverList,int loopDepth) 
	{
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverList = __serverList;
															#line 10324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __serverList,int loopDepth) 
	{
		serverList = std::move(__serverList);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(!serverMetadata.more && serverMetadata.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1620 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<UID, StorageMetadataType> idMetadata;
															#line 1621 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& sm : serverMetadata ) {
															#line 1622 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const UID id = decodeServerMetadataKey(sm.key);
															#line 1623 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			idMetadata[id] = decodeServerMetadataValue(sm.value);
															#line 10411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1625 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& s : servers ) {
															#line 1626 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (idMetadata.contains(s.id()))
															#line 10417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1627 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				s.metadata = idMetadata[s.id()];
															#line 10421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 1629 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent(SevWarn, "StorageServerMetadataMissing", self->id).detail("ServerID", s.id());
															#line 10427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		watchFuture = tr->watch(serverMetadataChangeKey);
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 3;
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 2, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& __serverMetadata,int loopDepth) 
	{
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverMetadata = __serverMetadata;
															#line 10450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && __serverMetadata,int loopDepth) 
	{
		serverMetadata = std::move(__serverMetadata);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1636 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1636 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->storageStatusInfos = std::move(servers);
															#line 1637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 1637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 4;
															#line 1637 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorStorageMetadataActor, 3, Void >*>(static_cast<MonitorStorageMetadataActor*>(this)));
															#line 10556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1638 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 10640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1638 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr->reset();
															#line 10649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state > 0) static_cast<MonitorStorageMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorStorageMetadataActor*>(this)->ActorCallback< MonitorStorageMetadataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorStorageMetadataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	KeyBackedObjectMap<UID, StorageMetadataType, decltype(IncludeVersion())> metadataMap;
															#line 1602 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1603 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	std::vector<StorageServerMetaInfo> servers;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverList;
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	RangeResult serverMetadata;
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> watchFuture;
															#line 10843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorStorageMetadata()
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorStorageMetadataActor final : public Actor<Void>, public ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >, public ActorCallback< MonitorStorageMetadataActor, 2, Void >, public ActorCallback< MonitorStorageMetadataActor, 3, Void >, public ActorCallback< MonitorStorageMetadataActor, 4, Void >, public FastAllocated<MonitorStorageMetadataActor>, public MonitorStorageMetadataActorState<MonitorStorageMetadataActor> {
															#line 10848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorStorageMetadataActor>::operator new;
	using FastAllocated<MonitorStorageMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11587725316598691840UL, 1488915596708011520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >;
friend struct ActorCallback< MonitorStorageMetadataActor, 2, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 3, Void >;
friend struct ActorCallback< MonitorStorageMetadataActor, 4, Void >;
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorStorageMetadataActor(ClusterControllerData* const& self) 
															#line 10869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorStorageMetadataActorState<MonitorStorageMetadataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8345257820642168576UL, 250769687947896832UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorStorageMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorStorageMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorStorageMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorStorageMetadataActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorStorageMetadata( ClusterControllerData* const& self ) {
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorStorageMetadataActor(self));
															#line 10906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1644 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// Monitors the global configuration version key for changes. When changes are
// made, the global configuration history is read and any updates are sent to
// all processes in the system by updating the ClientDBInfo object. The
// GlobalConfig actor class contains the functionality to read the latest
// history and update the processes local view.
															#line 10916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorGlobalConfig()
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorGlobalConfigActor>
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActorState {
															#line 10923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActorState(ClusterControllerData::DBInfo* const& db) 
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : db(db)
															#line 10930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	~MonitorGlobalConfigActorState() 
	{
		fdb_probe_actor_destroy("monitorGlobalConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 10945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorGlobalConfigActorState();
		static_cast<MonitorGlobalConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		tr = ReadYourWritesTransaction(db->db);
															#line 1653 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = ClientDBInfo();
															#line 1654 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 10979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1656 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1657 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(globalConfigVersionKey);
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 1;
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 5;
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 4, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 1660 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (globalConfigVersion.present())
															#line 11070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(globalConfigHistoryKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 2;
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 11095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 1728 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		globalConfigFuture = tr.watch(globalConfigVersionKey);
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 3;
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 2, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult const& globalConfigHistory,int loopDepth) 
	{
															#line 1668 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1669 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1670 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1672 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1674 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 11202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1683 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 11208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				break;
			}
															#line 1687 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1691 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 11227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 11231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1713 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 11235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1719 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1720 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1721 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1725 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 11251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(RangeResult && globalConfigHistory,int loopDepth) 
	{
															#line 1668 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(globalConfigHistory.size() > 0);
															#line 1669 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo = db->serverInfo->get().client;
															#line 1670 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.history.clear();
															#line 1672 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( const auto& kv : globalConfigHistory ) {
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ObjectReader reader(kv.value.begin(), IncludeVersion());
															#line 1674 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (reader.protocolVersion() != g_network->protocolVersion() || BUGGIFY_WITH_PROB(0.01))
															#line 11270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.clear();
															#line 1683 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				clientInfo.history.emplace_back(std::numeric_limits<Version>::max());
															#line 11276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				break;
			}
															#line 1687 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			VersionHistory vh;
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			reader.deserialize(vh);
															#line 1691 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			BinaryReader versionReader = BinaryReader(kv.key.removePrefix(globalConfigHistoryPrefix), Unversioned());
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			Version historyCommitVersion;
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			versionReader >> historyCommitVersion;
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			historyCommitVersion = bigEndian64(historyCommitVersion);
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			vh.version = historyCommitVersion;
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history.push_back(std::move(vh));
															#line 11295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (clientInfo.history.size() > 0)
															#line 11299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1713 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			clientInfo.history[0].mutations = Standalone<VectorRef<MutationRef>>();
															#line 11303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		clientInfo.id = deterministicRandom()->randomUniqueID();
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ServerDBInfo serverInfo = db->serverInfo->get();
															#line 1719 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.id = deterministicRandom()->randomUniqueID();
															#line 1720 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.infoGeneration = ++db->dbInfoCount;
															#line 1721 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		serverInfo.client = clientInfo;
															#line 1722 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->serverInfo->set(serverInfo);
															#line 1725 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		db->clientInfo->set(clientInfo);
															#line 11319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult const& globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(globalConfigHistory, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(RangeResult && globalConfigHistory,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(globalConfigHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = globalConfigFuture;
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 4;
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorGlobalConfigActor, 3, Void >*>(static_cast<MonitorGlobalConfigActor*>(this)));
															#line 11426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state > 0) static_cast<MonitorGlobalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorGlobalConfigActor*>(this)->ActorCallback< MonitorGlobalConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorGlobalConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData::DBInfo* db;
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1653 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClientDBInfo clientInfo;
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 1728 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> globalConfigFuture;
															#line 11690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorGlobalConfig()
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorGlobalConfigActor final : public Actor<Void>, public ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >, public ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >, public ActorCallback< MonitorGlobalConfigActor, 2, Void >, public ActorCallback< MonitorGlobalConfigActor, 3, Void >, public ActorCallback< MonitorGlobalConfigActor, 4, Void >, public FastAllocated<MonitorGlobalConfigActor>, public MonitorGlobalConfigActorState<MonitorGlobalConfigActor> {
															#line 11695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorGlobalConfigActor>::operator new;
	using FastAllocated<MonitorGlobalConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15281610884716910336UL, 5460577013797824512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >;
friend struct ActorCallback< MonitorGlobalConfigActor, 2, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 3, Void >;
friend struct ActorCallback< MonitorGlobalConfigActor, 4, Void >;
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorGlobalConfigActor(ClusterControllerData::DBInfo* const& db) 
															#line 11716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorGlobalConfigActorState<MonitorGlobalConfigActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9619138829789891328UL, 5514350300057065984UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorGlobalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorGlobalConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorGlobalConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorGlobalConfigActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorGlobalConfig( ClusterControllerData::DBInfo* const& db ) {
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorGlobalConfigActor(db));
															#line 11753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1738 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 11758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangingDatacentersActor>
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActorState {
															#line 11765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActorState(ClusterControllerData* const& self) 
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 11772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangingDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 1;
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 11794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangingDatacentersActorState();
		static_cast<UpdatedChangingDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1742 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 11817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1742 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 11826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->desiredDcIds.onChange();
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->desiredDcIds.get().present())
															#line 11919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set(std::make_pair(false, self->desiredDcIds.get()));
															#line 11923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->desiredDcIds.get().get());
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->changingDcIds.set( std::make_pair(worker.priorityInfo.dcFitness > newFitness, self->desiredDcIds.get()));
															#line 1753 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangingDatacenter", self->id) .detail("OldFitness", worker.priorityInfo.dcFitness) .detail("NewFitness", newFitness);
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (worker.priorityInfo.dcFitness > newFitness)
															#line 11938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1757 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				worker.priorityInfo.dcFitness = newFitness;
															#line 1758 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!worker.reply.isSet())
															#line 11944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.reply.send(RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 11948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				}
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 1762 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 11958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1790 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onChange;
															#line 1790 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 3;
															#line 1790 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 11976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 12004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1766 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 12014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changingDcIds.get().second.get());
															#line 1771 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 12020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 1775 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 12028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send( RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 12032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
		}
															#line 1782 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 12039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 2;
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*>(static_cast<UpdatedChangingDatacentersActor*>(this)));
															#line 12050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 12077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangingDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangingDatacentersActor*>(this)->ActorCallback< UpdatedChangingDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1762 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 12262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updatedChangingDatacenters()
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangingDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangingDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangingDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangingDatacentersActor>, public UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor> {
															#line 12267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdatedChangingDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangingDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3845572877669205760UL, 7563426506440293888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangingDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangingDatacentersActor, 2, Void >;
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangingDatacentersActor(ClusterControllerData* const& self) 
															#line 12286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdatedChangingDatacentersActorState<UpdatedChangingDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7981795789287489024UL, 15976645570533241600UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangingDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangingDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangingDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdatedChangingDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangingDatacenters( ClusterControllerData* const& self ) {
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangingDatacentersActor(self));
															#line 12321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1793 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 12326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updatedChangedDatacenters()
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdatedChangedDatacentersActor>
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActorState {
															#line 12333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActorState(ClusterControllerData* const& self) 
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1795 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   changeDelay(delay(SERVER_KNOBS->CC_CHANGE_DELAY)),
															#line 1796 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   onChange(self->changingDcIds.onChange())
															#line 12344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	~UpdatedChangedDatacentersActorState() 
	{
		fdb_probe_actor_destroy("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1797 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 12359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdatedChangedDatacentersActorState();
		static_cast<UpdatedChangedDatacentersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1799 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 1798 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1803 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = changeDelay;
															#line 12395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 1;
															#line 1799 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 1803 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 12402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1800 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 12419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1800 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = delay(SERVER_KNOBS->CC_CHANGE_DELAY);
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 12430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1804 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 1808 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 12445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 12451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1811 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1812 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 12459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1815 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 1816 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 12465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1817 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 12469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1823 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 12480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1804 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		changeDelay = Never();
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->changingDcIds.onChange();
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->changedDcIds.set(self->changingDcIds.get());
															#line 1808 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->changedDcIds.get().second.present())
															#line 12501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("UpdateChangedDatacenter", self->id).detail("CCFirst", self->changedDcIds.get().first);
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!self->changedDcIds.get().first)
															#line 12507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1811 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				auto& worker = self->id_worker[self->clusterControllerProcessId];
															#line 1812 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t newFitness = ClusterControllerPriorityInfo::calculateDCFitness( worker.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (worker.priorityInfo.dcFitness != newFitness)
															#line 12515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1815 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					worker.priorityInfo.dcFitness = newFitness;
															#line 1816 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!worker.reply.isSet())
															#line 12521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1817 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						worker.reply.send( RegisterWorkerReply(worker.details.processClass, worker.priorityInfo));
															#line 12525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					}
				}
				loopDepth = a_body1loopBody1when2cont2(loopDepth);
			}
			else
			{
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				currentFit = ProcessClass::BestFit;
															#line 1823 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 12536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopBody1when2loopHead1(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 0, Void >::remove();
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1(int loopDepth) 
	{
															#line 1823 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(currentFit <= ProcessClass::NeverAssign))
															#line 12640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1when2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool updated = false;
															#line 1825 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		for( auto& it : self->id_worker ) {
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if ((!it.second.priorityInfo.isExcluded && it.second.priorityInfo.processClassFitness == currentFit) || currentFit == ProcessClass::NeverAssign)
															#line 12650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1829 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				uint8_t fitness = ClusterControllerPriorityInfo::calculateDCFitness( it.second.details.interf.locality.dcId(), self->changedDcIds.get().second.get());
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (it.first != self->clusterControllerProcessId && it.second.priorityInfo.dcFitness != fitness)
															#line 12656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1834 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					updated = true;
															#line 1835 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					it.second.priorityInfo.dcFitness = fitness;
															#line 1836 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					if (!it.second.reply.isSet())
															#line 12664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					{
															#line 1837 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						it.second.reply.send(RegisterWorkerReply(it.second.details.processClass, it.second.priorityInfo));
															#line 12668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
					}
				}
			}
		}
															#line 1843 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (updated && currentFit < ProcessClass::NeverAssign)
															#line 12675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1844 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->CC_CLASS_DELAY);
															#line 1844 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1when2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 2;
															#line 1844 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*>(static_cast<UpdatedChangedDatacentersActor*>(this)));
															#line 12686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when2cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont1(int loopDepth) 
	{
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		currentFit++;
															#line 12713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state > 0) static_cast<UpdatedChangedDatacentersActor*>(this)->actor_wait_state = 0;
		static_cast<UpdatedChangedDatacentersActor*>(this)->ActorCallback< UpdatedChangedDatacentersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdatedChangedDatacentersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1795 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> changeDelay;
															#line 1796 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	int currentFit;
															#line 12870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updatedChangedDatacenters()
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdatedChangedDatacentersActor final : public Actor<Void>, public ActorCallback< UpdatedChangedDatacentersActor, 0, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 1, Void >, public ActorCallback< UpdatedChangedDatacentersActor, 2, Void >, public FastAllocated<UpdatedChangedDatacentersActor>, public UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor> {
															#line 12875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdatedChangedDatacentersActor>::operator new;
	using FastAllocated<UpdatedChangedDatacentersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18279692468894130688UL, 4084558363904506112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdatedChangedDatacentersActor, 0, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 1, Void >;
friend struct ActorCallback< UpdatedChangedDatacentersActor, 2, Void >;
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdatedChangedDatacentersActor(ClusterControllerData* const& self) 
															#line 12894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdatedChangedDatacentersActorState<UpdatedChangedDatacentersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2151090047836179200UL, 49094124038652928UL);
		ActorExecutionContextHelper __helper(static_cast<UpdatedChangedDatacentersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updatedChangedDatacenters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updatedChangedDatacenters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdatedChangedDatacentersActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updatedChangedDatacenters( ClusterControllerData* const& self ) {
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdatedChangedDatacentersActor(self));
															#line 12928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1854 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 12933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateDatacenterVersionDifferenceActor>
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActorState {
															#line 12940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActorState(ClusterControllerData* const& self) 
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   lastLogTime(0)
															#line 12949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDatacenterVersionDifferenceActorState() 
	{
		fdb_probe_actor_destroy("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1857 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 12964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDatacenterVersionDifferenceActorState();
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->versionDifferenceUpdated = false;
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS && self->db.config.usableRegions == 1)
															#line 12996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1861 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 1863 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 1864 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = 0;
															#line 1865 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = 0;
															#line 1866 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = 0;
															#line 1868 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge)
															#line 13010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1869 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 13014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 1;
															#line 1872 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1876 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryLog = Optional<TLogInterface>();
															#line 1877 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteLog = Optional<TLogInterface>();
															#line 1878 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 13043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1879 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			for( auto& logSet : self->db.serverInfo->get().logSystemConfig.tLogs ) {
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (logSet.isLocal && logSet.locality != tagLocalitySatellite)
															#line 13049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1881 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 1882 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 13055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
						{
															#line 1883 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
							primaryLog = tLog.interf();
															#line 13059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
							break;
						}
					}
				}
															#line 1888 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				if (!logSet.isLocal)
															#line 13066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				{
															#line 1889 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
					for( auto& tLog : logSet.tLogs ) {
															#line 1890 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
						if (tLog.present())
															#line 13072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
						{
															#line 1891 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
							remoteLog = tLog.interf();
															#line 13076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
							break;
						}
					}
				}
			}
		}
															#line 1899 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!primaryLog.present() || !remoteLog.present() || !self->db.serverInfo->get().ratekeeper.present())
															#line 13085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1900 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange();
															#line 1900 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 2;
															#line 1900 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		onChange = self->db.serverInfo->onChange();
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont15(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 1906 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		primaryMetrics = brokenPromiseToNever(primaryLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		remoteMetrics = brokenPromiseToNever(remoteLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ssVersionLagReply = brokenPromiseToNever( self->db.serverInfo->get().ratekeeper.get().getSSVersionLag.getReply(GetSSVersionLagRequest()));
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = (success(primaryMetrics) && success(remoteMetrics) && success(ssVersionLagReply)) || onChange;
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 3;
															#line 1913 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 13349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1919 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 1921 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 1922 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 1923 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 1927 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 1930 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 1932 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 13365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1933 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 13369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 13373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1937 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 1938 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 13379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1945 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 1945 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 1945 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (primaryMetrics.get().v > 0 && remoteMetrics.get().v > 0)
															#line 13406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1919 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			bool oldDifferenceTooLarge = !self->versionDifferenceUpdated || self->datacenterVersionDifference >= SERVER_KNOBS->MAX_VERSION_DIFFERENCE;
															#line 1921 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->versionDifferenceUpdated = true;
															#line 1922 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcLogServerVersionDifference = primaryMetrics.get().v - remoteMetrics.get().v;
															#line 1923 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->dcStorageServerVersionDifference = (ssVersionLagReply.get().maxPrimarySSVersion > 0 && ssVersionLagReply.get().maxRemoteSSVersion > 0) ? (ssVersionLagReply.get().maxPrimarySSVersion - ssVersionLagReply.get().maxRemoteSSVersion) : 0;
															#line 1927 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->datacenterVersionDifference = std::max(self->dcLogServerVersionDifference, self->dcStorageServerVersionDifference);
															#line 1930 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("VersionDifferenceOldLarge").detail("OldDifference", oldDifferenceTooLarge);
															#line 1932 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (oldDifferenceTooLarge && self->datacenterVersionDifference < SERVER_KNOBS->MAX_VERSION_DIFFERENCE)
															#line 13422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1933 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				checkOutstandingRequests(self);
															#line 13426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (now() - lastLogTime > SERVER_KNOBS->CLUSTER_CONTROLLER_LOGGING_DELAY)
															#line 13430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 1937 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				lastLogTime = now();
															#line 1938 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("DatacenterVersionDifference", self->id) .detail("Difference", self->datacenterVersionDifference) .detail("LogServerVersionDifference", self->dcLogServerVersionDifference) .detail("StorageServerVersionDifference", self->dcStorageServerVersionDifference);
															#line 13436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
		}
															#line 1945 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->VERSION_LAG_METRIC_INTERVAL) || onChange;
															#line 1945 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 13443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont5loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 4;
															#line 1945 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*>(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)));
															#line 13448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1946 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1946 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (onChange.isReady())
															#line 13544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state > 0) static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double lastLogTime;
															#line 1876 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> primaryLog;
															#line 1877 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Optional<TLogInterface> remoteLog;
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> onChange;
															#line 1906 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> primaryMetrics;
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<TLogQueuingMetricsReply> remoteMetrics;
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<GetSSVersionLagReply> ssVersionLagReply;
															#line 13643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updateDatacenterVersionDifference()
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateDatacenterVersionDifferenceActor final : public Actor<Void>, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >, public ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >, public FastAllocated<UpdateDatacenterVersionDifferenceActor>, public UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor> {
															#line 13648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator new;
	using FastAllocated<UpdateDatacenterVersionDifferenceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3364121844056152832UL, 5340921245766370560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >;
friend struct ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >;
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateDatacenterVersionDifferenceActor(ClusterControllerData* const& self) 
															#line 13668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateDatacenterVersionDifferenceActorState<UpdateDatacenterVersionDifferenceActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9937717957229000960UL, 3709248056524776448UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDatacenterVersionDifferenceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDatacenterVersionDifference");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDatacenterVersionDifference", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateDatacenterVersionDifferenceActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateDatacenterVersionDifference( ClusterControllerData* const& self ) {
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateDatacenterVersionDifferenceActor(self));
															#line 13704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

// A background actor that periodically checks remote DC health, and `checkOutstandingRequests` if remote DC
// recovers.
															#line 13711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRemoteDCHealth()
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class UpdateRemoteDCHealthActor>
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActorState {
															#line 13718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActorState(ClusterControllerData* const& self) 
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 13725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRemoteDCHealthActorState() 
	{
		fdb_probe_actor_destroy("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1958 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->INITIAL_UPDATE_CROSS_DC_INFO_DELAY);
															#line 1958 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 1;
															#line 1958 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 13747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRemoteDCHealthActorState();
		static_cast<UpdateRemoteDCHealthActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1960 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 1964 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 13772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1965 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 13776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1968 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1960 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteDCMonitorStarted = true;
															#line 1964 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!self->remoteTransactionSystemDegraded)
															#line 13791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1965 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 13795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1968 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 13799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1969 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool oldRemoteTransactionSystemDegraded = self->remoteTransactionSystemDegraded;
															#line 1970 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->remoteTransactionSystemDegraded = self->remoteTransactionSystemContainsDegradedServers();
															#line 1972 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (oldRemoteTransactionSystemDegraded && !self->remoteTransactionSystemDegraded)
															#line 13894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 1973 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 13898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 1975 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->CHECK_REMOTE_HEALTH_INTERVAL);
															#line 1975 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 2;
															#line 1975 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*>(static_cast<UpdateRemoteDCHealthActor*>(this)));
															#line 13909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state > 0) static_cast<UpdateRemoteDCHealthActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRemoteDCHealthActor*>(this)->ActorCallback< UpdateRemoteDCHealthActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 14003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via updateRemoteDCHealth()
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class UpdateRemoteDCHealthActor final : public Actor<Void>, public ActorCallback< UpdateRemoteDCHealthActor, 0, Void >, public ActorCallback< UpdateRemoteDCHealthActor, 1, Void >, public FastAllocated<UpdateRemoteDCHealthActor>, public UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor> {
															#line 14008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<UpdateRemoteDCHealthActor>::operator new;
	using FastAllocated<UpdateRemoteDCHealthActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13582046267671739136UL, 9931873845098462208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRemoteDCHealthActor, 0, Void >;
friend struct ActorCallback< UpdateRemoteDCHealthActor, 1, Void >;
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UpdateRemoteDCHealthActor(ClusterControllerData* const& self) 
															#line 14026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRemoteDCHealthActorState<UpdateRemoteDCHealthActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4727392956320167168UL, 13078950417560124416UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRemoteDCHealthActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRemoteDCHealth");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRemoteDCHealth", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRemoteDCHealthActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> updateRemoteDCHealth( ClusterControllerData* const& self ) {
															#line 1955 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new UpdateRemoteDCHealthActor(self));
															#line 14060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1978 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via doEmptyCommit()
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class DoEmptyCommitActor>
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActorState {
															#line 14072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActorState(Database const& cx) 
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : cx(cx),
															#line 1980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   tr(cx)
															#line 14081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	~DoEmptyCommitActorState() 
	{
		fdb_probe_actor_destroy("doEmptyCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1981 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 14096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1983 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1984 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1985 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			tr.makeSelfConflicting();
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 14135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 1;
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 0, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 14140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1989 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1989 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 2;
															#line 1989 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoEmptyCommitActor, 1, Void >*>(static_cast<DoEmptyCommitActor*>(this)));
															#line 14169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1987 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 14184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1987 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<DoEmptyCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoEmptyCommitActorState(); static_cast<DoEmptyCommitActor*>(this)->destroy(); return 0; }
															#line 14196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<DoEmptyCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoEmptyCommitActorState();
		static_cast<DoEmptyCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoEmptyCommitActor*>(this)->actor_wait_state > 0) static_cast<DoEmptyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<DoEmptyCommitActor*>(this)->ActorCallback< DoEmptyCommitActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoEmptyCommitActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoEmptyCommitActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Database cx;
															#line 1980 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Transaction tr;
															#line 14370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via doEmptyCommit()
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class DoEmptyCommitActor final : public Actor<Void>, public ActorCallback< DoEmptyCommitActor, 0, Void >, public ActorCallback< DoEmptyCommitActor, 1, Void >, public FastAllocated<DoEmptyCommitActor>, public DoEmptyCommitActorState<DoEmptyCommitActor> {
															#line 14375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<DoEmptyCommitActor>::operator new;
	using FastAllocated<DoEmptyCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2880581804633622016UL, 14941568937411022336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoEmptyCommitActor, 0, Void >;
friend struct ActorCallback< DoEmptyCommitActor, 1, Void >;
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	DoEmptyCommitActor(Database const& cx) 
															#line 14393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   DoEmptyCommitActorState<DoEmptyCommitActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9964447062675513344UL, 11254058382217442560UL);
		ActorExecutionContextHelper __helper(static_cast<DoEmptyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doEmptyCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doEmptyCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoEmptyCommitActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> doEmptyCommit( Database const& cx ) {
															#line 1979 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new DoEmptyCommitActor(cx));
															#line 14427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 1993 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via handleForcedRecoveries()
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleForcedRecoveriesActor>
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActorState {
															#line 14439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 14448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	~HandleForcedRecoveriesActorState() 
	{
		fdb_probe_actor_destroy("handleForcedRecoveries", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1995 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 14463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleForcedRecoveriesActorState();
		static_cast<HandleForcedRecoveriesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.forceRecovery.getFuture();
															#line 14493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ForceRecoveryRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ForceRecoveryRequest>>::value, "invalid type");
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 1;
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1997 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryStart", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("DcId", req.dcId.printable());
															#line 2000 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		fCommit = doEmptyCommit(self->cx);
															#line 2001 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = fCommit || delay(SERVER_KNOBS->FORCE_RECOVERY_CHECK_DELAY);
															#line 2001 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 2;
															#line 2001 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 1, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest const& __req,int loopDepth) 
	{
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req = __req;
															#line 14531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ForceRecoveryRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,ForceRecoveryRequest && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 2002 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 14610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 14614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2004 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2007 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 14624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2010 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 14632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 2002 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!fCommit.isReady() || fCommit.isError())
															#line 14657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (self->clusterControllerDcId != req.dcId)
															#line 14661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2004 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				std::vector<Optional<Key>> dcPriority;
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(req.dcId);
															#line 2006 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				dcPriority.push_back(self->clusterControllerDcId);
															#line 2007 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->desiredDcIds.set(dcPriority);
															#line 14671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			else
			{
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceRecovery = true;
															#line 2010 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.forceMasterFailure.trigger();
															#line 14679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = fCommit;
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 3;
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleForcedRecoveriesActor, 2, Void >*>(static_cast<HandleForcedRecoveriesActor*>(this)));
															#line 14690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 2014 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("ForcedRecoveryFinish", self->id).log();
															#line 2015 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.forceRecovery = false;
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(Void());
															#line 14783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state > 0) static_cast<HandleForcedRecoveriesActor*>(this)->actor_wait_state = 0;
		static_cast<HandleForcedRecoveriesActor*>(this)->ActorCallback< HandleForcedRecoveriesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleForcedRecoveriesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 1996 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ForceRecoveryRequest req;
															#line 2000 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> fCommit;
															#line 14883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via handleForcedRecoveries()
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleForcedRecoveriesActor final : public Actor<Void>, public ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >, public ActorCallback< HandleForcedRecoveriesActor, 1, Void >, public ActorCallback< HandleForcedRecoveriesActor, 2, Void >, public FastAllocated<HandleForcedRecoveriesActor>, public HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor> {
															#line 14888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<HandleForcedRecoveriesActor>::operator new;
	using FastAllocated<HandleForcedRecoveriesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6174006474720056832UL, 2387596221602033408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 1, Void >;
friend struct ActorCallback< HandleForcedRecoveriesActor, 2, Void >;
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleForcedRecoveriesActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 14907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   HandleForcedRecoveriesActorState<HandleForcedRecoveriesActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14107891886794473728UL, 6151159479286482432UL);
		ActorExecutionContextHelper __helper(static_cast<HandleForcedRecoveriesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleForcedRecoveries");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleForcedRecoveries", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleForcedRecoveriesActor, 0, ForceRecoveryRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleForcedRecoveriesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleForcedRecoveries( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleForcedRecoveriesActor(self, interf));
															#line 14942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2019 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 14947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via triggerAuditStorage()
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class TriggerAuditStorageActor>
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActorState {
															#line 14954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req),
															#line 2021 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   auditId()
															#line 14965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~TriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("triggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2022 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(!req.cancel);
															#line 14980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			try {
															#line 2024 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 14984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2052 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<TriggerAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerAuditStorageActorState(); static_cast<TriggerAuditStorageActor*>(this)->destroy(); return 0; }
															#line 15013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<TriggerAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerAuditStorageActorState();
		static_cast<TriggerAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2043 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCTriggerAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2049 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(audit_storage_failed());
															#line 15028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageBegin", self->id) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.range, req.engineType);
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 15049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2034 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 1, UID >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 15054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2024 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 15070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerAuditStorageActor, 0, Void >*>(static_cast<TriggerAuditStorageActor*>(this)));
															#line 15083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId_,int loopDepth) 
	{
															#line 2035 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2036 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2041 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId_,int loopDepth) 
	{
															#line 2035 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auditId = auditId_;
															#line 2036 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageEnd", self->id) .detail("AuditID", auditId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2041 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId_,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<TriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerAuditStorageActor*>(this)->ActorCallback< TriggerAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TriggerAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TriggerAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 2021 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	UID auditId;
															#line 15308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via triggerAuditStorage()
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class TriggerAuditStorageActor final : public Actor<Void>, public ActorCallback< TriggerAuditStorageActor, 0, Void >, public ActorCallback< TriggerAuditStorageActor, 1, UID >, public FastAllocated<TriggerAuditStorageActor>, public TriggerAuditStorageActorState<TriggerAuditStorageActor> {
															#line 15313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<TriggerAuditStorageActor>::operator new;
	using FastAllocated<TriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15074651844989486848UL, 13653263812887508480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerAuditStorageActor, 0, Void >;
friend struct ActorCallback< TriggerAuditStorageActor, 1, UID >;
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 15331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   TriggerAuditStorageActorState<TriggerAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12747449799772827392UL, 11482104197366523904UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TriggerAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> triggerAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new TriggerAuditStorageActor(self, req));
															#line 15365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2054 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via cancelAuditStorage()
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class CancelAuditStorageActor>
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActorState {
															#line 15377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActorState(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   req(req)
															#line 15386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~CancelAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("cancelAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2056 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.cancel);
															#line 15401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			try {
															#line 2058 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				;
															#line 15405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2082 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!static_cast<CancelAuditStorageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelAuditStorageActorState(); static_cast<CancelAuditStorageActor*>(this)->destroy(); return 0; }
															#line 15434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		new (&static_cast<CancelAuditStorageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelAuditStorageActorState();
		static_cast<CancelAuditStorageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2075 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent(SevInfo, "CCCancelAuditStorageFailed", self->id) .errorUnsuppressed(e) .detail("AuditID", req.id) .detail("AuditType", req.getType());
															#line 2079 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			req.reply.sendError(cancel_audit_storage_failed());
															#line 15449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2062 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageBegin", self->id) .detail("AuditID", req.id) .detail("AuditType", req.getType()) .detail("DDId", self->db.serverInfo->get().distributor.get().id());
															#line 2066 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TriggerAuditRequest fReq(req.getType(), req.id);
															#line 2067 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<UID> __when_expr_1 = self->db.serverInfo->get().distributor.get().triggerAudit.getReply(fReq);
															#line 2067 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 15470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 2;
															#line 2067 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 1, UID >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 15475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2058 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS || !self->db.serverInfo->get().distributor.present()))
															#line 15491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2060 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2060 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2060 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelAuditStorageActor, 0, Void >*>(static_cast<CancelAuditStorageActor*>(this)));
															#line 15504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(UID const& auditId,int loopDepth) 
	{
															#line 2068 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2073 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && auditId,int loopDepth) 
	{
															#line 2068 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCCancelAuditStorageEnd", self->id) .detail("ReturnedAuditID", auditId) .detail("AuditID", auditId) .detail("AuditType", req.getType());
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		ASSERT(auditId == req.id);
															#line 2073 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		req.reply.send(auditId);
															#line 15630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID const& auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(auditId, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(UID && auditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(auditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CancelAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditStorageActor*>(this)->ActorCallback< CancelAuditStorageActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CancelAuditStorageActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CancelAuditStorageActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	TriggerAuditRequest req;
															#line 15727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via cancelAuditStorage()
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class CancelAuditStorageActor final : public Actor<Void>, public ActorCallback< CancelAuditStorageActor, 0, Void >, public ActorCallback< CancelAuditStorageActor, 1, UID >, public FastAllocated<CancelAuditStorageActor>, public CancelAuditStorageActorState<CancelAuditStorageActor> {
															#line 15732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<CancelAuditStorageActor>::operator new;
	using FastAllocated<CancelAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15336015940268342784UL, 3009297569835685632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancelAuditStorageActor, 0, Void >;
friend struct ActorCallback< CancelAuditStorageActor, 1, UID >;
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	CancelAuditStorageActor(ClusterControllerData* const& self,TriggerAuditRequest const& req) 
															#line 15750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   CancelAuditStorageActorState<CancelAuditStorageActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10342539104284409856UL, 5939736706038642176UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CancelAuditStorageActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> cancelAuditStorage( ClusterControllerData* const& self, TriggerAuditRequest const& req ) {
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new CancelAuditStorageActor(self, req));
															#line 15784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2084 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 15789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class HandleTriggerAuditStorageActor>
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActorState {
															#line 15796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActorState(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   interf(interf)
															#line 15805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	~HandleTriggerAuditStorageActorState() 
	{
		fdb_probe_actor_destroy("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2086 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 15820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleTriggerAuditStorageActorState();
		static_cast<HandleTriggerAuditStorageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		auto __when_expr_0 = interf.clientInterface.triggerAudit.getFuture();
															#line 15850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<TriggerAuditRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<TriggerAuditRequest>>::value, "invalid type");
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 1;
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*>(static_cast<HandleTriggerAuditStorageActor*>(this)));
															#line 15859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest const& req,int loopDepth) 
	{
															#line 2088 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2093 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 15870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2094 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2095 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 15876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 2097 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 15882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(TriggerAuditRequest && req,int loopDepth) 
	{
															#line 2088 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevVerbose, "CCTriggerAuditStorageReceived", self->id) .detail("ClusterControllerDcId", self->clusterControllerDcId) .detail("Range", req.range) .detail("AuditType", req.getType()) .detail("KeyValueStoreType", req.engineType.toString());
															#line 2093 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (req.cancel)
															#line 15894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2094 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			ASSERT(req.id.isValid());
															#line 2095 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(cancelAuditStorage(self, req));
															#line 15900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		else
		{
															#line 2097 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->addActor.send(triggerAuditStorage(self, req));
															#line 15906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TriggerAuditRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state > 0) static_cast<HandleTriggerAuditStorageActor*>(this)->actor_wait_state = 0;
		static_cast<HandleTriggerAuditStorageActor*>(this)->ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest const& value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,TriggerAuditRequest && value) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*,Error err) 
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerFullInterface interf;
															#line 15991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via handleTriggerAuditStorage()
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class HandleTriggerAuditStorageActor final : public Actor<Void>, public ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >, public FastAllocated<HandleTriggerAuditStorageActor>, public HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor> {
															#line 15996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<HandleTriggerAuditStorageActor>::operator new;
	using FastAllocated<HandleTriggerAuditStorageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11697152112053377536UL, 8001232140721865216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >;
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	HandleTriggerAuditStorageActor(ClusterControllerData* const& self,ClusterControllerFullInterface const& interf) 
															#line 16013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   HandleTriggerAuditStorageActorState<HandleTriggerAuditStorageActor>(self, interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15197834898829094656UL, 1920184061417848064UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTriggerAuditStorageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleTriggerAuditStorage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleTriggerAuditStorage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HandleTriggerAuditStorageActor, 0, TriggerAuditRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> handleTriggerAuditStorage( ClusterControllerData* const& self, ClusterControllerFullInterface const& interf ) {
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new HandleTriggerAuditStorageActor(self, interf));
															#line 16046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2101 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via startDataDistributor()
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartDataDistributorActor>
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartDataDistributorActorState {
															#line 16058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartDataDistributorActorState(ClusterControllerData* const& self,double const& waitTime) 
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   waitTime(waitTime)
															#line 16067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	~StartDataDistributorActorState() 
	{
		fdb_probe_actor_destroy("startDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(waitTime);
															#line 2105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 1;
															#line 2105 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 0, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartDataDistributorActorState();
		static_cast<StartDataDistributorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2107 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2108 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2107 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartDataDistributor", self->id).log();
															#line 2108 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2110 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			noDistributor = !self->db.serverInfo->get().distributor.present();
															#line 2111 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 16219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2169 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2169 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 4;
															#line 2169 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 3, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2164 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruitError", self->id).error(e);
															#line 2165 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 16253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2166 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 16257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2116 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (noDistributor && self->db.serverInfo->get().distributor.present())
															#line 16273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2118 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 16277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2121 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> idUsed = self->getUsedIds();
															#line 2122 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo ddWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::DataDistributor, ProcessClass::NeverAssign, self->db.config, idUsed);
															#line 2127 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeDataDistributorRequest req(deterministicRandom()->randomUniqueID());
															#line 2128 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = ddWorker.worker;
															#line 2129 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::DataDistributor))
															#line 16293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2130 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 16297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 2133 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingDistributorID = req.reqId;
															#line 2134 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitDataDistributor", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", req.reqId);
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<DataDistributorInterface>> __when_expr_2 = worker.interf.dataDistributor.getReplyUnlessFailedFor( req, SERVER_KNOBS->WAIT_FOR_DISTRIBUTOR_JOIN_DELAY, 0);
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 3;
															#line 2138 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2111 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 16328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2114 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2114 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 2;
															#line 2114 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartDataDistributorActor, 1, Void >*>(static_cast<StartDataDistributorActor*>(this)));
															#line 16341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
															#line 2141 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 16450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2142 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2143 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2144 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2145 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2148 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 16462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2151 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 16468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2157 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 16472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2158 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 16476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2160 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2161 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 16482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
															#line 2141 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (ddInterf.present())
															#line 16496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2142 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitDistributor.set(false);
															#line 2143 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingDistributorID = ddInterf.get().id();
															#line 2144 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2145 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCDataDistributorRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("DDID", ddInterf.get().id());
															#line 2148 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (distributor.present() && distributor.get().id() != ddInterf.get().id() && self->id_worker.contains(distributor.get().locality.processId()))
															#line 16508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2151 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltDataDistributorAfterRecruit", self->id) .detail("DDID", distributor.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 16514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2157 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!distributor.present() || distributor.get().id() != ddInterf.get().id())
															#line 16518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2158 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setDistributor(ddInterf.get());
															#line 16522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2160 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2161 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartDataDistributorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartDataDistributorActorState(); static_cast<StartDataDistributorActor*>(this)->destroy(); return 0; }
															#line 16528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartDataDistributorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartDataDistributorActorState();
			static_cast<StartDataDistributorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> const& ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(ddInterf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<DataDistributorInterface> && ddInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(ddInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,ErrorOr<DataDistributorInterface> && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<StartDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<StartDataDistributorActor*>(this)->ActorCallback< StartDataDistributorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartDataDistributorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartDataDistributorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double waitTime;
															#line 2110 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	bool noDistributor;
															#line 2128 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerDetails worker;
															#line 16721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via startDataDistributor()
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartDataDistributorActor final : public Actor<Void>, public ActorCallback< StartDataDistributorActor, 0, Void >, public ActorCallback< StartDataDistributorActor, 1, Void >, public ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >, public ActorCallback< StartDataDistributorActor, 3, Void >, public FastAllocated<StartDataDistributorActor>, public StartDataDistributorActorState<StartDataDistributorActor> {
															#line 16726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<StartDataDistributorActor>::operator new;
	using FastAllocated<StartDataDistributorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10414696453020215808UL, 13338021313260800768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartDataDistributorActor, 0, Void >;
friend struct ActorCallback< StartDataDistributorActor, 1, Void >;
friend struct ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >;
friend struct ActorCallback< StartDataDistributorActor, 3, Void >;
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartDataDistributorActor(ClusterControllerData* const& self,double const& waitTime) 
															#line 16746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   StartDataDistributorActorState<StartDataDistributorActor>(self, waitTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startDataDistributor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8266636108691840000UL, 3944324526065100544UL);
		ActorExecutionContextHelper __helper(static_cast<StartDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startDataDistributor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startDataDistributor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartDataDistributorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartDataDistributorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartDataDistributorActor, 2, ErrorOr<DataDistributorInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartDataDistributorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> startDataDistributor( ClusterControllerData* const& self, double const& waitTime ) {
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StartDataDistributorActor(self, waitTime));
															#line 16782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2172 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 16787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorDataDistributor()
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorDataDistributorActor>
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorDataDistributorActorState {
															#line 16794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorDataDistributorActorState(ClusterControllerData* const& self) 
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2174 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruitThrottler()
															#line 16803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	~MonitorDataDistributorActorState() 
	{
		fdb_probe_actor_destroy("monitorDataDistributor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 16818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorDataDistributorActorState();
		static_cast<MonitorDataDistributorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2179 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 16841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 16857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2176 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2176 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 1;
															#line 2176 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 0, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 16870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2180 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		bool ddExist = self->db.serverInfo->get().distributor.present();
															#line 2181 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent(SevInfo, "CCMonitorDataDistributor", self->id) .detail("Recruiting", self->recruitDistributor.get()) .detail("Existing", ddExist) .detail("ExistingDD", ddExist ? self->db.serverInfo->get().distributor.get().id().toString() : "");
															#line 2186 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().distributor.present() && !self->recruitDistributor.get())
															#line 16990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2188 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitFailureClient(self->db.serverInfo->get().distributor.get().waitFailure, SERVER_KNOBS->DD_FAILURE_TIME);
															#line 2187 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2195 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->recruitDistributor.onChange();
															#line 17000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 2;
															#line 2188 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 1, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 2195 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 2, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 17007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2198 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = startDataDistributor(self, recruitThrottler.newRecruitment());
															#line 2198 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 3;
															#line 2198 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorDataDistributorActor, 3, Void >*>(static_cast<MonitorDataDistributorActor*>(this)));
															#line 17021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2190 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2191 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCDataDistributorDied", self->id).detail("DDID", distributor.get().id());
															#line 2192 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 2193 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::DataDistributorClass);
															#line 17049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2190 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& distributor = self->db.serverInfo->get().distributor;
															#line 2191 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCDataDistributorDied", self->id).detail("DDID", distributor.get().id());
															#line 2192 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		DataDistributorSingleton(distributor).halt(*self, distributor.get().locality.processId());
															#line 2193 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::DataDistributorClass);
															#line 17064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 1, Void >::remove();
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state > 0) static_cast<MonitorDataDistributorActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDataDistributorActor*>(this)->ActorCallback< MonitorDataDistributorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorDataDistributorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2174 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	SingletonRecruitThrottler recruitThrottler;
															#line 17293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorDataDistributor()
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorDataDistributorActor final : public Actor<Void>, public ActorCallback< MonitorDataDistributorActor, 0, Void >, public ActorCallback< MonitorDataDistributorActor, 1, Void >, public ActorCallback< MonitorDataDistributorActor, 2, Void >, public ActorCallback< MonitorDataDistributorActor, 3, Void >, public FastAllocated<MonitorDataDistributorActor>, public MonitorDataDistributorActorState<MonitorDataDistributorActor> {
															#line 17298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorDataDistributorActor>::operator new;
	using FastAllocated<MonitorDataDistributorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9615759156922222848UL, 7947795182021831424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorDataDistributorActor, 0, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 1, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 2, Void >;
friend struct ActorCallback< MonitorDataDistributorActor, 3, Void >;
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorDataDistributorActor(ClusterControllerData* const& self) 
															#line 17318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorDataDistributorActorState<MonitorDataDistributorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorDataDistributor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3240252173218499840UL, 15914322439490313216UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDataDistributorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorDataDistributor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorDataDistributor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorDataDistributorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorDataDistributor( ClusterControllerData* const& self ) {
															#line 2173 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorDataDistributorActor(self));
															#line 17353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2202 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 17358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via startRatekeeper()
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartRatekeeperActor>
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartRatekeeperActorState {
															#line 17365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartRatekeeperActorState(ClusterControllerData* const& self,double const& waitTime) 
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   waitTime(waitTime)
															#line 17374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("startRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	~StartRatekeeperActorState() 
	{
		fdb_probe_actor_destroy("startRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(waitTime);
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 1;
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 0, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRatekeeperActorState();
		static_cast<StartRatekeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartRatekeeper", self->id).log();
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartRatekeeper", self->id).log();
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 17432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			no_ratekeeper = !self->db.serverInfo->get().ratekeeper.present();
															#line 2212 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 17526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 4;
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 3, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruitError", self->id).error(e);
															#line 2263 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 17560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2264 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 17564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2217 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (no_ratekeeper && self->db.serverInfo->get().ratekeeper.present())
															#line 17580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2219 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 17584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2222 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo rkWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::Ratekeeper, ProcessClass::NeverAssign, self->db.config, id_used);
															#line 2228 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeRatekeeperRequest req(deterministicRandom()->randomUniqueID());
															#line 2229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = rkWorker.worker;
															#line 2230 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::Ratekeeper))
															#line 17600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2231 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 17604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 2234 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingRatekeeperID = req.reqId;
															#line 2235 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitRatekeeper", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", req.reqId);
															#line 2239 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<RatekeeperInterface>> __when_expr_2 = worker.interf.ratekeeper.getReplyUnlessFailedFor(req, SERVER_KNOBS->WAIT_FOR_RATEKEEPER_JOIN_DELAY, 0);
															#line 2239 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 3;
															#line 2239 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2212 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 17635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2215 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2215 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 2;
															#line 2215 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRatekeeperActor, 1, Void >*>(static_cast<StartRatekeeperActor*>(this)));
															#line 17648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<RatekeeperInterface> const& interf,int loopDepth) 
	{
															#line 2241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 17757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitRatekeeper.set(false);
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingRatekeeperID = interf.get().id();
															#line 2244 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2245 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", interf.get().id());
															#line 2248 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (ratekeeper.present() && ratekeeper.get().id() != interf.get().id() && self->id_worker.contains(ratekeeper.get().locality.processId()))
															#line 17769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltRatekeeperAfterRecruit", self->id) .detail("RKID", ratekeeper.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2253 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 17775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2255 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!ratekeeper.present() || ratekeeper.get().id() != interf.get().id())
															#line 17779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setRatekeeper(interf.get());
															#line 17783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2259 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 17789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<RatekeeperInterface> && interf,int loopDepth) 
	{
															#line 2241 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 17803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2242 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitRatekeeper.set(false);
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingRatekeeperID = interf.get().id();
															#line 2244 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2245 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCRatekeeperRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("RKID", interf.get().id());
															#line 2248 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (ratekeeper.present() && ratekeeper.get().id() != interf.get().id() && self->id_worker.contains(ratekeeper.get().locality.processId()))
															#line 17815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltRatekeeperAfterRecruit", self->id) .detail("RKID", ratekeeper.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2253 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 17821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2255 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!ratekeeper.present() || ratekeeper.get().id() != interf.get().id())
															#line 17825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2256 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setRatekeeper(interf.get());
															#line 17829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2258 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2259 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartRatekeeperActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRatekeeperActorState(); static_cast<StartRatekeeperActor*>(this)->destroy(); return 0; }
															#line 17835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartRatekeeperActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartRatekeeperActorState();
			static_cast<StartRatekeeperActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<RatekeeperInterface> const& interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(interf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<RatekeeperInterface> && interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(interf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,ErrorOr<RatekeeperInterface> const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,ErrorOr<RatekeeperInterface> && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<StartRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<StartRatekeeperActor*>(this)->ActorCallback< StartRatekeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartRatekeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartRatekeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	double waitTime;
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	bool no_ratekeeper;
															#line 2229 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerDetails worker;
															#line 18028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via startRatekeeper()
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartRatekeeperActor final : public Actor<Void>, public ActorCallback< StartRatekeeperActor, 0, Void >, public ActorCallback< StartRatekeeperActor, 1, Void >, public ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >, public ActorCallback< StartRatekeeperActor, 3, Void >, public FastAllocated<StartRatekeeperActor>, public StartRatekeeperActorState<StartRatekeeperActor> {
															#line 18033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<StartRatekeeperActor>::operator new;
	using FastAllocated<StartRatekeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12421954740040793856UL, 5818062914251346944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartRatekeeperActor, 0, Void >;
friend struct ActorCallback< StartRatekeeperActor, 1, Void >;
friend struct ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >;
friend struct ActorCallback< StartRatekeeperActor, 3, Void >;
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartRatekeeperActor(ClusterControllerData* const& self,double const& waitTime) 
															#line 18053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   StartRatekeeperActorState<StartRatekeeperActor>(self, waitTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRatekeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3469128922560809472UL, 14309449484042826496UL);
		ActorExecutionContextHelper __helper(static_cast<StartRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRatekeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRatekeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartRatekeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartRatekeeperActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartRatekeeperActor, 2, ErrorOr<RatekeeperInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartRatekeeperActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> startRatekeeper( ClusterControllerData* const& self, double const& waitTime ) {
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StartRatekeeperActor(self, waitTime));
															#line 18089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2270 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 18094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorRatekeeper()
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorRatekeeperActor>
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorRatekeeperActorState {
															#line 18101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorRatekeeperActorState(ClusterControllerData* const& self) 
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2272 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   recruitThrottler()
															#line 18110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	~MonitorRatekeeperActorState() 
	{
		fdb_probe_actor_destroy("monitorRatekeeper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2273 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 18125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorRatekeeperActorState();
		static_cast<MonitorRatekeeperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2277 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 18148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2273 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 18164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 1;
															#line 2274 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 0, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 18177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2278 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().ratekeeper.present() && !self->recruitRatekeeper.get())
															#line 18293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitFailureClient(self->db.serverInfo->get().ratekeeper.get().waitFailure, SERVER_KNOBS->RATEKEEPER_FAILURE_TIME);
															#line 2279 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2287 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->recruitRatekeeper.onChange();
															#line 18303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 2;
															#line 2280 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 1, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 2287 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 2, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 18310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2290 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = startRatekeeper(self, recruitThrottler.newRecruitment());
															#line 2290 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 3;
															#line 2290 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorRatekeeperActor, 3, Void >*>(static_cast<MonitorRatekeeperActor*>(this)));
															#line 18324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2283 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRatekeeperDied", self->id).detail("RKID", ratekeeper.get().id());
															#line 2284 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 2285 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::RatekeeperClass);
															#line 18352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2282 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		const auto& ratekeeper = self->db.serverInfo->get().ratekeeper;
															#line 2283 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRatekeeperDied", self->id).detail("RKID", ratekeeper.get().id());
															#line 2284 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		RatekeeperSingleton(ratekeeper).halt(*self, ratekeeper.get().locality.processId());
															#line 2285 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::RatekeeperClass);
															#line 18367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 1, Void >::remove();
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state > 0) static_cast<MonitorRatekeeperActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorRatekeeperActor*>(this)->ActorCallback< MonitorRatekeeperActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorRatekeeperActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorRatekeeperActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2272 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	SingletonRecruitThrottler recruitThrottler;
															#line 18596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorRatekeeper()
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorRatekeeperActor final : public Actor<Void>, public ActorCallback< MonitorRatekeeperActor, 0, Void >, public ActorCallback< MonitorRatekeeperActor, 1, Void >, public ActorCallback< MonitorRatekeeperActor, 2, Void >, public ActorCallback< MonitorRatekeeperActor, 3, Void >, public FastAllocated<MonitorRatekeeperActor>, public MonitorRatekeeperActorState<MonitorRatekeeperActor> {
															#line 18601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorRatekeeperActor>::operator new;
	using FastAllocated<MonitorRatekeeperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3527867660174667008UL, 17868639167821088256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorRatekeeperActor, 0, Void >;
friend struct ActorCallback< MonitorRatekeeperActor, 1, Void >;
friend struct ActorCallback< MonitorRatekeeperActor, 2, Void >;
friend struct ActorCallback< MonitorRatekeeperActor, 3, Void >;
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorRatekeeperActor(ClusterControllerData* const& self) 
															#line 18621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorRatekeeperActorState<MonitorRatekeeperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorRatekeeper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7634142024065878272UL, 15591452298169328640UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorRatekeeperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorRatekeeper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorRatekeeper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorRatekeeperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorRatekeeperActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorRatekeeperActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorRatekeeper( ClusterControllerData* const& self ) {
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorRatekeeperActor(self));
															#line 18656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2294 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 18661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via startConsistencyScan()
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartConsistencyScanActor>
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartConsistencyScanActorState {
															#line 18668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartConsistencyScanActorState(ClusterControllerData* const& self) 
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 18675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("startConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	~StartConsistencyScanActorState() 
	{
		fdb_probe_actor_destroy("startConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0.0);
															#line 2296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 1;
															#line 2296 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartConsistencyScanActor, 0, Void >*>(static_cast<StartConsistencyScanActor*>(this)));
															#line 18697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartConsistencyScanActorState();
		static_cast<StartConsistencyScanActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2297 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartConsistencyScan", self->id).log();
															#line 2298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 18722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2297 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCStartConsistencyScan", self->id).log();
															#line 2298 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 18733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<StartConsistencyScanActor*>(this)->ActorCallback< StartConsistencyScanActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartConsistencyScanActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			no_consistencyScan = !self->db.serverInfo->get().consistencyScan.present();
															#line 2301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 18827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = lowPriorityDelay(SERVER_KNOBS->ATTEMPT_RECRUITMENT_DELAY);
															#line 2359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 4;
															#line 2359 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartConsistencyScanActor, 3, Void >*>(static_cast<StartConsistencyScanActor*>(this)));
															#line 18849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2354 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCConsistencyScanRecruitError", self->id).error(e);
															#line 2355 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (e.code() != error_code_no_more_servers)
															#line 18861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2356 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 18865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 2306 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (no_consistencyScan && self->db.serverInfo->get().consistencyScan.present())
															#line 18881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2308 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartConsistencyScanActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartConsistencyScanActorState(); static_cast<StartConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 18885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartConsistencyScanActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartConsistencyScanActorState();
			static_cast<StartConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2311 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		std::map<Optional<Standalone<StringRef>>, int> id_used = self->getUsedIds();
															#line 2312 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		WorkerFitnessInfo csWorker = self->getWorkerForRoleInDatacenter(self->clusterControllerDcId, ProcessClass::ConsistencyScan, ProcessClass::NeverAssign, self->db.config, id_used);
															#line 2318 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		InitializeConsistencyScanRequest req(deterministicRandom()->randomUniqueID());
															#line 2319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		worker = csWorker.worker;
															#line 2320 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->onMasterIsBetter(worker, ProcessClass::ConsistencyScan))
															#line 18901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2321 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			worker = self->id_worker[self->masterProcessId.get()].details;
															#line 18905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
															#line 2324 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->recruitingConsistencyScanID = req.reqId;
															#line 2325 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCRecruitConsistencyScan", self->id) .detail("Addr", worker.interf.address()) .detail("CSID", req.reqId);
															#line 2329 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<ErrorOr<ConsistencyScanInterface>> __when_expr_2 = worker.interf.consistencyScan.getReplyUnlessFailedFor( req, SERVER_KNOBS->WAIT_FOR_CONSISTENCYSCAN_JOIN_DELAY, 0);
															#line 2329 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 3;
															#line 2329 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >*>(static_cast<StartConsistencyScanActor*>(this)));
															#line 18920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2301 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(!self->masterProcessId.present() || self->masterProcessId != self->db.serverInfo->get().master.locality.processId() || self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 18936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->db.serverInfo->onChange() || delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 2;
															#line 2304 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartConsistencyScanActor, 1, Void >*>(static_cast<StartConsistencyScanActor*>(this)));
															#line 18949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<StartConsistencyScanActor*>(this)->ActorCallback< StartConsistencyScanActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartConsistencyScanActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(ErrorOr<ConsistencyScanInterface> const& interf,int loopDepth) 
	{
															#line 2331 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 19058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitConsistencyScan.set(false);
															#line 2333 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingConsistencyScanID = interf.get().id();
															#line 2334 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& consistencyScan = self->db.serverInfo->get().consistencyScan;
															#line 2335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCConsistencyScanRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("CKID", interf.get().id());
															#line 2338 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (consistencyScan.present() && consistencyScan.get().id() != interf.get().id() && self->id_worker.contains(consistencyScan.get().locality.processId()))
															#line 19070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltConsistencyScanAfterRecruit", self->id) .detail("CKID", consistencyScan.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ConsistencyScanSingleton(consistencyScan).halt(*self, consistencyScan.get().locality.processId());
															#line 19076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2345 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!consistencyScan.present() || consistencyScan.get().id() != interf.get().id())
															#line 19080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2346 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setConsistencyScan(interf.get());
															#line 19084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartConsistencyScanActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartConsistencyScanActorState(); static_cast<StartConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 19090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartConsistencyScanActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartConsistencyScanActorState();
			static_cast<StartConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 2351 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCConsistencyScanRecruitEmpty", self->id).log();
															#line 19100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(ErrorOr<ConsistencyScanInterface> && interf,int loopDepth) 
	{
															#line 2331 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (interf.present())
															#line 19110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitConsistencyScan.set(false);
															#line 2333 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			self->recruitingConsistencyScanID = interf.get().id();
															#line 2334 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			const auto& consistencyScan = self->db.serverInfo->get().consistencyScan;
															#line 2335 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCConsistencyScanRecruited", self->id) .detail("Addr", worker.interf.address()) .detail("CKID", interf.get().id());
															#line 2338 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (consistencyScan.present() && consistencyScan.get().id() != interf.get().id() && self->id_worker.contains(consistencyScan.get().locality.processId()))
															#line 19122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				TraceEvent("CCHaltConsistencyScanAfterRecruit", self->id) .detail("CKID", consistencyScan.get().id()) .detail("DcID", printable(self->clusterControllerDcId));
															#line 2343 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				ConsistencyScanSingleton(consistencyScan).halt(*self, consistencyScan.get().locality.processId());
															#line 19128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2345 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!consistencyScan.present() || consistencyScan.get().id() != interf.get().id())
															#line 19132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			{
															#line 2346 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
				self->db.setConsistencyScan(interf.get());
															#line 19136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			}
															#line 2348 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			checkOutstandingRequests(self);
															#line 2349 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (!static_cast<StartConsistencyScanActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartConsistencyScanActorState(); static_cast<StartConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 19142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			new (&static_cast<StartConsistencyScanActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartConsistencyScanActorState();
			static_cast<StartConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 2351 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCConsistencyScanRecruitEmpty", self->id).log();
															#line 19152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<ConsistencyScanInterface> const& interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(interf, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ErrorOr<ConsistencyScanInterface> && interf,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(interf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<StartConsistencyScanActor*>(this)->ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >*,ErrorOr<ConsistencyScanInterface> const& value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >*,ErrorOr<ConsistencyScanInterface> && value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<StartConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<StartConsistencyScanActor*>(this)->ActorCallback< StartConsistencyScanActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartConsistencyScanActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartConsistencyScanActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2300 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	bool no_consistencyScan;
															#line 2319 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	WorkerDetails worker;
															#line 19339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via startConsistencyScan()
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartConsistencyScanActor final : public Actor<Void>, public ActorCallback< StartConsistencyScanActor, 0, Void >, public ActorCallback< StartConsistencyScanActor, 1, Void >, public ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >, public ActorCallback< StartConsistencyScanActor, 3, Void >, public FastAllocated<StartConsistencyScanActor>, public StartConsistencyScanActorState<StartConsistencyScanActor> {
															#line 19344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<StartConsistencyScanActor>::operator new;
	using FastAllocated<StartConsistencyScanActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10545248016806775040UL, 8916130763612977152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartConsistencyScanActor, 0, Void >;
friend struct ActorCallback< StartConsistencyScanActor, 1, Void >;
friend struct ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >;
friend struct ActorCallback< StartConsistencyScanActor, 3, Void >;
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartConsistencyScanActor(ClusterControllerData* const& self) 
															#line 19364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   StartConsistencyScanActorState<StartConsistencyScanActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startConsistencyScan", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(613462905251718400UL, 4615923531578201856UL);
		ActorExecutionContextHelper __helper(static_cast<StartConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startConsistencyScan");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startConsistencyScan", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartConsistencyScanActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartConsistencyScanActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartConsistencyScanActor, 2, ErrorOr<ConsistencyScanInterface> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartConsistencyScanActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> startConsistencyScan( ClusterControllerData* const& self ) {
															#line 2295 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new StartConsistencyScanActor(self));
															#line 19400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2362 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 19405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorConsistencyScan()
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class MonitorConsistencyScanActor>
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorConsistencyScanActorState {
															#line 19412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorConsistencyScanActorState(ClusterControllerData* const& self) 
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self)
															#line 19419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	~MonitorConsistencyScanActorState() 
	{
		fdb_probe_actor_destroy("monitorConsistencyScan", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 19434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorConsistencyScanActorState();
		static_cast<MonitorConsistencyScanActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2368 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCMonitorConsistencyScan", self->id).log();
															#line 2369 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 19459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2364 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (!(self->db.serverInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 19475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2365 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCMonitorConsistencyScanWaitingForRecovery", self->id).log();
															#line 2366 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->db.serverInfo->onChange();
															#line 2366 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state = 1;
															#line 2366 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyScanActor, 0, Void >*>(static_cast<MonitorConsistencyScanActor*>(this)));
															#line 19490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyScanActor*>(this)->ActorCallback< MonitorConsistencyScanActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyScanActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2370 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		if (self->db.serverInfo->get().consistencyScan.present() && !self->recruitConsistencyScan.get())
															#line 19606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		{
															#line 2371 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			wfClient = waitFailureClient(self->db.serverInfo->get().consistencyScan.get().waitFailure, SERVER_KNOBS->CONSISTENCYSCAN_FAILURE_TIME);
															#line 2375 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = wfClient;
															#line 2374 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 2380 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->recruitConsistencyScan.onChange();
															#line 19618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state = 2;
															#line 2375 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyScanActor, 1, Void >*>(static_cast<MonitorConsistencyScanActor*>(this)));
															#line 2380 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyScanActor, 2, Void >*>(static_cast<MonitorConsistencyScanActor*>(this)));
															#line 19625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2383 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			TraceEvent("CCMonitorConsistencyScanStarting", self->id).log();
															#line 2384 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = startConsistencyScan(self);
															#line 2384 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 19636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state = 3;
															#line 2384 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorConsistencyScanActor, 3, Void >*>(static_cast<MonitorConsistencyScanActor*>(this)));
															#line 19641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCMonitorConsistencyScanDied", self->id) .detail("CKID", self->db.serverInfo->get().consistencyScan.get().id());
															#line 2378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::ConsistencyScanClass);
															#line 19665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCMonitorConsistencyScanDied", self->id) .detail("CKID", self->db.serverInfo->get().consistencyScan.get().id());
															#line 2378 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		self->db.clearInterf(ProcessClass::ConsistencyScanClass);
															#line 19676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyScanActor*>(this)->ActorCallback< MonitorConsistencyScanActor, 1, Void >::remove();
		static_cast<MonitorConsistencyScanActor*>(this)->ActorCallback< MonitorConsistencyScanActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyScanActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyScanActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<MonitorConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorConsistencyScanActor*>(this)->ActorCallback< MonitorConsistencyScanActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorConsistencyScanActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorConsistencyScanActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	ClusterControllerData* self;
															#line 2371 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	Future<Void> wfClient;
															#line 19905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
};
// This generated class is to be used only via monitorConsistencyScan()
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class MonitorConsistencyScanActor final : public Actor<Void>, public ActorCallback< MonitorConsistencyScanActor, 0, Void >, public ActorCallback< MonitorConsistencyScanActor, 1, Void >, public ActorCallback< MonitorConsistencyScanActor, 2, Void >, public ActorCallback< MonitorConsistencyScanActor, 3, Void >, public FastAllocated<MonitorConsistencyScanActor>, public MonitorConsistencyScanActorState<MonitorConsistencyScanActor> {
															#line 19910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
	using FastAllocated<MonitorConsistencyScanActor>::operator new;
	using FastAllocated<MonitorConsistencyScanActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9933804340923084032UL, 14241403503887377920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorConsistencyScanActor, 0, Void >;
friend struct ActorCallback< MonitorConsistencyScanActor, 1, Void >;
friend struct ActorCallback< MonitorConsistencyScanActor, 2, Void >;
friend struct ActorCallback< MonitorConsistencyScanActor, 3, Void >;
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	MonitorConsistencyScanActor(ClusterControllerData* const& self) 
															#line 19930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorConsistencyScanActorState<MonitorConsistencyScanActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5148556312845369344UL, 11188601171742045952UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorConsistencyScan");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorConsistencyScan", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorConsistencyScanActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorConsistencyScanActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorConsistencyScanActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
[[nodiscard]] Future<Void> monitorConsistencyScan( ClusterControllerData* const& self ) {
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	return Future<Void>(new MonitorConsistencyScanActor(self));
															#line 19965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
}

#line 2388 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"

															#line 19970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
namespace {
// This generated class is to be used only via startEncryptKeyProxy()
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
template <class StartEncryptKeyProxyActor>
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
class StartEncryptKeyProxyActorState {
															#line 19977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
public:
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
	StartEncryptKeyProxyActorState(ClusterControllerData* const& self,EncryptionAtRestMode const& encryptMode) 
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		 : self(self),
															#line 2389 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		   encryptMode(encryptMode)
															#line 19986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
	{
		fdb_probe_actor_create("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this));

	}
	~StartEncryptKeyProxyActorState() 
	{
		fdb_probe_actor_destroy("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0.0);
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			if (static_cast<StartEncryptKeyProxyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartEncryptKeyProxyActor*>(this)->actor_wait_state = 1;
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartEncryptKeyProxyActor, 0, Void >*>(static_cast<StartEncryptKeyProxyActor*>(this)));
															#line 20008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartEncryptKeyProxyActorState();
		static_cast<StartEncryptKeyProxyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2393 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCEKP_Start", self->id).log();
															#line 2394 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 20033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2393 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		TraceEvent("CCEKP_Start", self->id).log();
															#line 2394 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
		;
															#line 20044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartEncryptKeyProxyActor*>(this)->actor_wait_state > 0) static_cast<StartEncryptKeyProxyActor*>(this)->actor_wait_state = 0;
		static_cast<StartEncryptKeyProxyActor*>(this)->ActorCallback< StartEncryptKeyProxyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartEncryptKeyProxyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartEncryptKeyProxyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartEncryptKeyProxyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartEncryptKeyProxyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartEncryptKeyProxyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartEncryptKeyProxyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startEncryptKeyProxy", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 2398 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			noEncryptKeyServer = !self->db.serverInfo->get().client.encryptKeyProxy.present();
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/ClusterController.actor.cpp"
			;
															#line 20138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ClusterController.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															