#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
/*
 * RegisterCluster.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_REGISTERCLUSTER_ACTOR_G_H)
#define METACLUSTER_REGISTERCLUSTER_ACTOR_G_H
#include "metacluster/RegisterCluster.actor.g.h"
#elif !defined(METACLUSTER_REGISTERCLUSTER_ACTOR_H)
#define METACLUSTER_REGISTERCLUSTER_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterOperationContext.actor.h"
#include "metacluster/MetaclusterTypes.h"
#include "metacluster/MetaclusterUtil.actor.h"
#include "metacluster/RemoveCluster.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

namespace internal {
template <class DB>
struct RegisterClusterImpl {
	MetaclusterOperationContext<DB> ctx;

	// Initialization parameters
	ClusterName clusterName;
	ClusterConnectionString connectionString;
	DataClusterEntry clusterEntry;

	// Loaded from the management cluster
	int64_t tenantIdPrefix;

	RegisterClusterImpl(Reference<DB> managementDb,
	                    ClusterName clusterName,
	                    ClusterConnectionString connectionString,
	                    DataClusterEntry clusterEntry)
	  : ctx(managementDb), clusterName(clusterName), connectionString(connectionString), clusterEntry(clusterEntry) {}

	// Store the cluster entry for the new cluster in a registering state
																#line 63 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
// This generated class is to be used only via registerInManagementCluster()
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
template <class RegisterInManagementClusterActor>
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class RegisterInManagementClusterActorState {
															#line 69 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterInManagementClusterActorState(RegisterClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		 : self(self),
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   tr(tr),
															#line 63 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   tenantIdPrefixFuture(TenantMetadata::tenantIdPrefix().get(tr))
															#line 80 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
	{
		fdb_probe_actor_create("registerInManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~RegisterInManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("registerInManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 64 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Optional<DataClusterMetadata>> __when_expr_0 = tryGetClusterTransaction(tr, self->clusterName);
															#line 64 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 97 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 64 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*>(static_cast<RegisterInManagementClusterActor*>(this)));
															#line 102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterInManagementClusterActorState();
		static_cast<RegisterInManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 65 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!dataClusterMetadata.present())
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 66 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Register new cluster");
															#line 67 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			self->clusterEntry.clusterState = DataClusterState::REGISTERING;
															#line 68 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			self->clusterEntry.allocated = ClusterUsage();
															#line 69 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			self->clusterEntry.id = deterministicRandom()->randomUniqueID();
															#line 73 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			metadata::activeRestoreIds().erase(tr, self->clusterName);
															#line 75 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			metadata::management::dataClusters().set(tr, self->clusterName, self->clusterEntry);
															#line 76 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			metadata::management::dataClusterConnectionRecords().set(tr, self->clusterName, self->connectionString);
															#line 141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
		else
		{
															#line 77 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (dataClusterMetadata.get().entry.clusterState == DataClusterState::REMOVING)
															#line 147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			{
															#line 78 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				CODE_PROBE(true, "Registering cluster being removed");
															#line 79 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				return a_body1Catch1(cluster_removed(), loopDepth);
															#line 153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			}
			else
			{
															#line 80 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				if (!dataClusterMetadata.get().matchesConfiguration( DataClusterMetadata(self->clusterEntry, self->connectionString)) || dataClusterMetadata.get().entry.clusterState != DataClusterState::REGISTERING)
															#line 159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
				{
															#line 83 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
					CODE_PROBE(true, "Cluster already exists");
															#line 84 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
					return a_body1Catch1(cluster_already_exists(), loopDepth);
															#line 165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
				}
				else
				{
															#line 86 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
					CODE_PROBE(true, "Retrying cluster registration");
															#line 87 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
					self->clusterEntry = dataClusterMetadata.get().entry;
															#line 173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
				}
			}
		}
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<Optional<int64_t>> __when_expr_1 = tenantIdPrefixFuture;
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >*>(static_cast<RegisterInManagementClusterActor*>(this)));
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> const& __dataClusterMetadata,int loopDepth) 
	{
															#line 64 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		dataClusterMetadata = __dataClusterMetadata;
															#line 195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> && __dataClusterMetadata,int loopDepth) 
	{
		dataClusterMetadata = std::move(__dataClusterMetadata);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterInManagementClusterActor*>(this)->ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<int64_t> const& tenantIdPrefix,int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		ASSERT(tenantIdPrefix.present());
															#line 93 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		self->tenantIdPrefix = tenantIdPrefix.get();
															#line 95 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TraceEvent("RegisteringDataCluster") .detail("ClusterName", self->clusterName) .detail("ClusterID", self->clusterEntry.id) .detail("Capacity", self->clusterEntry.capacity) .detail("ConnectionString", self->connectionString.toString()) .detail("AutoTenantAssignment", DataClusterEntry::autoTenantAssignmentToString(self->clusterEntry.autoTenantAssignment));
															#line 103 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<RegisterInManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterInManagementClusterActorState(); static_cast<RegisterInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<RegisterInManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterInManagementClusterActorState();
		static_cast<RegisterInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<int64_t> && tenantIdPrefix,int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		ASSERT(tenantIdPrefix.present());
															#line 93 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		self->tenantIdPrefix = tenantIdPrefix.get();
															#line 95 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TraceEvent("RegisteringDataCluster") .detail("ClusterName", self->clusterName) .detail("ClusterID", self->clusterEntry.id) .detail("Capacity", self->clusterEntry.capacity) .detail("ConnectionString", self->connectionString.toString()) .detail("AutoTenantAssignment", DataClusterEntry::autoTenantAssignmentToString(self->clusterEntry.autoTenantAssignment));
															#line 103 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<RegisterInManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterInManagementClusterActorState(); static_cast<RegisterInManagementClusterActor*>(this)->destroy(); return 0; }
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<RegisterInManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterInManagementClusterActorState();
		static_cast<RegisterInManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<int64_t> const& tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont2(tenantIdPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<int64_t> && tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(tenantIdPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterInManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterInManagementClusterActor*>(this)->ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerInManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterClusterImpl* self;
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 63 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Future<Optional<int64_t>> tenantIdPrefixFuture;
															#line 64 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Optional<DataClusterMetadata> dataClusterMetadata;
															#line 389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
};
// This generated class is to be used only via registerInManagementCluster()
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class RegisterInManagementClusterActor final : public Actor<Void>, public ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >, public ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >, public FastAllocated<RegisterInManagementClusterActor>, public RegisterInManagementClusterActorState<RegisterInManagementClusterActor> {
															#line 394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
	using FastAllocated<RegisterInManagementClusterActor>::operator new;
	using FastAllocated<RegisterInManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12623713788303852800UL, 10601106470354645248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >;
friend struct ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >;
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterInManagementClusterActor(RegisterClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		 : Actor<Void>(),
		   RegisterInManagementClusterActorState<RegisterInManagementClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerInManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10172767138303635712UL, 327575561513112320UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterInManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerInManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerInManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterInManagementClusterActor, 0, Optional<DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegisterInManagementClusterActor, 1, Optional<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
[[nodiscard]] static Future<Void> registerInManagementCluster( RegisterClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	return Future<Void>(new RegisterInManagementClusterActor(self, tr));
															#line 445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
}

#line 105 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"

																#line 450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
// This generated class is to be used only via configureDataCluster()
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
template <class ConfigureDataClusterActor>
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class ConfigureDataClusterActorState {
															#line 456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	ConfigureDataClusterActorState(RegisterClusterImpl* const& self) 
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		 : self(self)
															#line 463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
	{
		fdb_probe_actor_create("configureDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureDataClusterActorState() 
	{
		fdb_probe_actor_destroy("configureDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 107 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = util::openDatabase(self->connectionString);
															#line 107 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 1;
															#line 107 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureDataClusterActorState();
		static_cast<ConfigureDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		tr = dataClusterDb->createTransaction();
															#line 109 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		;
															#line 510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& __dataClusterDb,int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		dataClusterDb = __dataClusterDb;
															#line 519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && __dataClusterDb,int loopDepth) 
	{
		dataClusterDb = std::move(__dataClusterDb);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureDataClusterActor*>(this)->ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 111 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 113 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			existingTenantsFuture = TenantAPI::listTenantsTransaction(tr, ""_sr, "\xff\xff"_sr, 1);
															#line 115 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			existingDataFuture = tr->getRange(normalKeys, 1);
															#line 116 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			tombstoneFuture = metadata::registrationTombstones().exists(tr, self->clusterEntry.id);
															#line 120 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_1 = metadata::metaclusterRegistration().get(tr);
															#line 120 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 2;
															#line 120 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 186 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Void> __when_expr_6 = safeThreadFutureToFuture(tr->onError(e));
															#line 186 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 7;
															#line 186 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 6, Void >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (existingRegistration.present())
															#line 665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (existingRegistration.get().clusterType != ClusterType::METACLUSTER_DATA || existingRegistration.get().name != self->clusterName || !existingRegistration.get().matches(self->ctx.metaclusterRegistration.get()) || existingRegistration.get().id != self->clusterEntry.id)
															#line 669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			{
															#line 127 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				CODE_PROBE(true, "Cluster already registered during data cluster configuration");
															#line 128 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				return a_body1cont1loopBody1Catch1(cluster_already_registered(), loopDepth);
															#line 675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			}
			else
			{
															#line 132 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				CODE_PROBE(true, "Cluster registration already done on data cluster");
															#line 133 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				if (!static_cast<ConfigureDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureDataClusterActorState(); static_cast<ConfigureDataClusterActor*>(this)->destroy(); return 0; }
															#line 683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
				new (&static_cast<ConfigureDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ConfigureDataClusterActorState();
				static_cast<ConfigureDataClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 138 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<bool> __when_expr_2 = tombstoneFuture;
															#line 138 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 3;
															#line 138 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 2, bool >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& __existingRegistration,int loopDepth) 
	{
															#line 120 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		existingRegistration = __existingRegistration;
															#line 708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<MetaclusterRegistrationEntry> && __existingRegistration,int loopDepth) 
	{
		existingRegistration = std::move(__existingRegistration);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureDataClusterActor*>(this)->ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(bool const& tombstone,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (tombstone)
															#line 787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 140 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Registering cluster removed");
															#line 141 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
															#line 145 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<std::vector<std::pair<TenantName, int64_t>>> __when_expr_3 = safeThreadFutureToFuture(existingTenantsFuture);
															#line 145 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 4;
															#line 145 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(bool && tombstone,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (tombstone)
															#line 813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 140 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Registering cluster removed");
															#line 141 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
															#line 145 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<std::vector<std::pair<TenantName, int64_t>>> __when_expr_3 = safeThreadFutureToFuture(existingTenantsFuture);
															#line 145 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 4;
															#line 145 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(bool const& tombstone,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(tombstone, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(bool && tombstone,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(tombstone), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureDataClusterActor*>(this)->ActorCallback< ConfigureDataClusterActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureDataClusterActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont7(std::vector<std::pair<TenantName, int64_t>> const& existingTenants,int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!existingTenants.empty())
															#line 914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 148 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Registering cluster with tenants");
															#line 149 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			TraceEvent(SevWarn, "CannotRegisterClusterWithTenants").detail("ClusterName", self->clusterName);
															#line 150 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_not_empty(), loopDepth);
															#line 922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
															#line 153 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<RangeResult> __when_expr_4 = safeThreadFutureToFuture(existingDataFuture);
															#line 153 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 5;
															#line 153 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 4, RangeResult >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(std::vector<std::pair<TenantName, int64_t>> && existingTenants,int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!existingTenants.empty())
															#line 942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 148 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Registering cluster with tenants");
															#line 149 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			TraceEvent(SevWarn, "CannotRegisterClusterWithTenants").detail("ClusterName", self->clusterName);
															#line 150 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_not_empty(), loopDepth);
															#line 950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
															#line 153 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<RangeResult> __when_expr_4 = safeThreadFutureToFuture(existingDataFuture);
															#line 153 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 5;
															#line 153 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 4, RangeResult >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::vector<std::pair<TenantName, int64_t>> const& existingTenants,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(existingTenants, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::vector<std::pair<TenantName, int64_t>> && existingTenants,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont7(std::move(existingTenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureDataClusterActor*>(this)->ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> const& value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> && value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont9(RangeResult const& existingData,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!existingData.empty())
															#line 1045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 155 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Registering cluster with data", probe::decoration::rare);
															#line 156 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			TraceEvent(SevWarn, "CannotRegisterClusterWithData").detail("ClusterName", self->clusterName);
															#line 157 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_not_empty(), loopDepth);
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
															#line 160 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		metadata::metaclusterRegistration().set( tr, self->ctx.metaclusterRegistration.get().toDataClusterRegistration(self->clusterName, self->clusterEntry.id));
															#line 165 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TenantMetadata::tenantIdPrefix().set(tr, self->tenantIdPrefix);
															#line 169 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TenantMetadata::lastTenantId().clear(tr);
															#line 173 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		metadata::activeRestoreIds().clear(tr);
															#line 175 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<Void> __when_expr_5 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 175 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 6;
															#line 175 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 5, Void >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(RangeResult && existingData,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!existingData.empty())
															#line 1081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 155 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Registering cluster with data", probe::decoration::rare);
															#line 156 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			TraceEvent(SevWarn, "CannotRegisterClusterWithData").detail("ClusterName", self->clusterName);
															#line 157 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			return a_body1cont1loopBody1Catch1(cluster_not_empty(), loopDepth);
															#line 1089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
															#line 160 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		metadata::metaclusterRegistration().set( tr, self->ctx.metaclusterRegistration.get().toDataClusterRegistration(self->clusterName, self->clusterEntry.id));
															#line 165 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TenantMetadata::tenantIdPrefix().set(tr, self->tenantIdPrefix);
															#line 169 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TenantMetadata::lastTenantId().clear(tr);
															#line 173 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		metadata::activeRestoreIds().clear(tr);
															#line 175 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<Void> __when_expr_5 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 175 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 6;
															#line 175 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConfigureDataClusterActor, 5, Void >*>(static_cast<ConfigureDataClusterActor*>(this)));
															#line 1108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(RangeResult const& existingData,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(existingData, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7when1(RangeResult && existingData,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(existingData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureDataClusterActor*>(this)->ActorCallback< ConfigureDataClusterActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConfigureDataClusterActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 177 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TraceEvent("ConfiguredDataCluster") .detail("ClusterName", self->clusterName) .detail("ClusterID", self->clusterEntry.id) .detail("Capacity", self->clusterEntry.capacity) .detail("Version", tr->getCommittedVersion()) .detail("ConnectionString", self->connectionString.toString());
															#line 184 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<ConfigureDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureDataClusterActorState(); static_cast<ConfigureDataClusterActor*>(this)->destroy(); return 0; }
															#line 1194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<ConfigureDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureDataClusterActorState();
		static_cast<ConfigureDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 177 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TraceEvent("ConfiguredDataCluster") .detail("ClusterName", self->clusterName) .detail("ClusterID", self->clusterEntry.id) .detail("Capacity", self->clusterEntry.capacity) .detail("Version", tr->getCommittedVersion()) .detail("ConnectionString", self->connectionString.toString());
															#line 184 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<ConfigureDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureDataClusterActorState(); static_cast<ConfigureDataClusterActor*>(this)->destroy(); return 0; }
															#line 1208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<ConfigureDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureDataClusterActorState();
		static_cast<ConfigureDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureDataClusterActor*>(this)->ActorCallback< ConfigureDataClusterActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ConfigureDataClusterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureDataClusterActor*>(this)->ActorCallback< ConfigureDataClusterActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ConfigureDataClusterActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ConfigureDataClusterActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterClusterImpl* self;
															#line 107 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Reference<IDatabase> dataClusterDb;
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Reference<ITransaction> tr;
															#line 113 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Future<std::vector<std::pair<TenantName, int64_t>>> existingTenantsFuture;
															#line 115 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	ThreadFuture<RangeResult> existingDataFuture;
															#line 116 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Future<bool> tombstoneFuture;
															#line 120 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Optional<MetaclusterRegistrationEntry> existingRegistration;
															#line 1392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
};
// This generated class is to be used only via configureDataCluster()
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class ConfigureDataClusterActor final : public Actor<Void>, public ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >, public ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< ConfigureDataClusterActor, 2, bool >, public ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >, public ActorCallback< ConfigureDataClusterActor, 4, RangeResult >, public ActorCallback< ConfigureDataClusterActor, 5, Void >, public ActorCallback< ConfigureDataClusterActor, 6, Void >, public FastAllocated<ConfigureDataClusterActor>, public ConfigureDataClusterActorState<ConfigureDataClusterActor> {
															#line 1397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
	using FastAllocated<ConfigureDataClusterActor>::operator new;
	using FastAllocated<ConfigureDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9131872543083717888UL, 18094596975699028224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< ConfigureDataClusterActor, 2, bool >;
friend struct ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >;
friend struct ActorCallback< ConfigureDataClusterActor, 4, RangeResult >;
friend struct ActorCallback< ConfigureDataClusterActor, 5, Void >;
friend struct ActorCallback< ConfigureDataClusterActor, 6, Void >;
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	ConfigureDataClusterActor(RegisterClusterImpl* const& self) 
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		 : Actor<Void>(),
		   ConfigureDataClusterActorState<ConfigureDataClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15217109210993218560UL, 5607141198346292480UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureDataClusterActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureDataClusterActor, 1, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureDataClusterActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigureDataClusterActor, 3, std::vector<std::pair<TenantName, int64_t>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConfigureDataClusterActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ConfigureDataClusterActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ConfigureDataClusterActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
[[nodiscard]] static Future<Void> configureDataCluster( RegisterClusterImpl* const& self ) {
															#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	return Future<Void>(new ConfigureDataClusterActor(self));
															#line 1458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
}

#line 190 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"

	// Store the cluster entry for the new cluster
																#line 1464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
// This generated class is to be used only via markClusterReady()
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
template <class MarkClusterReadyActor>
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class MarkClusterReadyActorState {
															#line 1470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	MarkClusterReadyActorState(RegisterClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		 : self(self),
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   tr(tr)
															#line 1479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
	{
		fdb_probe_actor_create("markClusterReady", reinterpret_cast<unsigned long>(this));

	}
	~MarkClusterReadyActorState() 
	{
		fdb_probe_actor_destroy("markClusterReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 193 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Optional<DataClusterMetadata>> __when_expr_0 = tryGetClusterTransaction(tr, self->clusterName);
															#line 193 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<MarkClusterReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkClusterReadyActor*>(this)->actor_wait_state = 1;
															#line 193 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >*>(static_cast<MarkClusterReadyActor*>(this)));
															#line 1501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkClusterReadyActorState();
		static_cast<MarkClusterReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 194 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!dataClusterMetadata.present() || dataClusterMetadata.get().entry.clusterState == DataClusterState::REMOVING)
															#line 1524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		{
															#line 196 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			CODE_PROBE(true, "Registering cluster removed");
															#line 197 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			return a_body1Catch1(cluster_removed(), loopDepth);
															#line 1530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		}
		else
		{
															#line 198 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (dataClusterMetadata.get().entry.id != self->clusterEntry.id)
															#line 1536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			{
															#line 199 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				CODE_PROBE(true, "Registering cluster exists with different ID");
															#line 200 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				return a_body1Catch1(cluster_already_exists(), loopDepth);
															#line 1542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			}
			else
			{
															#line 201 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				if (dataClusterMetadata.get().entry.clusterState == DataClusterState::READY)
															#line 1548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
				{
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
					CODE_PROBE(true, "Registering cluster already ready");
															#line 203 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
					if (!static_cast<MarkClusterReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkClusterReadyActorState(); static_cast<MarkClusterReadyActor*>(this)->destroy(); return 0; }
															#line 1554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
					new (&static_cast<MarkClusterReadyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~MarkClusterReadyActorState();
					static_cast<MarkClusterReadyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 204 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
					if (dataClusterMetadata.get().entry.clusterState == DataClusterState::RESTORING)
															#line 1564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
					{
															#line 205 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
						CODE_PROBE(true, "Registering cluster restoring");
															#line 206 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
						return a_body1Catch1(cluster_restoring(), loopDepth);
															#line 1570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
					}
					else
					{
															#line 208 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
						ASSERT(dataClusterMetadata.get().entry.clusterState == DataClusterState::REGISTERING);
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
						dataClusterMetadata.get().entry.clusterState = DataClusterState::READY;
															#line 211 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
						if (dataClusterMetadata.get().entry.hasCapacity() && dataClusterMetadata.get().entry.autoTenantAssignment == AutoTenantAssignment::ENABLED)
															#line 1580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
						{
															#line 213 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
							metadata::management::clusterCapacityIndex().insert( tr, Tuple::makeTuple(dataClusterMetadata.get().entry.allocated.numTenantGroups, self->clusterName));
															#line 1584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
						}
															#line 216 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
						metadata::management::dataClusters().set(tr, self->clusterName, dataClusterMetadata.get().entry);
															#line 217 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
						metadata::management::dataClusterConnectionRecords().set(tr, self->clusterName, self->connectionString);
															#line 1590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
					}
				}
			}
		}
															#line 220 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TraceEvent("RegisteredDataCluster") .detail("ClusterName", self->clusterName) .detail("ClusterID", self->clusterEntry.id) .detail("Capacity", dataClusterMetadata.get().entry.capacity) .detail("ConnectionString", self->connectionString.toString()) .detail("AutoTenantAssignment", DataClusterEntry::autoTenantAssignmentToString(self->clusterEntry.autoTenantAssignment));
															#line 228 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<MarkClusterReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkClusterReadyActorState(); static_cast<MarkClusterReadyActor*>(this)->destroy(); return 0; }
															#line 1599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<MarkClusterReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkClusterReadyActorState();
		static_cast<MarkClusterReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> const& __dataClusterMetadata,int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		dataClusterMetadata = __dataClusterMetadata;
															#line 1611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<DataClusterMetadata> && __dataClusterMetadata,int loopDepth) 
	{
		dataClusterMetadata = std::move(__dataClusterMetadata);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkClusterReadyActor*>(this)->actor_wait_state > 0) static_cast<MarkClusterReadyActor*>(this)->actor_wait_state = 0;
		static_cast<MarkClusterReadyActor*>(this)->ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("markClusterReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >*,Optional<DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("markClusterReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("markClusterReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterClusterImpl* self;
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 193 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Optional<DataClusterMetadata> dataClusterMetadata;
															#line 1692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
};
// This generated class is to be used only via markClusterReady()
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class MarkClusterReadyActor final : public Actor<Void>, public ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >, public FastAllocated<MarkClusterReadyActor>, public MarkClusterReadyActorState<MarkClusterReadyActor> {
															#line 1697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
	using FastAllocated<MarkClusterReadyActor>::operator new;
	using FastAllocated<MarkClusterReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5773860497095113984UL, 5267895773095313408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >;
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	MarkClusterReadyActor(RegisterClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		 : Actor<Void>(),
		   MarkClusterReadyActorState<MarkClusterReadyActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markClusterReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1859648566809907968UL, 7477753228342352384UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markClusterReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markClusterReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkClusterReadyActor, 0, Optional<DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
[[nodiscard]] static Future<Void> markClusterReady( RegisterClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	return Future<Void>(new MarkClusterReadyActor(self, tr));
															#line 1746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
}

#line 230 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"

																#line 1751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
// This generated class is to be used only via run()
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
template <class RunActor>
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class RunActorState {
															#line 1757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RunActorState(RegisterClusterImpl* const& self) 
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		 : self(self),
															#line 233 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   removeCluster(self->ctx.managementDb, self->clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True, 5.0)
															#line 1766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 239 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (self->clusterName.startsWith("\xff"_sr))
															#line 1781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			{
															#line 240 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				CODE_PROBE(true, "Registering cluster with invalid name");
															#line 241 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				return a_body1Catch1(invalid_cluster_name(), loopDepth);
															#line 1787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			}
															#line 244 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return registerInManagementCluster(self, tr); });
															#line 244 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 244 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 1798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 250 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = configureDataCluster(self);
															#line 250 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 250 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 250 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = configureDataCluster(self);
															#line 250 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 250 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 274 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		StrictFuture<Void> __when_expr_3 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return markClusterReady(self, tr); });
															#line 274 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 4;
															#line 274 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunActor, 3, Void >*>(static_cast<RunActor*>(this)));
															#line 1949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 252 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			error = e;
															#line 1959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			try {
															#line 257 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				CODE_PROBE(true, "Rollback cluster registration");
															#line 258 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				removeCluster.clusterId = self->clusterEntry.id;
															#line 259 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				removeCluster.legalClusterStates.insert(DataClusterState::REGISTERING);
															#line 260 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				StrictFuture<Void> __when_expr_2 = removeCluster.run();
															#line 260 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 1971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 260 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 1976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1cont1(int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		return a_body1Catch1(error, loopDepth);
															#line 2097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"

		return loopDepth;
	}
	int a_body1cont1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 267 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			TraceEvent(SevWarn, "RegisterClusterRollbackFailed") .detail("ClusterName", self->clusterName) .detail("ConnectionString", self->connectionString.toString());
															#line 2106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = a_body1cont1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 261 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TraceEvent("RegisterClusterRolledBack") .detail("ClusterName", self->clusterName) .detail("ConnectionString", self->connectionString.toString());
															#line 2121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = a_body1cont1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 261 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		TraceEvent("RegisterClusterRolledBack") .detail("ClusterName", self->clusterName) .detail("ConnectionString", self->connectionString.toString());
															#line 2130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		loopDepth = a_body1cont1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1Catch1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 277 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 277 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterClusterImpl* self;
															#line 233 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	internal::RemoveClusterImpl<DB> removeCluster;
															#line 252 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Error error;
															#line 2328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
};
// This generated class is to be used only via run()
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, Void >, public ActorCallback< RunActor, 2, Void >, public ActorCallback< RunActor, 3, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 2333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14844221249816692992UL, 508665548856513280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, Void >;
friend struct ActorCallback< RunActor, 2, Void >;
friend struct ActorCallback< RunActor, 3, Void >;
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RunActor(RegisterClusterImpl* const& self) 
															#line 2353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
[[nodiscard]] static Future<Void> run( RegisterClusterImpl* const& self ) {
															#line 231 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	return Future<Void>(new RunActor(self));
															#line 2388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
}

#line 279 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Future<Void> run() { return run(this); }
};
} // namespace internal

															#line 2396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
// This generated class is to be used only via registerCluster()
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
template <class DB, class RegisterClusterActor>
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class RegisterClusterActorState {
															#line 2402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterClusterActorState(Reference<DB> const& db,ClusterName const& name,ClusterConnectionString const& connectionString,DataClusterEntry const& entry) 
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		 : db(db),
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   name(name),
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   connectionString(connectionString),
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   entry(entry),
															#line 288 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		   impl(db, name, connectionString, entry)
															#line 2417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
	{
		fdb_probe_actor_create("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	~RegisterClusterActorState() 
	{
		fdb_probe_actor_destroy("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 289 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 289 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterClusterActor*>(this)->actor_wait_state = 1;
															#line 289 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 0, Void >*>(static_cast<RegisterClusterActor*>(this)));
															#line 2439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	Reference<DB> db;
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	ClusterName name;
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	ClusterConnectionString connectionString;
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	DataClusterEntry entry;
															#line 288 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	internal::RegisterClusterImpl<DB> impl;
															#line 2567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
};
// This generated class is to be used only via registerCluster()
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
template <class DB>
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
class RegisterClusterActor final : public Actor<Void>, public ActorCallback< RegisterClusterActor<DB>, 0, Void >, public FastAllocated<RegisterClusterActor<DB>>, public RegisterClusterActorState<DB, RegisterClusterActor<DB>> {
															#line 2574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
public:
	using FastAllocated<RegisterClusterActor<DB>>::operator new;
	using FastAllocated<RegisterClusterActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12968910232486426624UL, 12716013949335547136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterClusterActor<DB>, 0, Void >;
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	RegisterClusterActor(Reference<DB> const& db,ClusterName const& name,ClusterConnectionString const& connectionString,DataClusterEntry const& entry) 
															#line 2591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
		 : Actor<Void>(),
		   RegisterClusterActorState<DB, RegisterClusterActor<DB>>(db, name, connectionString, entry),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5031830753118412800UL, 13167156597116580864UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterClusterActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
template <class DB>
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
[[nodiscard]] Future<Void> registerCluster( Reference<DB> const& db, ClusterName const& name, ClusterConnectionString const& connectionString, DataClusterEntry const& entry ) {
															#line 283 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"
	return Future<Void>(new RegisterClusterActor<DB>(db, name, connectionString, entry));
															#line 2625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/RegisterCluster.actor.g.h"
}

#line 292 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/RegisterCluster.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif