#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
/*
 * BulkLoadCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/BulkLoading.h"
#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

static const std::string BULK_LOAD_MODE_USAGE = "To set bulkload mode: bulkload mode [on|off]\n";
static const std::string BULK_LOAD_LOAD_USAGE =
    "To load a range of key/values: bulkload load <JOBID> <BEGINKEY> <ENDKEY> <DIR>\n"
    " where <JOBID> is the id of the bulkdumped job to load, <BEGINKEY> to <ENDKEY>\n"
    " denotes the key/value range to load, and <DIR> is a local directory OR \n"
    " blobstore url to load SST files from.\n";
static const std::string BULK_LOAD_STATUS_USAGE = "To get status: bulkload status\n";
static const std::string BULK_LOAD_CANCEL_USAGE = "To cancel current bulkload job: bulkload cancel <JOBID>\n";
static const std::string BULK_LOAD_HISTORY_USAGE = "To print bulkload job history: bulkload history\n";
static const std::string BULK_LOAD_HISTORY_CLEAR_USAGE = "To clear history: bulkload history clear [all|id]\n";

static const std::string BULKLOAD_ADD_LOCK_OWNER_USAGE =
    "To add a range lock owner: bulkload addlockowner <OWNER_UNIQUE_ID>\n";
static const std::string BULKLOAD_PRINT_LOCK_USAGE = "To print locked ranges: bulkload printlock\n";
static const std::string BULKLOAD_PRINT_LOCK_OWNER_USAGE = "To print range lock owners: bulkload printlockowner\n";
static const std::string BULKLOAD_CLEAR_LOCK_USAGE = "To clear a range lock: bulkload clearlock <OWNER_UNIQUE_ID>\n";

static const std::string BULK_LOAD_HELP_MESSAGE =
    BULK_LOAD_MODE_USAGE + BULK_LOAD_LOAD_USAGE + BULK_LOAD_STATUS_USAGE + BULK_LOAD_CANCEL_USAGE +
    BULK_LOAD_HISTORY_USAGE + BULK_LOAD_HISTORY_CLEAR_USAGE + BULKLOAD_ADD_LOCK_OWNER_USAGE +
    BULKLOAD_PRINT_LOCK_USAGE + BULKLOAD_PRINT_LOCK_OWNER_USAGE + BULKLOAD_CLEAR_LOCK_USAGE;

															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
// This generated class is to be used only via printPastBulkLoadJob()
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
template <class PrintPastBulkLoadJobActor>
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintPastBulkLoadJobActorState {
															#line 61 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintPastBulkLoadJobActorState(Database const& cx) 
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		 : cx(cx)
															#line 68 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this));

	}
	~PrintPastBulkLoadJobActorState() 
	{
		fdb_probe_actor_destroy("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<std::vector<BulkLoadJobState>> __when_expr_0 = getBulkLoadJobFromHistory(cx);
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 85 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state = 1;
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*>(static_cast<PrintPastBulkLoadJobActor*>(this)));
															#line 90 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintPastBulkLoadJobActorState();
		static_cast<PrintPastBulkLoadJobActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> const& jobs,int loopDepth) 
	{
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (jobs.empty())
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 56 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job in the history");
															#line 57 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PrintPastBulkLoadJobActorState();
			static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& job : jobs ) {
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			ASSERT(job.getPhase() == BulkLoadJobPhase::Complete || job.getPhase() == BulkLoadJobPhase::Error || job.getPhase() == BulkLoadJobPhase::Cancelled);
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!job.getTaskCount().present())
															#line 131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 63 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Job {} submitted at {} for range {}. The job has not initialized for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
			else
			{
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println( "Job {} submitted at {} for range {}. The job has {} tasks. The job ran for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), job.getTaskCount().get(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
															#line 81 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (job.getPhase() == BulkLoadJobPhase::Error)
															#line 145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 82 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				Optional<std::string> errorMessage = job.getErrorMessage();
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error message: {}", errorMessage.present() ? errorMessage.get() : "Not provided.");
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
		}
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintPastBulkLoadJobActorState();
		static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> && jobs,int loopDepth) 
	{
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (jobs.empty())
															#line 168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 56 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job in the history");
															#line 57 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PrintPastBulkLoadJobActorState();
			static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& job : jobs ) {
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			ASSERT(job.getPhase() == BulkLoadJobPhase::Complete || job.getPhase() == BulkLoadJobPhase::Error || job.getPhase() == BulkLoadJobPhase::Cancelled);
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!job.getTaskCount().present())
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 63 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Job {} submitted at {} for range {}. The job has not initialized for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
			else
			{
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println( "Job {} submitted at {} for range {}. The job has {} tasks. The job ran for {} mins and exited " "with status {}.", job.getJobId().toString(), std::to_string(job.getSubmitTime()), job.getJobRange().toString(), job.getTaskCount().get(), std::to_string((job.getEndTime() - job.getSubmitTime()) / 60.0), convertBulkLoadJobPhaseToString(job.getPhase()));
															#line 196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
															#line 81 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (job.getPhase() == BulkLoadJobPhase::Error)
															#line 200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 82 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				Optional<std::string> errorMessage = job.getErrorMessage();
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error message: {}", errorMessage.present() ? errorMessage.get() : "Not provided.");
															#line 206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
		}
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<PrintPastBulkLoadJobActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintPastBulkLoadJobActorState(); static_cast<PrintPastBulkLoadJobActor*>(this)->destroy(); return 0; }
															#line 211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<PrintPastBulkLoadJobActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintPastBulkLoadJobActorState();
		static_cast<PrintPastBulkLoadJobActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> const& jobs,int loopDepth) 
	{
		loopDepth = a_body1cont1(jobs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> && jobs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(jobs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state > 0) static_cast<PrintPastBulkLoadJobActor*>(this)->actor_wait_state = 0;
		static_cast<PrintPastBulkLoadJobActor*>(this)->ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Database cx;
															#line 296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
};
// This generated class is to be used only via printPastBulkLoadJob()
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintPastBulkLoadJobActor final : public Actor<Void>, public ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >, public FastAllocated<PrintPastBulkLoadJobActor>, public PrintPastBulkLoadJobActorState<PrintPastBulkLoadJobActor> {
															#line 301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
	using FastAllocated<PrintPastBulkLoadJobActor>::operator new;
	using FastAllocated<PrintPastBulkLoadJobActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1113674797094485760UL, 5225610810162216704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >;
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintPastBulkLoadJobActor(Database const& cx) 
															#line 318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		 : Actor<Void>(),
		   PrintPastBulkLoadJobActorState<PrintPastBulkLoadJobActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5590200633345809408UL, 11637533527039951616UL);
		ActorExecutionContextHelper __helper(static_cast<PrintPastBulkLoadJobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printPastBulkLoadJob");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printPastBulkLoadJob", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintPastBulkLoadJobActor, 0, std::vector<BulkLoadJobState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
[[nodiscard]] Future<Void> printPastBulkLoadJob( Database const& cx ) {
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	return Future<Void>(new PrintPastBulkLoadJobActor(cx));
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
}

#line 88 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"

void printBulkLoadJobTotalTaskCount(Optional<uint64_t> count) {
	if (count.present()) {
		fmt::println("Total {} tasks", count.get());
	} else {
		fmt::println("Total task count is unknown");
	}
	return;
}

															#line 364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
// This generated class is to be used only via printBulkLoadJobProgress()
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
template <class PrintBulkLoadJobProgressActor>
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintBulkLoadJobProgressActorState {
															#line 370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintBulkLoadJobProgressActorState(Database const& cx,BulkLoadJobState const& job) 
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		 : cx(cx),
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   job(job),
															#line 99 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   tr(cx),
															#line 100 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   readBegin(job.getJobRange().begin),
															#line 101 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   readEnd(job.getJobRange().end),
															#line 102 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   jobId(job.getJobId()),
															#line 103 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   rangeResult(),
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   completeTaskCount(0),
															#line 105 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   submitTaskCount(0),
															#line 106 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   errorTaskCount(0),
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   totalTaskCount(job.getTaskCount())
															#line 397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this));

	}
	~PrintBulkLoadJobProgressActorState() 
	{
		fdb_probe_actor_destroy("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			;
															#line 412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintBulkLoadJobProgressActorState();
		static_cast<PrintBulkLoadJobProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Submitted {} tasks", submitTaskCount);
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Finished {} tasks", completeTaskCount);
															#line 144 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Error {} tasks", errorTaskCount);
															#line 145 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		printBulkLoadJobTotalTaskCount(totalTaskCount);
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintBulkLoadJobProgressActorState(); static_cast<PrintBulkLoadJobProgressActor*>(this)->destroy(); return 0; }
															#line 443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintBulkLoadJobProgressActorState();
		static_cast<PrintBulkLoadJobProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!(readBegin < readEnd))
															#line 462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 110 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			rangeResult.clear();
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 113 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(rangeResult, krmGetRanges(&tr, bulkLoadTaskPrefix, KeyRangeRef(readBegin, readEnd)));
															#line 113 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 1;
															#line 113 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*>(static_cast<PrintBulkLoadJobProgressActor*>(this)));
															#line 482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 2;
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*>(static_cast<PrintBulkLoadJobProgressActor*>(this)));
															#line 524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 115 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
				continue;
			}
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			BulkLoadTaskState bulkLoadTask = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 119 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.getJobId() != jobId)
															#line 549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Submitted {} tasks", submitTaskCount);
															#line 121 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Finished {} tasks", completeTaskCount);
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error {} tasks", errorTaskCount);
															#line 123 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				printBulkLoadJobTotalTaskCount(totalTaskCount);
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Submitted && bulkLoadTask.getJobId() != UID::fromString("00000000-0000-0000-0000-000000000000"))
															#line 561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("Job {} has been cancelled or has completed", jobId.toString());
															#line 565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				}
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintBulkLoadJobProgressActorState(); static_cast<PrintBulkLoadJobProgressActor*>(this)->destroy(); return 0; }
															#line 569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				new (&static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PrintBulkLoadJobProgressActorState();
				static_cast<PrintBulkLoadJobProgressActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.phase == BulkLoadPhase::Complete)
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				completeTaskCount = completeTaskCount + bulkLoadTask.getManifests().size();
															#line 581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
			else
			{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Error)
															#line 587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 133 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					errorTaskCount = errorTaskCount + bulkLoadTask.getManifests().size();
															#line 591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				}
			}
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			submitTaskCount = submitTaskCount + bulkLoadTask.getManifests().size();
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 137 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		readBegin = rangeResult.back().key;
															#line 600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 115 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
				continue;
			}
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			BulkLoadTaskState bulkLoadTask = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 119 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.getJobId() != jobId)
															#line 619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Submitted {} tasks", submitTaskCount);
															#line 121 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Finished {} tasks", completeTaskCount);
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Error {} tasks", errorTaskCount);
															#line 123 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				printBulkLoadJobTotalTaskCount(totalTaskCount);
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Submitted && bulkLoadTask.getJobId() != UID::fromString("00000000-0000-0000-0000-000000000000"))
															#line 631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("Job {} has been cancelled or has completed", jobId.toString());
															#line 635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				}
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintBulkLoadJobProgressActorState(); static_cast<PrintBulkLoadJobProgressActor*>(this)->destroy(); return 0; }
															#line 639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				new (&static_cast<PrintBulkLoadJobProgressActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PrintBulkLoadJobProgressActorState();
				static_cast<PrintBulkLoadJobProgressActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (bulkLoadTask.phase == BulkLoadPhase::Complete)
															#line 647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				completeTaskCount = completeTaskCount + bulkLoadTask.getManifests().size();
															#line 651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
			else
			{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (bulkLoadTask.phase == BulkLoadPhase::Error)
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 133 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					errorTaskCount = errorTaskCount + bulkLoadTask.getManifests().size();
															#line 661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				}
			}
															#line 135 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			submitTaskCount = submitTaskCount + bulkLoadTask.getManifests().size();
															#line 666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 137 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		readBegin = rangeResult.back().key;
															#line 670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state > 0) static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBulkLoadJobProgressActor*>(this)->ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state > 0) static_cast<PrintBulkLoadJobProgressActor*>(this)->actor_wait_state = 0;
		static_cast<PrintBulkLoadJobProgressActor*>(this)->ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Database cx;
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadJobState job;
															#line 99 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Transaction tr;
															#line 100 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Key readBegin;
															#line 101 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Key readEnd;
															#line 102 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	UID jobId;
															#line 103 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	RangeResult rangeResult;
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	size_t completeTaskCount;
															#line 105 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	size_t submitTaskCount;
															#line 106 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	size_t errorTaskCount;
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Optional<uint64_t> totalTaskCount;
															#line 872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
};
// This generated class is to be used only via printBulkLoadJobProgress()
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class PrintBulkLoadJobProgressActor final : public Actor<Void>, public ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >, public ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >, public FastAllocated<PrintBulkLoadJobProgressActor>, public PrintBulkLoadJobProgressActorState<PrintBulkLoadJobProgressActor> {
															#line 877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
	using FastAllocated<PrintBulkLoadJobProgressActor>::operator new;
	using FastAllocated<PrintBulkLoadJobProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13352805641161137408UL, 12174223453868864512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >;
friend struct ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >;
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	PrintBulkLoadJobProgressActor(Database const& cx,BulkLoadJobState const& job) 
															#line 895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		 : Actor<Void>(),
		   PrintBulkLoadJobProgressActorState<PrintBulkLoadJobProgressActor>(cx, job),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10655978368853905920UL, 17576660726047062784UL);
		ActorExecutionContextHelper __helper(static_cast<PrintBulkLoadJobProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printBulkLoadJobProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printBulkLoadJobProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintBulkLoadJobProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintBulkLoadJobProgressActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
[[nodiscard]] Future<Void> printBulkLoadJobProgress( Database const& cx, BulkLoadJobState const& job ) {
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	return Future<Void>(new PrintBulkLoadJobProgressActor(cx, job));
															#line 928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
}

#line 148 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"

															#line 933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
// This generated class is to be used only via getBulkLoadMode()
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
template <class GetBulkLoadModeActor>
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class GetBulkLoadModeActorState {
															#line 939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	GetBulkLoadModeActorState(Database const& cx) 
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		 : cx(cx),
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   tr(cx)
															#line 948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getBulkLoadMode", reinterpret_cast<unsigned long>(this));

	}
	~GetBulkLoadModeActorState() 
	{
		fdb_probe_actor_destroy("getBulkLoadMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			;
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBulkLoadModeActorState();
		static_cast<GetBulkLoadModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 155 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			oldMode = 0;
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(bulkLoadModeKey);
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state = 1;
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >*>(static_cast<GetBulkLoadModeActor*>(this)));
															#line 1009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state = 2;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBulkLoadModeActor, 1, Void >*>(static_cast<GetBulkLoadModeActor*>(this)));
															#line 1038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& oldModeValue,int loopDepth) 
	{
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (oldModeValue.present())
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			BinaryReader rd(oldModeValue.get(), Unversioned());
															#line 160 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			rd >> oldMode;
															#line 1059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 162 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<GetBulkLoadModeActor*>(this)->SAV<int>::futures) { (void)(oldMode); this->~GetBulkLoadModeActorState(); static_cast<GetBulkLoadModeActor*>(this)->destroy(); return 0; }
															#line 1063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<GetBulkLoadModeActor*>(this)->SAV< int >::value()) int(std::move(oldMode)); // state_var_RVO
		this->~GetBulkLoadModeActorState();
		static_cast<GetBulkLoadModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && oldModeValue,int loopDepth) 
	{
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (oldModeValue.present())
															#line 1075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			BinaryReader rd(oldModeValue.get(), Unversioned());
															#line 160 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			rd >> oldMode;
															#line 1081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 162 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<GetBulkLoadModeActor*>(this)->SAV<int>::futures) { (void)(oldMode); this->~GetBulkLoadModeActorState(); static_cast<GetBulkLoadModeActor*>(this)->destroy(); return 0; }
															#line 1085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<GetBulkLoadModeActor*>(this)->SAV< int >::value()) int(std::move(oldMode)); // state_var_RVO
		this->~GetBulkLoadModeActorState();
		static_cast<GetBulkLoadModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& oldModeValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(oldModeValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && oldModeValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(oldModeValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadModeActor*>(this)->ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state > 0) static_cast<GetBulkLoadModeActor*>(this)->actor_wait_state = 0;
		static_cast<GetBulkLoadModeActor*>(this)->ActorCallback< GetBulkLoadModeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBulkLoadModeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBulkLoadModeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBulkLoadModeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBulkLoadMode", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Database cx;
															#line 150 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Transaction tr;
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	int oldMode;
															#line 1261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
};
// This generated class is to be used only via getBulkLoadMode()
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class GetBulkLoadModeActor final : public Actor<int>, public ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >, public ActorCallback< GetBulkLoadModeActor, 1, Void >, public FastAllocated<GetBulkLoadModeActor>, public GetBulkLoadModeActorState<GetBulkLoadModeActor> {
															#line 1266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
	using FastAllocated<GetBulkLoadModeActor>::operator new;
	using FastAllocated<GetBulkLoadModeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2774994431846973440UL, 15662261070892048640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >;
friend struct ActorCallback< GetBulkLoadModeActor, 1, Void >;
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	GetBulkLoadModeActor(Database const& cx) 
															#line 1284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		 : Actor<int>(),
		   GetBulkLoadModeActorState<GetBulkLoadModeActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBulkLoadMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5044981890040374016UL, 3241980670651426048UL);
		ActorExecutionContextHelper __helper(static_cast<GetBulkLoadModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBulkLoadMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBulkLoadMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBulkLoadModeActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBulkLoadModeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
[[nodiscard]] Future<int> getBulkLoadMode( Database const& cx ) {
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	return Future<int>(new GetBulkLoadModeActor(cx));
															#line 1317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
}

#line 168 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"

															#line 1322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
// This generated class is to be used only via bulkLoadCommandActor()
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
template <class BulkLoadCommandActorActor>
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class BulkLoadCommandActorActorState {
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		 : cx(cx),
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		   tokens(tokens)
															#line 1337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~BulkLoadCommandActorActorState() 
	{
		fdb_probe_actor_destroy("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 170 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[1], "mode"))
															#line 1352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 171 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (tokens.size() == 2)
															#line 1356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					StrictFuture<int> __when_expr_0 = getBulkLoadMode(cx);
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 1;
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 0, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
															#line 200 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (tokencmp(tokens[1], "load"))
															#line 1379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 201 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					StrictFuture<int> __when_expr_3 = getBulkLoadMode(cx);
															#line 201 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when2(__when_expr_3.get(), loopDepth); };
					static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 4;
															#line 201 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 3, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 234 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (tokencmp(tokens[1], "cancel"))
															#line 1397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					{
															#line 235 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (tokens.size() != 3)
															#line 1401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
						{
															#line 236 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							fmt::println("{}", BULK_LOAD_CANCEL_USAGE);
															#line 237 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
							new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
							this->~BulkLoadCommandActorActorState();
							static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 239 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						jobId = UID::fromString(tokens[2].toString());
															#line 240 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (!jobId.isValid())
															#line 1417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
						{
															#line 241 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							fmt::println("ERROR: Invalid job id {}", tokens[2].toString());
															#line 242 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							fmt::println("{}", BULK_LOAD_CANCEL_USAGE);
															#line 243 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
							new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
							this->~BulkLoadCommandActorActorState();
							static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 245 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						StrictFuture<Void> __when_expr_5 = cancelBulkLoadJob(cx, jobId);
															#line 245 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
						if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when3(__when_expr_5.get(), loopDepth); };
						static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 6;
															#line 245 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 5, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 249 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
						if (tokencmp(tokens[1], "status"))
															#line 1447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
						{
															#line 250 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (tokens.size() != 2)
															#line 1451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
							{
															#line 251 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								fmt::println("{}", BULK_LOAD_STATUS_USAGE);
															#line 252 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
								new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
								this->~BulkLoadCommandActorActorState();
								static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 254 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							StrictFuture<Optional<BulkLoadJobState>> __when_expr_6 = getRunningBulkLoadJob(cx);
															#line 254 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
							if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when4(__when_expr_6.get(), loopDepth); };
							static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 7;
															#line 254 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 264 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
							if (tokencmp(tokens[1], "history"))
															#line 1479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
							{
															#line 265 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								if (tokens.size() == 2)
															#line 1483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
								{
															#line 266 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									StrictFuture<Void> __when_expr_8 = printPastBulkLoadJob(cx);
															#line 266 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
									if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1when5(__when_expr_8.get(), loopDepth); };
									static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 9;
															#line 266 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 8, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
									loopDepth = a_body1cont25(loopDepth);
								}
							}
							else
							{
															#line 312 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
								if (tokencmp(tokens[1], "addlockowner"))
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
								{
															#line 314 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (tokens.size() != 3)
															#line 1510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
									{
															#line 315 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										fmt::println("{}", BULK_LOAD_STATUS_USAGE);
															#line 316 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
										new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
										this->~BulkLoadCommandActorActorState();
										static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
															#line 318 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									std::string ownerUniqueID = tokens[2].toString();
															#line 319 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (ownerUniqueID.empty())
															#line 1526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
									{
															#line 320 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										fmt::println("ERROR: Owner unique id cannot be empty");
															#line 321 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										fmt::println("{}", BULKLOAD_ADD_LOCK_OWNER_USAGE);
															#line 322 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
										new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
										this->~BulkLoadCommandActorActorState();
										static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
															#line 324 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									StrictFuture<Void> __when_expr_11 = registerRangeLockOwner(cx, ownerUniqueID, ownerUniqueID);
															#line 324 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
									if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1when6(__when_expr_11.get(), loopDepth); };
									static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 12;
															#line 324 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 11, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
															#line 327 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
									if (tokencmp(tokens[1], "printlock"))
															#line 1556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
									{
															#line 329 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (tokens.size() != 2)
															#line 1560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
										{
															#line 330 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											fmt::println("{}", BULKLOAD_PRINT_LOCK_USAGE);
															#line 331 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
											new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
											this->~BulkLoadCommandActorActorState();
											static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
											return 0;
										}
															#line 333 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_12 = findExclusiveReadLockOnRange(cx, normalKeys);
															#line 333 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
										if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1when7(__when_expr_12.get(), loopDepth); };
										static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 13;
															#line 333 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
										loopDepth = 0;
									}
									else
									{
															#line 349 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
										if (tokencmp(tokens[1], "printlockowner"))
															#line 1588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
										{
															#line 351 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (tokens.size() != 2)
															#line 1592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
											{
															#line 352 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												fmt::println("{}", BULKLOAD_PRINT_LOCK_OWNER_USAGE);
															#line 353 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
												new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
												this->~BulkLoadCommandActorActorState();
												static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
												return 0;
											}
															#line 355 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											StrictFuture<std::vector<RangeLockOwner>> __when_expr_13 = getAllRangeLockOwners(cx);
															#line 355 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
											if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1when8(__when_expr_13.get(), loopDepth); };
											static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 14;
															#line 355 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
											loopDepth = 0;
										}
										else
										{
															#line 361 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
											if (tokencmp(tokens[1], "clearlock"))
															#line 1620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
											{
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (tokens.size() != 3)
															#line 1624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
												{
															#line 364 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
													fmt::println("{}", BULKLOAD_CLEAR_LOCK_USAGE);
															#line 365 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
													if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
													new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
													this->~BulkLoadCommandActorActorState();
													static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
													return 0;
												}
															#line 367 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												std::string ownerUniqueID = tokens[2].toString();
															#line 368 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												StrictFuture<Void> __when_expr_14 = releaseExclusiveReadLockByUser(cx, ownerUniqueID);
															#line 368 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
												if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1when9(__when_expr_14.get(), loopDepth); };
												static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 15;
															#line 368 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 14, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
												loopDepth = 0;
											}
											else
											{
															#line 372 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												printUsage(tokens[0]);
															#line 373 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												printLongDesc(tokens[0]);
															#line 374 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
												if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
												new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
												this->~BulkLoadCommandActorActorState();
												static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
												return 0;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 183 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() != 3)
															#line 1693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 184 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_MODE_USAGE);
															#line 185 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 187 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokencmp(tokens[2], "on"))
															#line 1707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 188 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			StrictFuture<int> __when_expr_1 = setBulkLoadMode(cx, 1);
															#line 188 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 2;
															#line 188 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 1, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 191 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "off"))
															#line 1725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 192 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				StrictFuture<int> __when_expr_2 = setBulkLoadMode(cx, 0);
															#line 192 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when2(__when_expr_2.get(), loopDepth); };
				static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 3;
															#line 192 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 2, int >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 1736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("ERROR: Invalid bulkload mode value {}", tokens[2].toString());
															#line 197 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_MODE_USAGE);
															#line 198 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont3(int const& mode,int loopDepth) 
	{
															#line 173 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 1761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Bulkload mode is disabled");
															#line 1765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
		else
		{
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (mode == 1)
															#line 1771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Bulkload mode is enabled");
															#line 1775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
			else
			{
															#line 178 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Invalid bulkload mode value {}", mode);
															#line 1781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
		}
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int && mode,int loopDepth) 
	{
															#line 173 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 1798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 174 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Bulkload mode is disabled");
															#line 1802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
		else
		{
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (mode == 1)
															#line 1808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Bulkload mode is enabled");
															#line 1812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
			else
			{
															#line 178 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("Invalid bulkload mode value {}", mode);
															#line 1818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			}
		}
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont3(mode, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && mode,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11(int const& old,int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 1);
															#line 190 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(int && old,int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 1);
															#line 190 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 1926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(int const& old,int loopDepth) 
	{
		loopDepth = a_body1cont11(old, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int && old,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont13(int const& old,int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 0);
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont13(int && old,int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		TraceEvent("SetBulkLoadModeCommand").detail("OldValue", old).detail("NewValue", 0);
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when2(int const& old,int loopDepth) 
	{
		loopDepth = a_body1cont13(old, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(int && old,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(old), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont16(int const& mode,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 2116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 203 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Bulkload mode must be enabled to load data");
															#line 204 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 206 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() != 6)
															#line 2130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 207 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 210 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		UID jobId = UID::fromString(tokens[2].toString());
															#line 211 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!jobId.isValid())
															#line 2146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 212 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Invalid job id {}", tokens[2].toString());
															#line 213 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 214 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 216 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeBegin = tokens[3];
															#line 217 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeEnd = tokens[4];
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (rangeBegin >= rangeEnd || rangeEnd > normalKeys.end)
															#line 2166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 220 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println( "ERROR: Invalid range: {} to {}, normal key space only", rangeBegin.toString(), rangeEnd.toString());
															#line 222 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 223 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 225 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		std::string jobRoot = tokens[5].toString();
															#line 226 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
															#line 227 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		bulkLoadJob = createBulkLoadJob( jobId, range, jobRoot, jobRoot.find("blobstore://") == 0 ? BulkLoadTransportMethod::BLOBSTORE : BulkLoadTransportMethod::CP);
															#line 232 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkLoadJob(cx, bulkLoadJob);
															#line 232 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont16when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 5;
															#line 232 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 4, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont16(int && mode,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (mode == 0)
															#line 2204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 203 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Bulkload mode must be enabled to load data");
															#line 204 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 206 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() != 6)
															#line 2218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 207 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 208 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 210 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		UID jobId = UID::fromString(tokens[2].toString());
															#line 211 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!jobId.isValid())
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 212 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("ERROR: Invalid job id {}", tokens[2].toString());
															#line 213 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 214 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 216 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeBegin = tokens[3];
															#line 217 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		Key rangeEnd = tokens[4];
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (rangeBegin >= rangeEnd || rangeEnd > normalKeys.end)
															#line 2254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 220 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println( "ERROR: Invalid range: {} to {}, normal key space only", rangeBegin.toString(), rangeEnd.toString());
															#line 222 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", BULK_LOAD_LOAD_USAGE);
															#line 223 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 225 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		std::string jobRoot = tokens[5].toString();
															#line 226 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		KeyRange range = Standalone(KeyRangeRef(rangeBegin, rangeEnd));
															#line 227 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		bulkLoadJob = createBulkLoadJob( jobId, range, jobRoot, jobRoot.find("blobstore://") == 0 ? BulkLoadTransportMethod::BLOBSTORE : BulkLoadTransportMethod::CP);
															#line 232 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkLoadJob(cx, bulkLoadJob);
															#line 232 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont16when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 5;
															#line 232 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 4, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(int const& mode,int loopDepth) 
	{
		loopDepth = a_body1cont16(mode, loopDepth);

		return loopDepth;
	}
	int a_body1when2(int && mode,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(mode), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont16cont1(Void const& _,int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(bulkLoadJob.getJobId()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(bulkLoadJob.getJobId());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16cont1(Void && _,int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(bulkLoadJob.getJobId()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(bulkLoadJob.getJobId());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont16when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont16when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont16when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont16when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont18(Void const& _,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job {} has been cancelled. The job range lock has been cleared", jobId.toString());
															#line 247 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont18(Void && _,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job {} has been cancelled. The job range lock has been cleared", jobId.toString());
															#line 247 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont22(Optional<BulkLoadJobState> const& job,int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!job.present())
															#line 2569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 256 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job is running");
															#line 257 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 259 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Running bulk loading job: {}", job.get().getJobId().toString());
															#line 260 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job information: {}", job.get().toString());
															#line 261 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_7 = printBulkLoadJobProgress(cx, job.get());
															#line 261 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont22when1(__when_expr_7.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 8;
															#line 261 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 7, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont22(Optional<BulkLoadJobState> && job,int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!job.present())
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 256 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("No bulk loading job is running");
															#line 257 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
			this->~BulkLoadCommandActorActorState();
			static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 259 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Running bulk loading job: {}", job.get().getJobId().toString());
															#line 260 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Job information: {}", job.get().toString());
															#line 261 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		StrictFuture<Void> __when_expr_7 = printBulkLoadJobProgress(cx, job.get());
															#line 261 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont22when1(__when_expr_7.get(), loopDepth); };
		static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 8;
															#line 261 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 7, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when4(Optional<BulkLoadJobState> const& job,int loopDepth) 
	{
		loopDepth = a_body1cont22(job, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Optional<BulkLoadJobState> && job,int loopDepth) 
	{
		loopDepth = a_body1cont22(std::move(job), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont22cont1(Void const& _,int loopDepth) 
	{
															#line 262 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont22cont1(Void && _,int loopDepth) 
	{
															#line 262 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont25(int loopDepth) 
	{
															#line 269 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() == 3)
															#line 2811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 270 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "clear"))
															#line 2815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 271 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 272 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 274 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("ERROR: Invalid history option {}", tokens[2].toString());
															#line 275 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 276 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 279 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() == 4)
															#line 2844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 280 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "clear"))
															#line 2848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 281 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (tokencmp(tokens[3], "all"))
															#line 2852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 282 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					StrictFuture<Void> __when_expr_9 = clearBulkLoadJobHistory(cx);
															#line 282 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont25when1(__when_expr_9.get(), loopDepth); };
					static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 10;
															#line 282 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 9, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 2863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 286 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("ERROR: Invalid history clear option {}", tokens[3].toString());
															#line 287 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 288 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~BulkLoadCommandActorActorState();
					static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
			else
			{
															#line 291 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("ERROR: Invalid history clear option {}", tokens[2].toString());
															#line 292 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 293 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~BulkLoadCommandActorActorState();
				static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		else
		{
			loopDepth = a_body1cont25cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont26(Void const& _,int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont26(Void && _,int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 2919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont26(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont26(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont25cont1(int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (tokens.size() == 5)
															#line 3006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 297 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (tokencmp(tokens[2], "clear") && tokencmp(tokens[3], "id"))
															#line 3010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
															#line 298 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				UID jobId = UID::fromString(tokens[4].toString());
															#line 299 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (!jobId.isValid())
															#line 3016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				{
															#line 300 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("ERROR: Invalid job id {}", tokens[4].toString());
															#line 301 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					fmt::println("{}", BULK_LOAD_HISTORY_CLEAR_USAGE);
															#line 302 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
					if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
					new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~BulkLoadCommandActorActorState();
					static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 304 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				StrictFuture<Void> __when_expr_10 = clearBulkLoadJobHistory(cx, jobId);
															#line 304 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont25cont1when1(__when_expr_10.get(), loopDepth); };
				static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 11;
															#line 304 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< BulkLoadCommandActorActor, 10, Void >*>(static_cast<BulkLoadCommandActorActor*>(this)));
															#line 3039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont25cont12(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont25cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont25cont7(Void const& _,int loopDepth) 
	{
															#line 283 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("All bulkload job history has been cleared");
															#line 284 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont7(Void && _,int loopDepth) 
	{
															#line 283 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("All bulkload job history has been cleared");
															#line 284 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont25when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont25when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont25when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont25cont11(int loopDepth) 
	{
															#line 309 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		printLongDesc(tokens[0]);
															#line 310 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont12(int loopDepth) 
	{
		loopDepth = a_body1cont25cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont25cont13(Void const& _,int loopDepth) 
	{
															#line 305 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Bulkload job {} has been cleared from history", jobId.toString());
															#line 306 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(jobId); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(std::move(jobId)); // state_var_RVO
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont13(Void && _,int loopDepth) 
	{
															#line 305 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Bulkload job {} has been cleared from history", jobId.toString());
															#line 306 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(jobId); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(std::move(jobId)); // state_var_RVO
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont25cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont25cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont25cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont25cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont28(Void const& _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont28(Void && _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont28(_, loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont28(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont32(std::vector<std::pair<KeyRange, RangeLockState>> const& lockedRanges,int loopDepth) 
	{
															#line 335 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Total {} locked ranges", lockedRanges.size());
															#line 336 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (lockedRanges.size() > 10)
															#line 3385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 337 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("First 10 locks are:");
															#line 3389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 339 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		int count = 1;
															#line 340 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& lock : lockedRanges ) {
															#line 341 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (count > 10)
															#line 3397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
				break;
			}
															#line 344 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Lock {} on {} for {}", count, lock.first.toString(), lock.second.toString());
															#line 345 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			count++;
															#line 3405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 347 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont32(std::vector<std::pair<KeyRange, RangeLockState>> && lockedRanges,int loopDepth) 
	{
															#line 335 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		fmt::println("Total {} locked ranges", lockedRanges.size());
															#line 336 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (lockedRanges.size() > 10)
															#line 3423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		{
															#line 337 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("First 10 locks are:");
															#line 3427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 339 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		int count = 1;
															#line 340 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto& lock : lockedRanges ) {
															#line 341 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			if (count > 10)
															#line 3435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
			{
				break;
			}
															#line 344 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("Lock {} on {} for {}", count, lock.first.toString(), lock.second.toString());
															#line 345 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			count++;
															#line 3443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 347 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when7(std::vector<std::pair<KeyRange, RangeLockState>> const& lockedRanges,int loopDepth) 
	{
		loopDepth = a_body1cont32(lockedRanges, loopDepth);

		return loopDepth;
	}
	int a_body1when7(std::vector<std::pair<KeyRange, RangeLockState>> && lockedRanges,int loopDepth) 
	{
		loopDepth = a_body1cont32(std::move(lockedRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont35(std::vector<RangeLockOwner> const& owners,int loopDepth) 
	{
															#line 356 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto owner : owners ) {
															#line 357 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", owner.toString());
															#line 3536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 359 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont35(std::vector<RangeLockOwner> && owners,int loopDepth) 
	{
															#line 356 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		for( const auto owner : owners ) {
															#line 357 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
			fmt::println("{}", owner.toString());
															#line 3554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		}
															#line 359 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when8(std::vector<RangeLockOwner> const& owners,int loopDepth) 
	{
		loopDepth = a_body1cont35(owners, loopDepth);

		return loopDepth;
	}
	int a_body1when8(std::vector<RangeLockOwner> && owners,int loopDepth) 
	{
		loopDepth = a_body1cont35(std::move(owners), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont38(Void const& _,int loopDepth) 
	{
															#line 369 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont38(Void && _,int loopDepth) 
	{
															#line 369 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
		if (!static_cast<BulkLoadCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~BulkLoadCommandActorActorState(); static_cast<BulkLoadCommandActorActor*>(this)->destroy(); return 0; }
															#line 3657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		new (&static_cast<BulkLoadCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
		this->~BulkLoadCommandActorActorState();
		static_cast<BulkLoadCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont38(_, loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont38(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BulkLoadCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BulkLoadCommandActorActor*>(this)->ActorCallback< BulkLoadCommandActorActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< BulkLoadCommandActorActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< BulkLoadCommandActorActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	Database cx;
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 227 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadJobState bulkLoadJob;
															#line 239 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	UID jobId;
															#line 3748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
};
// This generated class is to be used only via bulkLoadCommandActor()
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
class BulkLoadCommandActorActor final : public Actor<UID>, public ActorCallback< BulkLoadCommandActorActor, 0, int >, public ActorCallback< BulkLoadCommandActorActor, 1, int >, public ActorCallback< BulkLoadCommandActorActor, 2, int >, public ActorCallback< BulkLoadCommandActorActor, 3, int >, public ActorCallback< BulkLoadCommandActorActor, 4, Void >, public ActorCallback< BulkLoadCommandActorActor, 5, Void >, public ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >, public ActorCallback< BulkLoadCommandActorActor, 7, Void >, public ActorCallback< BulkLoadCommandActorActor, 8, Void >, public ActorCallback< BulkLoadCommandActorActor, 9, Void >, public ActorCallback< BulkLoadCommandActorActor, 10, Void >, public ActorCallback< BulkLoadCommandActorActor, 11, Void >, public ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >, public ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >, public ActorCallback< BulkLoadCommandActorActor, 14, Void >, public FastAllocated<BulkLoadCommandActorActor>, public BulkLoadCommandActorActorState<BulkLoadCommandActorActor> {
															#line 3753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
public:
	using FastAllocated<BulkLoadCommandActorActor>::operator new;
	using FastAllocated<BulkLoadCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11527735797736522496UL, 11244147757659664384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkLoadCommandActorActor, 0, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 1, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 2, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 3, int >;
friend struct ActorCallback< BulkLoadCommandActorActor, 4, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 5, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >;
friend struct ActorCallback< BulkLoadCommandActorActor, 7, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 8, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 9, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 10, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 11, Void >;
friend struct ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >;
friend struct ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >;
friend struct ActorCallback< BulkLoadCommandActorActor, 14, Void >;
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	BulkLoadCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 3784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
		 : Actor<UID>(),
		   BulkLoadCommandActorActorState<BulkLoadCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5735936966811031040UL, 12288206974481010944UL);
		ActorExecutionContextHelper __helper(static_cast<BulkLoadCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkLoadCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkLoadCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 1, int >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 2, int >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 3, int >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 6, Optional<BulkLoadJobState> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 12, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 13, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< BulkLoadCommandActorActor, 14, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
[[nodiscard]] Future<UID> bulkLoadCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"
	return Future<UID>(new BulkLoadCommandActorActor(cx, tokens));
															#line 3830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/BulkLoadCommand.actor.g.cpp"
}

#line 377 "/Users/ec2-user/foundationdb/fdbcli/BulkLoadCommand.actor.cpp"

CommandFactory bulkLoadFactory("bulkload",
                               CommandHelp("bulkload [mode|load|status|cancel|history] [ARGs]",
                                           "bulkload commands",
                                           BULK_LOAD_HELP_MESSAGE.c_str()));
} // namespace fdb_cli
