/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.test.Instruction;
import com.apple.foundationdb.tuple.Tuple;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class StackUtils {
    static boolean pushError(Instruction instruction, FDBException fDBException) {
        if (fDBException.getCode() != 0) {
            instruction.push(StackUtils.getErrorBytes(fDBException));
        }
        return fDBException.getCode() != 0;
    }

    static byte[] getErrorBytes(FDBException fDBException) {
        Tuple tuple = new Tuple().add("ERROR".getBytes()).add(Integer.toString(fDBException.getCode()).getBytes());
        return tuple.pack();
    }

    static Object serializeFuture(Object object) {
        try {
            if (!(object instanceof CompletableFuture)) {
                return object;
            }
            CompletableFuture completableFuture = (CompletableFuture)object;
            if ((object = completableFuture.join()) == null) {
                object = "RESULT_NOT_PRESENT".getBytes();
            }
        }
        catch (CompletionException completionException) {
            FDBException fDBException = StackUtils.getRootFDBException(completionException);
            if (fDBException == null) {
                throw completionException;
            }
            object = StackUtils.getErrorBytes(fDBException);
        }
        return object;
    }

    static boolean validTenantMetadata(String string) {
        return string.charAt(0) == '{' && string.charAt(string.length() - 1) == '}' && string.contains("id") && string.contains("prefix");
    }

    static int getInt(List<Object> list, int n) {
        Object object = list.get(n);
        return StackUtils.getInt(object);
    }

    static int getInt(Object object) {
        return StackUtils.getInt(object, null);
    }

    static int getInt(Object object, Integer n) {
        if (object == null) {
            if (n == null) {
                throw new NullPointerException("Null input with no default");
            }
            return n;
        }
        return ((Number)object).intValue();
    }

    static Number getNumber(Object object) {
        return (Number)object;
    }

    static BigInteger getBigInteger(Object object) {
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        return BigInteger.valueOf(((Number)object).longValue());
    }

    static boolean getBoolean(Object object) {
        return StackUtils.getBoolean(object, null);
    }

    static boolean getBoolean(Object object, Boolean bl) {
        if (object == null) {
            if (bl == null) {
                throw new NullPointerException("Null input with no default");
            }
            return bl;
        }
        return StackUtils.getInt(object) != 0;
    }

    static KeySelector createSelector(Object object, Object object2, Object object3) {
        boolean bl = StackUtils.getBoolean(object2, null);
        int n = StackUtils.getInt(object3);
        return new KeySelector((byte[])object, bl, n);
    }

    static FDBException getRootFDBException(Throwable throwable) {
        while (throwable != null && throwable != throwable.getCause() && !(throwable instanceof FDBException)) {
            throwable = throwable.getCause();
        }
        return throwable instanceof FDBException ? (FDBException)throwable : null;
    }

    private StackUtils() {
    }
}

