#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
/*
 * BenchStream.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2022 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "benchmark/benchmark.h"

#include "flow/flow.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/PriorityMultiLock.actor.h"
#include <deque>
#include "flow/actorcompiler.h" // This must be the last #include.
#include "fmt/printf.h"

															#line 32 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
namespace {
// This generated class is to be used only via benchPriorityMultiLock()
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
template <class BenchPriorityMultiLockActor>
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
class BenchPriorityMultiLockActorState {
															#line 39 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
public:
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	BenchPriorityMultiLockActorState(benchmark::State* const& benchState) 
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		 : benchState(benchState),
															#line 33 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		   active(benchState->range(0)),
															#line 34 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		   inactive(benchState->range(1)),
															#line 37 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		   priorities()
															#line 52 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
	{
		fdb_probe_actor_create("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this));

	}
	~BenchPriorityMultiLockActorState() 
	{
		fdb_probe_actor_destroy("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			for(;priorities.size() < active + inactive;) {
															#line 39 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
				priorities.push_back(10 * (priorities.size() + 1));
															#line 69 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
			}
															#line 42 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			concurrency = priorities.size() * 10;
															#line 43 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			pml = makeReference<PriorityMultiLock>(concurrency, priorities);
															#line 46 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			lockFutures = std::deque<Future<PriorityMultiLock::Lock>>();
															#line 47 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			for(int j = 0;j < concurrency;++j) {
															#line 48 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
				lockFutures.push_back(pml->lock(j % active));
															#line 81 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
			}
															#line 52 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(std::vector<Future<PriorityMultiLock::Lock>>(lockFutures.begin(), lockFutures.end()));
															#line 52 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			if (static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 87 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state = 1;
															#line 52 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BenchPriorityMultiLockActor, 0, Void >*>(static_cast<BenchPriorityMultiLockActor*>(this)));
															#line 92 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BenchPriorityMultiLockActorState();
		static_cast<BenchPriorityMultiLockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 59 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		p = 0;
															#line 60 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		i = 0;
															#line 61 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		;
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 59 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		p = 0;
															#line 60 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		i = 0;
															#line 61 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		;
															#line 132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state > 0) static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state = 0;
		static_cast<BenchPriorityMultiLockActor*>(this)->ActorCallback< BenchPriorityMultiLockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchPriorityMultiLockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BenchPriorityMultiLockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BenchPriorityMultiLockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 79 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		benchState->SetItemsProcessed(static_cast<long>(benchState->iterations()));
															#line 81 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		if (!static_cast<BenchPriorityMultiLockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BenchPriorityMultiLockActorState(); static_cast<BenchPriorityMultiLockActor*>(this)->destroy(); return 0; }
															#line 206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		new (&static_cast<BenchPriorityMultiLockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BenchPriorityMultiLockActorState();
		static_cast<BenchPriorityMultiLockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 61 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		if (!(benchState->KeepRunning()))
															#line 225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 63 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		Future<PriorityMultiLock::Lock> f = lockFutures[i];
															#line 64 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		lockFutures[i] = pml->lock(p);
															#line 66 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		StrictFuture<PriorityMultiLock::Lock> __when_expr_1 = f;
															#line 66 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		if (static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state = 2;
															#line 66 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >*>(static_cast<BenchPriorityMultiLockActor*>(this)));
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(PriorityMultiLock::Lock const& lock,int loopDepth) 
	{
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		if (++p == active)
															#line 264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		{
															#line 70 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			p = 0;
															#line 268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		}
															#line 74 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		if (++i == lockFutures.size())
															#line 272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		{
															#line 75 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			i = 0;
															#line 276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(PriorityMultiLock::Lock && lock,int loopDepth) 
	{
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		if (++p == active)
															#line 286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		{
															#line 70 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			p = 0;
															#line 290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		}
															#line 74 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
		if (++i == lockFutures.size())
															#line 294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		{
															#line 75 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
			i = 0;
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(PriorityMultiLock::Lock const& lock,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(lock, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(PriorityMultiLock::Lock && lock,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(lock), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state > 0) static_cast<BenchPriorityMultiLockActor*>(this)->actor_wait_state = 0;
		static_cast<BenchPriorityMultiLockActor*>(this)->ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >::remove();

	}
	void a_callback_fire(ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >*,PriorityMultiLock::Lock const& value) 
	{
		fdb_probe_actor_enter("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >*,PriorityMultiLock::Lock && value) 
	{
		fdb_probe_actor_enter("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >*,Error err) 
	{
		fdb_probe_actor_enter("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	benchmark::State* benchState;
															#line 33 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	int active;
															#line 34 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	int inactive;
															#line 37 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	std::vector<int> priorities;
															#line 42 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	int concurrency;
															#line 43 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	Reference<PriorityMultiLock> pml;
															#line 46 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	std::deque<Future<PriorityMultiLock::Lock>> lockFutures;
															#line 59 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	int p;
															#line 60 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	int i;
															#line 385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
};
// This generated class is to be used only via benchPriorityMultiLock()
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
class BenchPriorityMultiLockActor final : public Actor<Void>, public ActorCallback< BenchPriorityMultiLockActor, 0, Void >, public ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >, public FastAllocated<BenchPriorityMultiLockActor>, public BenchPriorityMultiLockActorState<BenchPriorityMultiLockActor> {
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
public:
	using FastAllocated<BenchPriorityMultiLockActor>::operator new;
	using FastAllocated<BenchPriorityMultiLockActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< BenchPriorityMultiLockActor, 0, Void >;
friend struct ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >;
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	BenchPriorityMultiLockActor(benchmark::State* const& benchState) 
															#line 402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
		 : Actor<Void>(),
		   BenchPriorityMultiLockActorState<BenchPriorityMultiLockActor>(benchState)
	{
		fdb_probe_actor_enter("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("benchPriorityMultiLock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("benchPriorityMultiLock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BenchPriorityMultiLockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BenchPriorityMultiLockActor, 1, PriorityMultiLock::Lock >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
[[nodiscard]] static Future<Void> benchPriorityMultiLock( benchmark::State* const& benchState ) {
															#line 30 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"
	return Future<Void>(new BenchPriorityMultiLockActor(benchState));
															#line 431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchPriorityMultiLock.actor.g.cpp"
}

#line 83 "/Users/ec2-user/foundationdb/flowbench/BenchPriorityMultiLock.actor.cpp"

static void bench_priorityMultiLock(benchmark::State& benchState) {
	onMainThread([&benchState]() { return benchPriorityMultiLock(&benchState); }).blockUntilReady();
}

BENCHMARK(bench_priorityMultiLock)->Args({ 5, 0 })->Ranges({ { 1, 64 }, { 0, 128 } })->ReportAggregatesOnly(true);
