#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
/*
 * BenchNet2.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2022 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "benchmark/benchmark.h"

#include "flow/IRandom.h"
#include "flow/flow.h"
#include "flow/DeterministicRandom.h"
#include "flow/network.h"
#include "flow/ThreadHelper.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 33 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
namespace {
// This generated class is to be used only via increment()
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
template <class IncrementActor>
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
class IncrementActorState {
															#line 40 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
public:
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	IncrementActorState(TaskPriority const& priority,uint32_t* const& sum) 
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		 : priority(priority),
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		   sum(sum)
															#line 49 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
	{
		fdb_probe_actor_create("increment", reinterpret_cast<unsigned long>(this));

	}
	~IncrementActorState() 
	{
		fdb_probe_actor_destroy("increment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 32 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, priority);
															#line 32 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
			if (static_cast<IncrementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 66 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncrementActor*>(this)->actor_wait_state = 1;
															#line 32 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementActor, 0, Void >*>(static_cast<IncrementActor*>(this)));
															#line 71 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 33 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		++(*sum);
															#line 34 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (!static_cast<IncrementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementActorState(); static_cast<IncrementActor*>(this)->destroy(); return 0; }
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		new (&static_cast<IncrementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 33 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		++(*sum);
															#line 34 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (!static_cast<IncrementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementActorState(); static_cast<IncrementActor*>(this)->destroy(); return 0; }
															#line 110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		new (&static_cast<IncrementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementActor*>(this)->actor_wait_state > 0) static_cast<IncrementActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActor*>(this)->ActorCallback< IncrementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	TaskPriority priority;
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	uint32_t* sum;
															#line 185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
};
// This generated class is to be used only via increment()
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
class IncrementActor final : public Actor<Void>, public ActorCallback< IncrementActor, 0, Void >, public FastAllocated<IncrementActor>, public IncrementActorState<IncrementActor> {
															#line 190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
public:
	using FastAllocated<IncrementActor>::operator new;
	using FastAllocated<IncrementActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementActor, 0, Void >;
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	IncrementActor(TaskPriority const& priority,uint32_t* const& sum) 
															#line 201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		 : Actor<Void>(),
		   IncrementActorState<IncrementActor>(priority, sum)
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("increment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
[[nodiscard]] static Future<Void> increment( TaskPriority const& priority, uint32_t* const& sum ) {
															#line 31 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	return Future<Void>(new IncrementActor(priority, sum));
															#line 229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
}

#line 36 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"

static inline TaskPriority getRandomTaskPriority(DeterministicRandom& rand) {
	return static_cast<TaskPriority>(rand.randomInt(0, 100));
}

															#line 238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
namespace {
// This generated class is to be used only via benchNet2Actor()
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
template <class BenchNet2ActorActor>
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
class BenchNet2ActorActorState {
															#line 245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
public:
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	BenchNet2ActorActorState(benchmark::State* const& benchState) 
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		 : benchState(benchState),
															#line 42 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		   actorCount(benchState->range(0)),
															#line 43 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		   sum(),
															#line 44 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		   seed(platform::getRandomSeed())
															#line 258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
	{
		fdb_probe_actor_create("benchNet2Actor", reinterpret_cast<unsigned long>(this));

	}
	~BenchNet2ActorActorState() 
	{
		fdb_probe_actor_destroy("benchNet2Actor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
			;
															#line 273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BenchNet2ActorActorState();
		static_cast<BenchNet2ActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		benchState->SetItemsProcessed(actorCount * static_cast<long>(benchState->iterations()));
															#line 57 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (!static_cast<BenchNet2ActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BenchNet2ActorActorState(); static_cast<BenchNet2ActorActor*>(this)->destroy(); return 0; }
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		new (&static_cast<BenchNet2ActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BenchNet2ActorActorState();
		static_cast<BenchNet2ActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 45 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (!(benchState->KeepRunning()))
															#line 317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 46 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		sum = 0;
															#line 47 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		std::vector<Future<Void>> futures;
															#line 48 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		futures.reserve(actorCount);
															#line 49 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		DeterministicRandom rand(seed);
															#line 50 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		for(int i = 0;i < actorCount;++i) {
															#line 51 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
			futures.push_back(increment(getRandomTaskPriority(rand), &sum));
															#line 333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		}
															#line 53 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 53 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (static_cast<BenchNet2ActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BenchNet2ActorActor*>(this)->actor_wait_state = 1;
															#line 53 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BenchNet2ActorActor, 0, Void >*>(static_cast<BenchNet2ActorActor*>(this)));
															#line 344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 54 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		benchmark::DoNotOptimize(sum);
															#line 366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 54 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		benchmark::DoNotOptimize(sum);
															#line 375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BenchNet2ActorActor*>(this)->actor_wait_state > 0) static_cast<BenchNet2ActorActor*>(this)->actor_wait_state = 0;
		static_cast<BenchNet2ActorActor*>(this)->ActorCallback< BenchNet2ActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchNet2ActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchNet2Actor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchNet2Actor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BenchNet2ActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchNet2Actor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchNet2Actor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BenchNet2ActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchNet2Actor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchNet2Actor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	benchmark::State* benchState;
															#line 42 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	size_t actorCount;
															#line 43 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	uint32_t sum;
															#line 44 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	int seed;
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
};
// This generated class is to be used only via benchNet2Actor()
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
class BenchNet2ActorActor final : public Actor<Void>, public ActorCallback< BenchNet2ActorActor, 0, Void >, public FastAllocated<BenchNet2ActorActor>, public BenchNet2ActorActorState<BenchNet2ActorActor> {
															#line 456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
public:
	using FastAllocated<BenchNet2ActorActor>::operator new;
	using FastAllocated<BenchNet2ActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< BenchNet2ActorActor, 0, Void >;
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	BenchNet2ActorActor(benchmark::State* const& benchState) 
															#line 467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		 : Actor<Void>(),
		   BenchNet2ActorActorState<BenchNet2ActorActor>(benchState)
	{
		fdb_probe_actor_enter("benchNet2Actor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("benchNet2Actor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("benchNet2Actor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BenchNet2ActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
[[nodiscard]] static Future<Void> benchNet2Actor( benchmark::State* const& benchState ) {
															#line 41 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	return Future<Void>(new BenchNet2ActorActor(benchState));
															#line 495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
}

#line 59 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"

static void bench_net2(benchmark::State& benchState) {
	onMainThread([&benchState] { return benchNet2Actor(&benchState); }).blockUntilReady();
}

BENCHMARK(bench_net2)->Range(1, 1 << 16)->ReportAggregatesOnly(true);

static constexpr bool DELAY = false;
static constexpr bool YIELD = true;

															#line 509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
namespace {
// This generated class is to be used only via benchDelay()
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
template <bool useYield, class BenchDelayActor>
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
class BenchDelayActorState {
															#line 516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
public:
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	BenchDelayActorState(benchmark::State* const& benchState) 
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		 : benchState(benchState),
															#line 73 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		   timerCount(benchState->range(0)),
															#line 74 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		   futures(),
															#line 75 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		   rand(platform::getRandomSeed())
															#line 529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
	{
		fdb_probe_actor_create("benchDelay", reinterpret_cast<unsigned long>(this));

	}
	~BenchDelayActorState() 
	{
		fdb_probe_actor_destroy("benchDelay", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 76 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
			for(;--timerCount > 0;) {
															#line 77 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
				futures.push_back(delay(1.0 + rand.random01(), getRandomTaskPriority(rand)));
															#line 546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
			}
															#line 80 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
			;
															#line 550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BenchDelayActorState();
		static_cast<BenchDelayActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		benchState->SetItemsProcessed(static_cast<long>(benchState->iterations()));
															#line 84 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (!static_cast<BenchDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BenchDelayActorState(); static_cast<BenchDelayActor*>(this)->destroy(); return 0; }
															#line 575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		new (&static_cast<BenchDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BenchDelayActorState();
		static_cast<BenchDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 80 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (!(benchState->KeepRunning()))
															#line 594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 81 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		StrictFuture<Void> __when_expr_0 = useYield ? yield() : delay(0);
															#line 81 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		if (static_cast<BenchDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BenchDelayActor*>(this)->actor_wait_state = 1;
															#line 81 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BenchDelayActor, 0, Void >*>(static_cast<BenchDelayActor*>(this)));
															#line 607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BenchDelayActor*>(this)->actor_wait_state > 0) static_cast<BenchDelayActor*>(this)->actor_wait_state = 0;
		static_cast<BenchDelayActor*>(this)->ActorCallback< BenchDelayActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchDelayActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchDelay", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BenchDelayActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchDelay", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BenchDelayActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchDelay", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchDelay", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	benchmark::State* benchState;
															#line 73 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	int64_t timerCount;
															#line 74 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 75 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	DeterministicRandom rand;
															#line 708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
};
// This generated class is to be used only via benchDelay()
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
template <bool useYield>
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
class BenchDelayActor final : public Actor<Void>, public ActorCallback< BenchDelayActor<useYield>, 0, Void >, public FastAllocated<BenchDelayActor<useYield>>, public BenchDelayActorState<useYield, BenchDelayActor<useYield>> {
															#line 715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
public:
	using FastAllocated<BenchDelayActor<useYield>>::operator new;
	using FastAllocated<BenchDelayActor<useYield>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< BenchDelayActor<useYield>, 0, Void >;
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	BenchDelayActor(benchmark::State* const& benchState) 
															#line 726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
		 : Actor<Void>(),
		   BenchDelayActorState<useYield, BenchDelayActor<useYield>>(benchState)
	{
		fdb_probe_actor_enter("benchDelay", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("benchDelay");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("benchDelay", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BenchDelayActor<useYield>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
template <bool useYield>
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
[[nodiscard]] static Future<Void> benchDelay( benchmark::State* const& benchState ) {
															#line 69 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"
	return Future<Void>(new BenchDelayActor<useYield>(benchState));
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/flowbench/BenchNet2.actor.g.cpp"
}

#line 86 "/Users/ec2-user/foundationdb/flowbench/BenchNet2.actor.cpp"

template <bool useYield>
static void bench_delay(benchmark::State& benchState) {
	onMainThread([&benchState] { return benchDelay<useYield>(&benchState); }).blockUntilReady();
}

BENCHMARK_TEMPLATE(bench_delay, DELAY)->Range(0, 1 << 16)->ReportAggregatesOnly(true);
BENCHMARK_TEMPLATE(bench_delay, YIELD)->Range(0, 1 << 16)->ReportAggregatesOnly(true);
