/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.Transaction;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SerialInsertion {
    private static final int THREAD_COUNT = 10;
    private static final int BATCH_SIZE = 1000;
    private static final int NODES = 1000000;

    public static void main(String[] stringArray) {
        FDB fDB = FDB.selectAPIVersion((int)730);
        try (Database database = fDB.open();){
            long l = System.currentTimeMillis();
            ArrayList<InsertionThread> arrayList = new ArrayList<InsertionThread>(10);
            int n = 100000;
            for (int i = 0; i < 10; ++i) {
                if (i == 9) {
                    n += 0;
                }
                InsertionThread insertionThread = new InsertionThread(database, n * i, n);
                insertionThread.start();
                arrayList.add(insertionThread);
            }
            for (InsertionThread insertionThread : arrayList) {
                try {
                    insertionThread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            System.out.println("Time taken: " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    private SerialInsertion() {
    }

    static class InsertionThread
    extends Thread {
        private final Database db;
        private final int insertionStart;
        private final int insertionCount;

        InsertionThread(Database database, int n, int n2) {
            this.db = database;
            this.insertionStart = n;
            this.insertionCount = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = new byte[]{46, 46, 46, 46};
            int n = 0;
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            try (Transaction transaction = this.db.createTransaction();){
                while (n < this.insertionCount) {
                    try {
                        int n2;
                        for (n2 = 0; n2 < 1000 && n + n2 < this.insertionCount; ++n2) {
                            byteBuffer.putInt(0, this.insertionStart + n + n2);
                            transaction.set(byteBuffer.array(), byArray);
                        }
                        transaction.commit().join();
                        transaction.close();
                        transaction = this.db.createTransaction();
                        n += n2;
                    }
                    catch (RuntimeException runtimeException) {
                        transaction = (Transaction)transaction.onError((Throwable)runtimeException).join();
                    }
                }
            }
        }
    }
}

