/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.TransactionContext;
import java.util.concurrent.atomic.AtomicInteger;

public class IterableTest {
    public static void main(String[] stringArray) throws InterruptedException {
        try {
            FDB fDB = FDB.selectAPIVersion((int)730);
            try (Database database = fDB.open();){
                IterableTest.runTests(1000, (TransactionContext)database);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void runTests(int n, TransactionContext transactionContext) {
        System.out.println("Running tests...");
        long l = System.currentTimeMillis();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        try {
            transactionContext.run(transaction -> {
                for (KeyValue keyValue : transaction.getRange("vcount".getBytes(), "zz".getBytes())) {
                    System.out.println("K: " + new String(keyValue.getKey()) + ", V: " + new String(keyValue.getValue()));
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        System.out.println(" Transactions:    " + n);
        System.out.println(" Total Time:      " + d);
        System.out.println(" Gets+Sets / sec: " + (double)n / d);
        System.out.println(" Count:           " + atomicInteger.get());
        System.exit(0);
    }

    private IterableTest() {
    }
}

