/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentGetSetGet {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    final Semaphore semaphore = new Semaphore(100);
    final AtomicInteger errorCount = new AtomicInteger();
    final AtomicInteger attemptCount = new AtomicInteger();
    final AtomicInteger getCompleteCount = new AtomicInteger();
    public static final int COUNT = 1000;
    public static final int CONCURRENCY = 100;

    private static byte[] $(String string) {
        return string.getBytes(UTF8);
    }

    public static void main(String[] stringArray) {
        try (Database database = FDB.selectAPIVersion((int)730).open();){
            new ConcurrentGetSetGet().apply(database);
        }
    }

    public void apply(Database database) {
        new Thread(() -> {
            int n = 0;
            try {
                Thread.sleep(5000L);
                System.out.println("Loop " + n++ + ":");
                System.out.println(" attempts: " + this.attemptCount.get());
                System.out.println(" gets complete: " + this.getCompleteCount.get());
                System.out.println(" errors: " + this.errorCount.get());
                System.out.println(" sem: " + this.semaphore);
                System.out.println();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }).start();
        SecureRandom secureRandom = new SecureRandom();
        try {
            long l;
            long l2 = l = System.currentTimeMillis();
            for (int i = 0; i < 1000; ++i) {
                this.semaphore.acquire();
                long l3 = System.currentTimeMillis() - l2;
                if (l3 > 100L) {
                    System.out.println("Waited " + l3 + "ms");
                }
                l2 = System.currentTimeMillis();
                database.runAsync(transaction -> {
                    this.attemptCount.addAndGet(1);
                    String string = "test:" + secureRandom.nextInt();
                    return ((CompletableFuture)transaction.get(ConcurrentGetSetGet.$(string)).thenComposeAsync(byArray -> {
                        transaction.set(ConcurrentGetSetGet.$(string), ConcurrentGetSetGet.$("value"));
                        return transaction.get(ConcurrentGetSetGet.$(string)).thenRunAsync(() -> {
                            this.getCompleteCount.addAndGet(1);
                            this.semaphore.release();
                        }, FDB.DEFAULT_EXECUTOR);
                    }, (Executor)FDB.DEFAULT_EXECUTOR)).exceptionally(throwable -> {
                        this.errorCount.addAndGet(1);
                        System.err.println("Fail (" + throwable.getMessage() + ")");
                        this.semaphore.release();
                        return null;
                    });
                });
            }
            this.semaphore.acquire(100);
            long l4 = System.currentTimeMillis() - l;
            System.out.println("time taken (ms): " + l4);
            System.out.println("tr/sec:" + 1000000L / l4);
            System.out.println("attempts: " + this.attemptCount.get());
            System.out.println("gets complete: " + this.getCompleteCount.get());
            System.out.println("errors: " + this.errorCount.get());
            System.out.println();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }
}

