/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.MultiClientHelper;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;

public class SidebandMultiThreadClientTest {
    public static final MultiClientHelper clientHelper = new MultiClientHelper();
    private static final Map<Database, BlockingQueue<String>> db2Queues = new HashMap<Database, BlockingQueue<String>>();
    private static final int threadPerDB = 5;
    private static final int txnCnt = 1000;

    public static void main(String[] stringArray) throws Exception {
        FDB fDB = FDB.selectAPIVersion((int)730);
        SidebandMultiThreadClientTest.setupThreads(fDB);
        Collection<Database> collection = clientHelper.openDatabases(fDB);
        for (Database database : collection) {
            db2Queues.put(database, new LinkedBlockingQueue());
        }
        System.out.println("Start processing and validating");
        SidebandMultiThreadClientTest.process(collection);
        SidebandMultiThreadClientTest.check(collection);
        System.out.println("Test finished");
    }

    private static synchronized void setupThreads(FDB fDB) {
        int n = clientHelper.readClusterFromEnv().length;
        fDB.options().setClientThreadsPerVersion((long)n);
        System.out.printf("thread per version is %d\n", n);
        fDB.options().setExternalClientDirectory("/var/dynamic-conf/lib");
        fDB.options().setTraceEnable("/tmp");
        fDB.options().setKnob("min_trace_severity=5");
    }

    private static void process(Collection<Database> collection) {
        for (Database database : collection) {
            for (int i = 0; i < 5; ++i) {
                Thread thread = new Thread(Producer.create(database, db2Queues.get(database)));
                thread.start();
            }
        }
    }

    private static void check(Collection<Database> collection) throws InterruptedException {
        int n;
        HashMap<Thread, Consumer> hashMap = new HashMap<Thread, Consumer>();
        for (Database object : collection) {
            for (n = 0; n < 5; ++n) {
                Consumer consumer = Consumer.create(object, db2Queues.get(object));
                Thread thread = new Thread(consumer);
                thread.start();
                hashMap.put(thread, consumer);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ((Thread)entry.getKey()).join();
            n = ((Consumer)entry.getValue()).succeed ? 1 : 0;
            Assertions.assertTrue(n != 0, (String)"Sideband test failed");
        }
    }

    public static class Consumer
    implements Runnable {
        private final Database db;
        private final BlockingQueue<String> queue;
        private boolean succeed;

        private Consumer(Database database, BlockingQueue<String> blockingQueue) {
            this.db = database;
            this.queue = blockingQueue;
            this.succeed = true;
        }

        public static Consumer create(Database database, BlockingQueue<String> blockingQueue) {
            return new Consumer(database, blockingQueue);
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 1000 && this.succeed; ++i) {
                    String string = this.queue.take();
                    this.db.run(transaction -> {
                        byte[] byArray = (byte[])transaction.get(Tuple.from((Object[])new Object[]{string}).pack()).join();
                        if (byArray == null) {
                            System.out.println("FAILED to get key " + string + " from DB " + this.db);
                            this.succeed = false;
                        }
                        if (!this.succeed) {
                            return null;
                        }
                        String string2 = Tuple.fromBytes((byte[])byArray).getString(0);
                        return null;
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Get Exception in consumer: " + interruptedException);
                this.succeed = false;
            }
        }
    }

    public static class Producer
    implements Runnable {
        private final Database db;
        private final BlockingQueue<String> queue;

        private Producer(Database database, BlockingQueue<String> blockingQueue) {
            this.db = database;
            this.queue = blockingQueue;
        }

        public static Producer create(Database database, BlockingQueue<String> blockingQueue) {
            return new Producer(database, blockingQueue);
        }

        @Override
        public void run() {
            for (int i = 0; i < 1000; ++i) {
                long l = ThreadLocalRandom.current().nextLong();
                String string = String.format("Sideband/Multithread/Test/%d", l);
                this.db.run(transaction -> {
                    transaction.set(Tuple.from((Object[])new Object[]{string}).pack(), Tuple.from((Object[])new Object[]{"bar"}).pack());
                    return null;
                });
                this.queue.offer(string);
            }
        }
    }
}

