/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.MultiClientHelper;
import com.apple.foundationdb.tuple.Tuple;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;

public class RepeatableReadMultiThreadClientTest {
    public static final MultiClientHelper clientHelper = new MultiClientHelper();
    private static final int oldValueReadCount = 30;
    private static final int threadPerDB = 5;
    private static final String key = "foo";
    private static final String initialValue = "bar";
    private static final String newValue = "cool";
    private static final Map<Thread, OldValueReader> threadToOldValueReaders = new HashMap<Thread, OldValueReader>();

    public static void main(String[] stringArray) throws Exception {
        FDB fDB = FDB.selectAPIVersion((int)730);
        RepeatableReadMultiThreadClientTest.setupThreads(fDB);
        Collection<Database> collection = clientHelper.openDatabases(fDB);
        System.out.println("Starting tests");
        RepeatableReadMultiThreadClientTest.setup(collection);
        System.out.println("Start processing and validating");
        RepeatableReadMultiThreadClientTest.readOldValue(collection);
        RepeatableReadMultiThreadClientTest.setNewValueAndRead(collection);
        System.out.println("Test finished");
    }

    private static synchronized void setupThreads(FDB fDB) {
        int n = clientHelper.readClusterFromEnv().length;
        fDB.options().setClientThreadsPerVersion((long)n);
        System.out.printf("thread per version is %d\n", n);
        fDB.options().setExternalClientDirectory("/var/dynamic-conf/lib");
        fDB.options().setTraceEnable("/tmp");
        fDB.options().setKnob("min_trace_severity=5");
    }

    private static void setup(Collection<Database> collection) {
        for (Database database : collection) {
            database.run(transaction -> {
                transaction.set(Tuple.from((Object[])new Object[]{key}).pack(), Tuple.from((Object[])new Object[]{initialValue}).pack());
                return null;
            });
        }
    }

    private static void readOldValue(Collection<Database> collection) throws InterruptedException {
        for (Database database : collection) {
            for (int i = 0; i < 5; ++i) {
                OldValueReader oldValueReader = new OldValueReader(database);
                Thread thread = new Thread(OldValueReader.create(database));
                thread.start();
                threadToOldValueReaders.put(thread, oldValueReader);
            }
        }
    }

    private static void setNewValueAndRead(Collection<Database> collection) throws InterruptedException {
        Thread.sleep(1000L);
        HashMap<Thread, NewValueReader> hashMap = new HashMap<Thread, NewValueReader>();
        for (Database object : collection) {
            for (int i = 0; i < 5; ++i) {
                NewValueReader newValueReader = new NewValueReader(object);
                Thread thread = new Thread(NewValueReader.create(object));
                thread.start();
                hashMap.put(thread, newValueReader);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ((Thread)entry.getKey()).join();
            Assertions.assertTrue((boolean)((NewValueReader)entry.getValue()).succeed, (String)"new value reader failed to read the correct value");
        }
        for (Map.Entry entry : threadToOldValueReaders.entrySet()) {
            Assertions.assertTrue((boolean)((Thread)entry.getKey()).isAlive(), (String)("Old value reader finished too soon, cannot verify repeatable read, succeed is " + ((OldValueReader)entry.getValue()).succeed));
        }
        for (Map.Entry entry : threadToOldValueReaders.entrySet()) {
            ((Thread)entry.getKey()).join();
            Assertions.assertTrue((boolean)((OldValueReader)entry.getValue()).succeed, (String)"old value reader failed to read the correct value");
        }
    }

    public static class NewValueReader
    implements Runnable {
        private final Database db;
        private boolean succeed;

        public NewValueReader(Database database) {
            this.db = database;
            this.succeed = true;
        }

        public static NewValueReader create(Database database) {
            return new NewValueReader(database);
        }

        @Override
        public void run() {
            this.db.run(transaction -> {
                transaction.set(Tuple.from((Object[])new Object[]{RepeatableReadMultiThreadClientTest.key}).pack(), Tuple.from((Object[])new Object[]{RepeatableReadMultiThreadClientTest.newValue}).pack());
                return null;
            });
            String string = (String)this.db.run(transaction -> {
                byte[] byArray = (byte[])transaction.get(Tuple.from((Object[])new Object[]{RepeatableReadMultiThreadClientTest.key}).pack()).join();
                return Tuple.fromBytes((byte[])byArray).getString(0);
            });
            if (!RepeatableReadMultiThreadClientTest.newValue.equals(string)) {
                this.succeed = false;
            }
        }
    }

    public static class OldValueReader
    implements Runnable {
        private final Database db;
        private boolean succeed;

        private OldValueReader(Database database) {
            this.db = database;
            this.succeed = true;
        }

        public static OldValueReader create(Database database) {
            return new OldValueReader(database);
        }

        @Override
        public void run() {
            this.db.run(transaction -> {
                try {
                    for (int i = 0; i < 30; ++i) {
                        byte[] byArray = (byte[])transaction.get(Tuple.from((Object[])new Object[]{RepeatableReadMultiThreadClientTest.key}).pack()).join();
                        String string = Tuple.fromBytes((byte[])byArray).getString(0);
                        if (!RepeatableReadMultiThreadClientTest.initialValue.equals(string)) {
                            this.succeed = false;
                            break;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception exception) {
                    this.succeed = false;
                }
                return null;
            });
        }
    }
}

