/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.RequiresDatabase;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.async.AsyncIterator;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RequiresDatabase.class})
class RangeQueryIntegrationTest {
    private static final FDB fdb = FDB.selectAPIVersion((int)730);

    RangeQueryIntegrationTest() {
    }

    @BeforeEach
    @AfterEach
    void clearDatabase() throws Exception {
        try (Database database = fdb.open();){
            database.run(transaction -> {
                transaction.clear(new byte[0], new byte[]{-1});
                return null;
            });
        }
    }

    private void loadData(Database database, Map<byte[], byte[]> map) {
        database.run(transaction -> {
            for (Map.Entry entry : map.entrySet()) {
                transaction.set((byte[])entry.getKey(), (byte[])entry.getValue());
            }
            return null;
        });
    }

    @Test
    public void canGetRowWithKeySelector() throws Exception {
        Random random = new Random();
        byte[] byArray = new byte[128];
        byte[] byArray2 = new byte[128];
        random.nextBytes(byArray);
        byArray[0] = -18;
        random.nextBytes(byArray2);
        TreeMap<byte[], byte[]> treeMap = new TreeMap<byte[], byte[]>(ByteArrayUtil.comparator());
        treeMap.put(byArray, byArray2);
        try (Database database = fdb.open();){
            this.loadData(database, treeMap);
            database.run(transaction -> {
                byte[] byArray3 = (byte[])transaction.get(byArray).join();
                Assertions.assertNotNull((Object)byArray3, (String)"Missing key!");
                Assertions.assertArrayEquals((byte[])byArray2, (byte[])byArray3, (String)"incorrect value!");
                KeySelector keySelector = KeySelector.firstGreaterOrEqual((byte[])new byte[]{byArray[0]});
                KeySelector keySelector2 = KeySelector.firstGreaterOrEqual((byte[])ByteArrayUtil.strinc((byte[])keySelector.getKey()));
                AsyncIterable asyncIterable = transaction.getRange(keySelector, keySelector2);
                AsyncIterator asyncIterator = asyncIterable.iterator();
                Assertions.assertTrue((boolean)asyncIterator.hasNext(), (String)"Did not return a record!");
                KeyValue keyValue = (KeyValue)asyncIterator.next();
                Assertions.assertArrayEquals((byte[])byArray, (byte[])keyValue.getKey(), (String)"Did not return a key correctly!");
                Assertions.assertArrayEquals((byte[])byArray2, (byte[])keyValue.getValue(), (String)"Did not return the corect value!");
                return null;
            });
        }
    }

    @Test
    void rangeQueryReturnsResults() throws Exception {
        try (Database database = fdb.open();){
            database.run(transaction -> {
                transaction.set("vcount".getBytes(), "zz".getBytes());
                return null;
            });
            database.run(transaction -> {
                AsyncIterable asyncIterable = transaction.getRange("v".getBytes(), "y".getBytes());
                int n = 0;
                for (KeyValue keyValue : asyncIterable) {
                    Assertions.assertArrayEquals((byte[])"vcount".getBytes(), (byte[])keyValue.getKey(), (String)"Incorrect key returned!");
                    Assertions.assertArrayEquals((byte[])"zz".getBytes(), (byte[])keyValue.getValue(), (String)"Incorrect value returned!");
                    ++n;
                }
                Assertions.assertEquals((int)1, (int)n, (String)"Incorrect number of KeyValues returned");
                return null;
            });
        }
    }

    @Test
    void rangeQueryReturnsEmptyOutsideRange() throws Exception {
        try (Database database = fdb.open();){
            database.run(transaction -> {
                transaction.set("rangeEmpty".getBytes(), "zz".getBytes());
                return null;
            });
            database.run(transaction -> {
                AsyncIterator asyncIterator = transaction.getRange("b".getBytes(), "c".getBytes()).iterator();
                if (asyncIterator.hasNext()) {
                    Assertions.fail((String)("Found kvs when it really shouldn't: returned key = " + ByteArrayUtil.printable((byte[])((KeyValue)asyncIterator.next()).getKey())));
                }
                return null;
            });
        }
    }

    @Test
    void rangeQueryOverMultipleRows() throws Exception {
        int n = 100;
        TreeMap treeMap = new TreeMap(ByteArrayUtil.comparator());
        try (Database database = fdb.open();){
            database.run(transaction -> {
                for (int i = 0; i < n; ++i) {
                    byte[] byArray = ("multiRow" + i).getBytes();
                    byte[] byArray2 = ("multiValue" + i).getBytes();
                    transaction.set(byArray, byArray2);
                    treeMap.put(byArray, byArray2);
                }
                return null;
            });
            database.run(transaction -> {
                AsyncIterator asyncIterator = transaction.getRange("multi".getBytes(), "multj".getBytes()).iterator();
                Iterator iterator = treeMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Assertions.assertTrue((boolean)asyncIterator.hasNext(), (String)"iterator ended too early");
                    KeyValue keyValue = (KeyValue)asyncIterator.next();
                    Map.Entry entry = iterator.next();
                    Assertions.assertArrayEquals((byte[])((byte[])entry.getKey()), (byte[])keyValue.getKey(), (String)"Incorrect key!");
                    Assertions.assertArrayEquals((byte[])((byte[])entry.getValue()), (byte[])keyValue.getValue(), (String)"Incorrect value!");
                }
                Assertions.assertFalse((boolean)asyncIterator.hasNext(), (String)"Iterator returned too much data");
                return null;
            });
        }
    }
}

