/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.KeySelector;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MappedKeyValue;
import com.apple.foundationdb.MultiClientHelper;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.RequiresDatabase;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RequiresDatabase.class})
class MappedRangeQueryIntegrationTest {
    private static final FDB fdb = FDB.selectAPIVersion((int)730);
    public String databaseArg = null;
    private static final byte[] EMPTY = Tuple.from((Object[])new Object[0]).pack();
    private static final String PREFIX = "prefix";
    private static final String RECORD = "RECORD";
    private static final String INDEX = "INDEX";
    static byte[] MAPPER = Tuple.from((Object[])new Object[]{"prefix", "RECORD", "{K[3]}", "{...}"}).pack();
    static int SPLIT_SIZE = 3;
    int numRecords = 10000;
    int numQueries = 1;
    int numRecordsPerQuery = 100;
    boolean validate = true;
    private static final int RECORDS_PER_TXN = 100;
    RangeQueryWithIndex rangeQueryAndThenRangeQueries = (n, n2, database) -> database.run(transaction -> {
        try {
            List list = (List)transaction.getRange(KeySelector.firstGreaterOrEqual((byte[])MappedRangeQueryIntegrationTest.indexEntryKey(n)), KeySelector.firstGreaterOrEqual((byte[])MappedRangeQueryIntegrationTest.indexEntryKey(n2)), 0, false, StreamingMode.WANT_ALL).asList().get();
            Assertions.assertEquals((int)(n2 - n), (int)list.size());
            ArrayList<CompletableFuture> arrayList = new ArrayList<CompletableFuture>();
            for (int i = n; i < n2; ++i) {
                arrayList.add(transaction.getRange(Range.startsWith((byte[])MappedRangeQueryIntegrationTest.recordKeyPrefix(i)), 0, false, StreamingMode.WANT_ALL).asList());
            }
            AsyncUtil.whenAll(arrayList).get();
            if (this.validate) {
                Iterator iterator = list.iterator();
                Iterator iterator2 = arrayList.iterator();
                for (int i = n; i < n2; ++i) {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    this.assertByteArrayEquals(MappedRangeQueryIntegrationTest.indexEntryKey(i), ((KeyValue)iterator.next()).getKey());
                    Assertions.assertTrue((boolean)iterator2.hasNext());
                    List list2 = (List)((CompletableFuture)iterator2.next()).get();
                    this.validateRangeResult(i, list2);
                }
                Assertions.assertFalse((boolean)iterator.hasNext());
                Assertions.assertFalse((boolean)iterator2.hasNext());
            }
        }
        catch (Exception exception) {
            Assertions.fail((String)"Unexpected exception", (Throwable)exception);
        }
        return null;
    });
    RangeQueryWithIndex mappedRangeQuery = (n, n2, database) -> database.run(transaction -> {
        try {
            List list = (List)transaction.getMappedRange(KeySelector.firstGreaterOrEqual((byte[])MappedRangeQueryIntegrationTest.indexEntryKey(n)), KeySelector.firstGreaterOrEqual((byte[])MappedRangeQueryIntegrationTest.indexEntryKey(n2)), MAPPER, 0, false, StreamingMode.WANT_ALL).asList().get();
            Assertions.assertEquals((int)(n2 - n), (int)list.size());
            if (this.validate) {
                Iterator iterator = list.iterator();
                for (int i = n; i < n2; ++i) {
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    MappedKeyValue mappedKeyValue = (MappedKeyValue)iterator.next();
                    this.assertByteArrayEquals(MappedRangeQueryIntegrationTest.indexEntryKey(i), mappedKeyValue.getKey());
                    this.assertByteArrayEquals(EMPTY, mappedKeyValue.getValue());
                    this.assertByteArrayEquals(MappedRangeQueryIntegrationTest.indexEntryKey(i), mappedKeyValue.getKey());
                    byte[] byArray = MappedRangeQueryIntegrationTest.recordKeyPrefix(i);
                    this.assertByteArrayEquals(byArray, mappedKeyValue.getRangeBegin());
                    byArray[byArray.length - 1] = 1;
                    this.assertByteArrayEquals(byArray, mappedKeyValue.getRangeEnd());
                    List list2 = mappedKeyValue.getRangeResult();
                    this.validateRangeResult(i, list2);
                }
                Assertions.assertFalse((boolean)iterator.hasNext());
            }
        }
        catch (Exception exception) {
            Assertions.fail((String)"Unexpected exception", (Throwable)exception);
        }
        return null;
    });

    MappedRangeQueryIntegrationTest() {
    }

    private Database openFDB() {
        return fdb.open(this.databaseArg);
    }

    @BeforeEach
    @AfterEach
    void clearDatabase() throws Exception {
        try (Database database = this.openFDB();){
            database.run(transaction -> {
                transaction.clear(new byte[0], new byte[]{-1});
                return null;
            });
        }
    }

    private static String primaryKey(int n) {
        return String.format("primary-key-of-record-%08d", n);
    }

    private static String indexKey(int n) {
        return String.format("index-key-of-record-%08d", n);
    }

    private static String dataOfRecord(int n) {
        return String.format("data-of-record-%08d", n);
    }

    private static byte[] indexEntryKey(int n) {
        return Tuple.from((Object[])new Object[]{PREFIX, INDEX, MappedRangeQueryIntegrationTest.indexKey(n), MappedRangeQueryIntegrationTest.primaryKey(n)}).pack();
    }

    private static byte[] recordKeyPrefix(int n) {
        return Tuple.from((Object[])new Object[]{PREFIX, RECORD, MappedRangeQueryIntegrationTest.primaryKey(n)}).pack();
    }

    private static byte[] recordKey(int n, int n2) {
        return Tuple.from((Object[])new Object[]{PREFIX, RECORD, MappedRangeQueryIntegrationTest.primaryKey(n), n2}).pack();
    }

    private static byte[] recordValue(int n, int n2) {
        return Tuple.from((Object[])new Object[]{MappedRangeQueryIntegrationTest.dataOfRecord(n), n2}).pack();
    }

    private static void insertRecordWithIndex(Transaction transaction, int n) {
        transaction.set(MappedRangeQueryIntegrationTest.indexEntryKey(n), EMPTY);
        for (int i = 0; i < SPLIT_SIZE; ++i) {
            transaction.set(MappedRangeQueryIntegrationTest.recordKey(n, i), MappedRangeQueryIntegrationTest.recordValue(n, i));
        }
    }

    private static String getArgFromEnv() {
        String[] stringArray = MultiClientHelper.readClusterFromEnv();
        String string = stringArray[0];
        System.out.printf("Using Cluster: %s\n", string);
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        MappedRangeQueryIntegrationTest mappedRangeQueryIntegrationTest = new MappedRangeQueryIntegrationTest();
        mappedRangeQueryIntegrationTest.databaseArg = MappedRangeQueryIntegrationTest.getArgFromEnv();
        mappedRangeQueryIntegrationTest.clearDatabase();
        mappedRangeQueryIntegrationTest.comparePerformance();
        mappedRangeQueryIntegrationTest.clearDatabase();
    }

    @Test
    void comparePerformance() {
        FDB fDB = FDB.selectAPIVersion((int)730);
        try (Database database = this.openFDB();){
            MappedRangeQueryIntegrationTest.insertRecordsWithIndexes(this.numRecords, database);
            this.instrument(this.rangeQueryAndThenRangeQueries, "rangeQueryAndThenRangeQueries", database);
            this.instrument(this.mappedRangeQuery, "mappedRangeQuery", database);
        }
    }

    private void instrument(RangeQueryWithIndex rangeQueryWithIndex, String string, Database database) {
        System.out.printf("Starting %s (numQueries:%d, numRecordsPerQuery:%d, validation:%s)\n", string, this.numQueries, this.numRecordsPerQuery, this.validate ? "on" : "off");
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.numQueries; ++i) {
            int n = ThreadLocalRandom.current().nextInt(this.numRecords - this.numRecordsPerQuery);
            rangeQueryWithIndex.run(n, n + this.numRecordsPerQuery, database);
        }
        long l2 = System.currentTimeMillis() - l;
        System.out.printf("Finished %s, it takes %d ms for %d queries (%d qps)\n", string, l2, this.numQueries, (long)this.numQueries * 1000L / l2);
    }

    private static void insertRecordsWithIndexes(int n, Database database) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            int n4 = Math.min(n, n2 + 100);
            database.run(transaction -> {
                for (int i = n3; i < n4; ++i) {
                    MappedRangeQueryIntegrationTest.insertRecordWithIndex(transaction, i);
                }
                return null;
            });
            n2 = n4;
        }
    }

    void validateRangeResult(int n, List<KeyValue> list) {
        Assertions.assertEquals((int)list.size(), (int)SPLIT_SIZE);
        for (int i = 0; i < SPLIT_SIZE; ++i) {
            KeyValue keyValue = list.get(i);
            this.assertByteArrayEquals(MappedRangeQueryIntegrationTest.recordKey(n, i), keyValue.getKey());
            this.assertByteArrayEquals(MappedRangeQueryIntegrationTest.recordValue(n, i), keyValue.getValue());
        }
    }

    void assertByteArrayEquals(byte[] byArray, byte[] byArray2) {
        Assertions.assertEquals((Object)ByteArrayUtil.printable((byte[])byArray), (Object)ByteArrayUtil.printable((byte[])byArray2));
    }

    public static interface RangeQueryWithIndex {
        public void run(int var1, int var2, Database var3);
    }
}

