/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.tuple;

import com.apple.foundationdb.tuple.FastByteComparisons;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ByteArrayUtil
extends FastByteComparisons {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] join(byte[] byArray, List<byte[]> list) {
        return ByteArrayUtil.interludeJoin(byArray, (byte[][])list.toArray((T[])new byte[0][]));
    }

    public static byte[] interludeJoin(byte[] byArray, byte[][] byArray2) {
        if (byArray2 == null) {
            return new byte[0];
        }
        int n = byArray2.length;
        if (n == 0) {
            return EMPTY_BYTES;
        }
        if (byArray == null) {
            byArray = EMPTY_BYTES;
        }
        int n2 = 0;
        int n3 = byArray.length;
        for (int i = 0; i < n; ++i) {
            n2 += byArray2[i].length;
        }
        byte[] byArray3 = new byte[n3 * (n - 1) + n2];
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = byArray2[i].length;
            if (n6 > 0) {
                System.arraycopy(byArray2[i], 0, byArray3, n4, n6);
                n4 += n6;
            }
            if (n5 < n - 1 && n3 > 0) {
                System.arraycopy(byArray, 0, byArray3, n4, n3);
                n4 += n3;
            }
            ++n5;
        }
        return byArray3;
    }

    public static byte[] join(byte[] ... byArray) {
        return ByteArrayUtil.interludeJoin(null, byArray);
    }

    static boolean regionEquals(byte[] byArray, int n, byte[] byArray2) {
        if (byArray == null) {
            if (n == 0) {
                return byArray2 == null;
            }
            throw new IllegalArgumentException("start index after end of src");
        }
        if (byArray2 == null) {
            return false;
        }
        if (n >= byArray.length) {
            throw new IllegalArgumentException("start index after end of src");
        }
        if (byArray.length < n + byArray2.length) {
            return false;
        }
        return ByteArrayUtil.compareTo(byArray, n, byArray2.length, byArray2, 0, byArray2.length) == 0;
    }

    public static byte[] replace(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            return null;
        }
        return ByteArrayUtil.replace(byArray, 0, byArray.length, byArray2, byArray3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] replace(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) {
        ByteBuffer byteBuffer;
        if (n < 0 || n > byArray.length) {
            throw new IllegalArgumentException("Invalid offset for array pattern replacement");
        }
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Invalid length for array pattern replacement");
        }
        if (byArray2 == null || byArray2.length == 0) {
            return Arrays.copyOfRange(byArray, n, n + n2);
        }
        if (byArray3 == null || byArray3.length != byArray2.length) {
            int n3 = ByteArrayUtil.replace(byArray, n, n2, byArray2, byArray3, null);
            if (n3 == n2) return Arrays.copyOfRange(byArray, n, n + n2);
            byteBuffer = ByteBuffer.allocate(n3);
        } else {
            byteBuffer = ByteBuffer.allocate(n2);
        }
        ByteArrayUtil.replace(byArray, n, n2, byArray2, byArray3, byteBuffer);
        return byteBuffer.array();
    }

    static int replace(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, ByteBuffer byteBuffer) {
        int n3;
        if (byArray2 == null || byArray2.length == 0) {
            if (byteBuffer != null) {
                byteBuffer.put(byArray, n, n2);
            }
            return n2;
        }
        byte by = byArray2[0];
        int n4 = n;
        int n5 = n;
        int n6 = 0;
        int n7 = n3 = byArray3 == null ? 0 : byArray3.length;
        while (n5 < n + n2) {
            if (byArray[n5] == by && ByteArrayUtil.regionEquals(byArray, n5, byArray2)) {
                if (byteBuffer != null) {
                    byteBuffer.put(byArray, n4, n5 - n4);
                    if (byArray3 != null) {
                        byteBuffer.put(byArray3);
                    }
                }
                n6 += n5 - n4 + n3;
                n4 = n5 += byArray2.length;
                continue;
            }
            ++n5;
        }
        n6 += n5 - n4;
        if (byteBuffer != null) {
            byteBuffer.put(byArray, n4, n5 - n4);
        }
        return n6;
    }

    public static List<byte[]> split(byte[] byArray, byte[] byArray2) {
        return ByteArrayUtil.split(byArray, 0, byArray.length, byArray2);
    }

    public static List<byte[]> split(byte[] byArray, int n, int n2, byte[] byArray2) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n3 = n;
        int n4 = n;
        while (n3 <= n + n2 - byArray2.length) {
            if (ByteArrayUtil.regionEquals(byArray, n3, byArray2)) {
                linkedList.add(Arrays.copyOfRange(byArray, n4, n3));
                n4 = n3 += byArray2.length;
                continue;
            }
            ++n3;
        }
        if (n4 == n + n2) {
            linkedList.add(new byte[0]);
        } else {
            linkedList.add(Arrays.copyOfRange(byArray, n4, n + n2));
        }
        return linkedList;
    }

    public static int compareUnsigned(byte[] byArray, byte[] byArray2) {
        return ByteArrayUtil.compareTo(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public static Comparator<byte[]> comparator() {
        return FastByteComparisons.comparator();
    }

    public static boolean startsWith(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        return ByteArrayUtil.compareTo(byArray, 0, byArray2.length, byArray2, 0, byArray2.length) == 0;
    }

    public static byte[] strinc(byte[] byArray) {
        byte[] byArray2 = ByteArrayUtil.rstrip(byArray, (byte)-1);
        if (byArray2.length == 0) {
            throw new IllegalArgumentException("No key beyond supplied prefix");
        }
        byArray2[byArray2.length - 1] = (byte)(byArray2[byArray2.length - 1] + 1);
        return byArray2;
    }

    public static byte[] keyAfter(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        return byArray2;
    }

    static byte[] rstrip(byte[] byArray, byte by) {
        int n;
        for (n = byArray.length - 1; n >= 0 && byArray[n] == by; --n) {
        }
        return Arrays.copyOfRange(byArray, 0, n + 1);
    }

    public static byte[] encodeInt(long l) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(l).array();
    }

    public static long decodeInt(byte[] byArray) {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Source array must be of length 8");
        }
        return ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String printable(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 32 && by < 127 && by != 92) {
                stringBuilder.append((char)by);
                continue;
            }
            if (by == 92) {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append("\\x");
            int n = (by & 0xF0) >> 4;
            stringBuilder.append(hexChars[n]);
            n = by & 0xF;
            stringBuilder.append(hexChars[n]);
        }
        return stringBuilder.toString();
    }

    static int nullCount(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            ++n;
        }
        return n;
    }

    private ByteArrayUtil() {
    }
}

