/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.TreeNode;
import org.junit.platform.console.tasks.TreePrinter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class TreePrintingListener
implements TestExecutionListener {
    private final Map<String, TreeNode> nodesByUniqueId = new ConcurrentHashMap<String, TreeNode>();
    private TreeNode root;
    private final TreePrinter treePrinter;

    TreePrintingListener(PrintWriter out, boolean disableAnsiColors, Theme theme) {
        this.treePrinter = new TreePrinter(out, theme, disableAnsiColors);
    }

    private TreeNode addNode(TestIdentifier testIdentifier, Supplier<TreeNode> nodeSupplier) {
        TreeNode node = nodeSupplier.get();
        this.nodesByUniqueId.put(testIdentifier.getUniqueId(), node);
        testIdentifier.getParentId().map(this.nodesByUniqueId::get).orElse(this.root).addChild(node);
        return node;
    }

    private TreeNode getNode(TestIdentifier testIdentifier) {
        return this.nodesByUniqueId.get(testIdentifier.getUniqueId());
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.root = new TreeNode(testPlan.toString());
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.treePrinter.print(this.root);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.addNode(testIdentifier, () -> new TreeNode(testIdentifier));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.getNode(testIdentifier).setResult(testExecutionResult);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.addNode(testIdentifier, () -> new TreeNode(testIdentifier, reason));
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.getNode(testIdentifier).addReportEntry(entry);
    }
}

