#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
/*
 * WatchesSameKeyCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "flow/DeterministicRandom.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct WatchesSameKeyWorkload : TestWorkload {
	static constexpr auto NAME = "WatchesSameKeyCorrectness";
	int numWatches;
	std::vector<Future<Void>> cases;

	WatchesSameKeyWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		numWatches = getOption(options, "numWatches"_sr, 3);
	}

	Future<Void> setup(Database const& cx) override {
		cases.push_back(case1(cx, "foo1"_sr, this));
		cases.push_back(case2(cx, "foo2"_sr, this));
		cases.push_back(case3(cx, "foo3"_sr, this));
		cases.push_back(case4(cx, "foo4"_sr, this));
		cases.push_back(case5(cx, "foo5"_sr, this));
		return Void();
	}

	Future<Void> start(Database const& cx) override { return waitForAll(cases); }

	Future<bool> check(Database const& cx) override {
		bool ok = true;
		for (int i = 0; i < cases.size(); i++) {
			if (cases[i].isError())
				ok = false;
		}
		cases.clear();
		return ok;
	}

																#line 60 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
// This generated class is to be used only via setKeyRandomValue()
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
template <class SetKeyRandomValueActor>
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class SetKeyRandomValueActorState {
															#line 66 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	SetKeyRandomValueActorState(Database const& cx,Key const& key,Optional<Value> const& val) 
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		 : cx(cx),
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   key(key),
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   val(val),
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr(cx)
															#line 79 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("setKeyRandomValue", reinterpret_cast<unsigned long>(this));

	}
	~SetKeyRandomValueActorState() 
	{
		fdb_probe_actor_destroy("setKeyRandomValue", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			;
															#line 94 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeyRandomValueActorState();
		static_cast<SetKeyRandomValueActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			Value valS;
															#line 64 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (!val.present())
															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			{
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
				valS = Value(deterministicRandom()->randomUniqueID().toString());
															#line 131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			}
			else
			{
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
				valS = val.get();
															#line 137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			}
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr.set(key, valS);
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state = 1;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeyRandomValueActor, 0, Void >*>(static_cast<SetKeyRandomValueActor*>(this)));
															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state = 2;
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetKeyRandomValueActor, 1, Void >*>(static_cast<SetKeyRandomValueActor*>(this)));
															#line 179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<SetKeyRandomValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeyRandomValueActorState(); static_cast<SetKeyRandomValueActor*>(this)->destroy(); return 0; }
															#line 194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<SetKeyRandomValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeyRandomValueActorState();
		static_cast<SetKeyRandomValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<SetKeyRandomValueActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeyRandomValueActorState(); static_cast<SetKeyRandomValueActor*>(this)->destroy(); return 0; }
															#line 206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<SetKeyRandomValueActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeyRandomValueActorState();
		static_cast<SetKeyRandomValueActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state > 0) static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeyRandomValueActor*>(this)->ActorCallback< SetKeyRandomValueActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeyRandomValueActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyRandomValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeyRandomValueActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyRandomValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeyRandomValueActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyRandomValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state > 0) static_cast<SetKeyRandomValueActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeyRandomValueActor*>(this)->ActorCallback< SetKeyRandomValueActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeyRandomValueActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyRandomValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetKeyRandomValueActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyRandomValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetKeyRandomValueActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyRandomValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeyRandomValue", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Database cx;
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Key key;
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Optional<Value> val;
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
};
// This generated class is to be used only via setKeyRandomValue()
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class SetKeyRandomValueActor final : public Actor<Void>, public ActorCallback< SetKeyRandomValueActor, 0, Void >, public ActorCallback< SetKeyRandomValueActor, 1, Void >, public FastAllocated<SetKeyRandomValueActor>, public SetKeyRandomValueActorState<SetKeyRandomValueActor> {
															#line 389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
	using FastAllocated<SetKeyRandomValueActor>::operator new;
	using FastAllocated<SetKeyRandomValueActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1876433363730421504UL, 10971035954207977472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeyRandomValueActor, 0, Void >;
friend struct ActorCallback< SetKeyRandomValueActor, 1, Void >;
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	SetKeyRandomValueActor(Database const& cx,Key const& key,Optional<Value> const& val) 
															#line 407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   SetKeyRandomValueActorState<SetKeyRandomValueActor>(cx, key, val),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKeyRandomValue", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15984779955087813632UL, 16564456913347978240UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeyRandomValueActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKeyRandomValue");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKeyRandomValue", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeyRandomValueActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetKeyRandomValueActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> setKeyRandomValue( Database const& cx, Key const& key, Optional<Value> const& val ) {
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	return Future<Void>(new SetKeyRandomValueActor(cx, key, val));
															#line 440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
}

#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"

																#line 445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
// This generated class is to be used only via watchKey()
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
template <class WatchKeyActor>
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class WatchKeyActorState {
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	WatchKeyActorState(Database const& cx,Key const& key) 
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		 : cx(cx),
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   key(key),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr(cx)
															#line 462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("watchKey", reinterpret_cast<unsigned long>(this));

	}
	~WatchKeyActorState() 
	{
		fdb_probe_actor_destroy("watchKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			;
															#line 477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchKeyActorState();
		static_cast<WatchKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watchFuture = tr.watch(key);
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<WatchKeyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WatchKeyActor*>(this)->actor_wait_state = 1;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchKeyActor, 0, Void >*>(static_cast<WatchKeyActor*>(this)));
															#line 517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<WatchKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WatchKeyActor*>(this)->actor_wait_state = 2;
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchKeyActor, 1, Void >*>(static_cast<WatchKeyActor*>(this)));
															#line 546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<WatchKeyActor*>(this)->SAV<Future<Void>>::futures) { (void)(watchFuture); this->~WatchKeyActorState(); static_cast<WatchKeyActor*>(this)->destroy(); return 0; }
															#line 561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<WatchKeyActor*>(this)->SAV< Future<Void> >::value()) Future<Void>(std::move(watchFuture)); // state_var_RVO
		this->~WatchKeyActorState();
		static_cast<WatchKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<WatchKeyActor*>(this)->SAV<Future<Void>>::futures) { (void)(watchFuture); this->~WatchKeyActorState(); static_cast<WatchKeyActor*>(this)->destroy(); return 0; }
															#line 573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<WatchKeyActor*>(this)->SAV< Future<Void> >::value()) Future<Void>(std::move(watchFuture)); // state_var_RVO
		this->~WatchKeyActorState();
		static_cast<WatchKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchKeyActor*>(this)->actor_wait_state > 0) static_cast<WatchKeyActor*>(this)->actor_wait_state = 0;
		static_cast<WatchKeyActor*>(this)->ActorCallback< WatchKeyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchKeyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchKeyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchKeyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WatchKeyActor*>(this)->actor_wait_state > 0) static_cast<WatchKeyActor*>(this)->actor_wait_state = 0;
		static_cast<WatchKeyActor*>(this)->ActorCallback< WatchKeyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchKeyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchKeyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchKeyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Database cx;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Key key;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watchFuture;
															#line 751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
};
// This generated class is to be used only via watchKey()
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class WatchKeyActor final : public Actor<Future<Void>>, public ActorCallback< WatchKeyActor, 0, Void >, public ActorCallback< WatchKeyActor, 1, Void >, public FastAllocated<WatchKeyActor>, public WatchKeyActorState<WatchKeyActor> {
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
	using FastAllocated<WatchKeyActor>::operator new;
	using FastAllocated<WatchKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5055898733557412608UL, 15372306828466538496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Future<Void>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchKeyActor, 0, Void >;
friend struct ActorCallback< WatchKeyActor, 1, Void >;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	WatchKeyActor(Database const& cx,Key const& key) 
															#line 774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		 : Actor<Future<Void>>(),
		   WatchKeyActorState<WatchKeyActor>(cx, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10026342730243427840UL, 1931035960421840640UL);
		ActorExecutionContextHelper __helper(static_cast<WatchKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchKeyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WatchKeyActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
[[nodiscard]] static Future<Future<Void>> watchKey( Database const& cx, Key const& key ) {
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	return Future<Future<Void>>(new WatchKeyActor(cx, key));
															#line 807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
}

#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"

																#line 812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
// This generated class is to be used only via case1()
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
template <class Case1Actor>
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case1ActorState {
															#line 818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case1ActorState(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		 : cx(cx),
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   key(key),
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   self(self),
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr(cx)
															#line 831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("case1", reinterpret_cast<unsigned long>(this));

	}
	~Case1ActorState() 
	{
		fdb_probe_actor_destroy("case1", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			;
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Case1ActorState();
		static_cast<Case1Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watchFutures = std::vector<Future<Void>>();
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			i = int();
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr.set(key, Value(deterministicRandom()->randomUniqueID().toString()));
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			for(i = 0;i < self->numWatches;i++) {
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
				watchFutures.push_back(tr.watch(key));
															#line 885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			}
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Case1Actor*>(this)->actor_wait_state = 1;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Case1Actor, 0, Void >*>(static_cast<Case1Actor*>(this)));
															#line 896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case1Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<Case1Actor*>(this)->actor_wait_state = 4;
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case1Actor, 3, Void >*>(static_cast<Case1Actor*>(this)));
															#line 925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case1Actor*>(this)->actor_wait_state = 2;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case1Actor, 1, Void >*>(static_cast<Case1Actor*>(this)));
															#line 947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case1Actor*>(this)->actor_wait_state = 2;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case1Actor, 1, Void >*>(static_cast<Case1Actor*>(this)));
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Case1Actor*>(this)->actor_wait_state > 0) static_cast<Case1Actor*>(this)->actor_wait_state = 0;
		static_cast<Case1Actor*>(this)->ActorCallback< Case1Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case1Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Case1Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Case1Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i = 0;
															#line 1047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i = 0;
															#line 1056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Case1Actor*>(this)->actor_wait_state > 0) static_cast<Case1Actor*>(this)->actor_wait_state = 0;
		static_cast<Case1Actor*>(this)->ActorCallback< Case1Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case1Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Case1Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Case1Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case1Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case1ActorState(); static_cast<Case1Actor*>(this)->destroy(); return 0; }
															#line 1140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case1Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case1ActorState();
		static_cast<Case1Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!(i < watchFutures.size()))
															#line 1159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		{
			return a_body1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFutures[i];
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case1Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case1Actor*>(this)->actor_wait_state = 3;
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case1Actor, 2, Void >*>(static_cast<Case1Actor*>(this)));
															#line 1172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i++;
															#line 1194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i++;
															#line 1203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Case1Actor*>(this)->actor_wait_state > 0) static_cast<Case1Actor*>(this)->actor_wait_state = 0;
		static_cast<Case1Actor*>(this)->ActorCallback< Case1Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case1Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Case1Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Case1Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<Case1Actor*>(this)->actor_wait_state > 0) static_cast<Case1Actor*>(this)->actor_wait_state = 0;
		static_cast<Case1Actor*>(this)->ActorCallback< Case1Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case1Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< Case1Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< Case1Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Database cx;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Key key;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	WatchesSameKeyWorkload* self;
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	std::vector<Future<Void>> watchFutures;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	int i;
															#line 1382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
};
// This generated class is to be used only via case1()
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case1Actor final : public Actor<Void>, public ActorCallback< Case1Actor, 0, Void >, public ActorCallback< Case1Actor, 1, Void >, public ActorCallback< Case1Actor, 2, Void >, public ActorCallback< Case1Actor, 3, Void >, public FastAllocated<Case1Actor>, public Case1ActorState<Case1Actor> {
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
	using FastAllocated<Case1Actor>::operator new;
	using FastAllocated<Case1Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10468987398249320448UL, 2558507523935876352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Case1Actor, 0, Void >;
friend struct ActorCallback< Case1Actor, 1, Void >;
friend struct ActorCallback< Case1Actor, 2, Void >;
friend struct ActorCallback< Case1Actor, 3, Void >;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case1Actor(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 1407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   Case1ActorState<Case1Actor>(cx, key, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("case1", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9149354048211215104UL, 4220498572653002240UL);
		ActorExecutionContextHelper __helper(static_cast<Case1Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("case1");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("case1", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Case1Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Case1Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Case1Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< Case1Actor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> case1( Database const& cx, Key const& key, WatchesSameKeyWorkload* const& self ) {
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	return Future<Void>(new Case1Actor(cx, key, self));
															#line 1442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
}

#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"

																#line 1447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
// This generated class is to be used only via case2()
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
template <class Case2Actor>
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case2ActorState {
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case2ActorState(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		 : cx(cx),
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   key(key),
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   self(self),
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr(cx)
															#line 1466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("case2", reinterpret_cast<unsigned long>(this));

	}
	~Case2ActorState() 
	{
		fdb_probe_actor_destroy("case2", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			;
															#line 1481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Case2ActorState();
		static_cast<Case2Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watchFutures = std::vector<Future<Void>>();
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Future<Void>> __when_expr_0 = watchKey(cx, key);
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Case2Actor*>(this)->actor_wait_state = 1;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 0, Future<Void> >*>(static_cast<Case2Actor*>(this)));
															#line 1521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<Case2Actor*>(this)->actor_wait_state = 6;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 5, Void >*>(static_cast<Case2Actor*>(this)));
															#line 1550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i = int();
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		tr.set(key, Value(deterministicRandom()->randomUniqueID().toString()));
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		for(i = 0;i < self->numWatches;i++) {
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watchFutures.push_back(tr.watch(key));
															#line 1571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		}
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case2Actor*>(this)->actor_wait_state = 2;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 1, Void >*>(static_cast<Case2Actor*>(this)));
															#line 1582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Future<Void> const& __watch1,int loopDepth) 
	{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch1 = __watch1;
															#line 1591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Future<Void> && __watch1,int loopDepth) 
	{
		watch1 = std::move(__watch1);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Case2Actor*>(this)->actor_wait_state > 0) static_cast<Case2Actor*>(this)->actor_wait_state = 0;
		static_cast<Case2Actor*>(this)->ActorCallback< Case2Actor, 0, Future<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< Case2Actor, 0, Future<Void> >*,Future<Void> const& value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Case2Actor, 0, Future<Void> >*,Future<Void> && value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Case2Actor, 0, Future<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch1;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case2Actor*>(this)->actor_wait_state = 3;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 2, Void >*>(static_cast<Case2Actor*>(this)));
															#line 1677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch1;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case2Actor*>(this)->actor_wait_state = 3;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 2, Void >*>(static_cast<Case2Actor*>(this)));
															#line 1693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Case2Actor*>(this)->actor_wait_state > 0) static_cast<Case2Actor*>(this)->actor_wait_state = 0;
		static_cast<Case2Actor*>(this)->ActorCallback< Case2Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case2Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Case2Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Case2Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<Case2Actor*>(this)->actor_wait_state = 4;
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 3, Void >*>(static_cast<Case2Actor*>(this)));
															#line 1784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<Case2Actor*>(this)->actor_wait_state = 4;
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 3, Void >*>(static_cast<Case2Actor*>(this)));
															#line 1800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Case2Actor*>(this)->actor_wait_state > 0) static_cast<Case2Actor*>(this)->actor_wait_state = 0;
		static_cast<Case2Actor*>(this)->ActorCallback< Case2Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case2Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Case2Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Case2Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i = 0;
															#line 1884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i = 0;
															#line 1893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<Case2Actor*>(this)->actor_wait_state > 0) static_cast<Case2Actor*>(this)->actor_wait_state = 0;
		static_cast<Case2Actor*>(this)->ActorCallback< Case2Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case2Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< Case2Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< Case2Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case2Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case2ActorState(); static_cast<Case2Actor*>(this)->destroy(); return 0; }
															#line 1977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case2Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case2ActorState();
		static_cast<Case2Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1(int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!(i < watchFutures.size()))
															#line 1996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		{
			return a_body1loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watchFutures[i];
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case2Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<Case2Actor*>(this)->actor_wait_state = 5;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< Case2Actor, 4, Void >*>(static_cast<Case2Actor*>(this)));
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i++;
															#line 2031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		i++;
															#line 2040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<Case2Actor*>(this)->actor_wait_state > 0) static_cast<Case2Actor*>(this)->actor_wait_state = 0;
		static_cast<Case2Actor*>(this)->ActorCallback< Case2Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case2Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< Case2Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< Case2Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<Case2Actor*>(this)->actor_wait_state > 0) static_cast<Case2Actor*>(this)->actor_wait_state = 0;
		static_cast<Case2Actor*>(this)->ActorCallback< Case2Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case2Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< Case2Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< Case2Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Database cx;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Key key;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	WatchesSameKeyWorkload* self;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	std::vector<Future<Void>> watchFutures;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watch1;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	int i;
															#line 2221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
};
// This generated class is to be used only via case2()
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case2Actor final : public Actor<Void>, public ActorCallback< Case2Actor, 0, Future<Void> >, public ActorCallback< Case2Actor, 1, Void >, public ActorCallback< Case2Actor, 2, Void >, public ActorCallback< Case2Actor, 3, Void >, public ActorCallback< Case2Actor, 4, Void >, public ActorCallback< Case2Actor, 5, Void >, public FastAllocated<Case2Actor>, public Case2ActorState<Case2Actor> {
															#line 2226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
	using FastAllocated<Case2Actor>::operator new;
	using FastAllocated<Case2Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14393000841813660672UL, 12057839318416250624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Case2Actor, 0, Future<Void> >;
friend struct ActorCallback< Case2Actor, 1, Void >;
friend struct ActorCallback< Case2Actor, 2, Void >;
friend struct ActorCallback< Case2Actor, 3, Void >;
friend struct ActorCallback< Case2Actor, 4, Void >;
friend struct ActorCallback< Case2Actor, 5, Void >;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case2Actor(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 2248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   Case2ActorState<Case2Actor>(cx, key, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("case2", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16703765253120920320UL, 4413566808945493504UL);
		ActorExecutionContextHelper __helper(static_cast<Case2Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("case2");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("case2", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Case2Actor, 0, Future<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Case2Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Case2Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< Case2Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< Case2Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< Case2Actor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> case2( Database const& cx, Key const& key, WatchesSameKeyWorkload* const& self ) {
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	return Future<Void>(new Case2Actor(cx, key, self));
															#line 2285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
}

#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"

																#line 2290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
// This generated class is to be used only via case3()
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
template <class Case3Actor>
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case3ActorState {
															#line 2296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case3ActorState(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		 : cx(cx),
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   key(key),
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   self(self),
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr(cx),
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr2(cx),
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   val()
															#line 2313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("case3", reinterpret_cast<unsigned long>(this));

	}
	~Case3ActorState() 
	{
		fdb_probe_actor_destroy("case3", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			;
															#line 2328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Case3ActorState();
		static_cast<Case3Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			val = deterministicRandom()->randomUniqueID().toString();
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr2.set(key, val);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watch1 = tr2.watch(key);
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr2.commit();
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case3Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Case3Actor*>(this)->actor_wait_state = 1;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Case3Actor, 0, Void >*>(static_cast<Case3Actor*>(this)));
															#line 2372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e) && tr2.onError(e);
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case3Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<Case3Actor*>(this)->actor_wait_state = 4;
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case3Actor, 3, Void >*>(static_cast<Case3Actor*>(this)));
															#line 2401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case3Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case3Actor*>(this)->actor_wait_state = 2;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case3Actor, 1, Void >*>(static_cast<Case3Actor*>(this)));
															#line 2423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case3Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case3Actor*>(this)->actor_wait_state = 2;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case3Actor, 1, Void >*>(static_cast<Case3Actor*>(this)));
															#line 2439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Case3Actor*>(this)->actor_wait_state > 0) static_cast<Case3Actor*>(this)->actor_wait_state = 0;
		static_cast<Case3Actor*>(this)->ActorCallback< Case3Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case3Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Case3Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Case3Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		tr.set(key, val);
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch2 = tr.watch(key);
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case3Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case3Actor*>(this)->actor_wait_state = 3;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case3Actor, 2, Void >*>(static_cast<Case3Actor*>(this)));
															#line 2534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		tr.set(key, val);
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch2 = tr.watch(key);
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case3Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case3Actor*>(this)->actor_wait_state = 3;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case3Actor, 2, Void >*>(static_cast<Case3Actor*>(this)));
															#line 2554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Case3Actor*>(this)->actor_wait_state > 0) static_cast<Case3Actor*>(this)->actor_wait_state = 0;
		static_cast<Case3Actor*>(this)->ActorCallback< Case3Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case3Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Case3Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Case3Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch1.cancel();
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch2.cancel();
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case3Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case3ActorState(); static_cast<Case3Actor*>(this)->destroy(); return 0; }
															#line 2642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case3Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case3ActorState();
		static_cast<Case3Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch1.cancel();
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch2.cancel();
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case3Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case3ActorState(); static_cast<Case3Actor*>(this)->destroy(); return 0; }
															#line 2658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case3Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case3ActorState();
		static_cast<Case3Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Case3Actor*>(this)->actor_wait_state > 0) static_cast<Case3Actor*>(this)->actor_wait_state = 0;
		static_cast<Case3Actor*>(this)->ActorCallback< Case3Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case3Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Case3Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Case3Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<Case3Actor*>(this)->actor_wait_state > 0) static_cast<Case3Actor*>(this)->actor_wait_state = 0;
		static_cast<Case3Actor*>(this)->ActorCallback< Case3Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case3Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< Case3Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< Case3Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Database cx;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Key key;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	WatchesSameKeyWorkload* self;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr2;
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Value val;
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watch1;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watch2;
															#line 2844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
};
// This generated class is to be used only via case3()
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case3Actor final : public Actor<Void>, public ActorCallback< Case3Actor, 0, Void >, public ActorCallback< Case3Actor, 1, Void >, public ActorCallback< Case3Actor, 2, Void >, public ActorCallback< Case3Actor, 3, Void >, public FastAllocated<Case3Actor>, public Case3ActorState<Case3Actor> {
															#line 2849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
	using FastAllocated<Case3Actor>::operator new;
	using FastAllocated<Case3Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15158648790696399616UL, 16932487138560227840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Case3Actor, 0, Void >;
friend struct ActorCallback< Case3Actor, 1, Void >;
friend struct ActorCallback< Case3Actor, 2, Void >;
friend struct ActorCallback< Case3Actor, 3, Void >;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case3Actor(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 2869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   Case3ActorState<Case3Actor>(cx, key, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("case3", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9531007144374514176UL, 3390646721527068416UL);
		ActorExecutionContextHelper __helper(static_cast<Case3Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("case3");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("case3", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Case3Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Case3Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Case3Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< Case3Actor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> case3( Database const& cx, Key const& key, WatchesSameKeyWorkload* const& self ) {
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	return Future<Void>(new Case3Actor(cx, key, self));
															#line 2904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
}

#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"

																#line 2909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
// This generated class is to be used only via case4()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
template <class Case4Actor>
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case4ActorState {
															#line 2915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case4ActorState(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		 : cx(cx),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   key(key),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   self(self),
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr(cx),
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr2(cx)
															#line 2930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("case4", reinterpret_cast<unsigned long>(this));

	}
	~Case4ActorState() 
	{
		fdb_probe_actor_destroy("case4", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			;
															#line 2945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Case4ActorState();
		static_cast<Case4Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			val = Value(deterministicRandom()->randomUniqueID().toString());
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr2.set(key, val);
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watch1 = tr2.watch(key);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr2.commit();
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Case4Actor*>(this)->actor_wait_state = 1;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 0, Void >*>(static_cast<Case4Actor*>(this)));
															#line 2989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr.onError(e) && tr2.onError(e);
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<Case4Actor*>(this)->actor_wait_state = 7;
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 6, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 2;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 1, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 2;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 1, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Case4Actor*>(this)->actor_wait_state > 0) static_cast<Case4Actor*>(this)->actor_wait_state = 0;
		static_cast<Case4Actor*>(this)->ActorCallback< Case4Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case4Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Case4Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Case4Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		tr.set(key, val);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch2 = tr.watch(key);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 3;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 2, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		tr.set(key, val);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		watch2 = tr.watch(key);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 3;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 2, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Case4Actor*>(this)->actor_wait_state > 0) static_cast<Case4Actor*>(this)->actor_wait_state = 0;
		static_cast<Case4Actor*>(this)->ActorCallback< Case4Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case4Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Case4Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Case4Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = setKeyRandomValue( cx, key, Optional<Value>());
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 4;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 3, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = setKeyRandomValue( cx, key, Optional<Value>());
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 4;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 3, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Case4Actor*>(this)->actor_wait_state > 0) static_cast<Case4Actor*>(this)->actor_wait_state = 0;
		static_cast<Case4Actor*>(this)->ActorCallback< Case4Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case4Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Case4Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Case4Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watch1;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 5;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 4, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watch1;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 5;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 4, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<Case4Actor*>(this)->actor_wait_state > 0) static_cast<Case4Actor*>(this)->actor_wait_state = 0;
		static_cast<Case4Actor*>(this)->ActorCallback< Case4Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case4Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< Case4Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< Case4Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = watch2;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 6;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 5, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = watch2;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case4Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<Case4Actor*>(this)->actor_wait_state = 6;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< Case4Actor, 5, Void >*>(static_cast<Case4Actor*>(this)));
															#line 3492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<Case4Actor*>(this)->actor_wait_state > 0) static_cast<Case4Actor*>(this)->actor_wait_state = 0;
		static_cast<Case4Actor*>(this)->ActorCallback< Case4Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case4Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< Case4Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< Case4Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case4Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case4ActorState(); static_cast<Case4Actor*>(this)->destroy(); return 0; }
															#line 3576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case4Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case4ActorState();
		static_cast<Case4Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case4Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case4ActorState(); static_cast<Case4Actor*>(this)->destroy(); return 0; }
															#line 3588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case4Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case4ActorState();
		static_cast<Case4Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<Case4Actor*>(this)->actor_wait_state > 0) static_cast<Case4Actor*>(this)->actor_wait_state = 0;
		static_cast<Case4Actor*>(this)->ActorCallback< Case4Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case4Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< Case4Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< Case4Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<Case4Actor*>(this)->actor_wait_state > 0) static_cast<Case4Actor*>(this)->actor_wait_state = 0;
		static_cast<Case4Actor*>(this)->ActorCallback< Case4Actor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case4Actor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< Case4Actor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< Case4Actor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Database cx;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Key key;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	WatchesSameKeyWorkload* self;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr2;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Value val;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watch1;
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watch2;
															#line 3774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
};
// This generated class is to be used only via case4()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case4Actor final : public Actor<Void>, public ActorCallback< Case4Actor, 0, Void >, public ActorCallback< Case4Actor, 1, Void >, public ActorCallback< Case4Actor, 2, Void >, public ActorCallback< Case4Actor, 3, Void >, public ActorCallback< Case4Actor, 4, Void >, public ActorCallback< Case4Actor, 5, Void >, public ActorCallback< Case4Actor, 6, Void >, public FastAllocated<Case4Actor>, public Case4ActorState<Case4Actor> {
															#line 3779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
	using FastAllocated<Case4Actor>::operator new;
	using FastAllocated<Case4Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18076710664639023360UL, 10607616569256337920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Case4Actor, 0, Void >;
friend struct ActorCallback< Case4Actor, 1, Void >;
friend struct ActorCallback< Case4Actor, 2, Void >;
friend struct ActorCallback< Case4Actor, 3, Void >;
friend struct ActorCallback< Case4Actor, 4, Void >;
friend struct ActorCallback< Case4Actor, 5, Void >;
friend struct ActorCallback< Case4Actor, 6, Void >;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case4Actor(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 3802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   Case4ActorState<Case4Actor>(cx, key, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("case4", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12825434551921992448UL, 2485527095591006208UL);
		ActorExecutionContextHelper __helper(static_cast<Case4Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("case4");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("case4", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Case4Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Case4Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Case4Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< Case4Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< Case4Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< Case4Actor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< Case4Actor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> case4( Database const& cx, Key const& key, WatchesSameKeyWorkload* const& self ) {
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	return Future<Void>(new Case4Actor(cx, key, self));
															#line 3840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
}

#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"

																#line 3845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
// This generated class is to be used only via case5()
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
template <class Case5Actor>
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case5ActorState {
															#line 3851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case5ActorState(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		 : cx(cx),
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   key(key),
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   self(self),
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr1(cx),
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		   tr2(cx)
															#line 3866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("case5", reinterpret_cast<unsigned long>(this));

	}
	~Case5ActorState() 
	{
		fdb_probe_actor_destroy("case5", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			;
															#line 3881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Case5ActorState();
		static_cast<Case5Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr1.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr2.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr1.set(key, Value(deterministicRandom()->randomUniqueID().toString()));
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			tr2.set(key, Value(deterministicRandom()->randomUniqueID().toString()));
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watch1 = tr1.watch(key);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			watch2 = tr2.watch(key);
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr1.commit() && tr2.commit();
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Case5Actor*>(this)->actor_wait_state = 1;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 0, Void >*>(static_cast<Case5Actor*>(this)));
															#line 3931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr1.onError(e) && tr2.onError(e);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<Case5Actor*>(this)->actor_wait_state = 5;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 4, Void >*>(static_cast<Case5Actor*>(this)));
															#line 3960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watch1 || watch2;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case5Actor*>(this)->actor_wait_state = 2;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 1, Void >*>(static_cast<Case5Actor*>(this)));
															#line 3982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_1 = watch1 || watch2;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Case5Actor*>(this)->actor_wait_state = 2;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 1, Void >*>(static_cast<Case5Actor*>(this)));
															#line 3998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Case5Actor*>(this)->actor_wait_state > 0) static_cast<Case5Actor*>(this)->actor_wait_state = 0;
		static_cast<Case5Actor*>(this)->ActorCallback< Case5Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case5Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Case5Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Case5Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case5Actor*>(this)->actor_wait_state = 3;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 2, Void >*>(static_cast<Case5Actor*>(this)));
															#line 4089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = setKeyRandomValue(cx, key, Optional<Value>());
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<Case5Actor*>(this)->actor_wait_state = 3;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 2, Void >*>(static_cast<Case5Actor*>(this)));
															#line 4105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Case5Actor*>(this)->actor_wait_state > 0) static_cast<Case5Actor*>(this)->actor_wait_state = 0;
		static_cast<Case5Actor*>(this)->ActorCallback< Case5Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case5Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Case5Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Case5Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watch1 && watch2;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<Case5Actor*>(this)->actor_wait_state = 4;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 3, Void >*>(static_cast<Case5Actor*>(this)));
															#line 4196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watch1 && watch2;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (static_cast<Case5Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<Case5Actor*>(this)->actor_wait_state = 4;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< Case5Actor, 3, Void >*>(static_cast<Case5Actor*>(this)));
															#line 4212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Case5Actor*>(this)->actor_wait_state > 0) static_cast<Case5Actor*>(this)->actor_wait_state = 0;
		static_cast<Case5Actor*>(this)->ActorCallback< Case5Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case5Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Case5Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Case5Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case5Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case5ActorState(); static_cast<Case5Actor*>(this)->destroy(); return 0; }
															#line 4296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case5Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case5ActorState();
		static_cast<Case5Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
		if (!static_cast<Case5Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Case5ActorState(); static_cast<Case5Actor*>(this)->destroy(); return 0; }
															#line 4308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		new (&static_cast<Case5Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Case5ActorState();
		static_cast<Case5Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<Case5Actor*>(this)->actor_wait_state > 0) static_cast<Case5Actor*>(this)->actor_wait_state = 0;
		static_cast<Case5Actor*>(this)->ActorCallback< Case5Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case5Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< Case5Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< Case5Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<Case5Actor*>(this)->actor_wait_state > 0) static_cast<Case5Actor*>(this)->actor_wait_state = 0;
		static_cast<Case5Actor*>(this)->ActorCallback< Case5Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Case5Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< Case5Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< Case5Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Database cx;
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Key key;
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	WatchesSameKeyWorkload* self;
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr1;
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	ReadYourWritesTransaction tr2;
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watch1;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Future<Void> watch2;
															#line 4492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
};
// This generated class is to be used only via case5()
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
class Case5Actor final : public Actor<Void>, public ActorCallback< Case5Actor, 0, Void >, public ActorCallback< Case5Actor, 1, Void >, public ActorCallback< Case5Actor, 2, Void >, public ActorCallback< Case5Actor, 3, Void >, public ActorCallback< Case5Actor, 4, Void >, public FastAllocated<Case5Actor>, public Case5ActorState<Case5Actor> {
															#line 4497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
public:
	using FastAllocated<Case5Actor>::operator new;
	using FastAllocated<Case5Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4537960287155203072UL, 17799318093782910720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Case5Actor, 0, Void >;
friend struct ActorCallback< Case5Actor, 1, Void >;
friend struct ActorCallback< Case5Actor, 2, Void >;
friend struct ActorCallback< Case5Actor, 3, Void >;
friend struct ActorCallback< Case5Actor, 4, Void >;
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	Case5Actor(Database const& cx,Key const& key,WatchesSameKeyWorkload* const& self) 
															#line 4518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   Case5ActorState<Case5Actor>(cx, key, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("case5", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8458308828816575744UL, 17956813481891747328UL);
		ActorExecutionContextHelper __helper(static_cast<Case5Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("case5");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("case5", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Case5Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Case5Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Case5Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< Case5Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< Case5Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> case5( Database const& cx, Key const& key, WatchesSameKeyWorkload* const& self ) {
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"
	return Future<Void>(new Case5Actor(cx, key, self));
															#line 4554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/WatchesSameKeyCorrectness.actor.g.cpp"
}

#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/WatchesSameKeyCorrectness.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<WatchesSameKeyWorkload> WatchesSameKeyWorkloadFactory;
