#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
/*
 * TenantManagementConcurrencyWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterConsistency.actor.h"
#include "metacluster/TenantConsistency.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct TenantManagementConcurrencyWorkload : TestWorkload {
	static constexpr auto NAME = "TenantManagementConcurrency";

	const TenantName tenantNamePrefix = "tenant_management_concurrency_workload_"_sr;
	const Key testParametersKey = nonMetadataSystemKeys.begin.withSuffix("/tenant_test/test_parameters"_sr);

	int maxTenants;
	int maxTenantGroups;
	double testDuration;
	bool useMetacluster;
	bool createMetacluster;
	bool allowTenantLimitChanges;

	Reference<IDatabase> managementDb;
	Database standaloneDb;

	TenantManagementConcurrencyWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		maxTenants = std::min<int>(1e8 - 1, getOption(options, "maxTenants"_sr, 100));
		maxTenantGroups = std::min<int>(2 * maxTenants, getOption(options, "maxTenantGroups"_sr, 20));
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		createMetacluster = getOption(options, "createMetacluster"_sr, true);
		allowTenantLimitChanges = getOption(options, "allowTenantLimitChanges"_sr, true);

		if (hasOption(options, "useMetacluster"_sr)) {
			useMetacluster = getOption(options, "useMetacluster"_sr, false);
		} else if (clientId == 0) {
			useMetacluster = deterministicRandom()->coinflip();
		} else {
			// Other clients read the metacluster state from the database
			useMetacluster = false;
		}
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("Attrition"); }

	struct TestParameters {
		constexpr static FileIdentifier file_identifier = 14350843;

		bool useMetacluster = false;

		TestParameters() {}
		TestParameters(bool useMetacluster) : useMetacluster(useMetacluster) {}

		template <class Ar>
		void serialize(Ar& ar) {
			serializer(ar, useMetacluster);
		}

		Value encode() const { return ObjectWriter::toValue(*this, Unversioned()); }
		static TestParameters decode(ValueRef const& value) {
			return ObjectReader::fromStringRef<TestParameters>(value, Unversioned());
		}
	};

	Future<Void> setup(Database const& cx) override {
		if (allowTenantLimitChanges && clientId == 0 && g_network->isSimulated() && BUGGIFY) {
			IKnobCollection::getMutableGlobalKnobCollection().setKnob(
			    "max_tenants_per_cluster", KnobValueRef::create(int{ deterministicRandom()->randomInt(20, 100) }));
		}

		return _setup(cx, this);
	}
																#line 108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class _setupActor>
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class _setupActorState {
															#line 114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	_setupActorState(Database const& cx,TenantManagementConcurrencyWorkload* const& self) 
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   self(self),
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tr(cx)
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (self->clientId == 0)
															#line 140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (self->useMetacluster)
															#line 175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			metacluster::util::SkipMetaclusterCreation skipMetaclusterCreation(!self->createMetacluster || self->clientId != 0);
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			Optional<metacluster::DataClusterEntry> entry;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (!skipMetaclusterCreation)
															#line 183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				entry = metacluster::DataClusterEntry();
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				entry.get().capacity.numTenantGroups = 1e9;
															#line 189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<metacluster::util::SimulatedMetacluster> __when_expr_5 = metacluster::util::createSimulatedMetacluster(cx, {}, entry, skipMetaclusterCreation);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 6;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >*>(static_cast<_setupActor*>(this)));
															#line 200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			self->standaloneDb = cx;
															#line 207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			tr.set(self->testParametersKey, TestParameters(self->useMetacluster).encode());
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2(int loopDepth) 
	{
		try {
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_2 = tr.get(self->testParametersKey);
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Optional<Value> >*>(static_cast<_setupActor*>(this)));
															#line 496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break2(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody2Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 5;
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 4, Void >*>(static_cast<_setupActor*>(this)));
															#line 538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody2cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (val.present())
															#line 553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TestParameters params = TestParameters::decode(val.get());
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			self->useMetacluster = params.useMetacluster;
															#line 559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody2cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody2cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (val.present())
															#line 580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TestParameters params = TestParameters::decode(val.get());
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			self->useMetacluster = params.useMetacluster;
															#line 586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break2(loopDepth==0?0:loopDepth-1); // break
		}
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody2Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody2cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody2when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody2cont3(Void const& _,int loopDepth) 
	{
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		tr.reset();
															#line 682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody2cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2cont3(Void && _,int loopDepth) 
	{
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		tr.reset();
															#line 691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody2cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody2cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody2cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _setupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody2cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody2Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _setupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _setupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		ASSERT(!simMetacluster.dataDbs.empty());
															#line 889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		ASSERT(!simMetacluster.dataDbs.empty());
															#line 900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont5(simMetacluster, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(simMetacluster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	Transaction tr;
															#line 986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, Optional<Value> >, public ActorCallback< _setupActor, 3, Void >, public ActorCallback< _setupActor, 4, Void >, public ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6391973820269089536UL, 6810062527452449792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, Optional<Value> >;
friend struct ActorCallback< _setupActor, 3, Void >;
friend struct ActorCallback< _setupActor, 4, Void >;
friend struct ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	_setupActor(Database const& cx,TenantManagementConcurrencyWorkload* const& self) 
															#line 1013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _setupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _setupActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _setupActor, 5, metacluster::util::SimulatedMetacluster >*)0, actor_cancelled()); break;
		}

	}
};
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, TenantManagementConcurrencyWorkload* const& self ) {
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 1050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

	TenantName chooseTenantName() {
		TenantName tenant(
		    format("%s%08d", tenantNamePrefix.toString().c_str(), deterministicRandom()->randomInt(0, maxTenants)));

		return tenant;
	}

	Optional<TenantGroupName> chooseTenantGroup() {
		Optional<TenantGroupName> tenantGroup;
		if (deterministicRandom()->coinflip()) {
			tenantGroup =
			    TenantGroupNameRef(format("tenantgroup%08d", deterministicRandom()->randomInt(0, maxTenantGroups)));
		}

		return tenantGroup;
	}

																#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via createTenant()
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class CreateTenantActor>
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class CreateTenantActorState {
															#line 1078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	CreateTenantActorState(TenantManagementConcurrencyWorkload* const& self) 
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   entry(),
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 1091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("createTenant", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantActorState() 
	{
		fdb_probe_actor_destroy("createTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			entry.tenantName = tenant;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			entry.tenantGroup = self->chooseTenantGroup();
															#line 1108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			try {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 1112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyCreateTenantError", debugId) .error(e) .detail("TenantName", entry.tenantName) .detail("TenantGroup", entry.tenantGroup);
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (e.code() == error_code_metacluster_no_capacity || e.code() == error_code_cluster_removed || e.code() == error_code_cluster_restoring)
															#line 1144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				ASSERT(self->useMetacluster && !self->createMetacluster);
															#line 1148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (e.code() == error_code_tenant_removed)
															#line 1154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					ASSERT(self->useMetacluster);
															#line 1158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				}
				else
				{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					if (e.code() != error_code_tenant_already_exists && e.code() != error_code_cluster_no_capacity)
															#line 1164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					{
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						TraceEvent(SevError, "TenantManagementConcurrencyCreateTenantFailure", debugId) .error(e) .detail("TenantName", entry.tenantName) .detail("TenantGroup", entry.tenantGroup);
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						ASSERT(false);
															#line 1170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					}
				}
			}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 1176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CreateTenantActorState();
			static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 1194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "TenantManagementConcurrencyCreatingTenant", debugId) .detail("TenantName", entry.tenantName) .detail("TenantGroup", entry.tenantGroup);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		Future<Void> createFuture = self->useMetacluster ? metacluster::createTenant(self->managementDb, entry, metacluster::AssignClusterAutomatically::True, metacluster::IgnoreCapacityLimit::False) : success(TenantAPI::createTenant( self->standaloneDb.getReference(), tenant, entry.toTenantMapEntry()));
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_0 = timeout(createFuture, 30);
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 1;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 0, Optional<Void> >*>(static_cast<CreateTenantActor*>(this)));
															#line 1224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> const& result,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 1246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyCreatedTenant", debugId) .detail("TenantName", entry.tenantName) .detail("TenantGroup", entry.tenantGroup);
															#line 1250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant creation timed out");
															#line 1255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> && result,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 1264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyCreatedTenant", debugId) .detail("TenantName", entry.tenantName) .detail("TenantGroup", entry.tenantGroup);
															#line 1268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant creation timed out");
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName tenant;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	metacluster::MetaclusterTenantMapEntry entry;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 1361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via createTenant()
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class CreateTenantActor final : public Actor<Void>, public ActorCallback< CreateTenantActor, 0, Optional<Void> >, public FastAllocated<CreateTenantActor>, public CreateTenantActorState<CreateTenantActor> {
															#line 1366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<CreateTenantActor>::operator new;
	using FastAllocated<CreateTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12774897162282177536UL, 11617680938656865536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantActor, 0, Optional<Void> >;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	CreateTenantActor(TenantManagementConcurrencyWorkload* const& self) 
															#line 1383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CreateTenantActorState<CreateTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2480746510970185984UL, 428737674404862208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> createTenant( TenantManagementConcurrencyWorkload* const& self ) {
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new CreateTenantActor(self));
															#line 1415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

																#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via deleteTenant()
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class DeleteTenantActor>
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class DeleteTenantActorState {
															#line 1426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	DeleteTenantActorState(TenantManagementConcurrencyWorkload* const& self) 
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantActorState() 
	{
		fdb_probe_actor_destroy("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyDeleteTenantError", debugId) .error(e) .detail("TenantName", tenant);
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (e.code() == error_code_cluster_removed || e.code() == error_code_cluster_restoring)
															#line 1485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				ASSERT(self->useMetacluster && !self->createMetacluster);
															#line 1489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (e.code() != error_code_tenant_not_found)
															#line 1495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					TraceEvent(SevError, "TenantManagementConcurrencyDeleteTenantFailure", debugId) .error(e) .detail("TenantName", tenant);
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					ASSERT(false);
															#line 1501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				}
			}
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DeleteTenantActorState();
			static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 1524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "TenantManagementConcurrencyDeletingTenant", debugId).detail("TenantName", tenant);
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		Future<Void> deleteFuture = self->useMetacluster ? metacluster::deleteTenant(self->managementDb, tenant) : TenantAPI::deleteTenant(self->standaloneDb.getReference(), tenant);
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_0 = timeout(deleteFuture, 30);
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DeleteTenantActor*>(this)->actor_wait_state = 1;
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 0, Optional<Void> >*>(static_cast<DeleteTenantActor*>(this)));
															#line 1554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> const& result,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 1576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyDeletedTenant", debugId) .detail("TenantName", tenant);
															#line 1580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant deletion timed out");
															#line 1585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> && result,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 1594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyDeletedTenant", debugId) .detail("TenantName", tenant);
															#line 1598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant deletion timed out");
															#line 1603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName tenant;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 1689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via deleteTenant()
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class DeleteTenantActor final : public Actor<Void>, public ActorCallback< DeleteTenantActor, 0, Optional<Void> >, public FastAllocated<DeleteTenantActor>, public DeleteTenantActorState<DeleteTenantActor> {
															#line 1694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<DeleteTenantActor>::operator new;
	using FastAllocated<DeleteTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17923609510573825280UL, 8926361445467698432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantActor, 0, Optional<Void> >;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	DeleteTenantActor(TenantManagementConcurrencyWorkload* const& self) 
															#line 1711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteTenantActorState<DeleteTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14546017859301560576UL, 18123705475076122368UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> deleteTenant( TenantManagementConcurrencyWorkload* const& self ) {
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new DeleteTenantActor(self));
															#line 1743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

																#line 1748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via configureImpl()
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class ConfigureImplActor>
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ConfigureImplActorState {
															#line 1754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ConfigureImplActorState(TenantManagementConcurrencyWorkload* const& self,TenantName const& tenant,std::map<Standalone<StringRef>, Optional<Value>> const& configParams,metacluster::IgnoreCapacityLimit const& ignoreCapacityLimit) 
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tenant(tenant),
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   configParams(configParams),
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   ignoreCapacityLimit(ignoreCapacityLimit)
															#line 1767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureImplActorState() 
	{
		fdb_probe_actor_destroy("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (self->useMetacluster)
															#line 1782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = metacluster::configureTenant(self->managementDb, tenant, configParams, ignoreCapacityLimit);
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ConfigureImplActor*>(this)->actor_wait_state = 1;
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 0, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				tr = self->standaloneDb->createTransaction();
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 1802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ConfigureImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureImplActorState(); static_cast<ConfigureImplActor*>(this)->destroy(); return 0; }
															#line 1826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ConfigureImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<TenantMapEntry> __when_expr_1 = TenantAPI::getTenantTransaction(tr, tenant);
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 2;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 1, TenantMapEntry >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 5;
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 4, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(TenantMapEntry const& entry,int loopDepth) 
	{
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		TenantMapEntry updatedEntry = entry;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		for( auto param : configParams ) {
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			updatedEntry.configure(param.first, param.second);
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = TenantAPI::configureTenantTransaction(tr, entry, updatedEntry);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureImplActor*>(this)->actor_wait_state = 3;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 2, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 2020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(TenantMapEntry && entry,int loopDepth) 
	{
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		TenantMapEntry updatedEntry = entry;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		for( auto param : configParams ) {
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			updatedEntry.configure(param.first, param.second);
															#line 2033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = TenantAPI::configureTenantTransaction(tr, entry, updatedEntry);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ConfigureImplActor*>(this)->actor_wait_state = 3;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 2, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 2044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(TenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 1, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 1, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConfigureImplActor*>(this)->actor_wait_state = 4;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 3, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 2135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConfigureImplActor*>(this)->actor_wait_state = 4;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 3, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 2151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName tenant;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	std::map<Standalone<StringRef>, Optional<Value>> configParams;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	metacluster::IgnoreCapacityLimit ignoreCapacityLimit;
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureImpl()
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ConfigureImplActor final : public Actor<Void>, public ActorCallback< ConfigureImplActor, 0, Void >, public ActorCallback< ConfigureImplActor, 1, TenantMapEntry >, public ActorCallback< ConfigureImplActor, 2, Void >, public ActorCallback< ConfigureImplActor, 3, Void >, public ActorCallback< ConfigureImplActor, 4, Void >, public FastAllocated<ConfigureImplActor>, public ConfigureImplActorState<ConfigureImplActor> {
															#line 2420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureImplActor>::operator new;
	using FastAllocated<ConfigureImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7403914551194187520UL, 2849690659660856576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureImplActor, 0, Void >;
friend struct ActorCallback< ConfigureImplActor, 1, TenantMapEntry >;
friend struct ActorCallback< ConfigureImplActor, 2, Void >;
friend struct ActorCallback< ConfigureImplActor, 3, Void >;
friend struct ActorCallback< ConfigureImplActor, 4, Void >;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ConfigureImplActor(TenantManagementConcurrencyWorkload* const& self,TenantName const& tenant,std::map<Standalone<StringRef>, Optional<Value>> const& configParams,metacluster::IgnoreCapacityLimit const& ignoreCapacityLimit) 
															#line 2441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureImplActorState<ConfigureImplActor>(self, tenant, configParams, ignoreCapacityLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(766673556958241024UL, 14520056664626172928UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureImplActor, 1, TenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureImplActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConfigureImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConfigureImplActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureImpl( TenantManagementConcurrencyWorkload* const& self, TenantName const& tenant, std::map<Standalone<StringRef>, Optional<Value>> const& configParams, metacluster::IgnoreCapacityLimit const& ignoreCapacityLimit ) {
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ConfigureImplActor(self, tenant, configParams, ignoreCapacityLimit));
															#line 2477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

																#line 2482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via configureTenant()
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class ConfigureTenantActor>
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ConfigureTenantActorState {
															#line 2488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ConfigureTenantActorState(TenantManagementConcurrencyWorkload* const& self) 
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   configParams(),
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tenantGroup(self->chooseTenantGroup()),
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID()),
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   ignoreCapacityLimit(deterministicRandom()->coinflip())
															#line 2505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureTenantActorState() 
	{
		fdb_probe_actor_destroy("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			configParams["tenant_group"_sr] = tenantGroup;
															#line 2520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			try {
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 2524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyConfigureTenantError", debugId) .error(e) .detail("TenantName", tenant) .detail("TenantGroup", tenantGroup);
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (e.code() == error_code_cluster_removed || e.code() == error_code_cluster_restoring)
															#line 2556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				ASSERT(self->useMetacluster && !self->createMetacluster);
															#line 2560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (e.code() == error_code_cluster_no_capacity || e.code() == error_code_invalid_tenant_configuration)
															#line 2566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					ASSERT(self->useMetacluster && !self->createMetacluster);
															#line 2570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				}
				else
				{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					if (e.code() != error_code_tenant_not_found && e.code() != error_code_invalid_tenant_state)
															#line 2576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						TraceEvent(SevError, "TenantManagementConcurrencyConfigureTenantFailure", debugId) .error(e) .detail("TenantName", tenant) .detail("TenantGroup", tenantGroup);
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						ASSERT(false);
															#line 2582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					}
				}
			}
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 2588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ConfigureTenantActorState();
			static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 2606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "TenantManagementConcurrencyConfiguringTenant", debugId) .detail("TenantName", tenant) .detail("TenantGroup", tenantGroup);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_0 = timeout(configureImpl(self, tenant, configParams, ignoreCapacityLimit), 30);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 1;
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 2634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> const& result,int loopDepth) 
	{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 2656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyConfiguredTenant", debugId) .detail("TenantName", tenant) .detail("TenantGroup", tenantGroup);
															#line 2660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant configure timed out");
															#line 2665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> && result,int loopDepth) 
	{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 2674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyConfiguredTenant", debugId) .detail("TenantName", tenant) .detail("TenantGroup", tenantGroup);
															#line 2678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant configure timed out");
															#line 2683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName tenant;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	std::map<Standalone<StringRef>, Optional<Value>> configParams;
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	Optional<TenantGroupName> tenantGroup;
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	metacluster::IgnoreCapacityLimit ignoreCapacityLimit;
															#line 2775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureTenant()
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ConfigureTenantActor final : public Actor<Void>, public ActorCallback< ConfigureTenantActor, 0, Optional<Void> >, public FastAllocated<ConfigureTenantActor>, public ConfigureTenantActorState<ConfigureTenantActor> {
															#line 2780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureTenantActor>::operator new;
	using FastAllocated<ConfigureTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5791691335127712768UL, 1749968105713258240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureTenantActor, 0, Optional<Void> >;
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ConfigureTenantActor(TenantManagementConcurrencyWorkload* const& self) 
															#line 2797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureTenantActorState<ConfigureTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7048885742222706688UL, 1739664772098993408UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureTenant( TenantManagementConcurrencyWorkload* const& self ) {
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ConfigureTenantActor(self));
															#line 2829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

																#line 2834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via renameTenant()
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class RenameTenantActor>
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class RenameTenantActorState {
															#line 2840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	RenameTenantActorState(TenantManagementConcurrencyWorkload* const& self) 
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   oldTenant(self->chooseTenantName()),
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   newTenant(self->chooseTenantName()),
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 2853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantActorState() 
	{
		fdb_probe_actor_destroy("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 2869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyRenameTenantError", debugId) .error(e) .detail("OldTenantName", oldTenant) .detail("NewTenantName", newTenant);
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (e.code() == error_code_cluster_removed || e.code() == error_code_cluster_restoring)
															#line 2901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				ASSERT(self->useMetacluster && !self->createMetacluster);
															#line 2905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (e.code() == error_code_invalid_tenant_state || e.code() == error_code_tenant_removed || e.code() == error_code_cluster_no_capacity)
															#line 2911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					ASSERT(self->useMetacluster);
															#line 2915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				}
				else
				{
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					if (e.code() != error_code_tenant_not_found && e.code() != error_code_tenant_already_exists)
															#line 2921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					{
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						TraceEvent(SevDebug, "TenantManagementConcurrencyRenameTenantFailure", debugId) .error(e) .detail("OldTenantName", oldTenant) .detail("NewTenantName", newTenant);
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						ASSERT(false);
															#line 2927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					}
				}
			}
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 2933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RenameTenantActorState();
			static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 2951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "TenantManagementConcurrencyRenamingTenant", debugId) .detail("OldTenantName", oldTenant) .detail("NewTenantName", newTenant);
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		Future<Void> renameFuture = self->useMetacluster ? metacluster::renameTenant(self->managementDb, oldTenant, newTenant) : TenantAPI::renameTenant(self->standaloneDb.getReference(), oldTenant, newTenant);
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_0 = timeout(renameFuture, 30);
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 1;
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 0, Optional<Void> >*>(static_cast<RenameTenantActor*>(this)));
															#line 2981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> const& result,int loopDepth) 
	{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 3003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyRenamedTenant", debugId) .detail("OldTenantName", oldTenant) .detail("NewTenantName", newTenant);
															#line 3007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant rename timed out");
															#line 3012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> && result,int loopDepth) 
	{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 3021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyRenamedTenant", debugId) .detail("OldTenantName", oldTenant) .detail("NewTenantName", newTenant);
															#line 3025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant rename timed out");
															#line 3030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName oldTenant;
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName newTenant;
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via renameTenant()
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class RenameTenantActor final : public Actor<Void>, public ActorCallback< RenameTenantActor, 0, Optional<Void> >, public FastAllocated<RenameTenantActor>, public RenameTenantActorState<RenameTenantActor> {
															#line 3123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<RenameTenantActor>::operator new;
	using FastAllocated<RenameTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3618756780672307712UL, 3149766394667208960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantActor, 0, Optional<Void> >;
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	RenameTenantActor(TenantManagementConcurrencyWorkload* const& self) 
															#line 3140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RenameTenantActorState<RenameTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(972264867922354944UL, 1896563828629082368UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> renameTenant( TenantManagementConcurrencyWorkload* const& self ) {
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new RenameTenantActor(self));
															#line 3172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

																#line 3177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via changeLockStateImpl()
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class ChangeLockStateImplActor>
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ChangeLockStateImplActorState {
															#line 3183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ChangeLockStateImplActorState(TenantManagementConcurrencyWorkload* const& self,TenantName const& tenant,TenantAPI::TenantLockState const& lockState,bool const& useExistingId) 
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tenant(tenant),
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   lockState(lockState),
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   useExistingId(useExistingId),
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   lockId()
															#line 3198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("changeLockStateImpl", reinterpret_cast<unsigned long>(this));

	}
	~ChangeLockStateImplActorState() 
	{
		fdb_probe_actor_destroy("changeLockStateImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (self->useMetacluster)
															#line 3213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_0 = metacluster::getTenant(self->managementDb, tenant);
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 1;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				tr = self->standaloneDb->createTransaction();
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 3233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeLockStateImplActorState();
		static_cast<ChangeLockStateImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ChangeLockStateImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLockStateImplActorState(); static_cast<ChangeLockStateImplActor*>(this)->destroy(); return 0; }
															#line 3257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ChangeLockStateImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeLockStateImplActorState();
		static_cast<ChangeLockStateImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(metacluster::MetaclusterTenantMapEntry const& entry,int loopDepth) 
	{
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (useExistingId && entry.tenantLockId.present())
															#line 3269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = entry.tenantLockId.get();
															#line 3273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
		else
		{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = deterministicRandom()->randomUniqueID();
															#line 3279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = metacluster::changeTenantLockState(self->managementDb, tenant, lockState, lockId);
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 2;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 1, Void >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(metacluster::MetaclusterTenantMapEntry && entry,int loopDepth) 
	{
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (useExistingId && entry.tenantLockId.present())
															#line 3299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = entry.tenantLockId.get();
															#line 3303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
		else
		{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = deterministicRandom()->randomUniqueID();
															#line 3309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = metacluster::changeTenantLockState(self->managementDb, tenant, lockState, lockId);
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 2;
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 1, Void >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(metacluster::MetaclusterTenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::MetaclusterTenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateImplActor*>(this)->ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateImplActor*>(this)->ActorCallback< ChangeLockStateImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeLockStateImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<TenantMapEntry> __when_expr_2 = TenantAPI::getTenantTransaction(tr, tenant);
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 3;
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 6;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 5, Void >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(TenantMapEntry const& entry,int loopDepth) 
	{
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (useExistingId && entry.tenantLockId.present())
															#line 3571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = entry.tenantLockId.get();
															#line 3575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
		else
		{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = deterministicRandom()->randomUniqueID();
															#line 3581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = TenantAPI::changeLockState(tr, entry.id, lockState, lockId);
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 4;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 3, Void >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(TenantMapEntry && entry,int loopDepth) 
	{
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (useExistingId && entry.tenantLockId.present())
															#line 3601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = entry.tenantLockId.get();
															#line 3605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
		else
		{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			lockId = deterministicRandom()->randomUniqueID();
															#line 3611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = TenantAPI::changeLockState(tr, entry.id, lockState, lockId);
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 4;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 3, Void >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(TenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateImplActor*>(this)->ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 5;
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 4, Void >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 5;
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateImplActor, 4, Void >*>(static_cast<ChangeLockStateImplActor*>(this)));
															#line 3729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateImplActor*>(this)->ActorCallback< ChangeLockStateImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeLockStateImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateImplActor*>(this)->ActorCallback< ChangeLockStateImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeLockStateImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateImplActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateImplActor*>(this)->ActorCallback< ChangeLockStateImplActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateImplActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeLockStateImplActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName tenant;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantAPI::TenantLockState lockState;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	bool useExistingId;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	UID lockId;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 3995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via changeLockStateImpl()
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ChangeLockStateImplActor final : public Actor<Void>, public ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >, public ActorCallback< ChangeLockStateImplActor, 1, Void >, public ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >, public ActorCallback< ChangeLockStateImplActor, 3, Void >, public ActorCallback< ChangeLockStateImplActor, 4, Void >, public ActorCallback< ChangeLockStateImplActor, 5, Void >, public FastAllocated<ChangeLockStateImplActor>, public ChangeLockStateImplActorState<ChangeLockStateImplActor> {
															#line 4000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ChangeLockStateImplActor>::operator new;
	using FastAllocated<ChangeLockStateImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16596262361128145152UL, 3415629696705751552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >;
friend struct ActorCallback< ChangeLockStateImplActor, 1, Void >;
friend struct ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >;
friend struct ActorCallback< ChangeLockStateImplActor, 3, Void >;
friend struct ActorCallback< ChangeLockStateImplActor, 4, Void >;
friend struct ActorCallback< ChangeLockStateImplActor, 5, Void >;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ChangeLockStateImplActor(TenantManagementConcurrencyWorkload* const& self,TenantName const& tenant,TenantAPI::TenantLockState const& lockState,bool const& useExistingId) 
															#line 4022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeLockStateImplActorState<ChangeLockStateImplActor>(self, tenant, lockState, useExistingId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeLockStateImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9064400078443424768UL, 11756796556501598720UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeLockStateImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeLockStateImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeLockStateImplActor, 0, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeLockStateImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeLockStateImplActor, 2, TenantMapEntry >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeLockStateImplActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeLockStateImplActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeLockStateImplActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> changeLockStateImpl( TenantManagementConcurrencyWorkload* const& self, TenantName const& tenant, TenantAPI::TenantLockState const& lockState, bool const& useExistingId ) {
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ChangeLockStateImplActor(self, tenant, lockState, useExistingId));
															#line 4059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

																#line 4064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via changeLockState()
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class ChangeLockStateActor>
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ChangeLockStateActorState {
															#line 4070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ChangeLockStateActorState(TenantManagementConcurrencyWorkload* const& self) 
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   lockState((TenantAPI::TenantLockState)deterministicRandom()->randomInt(0, 3)),
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   useExistingId(deterministicRandom()->coinflip()),
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 4085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("changeLockState", reinterpret_cast<unsigned long>(this));

	}
	~ChangeLockStateActorState() 
	{
		fdb_probe_actor_destroy("changeLockState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				;
															#line 4101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeLockStateActorState();
		static_cast<ChangeLockStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyChangeLockStateError", debugId) .error(e) .detail("TenantName", tenant) .detail("TenantLockState", TenantAPI::tenantLockStateToString(lockState)) .detail("UseExistingId", useExistingId);
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (e.code() == error_code_cluster_removed || e.code() == error_code_cluster_restoring)
															#line 4133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				ASSERT(self->useMetacluster && !self->createMetacluster);
															#line 4137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (e.code() != error_code_tenant_not_found && e.code() != error_code_tenant_locked && e.code() != error_code_invalid_tenant_state)
															#line 4143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					TraceEvent(SevError, "TenantManagementConcurrencyChangeLockStateFailure", debugId) .error(e) .detail("TenantName", tenant) .detail("TenantLockState", TenantAPI::tenantLockStateToString(lockState)) .detail("UseExistingId", useExistingId);
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					ASSERT(false);
															#line 4149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				}
			}
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<ChangeLockStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLockStateActorState(); static_cast<ChangeLockStateActor*>(this)->destroy(); return 0; }
															#line 4154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<ChangeLockStateActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ChangeLockStateActorState();
			static_cast<ChangeLockStateActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ChangeLockStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLockStateActorState(); static_cast<ChangeLockStateActor*>(this)->destroy(); return 0; }
															#line 4172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ChangeLockStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeLockStateActorState();
		static_cast<ChangeLockStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "TenantManagementConcurrencyChangingTenantLockState", debugId) .detail("TenantName", tenant) .detail("TenantLockState", TenantAPI::tenantLockStateToString(lockState)) .detail("UseExistingId", useExistingId);
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_0 = timeout(changeLockStateImpl(self, tenant, lockState, useExistingId), 30);
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 1;
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 0, Optional<Void> >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 4200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> const& result,int loopDepth) 
	{
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 4222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyChangedTenantLockState", debugId) .detail("TenantName", tenant) .detail("TenantLockState", TenantAPI::tenantLockStateToString(lockState)) .detail("UseExistingId", useExistingId);
															#line 4226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant change lock state timed out");
															#line 4231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> && result,int loopDepth) 
	{
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 4240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "TenantManagementConcurrencyChangedTenantLockState", debugId) .detail("TenantName", tenant) .detail("TenantLockState", TenantAPI::tenantLockStateToString(lockState)) .detail("UseExistingId", useExistingId);
															#line 4244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Tenant change lock state timed out");
															#line 4249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantName tenant;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantAPI::TenantLockState lockState;
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	bool useExistingId;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 4339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via changeLockState()
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class ChangeLockStateActor final : public Actor<Void>, public ActorCallback< ChangeLockStateActor, 0, Optional<Void> >, public FastAllocated<ChangeLockStateActor>, public ChangeLockStateActorState<ChangeLockStateActor> {
															#line 4344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ChangeLockStateActor>::operator new;
	using FastAllocated<ChangeLockStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1502478305552933632UL, 4157359414128220928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeLockStateActor, 0, Optional<Void> >;
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	ChangeLockStateActor(TenantManagementConcurrencyWorkload* const& self) 
															#line 4361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeLockStateActorState<ChangeLockStateActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11357216008526473216UL, 16339221266547417344UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeLockState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeLockStateActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> changeLockState( TenantManagementConcurrencyWorkload* const& self ) {
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ChangeLockStateActor(self));
															#line 4393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override { return _start(cx, this); }
																#line 4399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class _startActor>
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class _startActorState {
															#line 4405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	_startActorState(Database const& cx,TenantManagementConcurrencyWorkload* const& self) 
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   self(self),
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   start(now())
															#line 4416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			;
															#line 4431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 4454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!(now() < start + self->testDuration))
															#line 4473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		operation = deterministicRandom()->randomInt(0, 5);
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (operation == 0)
															#line 4481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = createTenant(self);
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 4492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (operation == 1)
															#line 4499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = deleteTenant(self);
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 4510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (operation == 2)
															#line 4517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = configureTenant(self);
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 4528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
					if (operation == 3)
															#line 4535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
					{
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = renameTenant(self);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
						if (operation == 4)
															#line 4553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
						{
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_4 = changeLockState(self);
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
							if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
							static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 4564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
							loopDepth = a_body1loopBody1cont10(loopDepth);
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	double start;
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	int operation;
															#line 5064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 5069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1562033472850732032UL, 7698445298353467904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	_startActor(Database const& cx,TenantManagementConcurrencyWorkload* const& self) 
															#line 5090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, TenantManagementConcurrencyWorkload* const& self ) {
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 5126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override { return _check(cx, this); }
																#line 5132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
template <class _checkActor>
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class _checkActorState {
															#line 5138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	_checkActorState(Database const& cx,TenantManagementConcurrencyWorkload* const& self) 
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		   self(self)
															#line 5147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
			if (self->useMetacluster)
															#line 5162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				metaclusterConsistencyCheck = metacluster::util::MetaclusterConsistencyCheck<IDatabase>(self->managementDb, metacluster::util::AllowPartialMetaclusterOperations::True);
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = metaclusterConsistencyCheck.run();
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 5175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				tenantConsistencyCheck = metacluster::util::TenantConsistencyCheck<DatabaseContext, StandardTenantTypes>(self->standaloneDb.getReference(), &TenantMetadata::instance());
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = tenantConsistencyCheck.run();
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 5191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 5215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	TenantManagementConcurrencyWorkload* self;
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	metacluster::util::MetaclusterConsistencyCheck<IDatabase> metaclusterConsistencyCheck;
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	metacluster::util::TenantConsistencyCheck<DatabaseContext, StandardTenantTypes> tenantConsistencyCheck;
															#line 5405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 5410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18401635853399088640UL, 12534827383763635200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Void >;
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	_checkActor(Database const& cx,TenantManagementConcurrencyWorkload* const& self) 
															#line 5428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, TenantManagementConcurrencyWorkload* const& self ) {
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 5461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.g.cpp"
}

#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/TenantManagementConcurrencyWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<TenantManagementConcurrencyWorkload> TenantManagementConcurrencyWorkloadFactory;
