#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
/*
 * SpecialKeySpaceCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"
#include "boost/algorithm/string.hpp"

#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/Schemas.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IRandom.h"
#include "flow/actorcompiler.h"

struct SpecialKeySpaceCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "SpecialKeySpaceCorrectness";

	int actorCount, minKeysPerRange, maxKeysPerRange, rangeCount, keyBytes, valBytes, conflictRangeSizeFactor;
	double testDuration, absoluteRandomProb, transactionsPerSecond;
	PerfIntCounter wrongResults, keysCount;
	Reference<ReadYourWritesTransaction> ryw; // used to store all populated data
	std::vector<std::shared_ptr<SKSCTestRWImpl>> rwImpls;
	std::vector<std::shared_ptr<SKSCTestAsyncReadImpl>> asyncReadImpls;
	Standalone<VectorRef<KeyRangeRef>> keys;
	Standalone<VectorRef<KeyRangeRef>> rwKeys;

	SpecialKeySpaceCorrectnessWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), wrongResults("Wrong Results"), keysCount("Number of generated keys") {
		minKeysPerRange = getOption(options, "minKeysPerRange"_sr, 1);
		maxKeysPerRange = getOption(options, "maxKeysPerRange"_sr, 100);
		rangeCount = getOption(options, "rangeCount"_sr, 10);
		keyBytes = getOption(options, "keyBytes"_sr, 16);
		valBytes = getOption(options, "valueBytes"_sr, 16);
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 100.0);
		actorCount = getOption(options, "actorCount"_sr, 1);
		absoluteRandomProb = getOption(options, "absoluteRandomProb"_sr, 0.5);
		// Controls the relative size of read/write conflict ranges and the number of random getranges
		conflictRangeSizeFactor = getOption(options, "conflictRangeSizeFactor"_sr, 10);
		ASSERT(conflictRangeSizeFactor >= 1);
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }
	Future<bool> check(Database const& cx) override { return wrongResults.getValue() == 0; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
	// disable the default timeout setting
	double getCheckTimeout() const override { return std::numeric_limits<double>::max(); }

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		// Failure injection workloads like Rollback, Attrition and so on are interfering with the test.
		// In particular, the test aims to test special keys' functions on monitoring and managing the cluster.
		// It expects the FDB cluster is healthy and not doing unexpected configuration changes.
		// All changes should come from special keys' operations' outcome.
		// Consequently, we disable all failure injection workloads in background for this test
		out.insert("all");
	}

	Future<Void> _setup(Database cx, SpecialKeySpaceCorrectnessWorkload* self) {
		cx->specialKeySpace = std::make_unique<SpecialKeySpace>();
		self->ryw = makeReference<ReadYourWritesTransaction>(cx);
		self->ryw->setOption(FDBTransactionOptions::RAW_ACCESS);
		self->ryw->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_RELAXED);
		self->ryw->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
		self->ryw->setVersion(100);
		self->ryw->clear(normalKeys);
		// generate key ranges
		for (int i = 0; i < self->rangeCount; ++i) {
			std::string baseKey = deterministicRandom()->randomAlphaNumeric(i + 1);
			Key startKey(baseKey + "/");
			Key endKey(baseKey + "/\xff");
			self->keys.push_back_deep(self->keys.arena(), KeyRangeRef(startKey, endKey));
			if (deterministicRandom()->random01() < 0.2 && !self->rwImpls.empty()) {
				self->asyncReadImpls.push_back(std::make_shared<SKSCTestAsyncReadImpl>(KeyRangeRef(startKey, endKey)));
				cx->specialKeySpace->registerKeyRange(SpecialKeySpace::MODULE::TESTONLY,
				                                      SpecialKeySpace::IMPLTYPE::READONLY,
				                                      self->keys.back(),
				                                      self->asyncReadImpls.back().get());
			} else {
				self->rwImpls.push_back(std::make_shared<SKSCTestRWImpl>(KeyRangeRef(startKey, endKey)));
				// Although there are already ranges registered, the testing range will replace them
				cx->specialKeySpace->registerKeyRange(SpecialKeySpace::MODULE::TESTONLY,
				                                      SpecialKeySpace::IMPLTYPE::READWRITE,
				                                      self->keys.back(),
				                                      self->rwImpls.back().get());
			}
			// generate keys in each key range
			int keysInRange = deterministicRandom()->randomInt(self->minKeysPerRange, self->maxKeysPerRange + 1);
			self->keysCount += keysInRange;
			for (int j = 0; j < keysInRange; ++j) {
				self->ryw->set(Key(deterministicRandom()->randomAlphaNumeric(self->keyBytes)).withPrefix(startKey),
				               Value(deterministicRandom()->randomAlphaNumeric(self->valBytes)));
			}
		}
		ASSERT(rwImpls.size() > 0);

		return Void();
	}
																#line 123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class _startActor>
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class _startActorState {
															#line 129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	_startActorState(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx(cx),
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self)
															#line 138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			testRywLifetime(cx);
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(self->testSpecialKeySpaceErrors(cx, self) && self->getRangeCallActor(cx, self) && testConflictRanges(cx, true, self) && testConflictRanges(cx, false, self) && self->metricsApiCorrectnessActor(cx, self), self->testDuration, Void());
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (self->clientId == 0)
															#line 185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->managementApiCorrectnessActor(cx, self);
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (self->clientId == 0)
															#line 210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->managementApiCorrectnessActor(cx, self);
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8547820333781662976UL, 14120844164056055040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	_startActor(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
}

#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

	// This would be a unit test except we need a Database to create an ryw transaction
	static void testRywLifetime(Database cx) {
		Future<Void> f;
		{
			ReadYourWritesTransaction ryw{ cx->clone() };
			if (!ryw.getDatabase()->apiVersionAtLeast(630)) {
				// This test is not valid for API versions smaller than 630
				return;
			}
			f = success(ryw.get("\xff\xff/status/json"_sr));
			CODE_PROBE(!f.isReady(), "status json not ready");
		}
		ASSERT(f.isError());
		ASSERT(f.getError().code() == error_code_transaction_cancelled);
	}

																#line 486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
// This generated class is to be used only via getRangeCallActor()
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class GetRangeCallActorActor>
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class GetRangeCallActorActorState {
															#line 492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	GetRangeCallActorActorState(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx(cx),
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   lastTime(now()),
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   reverse(Reverse::False)
															#line 505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("getRangeCallActor", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeCallActorActorState() 
	{
		fdb_probe_actor_destroy("getRangeCallActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			;
															#line 520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeCallActorActorState();
		static_cast<GetRangeCallActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, 1.0 / self->transactionsPerSecond);
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<GetRangeCallActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRangeCallActorActor*>(this)->actor_wait_state = 1;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeCallActorActor, 0, Void >*>(static_cast<GetRangeCallActorActor*>(this)));
															#line 557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		reverse.set(deterministicRandom()->coinflip());
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		limit = self->randomLimits();
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		begin = self->randomKeySelector();
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		end = self->randomKeySelector();
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctResultFuture.isReady());
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResult = correctResultFuture.getValue();
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testResultFuture.isReady());
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResult = testResultFuture.getValue();
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctResult, testResult))
															#line 586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRange rkr = self->randomRWKeyRange();
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey1 = rkr.begin;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey2 = rkr.end;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue1 = self->randomValue();
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey1, rvalue1);
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey1, rvalue1);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue2 = self->randomValue();
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey2, rvalue2);
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey2, rvalue2);
															#line 616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey1);
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey1);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey2);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey2);
															#line 632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
			else
			{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkr);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkr);
															#line 640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
		}
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctRywResultFuture.isReady());
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResult = correctRywResultFuture.getValue();
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testRywResultFuture.isReady());
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResult = testRywResultFuture.getValue();
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctRywResult, testRywResult))
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange(ryw) are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		reverse.set(deterministicRandom()->coinflip());
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		limit = self->randomLimits();
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		begin = self->randomKeySelector();
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		end = self->randomKeySelector();
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctResultFuture.isReady());
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctResult = correctResultFuture.getValue();
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testResultFuture.isReady());
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testResult = testResultFuture.getValue();
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctResult, testResult))
															#line 693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRange rkr = self->randomRWKeyRange();
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey1 = rkr.begin;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		KeyRef rkey2 = rkr.end;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue1 = self->randomValue();
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey1, rvalue1);
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey1, rvalue1);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Value rvalue2 = self->randomValue();
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			cx->specialKeySpace->set(self->ryw.getPtr(), rkey2, rvalue2);
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			self->ryw->set(rkey2, rvalue2);
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey1);
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey1);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkey2);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkey2);
															#line 739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
			else
			{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				cx->specialKeySpace->clear(self->ryw.getPtr(), rkr);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				self->ryw->clear(rkr);
															#line 747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
		}
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResultFuture = self->ryw->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(correctRywResultFuture.isReady());
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto correctRywResult = correctRywResultFuture.getValue();
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResultFuture = cx->specialKeySpace->getRange(self->ryw.getPtr(), begin, end, limit, reverse);
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(testRywResultFuture.isReady());
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto testRywResult = testRywResultFuture.getValue();
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!self->compareRangeResult(correctRywResult, testRywResult))
															#line 764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "Results from getRange(ryw) are inconsistent") .detail("Begin", begin) .detail("End", end) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Reverse", reverse);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			++self->wrongResults;
															#line 770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeCallActorActor*>(this)->actor_wait_state > 0) static_cast<GetRangeCallActorActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeCallActorActor*>(this)->ActorCallback< GetRangeCallActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeCallActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeCallActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeCallActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	double lastTime;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reverse reverse;
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	GetRangeLimits limit;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeySelector begin;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeySelector end;
															#line 865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
};
// This generated class is to be used only via getRangeCallActor()
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class GetRangeCallActorActor final : public Actor<Void>, public ActorCallback< GetRangeCallActorActor, 0, Void >, public FastAllocated<GetRangeCallActorActor>, public GetRangeCallActorActorState<GetRangeCallActorActor> {
															#line 870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
	using FastAllocated<GetRangeCallActorActor>::operator new;
	using FastAllocated<GetRangeCallActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1470050591169880064UL, 13325615415807791872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeCallActorActor, 0, Void >;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	GetRangeCallActorActor(Database const& cx,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   GetRangeCallActorActorState<GetRangeCallActorActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeCallActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8464877911471062784UL, 4537410763034963968UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeCallActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeCallActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeCallActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeCallActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> getRangeCallActor( Database const& cx, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new GetRangeCallActorActor(cx, self));
															#line 919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
}

#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

	bool compareRangeResult(RangeResult const& res1, RangeResult const& res2) {
		if ((res1.more != res2.more) || (res1.readToBegin != res2.readToBegin) ||
		    (res1.readThroughEnd != res2.readThroughEnd)) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "RangeResultRef flags are inconsistent")
			    .detail("More", res1.more)
			    .detail("ReadToBegin", res1.readToBegin)
			    .detail("ReadThroughEnd", res1.readThroughEnd)
			    .detail("More2", res2.more)
			    .detail("ReadToBegin2", res2.readToBegin)
			    .detail("ReadThroughEnd2", res2.readThroughEnd);
			return false;
		}
		if (res1.size() != res2.size()) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Results' sizes are inconsistent")
			    .detail("CorrestResultSize", res1.size())
			    .detail("TestResultSize", res2.size());
			return false;
		}
		for (int i = 0; i < res1.size(); ++i) {
			if (res1[i].key != res2[i].key) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Keys are inconsistent")
				    .detail("Index", i)
				    .detail("CorrectKey", printable(res1[i].key))
				    .detail("TestKey", printable(res2[i].key));
				return false;
			}
			if (res1[i].value != res2[i].value) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Values are inconsistent")
				    .detail("Index", i)
				    .detail("CorrectValue", printable(res1[i].value))
				    .detail("TestValue", printable(res2[i].value));
				return false;
			}
			CODE_PROBE(true, "Special key space keys equal");
		}
		return true;
	}

	KeyRange randomRWKeyRange() {
		ASSERT(rwImpls.size() > 0);
		Key prefix = rwImpls[deterministicRandom()->randomInt(0, rwImpls.size())]->getKeyRange().begin;
		Key rkey1 = Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(0, keyBytes)))
		                .withPrefix(prefix);
		Key rkey2 = Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(0, keyBytes)))
		                .withPrefix(prefix);
		return rkey1 <= rkey2 ? KeyRangeRef(rkey1, rkey2) : KeyRangeRef(rkey2, rkey1);
	}

	Key randomKey() {
		Key randomKey;
		if (deterministicRandom()->random01() < absoluteRandomProb) {
			Key prefix;
			if (deterministicRandom()->random01() < absoluteRandomProb)
				// prefix length is randomly generated
				prefix =
				    Key(deterministicRandom()->randomAlphaNumeric(deterministicRandom()->randomInt(1, rangeCount + 1)) +
				        "/");
			else
				// pick up an existing prefix
				prefix = keys[deterministicRandom()->randomInt(0, rangeCount)].begin;
			randomKey = Key(deterministicRandom()->randomAlphaNumeric(keyBytes)).withPrefix(prefix);
		} else {
			// pick up existing keys from registered key ranges
			KeyRangeRef randomKeyRangeRef = keys[deterministicRandom()->randomInt(0, keys.size())];
			randomKey = deterministicRandom()->coinflip() ? randomKeyRangeRef.begin : randomKeyRangeRef.end;
		}
		return randomKey;
	}

	Value randomValue() { return Value(deterministicRandom()->randomAlphaNumeric(valBytes)); }

	KeySelector randomKeySelector() {
		// covers corner cases where offset points outside the key space
		int offset = deterministicRandom()->randomInt(-keysCount.getValue() - 1, keysCount.getValue() + 2);
		return KeySelectorRef(randomKey(), deterministicRandom()->coinflip(), offset);
	}

	GetRangeLimits randomLimits() {
		// TODO : fix knobs for row_unlimited
		int rowLimits = deterministicRandom()->randomInt(0, keysCount.getValue() + 1);
		// The largest key's bytes is longest prefix bytes + 1(for '/') + generated key bytes
		// 8 here refers to bytes of KeyValueRef
		int byteLimits = deterministicRandom()->randomInt(
		    1, keysCount.getValue() * (keyBytes + (rangeCount + 1) + valBytes + 8) + 1);

		auto limit = GetRangeLimits(rowLimits, byteLimits);
		// minRows is always initialized to 1
		if (limit.rows == 0)
			limit.minRows = 0;
		return limit;
	}

																#line 1020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
// This generated class is to be used only via testSpecialKeySpaceErrors()
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class TestSpecialKeySpaceErrorsActor>
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestSpecialKeySpaceErrorsActorState {
															#line 1026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestSpecialKeySpaceErrorsActorState(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   cx(cx_->clone()),
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   tenantId()
															#line 1039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this));

	}
	~TestSpecialKeySpaceErrorsActorState() 
	{
		fdb_probe_actor_destroy("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::createTenant(cx.getReference(), TenantName("foo"_sr));
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 1;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSpecialKeySpaceErrorsActorState();
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx = makeReference<ReadYourWritesTransaction>(cx);
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tenantTx = makeReference<ReadYourWritesTransaction>(cx, makeReference<Tenant>(tenantId));
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1 = makeReference<ReadYourWritesTransaction>(cx);
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx2 = makeReference<ReadYourWritesTransaction>(cx);
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		disableRyw = deterministicRandom()->coinflip();
															#line 1099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		try {
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(tenantTx->getRange(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT), CLIENT_KNOBS->TOO_MANY));
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 2;
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_tenant_already_exists || e.code() == error_code_actor_cancelled);
															#line 1126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(entry.present());
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tenantId = entry.get().id;
															#line 1143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(entry.present());
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tenantId = entry.get().id;
															#line 1154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		try {
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tenantTx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tenantTx->set(SpecialKeySpace::getManagementApiCommandPrefix("consistencycheck"), ValueRef());
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tenantTx->commit();
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 1258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont5Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 3;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_illegal_tenant_access);
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tenantTx->reset();
															#line 1289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 1304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 1313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		try {
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tenantTx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tenantTx->clear(SpecialKeySpace::getManagementApiCommandRange("exclude"));
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(false);
															#line 1415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_illegal_tenant_access);
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tenantTx->reset();
															#line 1441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 1456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 1465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			readresult1 = RangeResult();
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			readresult2 = RangeResult();
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			writeResult1 = RangeResult();
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			writeResult2 = RangeResult();
															#line 1569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			try {
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (disableRyw)
															#line 1573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					defaultTx1->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 1577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				}
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				defaultTx1->addReadConflictRange(singleKeyRange("testKeylll"_sr));
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				defaultTx1->addWriteConflictRange(singleKeyRange("testKeylll"_sr));
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_3 = store(readresult1, defaultTx1->getRange(readConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 1587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont11Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont11when1(__when_expr_3.get(), loopDepth); };
				static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 4;
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont11Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont11Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_illegal_tenant_access);
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tenantTx->reset();
															#line 1619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 1647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(int loopDepth) 
	{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_6 = store(readresult2, defaultTx1->getRange(readConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont11cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 7;
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(true, "conflict range tenant commit error thrown");
															#line 1681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont3(Void const& _,int loopDepth) 
	{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(writeResult1, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 1698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont11Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 5;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3(Void && _,int loopDepth) 
	{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = store(writeResult1, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 1714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont11Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont11cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 5;
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont5(Void const& _,int loopDepth) 
	{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = defaultTx1->commit();
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 1805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont11Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 6;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont5(Void && _,int loopDepth) 
	{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = defaultTx1->commit();
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11Catch1(actor_cancelled(), loopDepth);
															#line 1821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont11Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont11cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 6;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 1826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont6(Void const& _,int loopDepth) 
	{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "conflict range tenant commit succeeded");
															#line 1910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont6(Void && _,int loopDepth) 
	{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "conflict range tenant commit succeeded");
															#line 1919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont9(Void const& _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(writeResult2, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 8;
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont9(Void && _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(writeResult2, defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY));
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont11cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 8;
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont11cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont11cont10(Void const& _,int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(readresult1 == readresult2);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(writeResult1 == writeResult2);
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->reset();
															#line 2127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont10(Void && _,int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(readresult1 == readresult2);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(writeResult1 == writeResult2);
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->reset();
															#line 2140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont11cont11(int loopDepth) 
	{
		try {
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_18 = success(tx->getRange(KeyRangeRef("\xff\xff/transactio"_sr, "\xff\xff/transaction0"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11Catch1(actor_cancelled(), loopDepth);
															#line 2229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont11cont11Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont11cont11when1(__when_expr_18.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 19;
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1(int loopDepth) 
	{
		try {
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (disableRyw)
															#line 2257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				defaultTx1->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				defaultTx2->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 2263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			defaultTx1->setOption(FDBTransactionOptions::REPORT_CONFLICTING_KEYS);
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			defaultTx2->setOption(FDBTransactionOptions::REPORT_CONFLICTING_KEYS);
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = success(defaultTx1->getReadVersion());
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont11cont1loopBody1when1(__when_expr_8.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 9;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_17 = defaultTx2->onError(e);
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11cont1loopBody1Catch1when1(__when_expr_17.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 18;
															#line 445 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_9 = success(defaultTx2->getReadVersion());
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 10;
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_9 = success(defaultTx2->getReadVersion());
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont2when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 10;
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont11cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addReadConflictRange(singleKeyRange("foo"_sr));
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx2->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = defaultTx2->commit();
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont4when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 11;
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addReadConflictRange(singleKeyRange("foo"_sr));
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx2->addWriteConflictRange(singleKeyRange("foo"_sr));
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = defaultTx2->commit();
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont4when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 11;
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont11cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		try {
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_11 = defaultTx1->commit();
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 2572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont11cont1loopBody1cont5Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5when1(__when_expr_11.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 12;
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		try {
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_11 = defaultTx1->commit();
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1cont5Catch1(actor_cancelled(), loopDepth);
															#line 2595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont11cont1loopBody1cont5Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5when1(__when_expr_11.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 12;
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1loopBody1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1loopBody1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont11cont1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			err = e;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (err.code() != error_code_not_committed)
															#line 2699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_12 = defaultTx1->onError(err);
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5Catch1when1(__when_expr_12.get(), loopDepth); };
				static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 13;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 2730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 2739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont11cont1loopBody1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont11cont1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont1(int loopDepth) 
	{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_14 = defaultTx1->getRange(readConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY);
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5Catch1cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 15;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_13 = defaultTx2->onError(err);
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5Catch1cont2when1(__when_expr_13.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 14;
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont2(Void && _,int loopDepth) 
	{
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_13 = defaultTx2->onError(err);
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5Catch1cont2when1(__when_expr_13.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 14;
															#line 420 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 2875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont1loopBody1cont5Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont1loopBody1cont5Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11cont1loopBody1cont5Catch1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont11cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont11cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont11cont1loopBody1cont5Catch1cont5(int loopDepth) 
	{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_15 = defaultTx1->getRange(writeConflictRangeKeysRange, CLIENT_KNOBS->TOO_MANY);
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5Catch1cont5when1(__when_expr_15.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 16;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont1when1(RangeResult const& __readConflictRange,int loopDepth) 
	{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		readConflictRange = __readConflictRange;
															#line 3062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont1when1(RangeResult && __readConflictRange,int loopDepth) 
	{
		readConflictRange = std::move(__readConflictRange);
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont11cont1loopBody1cont5Catch1cont6(int loopDepth) 
	{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_16 = defaultTx1->getRange(conflictingKeysRange, CLIENT_KNOBS->TOO_MANY);
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont11cont1loopBody1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont11cont1loopBody1cont5Catch1cont6when1(__when_expr_16.get(), loopDepth); };
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 17;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont5when1(RangeResult const& __writeConflictRange,int loopDepth) 
	{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		writeConflictRange = __writeConflictRange;
															#line 3157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont5when1(RangeResult && __writeConflictRange,int loopDepth) 
	{
		writeConflictRange = std::move(__writeConflictRange);
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont11cont1loopBody1cont5Catch1cont7(int loopDepth) 
	{
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(readConflictRange.size() == 2 && readConflictRange.begin()->key == readConflictRangeKeysRange.begin.withSuffix("foo"_sr));
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(writeConflictRange.size() == 2 && writeConflictRange.begin()->key == writeConflictRangeKeysRange.begin.withSuffix("foo"_sr));
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(conflictKeys.size() == 2 && conflictKeys.begin()->key == conflictingKeysRange.begin.withSuffix("foo"_sr));
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx1->reset();
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		defaultTx2->reset();
															#line 3244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont11cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont6when1(RangeResult const& __conflictKeys,int loopDepth) 
	{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		conflictKeys = __conflictKeys;
															#line 3253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1cont5Catch1cont6when1(RangeResult && __conflictKeys,int loopDepth) 
	{
		conflictKeys = std::move(__conflictKeys);
		loopDepth = a_body1cont11cont1loopBody1cont5Catch1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont1loopBody1cont5Catch1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont11cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont11cont1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont11cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont11cont11cont1(int loopDepth) 
	{
		try {
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_19 = success(tx->getRange(KeyRangeRef("\xff\xff/transaction/"_sr, "\xff\xff/transaction1"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont1Catch1(actor_cancelled(), loopDepth);
															#line 3437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont11cont11cont1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont11cont11cont1when1(__when_expr_19.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 20;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_read);
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 3468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont2(Void const& _,int loopDepth) 
	{
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont2(Void && _,int loopDepth) 
	{
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont11cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont11cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont5(int loopDepth) 
	{
		try {
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_20 = success(tx->getRange(KeyRangeRef("\xff\xff/transaction"_sr, "\xff\xff/transaction1"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont5Catch1(actor_cancelled(), loopDepth);
															#line 3594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont11cont11cont5Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont11cont11cont5when1(__when_expr_20.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 21;
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_read);
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 3625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont6(Void const& _,int loopDepth) 
	{
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont6(Void && _,int loopDepth) 
	{
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont11cont11cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont11cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont9(int loopDepth) 
	{
		try {
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_21 = success(tx->getRange(KeyRangeRef("\xff\xff/transaction/"_sr, "\xff\xff/transaction0"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont9Catch1(actor_cancelled(), loopDepth);
															#line 3751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont11cont11cont9Catch1(__when_expr_21.getError(), loopDepth); else return a_body1cont11cont11cont9when1(__when_expr_21.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 22;
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_read);
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 3782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont10(Void const& _,int loopDepth) 
	{
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont10(Void && _,int loopDepth) 
	{
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 3806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont11cont11cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont11cont11cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11(int loopDepth) 
	{
		try {
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_RELAXED);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef startKey = "\xff\xff/transactio"_sr;
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef endKey = "\xff\xff/transaction1"_sr;
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_22 = tx->getRange(KeyRangeRef(startKey, endKey), GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11Catch1(actor_cancelled(), loopDepth);
															#line 3914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont11cont11cont11Catch1(__when_expr_22.getError(), loopDepth); else return a_body1cont11cont11cont11when1(__when_expr_22.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 23;
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 3919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont12(Void const& _,int loopDepth) 
	{
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "read transaction special keyrange");
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont12(Void && _,int loopDepth) 
	{
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "read transaction special keyrange");
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 3962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont11cont11cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont11cont11cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1(int loopDepth) 
	{
		try {
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->addReadConflictRange(singleKeyRange("testKey"_sr));
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef(readConflictRangeKeysRange.begin, false, 1);
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef("\xff\xff/transaction0"_sr, false, 0);
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_23 = success(tx->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY)));
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont1Catch1(actor_cancelled(), loopDepth);
															#line 4070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont11cont11cont11cont1Catch1(__when_expr_23.getError(), loopDepth); else return a_body1cont11cont11cont11cont1when1(__when_expr_23.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 24;
															#line 514 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont2(RangeResult const& result,int loopDepth) 
	{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!result.size());
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont2(RangeResult && result,int loopDepth) 
	{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!result.size());
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont11cont11cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont11cont11cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont5(int loopDepth) 
	{
		try {
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_24 = success(tx->getRange( KeyRangeRef("\xff\xff/A_no_module_related_prefix"_sr, "\xff\xff/I_am_also_not_in_any_module"_sr), CLIENT_KNOBS->TOO_MANY));
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont5Catch1(actor_cancelled(), loopDepth);
															#line 4220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont11cont11cont11cont5Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont11cont11cont11cont5when1(__when_expr_24.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 25;
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont6(Void const& _,int loopDepth) 
	{
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "end key selector inside module range");
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont6(Void && _,int loopDepth) 
	{
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "end key selector inside module range");
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont11cont11cont11cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont11cont11cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont9(int loopDepth) 
	{
		try {
															#line 535 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef("\xff\xff/zzz_i_am_not_a_module"_sr, false, 1);
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef("\xff\xff/zzz_to_be_the_final_one"_sr, false, 2);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_25 = success(tx->getRange(begin, end, CLIENT_KNOBS->TOO_MANY));
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont9Catch1(actor_cancelled(), loopDepth);
															#line 4374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont11cont11cont11cont9Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont11cont11cont11cont9when1(__when_expr_25.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 26;
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_module_found);
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 4405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont10(Void const& _,int loopDepth) 
	{
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont10(Void && _,int loopDepth) 
	{
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11cont11cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11cont11cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont11cont11cont11cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont11cont11cont11cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11(int loopDepth) 
	{
		try {
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef key = "\xff\xff/cluster_file_path"_sr;
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef(key, false, 0);
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef(keyAfter(key), false, 2);
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_26 = tx->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont11Catch1(actor_cancelled(), loopDepth);
															#line 4537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont11cont11cont11cont11Catch1(__when_expr_26.getError(), loopDepth); else return a_body1cont11cont11cont11cont11when1(__when_expr_26.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 27;
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont11Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont11Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 4558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_module_found);
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 4568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12(Void const& _,int loopDepth) 
	{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont12(Void && _,int loopDepth) 
	{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 4592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11cont11cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11cont11cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont11cont11cont11cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont11cont11cont11cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont1(int loopDepth) 
	{
		try {
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->addReadConflictRange(singleKeyRange("readKey"_sr));
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeyRef key = "\xff\xff/transaction/a_to_be_the_first"_sr;
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin = KeySelectorRef(key, false, 0);
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end = KeySelectorRef(key, false, 2);
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_27 = tx->getRange(begin, end, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont11cont1Catch1(actor_cancelled(), loopDepth);
															#line 4702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont11cont11cont11cont11cont1Catch1(__when_expr_27.getError(), loopDepth); else return a_body1cont11cont11cont11cont11cont1when1(__when_expr_27.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 28;
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 4707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont11cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont11cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont2(RangeResult const& result,int loopDepth) 
	{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && result.readThroughEnd);
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont2(RangeResult && result,int loopDepth) 
	{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && result.readThroughEnd);
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11cont11cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11cont11cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont11cont11cont11cont11Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont11cont11cont11cont11cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont5(int loopDepth) 
	{
		try {
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("\xff\xff/I_am_not_a_range_can_be_written"_sr, ValueRef());
															#line 4850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont11cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont11cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont6(RangeResult const& result,int loopDepth) 
	{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && !result.readThroughEnd);
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont6(RangeResult && result,int loopDepth) 
	{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(result.readToBegin && !result.readThroughEnd);
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 4893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont6(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont6(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11cont11cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11cont11cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont11cont11cont11cont11cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont11cont11cont11cont11cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont9(int loopDepth) 
	{
		try {
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("\xff\xff/I_am_not_a_range_can_be_written"_sr, ValueRef());
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(false);
															#line 4997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont11cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont11cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_write_disabled);
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 5023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12(int loopDepth) 
	{
		try {
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear(KeyRangeRef(SpecialKeySpace::getManagementApiCommandRange("exclude").begin, SpecialKeySpace::getManagementApiCommandRange("failed").end));
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(false);
															#line 5058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont11cont12Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont11cont12Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_write_module_found);
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 5084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont1(int loopDepth) 
	{
		try {
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeySelector startKeySelector = KeySelectorRef("\xff\xff/test"_sr, true, -200);
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			const KeySelector endKeySelector = KeySelectorRef("test"_sr, true, -10);
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_28 = tx->getRange(startKeySelector, endKeySelector, GetRangeLimits(CLIENT_KNOBS->TOO_MANY));
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont11cont12cont1Catch1(actor_cancelled(), loopDepth);
															#line 5121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont11cont11cont11cont11cont12cont1Catch1(__when_expr_28.getError(), loopDepth); else return a_body1cont11cont11cont11cont11cont12cont1when1(__when_expr_28.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 29;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 5126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont11cont12cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont11cont12cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_cross_module_clear);
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 5152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11cont12cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4(int loopDepth) 
	{
		try {
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_29 = tx->getRange(KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont11cont12cont4Catch1(actor_cancelled(), loopDepth);
															#line 5185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1cont11cont11cont11cont11cont12cont4Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont11cont11cont11cont11cont12cont4when1(__when_expr_29.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 30;
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 5190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont11cont11cont11cont11cont12cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11cont11cont11cont11cont12cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 5206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_key_outside_legal_range);
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 5216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont11cont11cont11cont11cont12cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont5(RangeResult const& result,int loopDepth) 
	{
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 5231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont5(RangeResult && result,int loopDepth) 
	{
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 5240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont12cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont5(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont5(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11cont11cont11cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11cont11cont11cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont11cont11cont11cont11cont12cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont11cont11cont11cont11cont12cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11cont12cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont8(int loopDepth) 
	{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<TestSpecialKeySpaceErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSpecialKeySpaceErrorsActorState(); static_cast<TestSpecialKeySpaceErrorsActor*>(this)->destroy(); return 0; }
															#line 5337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		new (&static_cast<TestSpecialKeySpaceErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestSpecialKeySpaceErrorsActorState();
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_31 = tx->onError(e);
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1Catch1(__when_expr_31.getError(), loopDepth); else return a_body1cont11cont11cont11cont11cont12cont4Catch1when1(__when_expr_31.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 32;
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 5357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont9(int loopDepth) 
	{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (result.size())
															#line 5372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			entry = deterministicRandom()->randomChoice(result);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_30 = tx->get(entry.key);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state < 0) return a_body1cont11cont11cont11cont11cont12cont4Catch1(actor_cancelled(), loopDepth);
															#line 5380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1cont11cont11cont11cont11cont12cont4Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont11cont11cont11cont11cont12cont9when1(__when_expr_30.get(), loopDepth); };
			static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 31;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >*>(static_cast<TestSpecialKeySpaceErrorsActor*>(this)));
															#line 5385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11cont11cont11cont11cont12cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4when1(RangeResult const& __result,int loopDepth) 
	{
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		result = __result;
															#line 5399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont12cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont11cont11cont11cont11cont12cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose30() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont11cont11cont11cont11cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont11cont11cont11cont11cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont11cont11cont11cont11cont12cont10(int loopDepth) 
	{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 5478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont11cont11cont11cont11cont12cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont11(Optional<Value> const& singleRes,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (singleRes.present())
															#line 5487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(singleRes.get() == entry.value);
															#line 5491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont11cont11cont11cont12cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont11(Optional<Value> && singleRes,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (singleRes.present())
															#line 5501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(singleRes.get() == entry.value);
															#line 5505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont11cont11cont11cont12cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont9when1(Optional<Value> const& singleRes,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont11(singleRes, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont9when1(Optional<Value> && singleRes,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont11(std::move(singleRes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose31() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont11cont11cont11cont11cont12cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont11cont11cont11cont11cont12cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont11cont11cont11cont11cont12cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1cont11cont11cont11cont11cont12cont10cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11cont11cont11cont11cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont4Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont11cont11cont11cont12cont4Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont11cont11cont11cont12cont4Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose32() 
	{
		if (static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state > 0) static_cast<TestSpecialKeySpaceErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<TestSpecialKeySpaceErrorsActor*>(this)->ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont11cont11cont11cont11cont12cont4Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_fire(ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont11cont11cont11cont11cont12cont4Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_error(ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), 31);

	}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	int64_t tenantId;
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tenantTx;
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> defaultTx1;
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> defaultTx2;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool disableRyw;
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult readresult1;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult readresult2;
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult writeResult1;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult writeResult2;
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Error err;
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult readConflictRange;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult writeConflictRange;
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult conflictKeys;
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	RangeResult result;
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeyValueRef entry;
															#line 5724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
};
// This generated class is to be used only via testSpecialKeySpaceErrors()
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestSpecialKeySpaceErrorsActor final : public Actor<Void>, public ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >, public ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >, public FastAllocated<TestSpecialKeySpaceErrorsActor>, public TestSpecialKeySpaceErrorsActorState<TestSpecialKeySpaceErrorsActor> {
															#line 5729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
	using FastAllocated<TestSpecialKeySpaceErrorsActor>::operator new;
	using FastAllocated<TestSpecialKeySpaceErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18205741362756030208UL, 304225933648344064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >;
friend struct ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestSpecialKeySpaceErrorsActor(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 5777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   TestSpecialKeySpaceErrorsActorState<TestSpecialKeySpaceErrorsActor>(cx_, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5687135045384554752UL, 8946962685745539072UL);
		ActorExecutionContextHelper __helper(static_cast<TestSpecialKeySpaceErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSpecialKeySpaceErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSpecialKeySpaceErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 14, RangeResult >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 15, RangeResult >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 16, RangeResult >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 21, Void >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 22, RangeResult >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 23, Void >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 24, Void >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 25, Void >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 26, RangeResult >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 27, RangeResult >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 28, RangeResult >*)0, actor_cancelled()); break;
		case 30: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 29, RangeResult >*)0, actor_cancelled()); break;
		case 31: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 30, Optional<Value> >*)0, actor_cancelled()); break;
		case 32: this->a_callback_error((ActorCallback< TestSpecialKeySpaceErrorsActor, 31, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> testSpecialKeySpaceErrors( Database const& cx_, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new TestSpecialKeySpaceErrorsActor(cx_, self));
															#line 5840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
}

#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

																#line 5845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
// This generated class is to be used only via testConflictRanges()
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class TestConflictRangesActor>
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestConflictRangesActorState {
															#line 5851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestConflictRangesActorState(Database const& cx_,bool const& read,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   read(read),
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   prefix(read ? readConflictRangeKeysRange.begin : writeConflictRangeKeysRange.begin)
															#line 5864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("testConflictRanges", reinterpret_cast<unsigned long>(this));

	}
	~TestConflictRangesActorState() 
	{
		fdb_probe_actor_destroy("testConflictRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(read, "test read conflict range special key implementation");
															#line 644 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(!read, "test write conflict range special key implementation");
															#line 646 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Database cx = cx_->clone();
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx = makeReference<ReadYourWritesTransaction>(cx);
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx = makeReference<ReadYourWritesTransaction>(cx);
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ryw = deterministicRandom()->coinflip();
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (!ryw)
															#line 5893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 5897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx->setVersion(100);
															#line 656 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			referenceTx->clear(normalKeys);
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			int numKeys = deterministicRandom()->randomInt(1, self->conflictRangeSizeFactor) * 4;
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			keys = std::vector<std::string>();
															#line 659 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			keys.resize(numKeys);
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			int lastKey = 0;
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for( auto& key : keys ) {
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				key = std::to_string(lastKey++);
															#line 5917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 5921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				keys.push_back("");
															#line 5925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 5929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				keys.push_back("\xff");
															#line 5933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::mt19937 g(deterministicRandom()->randomUInt32());
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::shuffle(keys.begin(), keys.end(), g);
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::sort(keys.begin(), keys.begin() + keys.size() / 2);
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(auto iter = keys.begin();iter + 1 < keys.begin() + keys.size() / 2;iter += 2) {
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				Standalone<KeyRangeRef> range = KeyRangeRef(*iter, *(iter + 1));
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (read)
															#line 5947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				{
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addReadConflictRange(range);
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addReadConflictRange(range);
															#line 5953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				}
				else
				{
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addWriteConflictRange(range);
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					tx->addWriteConflictRange(range);
															#line 5961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				}
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				referenceTx->set(range.begin, "1"_sr);
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				referenceTx->set(range.end, "0"_sr);
															#line 5967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (!read && deterministicRandom()->coinflip())
															#line 5971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
				try {
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_0 = tx->commit();
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 1;
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestConflictRangesActor, 0, Void >*>(static_cast<TestConflictRangesActor*>(this)));
															#line 5983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestConflictRangesActorState();
		static_cast<TestConflictRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(tx->get("\xff\xff/1314109/i_hope_this_isn't_registered"_sr));
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 2;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestConflictRangesActor, 1, Void >*>(static_cast<TestConflictRangesActor*>(this)));
															#line 6025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		CODE_PROBE(true, "Read write conflict range of committed transaction");
															#line 6040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 697 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (!static_cast<TestConflictRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestConflictRangesActorState(); static_cast<TestConflictRangesActor*>(this)->destroy(); return 0; }
															#line 6058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			new (&static_cast<TestConflictRangesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestConflictRangesActorState();
			static_cast<TestConflictRangesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state > 0) static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestConflictRangesActor*>(this)->ActorCallback< TestConflictRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestConflictRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		for(int i = 0;i < self->conflictRangeSizeFactor;++i) {
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			GetRangeLimits limit;
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector begin;
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeySelector end;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;;) {
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				begin = firstGreaterOrEqual(deterministicRandom()->randomChoice(keys));
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				end = firstGreaterOrEqual(deterministicRandom()->randomChoice(keys));
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (begin.getKey() < end.getKey())
															#line 6190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				{
					break;
				}
			}
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			Reverse reverse{ deterministicRandom()->coinflip() };
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto correctResultFuture = referenceTx->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(correctResultFuture.isReady());
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			begin.setKey(begin.getKey().withPrefix(prefix, begin.arena()));
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			end.setKey(end.getKey().withPrefix(prefix, begin.arena()));
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto testResultFuture = tx->getRange(begin, end, limit, Snapshot::False, reverse);
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(testResultFuture.isReady());
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto correct_iter = correctResultFuture.get().begin();
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			auto test_iter = testResultFuture.get().begin();
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			bool had_error = false;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;correct_iter != correctResultFuture.get().end() && test_iter != testResultFuture.get().end();) {
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (correct_iter->key != test_iter->key.removePrefix(prefix) || correct_iter->value != test_iter->value)
															#line 6219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				{
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					TraceEvent(SevError, "TestFailure") .detail("Reason", "Mismatched keys") .detail("ConflictType", read ? "read" : "write") .detail("CorrectKey", correct_iter->key) .detail("TestKey", test_iter->key) .detail("CorrectValue", correct_iter->value) .detail("TestValue", test_iter->value) .detail("Begin", begin) .detail("End", end) .detail("Ryw", ryw);
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					had_error = true;
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
					++self->wrongResults;
															#line 6227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				}
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++correct_iter;
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++test_iter;
															#line 6233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;correct_iter != correctResultFuture.get().end();) {
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Extra correct key") .detail("ConflictType", read ? "read" : "write") .detail("CorrectKey", correct_iter->key) .detail("CorrectValue", correct_iter->value) .detail("Begin", begin) .detail("End", end) .detail("Ryw", ryw);
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++correct_iter;
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				had_error = true;
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++self->wrongResults;
															#line 6245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;test_iter != testResultFuture.get().end();) {
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "TestFailure") .detail("Reason", "Extra test key") .detail("ConflictType", read ? "read" : "write") .detail("TestKey", test_iter->key) .detail("TestValue", test_iter->value) .detail("Begin", begin) .detail("End", end) .detail("Ryw", ryw);
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++test_iter;
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				had_error = true;
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				++self->wrongResults;
															#line 6257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (had_error)
															#line 6261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
				break;
			}
		}
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<TestConflictRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestConflictRangesActorState(); static_cast<TestConflictRangesActor*>(this)->destroy(); return 0; }
															#line 6268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		new (&static_cast<TestConflictRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestConflictRangesActorState();
		static_cast<TestConflictRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(e.code() == error_code_special_keys_no_module_found);
															#line 6289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 6304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 6313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont13cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestConflictRangesActor*>(this)->actor_wait_state > 0) static_cast<TestConflictRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestConflictRangesActor*>(this)->ActorCallback< TestConflictRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestConflictRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestConflictRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont13cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool read;
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	StringRef prefix;
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> referenceTx;
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool ryw;
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::vector<std::string> keys;
															#line 6422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
};
// This generated class is to be used only via testConflictRanges()
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class TestConflictRangesActor final : public Actor<Void>, public ActorCallback< TestConflictRangesActor, 0, Void >, public ActorCallback< TestConflictRangesActor, 1, Void >, public FastAllocated<TestConflictRangesActor>, public TestConflictRangesActorState<TestConflictRangesActor> {
															#line 6427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
	using FastAllocated<TestConflictRangesActor>::operator new;
	using FastAllocated<TestConflictRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13075873532647313920UL, 14262477420263172608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestConflictRangesActor, 0, Void >;
friend struct ActorCallback< TestConflictRangesActor, 1, Void >;
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	TestConflictRangesActor(Database const& cx_,bool const& read,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 6445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   TestConflictRangesActorState<TestConflictRangesActor>(cx_, read, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testConflictRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15893482590276846336UL, 2356409910050837504UL);
		ActorExecutionContextHelper __helper(static_cast<TestConflictRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testConflictRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testConflictRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestConflictRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestConflictRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> testConflictRanges( Database const& cx_, bool const& read, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new TestConflictRangesActor(cx_, read, self));
															#line 6478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
}

#line 780 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

	bool getRangeResultInOrder(const RangeResult& result) {
		for (int i = 0; i < result.size() - 1; ++i) {
			if (result[i].key >= result[i + 1].key) {
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "GetRangeResultNotInOrder")
				    .detail("Index", i)
				    .detail("Key1", result[i].key)
				    .detail("Key2", result[i + 1].key);
				return false;
			}
		}
		return true;
	}

																#line 6497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
// This generated class is to be used only via managementApiCorrectnessActor()
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class ManagementApiCorrectnessActorActor>
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class ManagementApiCorrectnessActorActorState {
															#line 6503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	ManagementApiCorrectnessActorActorState(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   cx(cx_->clone()),
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   tx(makeReference<ReadYourWritesTransaction>(cx))
															#line 6516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	~ManagementApiCorrectnessActorActorState() 
	{
		fdb_probe_actor_destroy("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_cluster_description = std::string();
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_coordinator_process = std::string();
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				old_coordinators_processes = std::vector<std::string>();
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				possible_to_add_coordinator = bool();
															#line 806 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				coordinators_key_range = KeyRangeRef("process/"_sr, "process0"_sr) .withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators"));
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				retries = 0;
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				changeCoordinatorsSucceeded = true;
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				;
															#line 6546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ManagementApiCorrectnessActorActorState();
		static_cast<ManagementApiCorrectnessActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 6570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("NewCoordinator", possible_to_add_coordinator ? new_coordinator_process : "") .detail("NewClusterDescription", new_cluster_description);
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (possible_to_add_coordinator)
															#line 6581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			;
															#line 6585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tx->get(coordinatorsKey);
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 1;
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tx->onError(e);
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 4;
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ccStrValue,int loopDepth) 
	{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ccStrValue.present());
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString ccStr(ccStrValue.get().toString());
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		new_cluster_description = SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT ? deterministicRandom()->randomAlphaNumeric(8) : ccStr.clusterKeyName().toString();
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tx->get( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")));
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 2;
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ccStrValue,int loopDepth) 
	{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ccStrValue.present());
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString ccStr(ccStrValue.get().toString());
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		new_cluster_description = SERVER_KNOBS->ENABLE_CROSS_CLUSTER_SUPPORT ? deterministicRandom()->randomAlphaNumeric(8) : ccStr.clusterKeyName().toString();
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tx->get( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")));
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 2;
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ccStrValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ccStrValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ccStrValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ccStrValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& processes_key,int loopDepth) 
	{
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(processes_key.present());
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		boost::split( old_coordinators_processes, processes_key.get().toString(), [](char c) { return c == ','; });
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_2 = getWorkers(&tx->getTransaction());
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 3;
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && processes_key,int loopDepth) 
	{
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(processes_key.present());
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		boost::split( old_coordinators_processes, processes_key.get().toString(), [](char c) { return c == ','; });
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<ProcessData>> __when_expr_2 = getWorkers(&tx->getTransaction());
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 3;
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 6823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& processes_key,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processes_key, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && processes_key,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processes_key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(std::vector<ProcessData> const& workers,int loopDepth) 
	{
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string old_coordinators_processes_string = describe(old_coordinators_processes);
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("OldCoordinators", old_coordinators_processes_string) .detail("WorkerSize", workers.size());
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (workers.size() > old_coordinators_processes.size())
															#line 6911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;;) {
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				auto worker = deterministicRandom()->randomChoice(workers);
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_coordinator_process = worker.address.toString();
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (old_coordinators_processes_string.find(new_coordinator_process) == std::string::npos)
															#line 6921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				{
					break;
				}
			}
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = true;
															#line 6928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = false;
															#line 6934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 6938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(std::vector<ProcessData> && workers,int loopDepth) 
	{
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string old_coordinators_processes_string = describe(old_coordinators_processes);
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("OldCoordinators", old_coordinators_processes_string) .detail("WorkerSize", workers.size());
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (workers.size() > old_coordinators_processes.size())
															#line 6951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for(;;) {
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				auto worker = deterministicRandom()->randomChoice(workers);
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_coordinator_process = worker.address.toString();
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (old_coordinators_processes_string.find(new_coordinator_process) == std::string::npos)
															#line 6961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				{
					break;
				}
			}
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = true;
															#line 6968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			possible_to_add_coordinator = false;
															#line 6974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 6978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(std::vector<ProcessData> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*,std::vector<ProcessData> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 5;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 5;
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		try {
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_9 = tx->get(coordinatorsKey);
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 7267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont4Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont4when1(__when_expr_9.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 10;
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string new_processes_key(new_coordinator_process);
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for( const auto& address : old_coordinators_processes ) {
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_processes_key += "," + address;
															#line 7303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")), Value(new_processes_key));
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("cluster_description"_sr.withPrefix( SpecialKeySpace::getManagementApiCommandPrefix("coordinators")), Value(new_cluster_description));
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tx->commit();
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 6;
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorsManualChange").error(e);
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 7355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_6 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 7;
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_7 = tx->onError(e);
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when2(__when_expr_7.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 8;
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 7396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 7405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(int loopDepth) 
	{
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 9;
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 7532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (++retries >= 10)
															#line 7536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				CODE_PROBE( true, "ChangeCoordinators Exceeded retry limit", probe::decoration::rare);
															#line 893 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				changeCoordinatorsSucceeded = false;
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 7544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 7549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(valueObj["message"].get_str() == "No change (existing configuration satisfies request)");
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(true, "Successfully changed coordinators");
															#line 7559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChange") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 7584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (++retries >= 10)
															#line 7588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				CODE_PROBE( true, "ChangeCoordinators Exceeded retry limit", probe::decoration::rare);
															#line 893 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				changeCoordinatorsSucceeded = false;
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 7596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 7601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(valueObj["message"].get_str() == "No change (existing configuration satisfies request)");
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			CODE_PROBE(true, "Successfully changed coordinators");
															#line 7611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont2loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont2loopBody1Catch1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 7871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tx->onError(e);
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont4Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 12;
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> const& res,int loopDepth) 
	{
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(res.present());
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString csNew(res.get().toString());
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || new_cluster_description == csNew.clusterKeyName().toString());
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || csNew.hostnames.size() + csNew.coords.size() == old_coordinators_processes.size() + 1);
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_10 = csNew.tryResolveHostnames();
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 7913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont4Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 11;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<Value> && res,int loopDepth) 
	{
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(res.present());
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ClusterConnectionString csNew(res.get().toString());
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || new_cluster_description == csNew.clusterKeyName().toString());
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!changeCoordinatorsSucceeded || csNew.hostnames.size() + csNew.coords.size() == old_coordinators_processes.size() + 1);
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_10 = csNew.tryResolveHostnames();
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 7937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont4Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 11;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 7942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont6(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<Value> && res,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont7(std::vector<NetworkAddress> const& newCoordinators,int loopDepth) 
	{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		for( const auto& network_address : newCoordinators ) {
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string address_str = network_address.toString();
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(std::find(old_coordinators_processes.begin(), old_coordinators_processes.end(), address_str) != old_coordinators_processes.end() || new_coordinator_process == address_str);
															#line 8030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 8034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(std::vector<NetworkAddress> && newCoordinators,int loopDepth) 
	{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		for( const auto& network_address : newCoordinators ) {
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string address_str = network_address.toString();
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ASSERT(std::find(old_coordinators_processes.begin(), old_coordinators_processes.end(), address_str) != old_coordinators_processes.end() || new_coordinator_process == address_str);
															#line 8047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 8051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<NetworkAddress> const& newCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont7(newCoordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<NetworkAddress> && newCoordinators,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(newCoordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_12 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont4Catch1cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 13;
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4Catch1cont1(Void && _,int loopDepth) 
	{
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_12 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont4Catch1cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 13;
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont4Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont4Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont4Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont4Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont4Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!(changeCoordinatorsSucceeded))
															#line 8355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			std::string new_processes_key;
															#line 940 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			for( const auto& address : old_coordinators_processes ) {
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_processes_key += new_processes_key.size() ? "," : "";
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				new_processes_key += address;
															#line 8372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set( "processes"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("coordinators")), Value(new_processes_key));
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_13 = tx->commit();
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont5loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont5loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont5loopBody1when1(__when_expr_13.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 14;
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorsManualChangeRevert").error(e);
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 8422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_14 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1Catch1when1(__when_expr_14.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 15;
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_15 = tx->onError(e);
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1Catch1when2(__when_expr_15.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 16;
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 8463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 8472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont5loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont5loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont5loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont5loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont1(int loopDepth) 
	{
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_16 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1Catch1cont1when1(__when_expr_16.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 17;
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 959 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChangeRevert") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 8599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 966 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 8603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (valueObj["message"].get_str() == "No change (existing configuration satisfies request)")
															#line 8609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 969 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 8613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "CoordinatorsManualChangeRevert") .detail("UnexpectedError", valueObj["message"].get_str());
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 8622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 959 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "CoordinatorsManualChangeRevert") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "coordinators");
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (valueObj["retriable"].get_bool())
															#line 8647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 966 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->reset();
															#line 8651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
		else
		{
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (valueObj["message"].get_str() == "No change (existing configuration satisfies request)")
															#line 8657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 969 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				tx->reset();
															#line 8661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				TraceEvent(SevError, "CoordinatorsManualChangeRevert") .detail("UnexpectedError", valueObj["message"].get_str());
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 8670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont5loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont5loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont5loopBody1Catch1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont5loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont5loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont5loopBody1Catch1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1Catch1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont5loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont5loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont12(int loopDepth) 
	{
		{
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			;
															#line 8931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = a_body1cont12loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 988 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_17 = tx->getRange(SpecialKeySpace::getManagementApiCommandRange("maintenance"), CLIENT_KNOBS->TOO_MANY);
															#line 988 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1loopBody1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_17.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 18;
															#line 988 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 8956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "MaintenanceGet").error(e);
															#line 1005 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_19 = tx->onError(e);
															#line 1005 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_19.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 20;
															#line 1005 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult const& maintenanceKVs,int loopDepth) 
	{
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!maintenanceKVs.more && !maintenanceKVs.size());
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_18 = tx->getRange(SpecialKeySpace::getManagementApiCommandRange("datadistribution"), CLIENT_KNOBS->TOO_MANY);
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1loopBody1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_18.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 19;
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult && maintenanceKVs,int loopDepth) 
	{
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!maintenanceKVs.more && !maintenanceKVs.size());
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_18 = tx->getRange(SpecialKeySpace::getManagementApiCommandRange("datadistribution"), CLIENT_KNOBS->TOO_MANY);
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1loopBody1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_18.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 19;
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& maintenanceKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(maintenanceKVs, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && maintenanceKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(maintenanceKVs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont1loopBody1cont3(RangeResult const& ddKVs,int loopDepth) 
	{
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!ddKVs.more && ddKVs.size() == 1);
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].key == "mode"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("datadistribution")));
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent("DDKVsValue").detail("Value", ddKVs[0].value);
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].value == Value(boost::lexical_cast<std::string>(-1)));
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(RangeResult && ddKVs,int loopDepth) 
	{
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!ddKVs.more && ddKVs.size() == 1);
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].key == "mode"_sr.withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("datadistribution")));
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent("DDKVsValue").detail("Value", ddKVs[0].value);
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ddKVs[0].value == Value(boost::lexical_cast<std::string>(-1)));
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult const& ddKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(ddKVs, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult && ddKVs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(ddKVs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<ManagementApiCorrectnessActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementApiCorrectnessActorActorState(); static_cast<ManagementApiCorrectnessActorActor*>(this)->destroy(); return 0; }
															#line 9322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		new (&static_cast<ManagementApiCorrectnessActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementApiCorrectnessActorActorState();
		static_cast<ManagementApiCorrectnessActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry = 0;
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 9336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
		try {
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set(Key(deterministicRandom()->randomAlphaNumeric(8)) .withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("maintenance")), Value(boost::lexical_cast<std::string>(deterministicRandom()->randomInt(1, 100))));
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set(Key(deterministicRandom()->randomAlphaNumeric(9)) .withPrefix(SpecialKeySpace::getManagementApiCommandPrefix("maintenance")), Value(boost::lexical_cast<std::string>(deterministicRandom()->randomInt(1, 100))));
															#line 1022 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_20 = tx->commit();
															#line 1022 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont12loopBody1Catch1(__when_expr_20.getError(), loopDepth); else return a_body1cont12loopBody1when1(__when_expr_20.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 21;
															#line 1022 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_20.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "MaintenanceSetMoreThanOneZone").error(e);
															#line 1026 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 9405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_21 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1Catch1when1(__when_expr_21.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 22;
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_21.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_22 = tx->onError(e);
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1Catch1when2(__when_expr_22.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 23;
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_22.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 9446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(false);
															#line 9455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose21() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose21();
		try {
			a_body1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 20);

	}
	int a_body1cont12loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_23 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1Catch1(__when_expr_23.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1Catch1cont1when1(__when_expr_23.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 24;
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 1032 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 1034 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceSetMoreThanOneZone") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 1032 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 1034 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceSetMoreThanOneZone") .detail("ErrorMessage", valueObj["message"].get_str());
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 9605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose22() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1cont12loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose22();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 21);

	}
	int a_body1cont12loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose23() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1cont12loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose23();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 22);

	}
	int a_body1cont12loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose24() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1cont12loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose24();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 23);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 1087 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ddIgnoreValue = DDIgnore::NONE;
															#line 1088 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 9865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 1089 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ddIgnoreValue |= DDIgnore::REBALANCE_READ;
															#line 9869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 9873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		{
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			ddIgnoreValue |= DDIgnore::REBALANCE_DISK;
															#line 9877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		}
															#line 1094 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 9881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set(ignoreSSFailuresZoneString.withPrefix( SpecialKeySpace::getManagementApiCommandPrefix("maintenance")), Value(boost::lexical_cast<std::string>(0)));
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_24 = tx->commit();
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_24.getError(), loopDepth); else return a_body1cont12cont2loopBody1when1(__when_expr_24.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 25;
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_24.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "MaintenanceDDIgnoreSSFailures").error(e);
															#line 1063 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 9948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_26 = tx->get(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::ERRORMSG).begin);
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1Catch1when1(__when_expr_26.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 27;
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_27 = tx->onError(e);
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1Catch1when2(__when_expr_27.get(), loopDepth); };
				static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 28;
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 9973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry++;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_25 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont12cont2loopBody1cont2when1(__when_expr_25.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 26;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry++;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_25 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont12cont2loopBody1Catch1(__when_expr_25.getError(), loopDepth); else return a_body1cont12cont2loopBody1cont2when1(__when_expr_25.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 26;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose25() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose25();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 24);

	}
	int a_body1cont12cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose26() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose26();
		try {
			a_body1cont12cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 25);

	}
	int a_body1cont12cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ignoreSSFailuresRetry++;
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_28 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont2loopBody1Catch1cont1when1(__when_expr_28.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 29;
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont2(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 1071 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ignoreSSFailuresRetry > 0);
															#line 1074 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceDDIgnoreSSFailures") .detail("Retry", ignoreSSFailuresRetry) .detail("ErrorMessage", valueObj["message"].get_str());
															#line 1077 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont2(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(errorMsg.present());
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 1071 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(valueObj["command"].get_str() == "maintenance" && !valueObj["retriable"].get_bool());
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(ignoreSSFailuresRetry > 0);
															#line 1074 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		TraceEvent(SevDebug, "MaintenanceDDIgnoreSSFailures") .detail("Retry", ignoreSSFailuresRetry) .detail("ErrorMessage", valueObj["message"].get_str());
															#line 1077 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont2(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont2(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose27() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont12cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1cont12cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose27();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont12cont2loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose28() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont12cont2loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1cont12cont2loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose28();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont12cont2loopBody1Catch1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2loopBody1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose29() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont12cont2loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1cont12cont2loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose29();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 28);

	}
	int a_body1cont12cont4(int loopDepth) 
	{
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 10521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1(int loopDepth) 
	{
		try {
															#line 1096 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeyRef ddPrefix = SpecialKeySpace::getManagementApiCommandPrefix("datadistribution");
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("mode"_sr.withPrefix(ddPrefix), "0"_sr);
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->set("rebalance_ignored"_sr.withPrefix(ddPrefix), BinaryWriter::toValue(ddIgnoreValue, Unversioned()));
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_29 = tx->commit();
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont3loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1cont12cont3loopBody1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont12cont3loopBody1when1(__when_expr_29.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 30;
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont3loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont3loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			TraceEvent(SevDebug, "DataDistributionDisableModeAndRebalance").error(e);
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_30 = tx->onError(e);
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont3loopBody1Catch1when1(__when_expr_30.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 31;
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 10623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose30() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont12cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont12cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose30();
		try {
			a_body1cont12cont3loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont3loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont3loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont12cont3loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont3loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose31() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont12cont3loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1cont12cont3loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose31();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1cont12cont7(int loopDepth) 
	{
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 10794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1(int loopDepth) 
	{
		try {
															#line 1113 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_31 = tx->get(healthyZoneKey);
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_31.getError(), loopDepth); else return a_body1cont12cont4loopBody1when1(__when_expr_31.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 32;
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_34 = tx->onError(e);
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_34.isReady()) { if (__when_expr_34.isError()) return a_body1Catch1(__when_expr_34.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont4loopBody1Catch1when1(__when_expr_34.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 35;
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_34.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2(Optional<Value> const& val1,int loopDepth) 
	{
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val1.present());
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto healthyZone = decodeHealthyZoneValue(val1.get());
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(healthyZone.first == ignoreSSFailuresZoneString);
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_32 = tx->get(dataDistributionModeKey);
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_32.isReady()) { if (__when_expr_32.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_32.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont2when1(__when_expr_32.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 33;
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_32.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2(Optional<Value> && val1,int loopDepth) 
	{
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val1.present());
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto healthyZone = decodeHealthyZoneValue(val1.get());
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(healthyZone.first == ignoreSSFailuresZoneString);
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_32 = tx->get(dataDistributionModeKey);
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_32.isReady()) { if (__when_expr_32.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_32.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont2when1(__when_expr_32.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 33;
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_32.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 10912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1when1(Optional<Value> const& val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont2(val1, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1when1(Optional<Value> && val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont2(std::move(val1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose32() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont12cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont12cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose32();
		try {
			a_body1cont12cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 31);

	}
	int a_body1cont12cont4loopBody1cont3(Optional<Value> const& val2,int loopDepth) 
	{
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val2.present());
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(BinaryReader::fromStringRef<int>(val2.get(), Unversioned()) == 0);
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_33 = tx->get(rebalanceDDIgnoreKey);
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_33.isReady()) { if (__when_expr_33.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_33.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont3when1(__when_expr_33.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 34;
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_33.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont3(Optional<Value> && val2,int loopDepth) 
	{
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val2.present());
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(BinaryReader::fromStringRef<int>(val2.get(), Unversioned()) == 0);
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_33 = tx->get(rebalanceDDIgnoreKey);
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_33.isReady()) { if (__when_expr_33.isError()) return a_body1cont12cont4loopBody1Catch1(__when_expr_33.getError(), loopDepth); else return a_body1cont12cont4loopBody1cont3when1(__when_expr_33.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 34;
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_33.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2when1(Optional<Value> const& val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont3(val2, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont2when1(Optional<Value> && val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont3(std::move(val2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose33() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont12cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont12cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose33();
		try {
			a_body1cont12cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 32);

	}
	int a_body1cont12cont4loopBody1cont4(Optional<Value> const& val3,int loopDepth) 
	{
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val3.present() && BinaryReader::fromStringRef<uint8_t>(val3.get(), Unversioned()) == ddIgnoreValue);
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont4(Optional<Value> && val3,int loopDepth) 
	{
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(val3.present() && BinaryReader::fromStringRef<uint8_t>(val3.get(), Unversioned()) == ddIgnoreValue);
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont3when1(Optional<Value> const& val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont4(val3, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1cont3when1(Optional<Value> && val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont4(std::move(val3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose34() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont12cont4loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont12cont4loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose34();
		try {
			a_body1cont12cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 33);

	}
	int a_body1cont12cont4loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose35() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1cont12cont4loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1cont12cont4loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose35();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 34);

	}
	int a_body1cont12cont8(int loopDepth) 
	{
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		;
															#line 11295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1(int loopDepth) 
	{
		try {
															#line 1137 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear(ignoreSSFailuresZoneString.withPrefix( SpecialKeySpace::getManagementApiCommandPrefix("maintenance")));
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			KeyRef ddPrefix = SpecialKeySpace::getManagementApiCommandPrefix("datadistribution");
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear("mode"_sr.withPrefix(ddPrefix));
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->clear("rebalance_ignored"_sr.withPrefix(ddPrefix));
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_35 = tx->commit();
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont7loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_35.isReady()) { if (__when_expr_35.isError()) return a_body1cont12cont7loopBody1Catch1(__when_expr_35.getError(), loopDepth); else return a_body1cont12cont7loopBody1when1(__when_expr_35.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 36;
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_35.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont7loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont7loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_36 = tx->onError(e);
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_36.isReady()) { if (__when_expr_36.isError()) return a_body1Catch1(__when_expr_36.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont7loopBody1Catch1when1(__when_expr_36.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 37;
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_36.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont7break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose36() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont12cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont12cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose36();
		try {
			a_body1cont12cont7loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont7loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont7loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 35);

	}
	int a_body1cont12cont7loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose37() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1cont12cont7loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1cont12cont7loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose37();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 36);

	}
	int a_body1cont12cont9(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1(int loopDepth) 
	{
		try {
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_37 = tx->get(healthyZoneKey);
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_37.isReady()) { if (__when_expr_37.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_37.getError(), loopDepth); else return a_body1cont12cont8loopBody1when1(__when_expr_37.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 38;
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_37.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont8loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont8loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont12cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1167 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_40 = tx->onError(e);
															#line 1167 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			if (__when_expr_40.isReady()) { if (__when_expr_40.isError()) return a_body1Catch1(__when_expr_40.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12cont8loopBody1Catch1when1(__when_expr_40.get(), loopDepth); };
			static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 41;
															#line 1167 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			__when_expr_40.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2(Optional<Value> const& val1,int loopDepth) 
	{
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val1.present());
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_38 = tx->get(dataDistributionModeKey);
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_38.isReady()) { if (__when_expr_38.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_38.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont2when1(__when_expr_38.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 39;
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_38.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2(Optional<Value> && val1,int loopDepth) 
	{
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val1.present());
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_38 = tx->get(dataDistributionModeKey);
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_38.isReady()) { if (__when_expr_38.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_38.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont2when1(__when_expr_38.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 39;
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_38.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1when1(Optional<Value> const& val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont2(val1, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1when1(Optional<Value> && val1,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont2(std::move(val1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose38() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont12cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont12cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose38();
		try {
			a_body1cont12cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 37);

	}
	int a_body1cont12cont8loopBody1cont3(Optional<Value> const& val2,int loopDepth) 
	{
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val2.present());
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_39 = tx->get(rebalanceDDIgnoreKey);
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_39.isReady()) { if (__when_expr_39.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_39.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont3when1(__when_expr_39.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 40;
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_39.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont3(Optional<Value> && val2,int loopDepth) 
	{
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val2.present());
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_39 = tx->get(rebalanceDDIgnoreKey);
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1cont12cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		if (__when_expr_39.isReady()) { if (__when_expr_39.isError()) return a_body1cont12cont8loopBody1Catch1(__when_expr_39.getError(), loopDepth); else return a_body1cont12cont8loopBody1cont3when1(__when_expr_39.get(), loopDepth); };
		static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 40;
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		__when_expr_39.addCallbackAndClear(static_cast<ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*>(static_cast<ManagementApiCorrectnessActorActor*>(this)));
															#line 11786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2when1(Optional<Value> const& val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont3(val2, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont2when1(Optional<Value> && val2,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont3(std::move(val2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose39() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont12cont8loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont12cont8loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose39();
		try {
			a_body1cont12cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 38);

	}
	int a_body1cont12cont8loopBody1cont4(Optional<Value> const& val3,int loopDepth) 
	{
															#line 1163 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val3.present());
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont4(Optional<Value> && val3,int loopDepth) 
	{
															#line 1163 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(!val3.present());
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		tx->reset();
															#line 11883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		return a_body1cont12cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont3when1(Optional<Value> const& val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont4(val3, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1cont3when1(Optional<Value> && val3,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont4(std::move(val3), loopDepth);

		return loopDepth;
	}
	void a_exitChoose40() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont12cont8loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont12cont8loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose40();
		try {
			a_body1cont12cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 39);

	}
	int a_body1cont12cont8loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose41() 
	{
		if (static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<ManagementApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementApiCorrectnessActorActor*>(this)->ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1cont12cont8loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_fire(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1cont12cont8loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
	void a_callback_error(ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose41();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 40);

	}
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::string new_cluster_description;
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::string new_coordinator_process;
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	std::vector<std::string> old_coordinators_processes;
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool possible_to_add_coordinator;
															#line 806 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	KeyRange coordinators_key_range;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	unsigned retries;
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	bool changeCoordinatorsSucceeded;
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	int ignoreSSFailuresRetry;
															#line 1087 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	uint8_t ddIgnoreValue;
															#line 12076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
};
// This generated class is to be used only via managementApiCorrectnessActor()
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class ManagementApiCorrectnessActorActor final : public Actor<Void>, public ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >, public ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >, public ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >, public ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >, public ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >, public ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >, public FastAllocated<ManagementApiCorrectnessActorActor>, public ManagementApiCorrectnessActorActorState<ManagementApiCorrectnessActorActor> {
															#line 12081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
	using FastAllocated<ManagementApiCorrectnessActorActor>::operator new;
	using FastAllocated<ManagementApiCorrectnessActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(983954020084539904UL, 14176996183491455232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >;
friend struct ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >;
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	ManagementApiCorrectnessActorActor(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 12138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   ManagementApiCorrectnessActorActorState<ManagementApiCorrectnessActorActor>(cx_, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15613886550486222848UL, 15598498704839473152UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("managementApiCorrectnessActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("managementApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 2, std::vector<ProcessData> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 6, Optional<Value> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 9, Optional<Value> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 10, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 14, Optional<Value> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 17, RangeResult >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 18, RangeResult >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 19, Void >*)0, actor_cancelled()); break;
		case 21: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 20, Void >*)0, actor_cancelled()); break;
		case 22: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 21, Optional<Value> >*)0, actor_cancelled()); break;
		case 23: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 22, Void >*)0, actor_cancelled()); break;
		case 24: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 23, Void >*)0, actor_cancelled()); break;
		case 25: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 24, Void >*)0, actor_cancelled()); break;
		case 26: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 25, Void >*)0, actor_cancelled()); break;
		case 27: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 26, Optional<Value> >*)0, actor_cancelled()); break;
		case 28: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 27, Void >*)0, actor_cancelled()); break;
		case 29: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 28, Void >*)0, actor_cancelled()); break;
		case 30: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 29, Void >*)0, actor_cancelled()); break;
		case 31: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 30, Void >*)0, actor_cancelled()); break;
		case 32: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 31, Optional<Value> >*)0, actor_cancelled()); break;
		case 33: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 32, Optional<Value> >*)0, actor_cancelled()); break;
		case 34: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 33, Optional<Value> >*)0, actor_cancelled()); break;
		case 35: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 34, Void >*)0, actor_cancelled()); break;
		case 36: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 35, Void >*)0, actor_cancelled()); break;
		case 37: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 36, Void >*)0, actor_cancelled()); break;
		case 38: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 37, Optional<Value> >*)0, actor_cancelled()); break;
		case 39: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 38, Optional<Value> >*)0, actor_cancelled()); break;
		case 40: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 39, Optional<Value> >*)0, actor_cancelled()); break;
		case 41: this->a_callback_error((ActorCallback< ManagementApiCorrectnessActorActor, 40, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> managementApiCorrectnessActor( Database const& cx_, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new ManagementApiCorrectnessActorActor(cx_, self));
															#line 12210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
}

#line 1173 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"

																#line 12215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
// This generated class is to be used only via metricsApiCorrectnessActor()
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
template <class MetricsApiCorrectnessActorActor>
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class MetricsApiCorrectnessActorActorState {
															#line 12221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	MetricsApiCorrectnessActorActorState(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		 : cx_(cx_),
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   self(self),
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   cx(cx_->clone()),
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		   tx(makeReference<ReadYourWritesTransaction>(cx))
															#line 12234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	~MetricsApiCorrectnessActorActorState() 
	{
		fdb_probe_actor_destroy("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1177 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
			tx->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 12249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
			{
															#line 1179 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tx->get("fault_tolerance_metrics_json"_sr.withPrefix( SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::METRICS).begin));
															#line 1179 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				if (static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state = 1;
															#line 1179 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*>(static_cast<MetricsApiCorrectnessActorActor*>(this)));
															#line 12260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetricsApiCorrectnessActorActorState();
		static_cast<MetricsApiCorrectnessActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		if (!static_cast<MetricsApiCorrectnessActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MetricsApiCorrectnessActorActorState(); static_cast<MetricsApiCorrectnessActorActor*>(this)->destroy(); return 0; }
															#line 12284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		new (&static_cast<MetricsApiCorrectnessActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MetricsApiCorrectnessActorActorState();
		static_cast<MetricsApiCorrectnessActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& metrics,int loopDepth) 
	{
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(metrics.present());
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto metricsObj = readJSONStrictly(metrics.get().toString()).get_obj();
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::faultToleranceStatusSchema.toString()).get_obj();
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, metricsObj, errorStr, SevError, true));
															#line 12304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && metrics,int loopDepth) 
	{
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(metrics.present());
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto metricsObj = readJSONStrictly(metrics.get().toString()).get_obj();
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::faultToleranceStatusSchema.toString()).get_obj();
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		std::string errorStr;
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
		ASSERT(schemaMatch(schema, metricsObj, errorStr, SevError, true));
															#line 12321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& metrics,int loopDepth) 
	{
		loopDepth = a_body1cont2(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && metrics,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state > 0) static_cast<MetricsApiCorrectnessActorActor*>(this)->actor_wait_state = 0;
		static_cast<MetricsApiCorrectnessActorActor*>(this)->ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx_;
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	SpecialKeySpaceCorrectnessWorkload* self;
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Database cx;
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tx;
															#line 12409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
};
// This generated class is to be used only via metricsApiCorrectnessActor()
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
class MetricsApiCorrectnessActorActor final : public Actor<Void>, public ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >, public FastAllocated<MetricsApiCorrectnessActorActor>, public MetricsApiCorrectnessActorActorState<MetricsApiCorrectnessActorActor> {
															#line 12414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
public:
	using FastAllocated<MetricsApiCorrectnessActorActor>::operator new;
	using FastAllocated<MetricsApiCorrectnessActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9276215339044327680UL, 10060320161681297408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >;
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	MetricsApiCorrectnessActorActor(Database const& cx_,SpecialKeySpaceCorrectnessWorkload* const& self) 
															#line 12431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   MetricsApiCorrectnessActorActorState<MetricsApiCorrectnessActorActor>(cx_, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17798466712909914112UL, 1737899628299752960UL);
		ActorExecutionContextHelper __helper(static_cast<MetricsApiCorrectnessActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metricsApiCorrectnessActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metricsApiCorrectnessActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetricsApiCorrectnessActorActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
[[nodiscard]] Future<Void> metricsApiCorrectnessActor( Database const& cx_, SpecialKeySpaceCorrectnessWorkload* const& self ) {
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
	return Future<Void>(new MetricsApiCorrectnessActorActor(cx_, self));
															#line 12463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.g.cpp"
}

#line 1189 "/Users/ec2-user/foundationdb/fdbserver/workloads/SpecialKeySpaceCorrectness.actor.cpp"
};

WorkloadFactory<SpecialKeySpaceCorrectnessWorkload> SpecialKeySpaceCorrectnessFactory;
