#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
/*
 * RYWPerformance.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RYWPerformanceWorkload : TestWorkload {
	static constexpr auto NAME = "RYWPerformance";

	int keyBytes, nodes, ranges;
	RYWPerformanceWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		nodes = getOption(options, "nodes"_sr, 10000);
		ranges = getOption(options, "ranges"_sr, 10);
		keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 16);
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0)
			return _setup(cx, this);
		return Void();
	}

																#line 45 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
template <class _setupActor>
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class _setupActorState {
															#line 51 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	_setupActorState(Database const& cx,RYWPerformanceWorkload* const& self) 
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		 : cx(cx),
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   self(self),
															#line 44 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   tr(cx)
															#line 62 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 46 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			;
															#line 77 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 48 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			for(int i = 0;i < self->nodes;i++) {
															#line 49 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
				tr.set(self->keyForIndex(i), "bar"_sr);
															#line 122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			}
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Database cx;
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	RYWPerformanceWorkload* self;
															#line 44 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Transaction tr;
															#line 366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1494057790186591744UL, 11799051362117237248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	_setupActor(Database const& cx,RYWPerformanceWorkload* const& self) 
															#line 389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, RYWPerformanceWorkload* const& self ) {
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
}

#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return _start(cx, this);
		return Void();
	}

																#line 433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
// This generated class is to be used only via fillCache()
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
template <class FillCacheActor>
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class FillCacheActorState {
															#line 439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	FillCacheActorState(ReadYourWritesTransaction* const& tr,RYWPerformanceWorkload* const& self,int const& type) 
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		 : tr(tr),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   self(self),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   type(type),
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   i()
															#line 452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
	{
		fdb_probe_actor_create("fillCache", reinterpret_cast<unsigned long>(this));

	}
	~FillCacheActorState() 
	{
		fdb_probe_actor_destroy("fillCache", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (type == 0)
															#line 467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			{
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
				for(i = 0;i < self->nodes;i++) {
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
					tr->set(self->keyForIndex(i), "foo"_sr);
															#line 473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
				}
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
				if (type == 1)
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
				{
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
					std::vector<Future<Optional<Value>>> gets;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
					for(i = 0;i < self->nodes;i++) {
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
						gets.push_back(tr->get(self->keyForIndex(i)));
															#line 489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
					}
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
					StrictFuture<Void> __when_expr_0 = waitForAll(gets);
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
					if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<FillCacheActor*>(this)->actor_wait_state = 1;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 0, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
					if (type == 2)
															#line 507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
					{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
						std::vector<Future<Optional<Value>>> gets;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
						for(i = 0;i < self->nodes;i++) {
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
							gets.push_back(tr->get(self->keyForIndex(i)));
															#line 515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
						}
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
						StrictFuture<Void> __when_expr_1 = waitForAll(gets);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
						if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<FillCacheActor*>(this)->actor_wait_state = 2;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 1, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
						if (type == 3)
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
						{
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
							std::vector<Future<Optional<Value>>> gets;
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
							for(i = 0;i < self->nodes;i += 2) {
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
								gets.push_back(tr->get(self->keyForIndex(i)));
															#line 541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
							}
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
							StrictFuture<Void> __when_expr_2 = waitForAll(gets);
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
							if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
							if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
							static_cast<FillCacheActor*>(this)->actor_wait_state = 3;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
							__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 2, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
							if (type == 4)
															#line 559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
							{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
								StrictFuture<Void> __when_expr_3 = success(tr->getRange(KeyRangeRef(self->keyForIndex(0), self->keyForIndex(self->nodes)), self->nodes));
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
								if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
								if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
								static_cast<FillCacheActor*>(this)->actor_wait_state = 4;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
								__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 3, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
								if (type == 5)
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
								{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
									StrictFuture<Void> __when_expr_4 = success(tr->getRange(KeyRangeRef(self->keyForIndex(0), self->keyForIndex(self->nodes)), self->nodes));
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
									if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
									if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when5(__when_expr_4.get(), loopDepth); };
									static_cast<FillCacheActor*>(this)->actor_wait_state = 5;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
									__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 4, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
									if (type == 6)
															#line 595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
									{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
										StrictFuture<Void> __when_expr_5 = success(tr->getRange(KeyRangeRef(self->keyForIndex(0), self->keyForIndex(self->nodes)), self->nodes));
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
										if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
										if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when6(__when_expr_5.get(), loopDepth); };
										static_cast<FillCacheActor*>(this)->actor_wait_state = 6;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
										__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 5, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
										loopDepth = 0;
									}
									else
									{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
										if (type == 7)
															#line 613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
										{
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
											StrictFuture<Void> __when_expr_6 = success(tr->getRange(KeyRangeRef(self->keyForIndex(0), self->keyForIndex(self->nodes)), self->nodes));
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
											if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
											if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when7(__when_expr_6.get(), loopDepth); };
											static_cast<FillCacheActor*>(this)->actor_wait_state = 7;
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
											__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 6, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
											loopDepth = 0;
										}
										else
										{
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
											if (type == 8)
															#line 631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
											{
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
												StrictFuture<Void> __when_expr_7 = success(tr->getRange(KeyRangeRef(self->keyForIndex(0), self->keyForIndex(self->nodes)), self->nodes));
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
												if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
												if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1when8(__when_expr_7.get(), loopDepth); };
												static_cast<FillCacheActor*>(this)->actor_wait_state = 8;
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
												__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 7, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
												loopDepth = 0;
											}
											else
											{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
												if (type == 9)
															#line 649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
												{
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
													std::vector<Future<RangeResult>> gets;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
													for(i = 0;i < self->nodes;i++) {
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
														gets.push_back(tr->getRange(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 2)), self->nodes));
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
													}
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
													StrictFuture<Void> __when_expr_8 = waitForAll(gets);
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
													if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
													if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1when9(__when_expr_8.get(), loopDepth); };
													static_cast<FillCacheActor*>(this)->actor_wait_state = 9;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
													__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 8, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
													loopDepth = 0;
												}
												else
												{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
													if (type == 10)
															#line 675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
													{
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
														std::vector<Future<RangeResult>> gets;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
														for(i = 0;i < self->nodes;i++) {
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															gets.push_back(tr->getRange(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 2)), self->nodes));
															#line 683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
														}
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
														StrictFuture<Void> __when_expr_9 = waitForAll(gets);
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
														if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
														if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1when10(__when_expr_9.get(), loopDepth); };
														static_cast<FillCacheActor*>(this)->actor_wait_state = 10;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
														__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 9, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
														loopDepth = 0;
													}
													else
													{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
														if (type == 11)
															#line 701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
														{
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															std::vector<Future<RangeResult>> gets;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															for(i = 0;i < self->nodes;i++) {
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																gets.push_back(tr->getRange(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 2)), self->nodes));
															#line 709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
															}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															StrictFuture<Void> __when_expr_10 = waitForAll(gets);
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
															if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1when11(__when_expr_10.get(), loopDepth); };
															static_cast<FillCacheActor*>(this)->actor_wait_state = 11;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 10, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
															loopDepth = 0;
														}
														else
														{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															if (type == 12)
															#line 727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
															{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																std::vector<Future<RangeResult>> gets;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																for(i = 0;i < self->nodes;i++) {
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																	gets.push_back(tr->getRange(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 2)), self->nodes));
															#line 735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
																}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																StrictFuture<Void> __when_expr_11 = waitForAll(gets);
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
																if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1when12(__when_expr_11.get(), loopDepth); };
																static_cast<FillCacheActor*>(this)->actor_wait_state = 12;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 11, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
																loopDepth = 0;
															}
															else
															{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																if (type == 13)
															#line 753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
																{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																	std::vector<Future<RangeResult>> gets;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																	for(i = 0;i < self->nodes;i++) {
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																		gets.push_back(tr->getRange(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 2)), self->nodes));
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
																	}
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																	StrictFuture<Void> __when_expr_12 = waitForAll(gets);
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																	if (static_cast<FillCacheActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
																	if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1when13(__when_expr_12.get(), loopDepth); };
																	static_cast<FillCacheActor*>(this)->actor_wait_state = 13;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
																	__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< FillCacheActor, 12, Void >*>(static_cast<FillCacheActor*>(this)));
															#line 772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
																	loopDepth = 0;
																}
																else
																{
																	loopDepth = a_body1cont37(loopDepth);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FillCacheActorState();
		static_cast<FillCacheActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!static_cast<FillCacheActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FillCacheActorState(); static_cast<FillCacheActor*>(this)->destroy(); return 0; }
															#line 813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		new (&static_cast<FillCacheActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FillCacheActorState();
		static_cast<FillCacheActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 1;i < self->nodes;i += 2) {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 1;i < self->nodes;i += 2) {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont17(int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(Void const& _,int loopDepth) 
	{
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(Void && _,int loopDepth) 
	{
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont19(int loopDepth) 
	{
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(Void const& _,int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(Void && _,int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont20(_, loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont20(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont21(int loopDepth) 
	{
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1cont22(Void const& _,int loopDepth) 
	{
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(self->keyForIndex(i));
															#line 1439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont22(Void && _,int loopDepth) 
	{
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(self->keyForIndex(i));
															#line 1451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22(_, loopDepth);

		return loopDepth;
	}
	int a_body1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont23(int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(Void const& _,int loopDepth) 
	{
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 1)));
															#line 1544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(Void && _,int loopDepth) 
	{
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 1)));
															#line 1556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont24(_, loopDepth);

		return loopDepth;
	}
	int a_body1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont24(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont25(int loopDepth) 
	{
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1cont26(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25(loopDepth);

		return loopDepth;
	}
	int a_body1cont26(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25(loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont26(_, loopDepth);

		return loopDepth;
	}
	int a_body1when9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont26(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont28(int loopDepth) 
	{
		loopDepth = a_body1cont25(loopDepth);

		return loopDepth;
	}
	int a_body1cont29(Void const& _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1cont29(Void && _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1when10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont29(_, loopDepth);

		return loopDepth;
	}
	int a_body1when10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont29(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont31(int loopDepth) 
	{
		loopDepth = a_body1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1cont32(Void const& _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont31(loopDepth);

		return loopDepth;
	}
	int a_body1cont32(Void && _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->set(self->keyForIndex(i), "foo"_sr);
															#line 1859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont31(loopDepth);

		return loopDepth;
	}
	int a_body1when11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont32(_, loopDepth);

		return loopDepth;
	}
	int a_body1when11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont32(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1when11(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont34(int loopDepth) 
	{
		loopDepth = a_body1cont31(loopDepth);

		return loopDepth;
	}
	int a_body1cont35(Void const& _,int loopDepth) 
	{
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(self->keyForIndex(i));
															#line 1952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont34(loopDepth);

		return loopDepth;
	}
	int a_body1cont35(Void && _,int loopDepth) 
	{
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i++) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(self->keyForIndex(i));
															#line 1964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont34(loopDepth);

		return loopDepth;
	}
	int a_body1when12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont35(_, loopDepth);

		return loopDepth;
	}
	int a_body1when12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont35(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when12(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont37(int loopDepth) 
	{
		loopDepth = a_body1cont34(loopDepth);

		return loopDepth;
	}
	int a_body1cont38(Void const& _,int loopDepth) 
	{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 1)));
															#line 2057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont37(loopDepth);

		return loopDepth;
	}
	int a_body1cont38(Void && _,int loopDepth) 
	{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		for(i = 0;i < self->nodes;i += 2) {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			tr->clear(KeyRangeRef(self->keyForIndex(i), self->keyForIndex(i + 1)));
															#line 2069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		loopDepth = a_body1cont37(loopDepth);

		return loopDepth;
	}
	int a_body1when13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont38(_, loopDepth);

		return loopDepth;
	}
	int a_body1when13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont38(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<FillCacheActor*>(this)->actor_wait_state > 0) static_cast<FillCacheActor*>(this)->actor_wait_state = 0;
		static_cast<FillCacheActor*>(this)->ActorCallback< FillCacheActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when13(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< FillCacheActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< FillCacheActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	RYWPerformanceWorkload* self;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int type;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int i;
															#line 2158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
};
// This generated class is to be used only via fillCache()
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class FillCacheActor final : public Actor<Void>, public ActorCallback< FillCacheActor, 0, Void >, public ActorCallback< FillCacheActor, 1, Void >, public ActorCallback< FillCacheActor, 2, Void >, public ActorCallback< FillCacheActor, 3, Void >, public ActorCallback< FillCacheActor, 4, Void >, public ActorCallback< FillCacheActor, 5, Void >, public ActorCallback< FillCacheActor, 6, Void >, public ActorCallback< FillCacheActor, 7, Void >, public ActorCallback< FillCacheActor, 8, Void >, public ActorCallback< FillCacheActor, 9, Void >, public ActorCallback< FillCacheActor, 10, Void >, public ActorCallback< FillCacheActor, 11, Void >, public ActorCallback< FillCacheActor, 12, Void >, public FastAllocated<FillCacheActor>, public FillCacheActorState<FillCacheActor> {
															#line 2163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
	using FastAllocated<FillCacheActor>::operator new;
	using FastAllocated<FillCacheActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5781458919806010112UL, 14345475195282030336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FillCacheActor, 0, Void >;
friend struct ActorCallback< FillCacheActor, 1, Void >;
friend struct ActorCallback< FillCacheActor, 2, Void >;
friend struct ActorCallback< FillCacheActor, 3, Void >;
friend struct ActorCallback< FillCacheActor, 4, Void >;
friend struct ActorCallback< FillCacheActor, 5, Void >;
friend struct ActorCallback< FillCacheActor, 6, Void >;
friend struct ActorCallback< FillCacheActor, 7, Void >;
friend struct ActorCallback< FillCacheActor, 8, Void >;
friend struct ActorCallback< FillCacheActor, 9, Void >;
friend struct ActorCallback< FillCacheActor, 10, Void >;
friend struct ActorCallback< FillCacheActor, 11, Void >;
friend struct ActorCallback< FillCacheActor, 12, Void >;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	FillCacheActor(ReadYourWritesTransaction* const& tr,RYWPerformanceWorkload* const& self,int const& type) 
															#line 2192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		 : Actor<Void>(),
		   FillCacheActorState<FillCacheActor>(tr, self, type),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fillCache", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9076002559844316416UL, 86816329907892480UL);
		ActorExecutionContextHelper __helper(static_cast<FillCacheActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fillCache");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fillCache", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FillCacheActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FillCacheActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FillCacheActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FillCacheActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FillCacheActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FillCacheActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< FillCacheActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< FillCacheActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< FillCacheActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< FillCacheActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< FillCacheActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< FillCacheActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< FillCacheActor, 12, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
[[nodiscard]] static Future<Void> fillCache( ReadYourWritesTransaction* const& tr, RYWPerformanceWorkload* const& self, int const& type ) {
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	return Future<Void>(new FillCacheActor(tr, self, type));
															#line 2236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
}

#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"

																#line 2241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
// This generated class is to be used only via test_get_single()
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
template <class Test_get_singleActor>
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_get_singleActorState {
															#line 2247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_get_singleActorState(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		 : cx(cx),
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   self(self),
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   cacheType(cacheType),
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   i(),
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   tr(cx)
															#line 2262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
	{
		fdb_probe_actor_create("test_get_single", reinterpret_cast<unsigned long>(this));

	}
	~Test_get_singleActorState() 
	{
		fdb_probe_actor_destroy("test_get_single", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			;
															#line 2277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Test_get_singleActorState();
		static_cast<Test_get_singleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->fillCache(&tr, self, cacheType);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_get_singleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Test_get_singleActor*>(this)->actor_wait_state = 1;
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Test_get_singleActor, 0, Void >*>(static_cast<Test_get_singleActor*>(this)));
															#line 2315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_get_singleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<Test_get_singleActor*>(this)->actor_wait_state = 3;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Test_get_singleActor, 2, Void >*>(static_cast<Test_get_singleActor*>(this)));
															#line 2344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 2361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 2372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Test_get_singleActor*>(this)->actor_wait_state > 0) static_cast<Test_get_singleActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_singleActor*>(this)->ActorCallback< Test_get_singleActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_singleActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Test_get_singleActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Test_get_singleActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		fprintf(stderr, "%f", self->nodes / (timer() - startTime));
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!static_cast<Test_get_singleActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Test_get_singleActorState(); static_cast<Test_get_singleActor*>(this)->destroy(); return 0; }
															#line 2458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		new (&static_cast<Test_get_singleActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Test_get_singleActorState();
		static_cast<Test_get_singleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < self->nodes))
															#line 2477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(tr.get(self->keyForIndex(self->nodes / 2)));
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<Test_get_singleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Test_get_singleActor*>(this)->actor_wait_state = 2;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Test_get_singleActor, 1, Void >*>(static_cast<Test_get_singleActor*>(this)));
															#line 2490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 2512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 2521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Test_get_singleActor*>(this)->actor_wait_state > 0) static_cast<Test_get_singleActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_singleActor*>(this)->ActorCallback< Test_get_singleActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_singleActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Test_get_singleActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Test_get_singleActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Test_get_singleActor*>(this)->actor_wait_state > 0) static_cast<Test_get_singleActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_singleActor*>(this)->ActorCallback< Test_get_singleActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_singleActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Test_get_singleActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Test_get_singleActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Database cx;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	RYWPerformanceWorkload* self;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int cacheType;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int i;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	double startTime;
															#line 2700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
};
// This generated class is to be used only via test_get_single()
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_get_singleActor final : public Actor<Void>, public ActorCallback< Test_get_singleActor, 0, Void >, public ActorCallback< Test_get_singleActor, 1, Void >, public ActorCallback< Test_get_singleActor, 2, Void >, public FastAllocated<Test_get_singleActor>, public Test_get_singleActorState<Test_get_singleActor> {
															#line 2705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
	using FastAllocated<Test_get_singleActor>::operator new;
	using FastAllocated<Test_get_singleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3392724492357022720UL, 3805231681799330816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Test_get_singleActor, 0, Void >;
friend struct ActorCallback< Test_get_singleActor, 1, Void >;
friend struct ActorCallback< Test_get_singleActor, 2, Void >;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_get_singleActor(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 2724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		 : Actor<Void>(),
		   Test_get_singleActorState<Test_get_singleActor>(cx, self, cacheType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("test_get_single", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11530155540925004288UL, 10526465652462960896UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_singleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("test_get_single");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("test_get_single", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Test_get_singleActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Test_get_singleActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Test_get_singleActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
[[nodiscard]] static Future<Void> test_get_single( Database const& cx, RYWPerformanceWorkload* const& self, int const& cacheType ) {
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	return Future<Void>(new Test_get_singleActor(cx, self, cacheType));
															#line 2758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
}

#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"

																#line 2763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
// This generated class is to be used only via test_get_many_sequential()
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
template <class Test_get_many_sequentialActor>
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_get_many_sequentialActorState {
															#line 2769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_get_many_sequentialActorState(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		 : cx(cx),
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   self(self),
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   cacheType(cacheType),
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   i(),
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   tr(cx)
															#line 2784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
	{
		fdb_probe_actor_create("test_get_many_sequential", reinterpret_cast<unsigned long>(this));

	}
	~Test_get_many_sequentialActorState() 
	{
		fdb_probe_actor_destroy("test_get_many_sequential", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			;
															#line 2799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Test_get_many_sequentialActorState();
		static_cast<Test_get_many_sequentialActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->fillCache(&tr, self, cacheType);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state = 1;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Test_get_many_sequentialActor, 0, Void >*>(static_cast<Test_get_many_sequentialActor*>(this)));
															#line 2837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state = 3;
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Test_get_many_sequentialActor, 2, Void >*>(static_cast<Test_get_many_sequentialActor*>(this)));
															#line 2866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 2883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 2894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state > 0) static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_many_sequentialActor*>(this)->ActorCallback< Test_get_many_sequentialActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_many_sequentialActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Test_get_many_sequentialActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Test_get_many_sequentialActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		fprintf(stderr, "%f", self->nodes / (timer() - startTime));
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!static_cast<Test_get_many_sequentialActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Test_get_many_sequentialActorState(); static_cast<Test_get_many_sequentialActor*>(this)->destroy(); return 0; }
															#line 2980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		new (&static_cast<Test_get_many_sequentialActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Test_get_many_sequentialActorState();
		static_cast<Test_get_many_sequentialActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < self->nodes))
															#line 2999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(tr.get(self->keyForIndex(i)));
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state = 2;
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Test_get_many_sequentialActor, 1, Void >*>(static_cast<Test_get_many_sequentialActor*>(this)));
															#line 3012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 3034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 3043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state > 0) static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_many_sequentialActor*>(this)->ActorCallback< Test_get_many_sequentialActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_many_sequentialActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Test_get_many_sequentialActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Test_get_many_sequentialActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state > 0) static_cast<Test_get_many_sequentialActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_many_sequentialActor*>(this)->ActorCallback< Test_get_many_sequentialActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_many_sequentialActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Test_get_many_sequentialActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Test_get_many_sequentialActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Database cx;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	RYWPerformanceWorkload* self;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int cacheType;
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int i;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	double startTime;
															#line 3222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
};
// This generated class is to be used only via test_get_many_sequential()
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_get_many_sequentialActor final : public Actor<Void>, public ActorCallback< Test_get_many_sequentialActor, 0, Void >, public ActorCallback< Test_get_many_sequentialActor, 1, Void >, public ActorCallback< Test_get_many_sequentialActor, 2, Void >, public FastAllocated<Test_get_many_sequentialActor>, public Test_get_many_sequentialActorState<Test_get_many_sequentialActor> {
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
	using FastAllocated<Test_get_many_sequentialActor>::operator new;
	using FastAllocated<Test_get_many_sequentialActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2067912582839625472UL, 5854818239920604160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Test_get_many_sequentialActor, 0, Void >;
friend struct ActorCallback< Test_get_many_sequentialActor, 1, Void >;
friend struct ActorCallback< Test_get_many_sequentialActor, 2, Void >;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_get_many_sequentialActor(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 3246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		 : Actor<Void>(),
		   Test_get_many_sequentialActorState<Test_get_many_sequentialActor>(cx, self, cacheType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("test_get_many_sequential", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6933712365431613696UL, 5543536083909330688UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_many_sequentialActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("test_get_many_sequential");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("test_get_many_sequential", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Test_get_many_sequentialActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Test_get_many_sequentialActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Test_get_many_sequentialActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
[[nodiscard]] static Future<Void> test_get_many_sequential( Database const& cx, RYWPerformanceWorkload* const& self, int const& cacheType ) {
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	return Future<Void>(new Test_get_many_sequentialActor(cx, self, cacheType));
															#line 3280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
}

#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"

																#line 3285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
// This generated class is to be used only via test_get_range_basic()
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
template <class Test_get_range_basicActor>
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_get_range_basicActorState {
															#line 3291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_get_range_basicActorState(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		 : cx(cx),
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   self(self),
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   cacheType(cacheType),
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   i(),
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   tr(cx)
															#line 3306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
	{
		fdb_probe_actor_create("test_get_range_basic", reinterpret_cast<unsigned long>(this));

	}
	~Test_get_range_basicActorState() 
	{
		fdb_probe_actor_destroy("test_get_range_basic", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			;
															#line 3321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Test_get_range_basicActorState();
		static_cast<Test_get_range_basicActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->fillCache(&tr, self, cacheType);
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_get_range_basicActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Test_get_range_basicActor*>(this)->actor_wait_state = 1;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Test_get_range_basicActor, 0, Void >*>(static_cast<Test_get_range_basicActor*>(this)));
															#line 3359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_get_range_basicActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<Test_get_range_basicActor*>(this)->actor_wait_state = 3;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Test_get_range_basicActor, 2, Void >*>(static_cast<Test_get_range_basicActor*>(this)));
															#line 3388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 3405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 3416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Test_get_range_basicActor*>(this)->actor_wait_state > 0) static_cast<Test_get_range_basicActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_range_basicActor*>(this)->ActorCallback< Test_get_range_basicActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_range_basicActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Test_get_range_basicActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Test_get_range_basicActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		fprintf(stderr, "%f", self->ranges / (timer() - startTime));
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!static_cast<Test_get_range_basicActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Test_get_range_basicActorState(); static_cast<Test_get_range_basicActor*>(this)->destroy(); return 0; }
															#line 3502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		new (&static_cast<Test_get_range_basicActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Test_get_range_basicActorState();
		static_cast<Test_get_range_basicActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < self->ranges))
															#line 3521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success( tr.getRange(KeyRangeRef(self->keyForIndex(0), self->keyForIndex(self->nodes)), self->nodes));
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<Test_get_range_basicActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Test_get_range_basicActor*>(this)->actor_wait_state = 2;
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Test_get_range_basicActor, 1, Void >*>(static_cast<Test_get_range_basicActor*>(this)));
															#line 3534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 3556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 3565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Test_get_range_basicActor*>(this)->actor_wait_state > 0) static_cast<Test_get_range_basicActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_range_basicActor*>(this)->ActorCallback< Test_get_range_basicActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_range_basicActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Test_get_range_basicActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Test_get_range_basicActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Test_get_range_basicActor*>(this)->actor_wait_state > 0) static_cast<Test_get_range_basicActor*>(this)->actor_wait_state = 0;
		static_cast<Test_get_range_basicActor*>(this)->ActorCallback< Test_get_range_basicActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_get_range_basicActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Test_get_range_basicActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Test_get_range_basicActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Database cx;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	RYWPerformanceWorkload* self;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int cacheType;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int i;
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	double startTime;
															#line 3744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
};
// This generated class is to be used only via test_get_range_basic()
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_get_range_basicActor final : public Actor<Void>, public ActorCallback< Test_get_range_basicActor, 0, Void >, public ActorCallback< Test_get_range_basicActor, 1, Void >, public ActorCallback< Test_get_range_basicActor, 2, Void >, public FastAllocated<Test_get_range_basicActor>, public Test_get_range_basicActorState<Test_get_range_basicActor> {
															#line 3749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
	using FastAllocated<Test_get_range_basicActor>::operator new;
	using FastAllocated<Test_get_range_basicActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8609888685128033024UL, 1037856448867348992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Test_get_range_basicActor, 0, Void >;
friend struct ActorCallback< Test_get_range_basicActor, 1, Void >;
friend struct ActorCallback< Test_get_range_basicActor, 2, Void >;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_get_range_basicActor(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 3768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		 : Actor<Void>(),
		   Test_get_range_basicActorState<Test_get_range_basicActor>(cx, self, cacheType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("test_get_range_basic", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17082026464982854912UL, 6497914522070913536UL);
		ActorExecutionContextHelper __helper(static_cast<Test_get_range_basicActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("test_get_range_basic");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("test_get_range_basic", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Test_get_range_basicActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Test_get_range_basicActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Test_get_range_basicActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
[[nodiscard]] static Future<Void> test_get_range_basic( Database const& cx, RYWPerformanceWorkload* const& self, int const& cacheType ) {
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	return Future<Void>(new Test_get_range_basicActor(cx, self, cacheType));
															#line 3802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
}

#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"

																#line 3807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
// This generated class is to be used only via test_interleaved_sets_gets()
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
template <class Test_interleaved_sets_getsActor>
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_interleaved_sets_getsActorState {
															#line 3813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_interleaved_sets_getsActorState(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		 : cx(cx),
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   self(self),
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   cacheType(cacheType),
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   i(),
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   tr(cx)
															#line 3828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
	{
		fdb_probe_actor_create("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this));

	}
	~Test_interleaved_sets_getsActorState() 
	{
		fdb_probe_actor_destroy("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			;
															#line 3843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Test_interleaved_sets_getsActorState();
		static_cast<Test_interleaved_sets_getsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->fillCache(&tr, self, cacheType);
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state = 1;
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Test_interleaved_sets_getsActor, 0, Void >*>(static_cast<Test_interleaved_sets_getsActor*>(this)));
															#line 3881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			if (static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state = 3;
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< Test_interleaved_sets_getsActor, 2, Void >*>(static_cast<Test_interleaved_sets_getsActor*>(this)));
															#line 3910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		tr.set(self->keyForIndex(self->nodes / 2), self->keyForIndex(self->nodes));
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 3929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		tr.set(self->keyForIndex(self->nodes / 2), self->keyForIndex(self->nodes));
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		startTime = timer();
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 3942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state > 0) static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state = 0;
		static_cast<Test_interleaved_sets_getsActor*>(this)->ActorCallback< Test_interleaved_sets_getsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_interleaved_sets_getsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Test_interleaved_sets_getsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Test_interleaved_sets_getsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		fprintf(stderr, "%f", self->nodes / (timer() - startTime));
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!static_cast<Test_interleaved_sets_getsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Test_interleaved_sets_getsActorState(); static_cast<Test_interleaved_sets_getsActor*>(this)->destroy(); return 0; }
															#line 4028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		new (&static_cast<Test_interleaved_sets_getsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Test_interleaved_sets_getsActorState();
		static_cast<Test_interleaved_sets_getsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < self->nodes))
															#line 4047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(tr.get(self->keyForIndex(self->nodes / 2)));
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state = 2;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Test_interleaved_sets_getsActor, 1, Void >*>(static_cast<Test_interleaved_sets_getsActor*>(this)));
															#line 4060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		tr.set(self->keyForIndex(self->nodes / 2), self->keyForIndex(i));
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		tr.set(self->keyForIndex(self->nodes / 2), self->keyForIndex(i));
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state > 0) static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state = 0;
		static_cast<Test_interleaved_sets_getsActor*>(this)->ActorCallback< Test_interleaved_sets_getsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_interleaved_sets_getsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Test_interleaved_sets_getsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Test_interleaved_sets_getsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state > 0) static_cast<Test_interleaved_sets_getsActor*>(this)->actor_wait_state = 0;
		static_cast<Test_interleaved_sets_getsActor*>(this)->ActorCallback< Test_interleaved_sets_getsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Test_interleaved_sets_getsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< Test_interleaved_sets_getsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< Test_interleaved_sets_getsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Database cx;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	RYWPerformanceWorkload* self;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int cacheType;
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int i;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	double startTime;
															#line 4274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
};
// This generated class is to be used only via test_interleaved_sets_gets()
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class Test_interleaved_sets_getsActor final : public Actor<Void>, public ActorCallback< Test_interleaved_sets_getsActor, 0, Void >, public ActorCallback< Test_interleaved_sets_getsActor, 1, Void >, public ActorCallback< Test_interleaved_sets_getsActor, 2, Void >, public FastAllocated<Test_interleaved_sets_getsActor>, public Test_interleaved_sets_getsActorState<Test_interleaved_sets_getsActor> {
															#line 4279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
	using FastAllocated<Test_interleaved_sets_getsActor>::operator new;
	using FastAllocated<Test_interleaved_sets_getsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14820146270364332288UL, 10002489566321715712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Test_interleaved_sets_getsActor, 0, Void >;
friend struct ActorCallback< Test_interleaved_sets_getsActor, 1, Void >;
friend struct ActorCallback< Test_interleaved_sets_getsActor, 2, Void >;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Test_interleaved_sets_getsActor(Database const& cx,RYWPerformanceWorkload* const& self,int const& cacheType) 
															#line 4298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		 : Actor<Void>(),
		   Test_interleaved_sets_getsActorState<Test_interleaved_sets_getsActor>(cx, self, cacheType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8095079468918818048UL, 10823165441921608448UL);
		ActorExecutionContextHelper __helper(static_cast<Test_interleaved_sets_getsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("test_interleaved_sets_gets");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("test_interleaved_sets_gets", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Test_interleaved_sets_getsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Test_interleaved_sets_getsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< Test_interleaved_sets_getsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
[[nodiscard]] static Future<Void> test_interleaved_sets_gets( Database const& cx, RYWPerformanceWorkload* const& self, int const& cacheType ) {
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	return Future<Void>(new Test_interleaved_sets_getsActor(cx, self, cacheType));
															#line 4332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
}

#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"

																#line 4337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
template <class _startActor>
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class _startActorState {
															#line 4343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	_startActorState(Database const& cx,RYWPerformanceWorkload* const& self) 
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		 : cx(cx),
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   self(self),
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		   i()
															#line 4354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "test_get_single, ");
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			i = 0;
															#line 4371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		fprintf(stderr, "test_get_many_sequential, ");
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 4396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < 14))
															#line 4412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->test_get_single(cx, self, i);
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 4425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 4457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 4480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		fprintf(stderr, "test_get_range_basic, ");
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 4;
															#line 4570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < 14))
															#line 4586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->test_get_many_sequential(cx, self, i);
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 4599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 4631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 4654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		fprintf(stderr, "test_interleaved_sets_gets, ");
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i = 0;
															#line 4744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < 14))
															#line 4760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->test_get_range_basic(cx, self, i);
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 4773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 4805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 4828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 4916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (!(i < 14))
															#line 4935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->test_interleaved_sets_gets(cx, self, i);
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 4980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 4984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		if (i == 13)
															#line 4993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, "\n");
															#line 4997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
		else
		{
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
			fprintf(stderr, ", ");
															#line 5003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		}
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
		i++;
															#line 5007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	Database cx;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	RYWPerformanceWorkload* self;
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	int i;
															#line 5093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 5098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12696369044545792512UL, 7425842562087716864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	_startActor(Database const& cx,RYWPerformanceWorkload* const& self) 
															#line 5118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, RYWPerformanceWorkload* const& self ) {
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 5153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/RYWPerformance.actor.g.cpp"
}

#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/RYWPerformance.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Key keyForIndex(uint64_t index) {
		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		double d = double(index) / nodes;
		emplaceIndex(data, 0, *(int64_t*)&d);

		return result;
	}
};

WorkloadFactory<RYWPerformanceWorkload> RYWPerformanceWorkloadFactory;
