#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
/*
 * PhysicalShardMove.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/ServerCheckpoint.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/flow.h"
#include <cstdint>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {
std::string printValue(const ErrorOr<Optional<Value>>& value) {
	if (value.isError()) {
		return value.getError().name();
	}
	return value.get().present() ? value.get().get().toString() : "Value Not Found.";
}
} // namespace

struct PhysicalShardMoveWorkLoad : TestWorkload {
	static constexpr auto NAME = "PhysicalShardMove";

	FlowLock startMoveKeysParallelismLock;
	FlowLock finishMoveKeysParallelismLock;
	FlowLock cleanUpDataMoveParallelismLock;
	const bool enabled;
	bool pass;

	PhysicalShardMoveWorkLoad(WorkloadContext const& wcx) : TestWorkload(wcx), enabled(!clientId), pass(true) {}

	void validationFailed(ErrorOr<Optional<Value>> expectedValue, ErrorOr<Optional<Value>> actualValue) {
		TraceEvent(SevError, "TestFailed")
		    .detail("ExpectedValue", printValue(expectedValue))
		    .detail("ActualValue", printValue(actualValue));
		pass = false;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (!enabled) {
			return Void();
		}
		return _start(this, cx);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert("RandomMoveKeys");
		out.insert("Attrition");
	}

																#line 81 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class _startActor>
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class _startActorState {
															#line 87 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	_startActorState(PhysicalShardMoveWorkLoad* const& self,Database const& cx) 
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : self(self),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   cx(cx)
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(setDDMode(cx, 0));
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamA = std::vector<UID>();
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		kvs = std::map<Key, Value>({ { "TestKeyA"_sr, "TestValueA"_sr }, { "TestKeyAB"_sr, "TestValueAB"_sr }, { "TestKeyAD"_sr, "TestValueAD"_sr }, { "TestKeyB"_sr, "TestValueB"_sr }, { "TestKeyBA"_sr, "TestValueBA"_sr }, { "TestKeyC"_sr, "TestValueC"_sr }, { "TestKeyD"_sr, "TestValueD"_sr }, { "TestKeyE"_sr, "TestValueE"_sr }, { "TestKeyF"_sr, "TestValueF"_sr } });
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(self->populateData(self, cx, &kvs));
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamA = std::vector<UID>();
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		kvs = std::map<Key, Value>({ { "TestKeyA"_sr, "TestValueA"_sr }, { "TestKeyAB"_sr, "TestValueAB"_sr }, { "TestKeyAD"_sr, "TestValueAD"_sr }, { "TestKeyB"_sr, "TestValueB"_sr }, { "TestKeyBA"_sr, "TestValueBA"_sr }, { "TestKeyC"_sr, "TestValueC"_sr }, { "TestKeyD"_sr, "TestValueD"_sr }, { "TestKeyE"_sr, "TestValueE"_sr }, { "TestKeyF"_sr, "TestValueF"_sr } });
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(self->populateData(self, cx, &kvs));
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestValueWritten").log();
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		excludes = std::unordered_set<UID>();
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		includes = std::unordered_set<UID>();
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamSize = 1;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		dataMoveReason = static_cast<DataMovementReason>( deterministicRandom()->randomInt(1, static_cast<int>(DataMovementReason::NUMBER_OF_REASONS)));
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyA"_sr, "TestKeyF"_sr);
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(teamA, self->moveShard(self, cx, newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes));
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestValueWritten").log();
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		excludes = std::unordered_set<UID>();
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		includes = std::unordered_set<UID>();
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamSize = 1;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		dataMoveReason = static_cast<DataMovementReason>( deterministicRandom()->randomInt(1, static_cast<int>(DataMovementReason::NUMBER_OF_REASONS)));
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyA"_sr, "TestKeyF"_sr);
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_2 = store(teamA, self->moveShard(self, cx, newDataMoveId(deterministicRandom()->randomUInt64(), AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes));
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestMovedRange1").detail("Range", currentRange).detail("Team", describe(teamA));
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		excludes.insert(teamA.begin(), teamA.end());
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		sh0 = deterministicRandom()->randomUInt64();
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		sh1 = deterministicRandom()->randomUInt64();
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		sh2 = deterministicRandom()->randomUInt64();
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyA"_sr, "TestKeyB"_sr);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(teamA, self->moveShard(self, cx, newDataMoveId(sh0, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes));
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestMovedRange1").detail("Range", currentRange).detail("Team", describe(teamA));
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		excludes.insert(teamA.begin(), teamA.end());
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		sh0 = deterministicRandom()->randomUInt64();
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		sh1 = deterministicRandom()->randomUInt64();
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		sh2 = deterministicRandom()->randomUInt64();
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyA"_sr, "TestKeyB"_sr);
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(teamA, self->moveShard(self, cx, newDataMoveId(sh0, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes));
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestMovedRange2").detail("Range", currentRange).detail("Team", describe(teamA));
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges = std::vector<KeyRange>();
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.push_back(KeyRangeRef("TestKeyA"_sr, "TestKeyAC"_sr));
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkpointRestore(self, cx, checkpointRanges, checkpointRanges, CheckpointAsKeyValues::True, &kvs);
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestMovedRange2").detail("Range", currentRange).detail("Team", describe(teamA));
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges = std::vector<KeyRange>();
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.push_back(KeyRangeRef("TestKeyA"_sr, "TestKeyAC"_sr));
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->checkpointRestore(self, cx, checkpointRanges, checkpointRanges, CheckpointAsKeyValues::True, &kvs);
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointRestored1");
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		includes.insert(teamA.begin(), teamA.end());
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyD"_sr, "TestKeyF"_sr);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<UID>> __when_expr_5 = self->moveShard( self, cx, newDataMoveId(sh0, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, std::vector<UID> >*>(static_cast<_startActor*>(this)));
															#line 650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointRestored1");
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		includes.insert(teamA.begin(), teamA.end());
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyD"_sr, "TestKeyF"_sr);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<UID>> __when_expr_5 = self->moveShard( self, cx, newDataMoveId(sh0, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, std::vector<UID> >*>(static_cast<_startActor*>(this)));
															#line 672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestMovedRange3").detail("Range", currentRange).detail("Team", describe(teamE));
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(std::equal(teamA.begin(), teamA.end(), teamE.begin()));
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamIdx = 0;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamIdx = 0;
															#line 762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<UID> const& __teamE,int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamE = __teamE;
															#line 771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<UID> && __teamE,int loopDepth) 
	{
		teamE = std::move(__teamE);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, std::vector<UID> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, std::vector<UID> >*,std::vector<UID> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, std::vector<UID> >*,std::vector<UID> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, std::vector<UID> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.clear();
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.push_back(KeyRangeRef("TestKeyA"_sr, "TestKeyB"_sr));
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.push_back(KeyRangeRef("TestKeyD"_sr, "TestKeyE"_sr));
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_7 = self->checkpointRestore(self, cx, checkpointRanges, checkpointRanges, CheckpointAsKeyValues::True, &kvs);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!(teamIdx < teamA.size()))
															#line 879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestGettingServerShards", teamA[teamIdx]) .detail("Range", KeyRangeRef("TestKeyD"_sr, "TestKeyF"_sr));
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<StorageServerShard>> __when_expr_6 = self->getStorageServerShards(cx, teamA[teamIdx], KeyRangeRef("TestKeyD"_sr, "TestKeyF"_sr));
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, std::vector<StorageServerShard> >*>(static_cast<_startActor*>(this)));
															#line 894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::vector<StorageServerShard> const& shards,int loopDepth) 
	{
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards.size() == 1);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].desiredId == sh0);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].id == sh0);
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestStorageServerShards", teamA[teamIdx]).detail("Shards", describe(shards));
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++teamIdx;
															#line 924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::vector<StorageServerShard> && shards,int loopDepth) 
	{
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards.size() == 1);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].desiredId == sh0);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].id == sh0);
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestStorageServerShards", teamA[teamIdx]).detail("Shards", describe(shards));
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++teamIdx;
															#line 941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::vector<StorageServerShard> const& shards,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(shards, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::vector<StorageServerShard> && shards,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(shards), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, std::vector<StorageServerShard> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<StorageServerShard> >*,std::vector<StorageServerShard> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, std::vector<StorageServerShard> >*,std::vector<StorageServerShard> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, std::vector<StorageServerShard> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointRestored2");
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyB"_sr, "TestKeyC"_sr);
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		includes.insert(teamA.begin(), teamA.end());
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<UID>> __when_expr_8 = self->moveShard( self, cx, newDataMoveId(sh1, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, std::vector<UID> >*>(static_cast<_startActor*>(this)));
															#line 1038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointRestored2");
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyB"_sr, "TestKeyC"_sr);
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		includes.insert(teamA.begin(), teamA.end());
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<UID>> __when_expr_8 = self->moveShard( self, cx, newDataMoveId(sh1, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, std::vector<UID> >*>(static_cast<_startActor*>(this)));
															#line 1060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestMovedRange4").detail("Range", currentRange).detail("Team", describe(teamB));
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(std::equal(teamA.begin(), teamA.end(), teamB.begin()));
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamIdx = 0;
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamIdx = 0;
															#line 1150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont9loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(std::vector<UID> const& __teamB,int loopDepth) 
	{
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamB = __teamB;
															#line 1159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(std::vector<UID> && __teamB,int loopDepth) 
	{
		teamB = std::move(__teamB);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, std::vector<UID> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, std::vector<UID> >*,std::vector<UID> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, std::vector<UID> >*,std::vector<UID> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, std::vector<UID> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.clear();
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.push_back(KeyRangeRef("TestKeyA"_sr, "TestKeyB"_sr));
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointRanges.push_back(KeyRangeRef("TestKeyB"_sr, "TestKeyC"_sr));
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		std::vector<KeyRange> restoreRanges;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		restoreRanges.push_back(KeyRangeRef("TestKeyA"_sr, "TestKeyB"_sr));
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		restoreRanges.push_back(KeyRangeRef("TestKeyB"_sr, "TestKeyC"_sr));
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_10 = self->checkpointRestore(self, cx, checkpointRanges, restoreRanges, CheckpointAsKeyValues::True, &kvs);
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 1257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont9loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1(int loopDepth) 
	{
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!(teamIdx < teamA.size()))
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		{
			return a_body1cont9break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<StorageServerShard>> __when_expr_9 = self->getStorageServerShards(cx, teamA[teamIdx], KeyRangeRef("TestKeyA"_sr, "TestKeyC"_sr));
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont9loopBody1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<StorageServerShard> >*>(static_cast<_startActor*>(this)));
															#line 1286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont1(std::vector<StorageServerShard> const& shards,int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestStorageServerShards", teamA[teamIdx]).detail("Shards", describe(shards));
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards.size() == 2);
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].desiredId == sh0);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[1].desiredId == sh1);
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++teamIdx;
															#line 1316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont1(std::vector<StorageServerShard> && shards,int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestStorageServerShards", teamA[teamIdx]).detail("Shards", describe(shards));
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards.size() == 2);
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].desiredId == sh0);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[1].desiredId == sh1);
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++teamIdx;
															#line 1333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(std::vector<StorageServerShard> const& shards,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(shards, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(std::vector<StorageServerShard> && shards,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(std::move(shards), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, std::vector<StorageServerShard> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<StorageServerShard> >*,std::vector<StorageServerShard> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<StorageServerShard> >*,std::vector<StorageServerShard> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, std::vector<StorageServerShard> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointRestored3");
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyB"_sr, "TestKeyC"_sr);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<UID>> __when_expr_11 = self->moveShard( self, cx, newDataMoveId(sh2, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, std::vector<UID> >*>(static_cast<_startActor*>(this)));
															#line 1428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointRestored3");
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		currentRange = KeyRangeRef("TestKeyB"_sr, "TestKeyC"_sr);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<UID>> __when_expr_11 = self->moveShard( self, cx, newDataMoveId(sh2, AssignEmptyRange::False, deterministicRandom()->random01() < SERVER_KNOBS->DD_PHYSICAL_SHARD_MOVE_PROBABILITY ? DataMoveType::PHYSICAL : DataMoveType::LOGICAL, dataMoveReason), currentRange, teamSize, includes, excludes);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, std::vector<UID> >*>(static_cast<_startActor*>(this)));
															#line 1448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestMovedRange5").detail("Range", currentRange).detail("Team", describe(teamC));
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(std::equal(teamA.begin(), teamA.end(), teamC.begin()));
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamIdx = 0;
															#line 1536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont10cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(std::vector<UID> const& __teamC,int loopDepth) 
	{
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		teamC = __teamC;
															#line 1545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(std::vector<UID> && __teamC,int loopDepth) 
	{
		teamC = std::move(__teamC);
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, std::vector<UID> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::vector<UID> >*,std::vector<UID> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::vector<UID> >*,std::vector<UID> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, std::vector<UID> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<int> __when_expr_13 = setDDMode(cx, 1);
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_13.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, int >*>(static_cast<_startActor*>(this)));
															#line 1632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1(int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!(teamIdx < teamA.size()))
															#line 1649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		{
			return a_body1cont10cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<std::vector<StorageServerShard>> __when_expr_12 = self->getStorageServerShards(cx, teamA[teamIdx], KeyRangeRef("TestKeyA"_sr, "TestKeyC"_sr));
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont2loopBody1when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, std::vector<StorageServerShard> >*>(static_cast<_startActor*>(this)));
															#line 1662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1cont1(std::vector<StorageServerShard> const& shards,int loopDepth) 
	{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards.size() == 2);
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].desiredId == sh0);
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[1].id == sh1);
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[1].desiredId == sh2);
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestStorageServerShards", teamA[teamIdx]).detail("Shards", describe(shards));
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++teamIdx;
															#line 1694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1cont1(std::vector<StorageServerShard> && shards,int loopDepth) 
	{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards.size() == 2);
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[0].desiredId == sh0);
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[1].id == sh1);
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(shards[1].desiredId == sh2);
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestStorageServerShards", teamA[teamIdx]).detail("Shards", describe(shards));
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++teamIdx;
															#line 1713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1when1(std::vector<StorageServerShard> const& shards,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2loopBody1cont1(shards, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2loopBody1when1(std::vector<StorageServerShard> && shards,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2loopBody1cont1(std::move(shards), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, std::vector<StorageServerShard> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, std::vector<StorageServerShard> >*,std::vector<StorageServerShard> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, std::vector<StorageServerShard> >*,std::vector<StorageServerShard> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, std::vector<StorageServerShard> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont4(int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_14 = self->validateData(self, cx, KeyRangeRef("TestKeyA"_sr, "TestKeyF"_sr), &kvs);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, Void >*>(static_cast<_startActor*>(this)));
															#line 1804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont5(int const& _,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		(void)_;
															#line 1813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5(int && _,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		(void)_;
															#line 1822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont10cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(int const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(int && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, int >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, int >*,int const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, int >*,int && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, int >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestValueVerified").log();
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestValueVerified").log();
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PhysicalShardMoveWorkLoad* self;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<UID> teamA;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::map<Key, Value> kvs;
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::unordered_set<UID> excludes;
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::unordered_set<UID> includes;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	int teamSize;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	DataMovementReason dataMoveReason;
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	KeyRangeRef currentRange;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	uint64_t sh0;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	uint64_t sh1;
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	uint64_t sh2;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<KeyRange> checkpointRanges;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<UID> teamE;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	int teamIdx;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<UID> teamB;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<UID> teamC;
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, std::vector<UID> >, public ActorCallback< _startActor, 6, std::vector<StorageServerShard> >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, std::vector<UID> >, public ActorCallback< _startActor, 9, std::vector<StorageServerShard> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, std::vector<UID> >, public ActorCallback< _startActor, 12, std::vector<StorageServerShard> >, public ActorCallback< _startActor, 13, int >, public ActorCallback< _startActor, 14, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9893531539747189760UL, 12300770490949515776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, std::vector<UID> >;
friend struct ActorCallback< _startActor, 6, std::vector<StorageServerShard> >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, std::vector<UID> >;
friend struct ActorCallback< _startActor, 9, std::vector<StorageServerShard> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, std::vector<UID> >;
friend struct ActorCallback< _startActor, 12, std::vector<StorageServerShard> >;
friend struct ActorCallback< _startActor, 13, int >;
friend struct ActorCallback< _startActor, 14, Void >;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	_startActor(PhysicalShardMoveWorkLoad* const& self,Database const& cx) 
															#line 2075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, std::vector<UID> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, std::vector<StorageServerShard> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, std::vector<UID> >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, std::vector<StorageServerShard> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, std::vector<UID> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, std::vector<StorageServerShard> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, int >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<Void> _start( PhysicalShardMoveWorkLoad* const& self, Database const& cx ) {
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 2121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

																#line 2126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via deleteCheckpoints()
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class DeleteCheckpointsActor>
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class DeleteCheckpointsActorState {
															#line 2132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	DeleteCheckpointsActorState(Database const& cx,std::vector<UID> const& checkpointIds) 
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : cx(cx),
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   checkpointIds(checkpointIds)
															#line 2141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteCheckpoints", reinterpret_cast<unsigned long>(this));

	}
	~DeleteCheckpointsActorState() 
	{
		fdb_probe_actor_destroy("deleteCheckpoints", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoints").detail("Checkpoints", describe(checkpointIds));
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr = Transaction(cx);
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			;
															#line 2160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<DeleteCheckpointsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteCheckpointsActorState(); static_cast<DeleteCheckpointsActor*>(this)->destroy(); return 0; }
															#line 2183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<DeleteCheckpointsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteCheckpointsActorState();
		static_cast<DeleteCheckpointsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			std::vector<Future<Optional<Value>>> checkpointEntries;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			for( const UID& id : checkpointIds ) {
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				checkpointEntries.push_back(tr.get(checkpointKeyFor(id)));
															#line 2207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_0 = getAll(checkpointEntries);
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 1;
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*>(static_cast<DeleteCheckpointsActor*>(this)));
															#line 2218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 3;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointsActor, 2, Void >*>(static_cast<DeleteCheckpointsActor*>(this)));
															#line 2260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<Optional<Value>> const& checkpointValues,int loopDepth) 
	{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for(int i = 0;i < checkpointIds.size();++i) {
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			const auto& value = checkpointValues[i];
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (!value.present())
															#line 2279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				TraceEvent(SevWarnAlways, "CheckpointNotFound");
															#line 2283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
				continue;
			}
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			CheckpointMetaData checkpoint = decodeCheckpointValue(value.get());
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			const Key key = checkpointKeyFor(checkpoint.checkpointID);
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Deleting);
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.set(key, checkpointValue(checkpoint));
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.clear(singleKeyRange(key));
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoint").detail("Checkpoint", checkpoint.toString());
															#line 2298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 2;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointsActor, 1, Void >*>(static_cast<DeleteCheckpointsActor*>(this)));
															#line 2309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<Optional<Value>> && checkpointValues,int loopDepth) 
	{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for(int i = 0;i < checkpointIds.size();++i) {
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			const auto& value = checkpointValues[i];
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (!value.present())
															#line 2322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				TraceEvent(SevWarnAlways, "CheckpointNotFound");
															#line 2326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
				continue;
			}
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			CheckpointMetaData checkpoint = decodeCheckpointValue(value.get());
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			const Key key = checkpointKeyFor(checkpoint.checkpointID);
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			checkpoint.setState(CheckpointMetaData::Deleting);
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.set(key, checkpointValue(checkpoint));
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.clear(singleKeyRange(key));
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent(SevDebug, "DataMoveDeleteCheckpoint").detail("Checkpoint", checkpoint.toString());
															#line 2341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 2;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteCheckpointsActor, 1, Void >*>(static_cast<DeleteCheckpointsActor*>(this)));
															#line 2352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<Optional<Value>> const& checkpointValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(checkpointValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<Optional<Value>> && checkpointValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(checkpointValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointsActor*>(this)->ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointsActor*>(this)->ActorCallback< DeleteCheckpointsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state > 0) static_cast<DeleteCheckpointsActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteCheckpointsActor*>(this)->ActorCallback< DeleteCheckpointsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteCheckpointsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteCheckpointsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<UID> checkpointIds;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Transaction tr;
															#line 2612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via deleteCheckpoints()
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class DeleteCheckpointsActor final : public Actor<Void>, public ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >, public ActorCallback< DeleteCheckpointsActor, 1, Void >, public ActorCallback< DeleteCheckpointsActor, 2, Void >, public FastAllocated<DeleteCheckpointsActor>, public DeleteCheckpointsActorState<DeleteCheckpointsActor> {
															#line 2617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<DeleteCheckpointsActor>::operator new;
	using FastAllocated<DeleteCheckpointsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9100373159218490368UL, 14429592567016139520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >;
friend struct ActorCallback< DeleteCheckpointsActor, 1, Void >;
friend struct ActorCallback< DeleteCheckpointsActor, 2, Void >;
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	DeleteCheckpointsActor(Database const& cx,std::vector<UID> const& checkpointIds) 
															#line 2636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteCheckpointsActorState<DeleteCheckpointsActor>(cx, checkpointIds),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteCheckpoints", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3647092636759606016UL, 17911147285598091008UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteCheckpointsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteCheckpoints");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteCheckpoints", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteCheckpointsActor, 0, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteCheckpointsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteCheckpointsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<Void> deleteCheckpoints( Database const& cx, std::vector<UID> const& checkpointIds ) {
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<Void>(new DeleteCheckpointsActor(cx, checkpointIds));
															#line 2670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

																#line 2675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via checkpointRestore()
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class CheckpointRestoreActor>
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class CheckpointRestoreActorState {
															#line 2681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	CheckpointRestoreActorState(PhysicalShardMoveWorkLoad* const& self,Database const& cx,std::vector<KeyRange> const& checkpointRanges,std::vector<KeyRange> const& restoreRanges,CheckpointAsKeyValues const& asKeyValues,std::map<Key, Value>* const& kvs) 
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : self(self),
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   cx(cx),
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   checkpointRanges(checkpointRanges),
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   restoreRanges(restoreRanges),
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   asKeyValues(asKeyValues),
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   kvs(kvs)
															#line 2698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("checkpointRestore", reinterpret_cast<unsigned long>(this));

	}
	~CheckpointRestoreActorState() 
	{
		fdb_probe_actor_destroy("checkpointRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent(SevDebug, "TestCreatingCheckpoint").detail("Ranges", describe(checkpointRanges));
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr = Transaction(cx);
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			format = DataMoveRocksCF;
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			dataMoveId = deterministicRandom()->randomUniqueID();
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("CheckpointRestore").detail("DMID1", dataMoveId.first()).detail("DMID2", dataMoveId.second());
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			version = Version();
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			;
															#line 2725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckpointRestoreActorState();
		static_cast<CheckpointRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		records = std::vector<std::pair<KeyRange, CheckpointMetaData>>();
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		;
															#line 2750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_0 = createCheckpoint(&tr, checkpointRanges, format, dataMoveId);
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 1;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 0, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 2778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 3;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 2, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 2820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 2;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 1, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 2842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 2;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 1, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 2858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		version = tr.getCommittedVersion();
															#line 2942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		version = tr.getCommittedVersion();
															#line 2951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointDir = abspath("fetchedCheckpoints" + deterministicRandom()->randomAlphaNumeric(6));
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		platform::eraseDirectoryRecursive(checkpointDir);
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(platform::createDirectory(checkpointDir));
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointFutures = std::vector<Future<CheckpointMetaData>>();
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		fetchedCheckpoints = std::vector<CheckpointMetaData>();
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		;
															#line 3132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		records.clear();
															#line 3148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		try {
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_3 = store(records, getCheckpointMetaData(cx, restoreRanges, version, format, Optional<UID>(dataMoveId)));
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 4;
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 3, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestFetchCheckpointMetadataError") .errorUnsuppressed(e) .detail("Range", describe(checkpointRanges)) .detail("Version", version);
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			ASSERT(e.code() != error_code_checkpoint_not_found);
															#line 3196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointMetaDataFetched") .detail("Range", describe(checkpointRanges)) .detail("Version", version);
															#line 3211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointMetaDataFetched") .detail("Range", describe(checkpointRanges)) .detail("Version", version);
															#line 3220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		std::vector<UID> checkpointIds;
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for( const auto& it : records ) {
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			checkpointIds.push_back(it.second.checkpointID);
															#line 3308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->deleteCheckpoints(cx, checkpointIds);
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 6;
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 5, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		checkpointFutures.clear();
															#line 3335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		try {
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (asKeyValues)
															#line 3339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				for(int i = 0;i < records.size();++i) {
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
					TraceEvent(SevDebug, "TestFetchingCheckpoint") .detail("Checkpoint", records[i].second.toString());
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
					const std::string currentDir = fetchedCheckpointDir(checkpointDir, records[i].second.checkpointID);
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
					platform::eraseDirectoryRecursive(currentDir);
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
					ASSERT(platform::createDirectory(currentDir));
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
					checkpointFutures.push_back( fetchCheckpointRanges(cx, records[i].second, currentDir, { records[i].first }));
															#line 3353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
				}
			}
			else
			{
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				for(int i = 1;i < records.size();++i) {
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
					ASSERT(records[i].second.checkpointID == records[i - 1].second.checkpointID);
															#line 3362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
				}
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				const std::string currentDir = fetchedCheckpointDir(checkpointDir, records.front().second.checkpointID);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				platform::eraseDirectoryRecursive(currentDir);
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				ASSERT(platform::createDirectory(currentDir));
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				checkpointFutures.push_back(fetchCheckpoint(cx, records.front().second, currentDir));
															#line 3372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_4 = store(fetchedCheckpoints, getAll(checkpointFutures));
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 5;
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 4, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestFetchCheckpointError").errorUnsuppressed(e);
															#line 3418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointFetched").detail("Checkpoints", describe(fetchedCheckpoints));
															#line 3433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointFetched").detail("Checkpoints", describe(fetchedCheckpoints));
															#line 3442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		rocksDBTestDir = "rocksdb-kvstore-test-restored-db";
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		shardId = "restored-shard";
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		kvStore = keyValueStoreShardedRocksDB( rocksDBTestDir, deterministicRandom()->randomUniqueID(), KeyValueStoreType::SSD_SHARDED_ROCKSDB);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_6 = kvStore->init();
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 7;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 6, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		rocksDBTestDir = "rocksdb-kvstore-test-restored-db";
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		shardId = "restored-shard";
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		kvStore = keyValueStoreShardedRocksDB( rocksDBTestDir, deterministicRandom()->randomUniqueID(), KeyValueStoreType::SSD_SHARDED_ROCKSDB);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_6 = kvStore->init();
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont4when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 7;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 6, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		try {
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_7 = kvStore->restore(shardId, restoreRanges, fetchedCheckpoints);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont6Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont6when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 8;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 7, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		try {
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_7 = kvStore->restore(shardId, restoreRanges, fetchedCheckpoints);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), loopDepth);
															#line 3675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont6Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont6when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 8;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 7, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointRestored").detail("Checkpoint", describe(fetchedCheckpoints));
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<RangeResult> __when_expr_8 = kvStore->readRange(normalKeys);
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont7when1(__when_expr_8.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 9;
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 8, RangeResult >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent(SevError, "TestRestoreCheckpointError") .errorUnsuppressed(e) .detail("Checkpoint", describe(fetchedCheckpoints));
															#line 3789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(RangeResult const& kvRange,int loopDepth) 
	{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(!kvRange.more);
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		std::unordered_map<Key, Value> kvsKvs;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for(int i = 0;i < kvRange.size();++i) {
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			kvsKvs[kvRange[i].key] = kvRange[i].value;
															#line 3910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		auto containsKey = [](std::vector<KeyRange> ranges, KeyRef key) { for (const auto& range : ranges) { if (range.contains(key)) { return true; } } return false; };
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		int count = 0;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for( const auto& [key, value] : *kvs ) {
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (containsKey(restoreRanges, key))
															#line 3920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				TraceEvent(SevDebug, "TestExpectKeyValueMatch").detail("Key", key).detail("Value", value);
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				auto it = kvsKvs.find(key);
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				ASSERT(it != kvsKvs.end() && it->second == value);
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				++count;
															#line 3930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
		}
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(kvsKvs.size() == count);
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointVerified").detail("Checkpoint", describe(fetchedCheckpoints));
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		Future<Void> close = kvStore->onClosed();
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		kvStore->dispose();
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_9 = close;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 10;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 9, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 3950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(RangeResult && kvRange,int loopDepth) 
	{
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(!kvRange.more);
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		std::unordered_map<Key, Value> kvsKvs;
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for(int i = 0;i < kvRange.size();++i) {
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			kvsKvs[kvRange[i].key] = kvRange[i].value;
															#line 3965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		auto containsKey = [](std::vector<KeyRange> ranges, KeyRef key) { for (const auto& range : ranges) { if (range.contains(key)) { return true; } } return false; };
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		int count = 0;
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for( const auto& [key, value] : *kvs ) {
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (containsKey(restoreRanges, key))
															#line 3975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				TraceEvent(SevDebug, "TestExpectKeyValueMatch").detail("Key", key).detail("Value", value);
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				auto it = kvsKvs.find(key);
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				ASSERT(it != kvsKvs.end() && it->second == value);
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				++count;
															#line 3985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
		}
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(kvsKvs.size() == count);
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestCheckpointVerified").detail("Checkpoint", describe(fetchedCheckpoints));
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		Future<Void> close = kvStore->onClosed();
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		kvStore->dispose();
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_9 = close;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10when1(__when_expr_9.get(), loopDepth); };
		static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 10;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckpointRestoreActor, 9, Void >*>(static_cast<CheckpointRestoreActor*>(this)));
															#line 4005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult const& kvRange,int loopDepth) 
	{
		loopDepth = a_body1cont10(kvRange, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(RangeResult && kvRange,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(kvRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 8, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 8, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 8, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 8, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		platform::eraseDirectoryRecursive(checkpointDir);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestRocksDBClosed").detail("Checkpoint", describe(fetchedCheckpoints));
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<CheckpointRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckpointRestoreActorState(); static_cast<CheckpointRestoreActor*>(this)->destroy(); return 0; }
															#line 4095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<CheckpointRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckpointRestoreActorState();
		static_cast<CheckpointRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		platform::eraseDirectoryRecursive(rocksDBTestDir);
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		platform::eraseDirectoryRecursive(checkpointDir);
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent(SevDebug, "TestRocksDBClosed").detail("Checkpoint", describe(fetchedCheckpoints));
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<CheckpointRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckpointRestoreActorState(); static_cast<CheckpointRestoreActor*>(this)->destroy(); return 0; }
															#line 4113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<CheckpointRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckpointRestoreActorState();
		static_cast<CheckpointRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckpointRestoreActor*>(this)->actor_wait_state > 0) static_cast<CheckpointRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<CheckpointRestoreActor*>(this)->ActorCallback< CheckpointRestoreActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckpointRestoreActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckpointRestoreActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PhysicalShardMoveWorkLoad* self;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<KeyRange> checkpointRanges;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<KeyRange> restoreRanges;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	CheckpointAsKeyValues asKeyValues;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::map<Key, Value>* kvs;
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Transaction tr;
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	CheckpointFormat format;
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	UID dataMoveId;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Version version;
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<std::pair<KeyRange, CheckpointMetaData>> records;
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::string checkpointDir;
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<Future<CheckpointMetaData>> checkpointFutures;
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<CheckpointMetaData> fetchedCheckpoints;
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::string rocksDBTestDir;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::string shardId;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	IKeyValueStore* kvStore;
															#line 4230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via checkpointRestore()
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class CheckpointRestoreActor final : public Actor<Void>, public ActorCallback< CheckpointRestoreActor, 0, Void >, public ActorCallback< CheckpointRestoreActor, 1, Void >, public ActorCallback< CheckpointRestoreActor, 2, Void >, public ActorCallback< CheckpointRestoreActor, 3, Void >, public ActorCallback< CheckpointRestoreActor, 4, Void >, public ActorCallback< CheckpointRestoreActor, 5, Void >, public ActorCallback< CheckpointRestoreActor, 6, Void >, public ActorCallback< CheckpointRestoreActor, 7, Void >, public ActorCallback< CheckpointRestoreActor, 8, RangeResult >, public ActorCallback< CheckpointRestoreActor, 9, Void >, public FastAllocated<CheckpointRestoreActor>, public CheckpointRestoreActorState<CheckpointRestoreActor> {
															#line 4235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<CheckpointRestoreActor>::operator new;
	using FastAllocated<CheckpointRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13353747981424361728UL, 705462826945133568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckpointRestoreActor, 0, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 1, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 2, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 3, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 4, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 5, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 6, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 7, Void >;
friend struct ActorCallback< CheckpointRestoreActor, 8, RangeResult >;
friend struct ActorCallback< CheckpointRestoreActor, 9, Void >;
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	CheckpointRestoreActor(PhysicalShardMoveWorkLoad* const& self,Database const& cx,std::vector<KeyRange> const& checkpointRanges,std::vector<KeyRange> const& restoreRanges,CheckpointAsKeyValues const& asKeyValues,std::map<Key, Value>* const& kvs) 
															#line 4261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<Void>(),
		   CheckpointRestoreActorState<CheckpointRestoreActor>(self, cx, checkpointRanges, restoreRanges, asKeyValues, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkpointRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13781275460602813440UL, 5089668311812311552UL);
		ActorExecutionContextHelper __helper(static_cast<CheckpointRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkpointRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkpointRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 8, RangeResult >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckpointRestoreActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<Void> checkpointRestore( PhysicalShardMoveWorkLoad* const& self, Database const& cx, std::vector<KeyRange> const& checkpointRanges, std::vector<KeyRange> const& restoreRanges, CheckpointAsKeyValues const& asKeyValues, std::map<Key, Value>* const& kvs ) {
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<Void>(new CheckpointRestoreActor(self, cx, checkpointRanges, restoreRanges, asKeyValues, kvs));
															#line 4302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

																#line 4307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via populateData()
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class PopulateDataActor>
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class PopulateDataActorState {
															#line 4313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PopulateDataActorState(PhysicalShardMoveWorkLoad* const& self,Database const& cx,std::map<Key, Value>* const& kvs) 
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : self(self),
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   cx(cx),
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   kvs(kvs),
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx)),
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   version(),
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   debugID()
															#line 4330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("populateData", reinterpret_cast<unsigned long>(this));

	}
	~PopulateDataActorState() 
	{
		fdb_probe_actor_destroy("populateData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			;
															#line 4345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PopulateDataActorState();
		static_cast<PopulateDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("PopulateTestDataDone") .detail("CommitVersion", tr->getCommittedVersion()) .detail("DebugID", debugID);
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<PopulateDataActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PopulateDataActorState(); static_cast<PopulateDataActor*>(this)->destroy(); return 0; }
															#line 4370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<PopulateDataActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PopulateDataActorState();
		static_cast<PopulateDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		debugID = deterministicRandom()->randomUniqueID();
															#line 4389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		try {
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr->debugTransaction(debugID);
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			for( const auto& [key, value] : *kvs ) {
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				tr->set(key, value);
															#line 4397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<PopulateDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PopulateDataActor*>(this)->actor_wait_state = 1;
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PopulateDataActor, 0, Void >*>(static_cast<PopulateDataActor*>(this)));
															#line 4408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestCommitError").errorUnsuppressed(e);
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<PopulateDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PopulateDataActor*>(this)->actor_wait_state = 2;
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PopulateDataActor, 1, Void >*>(static_cast<PopulateDataActor*>(this)));
															#line 4452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		version = tr->getCommittedVersion();
															#line 4467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		version = tr->getCommittedVersion();
															#line 4476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PopulateDataActor*>(this)->actor_wait_state > 0) static_cast<PopulateDataActor*>(this)->actor_wait_state = 0;
		static_cast<PopulateDataActor*>(this)->ActorCallback< PopulateDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PopulateDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PopulateDataActor*>(this)->actor_wait_state > 0) static_cast<PopulateDataActor*>(this)->actor_wait_state = 0;
		static_cast<PopulateDataActor*>(this)->ActorCallback< PopulateDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PopulateDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PopulateDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PhysicalShardMoveWorkLoad* self;
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::map<Key, Value>* kvs;
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Version version;
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	UID debugID;
															#line 4655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via populateData()
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class PopulateDataActor final : public Actor<Version>, public ActorCallback< PopulateDataActor, 0, Void >, public ActorCallback< PopulateDataActor, 1, Void >, public FastAllocated<PopulateDataActor>, public PopulateDataActorState<PopulateDataActor> {
															#line 4660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<PopulateDataActor>::operator new;
	using FastAllocated<PopulateDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12708768097679120640UL, 11153316751962523648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PopulateDataActor, 0, Void >;
friend struct ActorCallback< PopulateDataActor, 1, Void >;
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PopulateDataActor(PhysicalShardMoveWorkLoad* const& self,Database const& cx,std::map<Key, Value>* const& kvs) 
															#line 4678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<Version>(),
		   PopulateDataActorState<PopulateDataActor>(self, cx, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("populateData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16199582911145818112UL, 5085221050047154688UL);
		ActorExecutionContextHelper __helper(static_cast<PopulateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("populateData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("populateData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PopulateDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PopulateDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<Version> populateData( PhysicalShardMoveWorkLoad* const& self, Database const& cx, std::map<Key, Value>* const& kvs ) {
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<Version>(new PopulateDataActor(self, cx, kvs));
															#line 4711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

																#line 4716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via validateData()
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class ValidateDataActor>
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class ValidateDataActorState {
															#line 4722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	ValidateDataActorState(PhysicalShardMoveWorkLoad* const& self,Database const& cx,KeyRange const& range,std::map<Key, Value>* const& kvs) 
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : self(self),
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   cx(cx),
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   range(range),
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   kvs(kvs),
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   tr(cx),
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   debugID()
															#line 4739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("validateData", reinterpret_cast<unsigned long>(this));

	}
	~ValidateDataActorState() 
	{
		fdb_probe_actor_destroy("validateData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			;
															#line 4754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateDataActorState();
		static_cast<ValidateDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("ValidateTestDataDone").detail("DebugID", debugID);
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<ValidateDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateDataActorState(); static_cast<ValidateDataActor*>(this)->destroy(); return 0; }
															#line 4779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<ValidateDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateDataActorState();
		static_cast<ValidateDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		debugID = deterministicRandom()->randomUniqueID();
															#line 4798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		try {
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestValidateDataBegin").detail("DebugID", debugID);
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.debugTransaction(debugID);
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(range, CLIENT_KNOBS->TOO_MANY);
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<ValidateDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateDataActor*>(this)->actor_wait_state = 1;
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateDataActor, 0, RangeResult >*>(static_cast<ValidateDataActor*>(this)));
															#line 4813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestCommitError").errorUnsuppressed(e);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<ValidateDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ValidateDataActor*>(this)->actor_wait_state = 2;
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateDataActor, 1, Void >*>(static_cast<ValidateDataActor*>(this)));
															#line 4857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res,int loopDepth) 
	{
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(!res.more && res.size() < CLIENT_KNOBS->TOO_MANY);
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for( const auto& kv : res ) {
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			ASSERT((*kvs)[kv.key] == kv.value);
															#line 4876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res,int loopDepth) 
	{
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(!res.more && res.size() < CLIENT_KNOBS->TOO_MANY);
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for( const auto& kv : res ) {
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			ASSERT((*kvs)[kv.key] == kv.value);
															#line 4890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateDataActor*>(this)->actor_wait_state > 0) static_cast<ValidateDataActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDataActor*>(this)->ActorCallback< ValidateDataActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDataActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("validateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateDataActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("validateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateDataActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("validateData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateDataActor*>(this)->actor_wait_state > 0) static_cast<ValidateDataActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDataActor*>(this)->ActorCallback< ValidateDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PhysicalShardMoveWorkLoad* self;
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	KeyRange range;
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::map<Key, Value>* kvs;
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Transaction tr;
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	UID debugID;
															#line 5070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via validateData()
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class ValidateDataActor final : public Actor<Void>, public ActorCallback< ValidateDataActor, 0, RangeResult >, public ActorCallback< ValidateDataActor, 1, Void >, public FastAllocated<ValidateDataActor>, public ValidateDataActorState<ValidateDataActor> {
															#line 5075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<ValidateDataActor>::operator new;
	using FastAllocated<ValidateDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4637997844830460416UL, 14165679751908633600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateDataActor, 0, RangeResult >;
friend struct ActorCallback< ValidateDataActor, 1, Void >;
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	ValidateDataActor(PhysicalShardMoveWorkLoad* const& self,Database const& cx,KeyRange const& range,std::map<Key, Value>* const& kvs) 
															#line 5093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateDataActorState<ValidateDataActor>(self, cx, range, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3390558984087627264UL, 4655697053193422848UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateDataActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<Void> validateData( PhysicalShardMoveWorkLoad* const& self, Database const& cx, KeyRange const& range, std::map<Key, Value>* const& kvs ) {
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<Void>(new ValidateDataActor(self, cx, range, kvs));
															#line 5126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

																#line 5131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via readAndVerify()
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class ReadAndVerifyActor>
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class ReadAndVerifyActorState {
															#line 5137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	ReadAndVerifyActorState(PhysicalShardMoveWorkLoad* const& self,Database const& cx,Key const& key,ErrorOr<Optional<Value>> const& expectedValue) 
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : self(self),
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   cx(cx),
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   key(key),
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   expectedValue(expectedValue),
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   tr(cx),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   readVersion()
															#line 5154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("readAndVerify", reinterpret_cast<unsigned long>(this));

	}
	~ReadAndVerifyActorState() 
	{
		fdb_probe_actor_destroy("readAndVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			;
															#line 5171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadAndVerifyActorState();
		static_cast<ReadAndVerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestReadSuccess").detail("Version", readVersion);
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<ReadAndVerifyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadAndVerifyActorState(); static_cast<ReadAndVerifyActor*>(this)->destroy(); return 0; }
															#line 5196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<ReadAndVerifyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadAndVerifyActorState();
		static_cast<ReadAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 1;
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 0, Version >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 5223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestReadError").errorUnsuppressed(e);
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (expectedValue.isError() && expectedValue.getError().code() == e.code())
															#line 5260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 3;
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 2, Void >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 5273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& _readVersion,int loopDepth) 
	{
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		readVersion = _readVersion;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = timeoutError(tr.get(key), 30.0);
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 2;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 5297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && _readVersion,int loopDepth) 
	{
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		readVersion = _readVersion;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = timeoutError(tr.get(key), 30.0);
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 2;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >*>(static_cast<ReadAndVerifyActor*>(this)));
															#line 5315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& _readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && _readVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyActor*>(this)->ActorCallback< ReadAndVerifyActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		const bool equal = !expectedValue.isError() && res == expectedValue.get();
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!equal)
															#line 5401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		{
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			self->validationFailed(expectedValue, ErrorOr<Optional<Value>>(res));
															#line 5405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& __res,int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		res = __res;
															#line 5415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyActor*>(this)->ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<ReadAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadAndVerifyActor*>(this)->ActorCallback< ReadAndVerifyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadAndVerifyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadAndVerifyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PhysicalShardMoveWorkLoad* self;
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Key key;
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	ErrorOr<Optional<Value>> expectedValue;
															#line 511 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Transaction tr;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Version readVersion;
															#line 519 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Optional<Value> res;
															#line 5591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via readAndVerify()
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class ReadAndVerifyActor final : public Actor<Void>, public ActorCallback< ReadAndVerifyActor, 0, Version >, public ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >, public ActorCallback< ReadAndVerifyActor, 2, Void >, public FastAllocated<ReadAndVerifyActor>, public ReadAndVerifyActorState<ReadAndVerifyActor> {
															#line 5596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<ReadAndVerifyActor>::operator new;
	using FastAllocated<ReadAndVerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12951056140454851328UL, 9110403126406060032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadAndVerifyActor, 0, Version >;
friend struct ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >;
friend struct ActorCallback< ReadAndVerifyActor, 2, Void >;
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	ReadAndVerifyActor(PhysicalShardMoveWorkLoad* const& self,Database const& cx,Key const& key,ErrorOr<Optional<Value>> const& expectedValue) 
															#line 5615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<Void>(),
		   ReadAndVerifyActorState<ReadAndVerifyActor>(self, cx, key, expectedValue),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readAndVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3184544065301379584UL, 344653789742809600UL);
		ActorExecutionContextHelper __helper(static_cast<ReadAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readAndVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readAndVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadAndVerifyActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadAndVerifyActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadAndVerifyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<Void> readAndVerify( PhysicalShardMoveWorkLoad* const& self, Database const& cx, Key const& key, ErrorOr<Optional<Value>> const& expectedValue ) {
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<Void>(new ReadAndVerifyActor(self, cx, key, expectedValue));
															#line 5649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 538 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

																#line 5654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via writeAndVerify()
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class WriteAndVerifyActor>
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class WriteAndVerifyActorState {
															#line 5660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	WriteAndVerifyActorState(PhysicalShardMoveWorkLoad* const& self,Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : self(self),
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   cx(cx),
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   key(key),
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   value(value),
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx)),
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   version(),
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   debugID()
															#line 5679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("writeAndVerify", reinterpret_cast<unsigned long>(this));

	}
	~WriteAndVerifyActorState() 
	{
		fdb_probe_actor_destroy("writeAndVerify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			;
															#line 5694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestCommitSuccess").detail("CommitVersion", tr->getCommittedVersion()).detail("DebugID", debugID);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->readAndVerify(self, cx, key, value);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 3;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 2, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 5726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		debugID = deterministicRandom()->randomUniqueID();
															#line 5742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		try {
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			tr->debugTransaction(debugID);
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (value.present())
															#line 5750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				tr->set(key, value.get());
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				tr->set("Test?"_sr, value.get());
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				tr->set(key, value.get());
															#line 5758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
			else
			{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				tr->clear(key);
															#line 5764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeoutError(tr->commit(), 30.0);
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 1;
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 0, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 5775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestCommitError").errorUnsuppressed(e);
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 2;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyActor, 1, Void >*>(static_cast<WriteAndVerifyActor*>(this)));
															#line 5819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		version = tr->getCommittedVersion();
															#line 5834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		version = tr->getCommittedVersion();
															#line 5843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<WriteAndVerifyActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WriteAndVerifyActorState(); static_cast<WriteAndVerifyActor*>(this)->destroy(); return 0; }
															#line 6014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<WriteAndVerifyActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<WriteAndVerifyActor*>(this)->SAV<Version>::futures) { (void)(version); this->~WriteAndVerifyActorState(); static_cast<WriteAndVerifyActor*>(this)->destroy(); return 0; }
															#line 6026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<WriteAndVerifyActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~WriteAndVerifyActorState();
		static_cast<WriteAndVerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteAndVerifyActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyActor*>(this)->ActorCallback< WriteAndVerifyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PhysicalShardMoveWorkLoad* self;
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Key key;
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Optional<Value> value;
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Version version;
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	UID debugID;
															#line 6123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via writeAndVerify()
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class WriteAndVerifyActor final : public Actor<Version>, public ActorCallback< WriteAndVerifyActor, 0, Void >, public ActorCallback< WriteAndVerifyActor, 1, Void >, public ActorCallback< WriteAndVerifyActor, 2, Void >, public FastAllocated<WriteAndVerifyActor>, public WriteAndVerifyActorState<WriteAndVerifyActor> {
															#line 6128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<WriteAndVerifyActor>::operator new;
	using FastAllocated<WriteAndVerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4230659362732767232UL, 15546638667569265408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteAndVerifyActor, 0, Void >;
friend struct ActorCallback< WriteAndVerifyActor, 1, Void >;
friend struct ActorCallback< WriteAndVerifyActor, 2, Void >;
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	WriteAndVerifyActor(PhysicalShardMoveWorkLoad* const& self,Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 6147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<Version>(),
		   WriteAndVerifyActorState<WriteAndVerifyActor>(self, cx, key, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeAndVerify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3594513465819686400UL, 13554697269594140416UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeAndVerify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeAndVerify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteAndVerifyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<Version> writeAndVerify( PhysicalShardMoveWorkLoad* const& self, Database const& cx, Key const& key, Optional<Value> const& value ) {
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<Version>(new WriteAndVerifyActor(self, cx, key, value));
															#line 6181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

	// Move keys to a random selected team consisting of a single SS, this requires DD is disabled to prevent shards
	// being moved by DD automatically. Returns the address of the single SS of the new team.
																#line 6188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via moveShard()
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class MoveShardActor>
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class MoveShardActorState {
															#line 6194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	MoveShardActorState(PhysicalShardMoveWorkLoad* const& self,Database const& cx,UID const& dataMoveId,KeyRange const& keys,int const& teamSize,std::unordered_set<UID> const& includes,std::unordered_set<UID> const& excludes) 
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : self(self),
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   cx(cx),
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   dataMoveId(dataMoveId),
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   keys(keys),
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   teamSize(teamSize),
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   includes(includes),
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   excludes(excludes)
															#line 6213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("moveShard", reinterpret_cast<unsigned long>(this));

	}
	~MoveShardActorState() 
	{
		fdb_probe_actor_destroy("moveShard", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<MoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MoveShardActor*>(this)->actor_wait_state = 1;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >*>(static_cast<MoveShardActor*>(this)));
															#line 6235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveShardActorState();
		static_cast<MoveShardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<StorageServerInterface> const& interfs,int loopDepth) 
	{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(interfs.size() > teamSize - includes.size());
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for(;includes.size() < teamSize;) {
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			const auto& interf = interfs[deterministicRandom()->randomInt(0, interfs.size())];
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (!excludes.contains(interf.uniqueID) && !includes.contains(interf.uniqueID))
															#line 6264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				includes.insert(interf.uniqueID);
															#line 6268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
		}
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		dests = std::vector<UID>(includes.begin(), includes.end());
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		owner = deterministicRandom()->randomUniqueID();
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ddEnabledState = DDEnabledState();
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		tr = Transaction(cx);
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		;
															#line 6281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(std::vector<StorageServerInterface> && interfs,int loopDepth) 
	{
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(interfs.size() > teamSize - includes.size());
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		for(;includes.size() < teamSize;) {
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			const auto& interf = interfs[deterministicRandom()->randomInt(0, interfs.size())];
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (!excludes.contains(interf.uniqueID) && !includes.contains(interf.uniqueID))
															#line 6296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				includes.insert(interf.uniqueID);
															#line 6300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			}
		}
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		dests = std::vector<UID>(includes.begin(), includes.end());
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		owner = deterministicRandom()->randomUniqueID();
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ddEnabledState = DDEnabledState();
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		tr = Transaction(cx);
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		;
															#line 6313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& interfs,int loopDepth) 
	{
		loopDepth = a_body1cont1(interfs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && interfs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(interfs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveShardActor*>(this)->actor_wait_state > 0) static_cast<MoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<MoveShardActor*>(this)->ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestMoveShardComplete").detail("Range", keys.toString()).detail("NewTeam", describe(dests));
															#line 659 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<MoveShardActor*>(this)->SAV<std::vector<UID>>::futures) { (void)(dests); this->~MoveShardActorState(); static_cast<MoveShardActor*>(this)->destroy(); return 0; }
															#line 6399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<MoveShardActor*>(this)->SAV< std::vector<UID> >::value()) std::vector<UID>(std::move(dests)); // state_var_RVO
		this->~MoveShardActorState();
		static_cast<MoveShardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestMoveShard").detail("Range", keys.toString());
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<MoveKeysLock> __when_expr_1 = takeMoveKeysLock(cx, owner);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<MoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MoveShardActor*>(this)->actor_wait_state = 2;
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveShardActor, 1, MoveKeysLock >*>(static_cast<MoveShardActor*>(this)));
															#line 6428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (e.code() == error_code_movekeys_conflict)
															#line 6463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				tr.reset();
															#line 6467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
				loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);
			}
			else
			{
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				if (static_cast<MoveShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<MoveShardActor*>(this)->actor_wait_state = 7;
															#line 652 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MoveShardActor, 6, Void >*>(static_cast<MoveShardActor*>(this)));
															#line 6481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<RangeResult> __when_expr_2 = tr.getRange(dataMoveKeys, CLIENT_KNOBS->TOO_MANY);
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<MoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MoveShardActor*>(this)->actor_wait_state = 3;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveShardActor, 2, RangeResult >*>(static_cast<MoveShardActor*>(this)));
															#line 6506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(MoveKeysLock const& __moveKeysLock,int loopDepth) 
	{
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		moveKeysLock = __moveKeysLock;
															#line 6515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(MoveKeysLock && __moveKeysLock,int loopDepth) 
	{
		moveKeysLock = std::move(__moveKeysLock);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveShardActor*>(this)->actor_wait_state > 0) static_cast<MoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<MoveShardActor*>(this)->ActorCallback< MoveShardActor, 1, MoveKeysLock >::remove();

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 1, MoveKeysLock >*,MoveKeysLock const& value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 1, MoveKeysLock >*,MoveKeysLock && value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveShardActor, 1, MoveKeysLock >*,Error err) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Version> __when_expr_3 = tr.getReadVersion();
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<MoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<MoveShardActor*>(this)->actor_wait_state = 4;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MoveShardActor, 3, Version >*>(static_cast<MoveShardActor*>(this)));
															#line 6601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult const& __dataMoves,int loopDepth) 
	{
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		dataMoves = __dataMoves;
															#line 6610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(RangeResult && __dataMoves,int loopDepth) 
	{
		dataMoves = std::move(__dataMoves);
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MoveShardActor*>(this)->actor_wait_state > 0) static_cast<MoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<MoveShardActor*>(this)->ActorCallback< MoveShardActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MoveShardActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Version const& readVersion,int loopDepth) 
	{
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestMoveShardReadDataMoves") .detail("DataMoves", dataMoves.size()) .detail("ReadVersion", readVersion);
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		i = 0;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		;
															#line 6693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Version && readVersion,int loopDepth) 
	{
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestMoveShardReadDataMoves") .detail("DataMoves", dataMoves.size()) .detail("ReadVersion", readVersion);
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		i = 0;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		;
															#line 6706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MoveShardActor*>(this)->actor_wait_state > 0) static_cast<MoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<MoveShardActor*>(this)->ActorCallback< MoveShardActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MoveShardActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestMoveShardStartMoveKeys").detail("DataMove", dataMoveId);
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_5 = moveKeys(cx, MoveKeysParams(dataMoveId, std::vector<KeyRange>{ keys }, dests, dests, moveKeysLock, Promise<Void>(), &self->startMoveKeysParallelismLock, &self->finishMoveKeysParallelismLock, false, deterministicRandom()->randomUniqueID(), &ddEnabledState, CancelConflictingDataMoves::False, Optional<BulkLoadTaskState>()));
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<MoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<MoveShardActor*>(this)->actor_wait_state = 6;
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MoveShardActor, 5, Void >*>(static_cast<MoveShardActor*>(this)));
															#line 6799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4loopBody1(int loopDepth) 
	{
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!(i < dataMoves.size()))
															#line 6815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		UID dataMoveId = decodeDataMoveKey(dataMoves[i].key);
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		dataMove = decodeDataMoveValue(dataMoves[i].value);
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(dataMoveId == dataMove.id);
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestCancelDataMoveBegin").detail("DataMove", dataMove.toString());
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (dataMove.ranges.empty())
															#line 6829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		{
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			ASSERT(dataMove.getPhase() == DataMoveMetaData::Deleting);
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			TraceEvent("TestCancelEmptyDataMoveEnd").detail("DataMove", dataMove.toString());
															#line 6835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			return a_body1cont1loopBody1cont4continue1(loopDepth); // continue
		}
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<Void> __when_expr_4 = cleanUpDataMove(cx, dataMoveId, moveKeysLock, &self->cleanUpDataMoveParallelismLock, dataMove.ranges.front(), &ddEnabledState);
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<MoveShardActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<MoveShardActor*>(this)->actor_wait_state = 5;
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MoveShardActor, 4, Void >*>(static_cast<MoveShardActor*>(this)));
															#line 6847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4continue1(int loopDepth) 
	{
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++i;
															#line 6869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestCancelDataMoveEnd").detail("DataMove", dataMove.toString());
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++i;
															#line 6880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		TraceEvent("TestCancelDataMoveEnd").detail("DataMove", dataMove.toString());
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		++i;
															#line 6891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MoveShardActor*>(this)->actor_wait_state > 0) static_cast<MoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<MoveShardActor*>(this)->ActorCallback< MoveShardActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MoveShardActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MoveShardActor*>(this)->actor_wait_state > 0) static_cast<MoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<MoveShardActor*>(this)->ActorCallback< MoveShardActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MoveShardActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<MoveShardActor*>(this)->actor_wait_state > 0) static_cast<MoveShardActor*>(this)->actor_wait_state = 0;
		static_cast<MoveShardActor*>(this)->ActorCallback< MoveShardActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MoveShardActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MoveShardActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	PhysicalShardMoveWorkLoad* self;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	UID dataMoveId;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	KeyRange keys;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	int teamSize;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::unordered_set<UID> includes;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::unordered_set<UID> excludes;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	std::vector<UID> dests;
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	UID owner;
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	DDEnabledState ddEnabledState;
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Transaction tr;
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	MoveKeysLock moveKeysLock;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	RangeResult dataMoves;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	int i;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	DataMoveMetaData dataMove;
															#line 7181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via moveShard()
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class MoveShardActor final : public Actor<std::vector<UID>>, public ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< MoveShardActor, 1, MoveKeysLock >, public ActorCallback< MoveShardActor, 2, RangeResult >, public ActorCallback< MoveShardActor, 3, Version >, public ActorCallback< MoveShardActor, 4, Void >, public ActorCallback< MoveShardActor, 5, Void >, public ActorCallback< MoveShardActor, 6, Void >, public FastAllocated<MoveShardActor>, public MoveShardActorState<MoveShardActor> {
															#line 7186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<MoveShardActor>::operator new;
	using FastAllocated<MoveShardActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11093360159900719104UL, 9734704529590242816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<UID>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< MoveShardActor, 1, MoveKeysLock >;
friend struct ActorCallback< MoveShardActor, 2, RangeResult >;
friend struct ActorCallback< MoveShardActor, 3, Version >;
friend struct ActorCallback< MoveShardActor, 4, Void >;
friend struct ActorCallback< MoveShardActor, 5, Void >;
friend struct ActorCallback< MoveShardActor, 6, Void >;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	MoveShardActor(PhysicalShardMoveWorkLoad* const& self,Database const& cx,UID const& dataMoveId,KeyRange const& keys,int const& teamSize,std::unordered_set<UID> const& includes,std::unordered_set<UID> const& excludes) 
															#line 7209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<std::vector<UID>>(),
		   MoveShardActorState<MoveShardActor>(self, cx, dataMoveId, keys, teamSize, includes, excludes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("moveShard", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7705114804704740608UL, 12893506340479371776UL);
		ActorExecutionContextHelper __helper(static_cast<MoveShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("moveShard");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("moveShard", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveShardActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveShardActor, 1, MoveKeysLock >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MoveShardActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MoveShardActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MoveShardActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MoveShardActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< MoveShardActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<std::vector<UID>> moveShard( PhysicalShardMoveWorkLoad* const& self, Database const& cx, UID const& dataMoveId, KeyRange const& keys, int const& teamSize, std::unordered_set<UID> const& includes, std::unordered_set<UID> const& excludes ) {
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<std::vector<UID>>(new MoveShardActor(self, cx, dataMoveId, keys, teamSize, includes, excludes));
															#line 7247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 661 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

																#line 7252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
// This generated class is to be used only via getStorageServerShards()
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
template <class GetStorageServerShardsActor>
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class GetStorageServerShardsActorState {
															#line 7258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	GetStorageServerShardsActorState(Database const& cx,UID const& ssId,KeyRange const& range) 
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		 : cx(cx),
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   ssId(ssId),
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   range(range),
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		   tr(cx)
															#line 7271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServerShards", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServerShardsActorState() 
	{
		fdb_probe_actor_destroy("getStorageServerShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			;
															#line 7286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServerShardsActorState();
		static_cast<GetStorageServerShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(serverListKeyFor(ssId));
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state = 1;
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >*>(static_cast<GetStorageServerShardsActor*>(this)));
															#line 7324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			if (static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state = 3;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerShardsActor, 2, Void >*>(static_cast<GetStorageServerShardsActor*>(this)));
															#line 7353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& serverListValue,int loopDepth) 
	{
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(serverListValue.present());
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ssi = decodeServerListValue(serverListValue.get());
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		GetShardStateRequest req(range, GetShardStateRequest::READABLE, true);
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<GetShardStateReply> __when_expr_1 = ssi.getShardState.getReply(req, TaskPriority::DefaultEndpoint);
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state = 2;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >*>(static_cast<GetStorageServerShardsActor*>(this)));
															#line 7381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && serverListValue,int loopDepth) 
	{
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ASSERT(serverListValue.present());
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		ssi = decodeServerListValue(serverListValue.get());
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		GetShardStateRequest req(range, GetShardStateRequest::READABLE, true);
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		StrictFuture<GetShardStateReply> __when_expr_1 = ssi.getShardState.getReply(req, TaskPriority::DefaultEndpoint);
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state = 2;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >*>(static_cast<GetStorageServerShardsActor*>(this)));
															#line 7403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(serverListValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(serverListValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerShardsActor*>(this)->ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(GetShardStateReply const& rep,int loopDepth) 
	{
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<GetStorageServerShardsActor*>(this)->SAV<std::vector<StorageServerShard>>::futures) { (void)(rep.shards); this->~GetStorageServerShardsActorState(); static_cast<GetStorageServerShardsActor*>(this)->destroy(); return 0; }
															#line 7487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<GetStorageServerShardsActor*>(this)->SAV< std::vector<StorageServerShard> >::value()) std::vector<StorageServerShard>(rep.shards);
		this->~GetStorageServerShardsActorState();
		static_cast<GetStorageServerShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(GetShardStateReply && rep,int loopDepth) 
	{
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
		if (!static_cast<GetStorageServerShardsActor*>(this)->SAV<std::vector<StorageServerShard>>::futures) { (void)(rep.shards); this->~GetStorageServerShardsActorState(); static_cast<GetStorageServerShardsActor*>(this)->destroy(); return 0; }
															#line 7499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		new (&static_cast<GetStorageServerShardsActor*>(this)->SAV< std::vector<StorageServerShard> >::value()) std::vector<StorageServerShard>(rep.shards);
		this->~GetStorageServerShardsActorState();
		static_cast<GetStorageServerShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(GetShardStateReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(GetShardStateReply && rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerShardsActor*>(this)->ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >*,GetShardStateReply const& value) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >*,GetShardStateReply && value) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerShardsActor*>(this)->ActorCallback< GetStorageServerShardsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerShardsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetStorageServerShardsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetStorageServerShardsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Database cx;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	UID ssId;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	KeyRange range;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	Transaction tr;
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	StorageServerInterface ssi;
															#line 7679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
};
// This generated class is to be used only via getStorageServerShards()
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
class GetStorageServerShardsActor final : public Actor<std::vector<StorageServerShard>>, public ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >, public ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >, public ActorCallback< GetStorageServerShardsActor, 2, Void >, public FastAllocated<GetStorageServerShardsActor>, public GetStorageServerShardsActorState<GetStorageServerShardsActor> {
															#line 7684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
public:
	using FastAllocated<GetStorageServerShardsActor>::operator new;
	using FastAllocated<GetStorageServerShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16773288381565429248UL, 8329667066945192192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerShard>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >;
friend struct ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >;
friend struct ActorCallback< GetStorageServerShardsActor, 2, Void >;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	GetStorageServerShardsActor(Database const& cx,UID const& ssId,KeyRange const& range) 
															#line 7703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
		 : Actor<std::vector<StorageServerShard>>(),
		   GetStorageServerShardsActorState<GetStorageServerShardsActor>(cx, ssId, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServerShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6373221747181425920UL, 3577883875870942208UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServerShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServerShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServerShardsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageServerShardsActor, 1, GetShardStateReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetStorageServerShardsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
[[nodiscard]] Future<std::vector<StorageServerShard>> getStorageServerShards( Database const& cx, UID const& ssId, KeyRange const& range ) {
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"
	return Future<std::vector<StorageServerShard>>(new GetStorageServerShardsActor(cx, ssId, range));
															#line 7737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/PhysicalShardMove.actor.g.cpp"
}

#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/PhysicalShardMove.actor.cpp"

	Future<bool> check(Database const& cx) override { return pass; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<PhysicalShardMoveWorkLoad> PhysicalShardMoveWorkLoadFactory;