#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
/*
 * ConflictRange.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// For this test to report properly buggify must be disabled (flow.h) , and failConnection must be disabled in
// (sim2.actor.cpp)

struct ConflictRangeWorkload : TestWorkload {
	static constexpr auto NAME = "ConflictRange";
	int minOperationsPerTransaction, maxOperationsPerTransaction, maxKeySpace, maxOffset, minInitialAmount,
	    maxInitialAmount;
	double testDuration;
	bool testReadYourWrites;

	std::vector<Future<Void>> clients;
	PerfIntCounter withConflicts, withoutConflicts, retries;

	// This workload is not compatible with RandomRangeLock workload because RangeLock transaction triggers conflicts
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	ConflictRangeWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), withConflicts("WithConflicts"), withoutConflicts("withoutConflicts"), retries("Retries") {
		minOperationsPerTransaction = getOption(options, "minOperationsPerTransaction"_sr, 2);
		maxOperationsPerTransaction = getOption(options, "minOperationsPerTransaction"_sr, 4);
		maxKeySpace = getOption(options, "maxKeySpace"_sr, 100);
		maxOffset = getOption(options, "maxOffset"_sr, 5);
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		testReadYourWrites = getOption(options, "testReadYourWrites"_sr, false);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override {
		clients.clear();
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(withConflicts.getMetric());
		m.push_back(withoutConflicts.getMetric());
		m.push_back(retries.getMetric());
	}

																#line 73 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
template <class _startActor>
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
class _startActorState {
															#line 79 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
public:
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	_startActorState(Database const& cx,ConflictRangeWorkload* const& self) 
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		 : cx(cx),
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   self(self)
															#line 88 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (self->clientId == 0)
															#line 103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				StrictFuture<Void> __when_expr_0 = timeout(self->conflictRangeClient(cx, self), self->testDuration, Void());
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Database cx;
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	ConflictRangeWorkload* self;
															#line 241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10858255961011191808UL, 9553528073072098560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	_startActor(Database const& cx,ConflictRangeWorkload* const& self) 
															#line 263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ConflictRangeWorkload* const& self ) {
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
}

#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"

																#line 300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
// This generated class is to be used only via conflictRangeClient()
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
template <class ConflictRangeClientActor>
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
class ConflictRangeClientActorState {
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
public:
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	ConflictRangeClientActorState(Database const& cx,ConflictRangeWorkload* const& self) 
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		 : cx(cx),
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   self(self),
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   clientID(),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   myKeyA(),
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   myKeyB(),
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   myValue(),
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   onEqualA(),
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   onEqualB(),
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   offsetA(),
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   offsetB(),
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   randomLimit(),
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   reverse(Reverse::False),
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   randomSets(false),
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   insertedSet(),
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   originalResults(),
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   firstElement(),
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   clearedSet(),
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   clearedBegin(),
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		   clearedEnd()
															#line 349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
	{
		fdb_probe_actor_create("conflictRangeClient", reinterpret_cast<unsigned long>(this));

	}
	~ConflictRangeClientActorState() 
	{
		fdb_probe_actor_destroy("conflictRangeClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (g_network->isSimulated())
															#line 364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				StrictFuture<Void> __when_expr_0 = timeKeeperSetDisable(cx);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 1;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 0, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConflictRangeClientActorState();
		static_cast<ConflictRangeClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		sentinelKey = StringRef(format("%010d", self->maxKeySpace));
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		;
															#line 405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		randomSets = !randomSets;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		;
															#line 510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		firstElement = Key(StringRef(format("%010d", *(insertedSet.begin()))));
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr1 = Transaction(cx);
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr2 = Transaction(cx);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr3 = Transaction(cx);
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr4 = Transaction(cx);
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		trRYOW = ReadYourWritesTransaction(cx);
															#line 529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		try {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			;
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr0 = Transaction(cx);
															#line 555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		try {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			TraceEvent("ConflictRangeReset").log();
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			insertedSet.clear();
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (self->testReadYourWrites)
															#line 563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				clearedSet.clear();
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				int clearedA = deterministicRandom()->randomInt(0, self->maxKeySpace - 1);
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				int clearedB = deterministicRandom()->randomInt(0, self->maxKeySpace - 1);
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				clearedBegin = std::min(clearedA, clearedB);
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				clearedEnd = std::max(clearedA, clearedB) + 1;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				TraceEvent("ConflictRangeClear").detail("Begin", clearedBegin).detail("End", clearedEnd);
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			tr0.clear( KeyRangeRef(StringRef(format("%010d", 0)), StringRef(format("%010d", self->maxKeySpace))));
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < self->maxKeySpace;i++) {
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (deterministicRandom()->random01() > 0.5)
															#line 585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				{
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					TraceEvent("ConflictRangeInit").detail("Key", i);
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					if (self->testReadYourWrites && i >= clearedBegin && i < clearedEnd)
															#line 591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
					{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						clearedSet.insert(i);
															#line 595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
					}
					else
					{
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						insertedSet.insert(i);
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						tr0.set(StringRef(format("%010d", i)), deterministicRandom()->randomUniqueID().toString());
															#line 603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
					}
				}
			}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			tr0.set(sentinelKey, deterministicRandom()->randomUniqueID().toString());
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr0.commit();
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 2;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 1, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr0.onError(e);
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 3;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 2, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			e2 = e;
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (e2.code() != error_code_not_committed)
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				++self->retries;
															#line 862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			StrictFuture<Void> __when_expr_15 = tr1.onError(e2);
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1when1(__when_expr_15.get(), loopDepth); };
			static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 16;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 15, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (self->testReadYourWrites)
															#line 888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(auto iter = clearedSet.begin();iter != clearedSet.end();++iter) {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				tr1.set(StringRef(format("%010d", (*iter))), deterministicRandom()->randomUniqueID().toString());
															#line 894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr1.commit();
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 5;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 4, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		myKeyA = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace));
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		myKeyB = format("%010d", deterministicRandom()->randomInt(0, self->maxKeySpace));
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		onEqualA = deterministicRandom()->randomInt(0, 2) != 0;
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		onEqualB = deterministicRandom()->randomInt(0, 2) != 0;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		offsetA = deterministicRandom()->randomInt(-1 * self->maxOffset, self->maxOffset);
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		offsetB = deterministicRandom()->randomInt(-1 * self->maxOffset, self->maxOffset);
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		randomLimit = deterministicRandom()->randomInt(1, self->maxKeySpace);
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		reverse.set(deterministicRandom()->coinflip());
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = tr1.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 4;
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 3, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(RangeResult const& res,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (res.size())
															#line 971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			originalResults = res;
															#line 975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr1 = Transaction(cx);
															#line 980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1cont1(RangeResult && res,int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (res.size())
															#line 989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			originalResults = res;
															#line 993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			return a_body1cont1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr1 = Transaction(cx);
															#line 998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1loopBody1when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Version> __when_expr_5 = tr2.getReadVersion();
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 6;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 5, Version >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr1 = Transaction(cx);
															#line 1098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr1 = Transaction(cx);
															#line 1107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont8(Version const& readVersion,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (self->testReadYourWrites)
															#line 1191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			trRYOW.setVersion(readVersion);
															#line 1195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
		else
		{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			tr3.setVersion(readVersion);
															#line 1201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		for(int i = 0;i < deterministicRandom()->randomInt(self->minOperationsPerTransaction, self->maxOperationsPerTransaction + 1);i++) {
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (randomSets)
															#line 1207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				for(int j = 0;j < 5;j++) {
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					int proposedKey = deterministicRandom()->randomInt(0, self->maxKeySpace);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					if (!insertedSet.contains(proposedKey))
															#line 1215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
					{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						TraceEvent("ConflictRangeSet").detail("Key", proposedKey);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						insertedSet.insert(proposedKey);
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						tr2.set(StringRef(format("%010d", proposedKey)), deterministicRandom()->randomUniqueID().toString());
															#line 1223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
						break;
					}
				}
			}
			else
			{
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				for(int j = 0;j < 5;j++) {
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					int proposedKey = deterministicRandom()->randomInt(0, self->maxKeySpace);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					if (insertedSet.contains(proposedKey))
															#line 1236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
					{
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						TraceEvent("ConflictRangeClear").detail("Key", proposedKey);
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						insertedSet.erase(proposedKey);
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						tr2.clear(StringRef(format("%010d", proposedKey)));
															#line 1244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
						break;
					}
				}
			}
		}
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr2.commit();
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 7;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 6, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(Version && readVersion,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (self->testReadYourWrites)
															#line 1268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			trRYOW.setVersion(readVersion);
															#line 1272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
		else
		{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			tr3.setVersion(readVersion);
															#line 1278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		for(int i = 0;i < deterministicRandom()->randomInt(self->minOperationsPerTransaction, self->maxOperationsPerTransaction + 1);i++) {
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (randomSets)
															#line 1284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				for(int j = 0;j < 5;j++) {
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					int proposedKey = deterministicRandom()->randomInt(0, self->maxKeySpace);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					if (!insertedSet.contains(proposedKey))
															#line 1292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
					{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						TraceEvent("ConflictRangeSet").detail("Key", proposedKey);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						insertedSet.insert(proposedKey);
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						tr2.set(StringRef(format("%010d", proposedKey)), deterministicRandom()->randomUniqueID().toString());
															#line 1300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
						break;
					}
				}
			}
			else
			{
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				for(int j = 0;j < 5;j++) {
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					int proposedKey = deterministicRandom()->randomInt(0, self->maxKeySpace);
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					if (insertedSet.contains(proposedKey))
															#line 1313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
					{
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						TraceEvent("ConflictRangeClear").detail("Key", proposedKey);
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						insertedSet.erase(proposedKey);
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
						tr2.clear(StringRef(format("%010d", proposedKey)));
															#line 1321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
						break;
					}
				}
			}
		}
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr2.commit();
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont1loopBody1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 7;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 6, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		foundConflict = false;
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		try {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (self->testReadYourWrites)
															#line 1424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				trRYOW.clear(KeyRangeRef(StringRef(format("%010d", clearedBegin)), StringRef(format("%010d", clearedEnd))));
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				StrictFuture<RangeResult> __when_expr_7 = trRYOW.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_7.get(), loopDepth); };
				static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 8;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 7, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				tr3.clear(StringRef(format("%010d", self->maxKeySpace + 1)));
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				StrictFuture<RangeResult> __when_expr_9 = tr3.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont9when2(__when_expr_9.get(), loopDepth); };
				static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 10;
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 9, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		foundConflict = false;
															#line 1469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		try {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (self->testReadYourWrites)
															#line 1473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				trRYOW.clear(KeyRangeRef(StringRef(format("%010d", clearedBegin)), StringRef(format("%010d", clearedEnd))));
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				StrictFuture<RangeResult> __when_expr_7 = trRYOW.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont1loopBody1cont9when1(__when_expr_7.get(), loopDepth); };
				static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 8;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 7, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				tr3.clear(StringRef(format("%010d", self->maxKeySpace + 1)));
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				StrictFuture<RangeResult> __when_expr_9 = tr3.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1loopBody1cont9when2(__when_expr_9.get(), loopDepth); };
				static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 10;
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 9, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont9Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont9Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont1loopBody1cont19(int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (foundConflict)
															#line 1593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (self->testReadYourWrites)
															#line 1597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				tr1.clear(KeyRangeRef(StringRef(format("%010d", clearedBegin)), StringRef(format("%010d", clearedEnd))));
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				StrictFuture<Void> __when_expr_11 = tr1.commit();
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont1loopBody1cont19when1(__when_expr_11.get(), loopDepth); };
				static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 12;
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 11, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont19cont2(loopDepth);
			}
		}
		else
		{
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			StrictFuture<RangeResult> __when_expr_14 = tr4.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont1loopBody1cont19when2(__when_expr_14.get(), loopDepth); };
			static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 15;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 14, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (e.code() != error_code_not_committed)
															#line 1640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(e, loopDepth);
															#line 1644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			foundConflict = true;
															#line 1648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont19(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont20(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont20cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont21(RangeResult const& res,int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_8 = trRYOW.commit();
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont21when1(__when_expr_8.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 9;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 8, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont21(RangeResult && res,int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_8 = trRYOW.commit();
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont1loopBody1cont21when1(__when_expr_8.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 9;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 8, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont21(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont21(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1loopBody1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont1loopBody1cont21cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont21cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont21when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont21cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont21when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont21cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont21when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont21when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1loopBody1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont1loopBody1cont22(RangeResult const& res,int loopDepth) 
	{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_10 = tr3.commit();
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont22when1(__when_expr_10.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 11;
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 10, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont22(RangeResult && res,int loopDepth) 
	{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_10 = tr3.commit();
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont9Catch1(actor_cancelled(), loopDepth);
															#line 1881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1loopBody1cont9Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1loopBody1cont22when1(__when_expr_10.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 11;
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 10, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 1886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when2(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont22(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont9when2(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont22(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 9, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 9, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont9when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 9, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont9when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 9, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1loopBody1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont1loopBody1cont22cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont22cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1loopBody1cont9Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont9Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont9Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont1loopBody1cont20cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont19(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont2(int loopDepth) 
	{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<RangeResult> __when_expr_12 = tr4.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), randomLimit, Snapshot::False, reverse);
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont1loopBody1cont19cont2when1(__when_expr_12.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 13;
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 12, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont3(Void const& _,int loopDepth) 
	{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr1 = Transaction(cx);
															#line 2092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont19cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont3(Void && _,int loopDepth) 
	{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		tr1 = Transaction(cx);
															#line 2101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont19cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont19when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont19when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont1loopBody1cont19cont5(RangeResult const& res,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		++self->withConflicts;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (res.size() == originalResults.size())
															#line 2187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (res[i] != originalResults[i])
															#line 2193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				}
			}
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (originalResults.size() == randomLimit && ((offsetB <= 0 && !reverse) || (offsetA > 1 && reverse)))
															#line 2202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			KeyRef smallestResult = originalResults[0].key;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			KeyRef largestResult = originalResults[originalResults.size() - 1].key;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (reverse)
															#line 2214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				std::swap(smallestResult, largestResult);
															#line 2218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (largestResult >= sentinelKey)
															#line 2222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if ((smallestResult == firstElement || smallestResult == StringRef(format("%010d", *(insertedSet.begin())))) && offsetA < 0)
															#line 2230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if ((myKeyA > myKeyB || (myKeyA == myKeyB && onEqualA && !onEqualB)) && originalResults.size() == randomLimit)
															#line 2238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr1 = "";
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr1 += printable(res[i].key) + " ";
															#line 2250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr2 = "";
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < originalResults.size();i++) {
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr2 += printable(originalResults[i].key) + " ";
															#line 2258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			TraceEvent(SevError, "ConflictRangeError") .detail("Info", "Conflict returned, however results are the same") .detail("RandomSets", randomSets) .detail("MyKeyA", myKeyA) .detail("MyKeyB", myKeyB) .detail("OnEqualA", onEqualA) .detail("OnEqualB", onEqualB) .detail("OffsetA", offsetA) .detail("OffsetB", offsetB) .detail("RandomLimit", randomLimit) .detail("Reverse", reverse) .detail("Size", originalResults.size()) .detail("Results", keyStr1) .detail("Original", keyStr2);
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			tr4 = Transaction(cx);
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			StrictFuture<RangeResult> __when_expr_13 = tr4.getRange( KeyRangeRef(StringRef(format("%010d", 0)), StringRef(format("%010d", self->maxKeySpace))), 200);
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont19cont5when1(__when_expr_13.get(), loopDepth); };
			static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 14;
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 13, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont19cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont5(RangeResult && res,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		++self->withConflicts;
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (res.size() == originalResults.size())
															#line 2289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (res[i] != originalResults[i])
															#line 2295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				}
			}
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (originalResults.size() == randomLimit && ((offsetB <= 0 && !reverse) || (offsetA > 1 && reverse)))
															#line 2304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			KeyRef smallestResult = originalResults[0].key;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			KeyRef largestResult = originalResults[originalResults.size() - 1].key;
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (reverse)
															#line 2316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				std::swap(smallestResult, largestResult);
															#line 2320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (largestResult >= sentinelKey)
															#line 2324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if ((smallestResult == firstElement || smallestResult == StringRef(format("%010d", *(insertedSet.begin())))) && offsetA < 0)
															#line 2332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if ((myKeyA > myKeyB || (myKeyA == myKeyB && onEqualA && !onEqualB)) && originalResults.size() == randomLimit)
															#line 2340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			{
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr1 = "";
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr1 += printable(res[i].key) + " ";
															#line 2352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr2 = "";
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < originalResults.size();i++) {
															#line 319 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr2 += printable(originalResults[i].key) + " ";
															#line 2360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			TraceEvent(SevError, "ConflictRangeError") .detail("Info", "Conflict returned, however results are the same") .detail("RandomSets", randomSets) .detail("MyKeyA", myKeyA) .detail("MyKeyB", myKeyB) .detail("OnEqualA", onEqualA) .detail("OnEqualB", onEqualB) .detail("OffsetA", offsetA) .detail("OffsetB", offsetB) .detail("RandomLimit", randomLimit) .detail("Reverse", reverse) .detail("Size", originalResults.size()) .detail("Results", keyStr1) .detail("Original", keyStr2);
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			tr4 = Transaction(cx);
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			StrictFuture<RangeResult> __when_expr_13 = tr4.getRange( KeyRangeRef(StringRef(format("%010d", 0)), StringRef(format("%010d", self->maxKeySpace))), 200);
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1loopBody1cont1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont1loopBody1cont19cont5when1(__when_expr_13.get(), loopDepth); };
			static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 14;
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 13, RangeResult >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont19cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont2when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont5(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont2when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont5(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 12, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 12, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont19cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 12, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont19cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 12, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont1loopBody1cont19cont6(int loopDepth) 
	{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		return a_body1cont1loopBody1cont1Catch1(not_committed(), loopDepth);
															#line 2464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont7(RangeResult const& res,int loopDepth) 
	{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		std::string allKeyEntries = "";
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			allKeyEntries += printable(res[i].key) + " ";
															#line 2476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		TraceEvent("ConflictRangeDump").setMaxFieldLength(10000).detail("Keys", allKeyEntries);
															#line 2480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont19cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont7(RangeResult && res,int loopDepth) 
	{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		std::string allKeyEntries = "";
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		for(int i = 0;i < res.size();i++) {
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			allKeyEntries += printable(res[i].key) + " ";
															#line 2493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		TraceEvent("ConflictRangeDump").setMaxFieldLength(10000).detail("Keys", allKeyEntries);
															#line 2497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont19cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont5when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont7(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont5when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont7(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 13, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 13, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont19cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 13, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont19cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 13, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont1loopBody1cont19cont20(RangeResult const& res,int loopDepth) 
	{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		++self->withoutConflicts;
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (res.size() == originalResults.size())
															#line 2583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (res[i] != originalResults[i] && !(res[i].key.startsWith("\xff"_sr) && originalResults[i].key.startsWith("\xff"_sr)))
															#line 2589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					TraceEvent(SevError, "ConflictRangeError") .detail("Info", "No conflict returned, however results do not match") .detail("Original", printable(originalResults[i].key) + " " + printable(originalResults[i].value)) .detail("New", printable(res[i].key) + " " + printable(res[i].value));
															#line 2593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr1 = "";
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr1 += printable(res[i].key) + " ";
															#line 2605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr2 = "";
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < originalResults.size();i++) {
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr2 += printable(originalResults[i].key) + " ";
															#line 2613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			TraceEvent(SevError, "ConflictRangeError") .detail("Info", "No conflict returned, however result sizes do not match") .detail("OriginalSize", originalResults.size()) .detail("NewSize", res.size()) .detail("RandomSets", randomSets) .detail("MyKeyA", myKeyA) .detail("MyKeyB", myKeyB) .detail("OnEqualA", onEqualA) .detail("OnEqualB", onEqualB) .detail("OffsetA", offsetA) .detail("OffsetB", offsetB) .detail("RandomLimit", randomLimit) .detail("Reverse", reverse) .detail("Size", originalResults.size()) .detail("Results", keyStr1) .detail("Original", keyStr2);
															#line 2617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont19cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19cont20(RangeResult && res,int loopDepth) 
	{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		++self->withoutConflicts;
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (res.size() == originalResults.size())
															#line 2629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				if (res[i] != originalResults[i] && !(res[i].key.startsWith("\xff"_sr) && originalResults[i].key.startsWith("\xff"_sr)))
															#line 2635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
					TraceEvent(SevError, "ConflictRangeError") .detail("Info", "No conflict returned, however results do not match") .detail("Original", printable(originalResults[i].key) + " " + printable(originalResults[i].value)) .detail("New", printable(res[i].key) + " " + printable(res[i].value));
															#line 2639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr1 = "";
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr1 += printable(res[i].key) + " ";
															#line 2651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			std::string keyStr2 = "";
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			for(int i = 0;i < originalResults.size();i++) {
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
				keyStr2 += printable(originalResults[i].key) + " ";
															#line 2659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
			}
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
			TraceEvent(SevError, "ConflictRangeError") .detail("Info", "No conflict returned, however result sizes do not match") .detail("OriginalSize", originalResults.size()) .detail("NewSize", res.size()) .detail("RandomSets", randomSets) .detail("MyKeyA", myKeyA) .detail("MyKeyB", myKeyB) .detail("OnEqualA", onEqualA) .detail("OnEqualB", onEqualB) .detail("OffsetA", offsetA) .detail("OffsetB", offsetB) .detail("RandomLimit", randomLimit) .detail("Reverse", reverse) .detail("Size", originalResults.size()) .detail("Results", keyStr1) .detail("Original", keyStr2);
															#line 2663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont19cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19when2(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont20(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont19when2(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont19cont20(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 14, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 14, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont19when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 14, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont19when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 14, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont1loopBody1cont19cont21(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_16 = tr2.onError(e2);
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont1when1(__when_expr_16.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 17;
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 16, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_16 = tr2.onError(e2);
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont1when1(__when_expr_16.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 17;
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 16, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_17 = tr3.onError(e2);
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont3when1(__when_expr_17.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 18;
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 17, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3(Void && _,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_17 = tr3.onError(e2);
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont3when1(__when_expr_17.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 18;
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 17, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont1loopBody1cont1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont1loopBody1cont1Catch1cont4(Void const& _,int loopDepth) 
	{
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_18 = tr4.onError(e2);
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont4when1(__when_expr_18.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 19;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 18, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont4(Void && _,int loopDepth) 
	{
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_18 = tr4.onError(e2);
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont4when1(__when_expr_18.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 19;
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 18, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 2998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1cont1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1loopBody1cont1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont1loopBody1cont1Catch1cont5(Void const& _,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_19 = trRYOW.onError(e2);
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont5when1(__when_expr_19.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 20;
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 19, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 3089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont5(Void && _,int loopDepth) 
	{
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		StrictFuture<Void> __when_expr_19 = trRYOW.onError(e2);
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1Catch1cont5when1(__when_expr_19.get(), loopDepth); };
		static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 20;
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< ConflictRangeClientActor, 19, Void >*>(static_cast<ConflictRangeClientActor*>(this)));
															#line 3105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 18, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 18, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1cont1Catch1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 18, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1loopBody1cont1Catch1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 18, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont1loopBody1cont1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1Catch1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<ConflictRangeClientActor*>(this)->actor_wait_state > 0) static_cast<ConflictRangeClientActor*>(this)->actor_wait_state = 0;
		static_cast<ConflictRangeClientActor*>(this)->ActorCallback< ConflictRangeClientActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1loopBody1cont1Catch1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< ConflictRangeClientActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1loopBody1cont1Catch1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< ConflictRangeClientActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), 19);

	}
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Database cx;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	ConflictRangeWorkload* self;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	std::string clientID;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	std::string myKeyA;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	std::string myKeyB;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	std::string myValue;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	bool onEqualA;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	bool onEqualB;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	int offsetA;
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	int offsetB;
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	int randomLimit;
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Reverse reverse;
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	bool randomSets;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	std::set<int> insertedSet;
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	RangeResult originalResults;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Standalone<StringRef> firstElement;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	std::set<int> clearedSet;
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	int clearedBegin;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	int clearedEnd;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Key sentinelKey;
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Transaction tr0;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Transaction tr1;
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Transaction tr2;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Transaction tr3;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Transaction tr4;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	ReadYourWritesTransaction trRYOW;
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	bool foundConflict;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	Error e2;
															#line 3328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
};
// This generated class is to be used only via conflictRangeClient()
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
class ConflictRangeClientActor final : public Actor<Void>, public ActorCallback< ConflictRangeClientActor, 0, Void >, public ActorCallback< ConflictRangeClientActor, 1, Void >, public ActorCallback< ConflictRangeClientActor, 2, Void >, public ActorCallback< ConflictRangeClientActor, 3, RangeResult >, public ActorCallback< ConflictRangeClientActor, 4, Void >, public ActorCallback< ConflictRangeClientActor, 5, Version >, public ActorCallback< ConflictRangeClientActor, 6, Void >, public ActorCallback< ConflictRangeClientActor, 7, RangeResult >, public ActorCallback< ConflictRangeClientActor, 8, Void >, public ActorCallback< ConflictRangeClientActor, 9, RangeResult >, public ActorCallback< ConflictRangeClientActor, 10, Void >, public ActorCallback< ConflictRangeClientActor, 11, Void >, public ActorCallback< ConflictRangeClientActor, 12, RangeResult >, public ActorCallback< ConflictRangeClientActor, 13, RangeResult >, public ActorCallback< ConflictRangeClientActor, 14, RangeResult >, public ActorCallback< ConflictRangeClientActor, 15, Void >, public ActorCallback< ConflictRangeClientActor, 16, Void >, public ActorCallback< ConflictRangeClientActor, 17, Void >, public ActorCallback< ConflictRangeClientActor, 18, Void >, public ActorCallback< ConflictRangeClientActor, 19, Void >, public FastAllocated<ConflictRangeClientActor>, public ConflictRangeClientActorState<ConflictRangeClientActor> {
															#line 3333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
public:
	using FastAllocated<ConflictRangeClientActor>::operator new;
	using FastAllocated<ConflictRangeClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15078939042772270592UL, 16335179825075852800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConflictRangeClientActor, 0, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 1, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 2, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 3, RangeResult >;
friend struct ActorCallback< ConflictRangeClientActor, 4, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 5, Version >;
friend struct ActorCallback< ConflictRangeClientActor, 6, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 7, RangeResult >;
friend struct ActorCallback< ConflictRangeClientActor, 8, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 9, RangeResult >;
friend struct ActorCallback< ConflictRangeClientActor, 10, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 11, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 12, RangeResult >;
friend struct ActorCallback< ConflictRangeClientActor, 13, RangeResult >;
friend struct ActorCallback< ConflictRangeClientActor, 14, RangeResult >;
friend struct ActorCallback< ConflictRangeClientActor, 15, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 16, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 17, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 18, Void >;
friend struct ActorCallback< ConflictRangeClientActor, 19, Void >;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	ConflictRangeClientActor(Database const& cx,ConflictRangeWorkload* const& self) 
															#line 3369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
		 : Actor<Void>(),
		   ConflictRangeClientActorState<ConflictRangeClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("conflictRangeClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2087776482508201472UL, 1196108324755155712UL);
		ActorExecutionContextHelper __helper(static_cast<ConflictRangeClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("conflictRangeClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("conflictRangeClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 5, Version >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 9, RangeResult >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 12, RangeResult >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 13, RangeResult >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 14, RangeResult >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 18, Void >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< ConflictRangeClientActor, 19, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
[[nodiscard]] Future<Void> conflictRangeClient( Database const& cx, ConflictRangeWorkload* const& self ) {
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
	return Future<Void>(new ConflictRangeClientActor(cx, self));
															#line 3420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ConflictRange.actor.g.cpp"
}

#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/ConflictRange.actor.cpp"
};

WorkloadFactory<ConflictRangeWorkload> ConflictRangeWorkloadFactory;
