#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
/*
 * TagPartitionedLogSystemRecoveryTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TagPartitionedLogSystem.actor.h"
#include "flow/UnitTest.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

Reference<LogSet> makeSingleLogSet(const std::vector<TLogInterface>& tlogs, bool isLocal = true) {
	Reference<LogSet> logSet = makeReference<LogSet>();
	logSet->isLocal = isLocal;
	for (const auto& tlog : tlogs) {
		logSet->logServers.push_back(
		    makeReference<AsyncVar<OptionalInterface<TLogInterface>>>(OptionalInterface<TLogInterface>(tlog)));
	}
	return logSet;
}

std::tuple<int, std::vector<TLogLockResult>, bool> makeLogGroupResults(
    int replicationFactor,
    const std::vector<std::vector<UnknownCommittedVersions>>& perTLogUCV,
    const std::vector<TLogInterface>& tlogs,
    bool nonAvailableTLogsCompletePolicy = true,
    const std::vector<Version>& knownCommitted = {}) {
	std::vector<TLogLockResult> lockResults;
	lockResults.reserve(tlogs.size());
	for (int i = 0; i < tlogs.size(); ++i) {
		TLogLockResult result;
		result.logId = tlogs[i].id();
		result.knownCommittedVersion = (i < knownCommitted.size()) ? knownCommitted[i] : 0;
		for (const auto& ucv : perTLogUCV[i]) {
			result.unknownCommittedVersions.push_back(ucv);
		}
		lockResults.push_back(result);
	}
	return std::make_tuple(replicationFactor, std::move(lockResults), nonAvailableTLogsCompletePolicy);
}

} // namespace

															#line 62 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase60()
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase60Actor>
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase60ActorState {
															#line 69 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase60ActorState(UnitTestParameters const& params) 
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 76 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase60", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase60ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase60", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase60Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase60ActorState(); static_cast<FlowTestCase60Actor*>(this)->destroy(); return 0; }
															#line 95 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase60Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase60ActorState();
				static_cast<FlowTestCase60Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv }, { ucv } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "SimpleTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "SimpleTestRecoverVersionFailed").detail("Expected", 110).detail("Got", recoverVersion);
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase60Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase60ActorState(); static_cast<FlowTestCase60Actor*>(this)->destroy(); return 0; }
															#line 145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase60Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase60ActorState();
			static_cast<FlowTestCase60Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase60ActorState();
		static_cast<FlowTestCase60Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase60()
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase60Actor final : public Actor<Void>, public FastAllocated<FlowTestCase60Actor>, public FlowTestCase60ActorState<FlowTestCase60Actor> {
															#line 174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase60Actor>::operator new;
	using FastAllocated<FlowTestCase60Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12680349185177640704UL, 3790240622704730624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase60Actor(UnitTestParameters const& params) 
															#line 190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase60ActorState<FlowTestCase60Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase60", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(581146440781332992UL, 16303371015218125056UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase60Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase60");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase60", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase60( UnitTestParameters const& params ) {
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase60Actor(params));
															#line 222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase60, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/Simple")

#line 93 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase94()
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase94Actor>
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase94ActorState {
															#line 235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase94ActorState(UnitTestParameters const& params) 
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase94", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase94ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase94", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase94Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase94ActorState(); static_cast<FlowTestCase94Actor*>(this)->destroy(); return 0; }
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase94Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase94ActorState();
				static_cast<FlowTestCase94Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { {}, {} }, { tlogA, tlogB }, true, { 80, 90 });
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 70;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 90)
															#line 289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "FallbackTestMaxKCVFailed").detail("Expected", 90).detail("Got", maxKCV);
															#line 293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 90);
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 90)
															#line 299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "FallbackTestRecoverVersionFailed").detail("Expected", 90).detail("Got", recoverVersion);
															#line 303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 90);
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase94Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase94ActorState(); static_cast<FlowTestCase94Actor*>(this)->destroy(); return 0; }
															#line 309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase94Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase94ActorState();
			static_cast<FlowTestCase94Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase94ActorState();
		static_cast<FlowTestCase94Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase94()
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase94Actor final : public Actor<Void>, public FastAllocated<FlowTestCase94Actor>, public FlowTestCase94ActorState<FlowTestCase94Actor> {
															#line 338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase94Actor>::operator new;
	using FastAllocated<FlowTestCase94Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6237794194999471360UL, 16026951357306907904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase94Actor(UnitTestParameters const& params) 
															#line 354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase94ActorState<FlowTestCase94Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase94", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7160343916971339008UL, 16531539115448735232UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase94Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase94");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase94", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase94( UnitTestParameters const& params ) {
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase94Actor(params));
															#line 386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase94, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/FallbackToMaxKCV")

#line 124 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase125()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase125Actor>
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase125ActorState {
															#line 399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase125ActorState(UnitTestParameters const& params) 
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase125", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase125ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase125", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase125Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase125ActorState(); static_cast<FlowTestCase125Actor*>(this)->destroy(); return 0; }
															#line 425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase125Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase125ActorState();
				static_cast<FlowTestCase125Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucvLate(120, 110, std::vector<uint16_t>{ 0, 1 });
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv, ucvLate }, { ucv } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MissingDeliveryTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MissingDeliveryTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "tlogB did not receive version 120");
															#line 471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase125Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase125ActorState(); static_cast<FlowTestCase125Actor*>(this)->destroy(); return 0; }
															#line 477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase125Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase125ActorState();
			static_cast<FlowTestCase125Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase125ActorState();
		static_cast<FlowTestCase125Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase125()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase125Actor final : public Actor<Void>, public FastAllocated<FlowTestCase125Actor>, public FlowTestCase125ActorState<FlowTestCase125Actor> {
															#line 506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase125Actor>::operator new;
	using FastAllocated<FlowTestCase125Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6821142523464125184UL, 10443134577735076352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase125Actor(UnitTestParameters const& params) 
															#line 522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase125ActorState<FlowTestCase125Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase125", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7999563576076191488UL, 16039155595118015744UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase125Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase125");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase125", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase125( UnitTestParameters const& params ) {
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase125Actor(params));
															#line 554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase125, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/HaltOnMissingDelivery")

#line 162 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase163()
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase163Actor>
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase163ActorState {
															#line 567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase163ActorState(UnitTestParameters const& params) 
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase163", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase163ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase163", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase163Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase163ActorState(); static_cast<FlowTestCase163Actor*>(this)->destroy(); return 0; }
															#line 593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase163Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase163ActorState();
				static_cast<FlowTestCase163Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv2(120, 110, std::vector<uint16_t>{ 0, 1 });
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv, ucv2 }, { ucv } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PolicyNotSatisfiedTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PolicyNotSatisfiedTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Version 120 sent to both tLogs but only received by 1 (RF=2)");
															#line 639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase163Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase163ActorState(); static_cast<FlowTestCase163Actor*>(this)->destroy(); return 0; }
															#line 645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase163Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase163ActorState();
			static_cast<FlowTestCase163Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase163ActorState();
		static_cast<FlowTestCase163Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase163()
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase163Actor final : public Actor<Void>, public FastAllocated<FlowTestCase163Actor>, public FlowTestCase163ActorState<FlowTestCase163Actor> {
															#line 674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase163Actor>::operator new;
	using FastAllocated<FlowTestCase163Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16972641351036085760UL, 16658271003723686144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase163Actor(UnitTestParameters const& params) 
															#line 690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase163ActorState<FlowTestCase163Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase163", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12050036035296398592UL, 4823101645924892928UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase163Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase163");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase163", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase163( UnitTestParameters const& params ) {
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase163Actor(params));
															#line 722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase163, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/PolicyNotSatisfied")

#line 200 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase201()
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase201Actor>
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase201ActorState {
															#line 735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase201ActorState(UnitTestParameters const& params) 
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase201", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase201ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase201", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase201Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase201ActorState(); static_cast<FlowTestCase201Actor*>(this)->destroy(); return 0; }
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase201Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase201ActorState();
				static_cast<FlowTestCase201Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(95, 90, std::vector<uint16_t>{ 0, 1 });
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv }, { ucv } }, { tlogA, tlogB }, true, { 90, 90 });
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 80;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 90)
															#line 791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MinDVRespectedTestMaxKCVFailed").detail("Expected", 90).detail("Got", maxKCV);
															#line 795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 90);
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 95)
															#line 801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MinDVRespectedTestRecoverVersionFailed") .detail("Expected", 95) .detail("Got", recoverVersion) .detail("MinDV", minDV) .detail("MaxKCV", maxKCV);
															#line 805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 95);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase201Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase201ActorState(); static_cast<FlowTestCase201Actor*>(this)->destroy(); return 0; }
															#line 811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase201Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase201ActorState();
			static_cast<FlowTestCase201Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase201ActorState();
		static_cast<FlowTestCase201Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase201()
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase201Actor final : public Actor<Void>, public FastAllocated<FlowTestCase201Actor>, public FlowTestCase201ActorState<FlowTestCase201Actor> {
															#line 840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase201Actor>::operator new;
	using FastAllocated<FlowTestCase201Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5898544091215948800UL, 14729280551634754048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase201Actor(UnitTestParameters const& params) 
															#line 856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase201ActorState<FlowTestCase201Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase201", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7267332707161508096UL, 679722651989966848UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase201Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase201");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase201", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase201( UnitTestParameters const& params ) {
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase201Actor(params));
															#line 888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase201, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/MinDVRespected")

#line 236 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase237()
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase237Actor>
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase237ActorState {
															#line 901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase237ActorState(UnitTestParameters const& params) 
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase237", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase237ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase237", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase237Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase237ActorState(); static_cast<FlowTestCase237Actor*>(this)->destroy(); return 0; }
															#line 927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase237Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase237ActorState();
				static_cast<FlowTestCase237Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv110(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv120(120, 115, std::vector<uint16_t>{ 0, 1 });
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv110, ucv120 }, { ucv110, ucv120 } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "BrokenChainTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "BrokenChainTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Version 120 has prevVersion=115, expected 110");
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase237Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase237ActorState(); static_cast<FlowTestCase237Actor*>(this)->destroy(); return 0; }
															#line 979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase237Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase237ActorState();
			static_cast<FlowTestCase237Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase237ActorState();
		static_cast<FlowTestCase237Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase237()
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase237Actor final : public Actor<Void>, public FastAllocated<FlowTestCase237Actor>, public FlowTestCase237ActorState<FlowTestCase237Actor> {
															#line 1008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase237Actor>::operator new;
	using FastAllocated<FlowTestCase237Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3313948420907820800UL, 3449150412953932800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase237Actor(UnitTestParameters const& params) 
															#line 1024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase237ActorState<FlowTestCase237Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase237", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11954795935256850176UL, 7856017942059194112UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase237Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase237");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase237", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase237( UnitTestParameters const& params ) {
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase237Actor(params));
															#line 1056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase237, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/BrokenChain")

#line 275 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase276()
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase276Actor>
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase276ActorState {
															#line 1069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase276ActorState(UnitTestParameters const& params) 
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase276", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase276ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase276", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase276Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase276ActorState(); static_cast<FlowTestCase276Actor*>(this)->destroy(); return 0; }
															#line 1095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase276Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase276ActorState();
				static_cast<FlowTestCase276Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface primary1(locality), primary2(locality);
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface satellite1(locality), satellite2(locality);
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ primary1, primary2 }, true), makeSingleLogSet({ satellite1, satellite2 }, false) };
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv }, { ucv } }, { primary1, primary2 }, true, { 100, 100 });
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MultipleLogSetsTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 1129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 1135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "MultipleLogSetsTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("NumLogSets", logServers.size());
															#line 1139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase276Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase276ActorState(); static_cast<FlowTestCase276Actor*>(this)->destroy(); return 0; }
															#line 1145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase276Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase276ActorState();
			static_cast<FlowTestCase276Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase276ActorState();
		static_cast<FlowTestCase276Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase276()
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase276Actor final : public Actor<Void>, public FastAllocated<FlowTestCase276Actor>, public FlowTestCase276ActorState<FlowTestCase276Actor> {
															#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase276Actor>::operator new;
	using FastAllocated<FlowTestCase276Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8406658761233925376UL, 11459690148996289792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase276Actor(UnitTestParameters const& params) 
															#line 1190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase276ActorState<FlowTestCase276Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase276", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9781068012537641216UL, 16734461310843978496UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase276Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase276");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase276", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase276( UnitTestParameters const& params ) {
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase276Actor(params));
															#line 1222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase276, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/MultipleLogSets")

#line 314 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase315()
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase315Actor>
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase315ActorState {
															#line 1235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase315ActorState(UnitTestParameters const& params) 
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase315", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase315ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase315", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase315Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase315ActorState(); static_cast<FlowTestCase315Actor*>(this)->destroy(); return 0; }
															#line 1261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase315Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase315ActorState();
				static_cast<FlowTestCase315Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality), tlogB(locality), tlogC(locality);
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB, tlogC }) };
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv110(110, 100, std::vector<uint16_t>{ 0, 1, 2 });
															#line 327 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv120(120, 110, std::vector<uint16_t>{ 0, 1, 2 });
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults( 3, { { ucv110, ucv120 }, { ucv110, ucv120 }, { ucv110 } }, { tlogA, tlogB, tlogC }, false, { 100, 100, 100 });
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PartialAvailabilityTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 1295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 1301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "PartialAvailabilityTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Only 2 of 3 tLogs received version 120 (RF=3)");
															#line 1305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase315Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase315ActorState(); static_cast<FlowTestCase315Actor*>(this)->destroy(); return 0; }
															#line 1311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase315Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase315ActorState();
			static_cast<FlowTestCase315Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase315ActorState();
		static_cast<FlowTestCase315Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase315()
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase315Actor final : public Actor<Void>, public FastAllocated<FlowTestCase315Actor>, public FlowTestCase315ActorState<FlowTestCase315Actor> {
															#line 1340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase315Actor>::operator new;
	using FastAllocated<FlowTestCase315Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14735850475267092736UL, 5045803214563854592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase315Actor(UnitTestParameters const& params) 
															#line 1356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase315ActorState<FlowTestCase315Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase315", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8691705209224595968UL, 12806436817554523648UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase315Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase315");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase315", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase315( UnitTestParameters const& params ) {
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase315Actor(params));
															#line 1388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase315, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/PartialAvailabilityPolicyFail")

#line 353 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase354()
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase354Actor>
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase354ActorState {
															#line 1401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase354ActorState(UnitTestParameters const& params) 
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase354", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase354ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase354", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase354Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase354ActorState(); static_cast<FlowTestCase354Actor*>(this)->destroy(); return 0; }
															#line 1427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase354Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase354ActorState();
				static_cast<FlowTestCase354Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB }) };
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv80(80, 70, std::vector<uint16_t>{ 0, 1 });
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv80 }, { ucv80 } }, { tlogA, tlogB }, true, { 100, 100 });
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 375 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "VersionsBelowMaxKCVTestMaxKCVFailed").detail("Expected", 100).detail("Got", maxKCV);
															#line 1461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 100)
															#line 1467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "VersionsBelowMaxKCVTestRecoverVersionFailed") .detail("Expected", 100) .detail("Got", recoverVersion) .detail("Reason", "All UCVs below maxKCV should be filtered");
															#line 1471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 100);
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase354Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase354ActorState(); static_cast<FlowTestCase354Actor*>(this)->destroy(); return 0; }
															#line 1477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase354Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase354ActorState();
			static_cast<FlowTestCase354Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase354ActorState();
		static_cast<FlowTestCase354Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase354()
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase354Actor final : public Actor<Void>, public FastAllocated<FlowTestCase354Actor>, public FlowTestCase354ActorState<FlowTestCase354Actor> {
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase354Actor>::operator new;
	using FastAllocated<FlowTestCase354Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6686450588064056832UL, 15117359325732815104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase354Actor(UnitTestParameters const& params) 
															#line 1522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase354ActorState<FlowTestCase354Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase354", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13732710272036525824UL, 9408936190713591552UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase354Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase354");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase354", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase354( UnitTestParameters const& params ) {
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase354Actor(params));
															#line 1554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase354, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/VersionsBelowMaxKCV")

#line 390 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"

															#line 1560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase391()
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
template <class FlowTestCase391Actor>
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase391ActorState {
															#line 1567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase391ActorState(UnitTestParameters const& params) 
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
		 : params(params)
															#line 1574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase391", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase391ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase391", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 1589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				if (!static_cast<FlowTestCase391Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase391ActorState(); static_cast<FlowTestCase391Actor*>(this)->destroy(); return 0; }
															#line 1593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
				new (&static_cast<FlowTestCase391Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase391ActorState();
				static_cast<FlowTestCase391Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			LocalityData locality;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogA(locality);
															#line 401 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogB(locality);
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogC(locality);
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			TLogInterface tlogD(locality);
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			std::vector<Reference<LogSet>> logServers{ makeSingleLogSet({ tlogA, tlogB, tlogC, tlogD }) };
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv110(110, 100, std::vector<uint16_t>{ 0, 1 });
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv115(115, 112, std::vector<uint16_t>{ 0 });
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv120(120, 118, std::vector<uint16_t>{ 0, 1 });
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			UnknownCommittedVersions ucv125(125, 120, std::vector<uint16_t>{ 0 });
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			auto logGroupResults = makeLogGroupResults(2, { { ucv110, ucv115, ucv120, ucv125 }, { ucv110, ucv120 }, {}, {} }, { tlogA, tlogB, tlogC, tlogD }, true, { 100, 100, 100, 100 });
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version minDV = 90;
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Optional<std::tuple<Version, Version>> result = getRecoverVersionUnicast(logServers, logGroupResults, minDV);
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(result.present());
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version maxKCV = std::get<0>(result.get());
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			Version recoverVersion = std::get<1>(result.get());
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (maxKCV != 100)
															#line 1633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "RandomVersionsPartialDeliveryTestMaxKCVFailed") .detail("Expected", 100) .detail("Got", maxKCV);
															#line 1637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(maxKCV == 100);
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (recoverVersion != 110)
															#line 1643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			{
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
				TraceEvent(SevError, "RandomVersionsPartialDeliveryTestRecoverVersionFailed") .detail("Expected", 110) .detail("Got", recoverVersion) .detail("Reason", "Missing versions 112 and 118, break recovery before 120. " "Version 115 received by only tlogA (subset), also breaks recovery before 120. ");
															#line 1647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			}
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			ASSERT(recoverVersion == 110);
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
			if (!static_cast<FlowTestCase391Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase391ActorState(); static_cast<FlowTestCase391Actor*>(this)->destroy(); return 0; }
															#line 1653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
			new (&static_cast<FlowTestCase391Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase391ActorState();
			static_cast<FlowTestCase391Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase391ActorState();
		static_cast<FlowTestCase391Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	UnitTestParameters params;
															#line 1677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase391()
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
class FlowTestCase391Actor final : public Actor<Void>, public FastAllocated<FlowTestCase391Actor>, public FlowTestCase391ActorState<FlowTestCase391Actor> {
															#line 1682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase391Actor>::operator new;
	using FastAllocated<FlowTestCase391Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8970158072602956544UL, 2486009990549405184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	FlowTestCase391Actor(UnitTestParameters const& params) 
															#line 1698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase391ActorState<FlowTestCase391Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase391", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12248051868039835904UL, 155506184027778560UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase391Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase391");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase391", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
static Future<Void> flowTestCase391( UnitTestParameters const& params ) {
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
	return Future<Void>(new FlowTestCase391Actor(params));
															#line 1730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase391, "/TagPartitionedLogSystem/GetRecoverVersionUnicast/RandomVersionsPartialDelivery")

#line 460 "/Users/ec2-user/foundationdb/fdbserver/TagPartitionedLogSystemRecoveryTests.actor.cpp"
