#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
/*
 * RunRYWTransaction.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_RUNRYWTRANSACTION_ACTOR_G_H)
#define FDBCLIENT_RUNRYWTRANSACTION_ACTOR_G_H
#include "fdbclient/RunRYWTransaction.actor.g.h"
#elif !defined(FDBCLIENT_RUNRYWTRANSACTION_ACTOR_H)
#define FDBCLIENT_RUNRYWTRANSACTION_ACTOR_H

#include <utility>

#include "flow/flow.h"
#include "fdbclient/RunTransaction.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Runs a RYW transaction in a retry loop on the given Database.
//
// Takes a function func that accepts a Reference<ReadYourWritesTransaction> as a parameter and returns a non-Void
// Future. This function is run inside the transaction, and when the transaction is successfully committed the result of
// the function is returned.
//
// The supplied function should be idempotent. Otherwise, outcome of this function will depend on how many times the
// transaction is retried.
															#line 48 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
namespace {
// This generated class is to be used only via runRYWTransaction()
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function, class RunRYWTransactionActor>
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionActorState {
															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionActorState(Database const& cx,Function const& func) 
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		 : cx(cx),
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   func(func),
															#line 50 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   tr(new ReadYourWritesTransaction(cx))
															#line 66 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
	{
		fdb_probe_actor_create("runRYWTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RunRYWTransactionActorState() 
	{
		fdb_probe_actor_destroy("runRYWTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 51 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			;
															#line 81 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRYWTransactionActorState();
		static_cast<RunRYWTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 53 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> __when_expr_0 = func(tr);
															#line 53 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunRYWTransactionActor*>(this)->actor_wait_state = 1;
															#line 53 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*>(static_cast<RunRYWTransactionActor*>(this)));
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 58 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 58 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunRYWTransactionActor*>(this)->actor_wait_state = 3;
															#line 58 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionActor, 2, Void >*>(static_cast<RunRYWTransactionActor*>(this)));
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 55 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 55 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (static_cast<RunRYWTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunRYWTransactionActor*>(this)->actor_wait_state = 2;
															#line 55 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionActor, 1, Void >*>(static_cast<RunRYWTransactionActor*>(this)));
															#line 170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& __result,int loopDepth) 
	{
															#line 53 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		result = __result;
															#line 179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRYWTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionActor*>(this)->ActorCallback< RunRYWTransactionActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionActorState(); static_cast<RunRYWTransactionActor*>(this)->destroy(); return 0; }
															#line 258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionActorState();
		static_cast<RunRYWTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionActorState(); static_cast<RunRYWTransactionActor*>(this)->destroy(); return 0; }
															#line 270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionActorState();
		static_cast<RunRYWTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRYWTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionActor*>(this)->ActorCallback< RunRYWTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunRYWTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionActor*>(this)->ActorCallback< RunRYWTransactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Database cx;
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Function func;
															#line 50 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Reference<ReadYourWritesTransaction> tr;
															#line 53 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) result;
															#line 448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
};
// This generated class is to be used only via runRYWTransaction()
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionActor final : public Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>, public ActorCallback< RunRYWTransactionActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >, public ActorCallback< RunRYWTransactionActor<Function>, 1, Void >, public ActorCallback< RunRYWTransactionActor<Function>, 2, Void >, public FastAllocated<RunRYWTransactionActor<Function>>, public RunRYWTransactionActorState<Function, RunRYWTransactionActor<Function>> {
															#line 455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
	using FastAllocated<RunRYWTransactionActor<Function>>::operator new;
	using FastAllocated<RunRYWTransactionActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13092344450457520128UL, 14931033929085947648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRYWTransactionActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >;
friend struct ActorCallback< RunRYWTransactionActor<Function>, 1, Void >;
friend struct ActorCallback< RunRYWTransactionActor<Function>, 2, Void >;
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionActor(Database const& cx,Function const& func) 
															#line 474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		 : Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(),
		   RunRYWTransactionActorState<Function, RunRYWTransactionActor<Function>>(cx, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRYWTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7494342208880196352UL, 17429702160901737728UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRYWTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRYWTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRYWTransactionActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRYWTransactionActor<Function>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunRYWTransactionActor<Function>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
[[nodiscard]] Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> runRYWTransaction( Database const& cx, Function const& func ) {
															#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	return Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(new RunRYWTransactionActor<Function>(cx, func));
															#line 511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
}

#line 62 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"

// Debug version of runRYWTransaction. It logs the function name and the committed version of the transaction.
// Note the function name is required, e.g., taskFunc->getName() for TaskFuncBase.
															#line 518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
namespace {
// This generated class is to be used only via runRYWTransactionDebug()
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function, class RunRYWTransactionDebugActor>
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionDebugActorState {
															#line 525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionDebugActorState(Database const& cx,StringRef const& name,Function const& func) 
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		 : cx(cx),
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   name(name),
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   func(func),
															#line 68 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   tr(new ReadYourWritesTransaction(cx))
															#line 538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
	{
		fdb_probe_actor_create("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this));

	}
	~RunRYWTransactionDebugActorState() 
	{
		fdb_probe_actor_destroy("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			;
															#line 553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRYWTransactionDebugActorState();
		static_cast<RunRYWTransactionDebugActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 72 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> __when_expr_0 = func(tr);
															#line 72 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state = 1;
															#line 72 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionDebugActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*>(static_cast<RunRYWTransactionDebugActor*>(this)));
															#line 591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 80 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 80 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state = 3;
															#line 80 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionDebugActor, 2, Void >*>(static_cast<RunRYWTransactionDebugActor*>(this)));
															#line 620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 74 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 74 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state = 2;
															#line 74 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionDebugActor, 1, Void >*>(static_cast<RunRYWTransactionDebugActor*>(this)));
															#line 642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& __result,int loopDepth) 
	{
															#line 72 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		result = __result;
															#line 651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionDebugActor*>(this)->ActorCallback< RunRYWTransactionDebugActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionDebugActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionDebugActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionDebugActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 75 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		TraceEvent("DebugRunRYWTransaction") .detail("Function", name) .detail("CommitVersion", tr->getCommittedVersion());
															#line 78 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionDebugActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionDebugActorState(); static_cast<RunRYWTransactionDebugActor*>(this)->destroy(); return 0; }
															#line 732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionDebugActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionDebugActorState();
		static_cast<RunRYWTransactionDebugActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 75 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		TraceEvent("DebugRunRYWTransaction") .detail("Function", name) .detail("CommitVersion", tr->getCommittedVersion());
															#line 78 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionDebugActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionDebugActorState(); static_cast<RunRYWTransactionDebugActor*>(this)->destroy(); return 0; }
															#line 746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionDebugActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionDebugActorState();
		static_cast<RunRYWTransactionDebugActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionDebugActor*>(this)->ActorCallback< RunRYWTransactionDebugActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionDebugActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionDebugActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionDebugActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionDebugActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionDebugActor*>(this)->ActorCallback< RunRYWTransactionDebugActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionDebugActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionDebugActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionDebugActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Database cx;
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	StringRef name;
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Function func;
															#line 68 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Reference<ReadYourWritesTransaction> tr;
															#line 72 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) result;
															#line 926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
};
// This generated class is to be used only via runRYWTransactionDebug()
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionDebugActor final : public Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>, public ActorCallback< RunRYWTransactionDebugActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >, public ActorCallback< RunRYWTransactionDebugActor<Function>, 1, Void >, public ActorCallback< RunRYWTransactionDebugActor<Function>, 2, Void >, public FastAllocated<RunRYWTransactionDebugActor<Function>>, public RunRYWTransactionDebugActorState<Function, RunRYWTransactionDebugActor<Function>> {
															#line 933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
	using FastAllocated<RunRYWTransactionDebugActor<Function>>::operator new;
	using FastAllocated<RunRYWTransactionDebugActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8341031875819969792UL, 7051932645559423232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRYWTransactionDebugActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >;
friend struct ActorCallback< RunRYWTransactionDebugActor<Function>, 1, Void >;
friend struct ActorCallback< RunRYWTransactionDebugActor<Function>, 2, Void >;
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionDebugActor(Database const& cx,StringRef const& name,Function const& func) 
															#line 952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		 : Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(),
		   RunRYWTransactionDebugActorState<Function, RunRYWTransactionDebugActor<Function>>(cx, name, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9439272360505286144UL, 11681129204715301120UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionDebugActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRYWTransactionDebug");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRYWTransactionDebug", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRYWTransactionDebugActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRYWTransactionDebugActor<Function>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunRYWTransactionDebugActor<Function>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
[[nodiscard]] Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> runRYWTransactionDebug( Database const& cx, StringRef const& name, Function const& func ) {
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	return Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(new RunRYWTransactionDebugActor<Function>(cx, name, func));
															#line 989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
}

#line 84 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"

// Runs a RYW transaction in a retry loop on the given Database.
//
// Takes a function func that accepts a Reference<ReadYourWritesTransaction> as a parameter and returns a Void
// Future. This function is run inside the transaction.
//
// The supplied function should be idempotent. Otherwise, outcome of this function will depend on how many times the
// transaction is retried.
															#line 1001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
namespace {
// This generated class is to be used only via runRYWTransactionVoid()
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function, class RunRYWTransactionVoidActor>
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionVoidActorState {
															#line 1008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionVoidActorState(Database const& cx,Function const& func) 
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		 : cx(cx),
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   func(func),
															#line 94 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   tr(new ReadYourWritesTransaction(cx))
															#line 1019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
	{
		fdb_probe_actor_create("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this));

	}
	~RunRYWTransactionVoidActorState() 
	{
		fdb_probe_actor_destroy("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			;
															#line 1034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRYWTransactionVoidActorState();
		static_cast<RunRYWTransactionVoidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<Void> __when_expr_0 = func(tr);
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state = 1;
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionVoidActor, 0, Void >*>(static_cast<RunRYWTransactionVoidActor*>(this)));
															#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 101 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 101 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state = 3;
															#line 101 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionVoidActor, 2, Void >*>(static_cast<RunRYWTransactionVoidActor*>(this)));
															#line 1101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state = 2;
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionVoidActor, 1, Void >*>(static_cast<RunRYWTransactionVoidActor*>(this)));
															#line 1123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state = 2;
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionVoidActor, 1, Void >*>(static_cast<RunRYWTransactionVoidActor*>(this)));
															#line 1139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionVoidActor*>(this)->ActorCallback< RunRYWTransactionVoidActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionVoidActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionVoidActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionVoidActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionVoidActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRYWTransactionVoidActorState(); static_cast<RunRYWTransactionVoidActor*>(this)->destroy(); return 0; }
															#line 1223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionVoidActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunRYWTransactionVoidActorState();
		static_cast<RunRYWTransactionVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionVoidActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRYWTransactionVoidActorState(); static_cast<RunRYWTransactionVoidActor*>(this)->destroy(); return 0; }
															#line 1235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionVoidActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunRYWTransactionVoidActorState();
		static_cast<RunRYWTransactionVoidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionVoidActor*>(this)->ActorCallback< RunRYWTransactionVoidActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionVoidActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionVoidActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionVoidActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionVoidActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionVoidActor*>(this)->ActorCallback< RunRYWTransactionVoidActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionVoidActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionVoidActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionVoidActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Database cx;
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Function func;
															#line 94 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Reference<ReadYourWritesTransaction> tr;
															#line 1411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
};
// This generated class is to be used only via runRYWTransactionVoid()
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionVoidActor final : public Actor<Void>, public ActorCallback< RunRYWTransactionVoidActor<Function>, 0, Void >, public ActorCallback< RunRYWTransactionVoidActor<Function>, 1, Void >, public ActorCallback< RunRYWTransactionVoidActor<Function>, 2, Void >, public FastAllocated<RunRYWTransactionVoidActor<Function>>, public RunRYWTransactionVoidActorState<Function, RunRYWTransactionVoidActor<Function>> {
															#line 1418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
	using FastAllocated<RunRYWTransactionVoidActor<Function>>::operator new;
	using FastAllocated<RunRYWTransactionVoidActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15339984281234434048UL, 14678500811917533440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRYWTransactionVoidActor<Function>, 0, Void >;
friend struct ActorCallback< RunRYWTransactionVoidActor<Function>, 1, Void >;
friend struct ActorCallback< RunRYWTransactionVoidActor<Function>, 2, Void >;
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionVoidActor(Database const& cx,Function const& func) 
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		 : Actor<Void>(),
		   RunRYWTransactionVoidActorState<Function, RunRYWTransactionVoidActor<Function>>(cx, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7820160904235108608UL, 13965432267344630272UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionVoidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRYWTransactionVoid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRYWTransactionVoid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRYWTransactionVoidActor<Function>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRYWTransactionVoidActor<Function>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunRYWTransactionVoidActor<Function>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
[[nodiscard]] Future<Void> runRYWTransactionVoid( Database const& cx, Function const& func ) {
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	return Future<Void>(new RunRYWTransactionVoidActor<Function>(cx, func));
															#line 1474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
}

#line 105 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"

															#line 1479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
namespace {
// This generated class is to be used only via runRYWTransactionFailIfLocked()
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function, class RunRYWTransactionFailIfLockedActor>
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionFailIfLockedActorState {
															#line 1486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionFailIfLockedActorState(Database const& cx,Function const& func) 
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		 : cx(cx),
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   func(func),
															#line 109 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   tr(new ReadYourWritesTransaction(cx))
															#line 1497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
	{
		fdb_probe_actor_create("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this));

	}
	~RunRYWTransactionFailIfLockedActorState() 
	{
		fdb_probe_actor_destroy("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			;
															#line 1512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRYWTransactionFailIfLockedActorState();
		static_cast<RunRYWTransactionFailIfLockedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> __when_expr_0 = func(tr);
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state = 1;
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionFailIfLockedActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*>(static_cast<RunRYWTransactionFailIfLockedActor*>(this)));
															#line 1550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (e.code() == error_code_database_locked)
															#line 1572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			{
															#line 118 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			}
															#line 119 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 119 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state = 3;
															#line 119 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionFailIfLockedActor, 2, Void >*>(static_cast<RunRYWTransactionFailIfLockedActor*>(this)));
															#line 1587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 114 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 114 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state = 2;
															#line 114 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionFailIfLockedActor, 1, Void >*>(static_cast<RunRYWTransactionFailIfLockedActor*>(this)));
															#line 1609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& __result,int loopDepth) 
	{
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		result = __result;
															#line 1618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionFailIfLockedActor*>(this)->ActorCallback< RunRYWTransactionFailIfLockedActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionFailIfLockedActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionFailIfLockedActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionFailIfLockedActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 115 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionFailIfLockedActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionFailIfLockedActorState(); static_cast<RunRYWTransactionFailIfLockedActor*>(this)->destroy(); return 0; }
															#line 1697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionFailIfLockedActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionFailIfLockedActorState();
		static_cast<RunRYWTransactionFailIfLockedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 115 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionFailIfLockedActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionFailIfLockedActorState(); static_cast<RunRYWTransactionFailIfLockedActor*>(this)->destroy(); return 0; }
															#line 1709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionFailIfLockedActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionFailIfLockedActorState();
		static_cast<RunRYWTransactionFailIfLockedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionFailIfLockedActor*>(this)->ActorCallback< RunRYWTransactionFailIfLockedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionFailIfLockedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionFailIfLockedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionFailIfLockedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionFailIfLockedActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionFailIfLockedActor*>(this)->ActorCallback< RunRYWTransactionFailIfLockedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionFailIfLockedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionFailIfLockedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionFailIfLockedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Database cx;
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Function func;
															#line 109 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Reference<ReadYourWritesTransaction> tr;
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) result;
															#line 1887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
};
// This generated class is to be used only via runRYWTransactionFailIfLocked()
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionFailIfLockedActor final : public Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>, public ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >, public ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 1, Void >, public ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 2, Void >, public FastAllocated<RunRYWTransactionFailIfLockedActor<Function>>, public RunRYWTransactionFailIfLockedActorState<Function, RunRYWTransactionFailIfLockedActor<Function>> {
															#line 1894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
	using FastAllocated<RunRYWTransactionFailIfLockedActor<Function>>::operator new;
	using FastAllocated<RunRYWTransactionFailIfLockedActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13596532151145187072UL, 13511560235080475648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >;
friend struct ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 1, Void >;
friend struct ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 2, Void >;
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionFailIfLockedActor(Database const& cx,Function const& func) 
															#line 1913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		 : Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(),
		   RunRYWTransactionFailIfLockedActorState<Function, RunRYWTransactionFailIfLockedActor<Function>>(cx, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17083652881247750656UL, 4001030302939534080UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionFailIfLockedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRYWTransactionFailIfLocked");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRYWTransactionFailIfLocked", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunRYWTransactionFailIfLockedActor<Function>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
[[nodiscard]] Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> runRYWTransactionFailIfLocked( Database const& cx, Function const& func ) {
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	return Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(new RunRYWTransactionFailIfLockedActor<Function>(cx, func));
															#line 1950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
}

#line 123 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"

															#line 1955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
namespace {
// This generated class is to be used only via runRYWTransactionNoRetry()
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function, class RunRYWTransactionNoRetryActor>
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionNoRetryActorState {
															#line 1962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionNoRetryActorState(Database const& cx,Function const& func) 
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		 : cx(cx),
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   func(func),
															#line 128 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		   tr(new ReadYourWritesTransaction(cx))
															#line 1973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
	{
		fdb_probe_actor_create("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this));

	}
	~RunRYWTransactionNoRetryActorState() 
	{
		fdb_probe_actor_destroy("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			StrictFuture<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> __when_expr_0 = func(tr);
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			if (static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state = 1;
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionNoRetryActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*>(static_cast<RunRYWTransactionNoRetryActor*>(this)));
															#line 1995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRYWTransactionNoRetryActorState();
		static_cast<RunRYWTransactionNoRetryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state = 2;
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRYWTransactionNoRetryActor, 1, Void >*>(static_cast<RunRYWTransactionNoRetryActor*>(this)));
															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& __result,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		result = __result;
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionNoRetryActor*>(this)->ActorCallback< RunRYWTransactionNoRetryActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionNoRetryActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionNoRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionNoRetryActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionNoRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionNoRetryActor, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionNoRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionNoRetryActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionNoRetryActorState(); static_cast<RunRYWTransactionNoRetryActor*>(this)->destroy(); return 0; }
															#line 2113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionNoRetryActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionNoRetryActorState();
		static_cast<RunRYWTransactionNoRetryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
		if (!static_cast<RunRYWTransactionNoRetryActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>::futures) { (void)(result); this->~RunRYWTransactionNoRetryActorState(); static_cast<RunRYWTransactionNoRetryActor*>(this)->destroy(); return 0; }
															#line 2125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		new (&static_cast<RunRYWTransactionNoRetryActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunRYWTransactionNoRetryActorState();
		static_cast<RunRYWTransactionNoRetryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state > 0) static_cast<RunRYWTransactionNoRetryActor*>(this)->actor_wait_state = 0;
		static_cast<RunRYWTransactionNoRetryActor*>(this)->ActorCallback< RunRYWTransactionNoRetryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionNoRetryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionNoRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRYWTransactionNoRetryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionNoRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRYWTransactionNoRetryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionNoRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Database cx;
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Function func;
															#line 128 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	Reference<ReadYourWritesTransaction> tr;
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) result;
															#line 2216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
};
// This generated class is to be used only via runRYWTransactionNoRetry()
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
class RunRYWTransactionNoRetryActor final : public Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>, public ActorCallback< RunRYWTransactionNoRetryActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >, public ActorCallback< RunRYWTransactionNoRetryActor<Function>, 1, Void >, public FastAllocated<RunRYWTransactionNoRetryActor<Function>>, public RunRYWTransactionNoRetryActorState<Function, RunRYWTransactionNoRetryActor<Function>> {
															#line 2223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
public:
	using FastAllocated<RunRYWTransactionNoRetryActor<Function>>::operator new;
	using FastAllocated<RunRYWTransactionNoRetryActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15082657250984884480UL, 1894157295210286592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRYWTransactionNoRetryActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >;
friend struct ActorCallback< RunRYWTransactionNoRetryActor<Function>, 1, Void >;
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	RunRYWTransactionNoRetryActor(Database const& cx,Function const& func) 
															#line 2241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
		 : Actor<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(),
		   RunRYWTransactionNoRetryActorState<Function, RunRYWTransactionNoRetryActor<Function>>(cx, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1941606636547281152UL, 16418187166190023424UL);
		ActorExecutionContextHelper __helper(static_cast<RunRYWTransactionNoRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRYWTransactionNoRetry");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRYWTransactionNoRetry", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRYWTransactionNoRetryActor<Function>, 0, decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue()) >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRYWTransactionNoRetryActor<Function>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
template <class Function>
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
[[nodiscard]] Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())> runRYWTransactionNoRetry( Database const& cx, Function const& func ) {
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"
	return Future<decltype(std::declval<Function>()(Reference<ReadYourWritesTransaction>()).getValue())>(new RunRYWTransactionNoRetryActor<Function>(cx, func));
															#line 2277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/RunRYWTransaction.actor.g.h"
}

#line 133 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/RunRYWTransaction.actor.h"

#include "flow/unactorcompiler.h"
#endif
