#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
/*
 * ManagementAPI.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_MANAGEMENT_API_ACTOR_G_H)
#define FDBCLIENT_MANAGEMENT_API_ACTOR_G_H
#include "fdbclient/ManagementAPI.actor.g.h"
#elif !defined(FDBCLIENT_MANAGEMENT_API_ACTOR_H)
#define FDBCLIENT_MANAGEMENT_API_ACTOR_H

/* This file defines "management" interfaces for configuration, coordination changes, and
the inclusion and exclusion of servers. It is used to implement fdbcli management commands
and by test workloads that simulate such. It isn't exposed to C clients or anywhere outside
our code base and doesn't need to be versioned. It doesn't do anything you can't do with the
standard API and some knowledge of the contents of the system key space.
*/

#include <string>
#include <map>
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/RangeLock.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/MonitorLeader.h"
#include "flow/actorcompiler.h" // has to be last include

															#line 47 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<DatabaseConfiguration> getDatabaseConfiguration( Transaction* const& tr, bool const& useSystemPriority = false );

#line 46 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 51 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<DatabaseConfiguration> getDatabaseConfiguration( Database const& cx, bool const& useSystemPriority = false );

#line 47 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> waitForFullReplication( Database const& cx );

#line 48 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

struct IQuorumChange : ReferenceCounted<IQuorumChange> {
	virtual ~IQuorumChange() {}
	virtual Future<std::vector<NetworkAddress>> getDesiredCoordinators(Transaction* tr,
	                                                                   std::vector<NetworkAddress> oldCoordinators,
	                                                                   Reference<IClusterConnectionRecord>,
	                                                                   CoordinatorsResult&) = 0;
	virtual std::string getDesiredClusterKeyName() const { return std::string(); }
};

// Change to use the given set of coordination servers
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<CoordinatorsResult>> changeQuorumChecker( Transaction* const& tr, ClusterConnectionString* const& conn, std::string const& newName, bool const& disableConfigDB );

#line 63 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 74 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<CoordinatorsResult> changeQuorum( Database const& cx, Reference<IQuorumChange> const& change );

#line 64 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
Reference<IQuorumChange> autoQuorumChange(int desired = -1);
Reference<IQuorumChange> nameQuorumChange(std::string const& name, Reference<IQuorumChange> const& other);

// Exclude the given set of servers from use as state servers.  Returns as soon as the change is durable, without
// necessarily waiting for the servers to be evacuated.  A NetworkAddress with a port of 0 means all servers on the
// given IP.
															#line 84 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeServers( Database const& cx, std::vector<AddressExclusion> const& servers, bool const& failed = false );

#line 71 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 88 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeServers( Transaction* const& tr, std::vector<AddressExclusion> const& servers, bool const& failed = false );

#line 72 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Exclude the servers matching the given set of localities from use as state servers.  Returns as soon as the change
// is durable, without necessarily waiting for the servers to be evacuated.
															#line 95 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeLocalities( Database const& cx, std::unordered_set<std::string> const& localities, bool const& failed = false );

#line 76 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 99 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeLocalities( Transaction* const& tr, std::unordered_set<std::string> const& localities, bool const& failed = false );

#line 77 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Remove the given servers from the exclusion list.  A NetworkAddress with a port of 0 means all servers on the given
// IP.  A NetworkAddress() means all servers (don't exclude anything)
															#line 106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> includeServers( Database const& cx, std::vector<AddressExclusion> const& servers, bool const& failed = false );

#line 81 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Remove the given localities from the exclusion list.
															#line 112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> includeLocalities( Database const& cx, std::vector<std::string> const& localities, bool const& failed = false, bool const& includeAll = false );

#line 87 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Set the process class of processes with the given address.  A NetworkAddress with a port of 0 means all servers on
// the given IP.
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> setClass( Database const& cx, AddressExclusion const& server, ProcessClass const& processClass );

#line 91 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded servers including both "exclude" and "failed".
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getAllExcludedServers( Database const& cx );

#line 94 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getAllExcludedServers( Transaction* const& tr );

#line 95 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded servers.
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getExcludedServerList( Transaction* const& tr );

#line 98 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of failed servers.
															#line 141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getExcludedFailedServerList( Transaction* const& tr );

#line 101 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded localities
															#line 147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getAllExcludedLocalities( Database const& cx );

#line 104 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getAllExcludedLocalities( Transaction* const& tr );

#line 105 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded localities.
															#line 157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getExcludedLocalityList( Transaction* const& tr );

#line 108 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of failed localities.
															#line 163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getExcludedFailedLocalityList( Transaction* const& tr );

#line 111 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Decodes the locality string to a pair of locality prefix and its value.
// The prefix could be dcid, processid, machineid, processid.
std::pair<std::string, std::string> decodeLocality(const std::string& locality);
std::set<AddressExclusion> getServerAddressesByLocality(
    const std::map<std::string, StorageServerInterface> server_interfaces,
    const std::string& locality);
std::set<AddressExclusion> getAddressesByLocality(const std::vector<ProcessData>& workers, const std::string& locality);

// Check for the given, previously excluded servers to be evacuated (no longer used for state).  If waitForExclusion
// is true, this actor returns once it is safe to shut down all such machines without impacting fault tolerance,
// until and unless any of them are explicitly included with includeServers()
															#line 179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::set<NetworkAddress>> checkForExcludingServers( Database const& cx, std::vector<AddressExclusion> const& servers, bool const& waitForAllExcluded );

#line 126 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<bool> checkForExcludingServersTxActor( ReadYourWritesTransaction* const& tr, std::set<AddressExclusion>* const& exclusions, std::set<NetworkAddress>* const& inProgressExclusion );

#line 129 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Gets a list of all workers in the cluster (excluding testers)
															#line 189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<ProcessData>> getWorkers( Database const& cx );

#line 132 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<ProcessData>> getWorkers( Transaction* const& tr );

#line 133 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> timeKeeperSetDisable( Database const& cx );

#line 135 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> lockDatabase( Transaction* const& tr, UID const& id );

#line 137 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> lockDatabase( Reference<ReadYourWritesTransaction> const& tr, UID const& id );

#line 138 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> lockDatabase( Database const& cx, UID const& id );

#line 139 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> unlockDatabase( Transaction* const& tr, UID const& id );

#line 141 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> unlockDatabase( Reference<ReadYourWritesTransaction> const& tr, UID const& id );

#line 142 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> unlockDatabase( Database const& cx, UID const& id );

#line 143 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> checkDatabaseLock( Transaction* const& tr, UID const& id );

#line 145 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> checkDatabaseLock( Reference<ReadYourWritesTransaction> const& tr, UID const& id );

#line 146 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> advanceVersion( Database const& cx, Version const& v );

#line 148 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> setDDMode( Database const& cx, int const& mode );

#line 150 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> forceRecovery( Reference<IClusterConnectionRecord> const& clusterFile, Standalone<StringRef> const& dcId );

#line 152 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Start an audit on range of the specific type.
															#line 254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<UID> auditStorage( Reference<IClusterConnectionRecord> const& clusterFile, KeyRange const& range, AuditType const& type, KeyValueStoreType const& engineType, double const& timeoutSeconds );

#line 159 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
// Cancel an audit given type and id
															#line 259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<UID> cancelAuditStorage( Reference<IClusterConnectionRecord> const& clusterFile, AuditType const& type, UID const& auditId, double const& timeoutSeconds );

#line 164 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Set bulk load mode
// When the mode is on, DD will periodically check if there is any bulkload task to do by scaning the metadata.
															#line 266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> setBulkLoadMode( Database const& cx, int const& mode );

#line 168 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Create a bulkload task submission transaction without commit
// Used by ManagementAPI and bulkdumpRestore at DD
															#line 273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> setBulkLoadSubmissionTransaction( Transaction* const& tr, BulkLoadTaskState const& bulkLoadTask );

#line 172 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Create an bulkload task acknowledge transaction without commit
// Used by ManagementAPI and bulkdumpRestore at DD
															#line 280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> setBulkLoadFinalizeTransaction( Transaction* const& tr, KeyRange const& range, UID const& taskId );

#line 176 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get bulk load task for the input range and taskId
															#line 286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<BulkLoadTaskState> getBulkLoadTask( Transaction* const& tr, KeyRange const& range, UID const& taskId, std::vector<BulkLoadPhase> const& phases );

#line 182 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Add bulkLoad job to history map
															#line 292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> addBulkLoadJobToHistory( Transaction* const& tr, BulkLoadJobState const& jobState );

#line 185 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get all past bulkLoad jobs from history map
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<BulkLoadJobState>> getBulkLoadJobFromHistory( Database const& cx );

#line 188 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Erase all bulkLoad job history metadata if jobId is not provided. Otherwise, erase the job with the given jobId.
															#line 304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> clearBulkLoadJobHistory( Database const& cx, Optional<UID> const& jobId = Optional<UID>() );

#line 191 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current running bulk load job
															#line 310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<BulkLoadJobState>> getRunningBulkLoadJob( Database const& cx );

#line 194 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Cancel bulkLoad job for the given jobId
															#line 316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> cancelBulkLoadJob( Database const& cx, UID const& jobId );

#line 197 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Acknowledge all bulk load tasks that are in the Error phase.
// After acknowledge, the write traffic to the task's range is turned on and the task's metadata is cleared by the bulk
// load engine.
															#line 324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> acknowledgeAllErrorBulkLoadTasks( Database const& cx, UID const& jobId, KeyRange const& jobRange );

#line 202 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Submit a BulkLoad job: loading data from a remote folder using bulkloading mechanism.
// There is at most one BulkLoad or one BulkDump job at a time.
// If there is any existing BulkLoad or BulkDump job, reject the new job.
															#line 332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> submitBulkLoadJob( Database const& cx, BulkLoadJobState const& jobState );

#line 207 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Set bulk dump mode. When the mode is on, DD will periodically check if there is any bulkdump task to do by scaning
// the metadata.
															#line 339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> setBulkDumpMode( Database const& cx, int const& mode );

#line 211 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get bulk dump mode value.
															#line 345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> getBulkDumpMode( Database const& cx );

#line 214 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// TODO(BulkDump): Cancel or clear the BulkDump job
															#line 351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> cancelBulkDumpJob( Database const& cx, UID const& jobId );

#line 217 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Submit a bulkdump job: dumping data to a remote folder by storage servers.
// There is at most one BulkLoad or one BulkDump job at a time.
// If there is any existing BulkLoad or BulkDump job, reject the new job.
															#line 359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> submitBulkDumpJob( Database const& cx, BulkDumpState const& bulkDumpJob );

#line 222 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Return the existing job metadata
															#line 365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<BulkDumpState>> getSubmittedBulkDumpJob( Transaction* const& tr );

#line 225 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get total number of completed tasks within the input range
															#line 371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<size_t> getBulkDumpCompleteTaskCount( Database const& cx, KeyRange const& rangeToRead );

#line 228 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Persist a rangeLock owner to database metadata
// A range can only be locked by a registered owner
															#line 378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> registerRangeLockOwner( Database const& cx, RangeLockOwnerName const& ownerUniqueID, std::string const& description );

#line 232 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Remove an owner form the database metadata
															#line 384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> removeRangeLockOwner( Database const& cx, RangeLockOwnerName const& ownerUniqueID );

#line 235 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get all registered rangeLock owner
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<RangeLockOwner>> getAllRangeLockOwners( Database const& cx );

#line 238 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get a rangeLock owner by ownerUniqueID
															#line 396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<RangeLockOwner>> getRangeLockOwner( Database const& cx, RangeLockOwnerName const& ownerUniqueID );

#line 241 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Block write traffic to a user range (the input range must be within normalKeys).
// One transaction can call releaseExclusiveReadLockOnRange at most for one time.
															#line 403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> takeExclusiveReadLockOnRange( Transaction* const& tr, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 245 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> takeExclusiveReadLockOnRange( Database const& cx, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 247 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Unblock a user range (the input range must be within normalKeys).
// One transaction can call releaseExclusiveReadLockOnRange at most for one time.
															#line 415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> releaseExclusiveReadLockOnRange( Transaction* const& tr, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 251 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> releaseExclusiveReadLockOnRange( Database const& cx, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 253 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get locked ranges within the input range (the input range must be within normalKeys)
															#line 426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::pair<KeyRange, RangeLockState>>> findExclusiveReadLockOnRange( Database const& cx, KeyRange const& range, Optional<RangeLockOwnerName> const& ownerName = Optional<RangeLockOwnerName>() );

#line 259 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Clear all exclusive read lock by the input user. Not transactional.
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> releaseExclusiveReadLockByUser( Database const& cx, RangeLockOwnerName const& ownerUniqueID );

#line 262 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> printHealthyZone( Database const& cx );

#line 264 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<bool> clearHealthyZone( Database const& cx, bool const& printWarning = false, bool const& clearSSFailureZoneString = false );

#line 265 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<bool> setHealthyZone( Database const& cx, StringRef const& zoneId, double const& seconds, bool const& printWarning = false );

#line 266 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> waitForPrimaryDC( Database const& cx, StringRef const& dcId );

#line 268 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Gets the cluster connection string
															#line 456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<ClusterConnectionString>> getConnectionString( Database const& cx );

#line 271 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

void schemaCoverage(std::string const& spath, bool covered = true);
bool schemaMatch(json_spirit::mValue const& schema,
                 json_spirit::mValue const& result,
                 std::string& errorStr,
                 Severity sev = SevError,
                 bool checkCoverage = false,
                 std::string path = std::string(),
                 std::string schema_path = std::string());

// execute payload in 'snapCmd' on all the coordinators, TLogs and
// storage nodes
															#line 472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> mgmtSnapCreate( Database const& cx, Standalone<StringRef> const& snapCmd, UID const& snapUID );

#line 284 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> disableBackupWorker( Database const& cx );

#line 286 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> enableBackupWorker( Database const& cx );

#line 287 "/Users/ec2-user/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

#include "flow/unactorcompiler.h"
#endif
