/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.IOException;
import java.io.Writer;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.console.options.AvailableOptions;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;
import org.junit.platform.console.shadow.picocli.CommandLine;

@API(status=API.Status.INTERNAL, since="1.0")
public class PicocliCommandLineOptionsParser
implements CommandLineOptionsParser {
    @Override
    public CommandLineOptions parse(String ... arguments) {
        AvailableOptions availableOptions = this.getAvailableOptions();
        CommandLine parser = availableOptions.getParser();
        try {
            CommandLine.ParseResult detectedOptions = parser.parseArgs(arguments);
            return availableOptions.toCommandLineOptions(detectedOptions);
        }
        catch (Exception ex) {
            throw new JUnitException("Error parsing command-line arguments: " + ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void printHelp(Writer writer, boolean ansiColorOutputDisabled) {
        try {
            CommandLine parser = this.getAvailableOptions().getParser();
            if (ansiColorOutputDisabled) {
                parser.setColorScheme(CommandLine.Help.defaultColorScheme(CommandLine.Help.Ansi.OFF));
            }
            writer.append(parser.getUsageMessage());
        }
        catch (IOException ex) {
            throw new JUnitException("Error printing help", (Throwable)ex);
        }
    }

    private AvailableOptions getAvailableOptions() {
        return new AvailableOptions();
    }
}

