#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
/*
 * MetaclusterUtil.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_METACLUSTERUTIL_ACTOR_G_H)
#define METACLUSTER_METACLUSTERUTIL_ACTOR_G_H
#include "metacluster/MetaclusterUtil.actor.g.h"
#elif !defined(METACLUSTER_METACLUSTERUTIL_ACTOR_H)
#define METACLUSTER_METACLUSTERUTIL_ACTOR_H

#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/NativeAPI.actor.h"
#include "flow/FastRef.h"
#include "flow/IRandom.h"
#include "flow/Platform.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

// This provide metacluster utility functions that may be used both internally and externally to the metacluster project
namespace metacluster::util {

FDB_BOOLEAN_PARAM(SkipMetaclusterCreation);

// Helper function to compute metacluster capacity by passing the result of metacluster::listClusters
std::pair<ClusterUsage, ClusterUsage> metaclusterCapacity(std::map<ClusterName, DataClusterMetadata> const& clusters);

															#line 50 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
[[nodiscard]] Future<Reference<IDatabase>> openDatabase( ClusterConnectionString const& connectionString );

#line 49 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"

															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
// This generated class is to be used only via getAndOpenDatabase()
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
template <class Transaction, class GetAndOpenDatabaseActor>
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
class GetAndOpenDatabaseActorState {
															#line 61 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
public:
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
	GetAndOpenDatabaseActorState(Transaction const& managementTr,ClusterName const& clusterName) 
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		 : managementTr(managementTr),
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		   clusterName(clusterName)
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
	{
		fdb_probe_actor_create("getAndOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	~GetAndOpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("getAndOpenDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 52 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
			StrictFuture<DataClusterMetadata> __when_expr_0 = getClusterTransaction(managementTr, clusterName);
															#line 52 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
			if (static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 87 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 52 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAndOpenDatabaseActor, 0, DataClusterMetadata >*>(static_cast<GetAndOpenDatabaseActor*>(this)));
															#line 92 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAndOpenDatabaseActorState();
		static_cast<GetAndOpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
															#line 53 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		StrictFuture<Reference<IDatabase>> __when_expr_1 = openDatabase(clusterMetadata.connectionString);
															#line 53 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		if (static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state = 2;
															#line 53 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAndOpenDatabaseActor, 1, Reference<IDatabase> >*>(static_cast<GetAndOpenDatabaseActor*>(this)));
															#line 122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
															#line 53 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		StrictFuture<Reference<IDatabase>> __when_expr_1 = openDatabase(clusterMetadata.connectionString);
															#line 53 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		if (static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state = 2;
															#line 53 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAndOpenDatabaseActor, 1, Reference<IDatabase> >*>(static_cast<GetAndOpenDatabaseActor*>(this)));
															#line 138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<GetAndOpenDatabaseActor*>(this)->ActorCallback< GetAndOpenDatabaseActor, 0, DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< GetAndOpenDatabaseActor, 0, DataClusterMetadata >*,DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAndOpenDatabaseActor, 0, DataClusterMetadata >*,DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAndOpenDatabaseActor, 0, DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Reference<IDatabase> const& db,int loopDepth) 
	{
															#line 54 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		if (!static_cast<GetAndOpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(db); this->~GetAndOpenDatabaseActorState(); static_cast<GetAndOpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
		new (&static_cast<GetAndOpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(db);
		this->~GetAndOpenDatabaseActorState();
		static_cast<GetAndOpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IDatabase> && db,int loopDepth) 
	{
															#line 54 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
		if (!static_cast<GetAndOpenDatabaseActor*>(this)->SAV<Reference<IDatabase>>::futures) { (void)(db); this->~GetAndOpenDatabaseActorState(); static_cast<GetAndOpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
		new (&static_cast<GetAndOpenDatabaseActor*>(this)->SAV< Reference<IDatabase> >::value()) Reference<IDatabase>(db);
		this->~GetAndOpenDatabaseActorState();
		static_cast<GetAndOpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IDatabase> const& db,int loopDepth) 
	{
		loopDepth = a_body1cont2(db, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IDatabase> && db,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(db), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<GetAndOpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<GetAndOpenDatabaseActor*>(this)->ActorCallback< GetAndOpenDatabaseActor, 1, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAndOpenDatabaseActor, 1, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAndOpenDatabaseActor, 1, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAndOpenDatabaseActor, 1, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
	Transaction managementTr;
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
	ClusterName clusterName;
															#line 321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
};
// This generated class is to be used only via getAndOpenDatabase()
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
template <class Transaction>
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
class GetAndOpenDatabaseActor final : public Actor<Reference<IDatabase>>, public ActorCallback< GetAndOpenDatabaseActor<Transaction>, 0, DataClusterMetadata >, public ActorCallback< GetAndOpenDatabaseActor<Transaction>, 1, Reference<IDatabase> >, public FastAllocated<GetAndOpenDatabaseActor<Transaction>>, public GetAndOpenDatabaseActorState<Transaction, GetAndOpenDatabaseActor<Transaction>> {
															#line 328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
public:
	using FastAllocated<GetAndOpenDatabaseActor<Transaction>>::operator new;
	using FastAllocated<GetAndOpenDatabaseActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17653438592949776896UL, 3103166309887983872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<IDatabase>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAndOpenDatabaseActor<Transaction>, 0, DataClusterMetadata >;
friend struct ActorCallback< GetAndOpenDatabaseActor<Transaction>, 1, Reference<IDatabase> >;
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
	GetAndOpenDatabaseActor(Transaction const& managementTr,ClusterName const& clusterName) 
															#line 346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
		 : Actor<Reference<IDatabase>>(),
		   GetAndOpenDatabaseActorState<Transaction, GetAndOpenDatabaseActor<Transaction>>(managementTr, clusterName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5579025394397117440UL, 8060833552586050048UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndOpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAndOpenDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAndOpenDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAndOpenDatabaseActor<Transaction>, 0, DataClusterMetadata >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAndOpenDatabaseActor<Transaction>, 1, Reference<IDatabase> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
template <class Transaction>
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
[[nodiscard]] Future<Reference<IDatabase>> getAndOpenDatabase( Transaction const& managementTr, ClusterName const& clusterName ) {
															#line 50 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"
	return Future<Reference<IDatabase>>(new GetAndOpenDatabaseActor<Transaction>(managementTr, clusterName));
															#line 381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
}

#line 56 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"

struct SimulatedMetacluster {
	Reference<IDatabase> managementDb;
	std::map<ClusterName, Database> dataDbs;
};

															#line 391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/MetaclusterUtil.actor.g.h"
[[nodiscard]] Future<SimulatedMetacluster> createSimulatedMetacluster( Database const& db, Optional<int64_t> const& tenantIdPrefix = Optional<int64_t>(), Optional<DataClusterEntry> const& dataClusterConfig = DataClusterEntry(), SkipMetaclusterCreation const& skipMetaclusterCreation = SkipMetaclusterCreation::False );

#line 67 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/MetaclusterUtil.actor.h"

} // namespace metacluster::util

#include "flow/unactorcompiler.h"
#endif