#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
/*
 * DeleteTenant.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_DELETETENANT_ACTOR_G_H)
#define METACLUSTER_DELETETENANT_ACTOR_G_H
#include "metacluster/DeleteTenant.actor.g.h"
#elif !defined(METACLUSTER_DELETETENANT_ACTOR_H)
#define METACLUSTER_DELETETENANT_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterInternal.actor.h"
#include "metacluster/MetaclusterOperationContext.actor.h"
#include "metacluster/MetaclusterTypes.h"
#include "metacluster/UpdateTenantGroups.actor.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

namespace internal {
template <class DB>
struct DeleteTenantImpl {
	MetaclusterOperationContext<DB> ctx;

	// Initialization parameters
	// Either one can be specified, and the other will be looked up
	// and filled in by reading the metacluster metadata
	Optional<TenantName> tenantName;
	int64_t tenantId = -1;

	DeleteTenantImpl(Reference<DB> managementDb, TenantName tenantName) : ctx(managementDb), tenantName(tenantName) {}
	DeleteTenantImpl(Reference<DB> managementDb, int64_t tenantId) : ctx(managementDb), tenantId(tenantId) {}

	// Loads the cluster details for the cluster where the tenant is assigned.
	// Returns true if the deletion is already in progress
																#line 59 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
// This generated class is to be used only via getAssignedLocation()
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class GetAssignedLocationActor>
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class GetAssignedLocationActorState {
															#line 65 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	GetAssignedLocationActorState(DeleteTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		 : self(self),
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   tr(tr),
															#line 59 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   resolvedId(self->tenantId)
															#line 76 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
	{
		fdb_probe_actor_create("getAssignedLocation", reinterpret_cast<unsigned long>(this));

	}
	~GetAssignedLocationActorState() 
	{
		fdb_probe_actor_destroy("getAssignedLocation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 60 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (self->tenantId == -1)
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			{
															#line 61 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
				CODE_PROBE(true, "Delete tenant by name");
															#line 62 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
				ASSERT(self->tenantName.present());
															#line 63 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
				StrictFuture<Void> __when_expr_0 = store(resolvedId, metadata::management::tenantMetadata().tenantNameIndex.getD( tr, self->tenantName.get(), Snapshot::False, TenantInfo::INVALID_TENANT));
															#line 63 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
				if (static_cast<GetAssignedLocationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetAssignedLocationActor*>(this)->actor_wait_state = 1;
															#line 63 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAssignedLocationActor, 0, Void >*>(static_cast<GetAssignedLocationActor*>(this)));
															#line 106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 67 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
				CODE_PROBE(true, "Delete tenant by ID");
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAssignedLocationActorState();
		static_cast<GetAssignedLocationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<MetaclusterTenantMapEntry> __when_expr_1 = getTenantTransaction(tr, resolvedId);
															#line 70 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<GetAssignedLocationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetAssignedLocationActor*>(this)->actor_wait_state = 2;
															#line 70 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >*>(static_cast<GetAssignedLocationActor*>(this)));
															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAssignedLocationActor*>(this)->actor_wait_state > 0) static_cast<GetAssignedLocationActor*>(this)->actor_wait_state = 0;
		static_cast<GetAssignedLocationActor*>(this)->ActorCallback< GetAssignedLocationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAssignedLocationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAssignedLocationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAssignedLocationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 73 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (self->tenantName.present() && tenantEntry.tenantName != self->tenantName.get())
															#line 240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 74 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			ASSERT(tenantEntry.tenantState == TenantState::RENAMING || tenantEntry.tenantState == TenantState::REMOVING);
															#line 76 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Delete tenant by new name during rename");
															#line 77 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
															#line 80 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<Void> __when_expr_2 = self->ctx.setCluster(tr, tenantEntry.assignedCluster);
															#line 80 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<GetAssignedLocationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetAssignedLocationActor*>(this)->actor_wait_state = 3;
															#line 80 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetAssignedLocationActor, 2, Void >*>(static_cast<GetAssignedLocationActor*>(this)));
															#line 259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(MetaclusterTenantMapEntry const& __tenantEntry,int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(MetaclusterTenantMapEntry && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAssignedLocationActor*>(this)->actor_wait_state > 0) static_cast<GetAssignedLocationActor*>(this)->actor_wait_state = 0;
		static_cast<GetAssignedLocationActor*>(this)->ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >*,MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >*,MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 81 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<GetAssignedLocationActor*>(this)->SAV<std::pair<int64_t, bool>>::futures) { (void)(std::make_pair(resolvedId, tenantEntry.tenantState == TenantState::REMOVING)); this->~GetAssignedLocationActorState(); static_cast<GetAssignedLocationActor*>(this)->destroy(); return 0; }
															#line 347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<GetAssignedLocationActor*>(this)->SAV< std::pair<int64_t, bool> >::value()) std::pair<int64_t, bool>(std::make_pair(resolvedId, tenantEntry.tenantState == TenantState::REMOVING));
		this->~GetAssignedLocationActorState();
		static_cast<GetAssignedLocationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 81 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<GetAssignedLocationActor*>(this)->SAV<std::pair<int64_t, bool>>::futures) { (void)(std::make_pair(resolvedId, tenantEntry.tenantState == TenantState::REMOVING)); this->~GetAssignedLocationActorState(); static_cast<GetAssignedLocationActor*>(this)->destroy(); return 0; }
															#line 359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<GetAssignedLocationActor*>(this)->SAV< std::pair<int64_t, bool> >::value()) std::pair<int64_t, bool>(std::make_pair(resolvedId, tenantEntry.tenantState == TenantState::REMOVING));
		this->~GetAssignedLocationActorState();
		static_cast<GetAssignedLocationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetAssignedLocationActor*>(this)->actor_wait_state > 0) static_cast<GetAssignedLocationActor*>(this)->actor_wait_state = 0;
		static_cast<GetAssignedLocationActor*>(this)->ActorCallback< GetAssignedLocationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAssignedLocationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetAssignedLocationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetAssignedLocationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantImpl* self;
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 59 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	int64_t resolvedId;
															#line 70 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	MetaclusterTenantMapEntry tenantEntry;
															#line 450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
};
// This generated class is to be used only via getAssignedLocation()
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class GetAssignedLocationActor final : public Actor<std::pair<int64_t, bool>>, public ActorCallback< GetAssignedLocationActor, 0, Void >, public ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >, public ActorCallback< GetAssignedLocationActor, 2, Void >, public FastAllocated<GetAssignedLocationActor>, public GetAssignedLocationActorState<GetAssignedLocationActor> {
															#line 455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
	using FastAllocated<GetAssignedLocationActor>::operator new;
	using FastAllocated<GetAssignedLocationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3354150490027342336UL, 9263380797837870080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<int64_t, bool>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAssignedLocationActor, 0, Void >;
friend struct ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >;
friend struct ActorCallback< GetAssignedLocationActor, 2, Void >;
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	GetAssignedLocationActor(DeleteTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		 : Actor<std::pair<int64_t, bool>>(),
		   GetAssignedLocationActorState<GetAssignedLocationActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAssignedLocation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17287319806590419456UL, 7047401287733890048UL);
		ActorExecutionContextHelper __helper(static_cast<GetAssignedLocationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAssignedLocation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAssignedLocation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAssignedLocationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAssignedLocationActor, 1, MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetAssignedLocationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
[[nodiscard]] static Future<std::pair<int64_t, bool>> getAssignedLocation( DeleteTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 57 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	return Future<std::pair<int64_t, bool>>(new GetAssignedLocationActor(self, tr));
															#line 508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
}

#line 83 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"

	// Does an initial check if the tenant is empty. This is an optimization to prevent us marking a tenant
	// in the deleted state while it has data, but it is still possible that data gets added to it after this
	// point.
	//
	// SOMEDAY: should this also lock the tenant when locking is supported?
																#line 518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
// This generated class is to be used only via checkTenantEmpty()
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class CheckTenantEmptyActor>
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class CheckTenantEmptyActorState {
															#line 524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	CheckTenantEmptyActorState(DeleteTenantImpl* const& self,Reference<ITransaction> const& tr) 
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		 : self(self),
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   tr(tr)
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
	{
		fdb_probe_actor_create("checkTenantEmpty", reinterpret_cast<unsigned long>(this));

	}
	~CheckTenantEmptyActorState() 
	{
		fdb_probe_actor_destroy("checkTenantEmpty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::tryGetTenantTransaction(tr, self->tenantId);
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state = 1;
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >*>(static_cast<CheckTenantEmptyActor*>(this)));
															#line 555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTenantEmptyActorState();
		static_cast<CheckTenantEmptyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!tenantEntry.present())
															#line 578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 93 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Tenant removed while deleting");
															#line 94 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (!static_cast<CheckTenantEmptyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTenantEmptyActorState(); static_cast<CheckTenantEmptyActor*>(this)->destroy(); return 0; }
															#line 584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			new (&static_cast<CheckTenantEmptyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckTenantEmptyActorState();
			static_cast<CheckTenantEmptyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 97 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		ThreadFuture<RangeResult> rangeFuture = tr->getRange(prefixRange(tenantEntry.get().prefix), 1);
															#line 98 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<RangeResult> __when_expr_1 = safeThreadFutureToFuture(rangeFuture);
															#line 98 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state = 2;
															#line 98 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckTenantEmptyActor, 1, RangeResult >*>(static_cast<CheckTenantEmptyActor*>(this)));
															#line 601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantEmptyActor*>(this)->ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!result.empty())
															#line 689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 100 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Attempt to delete non-empty tenant");
															#line 101 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			return a_body1Catch1(tenant_not_empty(), loopDepth);
															#line 695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
															#line 104 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<CheckTenantEmptyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTenantEmptyActorState(); static_cast<CheckTenantEmptyActor*>(this)->destroy(); return 0; }
															#line 699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<CheckTenantEmptyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTenantEmptyActorState();
		static_cast<CheckTenantEmptyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && result,int loopDepth) 
	{
															#line 99 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!result.empty())
															#line 711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 100 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Attempt to delete non-empty tenant");
															#line 101 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			return a_body1Catch1(tenant_not_empty(), loopDepth);
															#line 717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
															#line 104 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<CheckTenantEmptyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTenantEmptyActorState(); static_cast<CheckTenantEmptyActor*>(this)->destroy(); return 0; }
															#line 721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<CheckTenantEmptyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTenantEmptyActorState();
		static_cast<CheckTenantEmptyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantEmptyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantEmptyActor*>(this)->ActorCallback< CheckTenantEmptyActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantEmptyActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckTenantEmptyActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckTenantEmptyActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantImpl* self;
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Reference<ITransaction> tr;
															#line 90 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Optional<TenantMapEntry> tenantEntry;
															#line 810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
};
// This generated class is to be used only via checkTenantEmpty()
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class CheckTenantEmptyActor final : public Actor<Void>, public ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >, public ActorCallback< CheckTenantEmptyActor, 1, RangeResult >, public FastAllocated<CheckTenantEmptyActor>, public CheckTenantEmptyActorState<CheckTenantEmptyActor> {
															#line 815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
	using FastAllocated<CheckTenantEmptyActor>::operator new;
	using FastAllocated<CheckTenantEmptyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15729582908807580672UL, 13532971343521855744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >;
friend struct ActorCallback< CheckTenantEmptyActor, 1, RangeResult >;
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	CheckTenantEmptyActor(DeleteTenantImpl* const& self,Reference<ITransaction> const& tr) 
															#line 833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		 : Actor<Void>(),
		   CheckTenantEmptyActorState<CheckTenantEmptyActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTenantEmpty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2524881804661134336UL, 18382370219238878464UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTenantEmpty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTenantEmpty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTenantEmptyActor, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckTenantEmptyActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
[[nodiscard]] static Future<Void> checkTenantEmpty( DeleteTenantImpl* const& self, Reference<ITransaction> const& tr ) {
															#line 89 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	return Future<Void>(new CheckTenantEmptyActor(self, tr));
															#line 866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
}

#line 106 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"

	// Mark the tenant as being in a removing state on the management cluster
																#line 872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
// This generated class is to be used only via markTenantInRemovingState()
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class MarkTenantInRemovingStateActor>
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class MarkTenantInRemovingStateActorState {
															#line 878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	MarkTenantInRemovingStateActorState(DeleteTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		 : self(self),
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   tr(tr)
															#line 887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
	{
		fdb_probe_actor_create("markTenantInRemovingState", reinterpret_cast<unsigned long>(this));

	}
	~MarkTenantInRemovingStateActorState() 
	{
		fdb_probe_actor_destroy("markTenantInRemovingState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<MetaclusterTenantMapEntry> __when_expr_0 = getTenantTransaction(tr, self->tenantId);
															#line 110 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<MarkTenantInRemovingStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkTenantInRemovingStateActor*>(this)->actor_wait_state = 1;
															#line 110 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >*>(static_cast<MarkTenantInRemovingStateActor*>(this)));
															#line 909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkTenantInRemovingStateActorState();
		static_cast<MarkTenantInRemovingStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 112 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (tenantEntry.tenantState != TenantState::REMOVING)
															#line 932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 113 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			tenantEntry.tenantState = TenantState::REMOVING;
															#line 115 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			metadata::management::tenantMetadata().tenantMap.set(tr, tenantEntry.id, tenantEntry);
															#line 116 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
															#line 119 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<MarkTenantInRemovingStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantInRemovingStateActorState(); static_cast<MarkTenantInRemovingStateActor*>(this)->destroy(); return 0; }
															#line 944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<MarkTenantInRemovingStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkTenantInRemovingStateActorState();
		static_cast<MarkTenantInRemovingStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(MetaclusterTenantMapEntry const& __tenantEntry,int loopDepth) 
	{
															#line 110 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(MetaclusterTenantMapEntry && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkTenantInRemovingStateActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantInRemovingStateActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantInRemovingStateActor*>(this)->ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >*,MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantInRemovingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >*,MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantInRemovingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantInRemovingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantImpl* self;
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 110 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	MetaclusterTenantMapEntry tenantEntry;
															#line 1037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
};
// This generated class is to be used only via markTenantInRemovingState()
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class MarkTenantInRemovingStateActor final : public Actor<Void>, public ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >, public FastAllocated<MarkTenantInRemovingStateActor>, public MarkTenantInRemovingStateActorState<MarkTenantInRemovingStateActor> {
															#line 1042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
	using FastAllocated<MarkTenantInRemovingStateActor>::operator new;
	using FastAllocated<MarkTenantInRemovingStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3749647978330197760UL, 17688795688385202432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >;
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	MarkTenantInRemovingStateActor(DeleteTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		 : Actor<Void>(),
		   MarkTenantInRemovingStateActorState<MarkTenantInRemovingStateActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18017347094198790144UL, 14183984063638199296UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantInRemovingStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markTenantInRemovingState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markTenantInRemovingState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkTenantInRemovingStateActor, 0, MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
[[nodiscard]] static Future<Void> markTenantInRemovingState( DeleteTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 108 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	return Future<Void>(new MarkTenantInRemovingStateActor(self, tr));
															#line 1091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
}

#line 121 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"

	// Delete the tenant and related metadata on the management cluster
																#line 1097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
// This generated class is to be used only via deleteTenantFromManagementCluster()
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class DeleteTenantFromManagementClusterActor>
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class DeleteTenantFromManagementClusterActorState {
															#line 1103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantFromManagementClusterActorState(DeleteTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		 : self(self),
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   tr(tr)
															#line 1112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
	{
		fdb_probe_actor_create("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantFromManagementClusterActorState() 
	{
		fdb_probe_actor_destroy("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 125 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<Optional<MetaclusterTenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, self->tenantId);
															#line 125 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state = 1;
															#line 125 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*>(static_cast<DeleteTenantFromManagementClusterActor*>(this)));
															#line 1134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantFromManagementClusterActorState();
		static_cast<DeleteTenantFromManagementClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 127 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!tenantEntry.present())
															#line 1157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 128 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Tenant removed during deletion");
															#line 129 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (!static_cast<DeleteTenantFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantFromManagementClusterActorState(); static_cast<DeleteTenantFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			new (&static_cast<DeleteTenantFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DeleteTenantFromManagementClusterActorState();
			static_cast<DeleteTenantFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 132 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		ASSERT(tenantEntry.get().tenantState == TenantState::REMOVING);
															#line 135 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		metadata::management::tenantMetadata().tenantMap.erase(tr, tenantEntry.get().id);
															#line 136 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		metadata::management::tenantMetadata().tenantNameIndex.erase(tr, tenantEntry.get().tenantName);
															#line 137 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 140 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		metadata::management::tenantMetadata().tenantCount.atomicOp(tr, -1, MutationRef::AddValue);
															#line 141 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		metadata::management::clusterTenantCount().atomicOp( tr, tenantEntry.get().assignedCluster, -1, MutationRef::AddValue);
															#line 145 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		metadata::management::clusterTenantIndex().erase( tr, Tuple::makeTuple(tenantEntry.get().assignedCluster, tenantEntry.get().tenantName, self->tenantId));
															#line 148 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (tenantEntry.get().renameDestination.present())
															#line 1185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 149 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Remove tenant that is being renamed");
															#line 151 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			metadata::management::tenantMetadata().tenantNameIndex.erase(tr, tenantEntry.get().renameDestination.get());
															#line 153 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			metadata::management::clusterTenantIndex().erase(tr, Tuple::makeTuple(tenantEntry.get().assignedCluster, tenantEntry.get().renameDestination.get(), TenantInfo::INVALID_TENANT));
															#line 1193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
															#line 160 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<Void> __when_expr_1 = internal::managementClusterRemoveTenantFromGroup( tr, tenantEntry.get(), &self->ctx.dataClusterMetadata.get());
															#line 160 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state = 2;
															#line 160 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >*>(static_cast<DeleteTenantFromManagementClusterActor*>(this)));
															#line 1204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		tenantEntry = __tenantEntry;
															#line 1213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterTenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantFromManagementClusterActor*>(this)->ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Optional<MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<DeleteTenantFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantFromManagementClusterActorState(); static_cast<DeleteTenantFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<DeleteTenantFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantFromManagementClusterActorState();
		static_cast<DeleteTenantFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<DeleteTenantFromManagementClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantFromManagementClusterActorState(); static_cast<DeleteTenantFromManagementClusterActor*>(this)->destroy(); return 0; }
															#line 1304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<DeleteTenantFromManagementClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantFromManagementClusterActorState();
		static_cast<DeleteTenantFromManagementClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantFromManagementClusterActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantFromManagementClusterActor*>(this)->ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantImpl* self;
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 125 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Optional<MetaclusterTenantMapEntry> tenantEntry;
															#line 1393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
};
// This generated class is to be used only via deleteTenantFromManagementCluster()
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class DeleteTenantFromManagementClusterActor final : public Actor<Void>, public ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >, public ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >, public FastAllocated<DeleteTenantFromManagementClusterActor>, public DeleteTenantFromManagementClusterActorState<DeleteTenantFromManagementClusterActor> {
															#line 1398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
	using FastAllocated<DeleteTenantFromManagementClusterActor>::operator new;
	using FastAllocated<DeleteTenantFromManagementClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17675075949549732608UL, 5973946966375032064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >;
friend struct ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >;
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantFromManagementClusterActor(DeleteTenantImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 1416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		 : Actor<Void>(),
		   DeleteTenantFromManagementClusterActorState<DeleteTenantFromManagementClusterActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2201708230440625408UL, 11544627752906401024UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantFromManagementClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenantFromManagementCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenantFromManagementCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantFromManagementClusterActor, 0, Optional<MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantFromManagementClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
[[nodiscard]] static Future<Void> deleteTenantFromManagementCluster( DeleteTenantImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 123 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	return Future<Void>(new DeleteTenantFromManagementClusterActor(self, tr));
															#line 1449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
}

#line 165 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"

																#line 1454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
// This generated class is to be used only via run()
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class RunActor>
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class RunActorState {
															#line 1460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	RunActorState(DeleteTenantImpl* const& self) 
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		 : self(self)
															#line 1467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 168 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<std::pair<int64_t, bool>> __when_expr_0 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return getAssignedLocation(self, tr); });
															#line 168 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 168 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, std::pair<int64_t, bool> >*>(static_cast<RunActor*>(this)));
															#line 1489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::pair<int64_t, bool> const& result,int loopDepth) 
	{
															#line 171 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (self->tenantId == -1)
															#line 1512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 172 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			self->tenantId = result.first;
															#line 1516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
		else
		{
															#line 174 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			ASSERT(result.first == self->tenantId);
															#line 1522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
															#line 177 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!result.second)
															#line 1526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 178 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return checkTenantEmpty(self, tr); });
															#line 178 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 178 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 185 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Resume tenant deletion");
															#line 1544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(std::pair<int64_t, bool> && result,int loopDepth) 
	{
															#line 171 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (self->tenantId == -1)
															#line 1554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 172 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			self->tenantId = result.first;
															#line 1558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
		else
		{
															#line 174 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			ASSERT(result.first == self->tenantId);
															#line 1564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		}
															#line 177 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!result.second)
															#line 1568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		{
															#line 178 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<Void> __when_expr_1 = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return checkTenantEmpty(self, tr); });
															#line 178 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 178 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 185 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			CODE_PROBE(true, "Resume tenant deletion");
															#line 1586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(std::pair<int64_t, bool> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<int64_t, bool> && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, std::pair<int64_t, bool> >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, std::pair<int64_t, bool> >*,std::pair<int64_t, bool> const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, std::pair<int64_t, bool> >*,std::pair<int64_t, bool> && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, std::pair<int64_t, bool> >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<Void> __when_expr_3 = self->ctx.runDataClusterTransaction([self = self](Reference<ITransaction> tr) { return TenantAPI::deleteTenantTransaction(tr, self->tenantId, ClusterType::METACLUSTER_DATA); });
															#line 189 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 4;
															#line 189 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunActor, 3, Void >*>(static_cast<RunActor*>(this)));
															#line 1678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 181 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<Void> __when_expr_2 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return markTenantInRemovingState(self, tr); });
															#line 181 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 181 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 1694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 181 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<Void> __when_expr_2 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return markTenantInRemovingState(self, tr); });
															#line 181 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 181 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 1710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<Void> __when_expr_4 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return deleteTenantFromManagementCluster(self, tr); });
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 5;
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunActor, 4, Void >*>(static_cast<RunActor*>(this)));
															#line 1888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		StrictFuture<Void> __when_expr_4 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { return deleteTenantFromManagementCluster(self, tr); });
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 5;
															#line 192 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunActor, 4, Void >*>(static_cast<RunActor*>(this)));
															#line 1904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 1988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantImpl* self;
															#line 2085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
};
// This generated class is to be used only via run()
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, std::pair<int64_t, bool> >, public ActorCallback< RunActor, 1, Void >, public ActorCallback< RunActor, 2, Void >, public ActorCallback< RunActor, 3, Void >, public ActorCallback< RunActor, 4, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 2090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11323445986298488576UL, 5597005243034492672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, std::pair<int64_t, bool> >;
friend struct ActorCallback< RunActor, 1, Void >;
friend struct ActorCallback< RunActor, 2, Void >;
friend struct ActorCallback< RunActor, 3, Void >;
friend struct ActorCallback< RunActor, 4, Void >;
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	RunActor(DeleteTenantImpl* const& self) 
															#line 2111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, std::pair<int64_t, bool> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
[[nodiscard]] static Future<Void> run( DeleteTenantImpl* const& self ) {
															#line 166 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	return Future<Void>(new RunActor(self));
															#line 2147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
}

#line 198 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Future<Void> run() { return run(this); }
};
} // namespace internal

															#line 2155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
// This generated class is to be used only via deleteTenant()
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class DB, class DeleteTenantActor>
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class DeleteTenantActorState {
															#line 2161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantActorState(Reference<DB> const& db,TenantName const& name) 
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		 : db(db),
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   name(name),
															#line 204 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   impl(db, name)
															#line 2172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
	{
		fdb_probe_actor_create("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantActorState() 
	{
		fdb_probe_actor_destroy("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 205 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 205 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 1;
															#line 205 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 0, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 2194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 206 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 2217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 206 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 2229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Reference<DB> db;
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	TenantName name;
															#line 204 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	internal::DeleteTenantImpl<DB> impl;
															#line 2318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
};
// This generated class is to be used only via deleteTenant()
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class DB>
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class DeleteTenantActor final : public Actor<Void>, public ActorCallback< DeleteTenantActor<DB>, 0, Void >, public FastAllocated<DeleteTenantActor<DB>>, public DeleteTenantActorState<DB, DeleteTenantActor<DB>> {
															#line 2325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
	using FastAllocated<DeleteTenantActor<DB>>::operator new;
	using FastAllocated<DeleteTenantActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7457603836124617472UL, 16920776155609637376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantActor<DB>, 0, Void >;
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantActor(Reference<DB> const& db,TenantName const& name) 
															#line 2342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		 : Actor<Void>(),
		   DeleteTenantActorState<DB, DeleteTenantActor<DB>>(db, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14546017859301560576UL, 18123705475076122368UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class DB>
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
[[nodiscard]] Future<Void> deleteTenant( Reference<DB> const& db, TenantName const& name ) {
															#line 202 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	return Future<Void>(new DeleteTenantActor<DB>(db, name));
															#line 2376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
}

#line 208 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"

															#line 2381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
// This generated class is to be used only via deleteTenant()
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class DB, class DeleteTenantActor1>
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class DeleteTenantActor1State {
															#line 2387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantActor1State(Reference<DB> const& db,int64_t const& id) 
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		 : db(db),
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   id(id),
															#line 211 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		   impl(db, id)
															#line 2398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
	{
		fdb_probe_actor_create("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantActor1State() 
	{
		fdb_probe_actor_destroy("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 212 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 212 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			if (static_cast<DeleteTenantActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantActor1*>(this)->actor_wait_state = 1;
															#line 212 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor1, 0, Void >*>(static_cast<DeleteTenantActor1*>(this)));
															#line 2420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantActor1State();
		static_cast<DeleteTenantActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 213 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<DeleteTenantActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActor1State(); static_cast<DeleteTenantActor1*>(this)->destroy(); return 0; }
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<DeleteTenantActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActor1State();
		static_cast<DeleteTenantActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 213 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
		if (!static_cast<DeleteTenantActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActor1State(); static_cast<DeleteTenantActor1*>(this)->destroy(); return 0; }
															#line 2455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		new (&static_cast<DeleteTenantActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActor1State();
		static_cast<DeleteTenantActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantActor1*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor1*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor1*>(this)->ActorCallback< DeleteTenantActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	Reference<DB> db;
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	int64_t id;
															#line 211 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	internal::DeleteTenantImpl<DB> impl;
															#line 2544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
};
// This generated class is to be used only via deleteTenant()
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class DB>
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
class DeleteTenantActor1 final : public Actor<Void>, public ActorCallback< DeleteTenantActor1<DB>, 0, Void >, public FastAllocated<DeleteTenantActor1<DB>>, public DeleteTenantActor1State<DB, DeleteTenantActor1<DB>> {
															#line 2551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
public:
	using FastAllocated<DeleteTenantActor1<DB>>::operator new;
	using FastAllocated<DeleteTenantActor1<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7457603836124617472UL, 16920776155609637376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantActor1<DB>, 0, Void >;
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	DeleteTenantActor1(Reference<DB> const& db,int64_t const& id) 
															#line 2568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
		 : Actor<Void>(),
		   DeleteTenantActor1State<DB, DeleteTenantActor1<DB>>(db, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5458217567662502400UL, 17688968944381675520UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantActor1<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
template <class DB>
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
[[nodiscard]] Future<Void> deleteTenant( Reference<DB> const& db, int64_t const& id ) {
															#line 209 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"
	return Future<Void>(new DeleteTenantActor1<DB>(db, id));
															#line 2602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/metacluster/include/metacluster/DeleteTenant.actor.g.h"
}

#line 215 "/Users/ec2-user/foundationdb/metacluster/include/metacluster/DeleteTenant.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif