#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
/*
 * S3Client.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <string>
#include <vector>
#include <unordered_set>
#include <algorithm>
#include <sstream>
#include <iomanip>

#ifdef _WIN32
#include <io.h>
#endif

#include "fdbclient/S3Client.actor.h"
#include "flow/IAsyncFile.h"
#include "flow/Trace.h"
#include "flow/Traceable.h"
#include "flow/flow.h"
#include "flow/xxhash.h"
#include "flow/Error.h"
#include "rapidxml/rapidxml.hpp"
#include <openssl/sha.h>
#include "libb64/encode.h"

#include "flow/actorcompiler.h" // has to be last include

// Configuration constants
#define S3_CHECKSUM_TAG_NAME "xxhash64"
#define S3_CHECKSUM_FILE_SUFFIX ".checksum"

typedef XXH64_state_t XXHashState;

using ::format; // Use FoundationDB's format, not std::format

// State for a part of a multipart upload.
struct PartState {
	int partNumber = 0;
	std::string etag;
	int64_t offset = 0;
	int64_t size = 0;
	std::string checksum; // MD5 or SHA256 depending on integrity check setting
	bool completed = false;
	std::string partData; // Part data kept for sequential XXH64 checksum calculation after upload

	PartState() = default; // Add explicit default constructor

	PartState(int pNum, int64_t off, int64_t sz, std::string checksum = "")
	  : partNumber(pNum), offset(off), size(sz), checksum(checksum) {}
};

// Config for S3 operations with configurable parameters
struct PartConfig {
	// Basic part configuration
	int64_t partSizeBytes = CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE;
	int baseRetryDelayMs = CLIENT_KNOBS->BLOBSTORE_MULTIPART_RETRY_DELAY_MS;

	// Retry configuration - now configurable instead of magic numbers
	// TODO: Add these to CLIENT_KNOBS for runtime configuration
	int maxPartRetries = 3; // Default: 3 retries per part
	int maxFileRetries = 3; // Default: 3 retries per file
	int maxRetryDelayMs = 30000; // Default: 30 second cap on retry delay

	// Checksum configuration
	// TODO: Add these to CLIENT_KNOBS for runtime configuration
	bool enableChecksumValidation = true; // Default: enable checksum validation
};

// Calculate hash of a file.
// Uses xxhash library because it's fast (supposedly) and used elsewhere in fdb.
// If size is -1, the function will determine the file size automatically.
// Returns a hex string representation of the xxhash64 checksum.
															#line 92 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via calculateFileChecksum()
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CalculateFileChecksumActor>
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActorState {
															#line 99 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActorState(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : file(file),
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(size),
															#line 91 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   pos(0),
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(XXH64_createState()),
															#line 93 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   buffer(65536),
															#line 94 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   readSize()
															#line 116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	~CalculateFileChecksumActorState() 
	{
		fdb_probe_actor_destroy("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_reset(hashState, 0);
															#line 131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			try {
															#line 99 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (size == -1)
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
															#line 100 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					StrictFuture<int64_t> __when_expr_0 = file->size();
															#line 100 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 1;
															#line 100 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 0, int64_t >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t const& s,int loopDepth) 
	{
															#line 101 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t && s,int loopDepth) 
	{
															#line 101 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 119 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 120 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 121 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CalculateFileChecksumActor*>(this)->SAV<std::string>::futures) { (void)(format("%016llx", hash)); this->~CalculateFileChecksumActorState(); static_cast<CalculateFileChecksumActor*>(this)->destroy(); return 0; }
															#line 303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CalculateFileChecksumActor*>(this)->SAV< std::string >::value()) std::string(format("%016llx", hash));
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(pos < size))
															#line 322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 105 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		readSize = std::min<int64_t>(buffer.size(), size - pos);
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_1 = file->read(buffer.data(), readSize, pos);
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 2;
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 1, int >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 108 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 109 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 113 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 115 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 116 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 108 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 109 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 113 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 115 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 116 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 91 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pos;
															#line 92 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 93 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 94 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int readSize;
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via calculateFileChecksum()
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActor final : public Actor<std::string>, public ActorCallback< CalculateFileChecksumActor, 0, int64_t >, public ActorCallback< CalculateFileChecksumActor, 1, int >, public FastAllocated<CalculateFileChecksumActor>, public CalculateFileChecksumActorState<CalculateFileChecksumActor> {
															#line 493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CalculateFileChecksumActor>::operator new;
	using FastAllocated<CalculateFileChecksumActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17911163767881088000UL, 6137477821607639296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CalculateFileChecksumActor, 0, int64_t >;
friend struct ActorCallback< CalculateFileChecksumActor, 1, int >;
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActor(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   CalculateFileChecksumActorState<CalculateFileChecksumActor>(file, size),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12128180428655768320UL, 2149007350426683136UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("calculateFileChecksum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::string> calculateFileChecksum( Reference<IAsyncFile> const& file, int64_t const& size ) {
															#line 90 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::string>(new CalculateFileChecksumActor(file, size));
															#line 545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 127 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

// Get the endpoint for the given s3url.
// Populates parameters and resource with parse of s3url.
Reference<S3BlobStoreEndpoint> getEndpoint(const std::string& s3url,
                                           std::string& resource,
                                           S3BlobStoreEndpoint::ParametersT& parameters) {
	try {
		std::string error;
		Optional<std::string> proxy;
		auto res = g_network->global(INetwork::enProxy);
		if (res) {
			proxy = *static_cast<Optional<std::string>*>(res);
		}
		Reference<S3BlobStoreEndpoint> endpoint =
		    S3BlobStoreEndpoint::fromString(s3url, proxy, &resource, &error, &parameters);

		if (!endpoint) {
			TraceEvent(SevError, "S3ClientGetEndpointNullEndpoint").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		// Let empty resource path be valid - it means list root of bucket

		// Validate bucket parameter exists
		if (parameters.find("bucket") == parameters.end()) {
			TraceEvent(SevError, "S3ClientGetEndpointMissingBucket").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		// Validate resource path characters
		for (char c : resource) {
			if (!isalnum(c) && c != '_' && c != '-' && c != '.' && c != '/') {
				TraceEvent(SevError, "S3ClientGetEndpointIllegalCharacter")
				    .detail("URL", s3url)
				    .detail("Character", std::string(1, c))
				    .detail("Error", error);
				throw backup_invalid_url();
			}
		}

		if (!error.empty()) {
			TraceEvent(SevError, "S3ClientGetEndpointError").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		return endpoint;

	} catch (Error& e) {
		TraceEvent(SevError, "S3ClientGetEndpointFailed").detail("URL", StringRef(s3url)).detail("Error", e.what());
		throw;
	}
}

// Helper function to determine if an error is retryable
bool isRetryableError(int errorCode) {
	return errorCode == error_code_http_bad_response || errorCode == error_code_connection_failed ||
	       errorCode == error_code_lookup_failed || errorCode == error_code_http_request_failed ||
	       errorCode == error_code_io_error || errorCode == error_code_platform_error;
}

// Write checksum with configurable fallback strategy
															#line 610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via writeChecksumWithFallback()
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class WriteChecksumWithFallbackActor>
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class WriteChecksumWithFallbackActorState {
															#line 617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	WriteChecksumWithFallbackActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& checksum,PartConfig const& config) 
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   checksum(checksum),
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config)
															#line 632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	~WriteChecksumWithFallbackActorState() 
	{
		fdb_probe_actor_destroy("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 193 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!config.enableChecksumValidation)
															#line 647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 194 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientChecksumValidationDisabled") .suppressFor(60) .detail("Bucket", bucket) .detail("Object", objectName);
															#line 198 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WriteChecksumWithFallbackActorState();
				static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 203 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				tags = std::map<std::string, std::string>();
															#line 204 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				tags[S3_CHECKSUM_TAG_NAME] = checksum;
															#line 205 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<Void> __when_expr_0 = endpoint->putObjectTags(bucket, objectName, tags);
															#line 205 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 1;
															#line 205 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*>(static_cast<WriteChecksumWithFallbackActor*>(this)));
															#line 673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = endpoint->writeEntireFile(bucket, objectName + S3_CHECKSUM_FILE_SUFFIX, checksum);
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 2;
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*>(static_cast<WriteChecksumWithFallbackActor*>(this)));
															#line 709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 212 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_http_bad_response && e.code() != error_code_file_not_found)
															#line 719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 215 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientTaggingFallback") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Reason", "Tagging not supported, using companion file");
															#line 727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 206 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", checksum);
															#line 210 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 206 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", checksum);
															#line 210 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteChecksumWithFallbackActor*>(this)->ActorCallback< WriteChecksumWithFallbackActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 228 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 228 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteChecksumWithFallbackActor*>(this)->ActorCallback< WriteChecksumWithFallbackActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string checksum;
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 203 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeChecksumWithFallback()
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class WriteChecksumWithFallbackActor final : public Actor<Void>, public ActorCallback< WriteChecksumWithFallbackActor, 0, Void >, public ActorCallback< WriteChecksumWithFallbackActor, 1, Void >, public FastAllocated<WriteChecksumWithFallbackActor>, public WriteChecksumWithFallbackActorState<WriteChecksumWithFallbackActor> {
															#line 961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteChecksumWithFallbackActor>::operator new;
	using FastAllocated<WriteChecksumWithFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16598077318150770176UL, 15536847635827116032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteChecksumWithFallbackActor, 0, Void >;
friend struct ActorCallback< WriteChecksumWithFallbackActor, 1, Void >;
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	WriteChecksumWithFallbackActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& checksum,PartConfig const& config) 
															#line 979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteChecksumWithFallbackActorState<WriteChecksumWithFallbackActor>(endpoint, bucket, objectName, checksum, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18335821694256988416UL, 390065426227613696UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeChecksumWithFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> writeChecksumWithFallback( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& checksum, PartConfig const& config ) {
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new WriteChecksumWithFallbackActor(endpoint, bucket, objectName, checksum, config));
															#line 1013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 230 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

// Read checksum with configurable fallback strategy
															#line 1019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via readChecksumWithFallback()
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ReadChecksumWithFallbackActor>
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class ReadChecksumWithFallbackActorState {
															#line 1026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	ReadChecksumWithFallbackActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,PartConfig const& config) 
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config)
															#line 1039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	~ReadChecksumWithFallbackActorState() 
	{
		fdb_probe_actor_destroy("readChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!config.enableChecksumValidation)
															#line 1054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 237 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevDebug, "S3ClientChecksumValidationDisabled") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
				this->~ReadChecksumWithFallbackActorState();
				static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<std::map<std::string, std::string>> __when_expr_0 = endpoint->getObjectTags(bucket, objectName);
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 1;
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*>(static_cast<ReadChecksumWithFallbackActor*>(this)));
															#line 1076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = endpoint->readEntireFile(bucket, objectName + S3_CHECKSUM_FILE_SUFFIX);
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 2;
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*>(static_cast<ReadChecksumWithFallbackActor*>(this)));
															#line 1113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 255 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_http_bad_response && e.code() != error_code_file_not_found)
															#line 1129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 256 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 258 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientTagsNotAvailable") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FallingBackToFile", "true");
															#line 1137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		auto it = tags.find(S3_CHECKSUM_TAG_NAME);
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (it != tags.end() && !it->second.empty())
															#line 1154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 248 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientChecksumFoundInTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", it->second);
															#line 252 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(it->second)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(it->second));
			this->~ReadChecksumWithFallbackActorState();
			static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<std::string, std::string> const& __tags,int loopDepth) 
	{
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		tags = __tags;
															#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<std::string, std::string> && __tags,int loopDepth) 
	{
		tags = std::move(__tags);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<ReadChecksumWithFallbackActor*>(this)->ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,std::map<std::string, std::string> const& value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,std::map<std::string, std::string> && value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 279 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientNoChecksumFound") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumValidationEnabled", config.enableChecksumValidation ? "true" : "false");
															#line 283 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 274 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_file_not_found)
															#line 1281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 275 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(std::string const& checksum,int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumFoundInFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 272 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(checksum)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(checksum));
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(std::string && checksum,int loopDepth) 
	{
															#line 267 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumFoundInFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 272 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(checksum)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(checksum));
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& checksum,int loopDepth) 
	{
		loopDepth = a_body1cont8(checksum, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && checksum,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(checksum), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<ReadChecksumWithFallbackActor*>(this)->ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 1410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readChecksumWithFallback()
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class ReadChecksumWithFallbackActor final : public Actor<Optional<std::string>>, public ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >, public ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >, public FastAllocated<ReadChecksumWithFallbackActor>, public ReadChecksumWithFallbackActorState<ReadChecksumWithFallbackActor> {
															#line 1415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<ReadChecksumWithFallbackActor>::operator new;
	using FastAllocated<ReadChecksumWithFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11800229378282285312UL, 12402270766103264256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >;
friend struct ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >;
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	ReadChecksumWithFallbackActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,PartConfig const& config) 
															#line 1433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   ReadChecksumWithFallbackActorState<ReadChecksumWithFallbackActor>(endpoint, bucket, objectName, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5279133990643063552UL, 16030994525704471296UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readChecksumWithFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> readChecksumWithFallback( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, PartConfig const& config ) {
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Optional<std::string>>(new ReadChecksumWithFallbackActor(endpoint, bucket, objectName, config));
															#line 1467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 285 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

// Upload a part of a multipart upload with configurable retry logic.

															#line 1474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via uploadPart()
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class UploadPartActor>
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActorState {
															#line 1481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(uploadID),
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(file),
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 295 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 296 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part),
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   attempt(0),
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxRetries(config.maxPartRetries),
															#line 299 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   delayMs(config.baseRetryDelayMs),
															#line 300 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   packets()
															#line 1512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	~UploadPartActorState() 
	{
		fdb_probe_actor_destroy("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 302 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientUploadPartStart") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("MaxRetries", maxRetries);
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 1529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 313 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			partData = std::string();
															#line 314 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			partData.resize(resultPart.size);
															#line 316 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(&partData[0], resultPart.size, resultPart.offset);
															#line 316 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UploadPartActor*>(this)->actor_wait_state = 1;
															#line 316 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 0, int >*>(static_cast<UploadPartActor*>(this)));
															#line 1571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 377 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			attempt++;
															#line 378 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (attempt >= maxRetries || !isRetryableError(e.code()))
															#line 1595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 379 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientUploadPartFailed") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("ErrorCode", e.code()) .detail("Attempts", attempt) .detail("MaxRetries", maxRetries) .detail("FinalError", e.what());
															#line 387 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 390 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientUploadPartRetry") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Attempt", attempt) .detail("Error", e.what()) .detail("DelayMs", delayMs);
															#line 398 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(delayMs / 1000.0);
															#line 398 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UploadPartActor*>(this)->actor_wait_state = 3;
															#line 398 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 2, Void >*>(static_cast<UploadPartActor*>(this)));
															#line 1614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int const& bytesRead,int loopDepth) 
	{
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 1629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 318 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientUploadPartReadError") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset);
															#line 322 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 1635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.partData = std::move(partData);
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string checksum;
															#line 332 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (CLIENT_KNOBS->BLOBSTORE_ENABLE_OBJECT_INTEGRITY_CHECK)
															#line 1643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 334 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			unsigned char hash[SHA256_DIGEST_LENGTH];
															#line 335 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_CTX sha256;
															#line 336 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Init(&sha256);
															#line 337 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Update(&sha256, resultPart.partData.data(), resultPart.partData.size());
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Final(hash, &sha256);
															#line 339 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string hashAsStr = std::string((char*)hash, SHA256_DIGEST_LENGTH);
															#line 340 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string sig = base64::encoder::from_string(hashAsStr);
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			sig.resize(sig.size() - 1);
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = sig;
															#line 1663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		else
		{
															#line 346 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = HTTP::computeMD5Sum(resultPart.partData);
															#line 1669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 350 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.checksum = checksum;
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		packets.discardAll();
															#line 354 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		PacketWriter pw(packets.getWriteBuffer(resultPart.partData.size()), nullptr, Unversioned());
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		pw.serializeBytes(resultPart.partData);
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = endpoint->uploadPart(bucket, objectName, uploadID, resultPart.partNumber, &packets, resultPart.partData.size(), resultPart.checksum);
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UploadPartActor*>(this)->actor_wait_state = 2;
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 1, std::string >*>(static_cast<UploadPartActor*>(this)));
															#line 1688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int && bytesRead,int loopDepth) 
	{
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 1697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 318 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientUploadPartReadError") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset);
															#line 322 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 1703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.partData = std::move(partData);
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string checksum;
															#line 332 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (CLIENT_KNOBS->BLOBSTORE_ENABLE_OBJECT_INTEGRITY_CHECK)
															#line 1711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 334 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			unsigned char hash[SHA256_DIGEST_LENGTH];
															#line 335 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_CTX sha256;
															#line 336 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Init(&sha256);
															#line 337 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Update(&sha256, resultPart.partData.data(), resultPart.partData.size());
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Final(hash, &sha256);
															#line 339 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string hashAsStr = std::string((char*)hash, SHA256_DIGEST_LENGTH);
															#line 340 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string sig = base64::encoder::from_string(hashAsStr);
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			sig.resize(sig.size() - 1);
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = sig;
															#line 1731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		else
		{
															#line 346 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = HTTP::computeMD5Sum(resultPart.partData);
															#line 1737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 350 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.checksum = checksum;
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		packets.discardAll();
															#line 354 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		PacketWriter pw(packets.getWriteBuffer(resultPart.partData.size()), nullptr, Unversioned());
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		pw.serializeBytes(resultPart.partData);
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = endpoint->uploadPart(bucket, objectName, uploadID, resultPart.partNumber, &packets, resultPart.partData.size(), resultPart.checksum);
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UploadPartActor*>(this)->actor_wait_state = 2;
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 1, std::string >*>(static_cast<UploadPartActor*>(this)));
															#line 1756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(std::string const& etag,int loopDepth) 
	{
															#line 365 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 366 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 367 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 375 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 1846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && etag,int loopDepth) 
	{
															#line 365 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 366 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 367 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 375 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 1864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& etag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(etag, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && etag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(etag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 1951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 1960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 295 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 296 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int attempt;
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxRetries;
															#line 299 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int delayMs;
															#line 300 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	UnsentPacketQueue packets;
															#line 313 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string partData;
															#line 2068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via uploadPart()
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActor final : public Actor<PartState>, public ActorCallback< UploadPartActor, 0, int >, public ActorCallback< UploadPartActor, 1, std::string >, public ActorCallback< UploadPartActor, 2, Void >, public FastAllocated<UploadPartActor>, public UploadPartActorState<UploadPartActor> {
															#line 2073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<UploadPartActor>::operator new;
	using FastAllocated<UploadPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4695531104749350144UL, 13791877443532335360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadPartActor, 0, int >;
friend struct ActorCallback< UploadPartActor, 1, std::string >;
friend struct ActorCallback< UploadPartActor, 2, Void >;
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 2092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<PartState>(),
		   UploadPartActorState<UploadPartActor>(endpoint, bucket, objectName, uploadID, file, part, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8500122340480301312UL, 500718127134435072UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadPartActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UploadPartActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UploadPartActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> uploadPart( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& uploadID, Reference<IAsyncFile> const& file, PartState const& part, PartConfig const& config ) {
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new UploadPartActor(endpoint, bucket, objectName, uploadID, file, part, config));
															#line 2127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 403 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy filepath to bucket at resource in s3.
															#line 2133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor>
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActorState {
															#line 2140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 410 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 411 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 412 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(),
															#line 413 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(),
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(XXH64_createState()),
															#line 416 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   retries(0),
															#line 417 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   offset(),
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   partNumber(),
															#line 419 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxConcurrentUploads(),
															#line 420 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   activeFutures(),
															#line 421 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   activePartIndices(),
															#line 422 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   partSize(),
															#line 423 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   numParts(),
															#line 424 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   checksum(),
															#line 425 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(),
															#line 426 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   tags()
															#line 2189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActorState() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 428 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 2204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActorState(); static_cast<CopyUpFileActor*>(this)->destroy(); return 0; }
															#line 2227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyUpFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 430 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Attempt", retries);
															#line 437 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!hashState)
															#line 2249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = XXH64_createState();
															#line 2253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 440 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_reset(hashState, 0);
															#line 442 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 442 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 1;
															#line 442 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 554 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 555 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 558 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if ((e.code() == error_code_file_not_found || e.code() == error_code_http_request_failed || e.code() == error_code_io_error) && retries < config.maxFileRetries)
															#line 2309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 561 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				retryError = e;
															#line 562 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientCopyUpFileRetry") .errorUnsuppressed(retryError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Retries", retries);
															#line 568 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				retries++;
															#line 571 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 572 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = nullptr;
															#line 573 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				parts.clear();
															#line 574 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				activeFutures.clear();
															#line 575 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				activePartIndices.clear();
															#line 577 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 2329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					file = Reference<IAsyncFile>();
															#line 2333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				}
															#line 582 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!uploadID.empty())
															#line 2337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
					try {
															#line 584 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_6 = endpoint->abortMultiPartUpload(bucket, objectName, uploadID);
															#line 584 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 2344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
						static_cast<CopyUpFileActor*>(this)->actor_wait_state = 7;
															#line 584 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 6, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
			}
			else
			{
															#line 602 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				err = e;
															#line 603 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 604 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = nullptr;
															#line 605 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFileError") .detail("Filepath", filepath) .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("Error", err.what()) .detail("Attempts", retries + 1);
															#line 613 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				file = Reference<IAsyncFile>();
															#line 616 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!uploadID.empty())
															#line 2377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
					try {
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_9 = endpoint->abortMultiPartUpload(bucket, objectName, uploadID);
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch2(actor_cancelled(), loopDepth);
															#line 2384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1Catch1when2(__when_expr_9.get(), loopDepth); };
						static_cast<CopyUpFileActor*>(this)->actor_wait_state = 10;
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 9, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont12(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 444 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, int64_t >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 444 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, int64_t >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int64_t const& fileSize,int loopDepth) 
	{
															#line 447 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		size = fileSize;
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = endpoint->beginMultiPartUpload(bucket, objectName);
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 3;
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 2, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(int64_t && fileSize,int loopDepth) 
	{
															#line 447 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		size = fileSize;
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = endpoint->beginMultiPartUpload(bucket, objectName);
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 3;
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 2, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(std::string const& id,int loopDepth) 
	{
															#line 450 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 454 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentUploads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_WRITES_PER_FILE;
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 456 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 459 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 2650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(std::string && id,int loopDepth) 
	{
															#line 450 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 454 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentUploads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_WRITES_PER_FILE;
															#line 455 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 456 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 459 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 2671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(std::string const& id,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(id, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(std::string && id,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(id), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 491 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		std::map<int, S3BlobStoreEndpoint::PartInfo> etagMap;
															#line 492 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 493 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 2759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 494 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFilePartNotCompleted") .detail("PartNumber", part.partNumber) .detail("Offset", part.offset) .detail("Size", part.size);
															#line 498 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 499 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 2767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 501 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			etagMap[part.partNumber] = S3BlobStoreEndpoint::PartInfo(part.etag, part.checksum);
															#line 2771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 504 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_4 = endpoint->finishMultiPartUpload(bucket, objectName, uploadID, etagMap);
															#line 504 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 5;
															#line 504 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 459 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(offset < size))
															#line 2798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;activeFutures.size() < maxConcurrentUploads && offset < size;) {
															#line 462 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, size - offset);
															#line 464 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			part = PartState();
															#line 465 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			part.partNumber = partNumber;
															#line 466 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			part.offset = offset;
															#line 467 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			part.size = partSize;
															#line 468 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.push_back(part);
															#line 470 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			activeFutures.push_back(uploadPart(endpoint, bucket, objectName, uploadID, file, part, config));
															#line 471 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			activePartIndices.push_back(partNumber - 1);
															#line 473 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 474 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 2824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 478 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!activeFutures.empty())
															#line 2828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 479 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::vector<PartState>> __when_expr_3 = getAll(activeFutures);
															#line 479 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 4;
															#line 479 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont4(std::vector<PartState> const& completedParts,int loopDepth) 
	{
															#line 481 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 482 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 2874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 485 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 2880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont4(std::vector<PartState> && completedParts,int loopDepth) 
	{
															#line 481 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 482 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 2891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 485 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 2897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(std::vector<PartState> const& completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont4(completedParts, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(std::vector<PartState> && completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont4(std::move(completedParts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(Optional<std::string> const& s3Checksum,int loopDepth) 
	{
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s3Checksum.present())
															#line 2981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 509 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientMultipartUploadChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("S3ChecksumSHA256", s3Checksum.get());
															#line 2985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 517 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCalculatingFileChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("NumParts", parts.size());
															#line 522 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 523 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.partData.empty())
															#line 2993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 524 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_update(hashState, part.partData.data(), part.partData.size());
															#line 2997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
		}
															#line 529 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		numParts = parts.size();
															#line 530 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 533 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 534 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 535 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		checksum = format("%016llx", hash);
															#line 538 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeChecksumWithFallback(endpoint, bucket, objectName, checksum, config);
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<std::string> && s3Checksum,int loopDepth) 
	{
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s3Checksum.present())
															#line 3030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 509 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientMultipartUploadChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("S3ChecksumSHA256", s3Checksum.get());
															#line 3034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 517 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCalculatingFileChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("NumParts", parts.size());
															#line 522 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 523 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.partData.empty())
															#line 3042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 524 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_update(hashState, part.partData.data(), part.partData.size());
															#line 3046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
		}
															#line 529 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		numParts = parts.size();
															#line 530 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 533 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 534 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 535 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		checksum = format("%016llx", hash);
															#line 538 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeChecksumWithFallback(endpoint, bucket, objectName, checksum, config);
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 541 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<std::string> const& s3Checksum,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(s3Checksum, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<std::string> && s3Checksum,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(s3Checksum), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 4, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 543 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", numParts) .detail("Checksum", checksum) .detail("Duration", now() - startTime) .detail("Attempts", retries + 1);
															#line 3154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 543 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", numParts) .detail("Checksum", checksum) .detail("Duration", now() - startTime) .detail("Attempts", retries + 1);
															#line 3163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
															#line 596 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (g_network->isSimulated())
															#line 3253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_7 = delay(0);
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_7.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 8;
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 7, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1Catch1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
															#line 593 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = "";
															#line 3278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& abortError,int loopDepth=0) 
	{
		try {
															#line 586 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientCopyUpFileAbortError") .error(abortError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("UploadID", uploadID) .detail("OriginalError", retryError.what());
															#line 3288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1Catch1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9(int loopDepth) 
	{
															#line 600 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(1.0 * retries);
															#line 600 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 9;
															#line 600 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 8, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont13(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch2(const Error& abortError,int loopDepth=0) 
	{
		try {
															#line 621 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyUpFileAbortError") .error(abortError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("OriginalError", err.what());
															#line 3606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1Catch1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont14cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 410 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 411 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 412 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 413 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 416 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int retries;
															#line 417 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 419 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxConcurrentUploads;
															#line 420 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> activeFutures;
															#line 421 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<int> activePartIndices;
															#line 422 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 423 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int numParts;
															#line 424 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string checksum;
															#line 425 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 426 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 561 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Error retryError;
															#line 602 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 3765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyUpFile()
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor final : public Actor<Void>, public ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< CopyUpFileActor, 1, int64_t >, public ActorCallback< CopyUpFileActor, 2, std::string >, public ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >, public ActorCallback< CopyUpFileActor, 4, Optional<std::string> >, public ActorCallback< CopyUpFileActor, 5, Void >, public ActorCallback< CopyUpFileActor, 6, Void >, public ActorCallback< CopyUpFileActor, 7, Void >, public ActorCallback< CopyUpFileActor, 8, Void >, public ActorCallback< CopyUpFileActor, 9, Void >, public FastAllocated<CopyUpFileActor>, public CopyUpFileActorState<CopyUpFileActor> {
															#line 3770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyUpFileActor>::operator new;
	using FastAllocated<CopyUpFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6755940544562353152UL, 7698014057707166208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyUpFileActor, 1, int64_t >;
friend struct ActorCallback< CopyUpFileActor, 2, std::string >;
friend struct ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >;
friend struct ActorCallback< CopyUpFileActor, 4, Optional<std::string> >;
friend struct ActorCallback< CopyUpFileActor, 5, Void >;
friend struct ActorCallback< CopyUpFileActor, 6, Void >;
friend struct ActorCallback< CopyUpFileActor, 7, Void >;
friend struct ActorCallback< CopyUpFileActor, 8, Void >;
friend struct ActorCallback< CopyUpFileActor, 9, Void >;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 3796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyUpFileActorState<CopyUpFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5029125091406905600UL, 16817405566823635200UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpFileActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpFileActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyUpFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyUpFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyUpFileActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CopyUpFileActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CopyUpFileActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyUpFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor(endpoint, bucket, objectName, filepath, config));
															#line 3838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 633 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 3843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor1>
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1State {
															#line 3850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1State(std::string const& filepath,std::string const& s3url) 
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : filepath(filepath),
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url)
															#line 3859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActor1State() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 635 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 636 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 637 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 638 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, parameters["bucket"], resource, filepath);
															#line 638 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 1;
															#line 638 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor1, 0, Void >*>(static_cast<CopyUpFileActor1*>(this)));
															#line 3887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 639 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 3910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 639 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 3922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor1*>(this)->ActorCallback< CopyUpFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 4009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyUpFile()
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1 final : public Actor<Void>, public ActorCallback< CopyUpFileActor1, 0, Void >, public FastAllocated<CopyUpFileActor1>, public CopyUpFileActor1State<CopyUpFileActor1> {
															#line 4014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyUpFileActor1>::operator new;
	using FastAllocated<CopyUpFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6755940544562353152UL, 7698014057707166208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor1, 0, Void >;
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1(std::string const& filepath,std::string const& s3url) 
															#line 4031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyUpFileActor1State<CopyUpFileActor1>(filepath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(794650894807017472UL, 16661816041386160896UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpFile( std::string const& filepath, std::string const& s3url ) {
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor1(filepath, s3url));
															#line 4064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 641 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 4069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyUpDirectory()
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpDirectoryActor>
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActorState {
															#line 4076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActorState(std::string const& dirpath,std::string const& s3url) 
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : dirpath(dirpath),
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url),
															#line 643 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 4087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 644 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 645 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 646 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 647 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			files = std::vector<std::string>();
															#line 648 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::findFilesRecursively(dirpath, files);
															#line 649 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirStart") .detail("Filecount", files.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 653 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			RangeForbody1Iterator0 = std::begin(files);
															#line 4114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 658 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 659 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpDirectoryActorState(); static_cast<CopyUpDirectoryActor*>(this)->destroy(); return 0; }
															#line 4139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyUpDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 653 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(files)))
															#line 4158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 653 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& file = *RangeForbody1Iterator0;
															#line 4164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 654 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = file;
															#line 655 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = resource + "/" + file.substr(dirpath.size() + 1);
															#line 656 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, bucket, s3path, filepath);
															#line 656 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 1;
															#line 656 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpDirectoryActor, 0, Void >*>(static_cast<CopyUpDirectoryActor*>(this)));
															#line 4179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 653 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1Iterator0;
															#line 4202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpDirectoryActor*>(this)->ActorCallback< CopyUpDirectoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 643 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 645 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 646 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 647 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<std::string> files;
															#line 653 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<std::string>>())) RangeForbody1Iterator0;
															#line 4308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyUpDirectory()
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActor final : public Actor<Void>, public ActorCallback< CopyUpDirectoryActor, 0, Void >, public FastAllocated<CopyUpDirectoryActor>, public CopyUpDirectoryActorState<CopyUpDirectoryActor> {
															#line 4313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyUpDirectoryActor>::operator new;
	using FastAllocated<CopyUpDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15599107764991513600UL, 18335474880682537728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpDirectoryActor, 0, Void >;
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActor(std::string const& dirpath,std::string const& s3url) 
															#line 4330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyUpDirectoryActorState<CopyUpDirectoryActor>(dirpath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11526468938747652608UL, 2529043041251822336UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpDirectoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpDirectory( std::string const& dirpath, std::string const& s3url ) {
															#line 642 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpDirectoryActor(dirpath, s3url));
															#line 4363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 661 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 4368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpBulkDumpFileSetActor>
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActorState {
															#line 4375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActorState(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   sourceFileSet(sourceFileSet),
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   destinationFileSet(destinationFileSet),
															#line 665 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 4388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpBulkDumpFileSetActorState() 
	{
		fdb_probe_actor_destroy("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 666 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 667 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 670 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetStart") .detail("Bucket", bucket) .detail("SourceFileSet", sourceFileSet.toString()) .detail("DestinationFileSet", destinationFileSet.toString());
															#line 674 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			pNumDeleted = 0;
															#line 675 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			pBytesDeleted = 0;
															#line 676 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			batch_dir = joinPath(getPath(s3url), destinationFileSet.getRelativePath());
															#line 679 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<bool> __when_expr_0 = endpoint->bucketExists(bucket);
															#line 679 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 1;
															#line 679 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& exists,int loopDepth) 
	{
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 4447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && exists,int loopDepth) 
	{
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 4472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 684 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		auto destinationManifestPath = joinPath(batch_dir, destinationFileSet.getManifestFileName());
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = copyUpFile(endpoint, bucket, destinationManifestPath, sourceFileSet.getManifestFileFullPath());
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 3;
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 686 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 4677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 687 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 688 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 688 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 688 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 686 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 4704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 687 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 688 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 688 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 688 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasByteSampleFile())
															#line 4806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			ASSERT(sourceFileSet.hasDataFile());
															#line 692 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationByteSamplePath = joinPath(batch_dir, destinationFileSet.getByteSampleFileName());
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_4 = copyUpFile(endpoint, bucket, destinationByteSamplePath, sourceFileSet.getBytesSampleFileFullPath());
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 5;
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 695 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetEnd") .detail("BatchDir", batch_dir) .detail("NumDeleted", pNumDeleted) .detail("BytesDeleted", pBytesDeleted);
															#line 699 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpBulkDumpFileSetActorState(); static_cast<CopyUpBulkDumpFileSetActor*>(this)->destroy(); return 0; }
															#line 4924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet sourceFileSet;
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet destinationFileSet;
															#line 665 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 667 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 674 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int pNumDeleted;
															#line 675 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pBytesDeleted;
															#line 676 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string batch_dir;
															#line 5037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActor final : public Actor<Void>, public ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >, public ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >, public FastAllocated<CopyUpBulkDumpFileSetActor>, public CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor> {
															#line 5042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator new;
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9294403383604247552UL, 11255682684888395776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >;
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActor(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 5063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor>(s3url, sourceFileSet, destinationFileSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(469867549170568960UL, 8064918125250259712UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpBulkDumpFileSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpBulkDumpFileSet( std::string const& s3url, BulkLoadFileSet const& sourceFileSet, BulkLoadFileSet const& destinationFileSet ) {
															#line 662 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpBulkDumpFileSetActor(s3url, sourceFileSet, destinationFileSet));
															#line 5100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 701 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via downloadPart()
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DownloadPartActor>
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartActorState {
															#line 5112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(file),
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 708 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part),
															#line 709 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   attempt(0),
															#line 710 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxRetries(config.maxPartRetries),
															#line 711 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   delayMs(config.baseRetryDelayMs)
															#line 5137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("downloadPart", reinterpret_cast<unsigned long>(this));

	}
	~DownloadPartActorState() 
	{
		fdb_probe_actor_destroy("downloadPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 713 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientDownloadPartStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 720 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 5154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 722 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			buffer = std::vector<uint8_t>();
															#line 723 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			totalBytesRead = 0;
															#line 724 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			buffer.resize(resultPart.size);
															#line 727 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.offset < 0 || resultPart.size <= 0)
															#line 5191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 728 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientDownloadPartInvalidRange") .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 731 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 5197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 734 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 5201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 782 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			attempt++;
															#line 783 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (attempt >= maxRetries || !isRetryableError(e.code()))
															#line 5225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 784 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartFailed") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("ErrorCode", e.code()) .detail("Attempts", attempt) .detail("FinalError", e.what());
															#line 791 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 794 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevInfo, "S3ClientDownloadPartRetry") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Attempt", attempt) .detail("Error", e.what()) .detail("DelayMs", delayMs);
															#line 802 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(delayMs / 1000.0);
															#line 802 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DownloadPartActor*>(this)->actor_wait_state = 3;
															#line 802 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 2, Void >*>(static_cast<DownloadPartActor*>(this)));
															#line 5244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 750 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (totalBytesRead != resultPart.size)
															#line 5259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 751 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartSizeMismatch") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead) .detail("Offset", resultPart.offset) .detail("FilePath", file->getFilename());
															#line 756 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 5265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 760 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!resultPart.checksum.empty())
															#line 5269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 761 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string calculatedMD5 = HTTP::computeMD5Sum(std::string((char*)buffer.data(), totalBytesRead));
															#line 762 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.checksum != calculatedMD5)
															#line 5275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 763 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartChecksumMismatch") .detail("Expected", resultPart.checksum) .detail("Calculated", calculatedMD5);
															#line 766 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(checksum_failed(), loopDepth);
															#line 5281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
		}
															#line 770 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->write(buffer.data(), totalBytesRead, resultPart.offset);
															#line 770 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadPartActor*>(this)->actor_wait_state = 2;
															#line 770 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 1, Void >*>(static_cast<DownloadPartActor*>(this)));
															#line 5293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 734 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(totalBytesRead < resultPart.size))
															#line 5309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 735 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_0 = endpoint->readObject(bucket, objectName, buffer.data() + totalBytesRead, resultPart.size - totalBytesRead, resultPart.offset + totalBytesRead);
															#line 735 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DownloadPartActor*>(this)->actor_wait_state = 1;
															#line 735 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 0, int >*>(static_cast<DownloadPartActor*>(this)));
															#line 5322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead == 0)
															#line 5344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 742 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartUnexpectedEOF") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead);
															#line 745 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 747 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		totalBytesRead += bytesRead;
															#line 5354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead == 0)
															#line 5363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 742 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartUnexpectedEOF") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead);
															#line 745 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 747 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		totalBytesRead += bytesRead;
															#line 5373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 772 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 773 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 780 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartActorState(); static_cast<DownloadPartActor*>(this)->destroy(); return 0; }
															#line 5461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<DownloadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 772 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 773 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 780 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartActorState(); static_cast<DownloadPartActor*>(this)->destroy(); return 0; }
															#line 5477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<DownloadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 803 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 5564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 803 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 5573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 708 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 709 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int attempt;
															#line 710 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxRetries;
															#line 711 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int delayMs;
															#line 722 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 723 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t totalBytesRead;
															#line 5677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via downloadPart()
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartActor final : public Actor<PartState>, public ActorCallback< DownloadPartActor, 0, int >, public ActorCallback< DownloadPartActor, 1, Void >, public ActorCallback< DownloadPartActor, 2, Void >, public FastAllocated<DownloadPartActor>, public DownloadPartActorState<DownloadPartActor> {
															#line 5682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<DownloadPartActor>::operator new;
	using FastAllocated<DownloadPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7091494355646493696UL, 18259899485127084800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadPartActor, 0, int >;
friend struct ActorCallback< DownloadPartActor, 1, Void >;
friend struct ActorCallback< DownloadPartActor, 2, Void >;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 5701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<PartState>(),
		   DownloadPartActorState<DownloadPartActor>(endpoint, bucket, objectName, file, part, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7678294994590579968UL, 4572654359242003456UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadPartActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DownloadPartActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DownloadPartActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> downloadPart( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, Reference<IAsyncFile> const& file, PartState const& part, PartConfig const& config ) {
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new DownloadPartActor(endpoint, bucket, objectName, file, part, config));
															#line 5736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 807 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getExpectedChecksum()
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class GetExpectedChecksumActor>
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class GetExpectedChecksumActorState {
															#line 5748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	GetExpectedChecksumActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName) 
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName)
															#line 5759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getExpectedChecksum", reinterpret_cast<unsigned long>(this));

	}
	~GetExpectedChecksumActorState() 
	{
		fdb_probe_actor_destroy("getExpectedChecksum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 811 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			PartConfig config;
															#line 812 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Optional<std::string>> __when_expr_0 = readChecksumWithFallback(endpoint, bucket, objectName, config);
															#line 812 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state = 1;
															#line 812 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*>(static_cast<GetExpectedChecksumActor*>(this)));
															#line 5783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> const& result,int loopDepth) 
	{
															#line 813 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<GetExpectedChecksumActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~GetExpectedChecksumActorState(); static_cast<GetExpectedChecksumActor*>(this)->destroy(); return 0; }
															#line 5806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<GetExpectedChecksumActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(result);
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> && result,int loopDepth) 
	{
															#line 813 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<GetExpectedChecksumActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~GetExpectedChecksumActorState(); static_cast<GetExpectedChecksumActor*>(this)->destroy(); return 0; }
															#line 5818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<GetExpectedChecksumActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(result);
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state > 0) static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<GetExpectedChecksumActor*>(this)->ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 5907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getExpectedChecksum()
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class GetExpectedChecksumActor final : public Actor<Optional<std::string>>, public ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >, public FastAllocated<GetExpectedChecksumActor>, public GetExpectedChecksumActorState<GetExpectedChecksumActor> {
															#line 5912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetExpectedChecksumActor>::operator new;
	using FastAllocated<GetExpectedChecksumActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18284774832016856320UL, 12032412755305460224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >;
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	GetExpectedChecksumActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName) 
															#line 5929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Optional<std::string>>(),
		   GetExpectedChecksumActorState<GetExpectedChecksumActor>(endpoint, bucket, objectName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(871911475965399040UL, 1400255941565895168UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExpectedChecksum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> getExpectedChecksum( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName ) {
															#line 808 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Optional<std::string>>(new GetExpectedChecksumActor(endpoint, bucket, objectName));
															#line 5962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 815 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy down file from s3 to filepath.
															#line 5968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor>
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActorState {
															#line 5975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 822 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 823 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 824 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   fileSize(0),
															#line 825 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   offset(0),
															#line 826 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   partNumber(1),
															#line 827 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   partSize(),
															#line 828 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   expectedChecksum(),
															#line 829 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   retries(0),
															#line 830 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxConcurrentDownloads(),
															#line 831 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   activeDownloadFutures(),
															#line 832 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   activePartIndices()
															#line 6012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActorState() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 834 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 6027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 998 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActorState(); static_cast<CopyDownFileActor*>(this)->destroy(); return 0; }
															#line 6050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyDownFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 836 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Attempt", retries);
															#line 842 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientCopyDownFileBeforeObjectSize") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 845 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = endpoint->objectSize(bucket, objectName);
															#line 845 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 1;
															#line 845 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 0, int64_t >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 943 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if ((e.code() == error_code_file_not_found || e.code() == error_code_http_request_failed || e.code() == error_code_io_error) && retries < config.maxFileRetries)
															#line 6116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 946 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientCopyDownFileRetry") .errorUnsuppressed(e) .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Retries", retries);
															#line 952 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				retries++;
															#line 955 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				parts.clear();
															#line 956 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				activeDownloadFutures.clear();
															#line 957 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				activePartIndices.clear();
															#line 959 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 6130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
					try {
															#line 961 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						file = Reference<IAsyncFile>();
															#line 962 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						IAsyncFileSystem::filesystem()->deleteFile(filepath, true);
															#line 6137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				err = e;
															#line 976 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyDownFileError") .detail("Bucket", bucket) .detail("ObjectName", objectName) .errorUnsuppressed(err) .detail("FilePath", filepath) .detail("FileSize", fileSize);
															#line 983 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 6159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
					try {
															#line 985 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_11 = file->sync();
															#line 985 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch2(actor_cancelled(), loopDepth);
															#line 6166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1Catch1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
						static_cast<CopyDownFileActor*>(this)->actor_wait_state = 12;
															#line 985 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 11, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont10(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t const& s,int loopDepth) 
	{
															#line 846 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCopyDownFileAfterObjectSize") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Size", s);
															#line 850 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 6200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 851 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 854 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(file_not_found(), loopDepth);
															#line 6206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 856 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 859 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 6214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 860 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 6218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 863 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 864 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 865 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 865 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 865 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t && s,int loopDepth) 
	{
															#line 846 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCopyDownFileAfterObjectSize") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Size", s);
															#line 850 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 6244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 851 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 854 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(file_not_found(), loopDepth);
															#line 6250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 856 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 859 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 6258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 860 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 6262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 863 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 864 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 865 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 865 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 865 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(s, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 870 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 870 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(fileSize);
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(fileSize);
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 875 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 876 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 877 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentDownloads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_READS_PER_FILE;
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 879 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 882 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 6589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 875 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 876 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 877 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentDownloads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_READS_PER_FILE;
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 879 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 882 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 6608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 908 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 909 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 6694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 910 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientCopyDownFilePartNotCompleted").detail("PartNumber", part.partNumber);
															#line 911 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 6700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
		}
															#line 915 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = file->truncate(fileSize);
															#line 915 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 6;
															#line 915 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 5, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1(int loopDepth) 
	{
															#line 882 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(offset < fileSize))
															#line 6728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 884 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;activeDownloadFutures.size() < maxConcurrentDownloads && offset < fileSize;) {
															#line 885 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, fileSize - offset);
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.emplace_back(partNumber, offset, partSize, "");
															#line 887 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			activeDownloadFutures.push_back( downloadPart(endpoint, bucket, objectName, file, parts.back(), config));
															#line 889 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			activePartIndices.push_back(partNumber - 1);
															#line 890 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 891 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 6746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!activeDownloadFutures.empty())
															#line 6750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 896 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::vector<PartState>> __when_expr_4 = getAll(activeDownloadFutures);
															#line 896 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 5;
															#line 896 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont4(std::vector<PartState> const& completedParts,int loopDepth) 
	{
															#line 898 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 899 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 6796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 902 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 903 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 6802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont4(std::vector<PartState> && completedParts,int loopDepth) 
	{
															#line 898 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 899 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 6813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 902 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 903 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 6819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1when1(std::vector<PartState> const& completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7loopBody1cont4(completedParts, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1when1(std::vector<PartState> && completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7loopBody1cont4(std::move(completedParts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = file->sync();
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = file->sync();
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_7 = getExpectedChecksum(endpoint, bucket, objectName);
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_7 = getExpectedChecksum(endpoint, bucket, objectName);
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont12cont1(Optional<std::string> const& cs,int loopDepth) 
	{
															#line 921 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (cs.present())
															#line 7117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 922 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = cs.get();
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_8 = calculateFileChecksum(file, fileSize);
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont12cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 9;
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 8, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1(Optional<std::string> && cs,int loopDepth) 
	{
															#line 921 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (cs.present())
															#line 7144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 922 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = cs.get();
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_8 = calculateFileChecksum(file, fileSize);
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont12cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 9;
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 8, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont12when1(Optional<std::string> const& cs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12cont1(cs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12when1(Optional<std::string> && cs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12cont1(std::move(cs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 7, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont12cont2(int loopDepth) 
	{
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 934 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", fileSize) .detail("Checksum", expectedChecksum) .detail("Parts", parts.size());
															#line 7248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont12cont3(int loopDepth) 
	{
															#line 924 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (actualChecksum != expectedChecksum)
															#line 7257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileChecksumMismatch") .detail("Expected", expectedChecksum) .detail("Calculated", actualChecksum);
															#line 928 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(checksum_failed(), loopDepth);
															#line 7263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1when1(std::string const& __actualChecksum,int loopDepth) 
	{
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		actualChecksum = __actualChecksum;
															#line 7273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1when1(std::string && __actualChecksum,int loopDepth) 
	{
		actualChecksum = std::move(__actualChecksum);
		loopDepth = a_body1loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 8, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 8, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 969 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (g_network->isSimulated())
															#line 7358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 970 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_9 = delay(0);
															#line 970 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont2when1(__when_expr_9.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 10;
															#line 970 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 9, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1Catch1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& cleanupError,int loopDepth=0) 
	{
		try {
															#line 964 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileCleanupError") .detail("FilePath", filepath) .errorUnsuppressed(cleanupError);
															#line 7390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(int loopDepth) 
	{
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(1.0 * retries);
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 11;
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 10, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1Catch1cont10(int loopDepth) 
	{
															#line 994 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 7608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch2(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 989 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileCleanupError") .detail("FilePath", filepath) .errorUnsuppressed(e2);
															#line 7623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1Catch1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void const& _,int loopDepth) 
	{
															#line 986 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 987 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 7640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void && _,int loopDepth) 
	{
															#line 986 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 987 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 7651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1Catch1cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 822 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 823 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 824 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t fileSize;
															#line 825 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 826 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 827 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 828 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string expectedChecksum;
															#line 829 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int retries;
															#line 830 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxConcurrentDownloads;
															#line 831 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> activeDownloadFutures;
															#line 832 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<int> activePartIndices;
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string actualChecksum;
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 7780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyDownFile()
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor final : public Actor<Void>, public ActorCallback< CopyDownFileActor, 0, int64_t >, public ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CopyDownFileActor, 2, Void >, public ActorCallback< CopyDownFileActor, 3, Void >, public ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >, public ActorCallback< CopyDownFileActor, 5, Void >, public ActorCallback< CopyDownFileActor, 6, Void >, public ActorCallback< CopyDownFileActor, 7, Optional<std::string> >, public ActorCallback< CopyDownFileActor, 8, std::string >, public ActorCallback< CopyDownFileActor, 9, Void >, public ActorCallback< CopyDownFileActor, 10, Void >, public ActorCallback< CopyDownFileActor, 11, Void >, public FastAllocated<CopyDownFileActor>, public CopyDownFileActorState<CopyDownFileActor> {
															#line 7785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyDownFileActor>::operator new;
	using FastAllocated<CopyDownFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7176915676427209472UL, 15298675469969029120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor, 0, int64_t >;
friend struct ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyDownFileActor, 2, Void >;
friend struct ActorCallback< CopyDownFileActor, 3, Void >;
friend struct ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >;
friend struct ActorCallback< CopyDownFileActor, 5, Void >;
friend struct ActorCallback< CopyDownFileActor, 6, Void >;
friend struct ActorCallback< CopyDownFileActor, 7, Optional<std::string> >;
friend struct ActorCallback< CopyDownFileActor, 8, std::string >;
friend struct ActorCallback< CopyDownFileActor, 9, Void >;
friend struct ActorCallback< CopyDownFileActor, 10, Void >;
friend struct ActorCallback< CopyDownFileActor, 11, Void >;
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 7813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyDownFileActorState<CopyDownFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7359276511881238784UL, 3382961653916387328UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyDownFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyDownFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyDownFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyDownFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CopyDownFileActor, 8, std::string >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CopyDownFileActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CopyDownFileActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CopyDownFileActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyDownFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 817 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor(endpoint, bucket, objectName, filepath, config));
															#line 7857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 1000 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 7862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor1>
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1State {
															#line 7869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1State(std::string const& s3url,std::string const& filepath) 
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath)
															#line 7878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActor1State() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1002 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientCopyDownFileWrapperStart").detail("S3URL", s3url).detail("FilePath", filepath);
															#line 1003 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 1004 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 1005 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientCopyDownFileBeforeGetEndpoint").detail("S3URL", s3url);
															#line 1006 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientCopyDownFileAfterGetEndpoint") .detail("S3URL", s3url) .detail("Resource", resource) .detail("Bucket", parameters["bucket"]);
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyDownFile(endpoint, parameters["bucket"], resource, filepath);
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 1;
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor1, 0, Void >*>(static_cast<CopyDownFileActor1*>(this)));
															#line 7912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1012 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCopyDownFileWrapperEnd").detail("S3URL", s3url).detail("FilePath", filepath);
															#line 1013 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 7937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1012 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientCopyDownFileWrapperEnd").detail("S3URL", s3url).detail("FilePath", filepath);
															#line 1013 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 7951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor1*>(this)->ActorCallback< CopyDownFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 8038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyDownFile()
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1 final : public Actor<Void>, public ActorCallback< CopyDownFileActor1, 0, Void >, public FastAllocated<CopyDownFileActor1>, public CopyDownFileActor1State<CopyDownFileActor1> {
															#line 8043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyDownFileActor1>::operator new;
	using FastAllocated<CopyDownFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7176915676427209472UL, 15298675469969029120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor1, 0, Void >;
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1(std::string const& s3url,std::string const& filepath) 
															#line 8060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyDownFileActor1State<CopyDownFileActor1>(s3url, filepath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17010639406587595520UL, 2888716185831900672UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownFile( std::string const& s3url, std::string const& filepath ) {
															#line 1001 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor1(s3url, filepath));
															#line 8093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 1015 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via copyDownDirectory()
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownDirectoryActor>
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActorState {
															#line 8105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActorState(std::string const& s3url,std::string const& dirpath) 
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   dirpath(dirpath),
															#line 1017 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 8116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1018 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 1019 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 1020 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 1021 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_0 = endpoint->listObjects(bucket, resource);
															#line 1021 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 1;
															#line 1021 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 8144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
															#line 1022 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 8171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
															#line 1022 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 8184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
		loopDepth = a_body1cont1(items, loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(items), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1032 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 1033 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownDirectoryActorState(); static_cast<CopyDownDirectoryActor*>(this)->destroy(); return 0; }
															#line 8270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<CopyDownDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(objects)))
															#line 8289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& object = *RangeForbody1cont1Iterator0;
															#line 8295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 1028 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = dirpath + "/" + object.name.substr(resource.size());
															#line 1029 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = object.name;
															#line 1030 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyDownFile(endpoint, bucket, s3path, filepath);
															#line 1030 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 2;
															#line 1030 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 1, Void >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 8310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 8333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 1017 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1019 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 1020 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1022 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<S3BlobStoreEndpoint::ObjectInfo> objects;
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<S3BlobStoreEndpoint::ObjectInfo>>())) RangeForbody1cont1Iterator0;
															#line 8439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via copyDownDirectory()
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActor final : public Actor<Void>, public ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >, public ActorCallback< CopyDownDirectoryActor, 1, Void >, public FastAllocated<CopyDownDirectoryActor>, public CopyDownDirectoryActorState<CopyDownDirectoryActor> {
															#line 8444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<CopyDownDirectoryActor>::operator new;
	using FastAllocated<CopyDownDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13683344193690118400UL, 5325027115877738752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >;
friend struct ActorCallback< CopyDownDirectoryActor, 1, Void >;
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActor(std::string const& s3url,std::string const& dirpath) 
															#line 8462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CopyDownDirectoryActorState<CopyDownDirectoryActor>(s3url, dirpath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10236592472061799424UL, 16660351427764155904UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownDirectory( std::string const& s3url, std::string const& dirpath ) {
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownDirectoryActor(s3url, dirpath));
															#line 8496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 1035 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via deleteResource()
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DeleteResourceActor>
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActorState {
															#line 8508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActorState(std::string const& s3url) 
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1037 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 8517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	~DeleteResourceActorState() 
	{
		fdb_probe_actor_destroy("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1038 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 1039 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 1040 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 1041 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = endpoint->deleteRecursively(bucket, resource);
															#line 1041 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<DeleteResourceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteResourceActor*>(this)->actor_wait_state = 1;
															#line 1041 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteResourceActor, 0, Void >*>(static_cast<DeleteResourceActor*>(this)));
															#line 8545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1042 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 8568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1042 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 8580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteResourceActor*>(this)->actor_wait_state > 0) static_cast<DeleteResourceActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteResourceActor*>(this)->ActorCallback< DeleteResourceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteResourceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1037 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1040 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 8669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via deleteResource()
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActor final : public Actor<Void>, public ActorCallback< DeleteResourceActor, 0, Void >, public FastAllocated<DeleteResourceActor>, public DeleteResourceActorState<DeleteResourceActor> {
															#line 8674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<DeleteResourceActor>::operator new;
	using FastAllocated<DeleteResourceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8006995233907926784UL, 15174814635124207616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteResourceActor, 0, Void >;
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActor(std::string const& s3url) 
															#line 8691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DeleteResourceActorState<DeleteResourceActor>(s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14827851668417892864UL, 17501710632754782464UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteResource");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteResourceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> deleteResource( std::string const& s3url ) {
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new DeleteResourceActor(s3url));
															#line 8724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 1044 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via listFiles()
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFilesActor>
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActorState {
															#line 8736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActorState(std::string const& s3url,int const& maxDepth) 
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxDepth(maxDepth)
															#line 8745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("listFiles", reinterpret_cast<unsigned long>(this));

	}
	~ListFilesActorState() 
	{
		fdb_probe_actor_destroy("listFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1047 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				resource = std::string();
															#line 1048 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				error = std::string();
															#line 1049 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				parameters = S3BlobStoreEndpoint::ParametersT();
															#line 1050 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				bstore = getEndpoint(s3url, resource, parameters);
															#line 1052 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!bstore)
															#line 8769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
															#line 1053 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					TraceEvent(SevError, "S3ClientListingFailed").detail("Error", error);
															#line 1054 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					return a_body1Catch2(backup_invalid_url(), loopDepth);
															#line 8775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				}
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				bucket = parameters["bucket"];
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<bool> __when_expr_0 = bstore->bucketExists(bucket);
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListFilesActor*>(this)->actor_wait_state = 1;
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 0, bool >*>(static_cast<ListFilesActor*>(this)));
															#line 8788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ListFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListFilesActorState(); static_cast<ListFilesActor*>(this)->destroy(); return 0; }
															#line 8817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		new (&static_cast<ListFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1123 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientListFilesError").detail("URL", s3url).detail("Error", e.what());
															#line 1124 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() == error_code_backup_invalid_url)
															#line 8832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 1125 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cerr << "ERROR: Invalid blobstore URL: " << s3url << std::endl;
															#line 8836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1126 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (e.code() == error_code_backup_auth_missing)
															#line 8842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
															#line 1127 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					std::cerr << "ERROR: Authentication information missing from URL" << std::endl;
															#line 8846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				}
				else
				{
															#line 1128 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					if (e.code() == error_code_backup_auth_unreadable)
															#line 8852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					{
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						std::cerr << "ERROR: Could not read authentication information" << std::endl;
															#line 8856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					}
					else
					{
															#line 1130 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						if (e.code() == error_code_http_request_failed)
															#line 8862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						{
															#line 1132 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
							if (e.what() && strstr(e.what(), "NoSuchBucket") != nullptr)
															#line 8866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
							{
															#line 1133 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
								std::cerr << "ERROR: Bucket does not exist" << std::endl;
															#line 8870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
							}
							else
							{
															#line 1134 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
								if (e.what() && strstr(e.what(), "NoSuchKey") != nullptr)
															#line 8876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
								{
															#line 1135 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: Resource does not exist in bucket" << std::endl;
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
									return a_body1Catch1(resource_not_found(), loopDepth);
															#line 8882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
								}
								else
								{
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: HTTP request to blobstore failed" << std::endl;
															#line 8888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
								}
							}
						}
						else
						{
															#line 1141 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
							std::cerr << "ERROR: " << e.what() << std::endl;
															#line 8896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
						}
					}
				}
			}
															#line 1143 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& exists,int loopDepth) 
	{
															#line 1062 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 8917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 1064 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 8923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 1068 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 1069 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 8929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 8933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth);
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 8944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(bool && exists,int loopDepth) 
	{
															#line 1062 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 8953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 1064 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 8959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 1068 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 1069 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 8965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 8969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth);
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 8980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1077 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		std::cout << "Contents of " << s3url << ":" << std::endl;
															#line 1080 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		std::set<std::string> directories;
															#line 1083 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		auto formatSize = [](int64_t size) -> std::string { const char* units[] = { "B", "KB", "MB", "GB", "TB", "PB" }; int unit = 0; double value = static_cast<double>(size); while (value >= 1024.0 && unit < 5) { value /= 1024.0; unit++; } char buffer[32]; snprintf(buffer, sizeof(buffer), "%.2f %s", value, units[unit]); return std::string(buffer); };
															#line 1097 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& prefix : result.commonPrefixes ) {
															#line 1098 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string dirName = prefix;
															#line 1100 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!dirName.empty() && dirName.back() == '/')
															#line 9074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 1101 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				dirName.pop_back();
															#line 9078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 1103 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			directories.insert(dirName);
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cout << "  " << dirName << "/" << std::endl;
															#line 9084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
															#line 1108 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& object : result.objects ) {
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string objectName = object.name;
															#line 1111 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			bool skip = false;
															#line 1112 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			for( const auto& dir : directories ) {
															#line 1113 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (objectName.find(dir + "/") == 0)
															#line 9096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
															#line 1114 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					skip = true;
															#line 9100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					break;
				}
			}
															#line 1118 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!skip)
															#line 9106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cout << " " << objectName << " " << formatSize(object.size) << std::endl;
															#line 9110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult const& __result,int loopDepth) 
	{
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		result = __result;
															#line 9121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxDepth;
															#line 1047 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1048 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string error;
															#line 1049 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ParametersT parameters;
															#line 1050 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1068 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Optional<char> delimiter;
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ListResult result;
															#line 9227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via listFiles()
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActor final : public Actor<Void>, public ActorCallback< ListFilesActor, 0, bool >, public ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >, public FastAllocated<ListFilesActor>, public ListFilesActorState<ListFilesActor> {
															#line 9232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<ListFilesActor>::operator new;
	using FastAllocated<ListFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12240790056908348928UL, 15552948716544106240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFilesActor, 0, bool >;
friend struct ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >;
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActor(std::string const& s3url,int const& maxDepth) 
															#line 9250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ListFilesActorState<ListFilesActor>(s3url, maxDepth),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7548829570599198464UL, 17955669203805414144UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFilesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> listFiles( std::string const& s3url, int const& maxDepth ) {
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new ListFilesActor(s3url, maxDepth));
															#line 9284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 1147 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 9289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via listFiles_impl()
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFiles_implActor>
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActorState {
															#line 9296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActorState(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		 : bstore(bstore),
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		   path(path)
															#line 9307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	~ListFiles_implActorState() 
	{
		fdb_probe_actor_destroy("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bstore->requestRateRead->getAllowance(1);
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListFiles_implActor*>(this)->actor_wait_state = 1;
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 0, Void >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFiles_implActorState();
		static_cast<ListFiles_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1153 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 1155 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1153 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 1155 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
															#line 1160 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 9471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 1161 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 1162 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 9477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		try {
															#line 1166 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 1167 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 1168 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 1170 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 1171 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 9490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 1172 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 1174 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 1177 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 1178 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 1179 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 1180 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 1181 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 9508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 1183 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 9514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					{
															#line 1184 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 1185 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					}
															#line 1187 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 1188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 9526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					{
															#line 1189 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 9530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					}
															#line 1191 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 9534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				}
															#line 1193 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 9538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 1196 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 9542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
															#line 1160 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 9560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		{
															#line 1161 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 1162 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 9566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		try {
															#line 1166 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 1167 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 1168 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 1170 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 1171 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 9579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			{
															#line 1172 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 1174 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 1177 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 1178 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 1179 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 1180 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 1181 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 9597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				{
															#line 1182 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 1183 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 9603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					{
															#line 1184 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 1185 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					}
															#line 1187 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 1188 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 9615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					{
															#line 1189 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 9619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
					}
															#line 1191 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 9623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
				}
															#line 1193 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 9627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			}
															#line 1196 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 9631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont2(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1198 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesError").error(e).detail("Bucket", bucket).detail("Path", path);
															#line 1199 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string path;
															#line 1153 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	HTTP::Headers headers;
															#line 1155 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string fullResource;
															#line 9749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
};
// This generated class is to be used only via listFiles_impl()
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActor final : public Actor<std::vector<std::string>>, public ActorCallback< ListFiles_implActor, 0, Void >, public ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >, public FastAllocated<ListFiles_implActor>, public ListFiles_implActorState<ListFiles_implActor> {
															#line 9754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
public:
	using FastAllocated<ListFiles_implActor>::operator new;
	using FastAllocated<ListFiles_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2598072973598976UL, 14919796625437383936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFiles_implActor, 0, Void >;
friend struct ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >;
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActor(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 9772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
		 : Actor<std::vector<std::string>>(),
		   ListFiles_implActorState<ListFiles_implActor>(bstore, bucket, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14489544770152881408UL, 3479841887926592000UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFiles_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> listFiles_impl( Reference<S3BlobStoreEndpoint> const& bstore, std::string const& bucket, std::string const& path ) {
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::vector<std::string>>(new ListFiles_implActor(bstore, bucket, path));
															#line 9806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/S3Client.actor.g.cpp.py_gen"
}

#line 1202 "/Users/ec2-user/foundationdb/fdbclient/S3Client.actor.cpp"
