#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
/*
 * FileBackupAgent.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbrpc/simulator.h"
#include "flow/EncryptUtils.h"
#include "flow/FastRef.h"
#include "flow/flow.h"
#include "fmt/format.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BlobCipher.h"
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/GetEncryptCipherKeys.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/PartitionedLogIterator.h"
#include "fdbclient/RestoreInterface.h"
#include "fdbclient/Status.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TaskBucket.h"
#include "flow/network.h"
#include "flow/Trace.h"

#include <cinttypes>
#include <cstdint>
#include <ctime>
#include <climits>
#include "flow/IAsyncFile.h"
#include "flow/genericactors.actor.h"
#include "flow/Hash3.h"
#include "flow/xxhash.h"

#include <memory>
#include <numeric>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <algorithm>
#include <unordered_map>
#include <utility>

#include "flow/actorcompiler.h" // This must be the last #include.

Optional<std::string> fileBackupAgentProxy = Optional<std::string>();

#define SevFRTestInfo SevVerbose
// #define SevFRTestInfo SevInfo

static std::string boolToYesOrNo(bool val) {
	return val ? std::string("Yes") : std::string("No");
}

static std::string versionToString(Optional<Version> version) {
	if (version.present())
		return std::to_string(version.get());
	else
		return "N/A";
}

static std::string timeStampToString(Optional<int64_t> epochs) {
	if (!epochs.present())
		return "N/A";
	return BackupAgentBase::formatTime(epochs.get());
}

static Future<Optional<int64_t>> getTimestampFromVersion(Optional<Version> ver,
                                                         Reference<ReadYourWritesTransaction> tr) {
	if (!ver.present())
		return Optional<int64_t>();

	return timeKeeperEpochsFromVersion(ver.get(), tr);
}

// Time format :
// <= 59 seconds
// <= 59.99 minutes
// <= 23.99 hours
// N.NN days
std::string secondsToTimeFormat(int64_t seconds) {
	if (seconds >= 86400)
		return format("%.2f day(s)", seconds / 86400.0);
	else if (seconds >= 3600)
		return format("%.2f hour(s)", seconds / 3600.0);
	else if (seconds >= 60)
		return format("%.2f minute(s)", seconds / 60.0);
	else
		return format("%lld second(s)", seconds);
}

const Key FileBackupAgent::keyLastRestorable = "last_restorable"_sr;

// For convenience
typedef FileBackupAgent::ERestoreState ERestoreState;

StringRef FileBackupAgent::restoreStateText(ERestoreState id) {
	switch (id) {
	case ERestoreState::UNINITIALIZED:
		return "uninitialized"_sr;
	case ERestoreState::QUEUED:
		return "queued"_sr;
	case ERestoreState::STARTING:
		return "starting"_sr;
	case ERestoreState::RUNNING:
		return "running"_sr;
	case ERestoreState::COMPLETED:
		return "completed"_sr;
	case ERestoreState::ABORTED:
		return "aborted"_sr;
	default:
		return "Unknown"_sr;
	}
}

Key FileBackupAgent::getPauseKey() {
	FileBackupAgent backupAgent;
	return backupAgent.taskBucket->getPauseKey();
}

															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getAll_impl()
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TagUidMap_GetAll_implActor>
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActorState {
															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActorState(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tagsMap(tagsMap),
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   snapshot(snapshot),
															#line 145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   prefix(tagsMap->prefix)
															#line 163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	~TagUidMap_GetAll_implActorState() 
	{
		fdb_probe_actor_destroy("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TagMap::RangeResultType> __when_expr_0 = tagsMap->getRange(tr, std::string(), {}, 1e6, snapshot);
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 1;
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*>(static_cast<TagUidMap_GetAll_implActor*>(this)));
															#line 185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 149 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 150 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 149 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 150 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(tagPairs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tagPairs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state > 0) static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 0;
		static_cast<TagUidMap_GetAll_implActor*>(this)->ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap* tagsMap;
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Snapshot snapshot;
															#line 145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key prefix;
															#line 327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAll_impl()
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActor final : public Actor<std::vector<KeyBackedTag>>, public ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >, public FastAllocated<TagUidMap_GetAll_implActor>, public TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor> {
															#line 332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TagUidMap_GetAll_implActor>::operator new;
	using FastAllocated<TagUidMap_GetAll_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3691672905545970944UL, 12766289290525048576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyBackedTag>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >;
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActor(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyBackedTag>>(),
		   TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor>(tagsMap, tr, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4531936230553832704UL, 10523325084301780224UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAll_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::vector<KeyBackedTag>> TagUidMap::getAll_impl( TagUidMap* const& tagsMap, Reference<ReadYourWritesTransaction> const& tr, Snapshot const& snapshot ) {
															#line 142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyBackedTag>>(new TagUidMap_GetAll_implActor(tagsMap, tr, snapshot));
															#line 381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 152 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

KeyBackedTag::KeyBackedTag(std::string tagName, StringRef tagMapPrefix)
  : KeyBackedProperty<UidAndAbortedFlagT>(TagUidMap(tagMapPrefix).getProperty(tagName)), tagName(tagName),
    tagMapPrefix(tagMapPrefix) {}

// Lists all backups and find if any partitioned backup is running.
															#line 391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AnyPartitionedBackupRunningActor>
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActorState {
															#line 398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActorState(Reference<ReadYourWritesTransaction> const& tr) 
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr)
															#line 405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	~AnyPartitionedBackupRunningActorState() 
	{
		fdb_probe_actor_destroy("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 159 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 160 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 161 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyBackedTag>> __when_expr_0 = getAllBackupTags(tr);
															#line 161 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 1;
															#line 161 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 168 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(tags, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(false);
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(i < futures.size()))
															#line 693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 171 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (futures[i].get().present())
															#line 699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 172 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			partitionedLog = Optional<bool>();
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			eState = EBackupState();
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			BackupConfig config(futures[i].get().get().first);
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(eState, config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN)) && store(partitionedLog, config.partitionedLogEnabled().get(tr));
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 3;
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i++;
															#line 743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 178 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(eState) && partitionedLog.present() && partitionedLog.get())
															#line 752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 178 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(eState) && partitionedLog.present() && partitionedLog.get())
															#line 770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<Future<Optional<UidAndAbortedFlagT>>> futures;
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int i;
															#line 172 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<bool> partitionedLog;
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState eState;
															#line 869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActor final : public Actor<bool>, public ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >, public ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >, public ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >, public FastAllocated<AnyPartitionedBackupRunningActor>, public AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor> {
															#line 874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator new;
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15477895209598467072UL, 13270053974605213184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >;
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActor(Reference<ReadYourWritesTransaction> const& tr) 
															#line 893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(587540076039375616UL, 15683259992114904576UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("anyPartitionedBackupRunning");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> anyPartitionedBackupRunning( Reference<ReadYourWritesTransaction> const& tr ) {
															#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new AnyPartitionedBackupRunningActor(tr));
															#line 928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 185 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

class RestoreConfig : public KeyBackedTaskConfig {
public:
	RestoreConfig(UID uid = UID()) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, uid) {}
	RestoreConfig(Reference<Task> task) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, task) {}

	KeyBackedProperty<ERestoreState> stateEnum() { return configSpace.pack(__FUNCTION__sr); }
	Future<StringRef> stateText(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr),
		           [](ERestoreState s) -> StringRef { return FileBackupAgent::restoreStateText(s); });
	}
	KeyBackedProperty<Key> addPrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> removePrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> onlyApplyMutationLogs() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> inconsistentSnapshotOnly() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> unlockDBAfterRestore() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> transformPartitionedLog() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Remove restoreRange() once it is safe to remove. It has been changed to restoreRanges
	KeyBackedProperty<KeyRange> restoreRange() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Changed to restoreRangeSet. It can be removed.
	KeyBackedProperty<std::vector<KeyRange>> restoreRanges() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedSet<KeyRange> restoreRangeSet() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> batchFuture() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> beginVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> restoreVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> firstConsistentVersion() { return configSpace.pack(__FUNCTION__sr); }

	KeyBackedProperty<Reference<IBackupContainer>> sourceContainer() { return configSpace.pack(__FUNCTION__sr); }
	// Get the source container as a bare URL, without creating a container instance
	KeyBackedProperty<Value> sourceContainerURL() { return configSpace.pack("sourceContainer"_sr); }

	// Total bytes written by all log and range restore tasks.
	KeyBackedBinaryValue<int64_t> bytesWritten() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks that have had tasks created for them by the Dispatch task
	KeyBackedBinaryValue<int64_t> filesBlocksDispatched() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks whose tasks have finished
	KeyBackedBinaryValue<int64_t> fileBlocksFinished() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of files in the fileMap
	KeyBackedBinaryValue<int64_t> fileCount() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of file blocks in the fileMap
	KeyBackedBinaryValue<int64_t> fileBlockCount() { return configSpace.pack(__FUNCTION__sr); }

	Future<std::vector<KeyRange>> getRestoreRangesOrDefault(Reference<ReadYourWritesTransaction> tr) {
		return getRestoreRangesOrDefault_impl(this, tr);
	}

																#line 978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetRestoreRangesOrDefault_implActor>
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActorState {
															#line 984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 233 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   ranges(),
															#line 234 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   batchSize(BUGGIFY ? 1 : CLIENT_KNOBS->RESTORE_RANGES_READ_BATCH),
															#line 235 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   begin(),
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   arena()
															#line 1001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetRestoreRangesOrDefault_implActorState() 
	{
		fdb_probe_actor_destroy("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 237 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 1016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 1039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyRange>> __when_expr_1 = self->restoreRanges().getD(tr);
															#line 250 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 2;
															#line 250 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 238 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<KeyBackedSet<KeyRange>::RangeResultType> __when_expr_0 = self->restoreRangeSet().getRange(tr, begin, {}, batchSize);
															#line 238 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 1;
															#line 238 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 241 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 1102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 244 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 1110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 241 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 1121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 244 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 1129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(rangeResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(rangeResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 257 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(ranges); this->~GetRestoreRangesOrDefault_implActorState(); static_cast<GetRestoreRangesOrDefault_implActor*>(this)->destroy(); return 0; }
															#line 1213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(std::move(ranges)); // state_var_RVO
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 252 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 1227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
															#line 251 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 252 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 1254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(_ranges, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_ranges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange const& range,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 1360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange && range,int loopDepth) 
	{
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 1369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange const& range,int loopDepth) 
	{
		loopDepth = a_body1cont5(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange && range,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 233 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 234 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int batchSize;
															#line 235 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<KeyRange> begin;
															#line 236 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 1461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >, public FastAllocated<GetRestoreRangesOrDefault_implActor>, public GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor> {
															#line 1466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator new;
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5163176831890278912UL, 9111048753632441088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >;
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 1485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::vector<KeyRange>>(),
		   GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7781314247607341824UL, 4200768842030992896UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreRangesOrDefault_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*)0, actor_cancelled()); break;
		}

	}
};
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<std::vector<KeyRange>> getRestoreRangesOrDefault_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyRange>>(new GetRestoreRangesOrDefault_implActor(self, tr));
															#line 1519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Describes a file to load blocks from during restore.  Ordered by version and then fileName to enable
	// incrementally advancing through the map, saving the version and path of the next starting point.
	struct RestoreFile {
		Version version; // this is beginVersion, not endVersion
		std::string fileName;
		bool isRange{ false }; // false for log file
		int64_t blockSize{ 0 };
		int64_t fileSize{ 0 };
		Version endVersion{ ::invalidVersion }; // not meaningful for range files
		int64_t tagId = -1; // only meaningful to log files, Log router tag. Non-negative for new backup format.
		int64_t totalTags = -1; // only meaningful to log files, Total number of log router tags.

		Tuple pack() const {
			return Tuple::makeTuple(
			    version, fileName, (int64_t)isRange, fileSize, blockSize, endVersion, tagId, totalTags);
		}
		static RestoreFile unpack(Tuple const& t) {
			RestoreFile r;
			int i = 0;
			r.version = t.getInt(i++);
			r.fileName = t.getString(i++).toString();
			r.isRange = t.getInt(i++) != 0;
			r.fileSize = t.getInt(i++);
			r.blockSize = t.getInt(i++);
			r.endVersion = t.getInt(i++);
			r.tagId = t.getInt(i++);
			r.totalTags = t.getInt(i++);
			return r;
		}
	};

	typedef KeyBackedSet<RestoreFile> FileSetT;
	FileSetT fileSet() { return configSpace.pack(__FUNCTION__sr); }

	FileSetT logFileSet() { return configSpace.pack(__FUNCTION__sr); }
	FileSetT rangeFileSet() { return configSpace.pack(__FUNCTION__sr); }

	Future<bool> isRunnable(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr), [](ERestoreState s) -> bool {
			return s != ERestoreState::ABORTED && s != ERestoreState::COMPLETED && s != ERestoreState::UNINITIALIZED;
		});
	}

	Future<Void> logError(Database cx, Error e, std::string const& details, void* taskInstance = nullptr) {
		if (!uid.isValid()) {
			TraceEvent(SevError, "FileRestoreErrorNoUID").error(e).detail("Description", details);
			return Void();
		}
		TraceEvent t(SevWarn, "FileRestoreError");
		t.error(e)
		    .detail("RestoreUID", uid)
		    .detail("Description", details)
		    .detail("TaskInstance", (uint64_t)taskInstance);
		// key_not_found could happen
		if (e.code() == error_code_key_not_found)
			t.backtrace();

		return updateErrorInfo(cx, e, details);
	}

	Key mutationLogPrefix() { return uidPrefixKey(applyLogKeys.begin, uid); }

	Key applyMutationsMapPrefix() { return uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid); }

																#line 1588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetApplyVersionLag_implActor>
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActorState {
															#line 1594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   uid(uid),
															#line 325 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginVal(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid), Snapshot::True)),
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endVal(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid), Snapshot::True))
															#line 1607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetApplyVersionLag_implActorState() 
	{
		fdb_probe_actor_destroy("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(beginVal) && success(endVal);
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 1;
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetApplyVersionLag_implActor, 0, Void >*>(static_cast<GetApplyVersionLag_implActor*>(this)));
															#line 1629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 1652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 334 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 335 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 1680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 334 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 335 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state > 0) static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetApplyVersionLag_implActor*>(this)->ActorCallback< GetApplyVersionLag_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 325 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> beginVal;
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> endVal;
															#line 1787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActor final : public Actor<int64_t>, public ActorCallback< GetApplyVersionLag_implActor, 0, Void >, public FastAllocated<GetApplyVersionLag_implActor>, public GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor> {
															#line 1792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetApplyVersionLag_implActor>::operator new;
	using FastAllocated<GetApplyVersionLag_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17068909949096035840UL, 3583144671835928064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetApplyVersionLag_implActor, 0, Void >;
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActor(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 1809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<int64_t>(),
		   GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor>(tr, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9614200584100791808UL, 10485171078912906496UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getApplyVersionLag_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetApplyVersionLag_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<int64_t> getApplyVersionLag_impl( Reference<ReadYourWritesTransaction> const& tr, UID const& uid ) {
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<int64_t>(new GetApplyVersionLag_implActor(tr, uid));
															#line 1841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 337 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<int64_t> getApplyVersionLag(Reference<ReadYourWritesTransaction> tr) {
		return getApplyVersionLag_impl(tr, uid);
	}

	void initApplyMutations(Reference<ReadYourWritesTransaction> tr,
	                        Key addPrefix,
	                        Key removePrefix,
	                        OnlyApplyMutationLogs onlyApplyMutationLogs) {
		// Set these because they have to match the applyMutations values.
		this->addPrefix().set(tr, addPrefix);
		this->removePrefix().set(tr, removePrefix);

		clearApplyMutationsKeys(tr);

		// Initialize add/remove prefix, range version map count and set the map's start key to InvalidVersion
		tr->set(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid), addPrefix);
		tr->set(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid), removePrefix);

		int64_t startCount = 0;
		tr->set(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid), StringRef((uint8_t*)&startCount, 8));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->set(mapStart, BinaryWriter::toValue<Version>(invalidVersion, Unversioned()));
	}

	void clearApplyMutationsKeys(Reference<ReadYourWritesTransaction> tr) {
		tr->setOption(FDBTransactionOptions::COMMIT_ON_FIRST_PROXY);

		// Clear add/remove prefix keys
		tr->clear(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid));

		// Clear range version map and count key
		tr->clear(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->clear(KeyRangeRef(mapStart, strinc(mapStart)));

		// Clear any loaded mutations that have not yet been applied
		Key mutationPrefix = mutationLogPrefix();
		tr->clear(KeyRangeRef(mutationPrefix, strinc(mutationPrefix)));

		// Clear end and begin versions (intentionally in this order)
		tr->clear(uidPrefixKey(applyMutationsEndRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsBeginRange.begin, uid));
	}

	void setApplyBeginVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsBeginRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyBeginVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

	void setApplyEndVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsEndRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyEndVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

																#line 1913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getCurrentVersion_impl()
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetCurrentVersion_implActor>
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActorState {
															#line 1919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 1928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetCurrentVersion_implActorState() 
	{
		fdb_probe_actor_destroy("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<ERestoreState> __when_expr_0 = self->stateEnum().getD(tr);
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 1;
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 1950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 407 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = -1;
															#line 408 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (status == ERestoreState::RUNNING)
															#line 1975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(version, self->getApplyBeginVersion(tr));
															#line 409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 2;
															#line 409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 1, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 1986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 410 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (status == ERestoreState::COMPLETED)
															#line 1993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 411 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_2 = store(version, self->restoreVersion().getD(tr));
															#line 411 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 3;
															#line 411 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 2, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 2004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont4(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(ERestoreState const& __status,int loopDepth) 
	{
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = __status;
															#line 2019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ERestoreState && __status,int loopDepth) 
	{
		status = std::move(__status);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 413 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetCurrentVersion_implActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetCurrentVersion_implActorState(); static_cast<GetCurrentVersion_implActor*>(this)->destroy(); return 0; }
															#line 2098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetCurrentVersion_implActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ERestoreState status;
															#line 407 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 2294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getCurrentVersion_impl()
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActor final : public Actor<Version>, public ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >, public ActorCallback< GetCurrentVersion_implActor, 1, Void >, public ActorCallback< GetCurrentVersion_implActor, 2, Void >, public FastAllocated<GetCurrentVersion_implActor>, public GetCurrentVersion_implActorState<GetCurrentVersion_implActor> {
															#line 2299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetCurrentVersion_implActor>::operator new;
	using FastAllocated<GetCurrentVersion_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2017144230918679808UL, 15560255543215443968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >;
friend struct ActorCallback< GetCurrentVersion_implActor, 1, Void >;
friend struct ActorCallback< GetCurrentVersion_implActor, 2, Void >;
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   GetCurrentVersion_implActorState<GetCurrentVersion_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6492461230199787776UL, 8628143503146865408UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCurrentVersion_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Version> getCurrentVersion_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new GetCurrentVersion_implActor(self, tr));
															#line 2352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 415 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Version> getCurrentVersion(Reference<ReadYourWritesTransaction> tr) {
		return getCurrentVersion_impl(this, tr);
	}

																#line 2361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<std::string> getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetProgress_implActorState;

#line 421 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getProgress(Reference<ReadYourWritesTransaction> tr) { return getProgress_impl(*this, tr); }

																#line 2368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<std::string> getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetFullStatus_implActorState;

#line 424 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getFullStatus(Reference<ReadYourWritesTransaction> tr) { return getFullStatus_impl(*this, tr); }
};

typedef RestoreConfig::RestoreFile RestoreFile;

															#line 2378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getProgress_impl()
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetProgress_implActor>
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActorState {
															#line 2384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 2393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetProgress_implActorState() 
	{
		fdb_probe_actor_destroy("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 432 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileCount = restore.fileCount().getD(tr);
															#line 435 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlockCount = restore.fileBlockCount().getD(tr);
															#line 436 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksDispatched = restore.filesBlocksDispatched().getD(tr);
															#line 437 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksFinished = restore.fileBlocksFinished().getD(tr);
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bytesWritten = restore.bytesWritten().getD(tr);
															#line 439 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			status = restore.stateText(tr);
															#line 440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			currentVersion = restore.getCurrentVersion(tr);
															#line 441 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lag = restore.getApplyVersionLag(tr);
															#line 442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			firstConsistentVersion = restore.firstConsistentVersion().getD(tr);
															#line 443 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = restore.tag().getD(tr);
															#line 444 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lastError = restore.lastError().getD(tr);
															#line 447 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uid = restore.getUid();
															#line 448 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fileCount) && success(fileBlockCount) && success(fileBlocksDispatched) && success(fileBlocksFinished) && success(bytesWritten) && success(status) && success(currentVersion) && success(lag) && success(firstConsistentVersion) && success(tag) && success(lastError);
															#line 448 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 1;
															#line 448 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*>(static_cast<RestoreConfig_GetProgress_implActor*>(this)));
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 2468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 454 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 2472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 458 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 2478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 2492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 454 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 2496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 458 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 2502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileCount;
															#line 435 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlockCount;
															#line 436 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksDispatched;
															#line 437 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksFinished;
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> bytesWritten;
															#line 439 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<StringRef> status;
															#line 440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> currentVersion;
															#line 441 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> lag;
															#line 442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> firstConsistentVersion;
															#line 443 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> tag;
															#line 444 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::pair<std::string, Version>> lastError;
															#line 447 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 2613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getProgress_impl()
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetProgress_implActor>, public RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor> {
															#line 2618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5289633511042658560UL, 6534957720108800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >;
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18275805459408915200UL, 825561359449413632UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProgress_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetProgress_implActor(restore, tr));
															#line 2667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 2672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getFullStatus_impl()
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetFullStatus_implActor>
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActorState {
															#line 2678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 2687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetFullStatus_implActorState() 
	{
		fdb_probe_actor_destroy("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 488 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ranges = restore.getRestoreRangesOrDefault(tr);
															#line 492 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			addPrefix = restore.addPrefix().getD(tr);
															#line 493 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			removePrefix = restore.removePrefix().getD(tr);
															#line 494 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			url = restore.sourceContainerURL().getD(tr);
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			restoreVersion = restore.restoreVersion().getD(tr);
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			progress = restore.getProgress(tr);
															#line 499 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ranges) && success(addPrefix) && success(removePrefix) && success(url) && success(restoreVersion) && success(progress);
															#line 499 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 1;
															#line 499 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*>(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)));
															#line 2725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 504 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 505 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 2754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 507 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 511 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 2760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 504 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 505 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 2778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 507 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 511 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 2784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::vector<KeyRange>> ranges;
															#line 492 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> addPrefix;
															#line 493 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> removePrefix;
															#line 494 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> url;
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> restoreVersion;
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> progress;
															#line 2883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getFullStatus_impl()
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetFullStatus_implActor>, public RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor> {
															#line 2888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12244393272683164672UL, 16535945411014203648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >;
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<std::string>(),
		   RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1316626605627362304UL, 15365334437446535168UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFullStatus_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetFullStatus_implActor(restore, tr));
															#line 2937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 513 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// two buffers are alternatively serving data and reading data from file
// thus when one buffer is serving data through peek()
// the other buffer is reading data from file to provide pipelining.
class TwoBuffers : public ReferenceCounted<TwoBuffers>, NonCopyable {
public:
	class IteratorBuffer : public ReferenceCounted<IteratorBuffer> {
	public:
		std::shared_ptr<char[]> data;
		// has_value means there is data, otherwise it means there is no data being fetched or ready
		// is_valid means data is being fetched, is_ready means data is ready
		std::optional<Future<Void>> fetchingData;
		size_t size;
		int index;
		int capacity;
		IteratorBuffer(int _capacity) {
			capacity = _capacity;
			data = std::shared_ptr<char[]>(new char[capacity]());
			fetchingData.reset();
			size = 0;
		}
		bool is_valid() { return fetchingData.has_value(); }
		void reset() {
			size = 0;
			index = 0;
			fetchingData.reset();
		}
	};
	TwoBuffers(int capacity, Reference<IBackupContainer> _bc, std::vector<RestoreConfig::RestoreFile>& _files, int tag);
	// ready need to be called first before calling peek
	// because a shared_ptr cannot be wrapped by a Future
	// this method ensures the current buffer has available data
	Future<Void> ready();
																#line 2974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> ready( Reference<TwoBuffers> const& self );
template <class> friend class TwoBuffers_ReadyActorState;

#line 547 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// fill buffer[index] with the next block of file
	// it has side effects to change currentFileIndex and currentFilePosition
																#line 2981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> readNextBlock( Reference<TwoBuffers> const& self, int const& index );
template <class> friend class TwoBuffers_ReadNextBlockActorState;

#line 550 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// peek can only be called after ready is called
	// it returns the pointer to the active buffer
	std::shared_ptr<char[]> peek();

	int getFileIndex();
	void setFileIndex(int);

	bool hasNext();

	void reset();

	// discard the current buffer and swap to the next one
	void discardAndSwap();

	// try to fill the buffer[index]
	// but no-op if the buffer have valid data or it is actively being filled
	void fillBufferIfAbsent(int index);

	size_t getBufferSize();

private:
	Reference<IteratorBuffer> buffers[2]; // Two buffers for alternating
	size_t bufferCapacity; // Size of each buffer in bytes
	Reference<IBackupContainer> bc;
	std::vector<RestoreConfig::RestoreFile> files;
	int tag;

	int cur; // Index of the current active buffer (0 or 1)
	size_t currentFileIndex; // Index of the current file being read
	size_t currentFilePosition; // Current read position in the current file
};

TwoBuffers::TwoBuffers(int capacity,
                       Reference<IBackupContainer> _bc,
                       std::vector<RestoreConfig::RestoreFile>& _files,
                       int _tag)
  : currentFileIndex(0), currentFilePosition(0), cur(0), bufferCapacity(capacity), files(_files), bc(_bc), tag(_tag) {
	buffers[0] = makeReference<IteratorBuffer>(capacity);
	buffers[1] = makeReference<IteratorBuffer>(capacity);
}

bool TwoBuffers::hasNext() {
	// if it is being load (valid but not ready, what would be the size?)
	while (currentFileIndex < files.size() && currentFilePosition >= files[currentFileIndex].fileSize) {
		currentFileIndex++;
		currentFilePosition = 0;
	}

	if (buffers[0]->is_valid() || buffers[1]->is_valid()) {
		return true;
	}

	return currentFileIndex != files.size();
}

Future<Void> TwoBuffers::ready() {
	return ready(Reference<TwoBuffers>::addRef(this));
}

															#line 3045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via ready()
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadyActor>
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActorState {
															#line 3051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActorState(Reference<TwoBuffers> const& self) 
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 3058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("ready", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadyActorState() 
	{
		fdb_probe_actor_destroy("ready", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 611 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 3073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 612 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 3077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadyActorState();
				static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 615 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(self->cur);
															#line 616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->buffers[self->cur]->fetchingData.value();
															#line 616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 1;
															#line 616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadyActor, 0, Void >*>(static_cast<TwoBuffers_ReadyActor*>(this)));
															#line 3094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 3117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 3121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 621 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 3125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 3137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 3141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 621 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 3145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadyActor*>(this)->ActorCallback< TwoBuffers_ReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 3230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via ready()
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadyActor, 0, Void >, public FastAllocated<TwoBuffers_ReadyActor>, public TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor> {
															#line 3235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TwoBuffers_ReadyActor>::operator new;
	using FastAllocated<TwoBuffers_ReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11177078989683447040UL, 17358110757508174080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadyActor, 0, Void >;
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActor(Reference<TwoBuffers> const& self) 
															#line 3252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14937009140389269760UL, 8193691466251763968UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ready");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::ready( Reference<TwoBuffers> const& self ) {
															#line 609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadyActor(self));
															#line 3284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 623 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

std::shared_ptr<char[]> TwoBuffers::peek() {
	return buffers[cur]->data;
}

int TwoBuffers::getFileIndex() {
	return buffers[cur]->index;
}

void TwoBuffers::setFileIndex(int newIndex) {
	if (newIndex < 0 || newIndex >= files.size()) {
		TraceEvent(SevError, "TwoBuffersFileIndexOutOfBound")
		    .detail("FilesSize", files.size())
		    .detail("NewIndex", newIndex)
		    .log();
	}
	currentFileIndex = newIndex;
}

void TwoBuffers::discardAndSwap() {
	// invalidate cur and change cur to next
	buffers[cur]->fetchingData.reset();
	cur = 1 - cur;
}

void TwoBuffers::reset() {
	// invalidate cur and change cur to next
	buffers[0]->reset();
	buffers[1]->reset();
	cur = 0;
	currentFileIndex = 0;
	currentFilePosition = 0;
}

size_t TwoBuffers::getBufferSize() {
	return buffers[cur]->size;
}

static double testKeyToDouble(const KeyRef& p) {
	uint64_t x = 0;
	sscanf(p.toString().c_str(), "%" SCNx64, &x);
	return *(double*)&x;
}

// only one readNextBlock can be run at a single time, otherwie the same block might be loaded twice
															#line 3333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via readNextBlock()
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadNextBlockActor>
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActorState {
															#line 3339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActorState(Reference<TwoBuffers> const& self,int const& index) 
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   index(index),
															#line 669 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   asyncFile()
															#line 3350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 670 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->currentFileIndex >= self->files.size())
															#line 3365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 671 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevError, "ReadNextBlockOutOfBound") .detail("FileIndex", self->currentFileIndex) .detail("Tag", self->tag) .detail("Position", self->currentFilePosition) .detail("FileSize", self->files[self->currentFileIndex].fileSize) .detail("FilesCount", self->files.size()) .log();
															#line 678 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadNextBlockActorState();
				static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->currentFileIndex].fileName);
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 3386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 3424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 681 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 3448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 687 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 3532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 688 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 3536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 689 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->index = self->currentFileIndex;
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->size = bytesRead;
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->currentFilePosition += bytesRead;
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 3558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int index;
															#line 669 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 685 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 3645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via readNextBlock()
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >, public FastAllocated<TwoBuffers_ReadNextBlockActor>, public TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor> {
															#line 3650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator new;
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15115538906052437760UL, 5654601977280840704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >;
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActor(Reference<TwoBuffers> const& self,int const& index) 
															#line 3668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor>(self, index),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1542594355812348416UL, 14195273269523580672UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::readNextBlock( Reference<TwoBuffers> const& self, int const& index ) {
															#line 668 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadNextBlockActor(self, index));
															#line 3701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 695 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void TwoBuffers::fillBufferIfAbsent(int index) {
	if (buffers[index]->is_valid()) {
		// if this buffer is valid, then do not overwrite it
		return;
	}
	if (currentFileIndex == files.size()) {
		// quit if no more contents
		return;
	}
	auto self = Reference<TwoBuffers>::addRef(this);
	self->buffers[index]->fetchingData = readNextBlock(self, index);
	return;
}

bool endOfBlock(char* start, int offset) {
	const unsigned char paddingChar = '\xff';
	return (unsigned char)*(start + offset) == paddingChar;
}

class PartitionedLogIteratorSimple : public PartitionedLogIterator {
public:
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	size_t bufferCapacity;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	size_t bufferOffset; // Current read offset
	int bufferSize;
	int fileOffset;
	int fileIndex;
	std::shared_ptr<char[]> buffer;
	std::vector<Version> endVersions;

	PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
	                             int _tag,
	                             std::vector<RestoreConfig::RestoreFile> _files,
	                             std::vector<Version> _endVersions);

	bool hasNext();
	Future<Void> loadNextBlock();
																#line 3748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self );
template <class> friend class PartitionedLogIteratorSimple_LoadNextBlockActorState;

#line 739 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	void removeBlockHeader();

	Standalone<VectorRef<VersionedMutation>> consumeData(Version firstVersion);

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 3759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_PeekNextVersionActorState;

#line 746 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 3768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_GetNextActorState;

#line 752 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

PartitionedLogIteratorSimple::PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
                                                           int _tag,
                                                           std::vector<RestoreConfig::RestoreFile> _files,
                                                           std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), endVersions(_endVersions), files(std::move(_files)), bufferOffset(0) {
	bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	buffer = std::shared_ptr<char[]>(new char[bufferCapacity]());
	fileOffset = 0;
	fileIndex = 0;
	bufferSize = 0;
}

// it will set fileOffset and fileIndex
bool PartitionedLogIteratorSimple::hasNext() {
	if (bufferOffset < bufferSize) {
		return true;
	}
	while (fileIndex < files.size() && fileOffset >= files[fileIndex].fileSize) {
		TraceEvent("ReachEndOfLogFiles")
		    .detail("BufferOffset", bufferOffset)
		    .detail("BufferSize", bufferSize)
		    .detail("FileOffset", fileOffset)
		    .detail("FileSize", files[fileIndex].fileSize)
		    .detail("FileName", files[fileIndex].fileName)
		    .detail("Tag", tag)
		    .detail("Index", fileIndex)
		    .log();
		fileOffset = 0;
		fileIndex++;
	}
	return fileIndex < files.size() && fileOffset < files[fileIndex].fileSize;
}

void PartitionedLogIteratorSimple::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

Standalone<VectorRef<VersionedMutation>> PartitionedLogIteratorSimple::consumeData(Version firstVersion) {
	Standalone<VectorRef<VersionedMutation>> mutations = Standalone<VectorRef<VersionedMutation>>();
	char* start = buffer.get();
	bool foundNewVersion = false;
	while (bufferOffset < bufferSize) {
		while (bufferOffset < bufferSize && !endOfBlock(start, bufferOffset)) {
			// for each block
			removeBlockHeader();

			// encoding format:
			// wr << bigEndian64(message.version.version) << bigEndian32(message.version.sub) <<
			// bigEndian32(mutation.size());
			Version version;
			std::memcpy(&version, start + bufferOffset, sizeof(Version));
			version = bigEndian64(version);
			if (version != firstVersion) {
				foundNewVersion = true;
				break; // Different version, stop here
			}

			int32_t subsequence;
			std::memcpy(&subsequence, start + bufferOffset + sizeof(Version), sizeof(int32_t));
			subsequence = bigEndian32(subsequence);

			int32_t mutationSize;
			std::memcpy(&mutationSize, start + bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
			mutationSize = bigEndian32(mutationSize);

			// assumption: the entire mutation is within the buffer
			size_t mutationTotalSize = mutationHeaderBytes + mutationSize;
			ASSERT(bufferOffset + mutationTotalSize <= bufferSize);

			// transform from stringref to mutationref here
			Standalone<StringRef> mutationData = makeString(mutationSize);
			std::memcpy(mutateString(mutationData), start + bufferOffset + mutationHeaderBytes, mutationSize);
			ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
			MutationRef mutation;
			reader >> mutation;

			VersionedMutation vm;
			vm.version = version;
			vm.subsequence = subsequence;
			vm.mutation = mutation;
			mutations.push_back_deep(mutations.arena(), vm);
			// Move the bufferOffset to include this mutation
			bufferOffset += mutationTotalSize;
		}

		if (bufferOffset < bufferSize && endOfBlock(start, bufferOffset)) {
			// there are paddings
			int remain = BLOCK_SIZE - (bufferOffset % BLOCK_SIZE);
			bufferOffset += remain;
		}
		if (foundNewVersion) {
			break;
		}
	}

	return mutations;
}

Future<Void> PartitionedLogIteratorSimple::loadNextBlock() {
	return loadNextBlock(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 3879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via loadNextBlock()
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_LoadNextBlockActor>
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActorState {
															#line 3885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 3892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_LoadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 859 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < self->bufferSize)
															#line 3907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 861 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 863 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 3919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 864 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 866 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			asyncFile = Reference<IAsyncFile>();
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->fileIndex].fileName);
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 3940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 868 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 869 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 871 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 3978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 868 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 869 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 871 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 4002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 874 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 4086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 875 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 4090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 876 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = bytesRead;
															#line 877 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset += bytesRead;
															#line 879 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 4100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 4112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 866 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 869 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 871 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 4197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadNextBlock()
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActor final : public Actor<Void>, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >, public FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>, public PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor> {
															#line 4202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5368276622827784704UL, 15184711332510193152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >;
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 4220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9541533795093038848UL, 7792905219334807296UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> PartitionedLogIteratorSimple::loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new PartitionedLogIteratorSimple_LoadNextBlockActor(self));
															#line 4253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Version> PartitionedLogIteratorSimple::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 4262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via peekNextVersion()
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_PeekNextVersionActor>
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActorState {
															#line 4268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 4275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 888 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 4290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 889 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 4294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 891 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->loadNextBlock();
															#line 891 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 891 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 4309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 892 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 894 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 897 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 4340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 892 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 894 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 897 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 4357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 911 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 4441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 897 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[self->fileIndex]))
															#line 4460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 898 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("SimpleIteratorFindOverlapAndSkip") .detail("Version", version) .detail("FileIndex", self->fileIndex) .log();
															#line 902 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 903 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = 0;
															#line 904 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset = 0;
															#line 905 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileIndex += 1;
															#line 906 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 906 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 906 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 4483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 908 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 909 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 4509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 908 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 909 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 4522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 4606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via peekNextVersion()
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>, public PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor> {
															#line 4611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9812875994556151808UL, 13803557353212135168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >;
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 4629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3510092154139981056UL, 14174065679173900288UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorSimple::peekNextVersion( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorSimple_PeekNextVersionActor(self));
															#line 4662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 4667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getNext()
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_GetNextActor>
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActorState {
															#line 4673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 4682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 917 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 4697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 918 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "SimpleIteratorExhausted") .detail("BufferOffset", self->bufferOffset) .detail("BufferSize", self->bufferSize) .detail("Tag", self->tag) .log();
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 4703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorSimple_GetNextActorState();
				static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 1;
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 4718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 926 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> firstBatch = self->consumeData(firstVersion);
															#line 927 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 4745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 4754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 946 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 4833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->bufferSize))
															#line 4852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 934 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 4858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 937 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 937 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 2;
															#line 937 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 4869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 938 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 940 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 4906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 938 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 940 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 4920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 5007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNext()
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_GetNextActor>, public PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor> {
															#line 5012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17871811441875109120UL, 17891032668415749888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >;
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 5030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17700238840770020608UL, 1654640055383343616UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorSimple_GetNextActor(self));
															#line 5063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 948 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext() {
	return getNext(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

class PartitionedLogIteratorTwoBuffers : public PartitionedLogIterator {
private:
	Reference<TwoBuffers> twobuffer;

	// consume single version data upto the end of the current batch
	// stop if seeing a different version from the parameter.
	// it has side effects to update bufferOffset after reading the data
	Future<Standalone<VectorRef<VersionedMutation>>> consumeData(Version firstVersion);
																#line 5080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& v );
template <class> friend class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState;

#line 964 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// each block has a format of {<header>[mutations]<padding>}, need to skip the header to read mutations
	// this method check if bufferOffset is at the boundary and advance it if necessary
	void removeBlockHeader();

public:
	// read up to a fixed number of block count
	// noted that each version has to be contained within 2 blocks
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	std::vector<Version> endVersions;
	bool hasMoreData; // Flag indicating if more data is available
	size_t bufferOffset; // Current read offset
	// empty means no data, future is valid but not ready means being fetched
	// future is ready means it currently holds data

	PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
	                                 int _tag,
	                                 std::vector<RestoreConfig::RestoreFile> _files,
	                                 std::vector<Version> _endVersions);

	// whether there are more contents for this tag in all files specified
	bool hasNext();

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 5115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState;

#line 995 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 5124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_GetNextActorState;

#line 1001 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData(Version firstVersion) {
	return consumeData(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this), firstVersion);
}

															#line 5135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via consumeData()
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_ConsumeDataActor>
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState {
															#line 5141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   firstVersion(firstVersion),
															#line 1010 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations(Standalone<VectorRef<VersionedMutation>>())
															#line 5152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("consumeData", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState() 
	{
		fdb_probe_actor_destroy("consumeData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 1;
															#line 1011 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)));
															#line 5174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1012 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1013 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1014 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1015 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1018 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1024 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1025 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1026 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 5215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 5219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					break;
				}
															#line 1031 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1032 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1033 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1035 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1038 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1041 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1044 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1048 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1049 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1050 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1052 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1053 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1054 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1055 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1056 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 5260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 5264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1064 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 5270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1066 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 5274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 5281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1012 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1013 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1014 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1015 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1018 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1024 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1025 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1026 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 5311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 5315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					break;
				}
															#line 1031 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1032 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1033 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1035 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1038 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1041 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1044 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1048 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1049 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1050 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1052 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1053 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1054 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1055 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1056 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 5356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 5360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1064 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 5366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1066 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 5370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
				break;
			}
		}
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 5377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 1010 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 5466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via consumeData()
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>, public PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor> {
															#line 5471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13202813324244315392UL, 5242898864605605888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >;
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActor(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 5488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>(self, firstVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6208903078462509824UL, 13390363306797634560UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& firstVersion ) {
															#line 1007 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_ConsumeDataActor(self, firstVersion));
															#line 5520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1072 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void PartitionedLogIteratorTwoBuffers::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

PartitionedLogIteratorTwoBuffers::PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
                                                                   int _tag,
                                                                   std::vector<RestoreConfig::RestoreFile> _files,
                                                                   std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), files(std::move(_files)), endVersions(_endVersions), bufferOffset(0) {
	int bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	twobuffer = makeReference<TwoBuffers>(bufferCapacity, _bc, files, tag);
}

bool PartitionedLogIteratorTwoBuffers::hasNext() {
	return twobuffer->hasNext();
}

Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}
															#line 5547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via peekNextVersion()
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState {
															#line 5553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1098 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   start(),
															#line 1099 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(),
															#line 1100 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   fileIndex()
															#line 5566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1101 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 5581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1102 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 5600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1105 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1106 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1108 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1110 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1105 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1106 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1108 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1110 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1110 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[fileIndex]))
															#line 5755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1111 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("RestoreLogFilesFoundOverlapAndSkip") .detail("Version", version) .detail("FileIndex", fileIndex) .log();
															#line 1116 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->reset();
															#line 1117 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1118 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->setFileIndex(fileIndex + 1);
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->twobuffer->ready();
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 5776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1121 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1122 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1123 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1124 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 5806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1121 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1122 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1123 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1124 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 5823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1098 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::shared_ptr<char[]> start;
															#line 1099 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 1100 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int fileIndex;
															#line 5911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via peekNextVersion()
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>, public PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor> {
															#line 5916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9812875994556151808UL, 13803557353212135168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >;
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 5934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(868233047335415808UL, 8756626667062018304UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(self));
															#line 5967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1128 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 5972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getNext()
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_GetNextActor>
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActorState {
															#line 5978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1131 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 5987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1132 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 6002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1133 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "IteratorExhausted").log();
															#line 1134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 6008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 1;
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_1 = self->consumeData(firstVersion);
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 2;
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 6062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
															#line 1139 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 6143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
															#line 1139 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 6154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(firstBatch, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(firstBatch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1162 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 6238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->twobuffer->getBufferSize()))
															#line 6257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1143 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->discardAndSwap();
															#line 1144 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->twobuffer->hasNext())
															#line 6267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1150 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = self->peekNextVersion();
															#line 1150 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 3;
															#line 1150 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version const& nextVersion,int loopDepth) 
	{
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 6311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version && nextVersion,int loopDepth) 
	{
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 6333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version const& nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(nextVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version && nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(nextVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
															#line 1155 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1156 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
															#line 1155 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1156 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(batch, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(std::move(batch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1131 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 6531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getNext()
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >, public FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>, public PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor> {
															#line 6536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17871811441875109120UL, 17891032668415749888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >;
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 6556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10518556646101966592UL, 11765083271327665664UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_GetNextActor(self));
															#line 6591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext() {
	return getNext(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}

FileBackupAgent::FileBackupAgent()
  : subspace(Subspace(fileBackupPrefixRange.begin))
    // The other subspaces have logUID -> value
    ,
    config(subspace.get(BackupAgentBase::keyConfig)), lastRestorable(subspace.get(FileBackupAgent::keyLastRestorable)),
    taskBucket(new TaskBucket(subspace.get(BackupAgentBase::keyTasks),
                              AccessSystemKeys::True,
                              PriorityBatch::False,
                              LockAware::True)),
    futureBucket(new FutureBucket(subspace.get(BackupAgentBase::keyFutures), AccessSystemKeys::True, LockAware::True)) {
}

namespace fileBackup {

// Return a block of contiguous padding bytes, growing if needed.
Value makePadding(int size) {
	static Value pad;
	if (pad.size() < size) {
		pad = makeString(size);
		memset(mutateString(pad), '\xff', pad.size());
	}

	return pad.substr(0, size);
}

struct IRangeFileWriter {
public:
	virtual Future<Void> padEnd(bool final) = 0;

	virtual Future<Void> writeKV(Key k, Value v) = 0;

	virtual Future<Void> writeKey(Key k) = 0;

	virtual Future<Void> finish() = 0;

	virtual ~IRangeFileWriter() {}
};

struct SnapshotFileBackupEncryptionKeys {
	Reference<BlobCipherKey> textCipherKey;
	Optional<Reference<BlobCipherKey>> headerCipherKey;
	StringRef ivRef;
};

// File Format handlers.
// Both Range and Log formats are designed to be readable starting at any BACKUP_RANGEFILE_BLOCK_SIZE boundary
// so they can be read in parallel.
//
// Writer instances must be kept alive while any member actors are in progress.
//
// EncryptedRangeFileWriter must be used as follows:
//   1 - writeKey(key) the queried key range begin
//   2 - writeKV(k, v) each kv pair to restore
//   3 - writeKey(key) the queried key range end
//   4 - finish()
//
// EncryptedRangeFileWriter will insert the required padding, header, and extra
// end/begin keys around the 1MB boundaries as needed.

struct EncryptedRangeFileWriter : public IRangeFileWriter {
	EncryptedRangeFileWriter(Database cx,
	                         Arena* arena,
	                         EncryptionAtRestMode encryptMode,
	                         Reference<IBackupFile> file = Reference<IBackupFile>(),
	                         int blockSize = 0)
	  : cx(cx), arena(arena), file(file), encryptMode(encryptMode), blockSize(blockSize), blockEnd(0),
	    fileVersion(BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION) {
		buffer = makeString(blockSize);
		wPtr = mutateString(buffer);
	}

																#line 6671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decryptImpl()
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecryptImplActor>
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecryptImplActorState {
															#line 6677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecryptImplActorState(Database const& cx,BlobCipherEncryptHeaderRef const& header,const uint8_t* const& dataP,int64_t const& dataLen,Arena* const& arena) 
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   header(header),
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   dataP(dataP),
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   dataLen(dataLen),
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   arena(arena)
															#line 6692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decryptImpl", reinterpret_cast<unsigned long>(this));

	}
	~DecryptImplActorState() 
	{
		fdb_probe_actor_destroy("decryptImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1245 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Reference<AsyncVar<ClientDBInfo> const> dbInfo = cx->clientInfo;
															#line 1246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			headerRef = header;
															#line 1247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TextAndHeaderCipherKeys> __when_expr_0 = GetEncryptCipherKeys<ClientDBInfo>::getEncryptCipherKeys(dbInfo, headerRef, BlobCipherMetrics::RESTORE);
															#line 1247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecryptImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecryptImplActor*>(this)->actor_wait_state = 1;
															#line 1247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*>(static_cast<DecryptImplActor*>(this)));
															#line 6718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 1249 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptHeaderCipherDetails cipherDetails = headerRef.getCipherDetails();
															#line 1250 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		cipherDetails.textCipherDetails.validateCipherDetailsWithCipherKey(cipherKeys.cipherTextKey);
															#line 1251 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (cipherDetails.headerCipherDetails.present())
															#line 6745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1252 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			cipherDetails.headerCipherDetails.get().validateCipherDetailsWithCipherKey(cipherKeys.cipherHeaderKey);
															#line 6749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1254 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		DecryptBlobCipherAes256Ctr decryptor( cipherKeys.cipherTextKey, cipherKeys.cipherHeaderKey, headerRef.getIV(), BlobCipherMetrics::RESTORE);
															#line 1256 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecryptImplActor*>(this)->SAV<StringRef>::futures) { (void)(decryptor.decrypt(dataP, dataLen, headerRef, *arena)); this->~DecryptImplActorState(); static_cast<DecryptImplActor*>(this)->destroy(); return 0; }
															#line 6755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<DecryptImplActor*>(this)->SAV< StringRef >::value()) StringRef(decryptor.decrypt(dataP, dataLen, headerRef, *arena));
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 1249 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptHeaderCipherDetails cipherDetails = headerRef.getCipherDetails();
															#line 1250 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		cipherDetails.textCipherDetails.validateCipherDetailsWithCipherKey(cipherKeys.cipherTextKey);
															#line 1251 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (cipherDetails.headerCipherDetails.present())
															#line 6771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1252 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			cipherDetails.headerCipherDetails.get().validateCipherDetailsWithCipherKey(cipherKeys.cipherHeaderKey);
															#line 6775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1254 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		DecryptBlobCipherAes256Ctr decryptor( cipherKeys.cipherTextKey, cipherKeys.cipherHeaderKey, headerRef.getIV(), BlobCipherMetrics::RESTORE);
															#line 1256 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecryptImplActor*>(this)->SAV<StringRef>::futures) { (void)(decryptor.decrypt(dataP, dataLen, headerRef, *arena)); this->~DecryptImplActorState(); static_cast<DecryptImplActor*>(this)->destroy(); return 0; }
															#line 6781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<DecryptImplActor*>(this)->SAV< StringRef >::value()) StringRef(decryptor.decrypt(dataP, dataLen, headerRef, *arena));
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecryptImplActor*>(this)->actor_wait_state > 0) static_cast<DecryptImplActor*>(this)->actor_wait_state = 0;
		static_cast<DecryptImplActor*>(this)->ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef header;
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* dataP;
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t dataLen;
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena* arena;
															#line 1246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef headerRef;
															#line 6876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decryptImpl()
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecryptImplActor final : public Actor<StringRef>, public ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >, public FastAllocated<DecryptImplActor>, public DecryptImplActorState<DecryptImplActor> {
															#line 6881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecryptImplActor>::operator new;
	using FastAllocated<DecryptImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5850092322112574208UL, 2955275695472099328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<StringRef>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >;
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecryptImplActor(Database const& cx,BlobCipherEncryptHeaderRef const& header,const uint8_t* const& dataP,int64_t const& dataLen,Arena* const& arena) 
															#line 6898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<StringRef>(),
		   DecryptImplActorState<DecryptImplActor>(cx, header, dataP, dataLen, arena),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4960209422272274432UL, 16507631506561169664UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decryptImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<StringRef> decryptImpl( Database const& cx, BlobCipherEncryptHeaderRef const& header, const uint8_t* const& dataP, int64_t const& dataLen, Arena* const& arena ) {
															#line 1240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<StringRef>(new DecryptImplActor(cx, header, dataP, dataLen, arena));
															#line 6930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1258 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	static Future<StringRef> decrypt(Database cx,
	                                 BlobCipherEncryptHeaderRef header,
	                                 const uint8_t* dataP,
	                                 int64_t dataLen,
	                                 Arena* arena) {
		return decryptImpl(cx, header, dataP, dataLen, arena);
	}

																#line 6943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via refreshKey()
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RefreshKeyActor>
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RefreshKeyActorState {
															#line 6949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RefreshKeyActorState(EncryptedRangeFileWriter* const& self,EncryptCipherDomainId const& domainId) 
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   domainId(domainId)
															#line 6958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("refreshKey", reinterpret_cast<unsigned long>(this));

	}
	~RefreshKeyActorState() 
	{
		fdb_probe_actor_destroy("refreshKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1269 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Reference<AsyncVar<ClientDBInfo> const> dbInfo = self->cx->clientInfo;
															#line 1270 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TextAndHeaderCipherKeys> __when_expr_0 = GetEncryptCipherKeys<ClientDBInfo>::getLatestEncryptCipherKeysForDomain( dbInfo, domainId, BlobCipherMetrics::BACKUP);
															#line 1270 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RefreshKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RefreshKeyActor*>(this)->actor_wait_state = 1;
															#line 1270 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*>(static_cast<RefreshKeyActor*>(this)));
															#line 6982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RefreshKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKeys.cipherTextKey); this->~RefreshKeyActorState(); static_cast<RefreshKeyActor*>(this)->destroy(); return 0; }
															#line 7005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RefreshKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKeys.cipherTextKey);
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RefreshKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKeys.cipherTextKey); this->~RefreshKeyActorState(); static_cast<RefreshKeyActor*>(this)->destroy(); return 0; }
															#line 7017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<RefreshKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKeys.cipherTextKey);
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshKeyActor*>(this)->actor_wait_state > 0) static_cast<RefreshKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshKeyActor*>(this)->ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId domainId;
															#line 7104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via refreshKey()
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RefreshKeyActor final : public Actor<Reference<BlobCipherKey>>, public ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >, public FastAllocated<RefreshKeyActor>, public RefreshKeyActorState<RefreshKeyActor> {
															#line 7109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<RefreshKeyActor>::operator new;
	using FastAllocated<RefreshKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11547663432401662720UL, 7006796426255594240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<BlobCipherKey>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >;
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RefreshKeyActor(EncryptedRangeFileWriter* const& self,EncryptCipherDomainId const& domainId) 
															#line 7126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Reference<BlobCipherKey>>(),
		   RefreshKeyActorState<RefreshKeyActor>(self, domainId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2600401531761827840UL, 1234727541164897536UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Reference<BlobCipherKey>> refreshKey( EncryptedRangeFileWriter* const& self, EncryptCipherDomainId const& domainId ) {
															#line 1267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Reference<BlobCipherKey>>(new RefreshKeyActor(self, domainId));
															#line 7158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1275 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 7163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via encrypt()
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class EncryptActor>
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class EncryptActorState {
															#line 7169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptActorState(EncryptedRangeFileWriter* const& self) 
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 7176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("encrypt", reinterpret_cast<unsigned long>(this));

	}
	~EncryptActorState() 
	{
		fdb_probe_actor_destroy("encrypt", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(self->cipherKeys.headerCipherKey.present() && self->cipherKeys.headerCipherKey.get().isValid() && self->cipherKeys.textCipherKey.isValid());
															#line 1281 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->cipherKeys.headerCipherKey.get()->isExpired() || self->cipherKeys.headerCipherKey.get()->needsRefresh())
															#line 7193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1283 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Reference<BlobCipherKey>> __when_expr_0 = refreshKey(self, self->cipherKeys.headerCipherKey.get()->getDomainId());
															#line 1283 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<EncryptActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<EncryptActor*>(this)->actor_wait_state = 1;
															#line 1283 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*>(static_cast<EncryptActor*>(this)));
															#line 7204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EncryptActorState();
		static_cast<EncryptActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1287 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->cipherKeys.textCipherKey->isExpired() || self->cipherKeys.textCipherKey->needsRefresh())
															#line 7232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1288 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<BlobCipherKey>> __when_expr_1 = refreshKey(self, self->cipherKeys.textCipherKey->getDomainId());
															#line 1288 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<EncryptActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<EncryptActor*>(this)->actor_wait_state = 2;
															#line 1288 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*>(static_cast<EncryptActor*>(this)));
															#line 7243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
															#line 1285 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = cipherKey;
															#line 7257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
															#line 1285 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = cipherKey;
															#line 7266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont2(cipherKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(cipherKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EncryptActor*>(this)->actor_wait_state > 0) static_cast<EncryptActor*>(this)->actor_wait_state = 0;
		static_cast<EncryptActor*>(this)->ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >::remove();

	}
	void a_callback_fire(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> const& value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> && value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Error err) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1291 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptBlobCipherAes265Ctr encryptor( self->cipherKeys.textCipherKey, self->cipherKeys.headerCipherKey, self->cipherKeys.ivRef.begin(), AES_256_IV_LENGTH, getEncryptAuthTokenMode(EncryptAuthTokenMode::ENCRYPT_HEADER_AUTH_TOKEN_MODE_SINGLE), BlobCipherMetrics::BACKUP);
															#line 1298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int64_t payloadSize = self->wPtr - self->dataPayloadStart;
															#line 1299 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StringRef encryptedData;
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		BlobCipherEncryptHeaderRef headerRef;
															#line 1301 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptedData = encryptor.encrypt(self->dataPayloadStart, payloadSize, &headerRef, *self->arena);
															#line 1302 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<StringRef> serialized = BlobCipherEncryptHeaderRef::toStringRef(headerRef);
															#line 1303 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->arena->dependsOn(serialized.arena());
															#line 1304 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(serialized.size() == self->encryptHeader.size());
															#line 1305 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(mutateString(self->encryptHeader), serialized.begin(), self->encryptHeader.size());
															#line 1308 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(self->dataPayloadStart, encryptedData.begin(), payloadSize);
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<EncryptActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EncryptActorState(); static_cast<EncryptActor*>(this)->destroy(); return 0; }
															#line 7370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<EncryptActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EncryptActorState();
		static_cast<EncryptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = cipherKey;
															#line 7382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = cipherKey;
															#line 7391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(cipherKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(cipherKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EncryptActor*>(this)->actor_wait_state > 0) static_cast<EncryptActor*>(this)->actor_wait_state = 0;
		static_cast<EncryptActor*>(this)->ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >::remove();

	}
	void a_callback_fire(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> const& value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> && value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Error err) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 7473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via encrypt()
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class EncryptActor final : public Actor<Void>, public ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >, public ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >, public FastAllocated<EncryptActor>, public EncryptActorState<EncryptActor> {
															#line 7478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<EncryptActor>::operator new;
	using FastAllocated<EncryptActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4639768229114438912UL, 10464376182239072768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >;
friend struct ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >;
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptActor(EncryptedRangeFileWriter* const& self) 
															#line 7496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   EncryptActorState<EncryptActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11460608645555408640UL, 117169993392551936UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("encrypt");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> encrypt( EncryptedRangeFileWriter* const& self ) {
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new EncryptActor(self));
															#line 7529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1311 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 7534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via updateEncryptionKeysCtx()
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class UpdateEncryptionKeysCtxActor>
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class UpdateEncryptionKeysCtxActorState {
															#line 7540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UpdateEncryptionKeysCtxActorState(EncryptedRangeFileWriter* const& self,KeyRef const& key) 
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   key(key)
															#line 7549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this));

	}
	~UpdateEncryptionKeysCtxActorState() 
	{
		fdb_probe_actor_destroy("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1313 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<EncryptCipherDomainId> __when_expr_0 = getEncryptionDomainDetails(key, self->encryptMode);
															#line 1313 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 1;
															#line 1313 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*>(static_cast<UpdateEncryptionKeysCtxActor*>(this)));
															#line 7571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1314 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		dbInfo = self->cx->clientInfo;
															#line 1317 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<TextAndHeaderCipherKeys> __when_expr_1 = GetEncryptCipherKeys<ClientDBInfo>::getLatestEncryptCipherKeysForDomain( dbInfo, curDomainId, BlobCipherMetrics::BACKUP);
															#line 1317 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 2;
															#line 1317 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*>(static_cast<UpdateEncryptionKeysCtxActor*>(this)));
															#line 7603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId const& __curDomainId,int loopDepth) 
	{
															#line 1313 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		curDomainId = __curDomainId;
															#line 7612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId && __curDomainId,int loopDepth) 
	{
		curDomainId = std::move(__curDomainId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state > 0) static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId const& value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId && value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,Error err) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(TextAndHeaderCipherKeys const& textAndHeaderCipherKeys,int loopDepth) 
	{
															#line 1320 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = textAndHeaderCipherKeys.cipherTextKey;
															#line 1321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = textAndHeaderCipherKeys.cipherHeaderKey;
															#line 1324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.ivRef = makeString(AES_256_IV_LENGTH, *self->arena);
															#line 1325 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(self->cipherKeys.ivRef), AES_256_IV_LENGTH);
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateEncryptionKeysCtxActorState(); static_cast<UpdateEncryptionKeysCtxActor*>(this)->destroy(); return 0; }
															#line 7699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TextAndHeaderCipherKeys && textAndHeaderCipherKeys,int loopDepth) 
	{
															#line 1320 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = textAndHeaderCipherKeys.cipherTextKey;
															#line 1321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = textAndHeaderCipherKeys.cipherHeaderKey;
															#line 1324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.ivRef = makeString(AES_256_IV_LENGTH, *self->arena);
															#line 1325 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(self->cipherKeys.ivRef), AES_256_IV_LENGTH);
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateEncryptionKeysCtxActorState(); static_cast<UpdateEncryptionKeysCtxActor*>(this)->destroy(); return 0; }
															#line 7719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys const& textAndHeaderCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(textAndHeaderCipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys && textAndHeaderCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(textAndHeaderCipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state > 0) static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef key;
															#line 1313 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId curDomainId;
															#line 1314 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<AsyncVar<ClientDBInfo> const> dbInfo;
															#line 7810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateEncryptionKeysCtx()
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class UpdateEncryptionKeysCtxActor final : public Actor<Void>, public ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >, public ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >, public FastAllocated<UpdateEncryptionKeysCtxActor>, public UpdateEncryptionKeysCtxActorState<UpdateEncryptionKeysCtxActor> {
															#line 7815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateEncryptionKeysCtxActor>::operator new;
	using FastAllocated<UpdateEncryptionKeysCtxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14081072231798593280UL, 5350323461652516864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >;
friend struct ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >;
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UpdateEncryptionKeysCtxActor(EncryptedRangeFileWriter* const& self,KeyRef const& key) 
															#line 7833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateEncryptionKeysCtxActorState<UpdateEncryptionKeysCtxActor>(self, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2045108966394790400UL, 17453403112709583616UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateEncryptionKeysCtx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> updateEncryptionKeysCtx( EncryptedRangeFileWriter* const& self, KeyRef const& key ) {
															#line 1312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new UpdateEncryptionKeysCtxActor(self, key));
															#line 7866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1328 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Returns the number of bytes that have been written to the buffer
	static int64_t currentBufferSize(EncryptedRangeFileWriter* self) { return self->wPtr - self->buffer.begin(); }

	static int64_t expectedFileSize(EncryptedRangeFileWriter* self) {
		// Return what has already been written to file plus the size of the current buffer
		// which indicates how many bytes the file will contain once the buffer is written
		return self->file->size() + currentBufferSize(self);
	}

	static void copyToBuffer(EncryptedRangeFileWriter* self, const void* src, size_t size) {
		if (size > 0) {
			std::memcpy(self->wPtr, src, size);
			self->wPtr += size;
			ASSERT(currentBufferSize(self) <= self->blockSize);
		}
	}

	static void appendStringRefWithLenToBuffer(EncryptedRangeFileWriter* self, StringRef* s) {
		// Append the string length followed by the string to the buffer
		uint32_t lenBuf = bigEndian32((uint32_t)s->size());
		copyToBuffer(self, &lenBuf, sizeof(lenBuf));
		copyToBuffer(self, s->begin(), s->size());
	}

	// TODO(gglass): this has been simplified for tenant removal.  Maybe it can be
	// simplified further.
	static Future<EncryptCipherDomainId> getEncryptionDomainDetails(KeyRef key, EncryptionAtRestMode encryptMode) {
		if (isSystemKey(key)) {
			return SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID;
		}
		return FDB_DEFAULT_ENCRYPT_DOMAIN_ID;
	}

	// Handles the first block and internal blocks.  Ends current block if needed.
	// The final flag is used in simulation to pad the file's final block to a whole block size
																#line 7906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via newBlock()
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockActor>
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActorState {
															#line 7912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActorState(EncryptedRangeFileWriter* const& self,int const& bytesNeeded,KeyRef const& lastKey,bool const& writeValue,bool const& final = false) 
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded),
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lastKey(lastKey),
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   writeValue(writeValue),
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   final(final)
															#line 7927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("newBlock", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockActorState() 
	{
		fdb_probe_actor_destroy("newBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1370 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int bytesLeft = self->blockEnd - expectedFileSize(self);
															#line 1371 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(bytesLeft >= 0);
															#line 1372 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (bytesLeft > 0)
															#line 7946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1373 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				paddingFFs = makePadding(bytesLeft);
															#line 1374 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				copyToBuffer(self, paddingFFs.begin(), bytesLeft);
															#line 7952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1377 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (expectedFileSize(self) > 0)
															#line 7956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1379 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(currentBufferSize(self) == self->blockSize);
															#line 1380 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = encrypt(self);
															#line 1380 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockActor*>(this)->actor_wait_state = 1;
															#line 1380 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 0, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 7969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1387 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (final)
															#line 7997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1388 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 8003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~NewBlockActorState();
			static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1393 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1396 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		copyToBuffer(self, (uint8_t*)&self->fileVersion, sizeof(self->fileVersion));
															#line 1399 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uint32_t headerSize = 0;
															#line 1400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptAuthTokenMode authTokenMode = getEncryptAuthTokenMode(EncryptAuthTokenMode::ENCRYPT_HEADER_AUTH_TOKEN_MODE_SINGLE);
															#line 1402 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptAuthTokenAlgo authTokenAlgo = getAuthTokenAlgoFromMode(authTokenMode);
															#line 1403 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		headerSize = BlobCipherEncryptHeaderRef::getHeaderSize(CLIENT_KNOBS->ENCRYPT_HEADER_FLAGS_VERSION, getEncryptCurrentAlgoHeaderVersion(authTokenMode, authTokenAlgo), ENCRYPT_CIPHER_MODE_AES_256_CTR, authTokenMode, authTokenAlgo);
															#line 1409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(headerSize > 0);
															#line 1411 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		copyToBuffer(self, (uint8_t*)&headerSize, sizeof(headerSize));
															#line 1413 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->encryptHeader = StringRef(self->wPtr, headerSize);
															#line 1414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr += headerSize;
															#line 1415 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->dataPayloadStart = self->wPtr;
															#line 1418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 8033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1419 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &lastKey);
															#line 1420 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &self->lastKey);
															#line 1421 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (writeValue)
															#line 8041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1422 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				appendStringRefWithLenToBuffer(self, &self->lastValue);
															#line 8045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
		}
															#line 1427 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (expectedFileSize(self) + bytesNeeded > self->blockEnd)
															#line 8050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1428 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 8054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 8058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), self->blockSize);
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 2;
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 1, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), self->blockSize);
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 2;
															#line 1381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 1, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1384 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr = mutateString(self->buffer);
															#line 8177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1384 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr = mutateString(self->buffer);
															#line 8186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef lastKey;
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool writeValue;
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool final;
															#line 1373 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 8278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via newBlock()
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor final : public Actor<Void>, public ActorCallback< NewBlockActor, 0, Void >, public ActorCallback< NewBlockActor, 1, Void >, public FastAllocated<NewBlockActor>, public NewBlockActorState<NewBlockActor> {
															#line 8283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<NewBlockActor>::operator new;
	using FastAllocated<NewBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14757043000591768064UL, 8064978558596008192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockActor, 0, Void >;
friend struct ActorCallback< NewBlockActor, 1, Void >;
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor(EncryptedRangeFileWriter* const& self,int const& bytesNeeded,KeyRef const& lastKey,bool const& writeValue,bool const& final = false) 
															#line 8301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NewBlockActorState<NewBlockActor>(self, bytesNeeded, lastKey, writeValue, final),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11473969930622856192UL, 2275173024393763072UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewBlockActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlock( EncryptedRangeFileWriter* const& self, int const& bytesNeeded, KeyRef const& lastKey, bool const& writeValue, bool const& final = false ) {
															#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockActor(self, bytesNeeded, lastKey, writeValue, final));
															#line 8334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1433 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> padEnd(bool final) {
		if (expectedFileSize(this) > 0) {
			return newBlock(this, 0, StringRef(), true, final);
		}
		return Void();
	}

	// Ends the current block if necessary based on bytesNeeded.
																#line 8347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via newBlockIfNeeded()
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockIfNeededActor>
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockIfNeededActorState {
															#line 8353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockIfNeededActorState(EncryptedRangeFileWriter* const& self,int const& bytesNeeded) 
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded)
															#line 8362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("newBlockIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockIfNeededActorState() 
	{
		fdb_probe_actor_destroy("newBlockIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1443 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (expectedFileSize(self) + bytesNeeded > self->blockEnd)
															#line 8377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1444 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = newBlock(self, bytesNeeded, self->lastKey, true);
															#line 1444 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state = 1;
															#line 1444 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockIfNeededActor, 0, Void >*>(static_cast<NewBlockIfNeededActor*>(this)));
															#line 8388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockIfNeededActorState();
		static_cast<NewBlockIfNeededActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1446 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockIfNeededActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockIfNeededActorState(); static_cast<NewBlockIfNeededActor*>(this)->destroy(); return 0; }
															#line 8416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<NewBlockIfNeededActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockIfNeededActorState();
		static_cast<NewBlockIfNeededActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state > 0) static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockIfNeededActor*>(this)->ActorCallback< NewBlockIfNeededActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 8515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via newBlockIfNeeded()
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockIfNeededActor final : public Actor<Void>, public ActorCallback< NewBlockIfNeededActor, 0, Void >, public FastAllocated<NewBlockIfNeededActor>, public NewBlockIfNeededActorState<NewBlockIfNeededActor> {
															#line 8520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<NewBlockIfNeededActor>::operator new;
	using FastAllocated<NewBlockIfNeededActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12166782325876442368UL, 17066884821197171200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockIfNeededActor, 0, Void >;
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockIfNeededActor(EncryptedRangeFileWriter* const& self,int const& bytesNeeded) 
															#line 8537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NewBlockIfNeededActorState<NewBlockIfNeededActor>(self, bytesNeeded),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2008971701599870208UL, 8353149633524734464UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlockIfNeeded");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockIfNeededActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlockIfNeeded( EncryptedRangeFileWriter* const& self, int const& bytesNeeded ) {
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockIfNeededActor(self, bytesNeeded));
															#line 8569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1448 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Start a new block if needed, then write the key and value
																#line 8575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor>
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActorState {
															#line 8581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActorState(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 8592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActorState() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1451 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->cipherKeys.headerCipherKey.present() || !self->cipherKeys.headerCipherKey.get().isValid() || !self->cipherKeys.textCipherKey.isValid())
															#line 8607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateEncryptionKeysCtx(self, k);
															#line 1453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteKV_implActor*>(this)->actor_wait_state = 1;
															#line 1453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 0, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 8618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1455 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newBlockIfNeeded(self, toWrite);
															#line 1456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 2;
															#line 1456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 1, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 8655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1457 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1458 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &v);
															#line 1459 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1460 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1461 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 8759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1457 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1458 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &v);
															#line 1459 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1460 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1461 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 8779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1455 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int toWrite;
															#line 8870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor final : public Actor<Void>, public ActorCallback< WriteKV_implActor, 0, Void >, public ActorCallback< WriteKV_implActor, 1, Void >, public FastAllocated<WriteKV_implActor>, public WriteKV_implActorState<WriteKV_implActor> {
															#line 8875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor>::operator new;
	using FastAllocated<WriteKV_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6315819753271108352UL, 6682033703558460416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor, 0, Void >;
friend struct ActorCallback< WriteKV_implActor, 1, Void >;
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 8893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActorState<WriteKV_implActor>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12331643623674153728UL, 17746951694630343424UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( EncryptedRangeFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor(self, k, v));
															#line 8926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1463 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	// Write begin key or end key.
																#line 8934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKey_impl()
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKey_implActor>
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActorState {
															#line 8940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActorState(EncryptedRangeFileWriter* const& self,Key const& k) 
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k)
															#line 8949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKey_implActorState() 
	{
		fdb_probe_actor_destroy("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1469 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (k.size() > 0 && (!self->cipherKeys.headerCipherKey.present() || !self->cipherKeys.headerCipherKey.get().isValid() || !self->cipherKeys.textCipherKey.isValid()))
															#line 8964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateEncryptionKeysCtx(self, k);
															#line 1472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteKey_implActor*>(this)->actor_wait_state = 1;
															#line 1472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 0, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 8975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1476 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int toWrite = sizeof(uint32_t) + k.size();
															#line 1477 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newBlockIfNeeded(self, toWrite);
															#line 1477 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor*>(this)->actor_wait_state = 2;
															#line 1477 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 1, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 9012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1478 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1479 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1480 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 9112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1478 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1479 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1480 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 9128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 9215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKey_impl()
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor final : public Actor<Void>, public ActorCallback< WriteKey_implActor, 0, Void >, public ActorCallback< WriteKey_implActor, 1, Void >, public FastAllocated<WriteKey_implActor>, public WriteKey_implActorState<WriteKey_implActor> {
															#line 9220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKey_implActor>::operator new;
	using FastAllocated<WriteKey_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11821968909654055424UL, 11922910546924800768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKey_implActor, 0, Void >;
friend struct ActorCallback< WriteKey_implActor, 1, Void >;
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor(EncryptedRangeFileWriter* const& self,Key const& k) 
															#line 9238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKey_implActorState<WriteKey_implActor>(self, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(551483992183075584UL, 8902642963360461568UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKey_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKey_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKey_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKey_impl( EncryptedRangeFileWriter* const& self, Key const& k ) {
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKey_implActor(self, k));
															#line 9271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1482 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKey(Key k) { return writeKey_impl(this, k); }

																#line 9278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via finish_impl()
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class Finish_implActor>
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class Finish_implActorState {
															#line 9284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Finish_implActorState(EncryptedRangeFileWriter* const& self) 
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 9291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("finish_impl", reinterpret_cast<unsigned long>(this));

	}
	~Finish_implActorState() 
	{
		fdb_probe_actor_destroy("finish_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1487 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (currentBufferSize(self) > 0)
															#line 9306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1488 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = encrypt(self);
															#line 1488 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<Finish_implActor*>(this)->actor_wait_state = 1;
															#line 1488 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 0, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 9317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Finish_implActorState();
		static_cast<Finish_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<Finish_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Finish_implActorState(); static_cast<Finish_implActor*>(this)->destroy(); return 0; }
															#line 9345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<Finish_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Finish_implActorState();
		static_cast<Finish_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), currentBufferSize(self));
															#line 1489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Finish_implActor*>(this)->actor_wait_state = 2;
															#line 1489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 1, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 9364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), currentBufferSize(self));
															#line 1489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Finish_implActor*>(this)->actor_wait_state = 2;
															#line 1489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 1, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 9380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Finish_implActor*>(this)->actor_wait_state > 0) static_cast<Finish_implActor*>(this)->actor_wait_state = 0;
		static_cast<Finish_implActor*>(this)->ActorCallback< Finish_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Finish_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Finish_implActor*>(this)->actor_wait_state > 0) static_cast<Finish_implActor*>(this)->actor_wait_state = 0;
		static_cast<Finish_implActor*>(this)->ActorCallback< Finish_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Finish_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 9549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via finish_impl()
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class Finish_implActor final : public Actor<Void>, public ActorCallback< Finish_implActor, 0, Void >, public ActorCallback< Finish_implActor, 1, Void >, public FastAllocated<Finish_implActor>, public Finish_implActorState<Finish_implActor> {
															#line 9554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<Finish_implActor>::operator new;
	using FastAllocated<Finish_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9445833433915780096UL, 2556072249770995456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Finish_implActor, 0, Void >;
friend struct ActorCallback< Finish_implActor, 1, Void >;
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Finish_implActor(EncryptedRangeFileWriter* const& self) 
															#line 9572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   Finish_implActorState<Finish_implActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6941044748667588864UL, 17414012196556178688UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finish_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Finish_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Finish_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> finish_impl( EncryptedRangeFileWriter* const& self ) {
															#line 1485 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new Finish_implActor(self));
															#line 9605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1493 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> finish() { return finish_impl(this); }

	Database cx;
	Arena* arena;
	EncryptionAtRestMode encryptMode;
	Reference<IBackupFile> file;
	int blockSize;

private:
	Standalone<StringRef> buffer;
	uint8_t* wPtr;
	StringRef encryptHeader;
	uint8_t* dataPayloadStart;
	int64_t blockEnd;
	uint32_t fileVersion;
	Key lastKey;
	Key lastValue;
	SnapshotFileBackupEncryptionKeys cipherKeys;
};

// File Format handlers.
// Both Range and Log formats are designed to be readable starting at any BACKUP_RANGEFILE_BLOCK_SIZE boundary
// so they can be read in parallel.
//
// Writer instances must be kept alive while any member actors are in progress.
//
// RangeFileWriter must be used as follows:
//   1 - writeKey(key) the queried key range begin
//   2 - writeKV(k, v) each kv pair to restore
//   3 - writeKey(key) the queried key range end
//	 4 - finish()
//
// RangeFileWriter will insert the required padding, header, and extra
// end/begin keys around the 1MB boundaries as needed.
//
// Example:
//   The range a-z is queries and returns c-j which covers 3 blocks.
//   The client code writes keys in this sequence:
//             a c d e f g h i j z
//
//   H = header   P = padding   a...z = keys  v = value | = block boundary
//
//   Encoded file:  H a cv dv ev P | H e ev fv gv hv P | H h hv iv jv z
//   Decoded in blocks yields:
//           Block 1: range [a, e) with kv pairs cv, dv
//           Block 2: range [e, h) with kv pairs ev, fv, gv
//           Block 3: range [h, z) with kv pairs hv, iv, jv
//
//   NOTE: All blocks except for the final block will have one last
//   value which will not be used.  This isn't actually a waste since
//   if the next KV pair wouldn't fit within the block after the value
//   then the space after the final key to the next 1MB boundary would
//   just be padding anyway.
struct RangeFileWriter : public IRangeFileWriter {
	RangeFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0), fileVersion(BACKUP_AGENT_SNAPSHOT_FILE_VERSION) {}

	// Handles the first block and internal blocks.  Ends current block if needed.
	// The final flag is used in simulation to pad the file's final block to a whole block size
																#line 9669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via newBlock()
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockActor1>
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor1State {
															#line 9675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor1State(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded),
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   final(final)
															#line 9686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("newBlock", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockActor1State() 
	{
		fdb_probe_actor_destroy("newBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1555 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int bytesLeft = self->blockEnd - self->file->size();
															#line 1556 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (bytesLeft > 0)
															#line 9703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1557 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				paddingFFs = makePadding(bytesLeft);
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockActor1*>(this)->actor_wait_state = 1;
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 0, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 9716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockActor1State();
		static_cast<NewBlockActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1561 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (final)
															#line 9744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1562 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1563 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<NewBlockActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActor1State(); static_cast<NewBlockActor1*>(this)->destroy(); return 0; }
															#line 9750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<NewBlockActor1*>(this)->SAV< Void >::value()) Void(Void());
			this->~NewBlockActor1State();
			static_cast<NewBlockActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1567 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&self->fileVersion, sizeof(self->fileVersion));
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 2;
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 1, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 9767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 9863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor1*>(this)->actor_wait_state = 3;
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 2, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 9874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 9888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor1*>(this)->actor_wait_state = 3;
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 2, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 9899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() + bytesNeeded > self->blockEnd)
															#line 9988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1581 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 9992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1583 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActor1State(); static_cast<NewBlockActor1*>(this)->destroy(); return 0; }
															#line 9996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<NewBlockActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockActor1State();
		static_cast<NewBlockActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1575 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1575 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 4;
															#line 1575 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 3, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 10015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1575 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1575 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 4;
															#line 1575 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 3, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 10031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 5;
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 4, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 10122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 5;
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 4, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 10138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool final;
															#line 1557 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 10313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via newBlock()
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor1 final : public Actor<Void>, public ActorCallback< NewBlockActor1, 0, Void >, public ActorCallback< NewBlockActor1, 1, Void >, public ActorCallback< NewBlockActor1, 2, Void >, public ActorCallback< NewBlockActor1, 3, Void >, public ActorCallback< NewBlockActor1, 4, Void >, public FastAllocated<NewBlockActor1>, public NewBlockActor1State<NewBlockActor1> {
															#line 10318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<NewBlockActor1>::operator new;
	using FastAllocated<NewBlockActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14757043000591768064UL, 8064978558596008192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockActor1, 0, Void >;
friend struct ActorCallback< NewBlockActor1, 1, Void >;
friend struct ActorCallback< NewBlockActor1, 2, Void >;
friend struct ActorCallback< NewBlockActor1, 3, Void >;
friend struct ActorCallback< NewBlockActor1, 4, Void >;
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor1(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 10339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NewBlockActor1State<NewBlockActor1>(self, bytesNeeded, final),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2007484470230468096UL, 2771688764731692544UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewBlockActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< NewBlockActor1, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< NewBlockActor1, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< NewBlockActor1, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlock( RangeFileWriter* const& self, int const& bytesNeeded, bool const& final = false ) {
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockActor1(self, bytesNeeded, final));
															#line 10375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1585 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Used in simulation only to create backup file sizes which are an integer multiple of the block size
	Future<Void> padEnd(bool final) {
		ASSERT(g_network->isSimulated());
		if (file->size() > 0) {
			return newBlock(this, 0, final);
		}
		return Void();
	}

	// Ends the current block if necessary based on bytesNeeded.
	Future<Void> newBlockIfNeeded(int bytesNeeded) {
		if (file->size() + bytesNeeded > blockEnd)
			return newBlock(this, bytesNeeded);
		return Void();
	}

	// Start a new block if needed, then write the key and value
																#line 10397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor1>
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1State {
															#line 10403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1State(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 10414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActor1State() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1604 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1605 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1605 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 1;
															#line 1605 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 0, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1606 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1606 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 2;
															#line 1606 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 1, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1606 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1606 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 2;
															#line 1606 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 1, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1607 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1607 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 3;
															#line 1607 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 2, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1607 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1607 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 3;
															#line 1607 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 2, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 10591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1608 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1610 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 10679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1608 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1609 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1610 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 10695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 10784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1 final : public Actor<Void>, public ActorCallback< WriteKV_implActor1, 0, Void >, public ActorCallback< WriteKV_implActor1, 1, Void >, public ActorCallback< WriteKV_implActor1, 2, Void >, public FastAllocated<WriteKV_implActor1>, public WriteKV_implActor1State<WriteKV_implActor1> {
															#line 10789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor1>::operator new;
	using FastAllocated<WriteKV_implActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6315819753271108352UL, 6682033703558460416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor1, 0, Void >;
friend struct ActorCallback< WriteKV_implActor1, 1, Void >;
friend struct ActorCallback< WriteKV_implActor1, 2, Void >;
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 10808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActor1State<WriteKV_implActor1>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16217267337946238464UL, 13255526101699148288UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( RangeFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor1(self, k, v));
															#line 10842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1612 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	// Write begin key or end key.
																#line 10850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKey_impl()
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKey_implActor1>
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor1State {
															#line 10856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor1State(RangeFileWriter* const& self,Key const& k) 
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k)
															#line 10865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKey_implActor1State() 
	{
		fdb_probe_actor_destroy("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1617 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(uint32_t) + k.size();
															#line 1618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 1;
															#line 1618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 0, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 10889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 2;
															#line 1619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 1, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 10919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 2;
															#line 1619 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 1, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 10935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor1*>(this)->ActorCallback< WriteKey_implActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1620 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActor1State(); static_cast<WriteKey_implActor1*>(this)->destroy(); return 0; }
															#line 11019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1620 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActor1State(); static_cast<WriteKey_implActor1*>(this)->destroy(); return 0; }
															#line 11031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKey_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor1*>(this)->ActorCallback< WriteKey_implActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 11118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKey_impl()
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor1 final : public Actor<Void>, public ActorCallback< WriteKey_implActor1, 0, Void >, public ActorCallback< WriteKey_implActor1, 1, Void >, public FastAllocated<WriteKey_implActor1>, public WriteKey_implActor1State<WriteKey_implActor1> {
															#line 11123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKey_implActor1>::operator new;
	using FastAllocated<WriteKey_implActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11821968909654055424UL, 11922910546924800768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKey_implActor1, 0, Void >;
friend struct ActorCallback< WriteKey_implActor1, 1, Void >;
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor1(RangeFileWriter* const& self,Key const& k) 
															#line 11141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKey_implActor1State<WriteKey_implActor1>(self, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3399269857036320000UL, 6984076183881784832UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKey_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKey_implActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKey_implActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKey_impl( RangeFileWriter* const& self, Key const& k ) {
															#line 1616 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKey_implActor1(self, k));
															#line 11174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1622 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKey(Key k) { return writeKey_impl(this, k); }

	Future<Void> finish() { return Void(); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
	uint32_t fileVersion;
	Key lastKey;
	Key lastValue;
};

void decodeKVPairs(StringRefReader* reader,
                   Standalone<VectorRef<KeyValueRef>>* results,
                   bool encryptedBlock,
                   EncryptionAtRestMode encryptMode,
                   Optional<int64_t> blockDomainId) {
	// Read begin key, if this fails then block was invalid.
	uint32_t kLen = reader->consumeNetworkUInt32();
	const uint8_t* k = reader->consume(kLen);
	results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
	KeyRef prevKey = KeyRef(k, kLen);
	// Read kv pairs and end key
	while (1) {
		// Read a key.
		kLen = reader->consumeNetworkUInt32();
		k = reader->consume(kLen);

		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader->eof() || *reader->rptr == 0xFF) {
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
			break;
		}

		// Read a value, which must exist or the block is invalid
		uint32_t vLen = reader->consumeNetworkUInt32();
		const uint8_t* v = reader->consume(vLen);

		results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));

		// If eof reached or first byte of next key len is 0xFF then a valid block end was reached.
		if (reader->eof() || *reader->rptr == 0xFF)
			break;
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader->remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();
}

static Reference<IBackupContainer> getBackupContainerWithProxy(Reference<IBackupContainer> _bc) {
	Reference<IBackupContainer> bc = IBackupContainer::openContainer(_bc->getURL(), fileBackupAgentProxy, {});
	return bc;
}

Standalone<VectorRef<KeyValueRef>> decodeRangeFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding BACKUP_AGENT_SNAPSHOT_FILE_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
		throw restore_unsupported_file_version();

	// Read begin key, if this fails then block was invalid.
	uint32_t beginKeyLen = reader.consumeNetworkUInt32();
	const uint8_t* beginKey = reader.consume(beginKeyLen);
	results.push_back(results.arena(), KeyValueRef(KeyRef(beginKey, beginKeyLen), ValueRef()));

	// Read kv pairs and end key
	while (1) {
		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			break;
		}

		// Read a key, which must exist or the block is invalid
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);

		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			// The last block in the file, will have Read End key.
			results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
			break;
		}

		// Read a value, which must exist or the block is invalid
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);
		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 11282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeRangeFileBlockActor>
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActorState {
															#line 11288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 1730 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 11303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeRangeFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1731 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = uncancellable(holdWhile(buf, file->read(mutateString(buf), len, offset)));
															#line 1731 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 1;
															#line 1731 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 0, int >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 11325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeRangeFileBlockActorState();
		static_cast<DecodeRangeFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 1732 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 11348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1733 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 11352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1735 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1737 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1738 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1739 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 2;
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 11371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 1732 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 11380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1733 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 11384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1735 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1737 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1738 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1739 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 2;
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 11403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1741 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptMode = config.encryptionAtRestMode;
															#line 1742 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		blockDomainId = -1;
															#line 11489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		try {
															#line 1747 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int32_t file_version = reader.consume<int32_t>();
															#line 1748 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(!encryptMode.isEncryptionEnabled() || file_version == BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION);
															#line 1749 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (file_version == BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
															#line 11497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1750 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				decodeKVPairs(&reader, &results, false, encryptMode, Optional<int64_t>());
															#line 11501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = a_body1cont5(loopDepth);
			}
			else
			{
															#line 1751 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (file_version == BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION)
															#line 11508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1752 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					CODE_PROBE(true, "decoding encrypted block", probe::decoration::rare);
															#line 1754 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					headerLen = reader.consume<uint32_t>();
															#line 1756 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					headerStart = reader.consume(headerLen);
															#line 1757 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StringRef headerS = StringRef(headerStart, headerLen);
															#line 1758 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					encryptHeader = BlobCipherEncryptHeaderRef();
															#line 1760 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					encryptHeader = BlobCipherEncryptHeaderRef::fromStringRef(headerS);
															#line 1761 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					blockDomainId = encryptHeader.getCipherDetails().textCipherDetails.encryptDomainId;
															#line 1763 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					const uint8_t* dataPayloadStart = headerStart + headerLen;
															#line 1765 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					int64_t bytesRead = sizeof(int32_t) + sizeof(uint32_t) + headerLen;
															#line 1767 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					int64_t dataLen = len - bytesRead;
															#line 1768 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<StringRef> __when_expr_2 = EncryptedRangeFileWriter::decrypt(cx, encryptHeader, dataPayloadStart, dataLen, &results.arena());
															#line 1768 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 11534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
					static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 3;
															#line 1768 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 11539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
															#line 1773 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					return a_body1cont2Catch1(restore_unsupported_file_version(), loopDepth);
															#line 11546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config = __config;
															#line 11562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1777 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (e.code() == error_code_encrypt_keys_fetch_failed || e.code() == error_code_encrypt_key_not_found)
															#line 11642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1778 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(!isReservedEncryptDomain(blockDomainId));
															#line 1779 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarnAlways, "SnapshotRestoreEncryptKeyFetchFailed");
															#line 1780 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				CODE_PROBE(true, "Snapshot restore encrypt keys not found", probe::decoration::rare);
															#line 11650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 1782 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreDecodeRangeFileBlockFailed") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len) .detail("ErrorRelativeOffset", reader.rptr - buf.begin()) .detail("ErrorAbsoluteOffset", reader.rptr - buf.begin() + offset);
															#line 1789 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 11656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1775 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecodeRangeFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(results); this->~DecodeRangeFileBlockActorState(); static_cast<DecodeRangeFileBlockActor*>(this)->destroy(); return 0; }
															#line 11670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<DecodeRangeFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(std::move(results)); // state_var_RVO
		this->~DecodeRangeFileBlockActorState();
		static_cast<DecodeRangeFileBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(StringRef const& decryptedData,int loopDepth) 
	{
															#line 1770 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(decryptedData, restore_corrupted_data());
															#line 1771 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		decodeKVPairs(&reader, &results, true, encryptMode, blockDomainId);
															#line 11690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(StringRef && decryptedData,int loopDepth) 
	{
															#line 1770 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(decryptedData, restore_corrupted_data());
															#line 1771 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		decodeKVPairs(&reader, &results, true, encryptMode, blockDomainId);
															#line 11701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(StringRef const& decryptedData,int loopDepth) 
	{
		loopDepth = a_body1cont8(decryptedData, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(StringRef && decryptedData,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(decryptedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*,StringRef const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*,StringRef && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1730 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 1737 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> results;
															#line 1738 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRefReader reader;
															#line 1739 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 1740 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DatabaseConfiguration config;
															#line 1741 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptionAtRestMode encryptMode;
															#line 1742 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t blockDomainId;
															#line 1754 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t headerLen;
															#line 1756 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* headerStart;
															#line 1758 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef encryptHeader;
															#line 11809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeRangeFileBlockActor, 0, int >, public ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >, public ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >, public FastAllocated<DecodeRangeFileBlockActor>, public DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor> {
															#line 11814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecodeRangeFileBlockActor>::operator new;
	using FastAllocated<DecodeRangeFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(699330945016901120UL, 1625256662520518656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeRangeFileBlockActor, 0, int >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >;
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 11833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor>(file, offset, len, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16131528145190661120UL, 4810314581124466176UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeRangeFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 2, StringRef >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeRangeFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len, Database const& cx ) {
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeRangeFileBlockActor(file, offset, len, cx));
															#line 11867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1792 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Very simple format compared to KeyRange files.
// Header, [Key, Value]... Key len
struct LogFileWriter {
	LogFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0) {}

	// Start a new block if needed, then write the key and value
																#line 11879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via writeKV_impl()
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor2>
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor2State {
															#line 11885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor2State(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 11896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActor2State() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1802 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1803 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->file->size() + toWrite > self->blockEnd)
															#line 11913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1805 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int bytesLeft = self->blockEnd - self->file->size();
															#line 1806 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (bytesLeft > 0)
															#line 11919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1807 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					paddingFFs = makePadding(bytesLeft);
															#line 1808 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1808 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 1;
															#line 1808 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 0, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 11932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1818 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(k);
															#line 1818 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 3;
															#line 1818 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 2, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 11972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1812 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1815 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&BACKUP_AGENT_MLOG_VERSION, sizeof(BACKUP_AGENT_MLOG_VERSION));
															#line 1815 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 2;
															#line 1815 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 1, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 11990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 4;
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 3, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 12180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 4;
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 3, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 12196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1822 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 12280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1823 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 12284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1825 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor2State(); static_cast<WriteKV_implActor2*>(this)->destroy(); return 0; }
															#line 12288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1822 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 12300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1823 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 12304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1825 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor2State(); static_cast<WriteKV_implActor2*>(this)->destroy(); return 0; }
															#line 12308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<WriteKV_implActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	LogFileWriter* self;
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1807 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 12399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeKV_impl()
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor2 final : public Actor<Void>, public ActorCallback< WriteKV_implActor2, 0, Void >, public ActorCallback< WriteKV_implActor2, 1, Void >, public ActorCallback< WriteKV_implActor2, 2, Void >, public ActorCallback< WriteKV_implActor2, 3, Void >, public FastAllocated<WriteKV_implActor2>, public WriteKV_implActor2State<WriteKV_implActor2> {
															#line 12404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteKV_implActor2>::operator new;
	using FastAllocated<WriteKV_implActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6315819753271108352UL, 6682033703558460416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor2, 0, Void >;
friend struct ActorCallback< WriteKV_implActor2, 1, Void >;
friend struct ActorCallback< WriteKV_implActor2, 2, Void >;
friend struct ActorCallback< WriteKV_implActor2, 3, Void >;
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor2(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 12424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteKV_implActor2State<WriteKV_implActor2>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1459114523673046528UL, 17997660117777869824UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor2, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor2, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor2, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteKV_implActor2, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( LogFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1800 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor2(self, k, v));
															#line 12459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1827 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
};

// input: a string of [param1, param2], [param1, param2] ..., [param1, param2]
// output: a vector of [param1, param2] after removing the length info
Standalone<VectorRef<KeyValueRef>> decodeMutationLogFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding version BACKUP_AGENT_MLOG_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_MLOG_VERSION)
		throw restore_unsupported_file_version();

	// Read k/v pairs.  Block ends either at end of last value exactly or with 0xFF as first key len byte.
	while (1) {
		// If eof reached or first key len bytes is 0xFF then end of block was reached.
		if (reader.eof() || *reader.rptr == 0xFF)
			break;

		// Read key and value.  If anything throws then there is a problem.
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);

		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 12506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeMutationLogFileBlockActor>
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActorState {
															#line 12512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 1873 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 12525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeMutationLogFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1874 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(mutateString(buf), len, offset);
															#line 1874 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 1;
															#line 1874 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*>(static_cast<DecodeMutationLogFileBlockActor*>(this)));
															#line 12547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeMutationLogFileBlockActorState();
		static_cast<DecodeMutationLogFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 1875 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 12570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1876 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 12574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		try {
															#line 1879 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 12579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 1875 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 12597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1876 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 12601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		try {
															#line 1879 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 12606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeMutationLogFileBlockActor*>(this)->ActorCallback< DecodeMutationLogFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreCorruptLogFileBlock") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len);
															#line 1886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 12702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 1873 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 12720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeMutationLogFileBlockActor, 0, int >, public FastAllocated<DecodeMutationLogFileBlockActor>, public DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor> {
															#line 12725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator new;
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10216492602818170368UL, 12205138114487918336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeMutationLogFileBlockActor, 0, int >;
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 12742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor>(file, offset, len),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10553348071887031296UL, 14129820410599961600UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeMutationLogFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeMutationLogFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len ) {
															#line 1870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeMutationLogFileBlockActor(file, offset, len));
															#line 12774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1889 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 12779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via checkTaskVersion()
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class CheckTaskVersionActor>
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActorState {
															#line 12785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActorState(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   name(name),
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 12798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	~CheckTaskVersionActorState() 
	{
		fdb_probe_actor_destroy("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1891 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uint32_t taskVersion = task->getVersion();
															#line 1892 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (taskVersion > version)
															#line 12815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 1893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				err = task_invalid_version();
															#line 1895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "BA_BackupRangeTaskFuncExecute") .detail("TaskVersion", taskVersion) .detail("Name", name) .detail("Version", version);
															#line 1899 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (KeyBackedTaskConfig::TaskParams.uid().exists(task))
															#line 12823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				{
															#line 1900 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					std::string msg = format("%s task version `%lu' is greater than supported version `%lu'", task->params[Task::reservedTaskParamKeyType].toString().c_str(), (unsigned long)taskVersion, (unsigned long)version);
															#line 1904 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = BackupConfig(task).logError(cx, err, msg);
															#line 1904 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 1;
															#line 1904 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTaskVersionActor, 0, Void >*>(static_cast<CheckTaskVersionActor*>(this)));
															#line 12836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1910 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<CheckTaskVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTaskVersionActorState(); static_cast<CheckTaskVersionActor*>(this)->destroy(); return 0; }
															#line 12869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<CheckTaskVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1907 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 12881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state > 0) static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTaskVersionActor*>(this)->ActorCallback< CheckTaskVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTaskVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 1893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Error err;
															#line 12982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkTaskVersion()
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActor final : public Actor<Void>, public ActorCallback< CheckTaskVersionActor, 0, Void >, public FastAllocated<CheckTaskVersionActor>, public CheckTaskVersionActorState<CheckTaskVersionActor> {
															#line 12987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckTaskVersionActor>::operator new;
	using FastAllocated<CheckTaskVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(36509703108321280UL, 4852697748895835392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTaskVersionActor, 0, Void >;
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActor(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 13004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckTaskVersionActorState<CheckTaskVersionActor>(cx, task, name, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3362756845853264896UL, 17854206522136534528UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTaskVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTaskVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> checkTaskVersion( Database const& cx, Reference<Task> const& task, StringRef const& name, uint32_t const& version ) {
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new CheckTaskVersionActor(cx, task, name, version));
															#line 13036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1912 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 13041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via abortFiveZeroBackup()
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveZeroBackupActor>
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActorState {
															#line 13047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 13058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveZeroBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1916 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1917 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1919 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tagNames = backupAgent->subspace.get(BackupAgentBase::keyTagName);
															#line 1920 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(tagNames.pack(Key(tagName)));
															#line 1920 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 1;
															#line 1920 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 13086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& uidStr,int loopDepth) 
	{
															#line 1921 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 13109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1922 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 1923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 13115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 1928 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 1929 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 13138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && uidStr,int loopDepth) 
	{
															#line 1921 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 13147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1922 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 1923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 13153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 1928 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 1929 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 13176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(uidStr, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(uidStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& statusStr,int loopDepth) 
	{
															#line 1932 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 1935 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 1940 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 1943 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 1944 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 1945 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 1949 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1954 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 13278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1955 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 13282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1957 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 13286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && statusStr,int loopDepth) 
	{
															#line 1932 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 1935 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 1940 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 1943 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 1944 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 1945 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 1949 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 1954 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 13316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 1955 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 13320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 1957 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 13324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(statusStr, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(statusStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 1919 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace tagNames;
															#line 1925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace statusSpace;
															#line 1928 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace globalConfig;
															#line 1929 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace newConfigSpace;
															#line 1932 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState status;
															#line 13425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via abortFiveZeroBackup()
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >, public ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >, public FastAllocated<AbortFiveZeroBackupActor>, public AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor> {
															#line 13430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AbortFiveZeroBackupActor>::operator new;
	using FastAllocated<AbortFiveZeroBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5967588458762748928UL, 13561255542284915200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >;
friend struct ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >;
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 13448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9684559041468978176UL, 9313393515895828736UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveZeroBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveZeroBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveZeroBackupActor(backupAgent, tr, tagName));
															#line 13481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1959 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveZeroBackupTask : TaskFuncBase {
	static StringRef name;
																#line 13488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor>
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActorState {
															#line 13494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 1966 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 1967 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(task->params[BackupAgentBase::keyConfigBackupTag].toString())
															#line 13511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActorState() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1969 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevInfo, "FileBackupCancelOldTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = abortFiveZeroBackup(&backupAgent, tr, tagName);
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 1;
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 0, Void >*>(static_cast<_finishActor*>(this)));
															#line 13535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 13565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 13581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1975 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 13665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1975 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 13677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 1966 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 1967 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 13772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor final : public Actor<Void>, public ActorCallback< _finishActor, 0, Void >, public ActorCallback< _finishActor, 1, Void >, public FastAllocated<_finishActor>, public _finishActorState<_finishActor> {
															#line 13777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor>::operator new;
	using FastAllocated<_finishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14554670902827185152UL, 13564214212088420608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor, 0, Void >;
friend struct ActorCallback< _finishActor, 1, Void >;
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 13795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActorState<_finishActor>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5805366160711900928UL, 534046083987129088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor(tr, taskBucket, futureBucket, task));
															#line 13828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 1977 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveZeroBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveZeroBackupTask::name = "abort_legacy_backup"_sr;
REGISTER_TASKFUNC(AbortFiveZeroBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_diff_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_log_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_restorable);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finish_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finished_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_start_full_backup);

															#line 13864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via abortFiveOneBackup()
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveOneBackupActor>
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActorState {
															#line 13870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 13881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveOneBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2012 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2013 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2015 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = makeBackupTag(tagName);
															#line 2016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<UidAndAbortedFlagT> __when_expr_0 = tag.getOrThrow(tr, Snapshot::False, backup_unneeded());
															#line 2016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 1;
															#line 2016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 13909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2018 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config = BackupConfig(current.first);
															#line 2019 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<EBackupState> __when_expr_1 = config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN);
															#line 2019 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 2;
															#line 2019 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 13941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT const& __current,int loopDepth) 
	{
															#line 2016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		current = __current;
															#line 13950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT && __current,int loopDepth) 
	{
		current = std::move(__current);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(EBackupState const& status,int loopDepth) 
	{
															#line 2021 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 14029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2022 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 14033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 14046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(EBackupState && status,int loopDepth) 
	{
															#line 2021 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 14055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2022 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 14059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 2030 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 14072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState const& status,int loopDepth) 
	{
		loopDepth = a_body1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState && status,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 2033 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 2035 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2036 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2038 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 2040 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 14166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 2033 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 2035 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2036 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2038 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 2040 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 14188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 2015 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyBackedTag tag;
															#line 2016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UidAndAbortedFlagT current;
															#line 2018 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 14283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via abortFiveOneBackup()
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >, public ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >, public ActorCallback< AbortFiveOneBackupActor, 2, Void >, public FastAllocated<AbortFiveOneBackupActor>, public AbortFiveOneBackupActorState<AbortFiveOneBackupActor> {
															#line 14288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AbortFiveOneBackupActor>::operator new;
	using FastAllocated<AbortFiveOneBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7393185656240019456UL, 6699738610628394496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >;
friend struct ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >;
friend struct ActorCallback< AbortFiveOneBackupActor, 2, Void >;
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 14307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   AbortFiveOneBackupActorState<AbortFiveOneBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12508330983096255488UL, 5977812422500027136UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveOneBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveOneBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 2009 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveOneBackupActor(backupAgent, tr, tagName));
															#line 14341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveOneBackupTask : TaskFuncBase {
	static StringRef name;
																#line 14348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor1>
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1State {
															#line 14354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2049 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 2050 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(task)
															#line 14371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor1State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = config.tag().getOrThrow(tr);
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor1*>(this)->actor_wait_state = 1;
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 0, std::string >*>(static_cast<_finishActor1*>(this)));
															#line 14393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2053 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupCancelFiveOneTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 2056 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = abortFiveOneBackup(&backupAgent, tr, tagName);
															#line 2056 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 2056 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Void >*>(static_cast<_finishActor1*>(this)));
															#line 14425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& __tagName,int loopDepth) 
	{
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tagName = __tagName;
															#line 14434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && __tagName,int loopDepth) 
	{
		tagName = std::move(__tagName);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor1, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 14520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 14536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2059 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 14620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2059 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 14632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2049 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2050 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 14729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _finish()
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1 final : public Actor<Void>, public ActorCallback< _finishActor1, 0, std::string >, public ActorCallback< _finishActor1, 1, Void >, public ActorCallback< _finishActor1, 2, Void >, public FastAllocated<_finishActor1>, public _finishActor1State<_finishActor1> {
															#line 14734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_finishActor1>::operator new;
	using FastAllocated<_finishActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14554670902827185152UL, 13564214212088420608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor1, 0, std::string >;
friend struct ActorCallback< _finishActor1, 1, Void >;
friend struct ActorCallback< _finishActor1, 2, Void >;
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 14753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _finishActor1State<_finishActor1>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9581808447337778176UL, 9167718057927325696UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor1, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor1(tr, taskBucket, futureBucket, task));
															#line 14787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2061 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveOneBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveOneBackupTask::name = "abort_legacy_backup_5.2"_sr;
REGISTER_TASKFUNC(AbortFiveOneBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_ranges);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_erase_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_finished);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_snapshot_manifest);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_start);

std::function<void(Reference<Task>)> NOP_SETUP_TASK_FN = [](Reference<Task> task) { /* NOP */ };
															#line 14824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via addBackupTask()
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AddBackupTaskActor>
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActorState {
															#line 14830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActorState(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : name(name),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(config),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   waitFor(waitFor),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setupTaskFn(setupTaskFn),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   priority(priority),
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setValidation(setValidation)
															#line 14855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	~AddBackupTaskActorState() 
	{
		fdb_probe_actor_destroy("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2105 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 2107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 1;
															#line 2107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 0, Key >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 14881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 2108 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 14913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 2108 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 14931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2115 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 2117 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 15017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2118 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 15021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 2120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 2120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 15036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2115 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 2117 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 15047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2118 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 15051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 2120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 2120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 15066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2122 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 15150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2122 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 15162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::function<void(Reference<Task>)> setupTaskFn;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int priority;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SetValidation setValidation;
															#line 2108 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 15267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addBackupTask()
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActor final : public Actor<Key>, public ActorCallback< AddBackupTaskActor, 0, Key >, public ActorCallback< AddBackupTaskActor, 1, Void >, public ActorCallback< AddBackupTaskActor, 2, Void >, public FastAllocated<AddBackupTaskActor>, public AddBackupTaskActorState<AddBackupTaskActor> {
															#line 15272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddBackupTaskActor>::operator new;
	using FastAllocated<AddBackupTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17523684487253014528UL, 4656232579477564160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddBackupTaskActor, 0, Key >;
friend struct ActorCallback< AddBackupTaskActor, 1, Void >;
friend struct ActorCallback< AddBackupTaskActor, 2, Void >;
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActor(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 15291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   AddBackupTaskActorState<AddBackupTaskActor>(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9042814576718378240UL, 18087378901118404352UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addBackupTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddBackupTaskActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddBackupTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AddBackupTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addBackupTask( StringRef const& name, uint32_t const& version, Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, TaskCompletionKey const& completionKey, BackupConfig const& config, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(), std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN, int const& priority = 0, SetValidation const& setValidation = SetValidation::True ) {
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Key>(new AddBackupTaskActor(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation));
															#line 15325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2124 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Clears the backup ID from "backupStartedKey" to pause backup workers.
															#line 15331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via clearBackupStartID()
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class ClearBackupStartIDActor>
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActorState {
															#line 15337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupUid(backupUid)
															#line 15346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	~ClearBackupStartIDActorState() 
	{
		fdb_probe_actor_destroy("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2128 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(backupStartedKey);
															#line 2128 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 1;
															#line 2128 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*>(static_cast<ClearBackupStartIDActor*>(this)));
															#line 15368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& started,int loopDepth) 
	{
															#line 2129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 2130 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 15393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2131 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 15397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2133 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 2135 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 15403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2136 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 15407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2139 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 15411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2140 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 2141 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 15417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2143 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 15423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 15427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && started,int loopDepth) 
	{
															#line 2129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 2130 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 15441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2131 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 15445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2133 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 2135 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 15451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2136 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 15455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2139 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 15459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2140 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 2141 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 15465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2143 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 15471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 15475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& started,int loopDepth) 
	{
		loopDepth = a_body1cont1(started, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && started,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(started), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state > 0) static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 0;
		static_cast<ClearBackupStartIDActor*>(this)->ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID backupUid;
															#line 15562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearBackupStartID()
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActor final : public Actor<Void>, public ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >, public FastAllocated<ClearBackupStartIDActor>, public ClearBackupStartIDActorState<ClearBackupStartIDActor> {
															#line 15567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearBackupStartIDActor>::operator new;
	using FastAllocated<ClearBackupStartIDActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4562551689386902784UL, 6271950889658115072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >;
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActor(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 15584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearBackupStartIDActorState<ClearBackupStartIDActor>(tr, backupUid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2638382467860152832UL, 17874567724139410688UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearBackupStartID");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> clearBackupStartID( Reference<ReadYourWritesTransaction> const& tr, UID const& backupUid ) {
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new ClearBackupStartIDActor(tr, backupUid));
															#line 15616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Backup and Restore taskFunc definitions will inherit from one of the following classes which
// servers to catch and log to the appropriate config any error that execute/finish didn't catch and log.
struct RestoreTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return RestoreConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

struct BackupTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return BackupConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

															#line 15643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via getBlockOfShards()
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetBlockOfShardsActor>
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActorState {
															#line 15649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActorState(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginKey(beginKey),
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endKey(endKey),
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   limit(limit)
															#line 15662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	~GetBlockOfShardsActorState() 
	{
		fdb_probe_actor_destroy("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2175 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2177 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results = Standalone<VectorRef<KeyRef>>();
															#line 2178 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange( KeyRangeRef(keyAfter(beginKey.withPrefix(keyServersPrefix)), endKey.withPrefix(keyServersPrefix)), limit);
															#line 2178 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 1;
															#line 2178 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*>(static_cast<GetBlockOfShardsActor*>(this)));
															#line 15690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 2182 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 2183 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 15717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2186 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 15721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 2182 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 2183 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 15737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2186 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 15741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state > 0) static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlockOfShardsActor*>(this)->ActorCallback< GetBlockOfShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key beginKey;
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int limit;
															#line 2177 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> results;
															#line 15834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getBlockOfShards()
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetBlockOfShardsActor, 0, RangeResult >, public FastAllocated<GetBlockOfShardsActor>, public GetBlockOfShardsActorState<GetBlockOfShardsActor> {
															#line 15839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetBlockOfShardsActor>::operator new;
	using FastAllocated<GetBlockOfShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3221537923208926208UL, 12628436866250756608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlockOfShardsActor, 0, RangeResult >;
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActor(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 15856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetBlockOfShardsActorState<GetBlockOfShardsActor>(tr, beginKey, endKey, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13286161151181671680UL, 17379547947322064896UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlockOfShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getBlockOfShards( Reference<ReadYourWritesTransaction> const& tr, Key const& beginKey, Key const& endKey, int const& limit ) {
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetBlockOfShardsActor(tr, beginKey, endKey, limit));
															#line 15888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2188 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct BackupRangeTaskFunc : BackupTaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	static struct {
		static TaskParam<Key> beginKey() { return __FUNCTION__sr; }
		static TaskParam<Key> endKey() { return __FUNCTION__sr; }
		static TaskParam<bool> addBackupRangeTasks() { return __FUNCTION__sr; }
	} Params;

	std::string toString(Reference<Task> task) const override {
		return format("beginKey '%s' endKey '%s' addTasks %d",
		              Params.beginKey().get(task).printable().c_str(),
		              Params.endKey().get(task).printable().c_str(),
		              Params.addBackupRangeTasks().get(task));
	}

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

	// Finish (which flushes/syncs) the file, and then in a single transaction, make some range backup progress
	// durable. This means:
	//  - increment the backup config's range bytes written
	//  - update the range file map
	//  - update the task begin key
	//  - save/extend the task with the new params
	// Returns whether or not the caller should continue executing the task.
																#line 15932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via finishRangeFile()
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class FinishRangeFileActor>
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishRangeFileActorState {
															#line 15938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishRangeFileActorState(Reference<IBackupFile> const& file,Database const& cx,Reference<Task> const& task,Reference<TaskBucket> const& taskBucket,KeyRange const& range,Version const& version) 
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   range(range),
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 15955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	~FinishRangeFileActorState() 
	{
		fdb_probe_actor_destroy("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2234 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = file->finish();
															#line 2234 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 1;
															#line 2234 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 0, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 15977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2237 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 16000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2238 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 16004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2241 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2242 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 16025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2237 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 16034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2238 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 16038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2241 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2242 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 16059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2249 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 16145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2249 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 16156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2281 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(usedFile); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 16240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(std::move(usedFile)); // state_var_RVO
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 2251 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2252 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2256 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.beginKey().set(task, range.end);
															#line 2259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = taskBucket->extendTimeout(tr, task, UpdateParams::True);
															#line 2259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 3;
															#line 2259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 2, Version >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 16273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2277 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 2277 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 6;
															#line 2277 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 5, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 16315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 2262 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.rangeBytesWritten().atomicOp(tr, file->size(), MutationRef::AddValue);
															#line 2263 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.snapshotRangeFileCount().atomicOp(tr, 1, MutationRef::AddValue);
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<BackupConfig::RangeSlice>> __when_expr_3 = backup.snapshotRangeFileMap().get(tr, range.end);
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 4;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 16341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version const& __newTimeout,int loopDepth) 
	{
															#line 2259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newTimeout = __newTimeout;
															#line 16350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version && __newTimeout,int loopDepth) 
	{
		newTimeout = std::move(__newTimeout);
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
															#line 2267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 16429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2268 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2270 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 16435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 16446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
															#line 2267 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 16455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2268 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2270 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 16461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 16472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Optional<BackupConfig::RangeSlice> const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Optional<BackupConfig::RangeSlice> && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2274 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 16556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2274 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 16565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupFile> file;
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRange range;
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 2240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2241 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig backup;
															#line 2242 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool usedFile;
															#line 2247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FlowLock::Releaser releaser;
															#line 2259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version newTimeout;
															#line 16754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via finishRangeFile()
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishRangeFileActor final : public Actor<bool>, public ActorCallback< FinishRangeFileActor, 0, Void >, public ActorCallback< FinishRangeFileActor, 1, Void >, public ActorCallback< FinishRangeFileActor, 2, Version >, public ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >, public ActorCallback< FinishRangeFileActor, 4, Void >, public ActorCallback< FinishRangeFileActor, 5, Void >, public FastAllocated<FinishRangeFileActor>, public FinishRangeFileActorState<FinishRangeFileActor> {
															#line 16759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<FinishRangeFileActor>::operator new;
	using FastAllocated<FinishRangeFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4196185886229707264UL, 11102443552844668416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishRangeFileActor, 0, Void >;
friend struct ActorCallback< FinishRangeFileActor, 1, Void >;
friend struct ActorCallback< FinishRangeFileActor, 2, Version >;
friend struct ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >;
friend struct ActorCallback< FinishRangeFileActor, 4, Void >;
friend struct ActorCallback< FinishRangeFileActor, 5, Void >;
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishRangeFileActor(Reference<IBackupFile> const& file,Database const& cx,Reference<Task> const& task,Reference<TaskBucket> const& taskBucket,KeyRange const& range,Version const& version) 
															#line 16781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   FinishRangeFileActorState<FinishRangeFileActor>(file, cx, task, taskBucket, range, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3667902104148193536UL, 8200535100199061504UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishRangeFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishRangeFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishRangeFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishRangeFileActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FinishRangeFileActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FinishRangeFileActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<bool> finishRangeFile( Reference<IBackupFile> const& file, Database const& cx, Reference<Task> const& task, Reference<TaskBucket> const& taskBucket, KeyRange const& range, Version const& version ) {
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new FinishRangeFileActor(file, cx, task, taskBucket, range, version));
															#line 16818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2283 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 16823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via addTask()
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AddTaskActor>
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddTaskActorState {
															#line 16829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddTaskActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,int const& priority,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),Version const& scheduledVersion = invalidVersion) 
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   priority(priority),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   begin(begin),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   end(end),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   waitFor(waitFor),
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   scheduledVersion(scheduledVersion)
															#line 16852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActorState() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2293 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = addBackupTask( BackupRangeTaskFunc::name, BackupRangeTaskFunc::version, tr, taskBucket, completionKey, BackupConfig(parentTask), waitFor, [=](Reference<Task> task) { Params.beginKey().set(task, begin); Params.endKey().set(task, end); Params.addBackupRangeTasks().set(task, false); if (scheduledVersion != invalidVersion) ReservedTaskParams::scheduledVersion().set(task, scheduledVersion); }, priority);
															#line 2293 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor*>(this)->actor_wait_state = 1;
															#line 2293 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor, 0, Key >*>(static_cast<AddTaskActor*>(this)));
															#line 16874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& key,int loopDepth) 
	{
															#line 2309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(key); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 16897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(key);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Key && key,int loopDepth) 
	{
															#line 2309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(key); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 16909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(key);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1(key, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && key,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor*>(this)->actor_wait_state > 0) static_cast<AddTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor*>(this)->ActorCallback< AddTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int priority;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key begin;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key end;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version scheduledVersion;
															#line 17010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via addTask()
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddTaskActor final : public Actor<Key>, public ActorCallback< AddTaskActor, 0, Key >, public FastAllocated<AddTaskActor>, public AddTaskActorState<AddTaskActor> {
															#line 17015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<AddTaskActor>::operator new;
	using FastAllocated<AddTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8268218191229936384UL, 13182618089533065728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor, 0, Key >;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddTaskActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,int const& priority,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),Version const& scheduledVersion = invalidVersion) 
															#line 17032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Key>(),
		   AddTaskActorState<AddTaskActor>(tr, taskBucket, parentTask, priority, begin, end, completionKey, waitFor, scheduledVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6060296532077720576UL, 16456885635641163264UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, int const& priority, Key const& begin, Key const& end, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(), Version const& scheduledVersion = invalidVersion ) {
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor(tr, taskBucket, parentTask, priority, begin, end, completionKey, waitFor, scheduledVersion));
															#line 17064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2311 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 17069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _execute()
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _executeActor>
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _executeActorState {
															#line 17075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_executeActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2316 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lock(new FlowLock(CLIENT_KNOBS->BACKUP_LOCK_BYTES))
															#line 17090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActorState() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2318 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, BackupRangeTaskFunc::name, BackupRangeTaskFunc::version);
															#line 2318 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 1;
															#line 2318 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 0, Void >*>(static_cast<_executeActor*>(this)));
															#line 17112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActorState();
		static_cast<_executeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2320 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = Params.beginKey().get(task);
															#line 2321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		endKey = Params.endKey().get(task);
															#line 2323 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupRangeStart") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("TaskKey", task->key.printable());
															#line 2332 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (beginKey == endKey)
															#line 17141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 17145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, beginKey, endKey, 1); });
															#line 2336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 2336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 17160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2320 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = Params.beginKey().get(task);
															#line 2321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		endKey = Params.endKey().get(task);
															#line 2323 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupRangeStart") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("TaskKey", task->key.printable());
															#line 2332 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (beginKey == endKey)
															#line 17175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 17179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, beginKey, endKey, 1); });
															#line 2336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 2336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 17194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _executeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Standalone<VectorRef<KeyRef>> const& keys,int loopDepth) 
	{
															#line 2338 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (keys.size() > 0)
															#line 17278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2339 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.addBackupRangeTasks().set(task, true);
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 17284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2346 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = Reference<IBackupFile>();
															#line 2347 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outVersion = invalidVersion;
															#line 2348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lastKey = Key();
															#line 2351 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = PromiseStream<RangeResultWithVersion>();
															#line 2353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rc = readCommitted(cx, results, lock, KeyRangeRef(beginKey, endKey), Terminator::True, AccessSystemKeys::True, LockAware::True);
															#line 2360 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rangeFile = std::unique_ptr<IRangeFileWriter>();
															#line 2361 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2362 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_2 = getDatabaseConfiguration(cx);
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 3;
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 2, DatabaseConfiguration >*>(static_cast<_executeActor*>(this)));
															#line 17315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Standalone<VectorRef<KeyRef>> && keys,int loopDepth) 
	{
															#line 2338 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (keys.size() > 0)
															#line 17324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2339 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.addBackupRangeTasks().set(task, true);
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 17330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2346 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = Reference<IBackupFile>();
															#line 2347 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outVersion = invalidVersion;
															#line 2348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lastKey = Key();
															#line 2351 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = PromiseStream<RangeResultWithVersion>();
															#line 2353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rc = readCommitted(cx, results, lock, KeyRangeRef(beginKey, endKey), Terminator::True, AccessSystemKeys::True, LockAware::True);
															#line 2360 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		rangeFile = std::unique_ptr<IRangeFileWriter>();
															#line 2361 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2362 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_2 = getDatabaseConfiguration(cx);
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 3;
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 2, DatabaseConfiguration >*>(static_cast<_executeActor*>(this)));
															#line 17361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRef>> const& keys,int loopDepth) 
	{
		loopDepth = a_body1cont2(keys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyRef>> && keys,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(keys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(DatabaseConfiguration const& config,int loopDepth) 
	{
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptMode = config.encryptionAtRestMode;
															#line 2369 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_3 = backup.backupContainer().getD(cx.getReference());
															#line 2369 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 4;
															#line 2369 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*>(static_cast<_executeActor*>(this)));
															#line 17454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(DatabaseConfiguration && config,int loopDepth) 
	{
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptMode = config.encryptionAtRestMode;
															#line 2369 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Reference<IBackupContainer>> __when_expr_3 = backup.backupContainer().getD(cx.getReference());
															#line 2369 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 4;
															#line 2369 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*>(static_cast<_executeActor*>(this)));
															#line 17472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(DatabaseConfiguration const& config,int loopDepth) 
	{
		loopDepth = a_body1cont4(config, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(DatabaseConfiguration && config,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 2, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 2, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _executeActor, 2, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _executeActor, 2, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Reference<IBackupContainer> const& _bc,int loopDepth) 
	{
															#line 2370 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!_bc)
															#line 17556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2371 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 17560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2373 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bc = getBackupContainerWithProxy(_bc);
															#line 2374 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		done = false;
															#line 2375 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2376 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptionEnabled = Optional<bool>();
															#line 2378 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 17576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<IBackupContainer> && _bc,int loopDepth) 
	{
															#line 2370 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!_bc)
															#line 17585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2371 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 17589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2373 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bc = getBackupContainerWithProxy(_bc);
															#line 2374 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		done = false;
															#line 2375 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2376 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptionEnabled = Optional<bool>();
															#line 2378 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 17605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IBackupContainer> const& _bc,int loopDepth) 
	{
		loopDepth = a_body1cont6(_bc, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IBackupContainer> && _bc,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_bc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 3, Reference<IBackupContainer> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*,Reference<IBackupContainer> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 2379 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		values = RangeResultWithVersion();
															#line 17696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		try {
															#line 2381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			auto __when_expr_4 = results.getFuture();
															#line 17700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_4), FutureStream<RangeResultWithVersion>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<RangeResultWithVersion>>::value, "invalid type");
															#line 2381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont6loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6loopBody1when1(__when_expr_4.pop(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 5;
															#line 2381 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*>(static_cast<_executeActor*>(this)));
															#line 17709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 2393 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (values.second != outVersion || done)
															#line 17724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2394 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (outFile)
															#line 17728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2395 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				CODE_PROBE(outVersion != invalidVersion, "Backup range task wrote multiple versions");
															#line 2396 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				nextKey = done ? endKey : keyAfter(lastKey);
															#line 2397 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_5 = rangeFile->writeKey(nextKey);
															#line 2397 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
				static_cast<_executeActor*>(this)->actor_wait_state = 6;
															#line 2397 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 5, Void >*>(static_cast<_executeActor*>(this)));
															#line 17743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont6loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2385 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 17763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2386 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				done = true;
															#line 17767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			else
			{
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 17773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(RangeResultWithVersion const& _values,int loopDepth) 
	{
															#line 2382 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		values = _values;
															#line 2383 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lock->release(values.first.expectedSize());
															#line 17791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(RangeResultWithVersion && _values,int loopDepth) 
	{
															#line 2382 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		values = _values;
															#line 2383 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lock->release(values.first.expectedSize());
															#line 17802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResultWithVersion const& _values,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(_values, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(RangeResultWithVersion && _values,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(_values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >::remove();

	}
	void a_callback_fire(ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*,RangeResultWithVersion const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*,RangeResultWithVersion && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5(int loopDepth) 
	{
															#line 2470 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (values.first.size() != 0)
															#line 17899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2471 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			i = 0;
															#line 2472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 17905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = a_body1cont6loopBody1cont5loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6(int loopDepth) 
	{
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (done)
															#line 17919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2422 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 17923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2426 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outVersion = values.second;
															#line 2429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		blockSize = BUGGIFY ? deterministicRandom()->randomInt(250e3, 4e6) : CLIENT_KNOBS->BACKUP_RANGEFILE_BLOCK_SIZE;
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		snapshotBeginVersion = Version();
															#line 2432 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		snapshotRangeFileCount = int64_t();
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2435 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 17941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 2399 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (BUGGIFY)
															#line 17950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = rangeFile->padEnd(true);
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 7;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 6, Void >*>(static_cast<_executeActor*>(this)));
															#line 17961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 2399 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (BUGGIFY)
															#line 17975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_6 = rangeFile->padEnd(true);
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 7;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 6, Void >*>(static_cast<_executeActor*>(this)));
															#line 17986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6loopBody1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _executeActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _executeActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6loopBody1cont8(int loopDepth) 
	{
															#line 2403 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_7 = rangeFile->finish();
															#line 2403 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 8;
															#line 2403 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 7, Void >*>(static_cast<_executeActor*>(this)));
															#line 18082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _executeActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _executeActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont6loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_8 = finishRangeFile(outFile, cx, task, taskBucket, KeyRangeRef(beginKey, nextKey), outVersion);
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 9;
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 8, bool >*>(static_cast<_executeActor*>(this)));
															#line 18185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_8 = finishRangeFile(outFile, cx, task, taskBucket, KeyRangeRef(beginKey, nextKey), outVersion);
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 9;
															#line 2405 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 8, bool >*>(static_cast<_executeActor*>(this)));
															#line 18201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _executeActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _executeActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont6loopBody1cont10cont1(bool const& usedFile,int loopDepth) 
	{
															#line 2407 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupWroteRangeFile") .suppressFor(60) .detail("BackupUID", backup.getUid()) .detail("Size", outFile->size()) .detail("Keys", nrKeys) .detail("ReadVersion", outVersion) .detail("BeginKey", beginKey.printable()) .detail("EndKey", nextKey.printable()) .detail("AddedFileToMap", usedFile);
															#line 2417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = nextKey;
															#line 18289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10cont1(bool && usedFile,int loopDepth) 
	{
															#line 2407 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupWroteRangeFile") .suppressFor(60) .detail("BackupUID", backup.getUid()) .detail("Size", outFile->size()) .detail("Keys", nrKeys) .detail("ReadVersion", outVersion) .detail("BeginKey", beginKey.printable()) .detail("EndKey", nextKey.printable()) .detail("AddedFileToMap", usedFile);
															#line 2417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys = 0;
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = nextKey;
															#line 18302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10when1(bool const& usedFile,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10cont1(usedFile, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont10when1(bool && usedFile,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10cont1(std::move(usedFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 8, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 8, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _executeActor, 8, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _executeActor, 8, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont6loopBody1cont11(int loopDepth) 
	{
															#line 2451 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_11 = bc->writeRangeFile(snapshotBeginVersion, snapshotRangeFileCount, outVersion, blockSize);
															#line 2451 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont11when1(__when_expr_11.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 12;
															#line 2451 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 11, Reference<IBackupFile> >*>(static_cast<_executeActor*>(this)));
															#line 18393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1(int loopDepth) 
	{
		try {
															#line 2437 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_9 = taskBucket->keepRunning(tr, task) && storeOrThrow(snapshotBeginVersion, backup.snapshotBeginVersion().get(tr)) && store(encryptionEnabled, backup.enableSnapshotBackupEncryption().get(tr)) && store(snapshotRangeFileCount, backup.snapshotRangeFileCount().getD(tr));
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont6loopBody1cont6loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont6loopBody1cont6loopBody1when1(__when_expr_9.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 10;
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 9, Void >*>(static_cast<_executeActor*>(this)));
															#line 18421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_10 = tr->onError(e);
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 18458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1cont6loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 11;
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 10, Void >*>(static_cast<_executeActor*>(this)));
															#line 18463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont6loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont6loopBody1cont6break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _executeActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _executeActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont6loopBody1cont6loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont6loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont6loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6loopBody1cont6loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _executeActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont6loopBody1cont6loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _executeActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont6loopBody1cont11cont1(Reference<IBackupFile> const& f,int loopDepth) 
	{
															#line 2453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = f;
															#line 2455 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!encryptionEnabled.present() || !encryptionEnabled.get())
															#line 18654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			encryptMode = EncryptionAtRestMode::DISABLED;
															#line 18658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2458 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevDebug, "EncryptionMode").detail("EncryptMode", encryptMode.toString());
															#line 2460 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (encryptMode.mode != EncryptionAtRestMode::DISABLED)
															#line 18664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2461 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			CODE_PROBE(true, "using encrypted snapshot file writer", probe::decoration::rare);
															#line 2462 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			rangeFile = std::make_unique<EncryptedRangeFileWriter>(cx, &arena, encryptMode, outFile, blockSize);
															#line 18670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2464 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			rangeFile = std::make_unique<RangeFileWriter>(outFile, blockSize);
															#line 18676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_12 = rangeFile->writeKey(beginKey);
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont11cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 13;
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 12, Void >*>(static_cast<_executeActor*>(this)));
															#line 18687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont1(Reference<IBackupFile> && f,int loopDepth) 
	{
															#line 2453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		outFile = f;
															#line 2455 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!encryptionEnabled.present() || !encryptionEnabled.get())
															#line 18698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			encryptMode = EncryptionAtRestMode::DISABLED;
															#line 18702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2458 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevDebug, "EncryptionMode").detail("EncryptMode", encryptMode.toString());
															#line 2460 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (encryptMode.mode != EncryptionAtRestMode::DISABLED)
															#line 18708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2461 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			CODE_PROBE(true, "using encrypted snapshot file writer", probe::decoration::rare);
															#line 2462 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			rangeFile = std::make_unique<EncryptedRangeFileWriter>(cx, &arena, encryptMode, outFile, blockSize);
															#line 18714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
		else
		{
															#line 2464 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			rangeFile = std::make_unique<RangeFileWriter>(outFile, blockSize);
															#line 18720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_12 = rangeFile->writeKey(beginKey);
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont11cont1when1(__when_expr_12.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 13;
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 12, Void >*>(static_cast<_executeActor*>(this)));
															#line 18731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11when1(Reference<IBackupFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11when1(Reference<IBackupFile> && f,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 11, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 11, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont6loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _executeActor, 11, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont6loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _executeActor, 11, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont6loopBody1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont11cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6loopBody1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _executeActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont6loopBody1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _executeActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont6loopBody1cont13(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont14(int loopDepth) 
	{
															#line 2475 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		lastKey = values.first.back().key;
															#line 2476 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		nrKeys += values.first.size();
															#line 18910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 2472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(i < values.first.size()))
															#line 18926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
			return a_body1cont6loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2473 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_13 = rangeFile->writeKV(values.first[i].key, values.first[i].value);
															#line 2473 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 18934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1cont5loopBody1when1(__when_expr_13.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 14;
															#line 2473 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 13, Void >*>(static_cast<_executeActor*>(this)));
															#line 18939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		++i;
															#line 18961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		++i;
															#line 18970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont6loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _executeActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont6loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _executeActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 13);

	}
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2316 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FlowLock> lock;
															#line 2320 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key beginKey;
															#line 2321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 2346 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupFile> outFile;
															#line 2347 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version outVersion;
															#line 2348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key lastKey;
															#line 2351 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PromiseStream<RangeResultWithVersion> results;
															#line 2353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Void> rc;
															#line 2360 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::unique_ptr<IRangeFileWriter> rangeFile;
															#line 2361 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig backup;
															#line 2362 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptionAtRestMode encryptMode;
															#line 2373 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 2374 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool done;
															#line 2375 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t nrKeys;
															#line 2376 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<bool> encryptionEnabled;
															#line 2379 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeResultWithVersion values;
															#line 2396 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key nextKey;
															#line 2429 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int blockSize;
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version snapshotBeginVersion;
															#line 2432 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t snapshotRangeFileCount;
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2471 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t i;
															#line 19104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _execute()
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _executeActor final : public Actor<Void>, public ActorCallback< _executeActor, 0, Void >, public ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >, public ActorCallback< _executeActor, 2, DatabaseConfiguration >, public ActorCallback< _executeActor, 3, Reference<IBackupContainer> >, public ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >, public ActorCallback< _executeActor, 5, Void >, public ActorCallback< _executeActor, 6, Void >, public ActorCallback< _executeActor, 7, Void >, public ActorCallback< _executeActor, 8, bool >, public ActorCallback< _executeActor, 9, Void >, public ActorCallback< _executeActor, 10, Void >, public ActorCallback< _executeActor, 11, Reference<IBackupFile> >, public ActorCallback< _executeActor, 12, Void >, public ActorCallback< _executeActor, 13, Void >, public FastAllocated<_executeActor>, public _executeActorState<_executeActor> {
															#line 19109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<_executeActor>::operator new;
	using FastAllocated<_executeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10066233395365156864UL, 3189826483766510592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _executeActor, 0, Void >;
friend struct ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< _executeActor, 2, DatabaseConfiguration >;
friend struct ActorCallback< _executeActor, 3, Reference<IBackupContainer> >;
friend struct ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >;
friend struct ActorCallback< _executeActor, 5, Void >;
friend struct ActorCallback< _executeActor, 6, Void >;
friend struct ActorCallback< _executeActor, 7, Void >;
friend struct ActorCallback< _executeActor, 8, bool >;
friend struct ActorCallback< _executeActor, 9, Void >;
friend struct ActorCallback< _executeActor, 10, Void >;
friend struct ActorCallback< _executeActor, 11, Reference<IBackupFile> >;
friend struct ActorCallback< _executeActor, 12, Void >;
friend struct ActorCallback< _executeActor, 13, Void >;
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_executeActor(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 19139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _executeActorState<_executeActor>(cx, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11570159100681900032UL, 1174875376554251520UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _executeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _executeActor, 2, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _executeActor, 3, Reference<IBackupContainer> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< _executeActor, 4, RangeResultWithVersion >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _executeActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _executeActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _executeActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _executeActor, 8, bool >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _executeActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _executeActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _executeActor, 11, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _executeActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _executeActor, 13, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _execute( Database const& cx, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _executeActor(cx, taskBucket, futureBucket, task));
															#line 19184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2480 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 19189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via startBackupRangeInternal()
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class StartBackupRangeInternalActor>
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class StartBackupRangeInternalActorState {
															#line 19195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StartBackupRangeInternalActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuture> const& onDone) 
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   onDone(onDone)
															#line 19210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startBackupRangeInternal", reinterpret_cast<unsigned long>(this));

	}
	~StartBackupRangeInternalActorState() 
	{
		fdb_probe_actor_destroy("startBackupRangeInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2487 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2488 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			nextKey = Params.beginKey().get(task);
															#line 2489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			endKey = Params.endKey().get(task);
															#line 2491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_0 = getBlockOfShards(tr, nextKey, endKey, CLIENT_KNOBS->BACKUP_SHARD_TASK_LIMIT);
															#line 2491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 1;
															#line 2491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 19240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartBackupRangeInternalActorState();
		static_cast<StartBackupRangeInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2494 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<Future<Key>> addTaskVector;
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(int idx = 0;idx < keys.size();++idx) {
															#line 2496 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (nextKey != keys[idx])
															#line 19267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2497 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				addTaskVector.push_back(addTask(tr, taskBucket, task, task->getPriority(), nextKey, keys[idx], TaskCompletionKey::joinWith(onDone)));
															#line 2504 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent("FileBackupRangeSplit") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("SliceBeginKey", nextKey.printable()) .detail("SliceEndKey", keys[idx].printable());
															#line 19273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			}
															#line 2512 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			nextKey = keys[idx];
															#line 19277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		}
															#line 2515 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(addTaskVector);
															#line 2515 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 2;
															#line 2515 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 1, Void >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 19288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> const& __keys,int loopDepth) 
	{
															#line 2491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		keys = __keys;
															#line 19297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> && __keys,int loopDepth) 
	{
		keys = std::move(__keys);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state > 0) static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<StartBackupRangeInternalActor*>(this)->ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2517 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextKey != endKey)
															#line 19376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(addTask(tr, taskBucket, task, task->getPriority(), nextKey, endKey, TaskCompletionKey::joinWith(onDone), Reference<TaskFuture>(), task->getPriority()));
															#line 2519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 3;
															#line 2519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 2, Void >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 19387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2517 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextKey != endKey)
															#line 19401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		{
															#line 2519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = success(addTask(tr, taskBucket, task, task->getPriority(), nextKey, endKey, TaskCompletionKey::joinWith(onDone), Reference<TaskFuture>(), task->getPriority()));
															#line 2519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 3;
															#line 2519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartBackupRangeInternalActor, 2, Void >*>(static_cast<StartBackupRangeInternalActor*>(this)));
															#line 19412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state > 0) static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<StartBackupRangeInternalActor*>(this)->ActorCallback< StartBackupRangeInternalActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartBackupRangeInternalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2530 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<StartBackupRangeInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartBackupRangeInternalActorState(); static_cast<StartBackupRangeInternalActor*>(this)->destroy(); return 0; }
															#line 19501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<StartBackupRangeInternalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartBackupRangeInternalActorState();
		static_cast<StartBackupRangeInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state > 0) static_cast<StartBackupRangeInternalActor*>(this)->actor_wait_state = 0;
		static_cast<StartBackupRangeInternalActor*>(this)->ActorCallback< StartBackupRangeInternalActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartBackupRangeInternalActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartBackupRangeInternalActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> onDone;
															#line 2488 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key nextKey;
															#line 2489 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 2491 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> keys;
															#line 19612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startBackupRangeInternal()
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class StartBackupRangeInternalActor final : public Actor<Void>, public ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >, public ActorCallback< StartBackupRangeInternalActor, 1, Void >, public ActorCallback< StartBackupRangeInternalActor, 2, Void >, public FastAllocated<StartBackupRangeInternalActor>, public StartBackupRangeInternalActorState<StartBackupRangeInternalActor> {
															#line 19617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartBackupRangeInternalActor>::operator new;
	using FastAllocated<StartBackupRangeInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17295322735792400640UL, 7759982281405512704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< StartBackupRangeInternalActor, 1, Void >;
friend struct ActorCallback< StartBackupRangeInternalActor, 2, Void >;
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StartBackupRangeInternalActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task,Reference<TaskFuture> const& onDone) 
															#line 19636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartBackupRangeInternalActorState<StartBackupRangeInternalActor>(tr, taskBucket, futureBucket, task, onDone),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14943095139744488960UL, 2433527876298934528UL);
		ActorExecutionContextHelper __helper(static_cast<StartBackupRangeInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startBackupRangeInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startBackupRangeInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartBackupRangeInternalActor, 0, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartBackupRangeInternalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartBackupRangeInternalActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> startBackupRangeInternal( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task, Reference<TaskFuture> const& onDone ) {
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new StartBackupRangeInternalActor(tr, taskBucket, futureBucket, task, onDone));
															#line 19670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
}

#line 2532 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 19675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
// This generated class is to be used only via _finish()
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor2>
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor2State {
															#line 19681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
public:
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor2State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2537 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskFuture(futureBucket->unpack(task->params[Task::reservedTaskParamKeyDone]))
															#line 19696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor2State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2538 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (Params.addBackupRangeTasks().get(task))
															#line 19711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
			{
															#line 2539 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = startBackupRangeInternal(tr, taskBucket, futureBucket, task, taskFuture);
															#line 2539 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_finishActor2*>(this)->actor_wait_state = 1;
															#line 2539 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 0, Void >*>(static_cast<_finishActor2*>(this)));
															#line 19722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_1 = taskFuture->set(tr, taskBucket);
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_finishActor2*>(this)->actor_wait_state = 2;
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 1, Void >*>(static_cast<_finishActor2*>(this)));
															#line 19736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2544 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2544 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor2*>(this)->actor_wait_state = 3;
															#line 2544 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor2, 2, Void >*>(static_cast<_finishActor2*>(this)));
															#line 19767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor2*>(this)->actor_wait_state > 0) static_cast<_finishActor2*>(this)->actor_wait_state = 0;
		static_cast<_finishActor2*>(this)->ActorCallback< _finishActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor2*>(this)->actor_wait_state > 0) static_cast<_finishActor2*>(this)->actor_wait_state = 0;
		static_cast<_finishActor2*>(this)->ActorCallback< _finishActor2, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor2, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor2, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor2, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupRangeFinish") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("TaskKey", task->key.printable());
															#line 2553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor2State(); static_cast<_finishActor2*>(this)->destroy(); return 0; }
															#line 19952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp.py_gen"
		new (&static_cast<_finishActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor2State();
		static_cast<_finishActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	i