/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Range;
import com.apple.foundationdb.ReadTransactionContext;
import com.apple.foundationdb.directory.Directory;
import com.apple.foundationdb.directory.DirectoryLayer;
import com.apple.foundationdb.directory.DirectorySubspace;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.test.DirectoryOperation;
import com.apple.foundationdb.test.DirectoryUtil;
import com.apple.foundationdb.test.Instruction;
import com.apple.foundationdb.test.StackUtils;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class DirectoryExtension {
    List<Object> dirList = new ArrayList<Object>();
    int dirIndex = 0;
    int errorIndex = 0;

    DirectoryExtension() {
        this.dirList.add(DirectoryLayer.getDefault());
    }

    Directory directory() {
        return (Directory)this.dirList.get(this.dirIndex);
    }

    Subspace subspace() {
        return (Subspace)this.dirList.get(this.dirIndex);
    }

    void processInstruction(Instruction instruction) {
        block37: {
            try {
                DirectoryOperation directoryOperation = DirectoryOperation.valueOf(instruction.op);
                if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_SUBSPACE) {
                    Tuple tuple = DirectoryUtil.popTuple(instruction).get();
                    byte[] byArray = (byte[])instruction.popParam().get();
                    this.dirList.add(new Subspace(tuple, byArray));
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_LAYER) {
                    boolean bl;
                    List<Object> list = instruction.popParams(3).get();
                    Subspace subspace = (Subspace)this.dirList.get(StackUtils.getInt(list.get(0)));
                    Subspace subspace2 = (Subspace)this.dirList.get(StackUtils.getInt(list.get(1)));
                    boolean bl2 = bl = StackUtils.getInt(list.get(2)) == 1;
                    if (subspace == null || subspace2 == null) {
                        this.dirList.add(null);
                    } else {
                        this.dirList.add(new DirectoryLayer(subspace, subspace2, bl));
                    }
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_CHANGE) {
                    this.dirIndex = StackUtils.getInt(instruction.popParam().get());
                    if (this.dirList.get(this.dirIndex) == null) {
                        this.dirIndex = this.errorIndex;
                    }
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_SET_ERROR_INDEX) {
                    this.errorIndex = StackUtils.getInt(instruction.popParam().get());
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_OR_OPEN || directoryOperation == DirectoryOperation.DIRECTORY_OPEN) {
                    List<String> list = DirectoryUtil.popPath(instruction).get();
                    byte[] byArray = (byte[])instruction.popParam().get();
                    CompletableFuture completableFuture = byArray == null ? (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_OR_OPEN ? this.directory().createOrOpen(instruction.tcx, list) : this.directory().open(instruction.readTcx, list)) : (directoryOperation == DirectoryOperation.DIRECTORY_CREATE_OR_OPEN ? this.directory().createOrOpen(instruction.tcx, list, byArray) : this.directory().open(instruction.readTcx, list, byArray));
                    this.dirList.add(completableFuture.get());
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_CREATE) {
                    CompletableFuture completableFuture;
                    List<String> list = DirectoryUtil.popPath(instruction).get();
                    List<Object> list2 = instruction.popParams(2).get();
                    byte[] byArray = (byte[])list2.get(0);
                    byte[] byArray2 = (byte[])list2.get(1);
                    if (byArray == null && byArray2 == null) {
                        completableFuture = this.directory().create(instruction.tcx, list);
                    } else if (byArray2 == null) {
                        completableFuture = this.directory().create(instruction.tcx, list, byArray);
                    } else {
                        if (byArray == null) {
                            byArray = new byte[]{};
                        }
                        completableFuture = this.directory().create(instruction.tcx, list, byArray, byArray2);
                    }
                    this.dirList.add(completableFuture.get());
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_MOVE) {
                    List<List<String>> list = DirectoryUtil.popPaths(instruction, 2).get();
                    DirectorySubspace directorySubspace = (DirectorySubspace)this.directory().move(instruction.tcx, list.get(0), list.get(1)).get();
                    this.dirList.add(directorySubspace);
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_MOVE_TO) {
                    List<String> list = DirectoryUtil.popPath(instruction).get();
                    DirectorySubspace directorySubspace = (DirectorySubspace)this.directory().moveTo(instruction.tcx, list).get();
                    this.dirList.add(directorySubspace);
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_REMOVE) {
                    int n = StackUtils.getInt(instruction.popParam().get());
                    List<List<String>> list = DirectoryUtil.popPaths(instruction, n).get();
                    if (list.size() == 0) {
                        this.directory().remove(instruction.tcx).get();
                    } else {
                        this.directory().remove(instruction.tcx, list.get(0)).get();
                    }
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_REMOVE_IF_EXISTS) {
                    int n = StackUtils.getInt(instruction.popParam().get());
                    List<List<String>> list = DirectoryUtil.popPaths(instruction, n).get();
                    if (list.size() == 0) {
                        this.directory().removeIfExists(instruction.tcx).get();
                    } else {
                        this.directory().removeIfExists(instruction.tcx, list.get(0)).get();
                    }
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_LIST) {
                    int n = StackUtils.getInt(instruction.popParam().get());
                    List<List<String>> list = DirectoryUtil.popPaths(instruction, n).get();
                    List list3 = list.size() == 0 ? (List)this.directory().list(instruction.readTcx).get() : (List)this.directory().list(instruction.readTcx, list.get(0)).get();
                    instruction.push(Tuple.fromItems((Iterable)list3).pack());
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_EXISTS) {
                    int n = StackUtils.getInt(instruction.popParam().get());
                    List<List<String>> list = DirectoryUtil.popPaths(instruction, n).get();
                    instruction.readTcx.read(readTransaction -> (Long)readTransaction.getReadVersion().join());
                    boolean bl = list.size() == 0 ? ((Boolean)this.directory().exists(instruction.readTcx).get()).booleanValue() : ((Boolean)this.directory().exists(instruction.readTcx, list.get(0)).get()).booleanValue();
                    instruction.push(bl ? 1 : 0);
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_PACK_KEY) {
                    Tuple tuple = DirectoryUtil.popTuple(instruction).get();
                    instruction.push(this.subspace().pack(tuple));
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_UNPACK_KEY) {
                    byte[] byArray = (byte[])instruction.popParam().get();
                    Tuple tuple = this.subspace().unpack(byArray);
                    for (Object e : tuple) {
                        instruction.push(e);
                    }
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_RANGE) {
                    Tuple tuple = DirectoryUtil.popTuple(instruction).get();
                    Range range = this.subspace().range(tuple);
                    instruction.push(range.begin);
                    instruction.push(range.end);
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_CONTAINS) {
                    byte[] byArray = (byte[])instruction.popParam().get();
                    instruction.push(this.subspace().contains(byArray) ? 1 : 0);
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_OPEN_SUBSPACE) {
                    Tuple tuple = DirectoryUtil.popTuple(instruction).get();
                    this.dirList.add(this.subspace().subspace(tuple));
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_LOG_SUBSPACE) {
                    byte[] byArray = (byte[])instruction.popParam().get();
                    instruction.tr.set(Tuple.from((Object[])new Object[]{this.dirIndex}).pack(byArray), this.subspace().getKey());
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_LOG_DIRECTORY) {
                    byte[] byArray = (byte[])instruction.popParam().get();
                    boolean bl = (Boolean)this.directory().exists((ReadTransactionContext)instruction.tr).get();
                    ArrayList arrayList = bl ? (List)this.directory().list((ReadTransactionContext)instruction.tr).get() : new ArrayList();
                    Subspace subspace = new Subspace(new Tuple().add((long)this.dirIndex), byArray);
                    instruction.tr.set(subspace.pack((Object)"path"), Tuple.fromItems((Iterable)this.directory().getPath()).pack());
                    instruction.tr.set(subspace.pack((Object)"layer"), new Tuple().add(this.directory().getLayer()).pack());
                    instruction.tr.set(subspace.pack((Object)"exists"), new Tuple().add(bl ? 1L : 0L).pack());
                    instruction.tr.set(subspace.pack((Object)"children"), Tuple.fromItems(arrayList).pack());
                    break block37;
                }
                if (directoryOperation == DirectoryOperation.DIRECTORY_STRIP_PREFIX) {
                    byte[] byArray;
                    byte[] byArray3 = (byte[])instruction.popParam().get();
                    if (byArray3.length < (byArray = this.subspace().getKey()).length) {
                        throw new RuntimeException("String does not start with raw prefix");
                    }
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray3[i] == byArray[i]) continue;
                        throw new RuntimeException("String does not start with raw prefix");
                    }
                    instruction.push(Arrays.copyOfRange(byArray3, byArray.length, byArray3.length));
                    break block37;
                }
                throw new RuntimeException("Unknown operation:" + instruction.op);
            }
            catch (Throwable throwable) {
                DirectoryUtil.pushError(instruction, throwable, this.dirList);
            }
        }
    }
}

