﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/workmail/model/DescribeInboundDmarcSettingsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::WorkMail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

DescribeInboundDmarcSettingsRequest::DescribeInboundDmarcSettingsRequest() : 
    m_organizationIdHasBeenSet(false)
{
}

Aws::String DescribeInboundDmarcSettingsRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_organizationIdHasBeenSet)
  {
   payload.WithString("OrganizationId", m_organizationId);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeInboundDmarcSettingsRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "WorkMailService.DescribeInboundDmarcSettings"));
  return headers;

}




