﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/route53-recovery-control-config/model/ListRoutingControlsResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::Route53RecoveryControlConfig::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRoutingControlsResult::ListRoutingControlsResult()
{
}

ListRoutingControlsResult::ListRoutingControlsResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

ListRoutingControlsResult& ListRoutingControlsResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("NextToken"))
  {
    m_nextToken = jsonValue.GetString("NextToken");

  }

  if(jsonValue.ValueExists("RoutingControls"))
  {
    Array<JsonView> routingControlsJsonList = jsonValue.GetArray("RoutingControls");
    for(unsigned routingControlsIndex = 0; routingControlsIndex < routingControlsJsonList.GetLength(); ++routingControlsIndex)
    {
      m_routingControls.push_back(routingControlsJsonList[routingControlsIndex].AsObject());
    }
  }



  return *this;
}
