﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ec2/model/EnableImageDeprecationRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::EC2::Model;
using namespace Aws::Utils;

EnableImageDeprecationRequest::EnableImageDeprecationRequest() : 
    m_imageIdHasBeenSet(false),
    m_deprecateAtHasBeenSet(false),
    m_dryRun(false),
    m_dryRunHasBeenSet(false)
{
}

Aws::String EnableImageDeprecationRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=EnableImageDeprecation&";
  if(m_imageIdHasBeenSet)
  {
    ss << "ImageId=" << StringUtils::URLEncode(m_imageId.c_str()) << "&";
  }

  if(m_deprecateAtHasBeenSet)
  {
    ss << "DeprecateAt=" << StringUtils::URLEncode(m_deprecateAt.ToGmtString(DateFormat::ISO_8601).c_str()) << "&";
  }

  if(m_dryRunHasBeenSet)
  {
    ss << "DryRun=" << std::boolalpha << m_dryRun << "&";
  }

  ss << "Version=2016-11-15";
  return ss.str();
}


void  EnableImageDeprecationRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
