﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/wellarchitected/model/ImportLensResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::WellArchitected::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ImportLensResult::ImportLensResult() : 
    m_status(ImportLensStatus::NOT_SET)
{
}

ImportLensResult::ImportLensResult(const Aws::AmazonWebServiceResult<JsonValue>& result) : 
    m_status(ImportLensStatus::NOT_SET)
{
  *this = result;
}

ImportLensResult& ImportLensResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("LensArn"))
  {
    m_lensArn = jsonValue.GetString("LensArn");

  }

  if(jsonValue.ValueExists("Status"))
  {
    m_status = ImportLensStatusMapper::GetImportLensStatusForName(jsonValue.GetString("Status"));

  }



  return *this;
}
