﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ssm-contacts/model/GetContactResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::SSMContacts::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetContactResult::GetContactResult() : 
    m_type(ContactType::NOT_SET)
{
}

GetContactResult::GetContactResult(const Aws::AmazonWebServiceResult<JsonValue>& result) : 
    m_type(ContactType::NOT_SET)
{
  *this = result;
}

GetContactResult& GetContactResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("ContactArn"))
  {
    m_contactArn = jsonValue.GetString("ContactArn");

  }

  if(jsonValue.ValueExists("Alias"))
  {
    m_alias = jsonValue.GetString("Alias");

  }

  if(jsonValue.ValueExists("DisplayName"))
  {
    m_displayName = jsonValue.GetString("DisplayName");

  }

  if(jsonValue.ValueExists("Type"))
  {
    m_type = ContactTypeMapper::GetContactTypeForName(jsonValue.GetString("Type"));

  }

  if(jsonValue.ValueExists("Plan"))
  {
    m_plan = jsonValue.GetObject("Plan");

  }



  return *this;
}
