﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/quicksight/model/ColumnLevelPermissionRule.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace QuickSight
{
namespace Model
{

ColumnLevelPermissionRule::ColumnLevelPermissionRule() : 
    m_principalsHasBeenSet(false),
    m_columnNamesHasBeenSet(false)
{
}

ColumnLevelPermissionRule::ColumnLevelPermissionRule(JsonView jsonValue) : 
    m_principalsHasBeenSet(false),
    m_columnNamesHasBeenSet(false)
{
  *this = jsonValue;
}

ColumnLevelPermissionRule& ColumnLevelPermissionRule::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Principals"))
  {
    Array<JsonView> principalsJsonList = jsonValue.GetArray("Principals");
    for(unsigned principalsIndex = 0; principalsIndex < principalsJsonList.GetLength(); ++principalsIndex)
    {
      m_principals.push_back(principalsJsonList[principalsIndex].AsString());
    }
    m_principalsHasBeenSet = true;
  }

  if(jsonValue.ValueExists("ColumnNames"))
  {
    Array<JsonView> columnNamesJsonList = jsonValue.GetArray("ColumnNames");
    for(unsigned columnNamesIndex = 0; columnNamesIndex < columnNamesJsonList.GetLength(); ++columnNamesIndex)
    {
      m_columnNames.push_back(columnNamesJsonList[columnNamesIndex].AsString());
    }
    m_columnNamesHasBeenSet = true;
  }

  return *this;
}

JsonValue ColumnLevelPermissionRule::Jsonize() const
{
  JsonValue payload;

  if(m_principalsHasBeenSet)
  {
   Array<JsonValue> principalsJsonList(m_principals.size());
   for(unsigned principalsIndex = 0; principalsIndex < principalsJsonList.GetLength(); ++principalsIndex)
   {
     principalsJsonList[principalsIndex].AsString(m_principals[principalsIndex]);
   }
   payload.WithArray("Principals", std::move(principalsJsonList));

  }

  if(m_columnNamesHasBeenSet)
  {
   Array<JsonValue> columnNamesJsonList(m_columnNames.size());
   for(unsigned columnNamesIndex = 0; columnNamesIndex < columnNamesJsonList.GetLength(); ++columnNamesIndex)
   {
     columnNamesJsonList[columnNamesIndex].AsString(m_columnNames[columnNamesIndex]);
   }
   payload.WithArray("ColumnNames", std::move(columnNamesJsonList));

  }

  return payload;
}

} // namespace Model
} // namespace QuickSight
} // namespace Aws
