﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/lookoutvision/model/StartModelResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::LookoutforVision::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

StartModelResult::StartModelResult() : 
    m_status(ModelHostingStatus::NOT_SET)
{
}

StartModelResult::StartModelResult(const Aws::AmazonWebServiceResult<JsonValue>& result) : 
    m_status(ModelHostingStatus::NOT_SET)
{
  *this = result;
}

StartModelResult& StartModelResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("Status"))
  {
    m_status = ModelHostingStatusMapper::GetModelHostingStatusForName(jsonValue.GetString("Status"));

  }



  return *this;
}
