﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/lexv2-runtime/model/ConfidenceScore.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace LexRuntimeV2
{
namespace Model
{

ConfidenceScore::ConfidenceScore() : 
    m_score(0.0),
    m_scoreHasBeenSet(false)
{
}

ConfidenceScore::ConfidenceScore(JsonView jsonValue) : 
    m_score(0.0),
    m_scoreHasBeenSet(false)
{
  *this = jsonValue;
}

ConfidenceScore& ConfidenceScore::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("score"))
  {
    m_score = jsonValue.GetDouble("score");

    m_scoreHasBeenSet = true;
  }

  return *this;
}

JsonValue ConfidenceScore::Jsonize() const
{
  JsonValue payload;

  if(m_scoreHasBeenSet)
  {
   payload.WithDouble("score", m_score);

  }

  return payload;
}

} // namespace Model
} // namespace LexRuntimeV2
} // namespace Aws
