﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ivschat/model/CreateChatTokenResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::ivschat::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateChatTokenResult::CreateChatTokenResult()
{
}

CreateChatTokenResult::CreateChatTokenResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

CreateChatTokenResult& CreateChatTokenResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("sessionExpirationTime"))
  {
    m_sessionExpirationTime = jsonValue.GetString("sessionExpirationTime");

  }

  if(jsonValue.ValueExists("token"))
  {
    m_token = jsonValue.GetString("token");

  }

  if(jsonValue.ValueExists("tokenExpirationTime"))
  {
    m_tokenExpirationTime = jsonValue.GetString("tokenExpirationTime");

  }



  return *this;
}
