﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/iotwireless/model/GetPartnerAccountResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::IoTWireless::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetPartnerAccountResult::GetPartnerAccountResult() : 
    m_accountLinked(false)
{
}

GetPartnerAccountResult::GetPartnerAccountResult(const Aws::AmazonWebServiceResult<JsonValue>& result) : 
    m_accountLinked(false)
{
  *this = result;
}

GetPartnerAccountResult& GetPartnerAccountResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("Sidewalk"))
  {
    m_sidewalk = jsonValue.GetObject("Sidewalk");

  }

  if(jsonValue.ValueExists("AccountLinked"))
  {
    m_accountLinked = jsonValue.GetBool("AccountLinked");

  }



  return *this;
}
