﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudsearch/CloudSearch_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/cloudsearch/model/AnalysisScheme.h>
#include <aws/cloudsearch/model/OptionStatus.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace CloudSearch
{
namespace Model
{

  /**
   * <p>The status and configuration of an <code>AnalysisScheme</code>.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/cloudsearch-2013-01-01/AnalysisSchemeStatus">AWS
   * API Reference</a></p>
   */
  class AWS_CLOUDSEARCH_API AnalysisSchemeStatus
  {
  public:
    AnalysisSchemeStatus();
    AnalysisSchemeStatus(const Aws::Utils::Xml::XmlNode& xmlNode);
    AnalysisSchemeStatus& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
    void OutputToStream(Aws::OStream& oStream, const char* location) const;


    
    inline const AnalysisScheme& GetOptions() const{ return m_options; }

    
    inline bool OptionsHasBeenSet() const { return m_optionsHasBeenSet; }

    
    inline void SetOptions(const AnalysisScheme& value) { m_optionsHasBeenSet = true; m_options = value; }

    
    inline void SetOptions(AnalysisScheme&& value) { m_optionsHasBeenSet = true; m_options = std::move(value); }

    
    inline AnalysisSchemeStatus& WithOptions(const AnalysisScheme& value) { SetOptions(value); return *this;}

    
    inline AnalysisSchemeStatus& WithOptions(AnalysisScheme&& value) { SetOptions(std::move(value)); return *this;}


    
    inline const OptionStatus& GetStatus() const{ return m_status; }

    
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }

    
    inline void SetStatus(const OptionStatus& value) { m_statusHasBeenSet = true; m_status = value; }

    
    inline void SetStatus(OptionStatus&& value) { m_statusHasBeenSet = true; m_status = std::move(value); }

    
    inline AnalysisSchemeStatus& WithStatus(const OptionStatus& value) { SetStatus(value); return *this;}

    
    inline AnalysisSchemeStatus& WithStatus(OptionStatus&& value) { SetStatus(std::move(value)); return *this;}

  private:

    AnalysisScheme m_options;
    bool m_optionsHasBeenSet;

    OptionStatus m_status;
    bool m_statusHasBeenSet;
  };

} // namespace Model
} // namespace CloudSearch
} // namespace Aws
