#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
/*
 * FlowTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2022 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Unit tests for the flow language and libraries

#include "flow/Arena.h"
#include "flow/ProtocolVersion.h"
#include "flow/UnitTest.h"
#include "flow/DeterministicRandom.h"
#include "flow/IThreadPool.h"
#include "flow/WriteOnlySet.h"
#include "fdbrpc/fdbrpc.h"
#include "flow/IAsyncFile.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

void forceLinkFlowTests() {}

constexpr int firstLine = __LINE__;
															#line 39 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase37()
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase37Actor>
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase37ActorState {
															#line 46 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase37ActorState(UnitTestParameters const& params) 
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 53 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase37", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase37ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase37", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 68 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase37ActorState();
		static_cast<FlowTestCase37Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 51 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__FILE__sr.endsWith("FlowTests.actor.cpp"_sr));
															#line 52 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase37Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase37ActorState(); static_cast<FlowTestCase37Actor*>(this)->destroy(); return 0; }
															#line 93 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase37Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase37ActorState();
		static_cast<FlowTestCase37Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 40 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(__LINE__ == firstLine + 4);
															#line 41 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 41 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 117 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 1;
															#line 41 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase37Actor, 0, Void >*>(static_cast<FlowTestCase37Actor*>(this)));
															#line 122 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 45 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(__LINE__ == firstLine + 9);
															#line 46 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = Future<Void>(Void());
															#line 46 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 161 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 2;
															#line 46 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase37Actor, 1, Void >*>(static_cast<FlowTestCase37Actor*>(this)));
															#line 166 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 6);
															#line 43 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1loopBody1Catch1(success(), loopDepth);
															#line 183 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 42 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 6);
															#line 43 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1loopBody1Catch1(success(), loopDepth);
															#line 193 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase37Actor*>(this)->ActorCallback< FlowTestCase37Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase37Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 11);
															#line 264 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 11);
															#line 273 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase37Actor*>(this)->ActorCallback< FlowTestCase37Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase37Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 343 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase37()
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase37Actor final : public Actor<Void>, public ActorCallback< FlowTestCase37Actor, 0, Void >, public ActorCallback< FlowTestCase37Actor, 1, Void >, public FastAllocated<FlowTestCase37Actor>, public FlowTestCase37ActorState<FlowTestCase37Actor> {
															#line 348 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase37Actor>::operator new;
	using FastAllocated<FlowTestCase37Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase37Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase37Actor, 1, Void >;
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase37Actor(UnitTestParameters const& params) 
															#line 360 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase37ActorState<FlowTestCase37Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase37");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase37Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase37Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase37( UnitTestParameters const& params ) {
															#line 37 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase37Actor(params));
															#line 389 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase37, "/flow/actorcompiler/lineNumbers")

#line 54 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 395 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase55()
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase55Actor>
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase55ActorState {
															#line 402 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase55ActorState(UnitTestParameters const& params) 
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 409 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase55", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase55ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase55", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (FLOW_KNOBS->MAX_BUGGIFIED_DELAY == 0)
															#line 424 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 57 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (!static_cast<FlowTestCase55Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase55ActorState(); static_cast<FlowTestCase55Actor*>(this)->destroy(); return 0; }
															#line 428 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				new (&static_cast<FlowTestCase55Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase55ActorState();
				static_cast<FlowTestCase55Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 59 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 436 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase55ActorState();
		static_cast<FlowTestCase55Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		x = deterministicRandom()->random01();
															#line 61 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		last = 0;
															#line 62 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		f1 = map(delay(x), [last = &last](const Void&) { *last = 1; return Void(); });
															#line 66 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		f2 = map(delay(x), [last = &last](const Void&) { *last = 2; return Void(); });
															#line 70 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = f1 && f2;
															#line 70 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase55Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 476 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase55Actor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase55Actor, 0, Void >*>(static_cast<FlowTestCase55Actor*>(this)));
															#line 481 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (last == 1)
															#line 490 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 72 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			CODE_PROBE(true, "Delays can become ready out of order", probe::decoration::rare);
															#line 73 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase55Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase55ActorState(); static_cast<FlowTestCase55Actor*>(this)->destroy(); return 0; }
															#line 496 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase55Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase55ActorState();
			static_cast<FlowTestCase55Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (last == 1)
															#line 510 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 72 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			CODE_PROBE(true, "Delays can become ready out of order", probe::decoration::rare);
															#line 73 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase55Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase55ActorState(); static_cast<FlowTestCase55Actor*>(this)->destroy(); return 0; }
															#line 516 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase55Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase55ActorState();
			static_cast<FlowTestCase55Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase55Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase55Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase55Actor*>(this)->ActorCallback< FlowTestCase55Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase55Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase55Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase55Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 60 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	double x;
															#line 61 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int last;
															#line 62 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f1;
															#line 66 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f2;
															#line 599 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase55()
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase55Actor final : public Actor<Void>, public ActorCallback< FlowTestCase55Actor, 0, Void >, public FastAllocated<FlowTestCase55Actor>, public FlowTestCase55ActorState<FlowTestCase55Actor> {
															#line 604 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase55Actor>::operator new;
	using FastAllocated<FlowTestCase55Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase55Actor, 0, Void >;
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase55Actor(UnitTestParameters const& params) 
															#line 615 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase55ActorState<FlowTestCase55Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase55");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase55Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase55( UnitTestParameters const& params ) {
															#line 55 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase55Actor(params));
															#line 643 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase55, "/flow/buggifiedDelay")

#line 77 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

template <class T, class Func, class ErrFunc, class CallbackType>
class LambdaCallback final : public CallbackType, public FastAllocated<LambdaCallback<T, Func, ErrFunc, CallbackType>> {
	Func func;
	ErrFunc errFunc;

	void fire(T const& t) override {
		CallbackType::remove();
		func(t);
		delete this;
	}
	void fire(T&& t) override {
		CallbackType::remove();
		func(std::move(t));
		delete this;
	}
	void error(Error e) override {
		CallbackType::remove();
		errFunc(e);
		delete this;
	}

public:
	LambdaCallback(Func&& f, ErrFunc&& e) : func(std::move(f)), errFunc(std::move(e)) {}
};

template <class T, class Func, class ErrFunc>
void onReady(Future<T>&& f, Func&& func, ErrFunc&& errFunc) {
	if (f.isReady()) {
		if (f.isError())
			errFunc(f.getError());
		else
			func(f.get());
	} else
		f.addCallbackAndClear(new LambdaCallback<T, Func, ErrFunc, Callback<T>>(std::move(func), std::move(errFunc)));
}

template <class T, class Func, class ErrFunc>
void onReady(FutureStream<T>&& f, Func&& func, ErrFunc&& errFunc) {
	if (f.isReady()) {
		if (f.isError())
			errFunc(f.getError());
		else
			func(f.pop());
	} else
		f.addCallbackAndClear(
		    new LambdaCallback<T, Func, ErrFunc, SingleCallback<T>>(std::move(func), std::move(errFunc)));
}

															#line 697 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via emptyVoidActor()
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class EmptyVoidActorActor>
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyVoidActorActorState {
															#line 704 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyVoidActorActorState() 
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 710 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("emptyVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~EmptyVoidActorActorState() 
	{
		fdb_probe_actor_destroy("emptyVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<EmptyVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<EmptyVoidActorActor*>(this);
															#line 743 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
};
// This generated class is to be used only via emptyVoidActor()
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyVoidActorActor final : public Actor<void>, public FastAllocated<EmptyVoidActorActor>, public EmptyVoidActorActorState<EmptyVoidActorActor> {
															#line 752 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<EmptyVoidActorActor>::operator new;
	using FastAllocated<EmptyVoidActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyVoidActorActor() 
															#line 762 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   EmptyVoidActorActorState<EmptyVoidActorActor>()
	{
		fdb_probe_actor_enter("emptyVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void emptyVoidActor(  ) {
															#line 126 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new EmptyVoidActorActor();
															#line 781 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 127 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 786 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via emptyActor()
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class EmptyActorActor>
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyActorActorState {
															#line 793 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyActorActorState() 
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 799 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("emptyActor", reinterpret_cast<unsigned long>(this));

	}
	~EmptyActorActorState() 
	{
		fdb_probe_actor_destroy("emptyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<EmptyActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EmptyActorActorState(); static_cast<EmptyActorActor*>(this)->destroy(); return 0; }
															#line 813 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<EmptyActorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~EmptyActorActorState();
			static_cast<EmptyActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EmptyActorActorState();
		static_cast<EmptyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via emptyActor()
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyActorActor final : public Actor<Void>, public FastAllocated<EmptyActorActor>, public EmptyActorActorState<EmptyActorActor> {
															#line 839 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<EmptyActorActor>::operator new;
	using FastAllocated<EmptyActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyActorActor() 
															#line 849 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   EmptyActorActorState<EmptyActorActor>()
	{
		fdb_probe_actor_enter("emptyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> emptyActor(  ) {
															#line 128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new EmptyActorActor());
															#line 876 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 131 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 881 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via oneWaitVoidActor()
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class OneWaitVoidActorActor>
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitVoidActorActorState {
															#line 888 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitVoidActorActorState(Future<Void> const& f) 
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f)
															#line 895 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("oneWaitVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~OneWaitVoidActorActorState() 
	{
		fdb_probe_actor_destroy("oneWaitVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 133 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 912 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state = 1;
															#line 133 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OneWaitVoidActorActor, 0, Void >*>(static_cast<OneWaitVoidActorActor*>(this)));
															#line 916 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<OneWaitVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state > 0) static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state = 0;
		static_cast<OneWaitVoidActorActor*>(this)->ActorCallback< OneWaitVoidActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<OneWaitVoidActorActor*>(this);
															#line 1013 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 1020 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via oneWaitVoidActor()
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitVoidActorActor final : public Actor<void>, public ActorCallback< OneWaitVoidActorActor, 0, Void >, public FastAllocated<OneWaitVoidActorActor>, public OneWaitVoidActorActorState<OneWaitVoidActorActor> {
															#line 1025 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<OneWaitVoidActorActor>::operator new;
	using FastAllocated<OneWaitVoidActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< OneWaitVoidActorActor, 0, Void >;
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitVoidActorActor(Future<Void> const& f) 
															#line 1036 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   OneWaitVoidActorActorState<OneWaitVoidActorActor>(f)
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("oneWaitVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void oneWaitVoidActor( Future<Void> const& f ) {
															#line 132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new OneWaitVoidActorActor(f);
															#line 1055 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 135 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1060 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via oneWaitActor()
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class OneWaitActorActor>
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitActorActorState {
															#line 1067 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitActorActorState(Future<Void> const& f) 
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f)
															#line 1074 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("oneWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~OneWaitActorActorState() 
	{
		fdb_probe_actor_destroy("oneWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 137 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<OneWaitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1091 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OneWaitActorActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OneWaitActorActor, 0, Void >*>(static_cast<OneWaitActorActor*>(this)));
															#line 1096 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<OneWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OneWaitActorActorState(); static_cast<OneWaitActorActor*>(this)->destroy(); return 0; }
															#line 1119 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<OneWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<OneWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OneWaitActorActorState(); static_cast<OneWaitActorActor*>(this)->destroy(); return 0; }
															#line 1131 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<OneWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OneWaitActorActor*>(this)->actor_wait_state > 0) static_cast<OneWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<OneWaitActorActor*>(this)->ActorCallback< OneWaitActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OneWaitActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OneWaitActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OneWaitActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 1204 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via oneWaitActor()
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitActorActor final : public Actor<Void>, public ActorCallback< OneWaitActorActor, 0, Void >, public FastAllocated<OneWaitActorActor>, public OneWaitActorActorState<OneWaitActorActor> {
															#line 1209 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<OneWaitActorActor>::operator new;
	using FastAllocated<OneWaitActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< OneWaitActorActor, 0, Void >;
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitActorActor(Future<Void> const& f) 
															#line 1220 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   OneWaitActorActorState<OneWaitActorActor>(f)
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("oneWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OneWaitActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> oneWaitActor( Future<Void> const& f ) {
															#line 136 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new OneWaitActorActor(f));
															#line 1248 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 140 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

Future<Void> g_cheese;
															#line 1254 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via cheeseWaitActor()
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class CheeseWaitActorActor>
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class CheeseWaitActorActorState {
															#line 1261 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	CheeseWaitActorActorState() 
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("cheeseWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~CheeseWaitActorActorState() 
	{
		fdb_probe_actor_destroy("cheeseWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_cheese;
															#line 143 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<CheeseWaitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1283 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheeseWaitActorActor*>(this)->actor_wait_state = 1;
															#line 143 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheeseWaitActorActor, 0, Void >*>(static_cast<CheeseWaitActorActor*>(this)));
															#line 1288 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 144 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<CheeseWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheeseWaitActorActorState(); static_cast<CheeseWaitActorActor*>(this)->destroy(); return 0; }
															#line 1311 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<CheeseWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 144 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<CheeseWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheeseWaitActorActorState(); static_cast<CheeseWaitActorActor*>(this)->destroy(); return 0; }
															#line 1323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<CheeseWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheeseWaitActorActor*>(this)->actor_wait_state > 0) static_cast<CheeseWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<CheeseWaitActorActor*>(this)->ActorCallback< CheeseWaitActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheeseWaitActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheeseWaitActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheeseWaitActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via cheeseWaitActor()
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class CheeseWaitActorActor final : public Actor<Void>, public ActorCallback< CheeseWaitActorActor, 0, Void >, public FastAllocated<CheeseWaitActorActor>, public CheeseWaitActorActorState<CheeseWaitActorActor> {
															#line 1398 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<CheeseWaitActorActor>::operator new;
	using FastAllocated<CheeseWaitActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< CheeseWaitActorActor, 0, Void >;
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	CheeseWaitActorActor() 
															#line 1409 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   CheeseWaitActorActorState<CheeseWaitActorActor>()
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cheeseWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheeseWaitActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> cheeseWaitActor(  ) {
															#line 142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new CheeseWaitActorActor());
															#line 1437 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 146 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

size_t cheeseWaitActorSize() {
#ifndef OPEN_FOR_IDE
	return sizeof(CheeseWaitActorActor);
#else
	return 0ul;
#endif
}

															#line 1450 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via trivialVoidActor()
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TrivialVoidActorActor>
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TrivialVoidActorActorState {
															#line 1457 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TrivialVoidActorActorState(int* const& result) 
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : result(result)
															#line 1464 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("trivialVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~TrivialVoidActorActorState() 
	{
		fdb_probe_actor_destroy("trivialVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*result = 1;
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TrivialVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<TrivialVoidActorActor*>(this);
															#line 1501 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* result;
															#line 1508 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via trivialVoidActor()
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TrivialVoidActorActor final : public Actor<void>, public FastAllocated<TrivialVoidActorActor>, public TrivialVoidActorActorState<TrivialVoidActorActor> {
															#line 1513 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TrivialVoidActorActor>::operator new;
	using FastAllocated<TrivialVoidActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TrivialVoidActorActor(int* const& result) 
															#line 1523 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   TrivialVoidActorActorState<TrivialVoidActorActor>(result)
	{
		fdb_probe_actor_enter("trivialVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trivialVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trivialVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void trivialVoidActor( int* const& result ) {
															#line 155 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new TrivialVoidActorActor(result);
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 158 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1547 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via return42Actor()
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Return42ActorActor>
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Return42ActorActorState {
															#line 1554 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Return42ActorActorState() 
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 1560 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("return42Actor", reinterpret_cast<unsigned long>(this));

	}
	~Return42ActorActorState() 
	{
		fdb_probe_actor_destroy("return42Actor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<Return42ActorActor*>(this)->SAV<int>::futures) { (void)(42); this->~Return42ActorActorState(); static_cast<Return42ActorActor*>(this)->destroy(); return 0; }
															#line 1574 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<Return42ActorActor*>(this)->SAV< int >::value()) int(42);
			this->~Return42ActorActorState();
			static_cast<Return42ActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Return42ActorActorState();
		static_cast<Return42ActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via return42Actor()
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Return42ActorActor final : public Actor<int>, public FastAllocated<Return42ActorActor>, public Return42ActorActorState<Return42ActorActor> {
															#line 1600 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Return42ActorActor>::operator new;
	using FastAllocated<Return42ActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Return42ActorActor() 
															#line 1610 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Return42ActorActorState<Return42ActorActor>()
	{
		fdb_probe_actor_enter("return42Actor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("return42Actor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("return42Actor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> return42Actor(  ) {
															#line 159 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Return42ActorActor());
															#line 1637 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 162 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1642 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via voidWaitActor()
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class VoidWaitActorActor>
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class VoidWaitActorActorState {
															#line 1649 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	VoidWaitActorActorState(Future<int> const& in,int* const& result) 
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in),
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   result(result)
															#line 1658 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("voidWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~VoidWaitActorActorState() 
	{
		fdb_probe_actor_destroy("voidWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<int> __when_expr_0 = in;
															#line 164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1675 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			static_cast<VoidWaitActorActor*>(this)->actor_wait_state = 1;
															#line 164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VoidWaitActorActor, 0, int >*>(static_cast<VoidWaitActorActor*>(this)));
															#line 1679 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<VoidWaitActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		*result = i;
															#line 1701 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		*result = i;
															#line 1710 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VoidWaitActorActor*>(this)->actor_wait_state > 0) static_cast<VoidWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<VoidWaitActorActor*>(this)->ActorCallback< VoidWaitActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< VoidWaitActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VoidWaitActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VoidWaitActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<VoidWaitActorActor*>(this);
															#line 1782 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<int> in;
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* result;
															#line 1791 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via voidWaitActor()
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class VoidWaitActorActor final : public Actor<void>, public ActorCallback< VoidWaitActorActor, 0, int >, public FastAllocated<VoidWaitActorActor>, public VoidWaitActorActorState<VoidWaitActorActor> {
															#line 1796 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<VoidWaitActorActor>::operator new;
	using FastAllocated<VoidWaitActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() {{ ((Actor<void>*)this)->~Actor(); operator delete(this); }}
#pragma clang diagnostic pop
friend struct ActorCallback< VoidWaitActorActor, 0, int >;
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	VoidWaitActorActor(Future<int> const& in,int* const& result) 
															#line 1807 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   VoidWaitActorActorState<VoidWaitActorActor>(in, result)
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("voidWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
}
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void voidWaitActor( Future<int> const& in, int* const& result ) {
															#line 163 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new VoidWaitActorActor(in, result);
															#line 1826 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 167 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1831 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via addOneActor()
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class AddOneActorActor>
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class AddOneActorActorState {
															#line 1838 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AddOneActorActorState(Future<int> const& in) 
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in)
															#line 1845 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("addOneActor", reinterpret_cast<unsigned long>(this));

	}
	~AddOneActorActorState() 
	{
		fdb_probe_actor_destroy("addOneActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<int> __when_expr_0 = in;
															#line 169 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<AddOneActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1862 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddOneActorActor*>(this)->actor_wait_state = 1;
															#line 169 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddOneActorActor, 0, int >*>(static_cast<AddOneActorActor*>(this)));
															#line 1867 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 170 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<AddOneActorActor*>(this)->SAV<int>::futures) { (void)(i + 1); this->~AddOneActorActorState(); static_cast<AddOneActorActor*>(this)->destroy(); return 0; }
															#line 1890 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<AddOneActorActor*>(this)->SAV< int >::value()) int(i + 1);
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 170 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<AddOneActorActor*>(this)->SAV<int>::futures) { (void)(i + 1); this->~AddOneActorActorState(); static_cast<AddOneActorActor*>(this)->destroy(); return 0; }
															#line 1902 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<AddOneActorActor*>(this)->SAV< int >::value()) int(i + 1);
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddOneActorActor*>(this)->actor_wait_state > 0) static_cast<AddOneActorActor*>(this)->actor_wait_state = 0;
		static_cast<AddOneActorActor*>(this)->ActorCallback< AddOneActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< AddOneActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddOneActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddOneActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<int> in;
															#line 1975 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via addOneActor()
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class AddOneActorActor final : public Actor<int>, public ActorCallback< AddOneActorActor, 0, int >, public FastAllocated<AddOneActorActor>, public AddOneActorActorState<AddOneActorActor> {
															#line 1980 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<AddOneActorActor>::operator new;
	using FastAllocated<AddOneActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< AddOneActorActor, 0, int >;
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AddOneActorActor(Future<int> const& in) 
															#line 1991 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   AddOneActorActorState<AddOneActorActor>(in)
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addOneActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddOneActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> addOneActor( Future<int> const& in ) {
															#line 168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new AddOneActorActor(in));
															#line 2019 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 172 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2024 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via chooseTwoActor()
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ChooseTwoActorActor>
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ChooseTwoActorActorState {
															#line 2031 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ChooseTwoActorActorState(Future<Void> const& f,Future<Void> const& g) 
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f),
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   g(g)
															#line 2040 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("chooseTwoActor", reinterpret_cast<unsigned long>(this));

	}
	~ChooseTwoActorActorState() 
	{
		fdb_probe_actor_destroy("chooseTwoActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 175 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ChooseTwoActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2057 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 176 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = g;
															#line 2061 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ChooseTwoActorActor*>(this)->actor_wait_state = 1;
															#line 175 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChooseTwoActorActor, 0, Void >*>(static_cast<ChooseTwoActorActor*>(this)));
															#line 176 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChooseTwoActorActor, 1, Void >*>(static_cast<ChooseTwoActorActor*>(this)));
															#line 2068 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChooseTwoActorActorState();
		static_cast<ChooseTwoActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 178 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ChooseTwoActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChooseTwoActorActorState(); static_cast<ChooseTwoActorActor*>(this)->destroy(); return 0; }
															#line 2091 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ChooseTwoActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChooseTwoActorActorState();
		static_cast<ChooseTwoActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChooseTwoActorActor*>(this)->actor_wait_state > 0) static_cast<ChooseTwoActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseTwoActorActor*>(this)->ActorCallback< ChooseTwoActorActor, 0, Void >::remove();
		static_cast<ChooseTwoActorActor*>(this)->ActorCallback< ChooseTwoActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChooseTwoActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChooseTwoActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> g;
															#line 2224 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via chooseTwoActor()
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ChooseTwoActorActor final : public Actor<Void>, public ActorCallback< ChooseTwoActorActor, 0, Void >, public ActorCallback< ChooseTwoActorActor, 1, Void >, public FastAllocated<ChooseTwoActorActor>, public ChooseTwoActorActorState<ChooseTwoActorActor> {
															#line 2229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<ChooseTwoActorActor>::operator new;
	using FastAllocated<ChooseTwoActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< ChooseTwoActorActor, 0, Void >;
friend struct ActorCallback< ChooseTwoActorActor, 1, Void >;
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ChooseTwoActorActor(Future<Void> const& f,Future<Void> const& g) 
															#line 2241 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   ChooseTwoActorActorState<ChooseTwoActorActor>(f, g)
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chooseTwoActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChooseTwoActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> chooseTwoActor( Future<Void> const& f, Future<Void> const& g ) {
															#line 173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new ChooseTwoActorActor(f, g));
															#line 2269 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 180 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2274 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via consumeOneActor()
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ConsumeOneActorActor>
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ConsumeOneActorActorState {
															#line 2281 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ConsumeOneActorActorState(FutureStream<int> const& in) 
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in)
															#line 2288 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("consumeOneActor", reinterpret_cast<unsigned long>(this));

	}
	~ConsumeOneActorActorState() 
	{
		fdb_probe_actor_destroy("consumeOneActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<int> __when_expr_0 = in;
															#line 182 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ConsumeOneActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2305 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<ConsumeOneActorActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ConsumeOneActorActor, 0, int >*>(static_cast<ConsumeOneActorActor*>(this)));
															#line 2310 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 183 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ConsumeOneActorActor*>(this)->SAV<int>::futures) { (void)(i); this->~ConsumeOneActorActorState(); static_cast<ConsumeOneActorActor*>(this)->destroy(); return 0; }
															#line 2333 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ConsumeOneActorActor*>(this)->SAV< int >::value()) int(i);
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 183 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ConsumeOneActorActor*>(this)->SAV<int>::futures) { (void)(i); this->~ConsumeOneActorActorState(); static_cast<ConsumeOneActorActor*>(this)->destroy(); return 0; }
															#line 2345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ConsumeOneActorActor*>(this)->SAV< int >::value()) int(i);
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsumeOneActorActor*>(this)->actor_wait_state > 0) static_cast<ConsumeOneActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeOneActorActor*>(this)->ActorSingleCallback< ConsumeOneActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<int> in;
															#line 2418 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via consumeOneActor()
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ConsumeOneActorActor final : public Actor<int>, public ActorSingleCallback< ConsumeOneActorActor, 0, int >, public FastAllocated<ConsumeOneActorActor>, public ConsumeOneActorActorState<ConsumeOneActorActor> {
															#line 2423 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<ConsumeOneActorActor>::operator new;
	using FastAllocated<ConsumeOneActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ConsumeOneActorActor, 0, int >;
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ConsumeOneActorActor(FutureStream<int> const& in) 
															#line 2434 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   ConsumeOneActorActorState<ConsumeOneActorActor>(in)
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeOneActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ConsumeOneActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> consumeOneActor( FutureStream<int> const& in ) {
															#line 181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new ConsumeOneActorActor(in));
															#line 2462 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 185 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2467 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via sumActor()
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class SumActorActor>
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class SumActorActorState {
															#line 2474 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	SumActorActorState(FutureStream<int> const& in) 
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in),
															#line 187 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   total(0)
															#line 2483 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("sumActor", reinterpret_cast<unsigned long>(this));

	}
	~SumActorActorState() 
	{
		fdb_probe_actor_destroy("sumActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 189 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				;
															#line 2499 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SumActorActorState();
		static_cast<SumActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 197 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<SumActorActor*>(this)->SAV<int>::futures) { (void)(total); this->~SumActorActorState(); static_cast<SumActorActor*>(this)->destroy(); return 0; }
															#line 2528 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<SumActorActor*>(this)->SAV< int >::value()) int(std::move(total)); // state_var_RVO
		this->~SumActorActorState();
		static_cast<SumActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 194 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 2541 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 195 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2545 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 190 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		FutureStream<int> __when_expr_0 = in;
															#line 190 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<SumActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2570 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<SumActorActor*>(this)->actor_wait_state = 1;
															#line 190 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< SumActorActor, 0, int >*>(static_cast<SumActorActor*>(this)));
															#line 2575 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int const& i,int loopDepth) 
	{
															#line 191 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		total += i;
															#line 2584 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int && i,int loopDepth) 
	{
															#line 191 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		total += i;
															#line 2593 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SumActorActor*>(this)->actor_wait_state > 0) static_cast<SumActorActor*>(this)->actor_wait_state = 0;
		static_cast<SumActorActor*>(this)->ActorSingleCallback< SumActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< SumActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< SumActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< SumActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<int> in;
															#line 187 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int total;
															#line 2665 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via sumActor()
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class SumActorActor final : public Actor<int>, public ActorSingleCallback< SumActorActor, 0, int >, public FastAllocated<SumActorActor>, public SumActorActorState<SumActorActor> {
															#line 2670 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<SumActorActor>::operator new;
	using FastAllocated<SumActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< SumActorActor, 0, int >;
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	SumActorActor(FutureStream<int> const& in) 
															#line 2681 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   SumActorActorState<SumActorActor>(in)
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sumActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< SumActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> sumActor( FutureStream<int> const& in ) {
															#line 186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new SumActorActor(in));
															#line 2709 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 199 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2714 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via templateActor()
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T, class TemplateActorActor>
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TemplateActorActorState {
															#line 2721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TemplateActorActorState(T const& t) 
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : t(t)
															#line 2728 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("templateActor", reinterpret_cast<unsigned long>(this));

	}
	~TemplateActorActorState() 
	{
		fdb_probe_actor_destroy("templateActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 202 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TemplateActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TemplateActorActorState(); static_cast<TemplateActorActor*>(this)->destroy(); return 0; }
															#line 2743 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<TemplateActorActor*>(this)->SAV< T >::value()) T(std::move(t)); // state_var_RVO
			this->~TemplateActorActorState();
			static_cast<TemplateActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TemplateActorActorState();
		static_cast<TemplateActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	T t;
															#line 2767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via templateActor()
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T>
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TemplateActorActor final : public Actor<T>, public FastAllocated<TemplateActorActor<T>>, public TemplateActorActorState<T, TemplateActorActor<T>> {
															#line 2774 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TemplateActorActor<T>>::operator new;
	using FastAllocated<TemplateActorActor<T>>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<T>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TemplateActorActor(T const& t) 
															#line 2784 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<T>(),
		   TemplateActorActorState<T, TemplateActorActor<T>>(t)
	{
		fdb_probe_actor_enter("templateActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("templateActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("templateActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T>
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<T> templateActor( T const& t ) {
															#line 200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<T>(new TemplateActorActor<T>(t));
															#line 2813 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 204 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

static int destroy() {
	return 666;
}
															#line 2821 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via testHygeine()
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestHygeineActor>
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestHygeineActorState {
															#line 2828 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestHygeineActorState() 
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 2834 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("testHygeine", reinterpret_cast<unsigned long>(this));

	}
	~TestHygeineActorState() 
	{
		fdb_probe_actor_destroy("testHygeine", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(destroy() == 666);
															#line 210 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TestHygeineActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestHygeineActorState(); static_cast<TestHygeineActor*>(this)->destroy(); return 0; }
															#line 2850 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<TestHygeineActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestHygeineActorState();
			static_cast<TestHygeineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestHygeineActorState();
		static_cast<TestHygeineActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via testHygeine()
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestHygeineActor final : public Actor<Void>, public FastAllocated<TestHygeineActor>, public TestHygeineActorState<TestHygeineActor> {
															#line 2876 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TestHygeineActor>::operator new;
	using FastAllocated<TestHygeineActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestHygeineActor() 
															#line 2886 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestHygeineActorState<TestHygeineActor>()
	{
		fdb_probe_actor_enter("testHygeine", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testHygeine");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testHygeine", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> testHygeine(  ) {
															#line 208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new TestHygeineActor());
															#line 2913 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 212 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// bool expectActorCount(int x) { return actorCount == x; }
bool expectActorCount(int) {
	return true;
}

struct YieldMockNetwork final : INetwork, ReferenceCounted<YieldMockNetwork> {
	int ticks;
	Promise<Void> nextTick;
	int nextYield;
	INetwork* baseNetwork;

	flowGlobalType global(int id) const override { return baseNetwork->global(id); }
	void setGlobal(size_t id, flowGlobalType v) override {
		baseNetwork->setGlobal(id, v);
		return;
	}

	YieldMockNetwork() : ticks(0), nextYield(0) {
		baseNetwork = g_network;
		g_network = this;
	}
	~YieldMockNetwork() { g_network = baseNetwork; }

	void tick() {
		ticks++;
		Promise<Void> t;
		t.swap(nextTick);
		t.send(Void());
	}

	Future<class Void> delay(double seconds, TaskPriority taskID) override { return nextTick.getFuture(); }

	Future<class Void> orderedDelay(double seconds, TaskPriority taskID) override { return nextTick.getFuture(); }

	Future<class Void> yield(TaskPriority taskID) override {
		if (check_yield(taskID))
			return delay(0, taskID);
		return Void();
	}

	bool check_yield(TaskPriority taskID) override {
		if (nextYield > 0)
			--nextYield;
		return nextYield == 0;
	}

	// Delegate everything else.  TODO: Make a base class NetworkWrapper for delegating everything in INetwork
	TaskPriority getCurrentTask() const override { return baseNetwork->getCurrentTask(); }
	void setCurrentTask(TaskPriority taskID) override { baseNetwork->setCurrentTask(taskID); }
	double now() const override { return baseNetwork->now(); }
	double timer() override { return baseNetwork->timer(); }
	double timer_monotonic() override { return baseNetwork->timer_monotonic(); }
	void stop() override { return baseNetwork->stop(); }
	void addStopCallback(std::function<void()> fn) override {
		ASSERT(false);
		return;
	}
	bool isSimulated() const override { return baseNetwork->isSimulated(); }
	void onMainThread(Promise<Void>&& signal, TaskPriority taskID) override {
		return baseNetwork->onMainThread(std::move(signal), taskID);
	}
	bool isOnMainThread() const override { return baseNetwork->isOnMainThread(); }
	THREAD_HANDLE startThread(THREAD_FUNC_RETURN (*func)(void*), void* arg, int stackSize, const char* name) override {
		return baseNetwork->startThread(func, arg, stackSize, name);
	}
	Future<Reference<class IAsyncFile>> open(std::string filename, int64_t flags, int64_t mode) {
		return IAsyncFileSystem::filesystem()->open(filename, flags, mode);
	}
	Future<Void> deleteFile(std::string filename, bool mustBeDurable) {
		return IAsyncFileSystem::filesystem()->deleteFile(filename, mustBeDurable);
	}
	void run() override { return baseNetwork->run(); }
	bool checkRunnable() override { return baseNetwork->checkRunnable(); }
	void getDiskBytes(std::string const& directory, int64_t& free, int64_t& total) override {
		return baseNetwork->getDiskBytes(directory, free, total);
	}
	bool isAddressOnThisHost(NetworkAddress const& addr) const override {
		return baseNetwork->isAddressOnThisHost(addr);
	}
	const TLSConfig& getTLSConfig() const override {
		static TLSConfig emptyConfig;
		return emptyConfig;
	}
#ifdef ENABLE_SAMPLING
	ActorLineageSet& getActorLineageSet() override { throw std::exception(); }
#endif
	ProtocolVersion protocolVersion() const override { return baseNetwork->protocolVersion(); }
};

struct NonserializableThing {};
															#line 3008 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via testNonserializableThing()
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestNonserializableThingActor>
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestNonserializableThingActorState {
															#line 3015 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestNonserializableThingActorState() 
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 3021 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("testNonserializableThing", reinterpret_cast<unsigned long>(this));

	}
	~TestNonserializableThingActorState() 
	{
		fdb_probe_actor_destroy("testNonserializableThing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 304 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TestNonserializableThingActor*>(this)->SAV<NonserializableThing>::futures) { (void)(NonserializableThing()); this->~TestNonserializableThingActorState(); static_cast<TestNonserializableThingActor*>(this)->destroy(); return 0; }
															#line 3035 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<TestNonserializableThingActor*>(this)->SAV< NonserializableThing >::value()) NonserializableThing(NonserializableThing());
			this->~TestNonserializableThingActorState();
			static_cast<TestNonserializableThingActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestNonserializableThingActorState();
		static_cast<TestNonserializableThingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via testNonserializableThing()
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestNonserializableThingActor final : public Actor<NonserializableThing>, public FastAllocated<TestNonserializableThingActor>, public TestNonserializableThingActorState<TestNonserializableThingActor> {
															#line 3061 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TestNonserializableThingActor>::operator new;
	using FastAllocated<TestNonserializableThingActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<NonserializableThing>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestNonserializableThingActor() 
															#line 3071 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<NonserializableThing>(),
		   TestNonserializableThingActorState<TestNonserializableThingActor>()
	{
		fdb_probe_actor_enter("testNonserializableThing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testNonserializableThing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testNonserializableThing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<NonserializableThing> testNonserializableThing(  ) {
															#line 303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<NonserializableThing>(new TestNonserializableThingActor());
															#line 3098 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 306 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3103 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via testCancelled()
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestCancelledActor>
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestCancelledActorState {
															#line 3110 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestCancelledActorState(bool* const& exits,Future<Void> const& f) 
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : exits(exits),
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   f(f)
															#line 3119 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testCancelled", reinterpret_cast<unsigned long>(this));

	}
	~TestCancelledActorState() 
	{
		fdb_probe_actor_destroy("testCancelled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 309 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 309 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<TestCancelledActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3137 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestCancelledActor*>(this)->actor_wait_state = 1;
															#line 309 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCancelledActor, 0, Void >*>(static_cast<TestCancelledActor*>(this)));
															#line 3142 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCancelledActorState();
		static_cast<TestCancelledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 320 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<TestCancelledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCancelledActorState(); static_cast<TestCancelledActor*>(this)->destroy(); return 0; }
															#line 3171 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<TestCancelledActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCancelledActorState();
		static_cast<TestCancelledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 311 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			err = e;
															#line 3184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			try {
															#line 313 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 313 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<TestCancelledActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 3190 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
				static_cast<TestCancelledActor*>(this)->actor_wait_state = 2;
															#line 313 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCancelledActor, 1, Void >*>(static_cast<TestCancelledActor*>(this)));
															#line 3195 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCancelledActor*>(this)->actor_wait_state > 0) static_cast<TestCancelledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCancelledActor*>(this)->ActorCallback< TestCancelledActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCancelledActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 318 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 3304 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*exits = true;
															#line 316 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCancelledActor*>(this)->actor_wait_state > 0) static_cast<TestCancelledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCancelledActor*>(this)->ActorCallback< TestCancelledActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCancelledActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1Catch2cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool* exits;
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 311 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Error err;
															#line 3419 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via testCancelled()
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestCancelledActor final : public Actor<Void>, public ActorCallback< TestCancelledActor, 0, Void >, public ActorCallback< TestCancelledActor, 1, Void >, public FastAllocated<TestCancelledActor>, public TestCancelledActorState<TestCancelledActor> {
															#line 3424 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TestCancelledActor>::operator new;
	using FastAllocated<TestCancelledActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCancelledActor, 0, Void >;
friend struct ActorCallback< TestCancelledActor, 1, Void >;
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestCancelledActor(bool* const& exits,Future<Void> const& f) 
															#line 3436 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestCancelledActorState<TestCancelledActor>(exits, f)
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCancelled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCancelledActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCancelledActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<Void> testCancelled( bool* const& exits, Future<Void> const& f ) {
															#line 307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new TestCancelledActor(exits, f));
															#line 3465 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 322 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3470 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase323()
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase323Actor>
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase323ActorState {
															#line 3477 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase323ActorState(UnitTestParameters const& params) 
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 3484 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase323", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase323ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase323", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 324 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			bool exits = false;
															#line 325 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 326 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> test = testCancelled(&exits, p.getFuture());
															#line 327 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getPromiseReferenceCount() == 1 && p.getFutureReferenceCount() == 1);
															#line 328 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			test.cancel();
															#line 329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(exits);
															#line 330 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(test.getPromiseReferenceCount() == 0 && test.getFutureReferenceCount() == 1 && test.isReady() && test.isError() && test.getError().code() == error_code_actor_cancelled);
															#line 332 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getPromiseReferenceCount() == 1 && p.getFutureReferenceCount() == 0);
															#line 334 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase323Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase323ActorState(); static_cast<FlowTestCase323Actor*>(this)->destroy(); return 0; }
															#line 3515 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase323Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase323ActorState();
			static_cast<FlowTestCase323Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase323ActorState();
		static_cast<FlowTestCase323Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 3539 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase323()
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase323Actor final : public Actor<Void>, public FastAllocated<FlowTestCase323Actor>, public FlowTestCase323ActorState<FlowTestCase323Actor> {
															#line 3544 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase323Actor>::operator new;
	using FastAllocated<FlowTestCase323Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase323Actor(UnitTestParameters const& params) 
															#line 3554 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase323ActorState<FlowTestCase323Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase323", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase323");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase323", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase323( UnitTestParameters const& params ) {
															#line 323 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase323Actor(params));
															#line 3581 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase323, "/flow/flow/cancel1")

#line 336 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3587 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via noteCancel()
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class NoteCancelActor>
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class NoteCancelActorState {
															#line 3594 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	NoteCancelActorState(int* const& cancelled) 
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : cancelled(cancelled)
															#line 3601 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("noteCancel", reinterpret_cast<unsigned long>(this));

	}
	~NoteCancelActorState() 
	{
		fdb_probe_actor_destroy("noteCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 338 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*cancelled = 0;
															#line 3616 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			try {
															#line 340 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 340 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<NoteCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3622 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NoteCancelActor*>(this)->actor_wait_state = 1;
															#line 340 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NoteCancelActor, 0, Void >*>(static_cast<NoteCancelActor*>(this)));
															#line 3627 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NoteCancelActorState();
		static_cast<NoteCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 343 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("Cancelled!\n");
															#line 344 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*cancelled = 1;
															#line 345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			return a_body1Catch1(__current_error, loopDepth);
															#line 3661 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 3675 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 341 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 3683 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NoteCancelActor*>(this)->actor_wait_state > 0) static_cast<NoteCancelActor*>(this)->actor_wait_state = 0;
		static_cast<NoteCancelActor*>(this)->ActorCallback< NoteCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NoteCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NoteCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NoteCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* cancelled;
															#line 3752 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via noteCancel()
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class NoteCancelActor final : public Actor<Void>, public ActorCallback< NoteCancelActor, 0, Void >, public FastAllocated<NoteCancelActor>, public NoteCancelActorState<NoteCancelActor> {
															#line 3757 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<NoteCancelActor>::operator new;
	using FastAllocated<NoteCancelActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< NoteCancelActor, 0, Void >;
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	NoteCancelActor(int* const& cancelled) 
															#line 3768 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   NoteCancelActorState<NoteCancelActor>(cancelled)
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("noteCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NoteCancelActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> noteCancel( int* const& cancelled ) {
															#line 337 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new NoteCancelActor(cancelled));
															#line 3796 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 348 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3801 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase349()
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase349Actor>
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase349ActorState {
															#line 3808 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase349ActorState(UnitTestParameters const& params) 
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 3815 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase349", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase349ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase349", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 350 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int c1 = 0, c2 = 0, c3 = 0;
															#line 352 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> cf = noteCancel(&c1);
															#line 353 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c1 == 0);
															#line 354 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = Future<Void>();
															#line 355 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c1 == 1);
															#line 357 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = noteCancel(&c2) && noteCancel(&c3);
															#line 358 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c2 == 0 && c3 == 0);
															#line 359 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = Future<Void>();
															#line 360 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c2 == 1 && c3 == 1);
															#line 361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase349Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase349ActorState(); static_cast<FlowTestCase349Actor*>(this)->destroy(); return 0; }
															#line 3848 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase349Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase349ActorState();
			static_cast<FlowTestCase349Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase349ActorState();
		static_cast<FlowTestCase349Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 3872 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase349()
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase349Actor final : public Actor<Void>, public FastAllocated<FlowTestCase349Actor>, public FlowTestCase349ActorState<FlowTestCase349Actor> {
															#line 3877 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase349Actor>::operator new;
	using FastAllocated<FlowTestCase349Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase349Actor(UnitTestParameters const& params) 
															#line 3887 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase349ActorState<FlowTestCase349Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase349", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase349");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase349", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase349( UnitTestParameters const& params ) {
															#line 349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase349Actor(params));
															#line 3914 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase349, "/flow/flow/cancel2")

#line 363 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

namespace flow_tests_details {
// Simple message for flatbuffers unittests
struct Int {
	constexpr static FileIdentifier file_identifier = 12345;
	uint32_t value;
	Int() = default;
	Int(uint32_t value) : value(value) {}
	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, value);
	}
};
} // namespace flow_tests_details

															#line 3934 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase378()
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase378Actor>
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase378ActorState {
															#line 3941 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase378ActorState(UnitTestParameters const& params) 
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 3948 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase378", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase378ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase378", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 381 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<NonserializableThing> f = testNonserializableThing();
															#line 382 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Promise<NonserializableThing> p;
															#line 383 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				p.send(NonserializableThing());
															#line 384 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				f = p.getFuture();
															#line 3970 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 392 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> rpInt;
															#line 393 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<flow_tests_details::Int> f = rpInt.getFuture();
															#line 394 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(!f.isReady());
															#line 395 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rpInt.send(123);
															#line 396 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.get().value == 123);
															#line 3983 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 400 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> rsInt;
															#line 401 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				FutureStream<flow_tests_details::Int> f = rsInt.getFuture();
															#line 402 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rsInt.send(1);
															#line 403 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rsInt.send(2);
															#line 404 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.pop().value == 1);
															#line 405 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.pop().value == 2);
															#line 3998 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 408 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase378Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase378ActorState(); static_cast<FlowTestCase378Actor*>(this)->destroy(); return 0; }
															#line 4002 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase378Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase378ActorState();
			static_cast<FlowTestCase378Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase378ActorState();
		static_cast<FlowTestCase378Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4026 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase378()
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase378Actor final : public Actor<Void>, public FastAllocated<FlowTestCase378Actor>, public FlowTestCase378ActorState<FlowTestCase378Actor> {
															#line 4031 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase378Actor>::operator new;
	using FastAllocated<FlowTestCase378Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase378Actor(UnitTestParameters const& params) 
															#line 4041 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase378ActorState<FlowTestCase378Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase378", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase378");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase378", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase378( UnitTestParameters const& params ) {
															#line 378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase378Actor(params));
															#line 4068 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase378, "/flow/flow/nonserializable futures")

#line 410 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4074 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase411()
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase411Actor>
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase411ActorState {
															#line 4081 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase411ActorState(UnitTestParameters const& params) 
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4088 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase411", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase411ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase411", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 414 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> locInt;
															#line 415 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryWriter wr(IncludeVersion());
															#line 416 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				wr << locInt;
															#line 418 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(locInt.getEndpoint().isValid() && locInt.getEndpoint().isLocal() && locInt.getEndpoint().getPrimaryAddress() == FlowTransport::transport().getLocalAddress());
															#line 421 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryReader rd(wr.toValue(), IncludeVersion());
															#line 422 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> remoteInt;
															#line 423 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rd >> remoteInt;
															#line 425 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(remoteInt.getEndpoint() == locInt.getEndpoint());
															#line 4118 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 430 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (0)
															#line 4122 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 431 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> locInt;
															#line 432 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryWriter wr(IncludeVersion());
															#line 433 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				wr << locInt;
															#line 435 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(locInt.getEndpoint().isValid() && locInt.getEndpoint().isLocal());
															#line 437 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryReader rd(wr.toValue(), IncludeVersion());
															#line 438 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> remoteInt;
															#line 439 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rd >> remoteInt;
															#line 441 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(remoteInt.getEndpoint() == locInt.getEndpoint());
															#line 4140 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 444 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase411Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase411ActorState(); static_cast<FlowTestCase411Actor*>(this)->destroy(); return 0; }
															#line 4144 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase411Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase411ActorState();
			static_cast<FlowTestCase411Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase411ActorState();
		static_cast<FlowTestCase411Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase411()
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase411Actor final : public Actor<Void>, public FastAllocated<FlowTestCase411Actor>, public FlowTestCase411ActorState<FlowTestCase411Actor> {
															#line 4173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase411Actor>::operator new;
	using FastAllocated<FlowTestCase411Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase411Actor(UnitTestParameters const& params) 
															#line 4183 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase411ActorState<FlowTestCase411Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase411", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase411");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase411", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase411( UnitTestParameters const& params ) {
															#line 411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase411Actor(params));
															#line 4210 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase411, "/flow/flow/networked futures")

#line 446 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4216 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase447()
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase447Actor>
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase447ActorState {
															#line 4223 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase447ActorState(UnitTestParameters const& params) 
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4230 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase447", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase447ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase447", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 448 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Promise<int>> ps(5);
															#line 449 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<int>> fs;
															#line 450 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> qs;
															#line 451 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for( auto& p : ps ) {
															#line 452 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				fs.push_back(p.getFuture());
															#line 4253 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 454 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i <= ps.size();i++) {
															#line 455 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				qs.push_back(quorum(fs, i));
															#line 4259 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 457 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < ps.size();i++) {
															#line 458 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(qs[i].isReady());
															#line 459 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(!qs[i + 1].isReady());
															#line 460 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ps[i].send(i);
															#line 4269 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 462 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(qs[ps.size()].isReady());
															#line 463 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase447Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase447ActorState(); static_cast<FlowTestCase447Actor*>(this)->destroy(); return 0; }
															#line 4275 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase447Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase447ActorState();
			static_cast<FlowTestCase447Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase447ActorState();
		static_cast<FlowTestCase447Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4299 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase447()
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase447Actor final : public Actor<Void>, public FastAllocated<FlowTestCase447Actor>, public FlowTestCase447ActorState<FlowTestCase447Actor> {
															#line 4304 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase447Actor>::operator new;
	using FastAllocated<FlowTestCase447Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase447Actor(UnitTestParameters const& params) 
															#line 4314 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase447ActorState<FlowTestCase447Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase447", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase447");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase447", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase447( UnitTestParameters const& params ) {
															#line 447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase447Actor(params));
															#line 4341 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase447, "/flow/flow/quorum")

#line 465 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4347 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase466()
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase466Actor>
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase466ActorState {
															#line 4354 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase466ActorState(UnitTestParameters const& params) 
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase466", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase466ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase466", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 467 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> invalid;
															#line 468 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!invalid.isValid());
															#line 470 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> never = Never();
															#line 471 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(never.isValid() && !never.isReady());
															#line 473 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> one = 1;
															#line 474 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.isValid() && one.isReady() && !one.isError());
															#line 475 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.get() == 1);
															#line 476 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.getFutureReferenceCount() == 1);
															#line 477 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase466Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase466ActorState(); static_cast<FlowTestCase466Actor*>(this)->destroy(); return 0; }
															#line 4392 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase466Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase466ActorState();
			static_cast<FlowTestCase466Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase466ActorState();
		static_cast<FlowTestCase466Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4416 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase466()
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase466Actor final : public Actor<Void>, public FastAllocated<FlowTestCase466Actor>, public FlowTestCase466ActorState<FlowTestCase466Actor> {
															#line 4421 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase466Actor>::operator new;
	using FastAllocated<FlowTestCase466Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase466Actor(UnitTestParameters const& params) 
															#line 4431 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase466ActorState<FlowTestCase466Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase466", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase466");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase466", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase466( UnitTestParameters const& params ) {
															#line 466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase466Actor(params));
															#line 4458 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase466, "/flow/flow/trivial futures")

#line 479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4464 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase480()
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase480Actor>
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase480ActorState {
															#line 4471 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase480ActorState(UnitTestParameters const& params) 
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4478 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase480", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase480ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase480", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 481 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f;
															#line 483 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 484 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid());
															#line 485 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!p.isSet());
															#line 486 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(1);
															#line 487 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isSet());
															#line 488 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().get() == 1);
															#line 490 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p2;
															#line 491 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p2.getFuture();
															#line 492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && !f.isReady());
															#line 493 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(2);
															#line 494 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && !f.isError());
															#line 495 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 2);
															#line 497 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p3;
															#line 498 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p3.getFuture();
															#line 499 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.sendError(end_of_stream());
															#line 500 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 501 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_end_of_stream);
															#line 503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p4;
															#line 504 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p4.getFuture();
															#line 505 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p4 = Promise<int>();
															#line 506 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p4.isValid() && !p4.isSet());
															#line 507 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 508 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_broken_promise);
															#line 509 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase480Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase480ActorState(); static_cast<FlowTestCase480Actor*>(this)->destroy(); return 0; }
															#line 4541 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase480Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase480ActorState();
			static_cast<FlowTestCase480Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase480ActorState();
		static_cast<FlowTestCase480Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4565 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase480()
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase480Actor final : public Actor<Void>, public FastAllocated<FlowTestCase480Actor>, public FlowTestCase480ActorState<FlowTestCase480Actor> {
															#line 4570 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase480Actor>::operator new;
	using FastAllocated<FlowTestCase480Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase480Actor(UnitTestParameters const& params) 
															#line 4580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase480ActorState<FlowTestCase480Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase480", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase480");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase480", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase480( UnitTestParameters const& params ) {
															#line 480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase480Actor(params));
															#line 4607 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase480, "/flow/flow/trivial promises")

#line 511 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4613 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase512()
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase512Actor>
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase512ActorState {
															#line 4620 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase512ActorState(UnitTestParameters const& params) 
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4627 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase512", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase512ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase512", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 513 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<int> f;
															#line 515 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p;
															#line 516 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(1);
															#line 517 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().isReady());
															#line 518 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().pop() == 1);
															#line 520 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p2;
															#line 521 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p2.getFuture();
															#line 522 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && !f.isReady());
															#line 523 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(2);
															#line 524 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(3);
															#line 525 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && !f.isError());
															#line 526 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 2);
															#line 527 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 3);
															#line 529 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p3;
															#line 530 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p3.getFuture();
															#line 531 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.send(4);
															#line 532 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.sendError(end_of_stream());
															#line 533 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError());
															#line 534 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 4);
															#line 535 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isError());
															#line 536 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_end_of_stream);
															#line 538 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p4;
															#line 539 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p4.getFuture();
															#line 540 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p4 = PromiseStream<int>();
															#line 541 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_broken_promise);
															#line 543 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase512Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase512ActorState(); static_cast<FlowTestCase512Actor*>(this)->destroy(); return 0; }
															#line 4694 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase512Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase512ActorState();
			static_cast<FlowTestCase512Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase512ActorState();
		static_cast<FlowTestCase512Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4718 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase512()
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase512Actor final : public Actor<Void>, public FastAllocated<FlowTestCase512Actor>, public FlowTestCase512ActorState<FlowTestCase512Actor> {
															#line 4723 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase512Actor>::operator new;
	using FastAllocated<FlowTestCase512Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase512Actor(UnitTestParameters const& params) 
															#line 4733 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase512ActorState<FlowTestCase512Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase512", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase512");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase512", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase512( UnitTestParameters const& params ) {
															#line 512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase512Actor(params));
															#line 4760 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase512, "/flow/flow/trivial promisestreams")

#line 545 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4766 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase546()
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase546Actor>
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase546ActorState {
															#line 4773 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase546ActorState(UnitTestParameters const& params) 
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4780 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase546", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase546ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase546", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 547 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 548 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f = p.getFuture();
															#line 549 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 550 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			bool happened = false;
															#line 552 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(std::move(f), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 553 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&happened](int) { happened = true; }, [&happened](Error) { happened = true; });
															#line 554 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isValid());
															#line 555 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && !p.isSet() && p.getFutureReferenceCount() == 1);
															#line 556 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0 && !happened);
															#line 558 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(123);
															#line 559 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123 && happened);
															#line 560 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && p.isSet() && p.getFutureReferenceCount() == 0 && p.getFuture().get() == 123);
															#line 562 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 563 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 564 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123);
															#line 565 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && p.isSet() && p.getFutureReferenceCount() == 0 && p.getFuture().get() == 123);
															#line 567 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<int>();
															#line 568 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p.getFuture();
															#line 569 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 570 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(std::move(f), [&result](int x) { result = x; }, [&result](Error e) { result = -e.code(); });
															#line 571 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isValid());
															#line 572 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && !p.isSet() && p.getFutureReferenceCount() == 1);
															#line 573 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 575 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<int>();
															#line 576 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == -error_code_broken_promise);
															#line 577 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase546Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase546ActorState(); static_cast<FlowTestCase546Actor*>(this)->destroy(); return 0; }
															#line 4845 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase546Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase546ActorState();
			static_cast<FlowTestCase546Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase546ActorState();
		static_cast<FlowTestCase546Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4869 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase546()
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase546Actor final : public Actor<Void>, public FastAllocated<FlowTestCase546Actor>, public FlowTestCase546ActorState<FlowTestCase546Actor> {
															#line 4874 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase546Actor>::operator new;
	using FastAllocated<FlowTestCase546Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase546Actor(UnitTestParameters const& params) 
															#line 4884 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase546ActorState<FlowTestCase546Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase546", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase546");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase546", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase546( UnitTestParameters const& params ) {
															#line 546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase546Actor(params));
															#line 4911 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase546, "/flow/flow/callbacks")

#line 579 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4917 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase580()
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase580Actor>
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase580ActorState {
															#line 4924 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase580ActorState(UnitTestParameters const& params) 
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4931 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase580", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase580ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase580", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 581 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p;
															#line 583 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 585 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 587 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 589 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(123);
															#line 590 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(456);
															#line 592 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123);
															#line 593 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 595 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 597 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 456);
															#line 598 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 600 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 602 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 604 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = PromiseStream<int>();
															#line 606 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == -1);
															#line 607 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase580Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase580ActorState(); static_cast<FlowTestCase580Actor*>(this)->destroy(); return 0; }
															#line 4976 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase580Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase580ActorState();
			static_cast<FlowTestCase580Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase580ActorState();
		static_cast<FlowTestCase580Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5000 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase580()
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase580Actor final : public Actor<Void>, public FastAllocated<FlowTestCase580Actor>, public FlowTestCase580ActorState<FlowTestCase580Actor> {
															#line 5005 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase580Actor>::operator new;
	using FastAllocated<FlowTestCase580Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase580Actor(UnitTestParameters const& params) 
															#line 5015 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase580ActorState<FlowTestCase580Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase580", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase580");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase580", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase580( UnitTestParameters const& params ) {
															#line 580 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase580Actor(params));
															#line 5042 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase580, "/flow/flow/promisestream callbacks")

#line 609 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Incompatible with --crash, so we are commenting it out for now
/*
TEST_CASE("/flow/flow/promisestream multiple wait error")
{
    state int result = 0;
    state PromiseStream<int> p;
    try {
        onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e){ result = -1; });
        result = 100;
        onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e){ result = -1; });
        ASSERT(false);
    }
    catch (Error& e) {
        ASSERT(e.code() == error_code_internal_error);
    }
    ASSERT(result == 100);
    p = PromiseStream<int>();
    ASSERT(result == -1);
    return Void();
}
*/

															#line 5070 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase632()
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase632Actor>
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase632ActorState {
															#line 5077 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase632ActorState(UnitTestParameters const& params) 
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5084 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase632", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase632ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase632", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 633 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 635 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 636 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			trivialVoidActor(&result);
															#line 637 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 1);
															#line 638 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 640 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f = return42Actor();
															#line 641 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError() && f.get() == 42 && f.getFutureReferenceCount() == 1 && f.getPromiseReferenceCount() == 0);
															#line 643 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 644 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 645 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 647 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = templateActor(24);
															#line 648 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError() && f.get() == 24 && f.getFutureReferenceCount() == 1 && f.getPromiseReferenceCount() == 0);
															#line 650 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 651 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 652 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 654 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 655 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			voidWaitActor(2, &result);
															#line 656 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 2 && expectActorCount(0));
															#line 658 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 659 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = addOneActor(p.getFuture());
															#line 660 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isReady() && expectActorCount(1));
															#line 661 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(100);
															#line 662 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && f.get() == 101);
															#line 663 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 664 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 665 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 667 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> ps;
															#line 668 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = consumeOneActor(ps.getFuture());
															#line 669 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isReady() && expectActorCount(1));
															#line 670 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(101);
															#line 671 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 101 && ps.isEmpty());
															#line 672 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(102);
															#line 673 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ps.isEmpty());
															#line 674 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = consumeOneActor(ps.getFuture());
															#line 675 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 102 && ps.isEmpty());
															#line 677 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = sumActor(ps.getFuture());
															#line 678 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(1);
															#line 679 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(10);
															#line 680 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(100);
															#line 681 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.sendError(end_of_stream());
															#line 682 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 111);
															#line 684 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(testHygeine().isReady());
															#line 685 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase632Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase632ActorState(); static_cast<FlowTestCase632Actor*>(this)->destroy(); return 0; }
															#line 5183 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase632Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase632ActorState();
			static_cast<FlowTestCase632Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase632ActorState();
		static_cast<FlowTestCase632Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5207 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase632()
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase632Actor final : public Actor<Void>, public FastAllocated<FlowTestCase632Actor>, public FlowTestCase632ActorState<FlowTestCase632Actor> {
															#line 5212 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase632Actor>::operator new;
	using FastAllocated<FlowTestCase632Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase632Actor(UnitTestParameters const& params) 
															#line 5222 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase632ActorState<FlowTestCase632Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase632", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase632");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase632", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase632( UnitTestParameters const& params ) {
															#line 632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase632Actor(params));
															#line 5249 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase632, "/flow/flow/trivial actors")

#line 687 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5255 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase688()
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase688Actor>
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase688ActorState {
															#line 5262 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase688ActorState(UnitTestParameters const& params) 
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5269 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase688", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase688ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase688", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 692 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 694 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yn->nextYield = 0;
															#line 696 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 697 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> u = p.getFuture();
															#line 698 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> i = success(u);
															#line 700 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> v;
															#line 701 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 702 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				v.push_back(yieldedFuture(u));
															#line 5298 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 703 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto numReady = [&v]() { return std::count_if(v.begin(), v.end(), [](Future<Void> v) { return v.isReady(); }); };
															#line 705 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(numReady() == 0);
															#line 706 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(Void());
															#line 707 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(u.isReady() && i.isReady() && numReady() == 0);
															#line 709 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 710 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yn->tick();
															#line 711 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(numReady() == i + 1);
															#line 5314 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 714 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 715 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(v[i].getPromiseReferenceCount() == 0 && v[i].getFutureReferenceCount() == 1);
															#line 5320 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 718 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase688Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase688ActorState(); static_cast<FlowTestCase688Actor*>(this)->destroy(); return 0; }
															#line 5324 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase688Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase688ActorState();
			static_cast<FlowTestCase688Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase688ActorState();
		static_cast<FlowTestCase688Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5348 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase688()
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase688Actor final : public Actor<Void>, public FastAllocated<FlowTestCase688Actor>, public FlowTestCase688ActorState<FlowTestCase688Actor> {
															#line 5353 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase688Actor>::operator new;
	using FastAllocated<FlowTestCase688Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase688Actor(UnitTestParameters const& params) 
															#line 5363 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase688ActorState<FlowTestCase688Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase688", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase688");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase688", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase688( UnitTestParameters const& params ) {
															#line 688 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase688Actor(params));
															#line 5390 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase688, "/flow/flow/yieldedFuture/progress")

#line 720 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5396 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase721()
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase721Actor>
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase721ActorState {
															#line 5403 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase721ActorState(UnitTestParameters const& params) 
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5410 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase721", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase721ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase721", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 724 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 726 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int r = 0;r < 100;r++) {
															#line 727 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Promise<Void> p;
															#line 728 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> u = p.getFuture();
															#line 729 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> i = success(u);
															#line 731 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> v;
															#line 732 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < 25;i++) {
															#line 733 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					v.push_back(yieldedFuture(u));
															#line 5439 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 734 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				auto numReady = [&v]() { return std::count_if(v.begin(), v.end(), [](Future<Void> v) { return v.isReady(); }); };
															#line 738 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> j = success(u);
															#line 740 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(numReady() == 0);
															#line 742 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				int expectYield = deterministicRandom()->randomInt(0, 4);
															#line 743 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				int expectReady = expectYield;
															#line 744 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yn->nextYield = 1 + expectYield;
															#line 746 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				p.send(Void());
															#line 747 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(u.isReady() && i.isReady() && j.isReady() && numReady() == expectReady);
															#line 749 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(;numReady() != v.size();) {
															#line 750 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					expectYield = deterministicRandom()->randomInt(0, 4);
															#line 751 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					yn->nextYield = 1 + expectYield;
															#line 752 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					expectReady += 1 + expectYield;
															#line 753 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					yn->tick();
															#line 756 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(numReady() == std::min<int>(expectReady, v.size()));
															#line 5469 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 759 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < v.size();i++) {
															#line 760 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(v[i].getPromiseReferenceCount() == 0 && v[i].getFutureReferenceCount() == 1);
															#line 5475 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
			}
															#line 764 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase721Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase721ActorState(); static_cast<FlowTestCase721Actor*>(this)->destroy(); return 0; }
															#line 5480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase721Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase721ActorState();
			static_cast<FlowTestCase721Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase721ActorState();
		static_cast<FlowTestCase721Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5504 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase721()
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase721Actor final : public Actor<Void>, public FastAllocated<FlowTestCase721Actor>, public FlowTestCase721ActorState<FlowTestCase721Actor> {
															#line 5509 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase721Actor>::operator new;
	using FastAllocated<FlowTestCase721Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase721Actor(UnitTestParameters const& params) 
															#line 5519 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase721ActorState<FlowTestCase721Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase721", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase721");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase721", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase721( UnitTestParameters const& params ) {
															#line 721 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase721Actor(params));
															#line 5546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase721, "/flow/flow/yieldedFuture/random")

#line 766 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5552 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase767()
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase767Actor>
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase767ActorState {
															#line 5559 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase767ActorState(UnitTestParameters const& params) 
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5566 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase767", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase767ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase767", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 768 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			double start;
															#line 769 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int N = 1000000;
															#line 771 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 773 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yn->nextYield = 2 * N + 100;
															#line 775 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 776 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> f = p.getFuture();
															#line 777 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> ys;
															#line 779 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 780 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 781 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ys.push_back(yieldedFuture(f));
															#line 5599 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 782 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) create: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 783 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(Void());
															#line 784 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) total: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 786 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for( auto& y : ys ) {
															#line 787 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(y.isReady());
															#line 5611 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 789 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<Void>();
															#line 790 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p.getFuture();
															#line 792 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 793 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 794 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yieldedFuture(f);
															#line 5623 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 795 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) cancel: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 797 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase767Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase767ActorState(); static_cast<FlowTestCase767Actor*>(this)->destroy(); return 0; }
															#line 5629 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase767Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase767ActorState();
			static_cast<FlowTestCase767Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase767ActorState();
		static_cast<FlowTestCase767Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5653 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase767()
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase767Actor final : public Actor<Void>, public FastAllocated<FlowTestCase767Actor>, public FlowTestCase767ActorState<FlowTestCase767Actor> {
															#line 5658 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase767Actor>::operator new;
	using FastAllocated<FlowTestCase767Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase767Actor(UnitTestParameters const& params) 
															#line 5668 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase767ActorState<FlowTestCase767Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase767");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase767( UnitTestParameters const& params ) {
															#line 767 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase767Actor(params));
															#line 5695 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase767, "/flow/perf/yieldedFuture")

#line 799 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5701 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase800()
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase800Actor>
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase800ActorState {
															#line 5708 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase800ActorState(UnitTestParameters const& params) 
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5715 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase800", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase800ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase800", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 801 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 803 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> a, b;
															#line 804 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> c = chooseTwoActor(a.getFuture(), b.getFuture());
															#line 805 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 2 && b.getFutureReferenceCount() == 2 && !c.isReady());
															#line 806 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			b.send(Void());
															#line 807 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 0 && b.getFutureReferenceCount() == 0 && c.isReady() && !c.isError() && expectActorCount(1));
															#line 809 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			c = Future<Void>();
															#line 810 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 0 && b.getFutureReferenceCount() == 0 && expectActorCount(0));
															#line 811 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase800Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase800ActorState(); static_cast<FlowTestCase800Actor*>(this)->destroy(); return 0; }
															#line 5746 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase800Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase800ActorState();
			static_cast<FlowTestCase800Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase800ActorState();
		static_cast<FlowTestCase800Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5770 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase800()
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase800Actor final : public Actor<Void>, public FastAllocated<FlowTestCase800Actor>, public FlowTestCase800ActorState<FlowTestCase800Actor> {
															#line 5775 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase800Actor>::operator new;
	using FastAllocated<FlowTestCase800Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase800Actor(UnitTestParameters const& params) 
															#line 5785 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase800ActorState<FlowTestCase800Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase800", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase800");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase800", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase800( UnitTestParameters const& params ) {
															#line 800 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase800Actor(params));
															#line 5812 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase800, "/flow/flow/chooseTwoActor")

#line 813 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5818 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase814()
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase814Actor>
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase814ActorState {
															#line 5825 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase814ActorState(UnitTestParameters const& params) 
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5832 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase814", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase814ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase814", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 815 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			double start;
															#line 816 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int N = 1000000;
															#line 818 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 820 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 821 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 822 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				emptyVoidActor();
															#line 5857 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 823 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("emptyVoidActor(): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 825 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 827 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 828 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 829 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				emptyActor();
															#line 5869 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 831 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("emptyActor(): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 833 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 835 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> neverSet;
															#line 836 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> never = neverSet.getFuture();
															#line 837 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> already = Void();
															#line 839 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 840 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 841 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				oneWaitVoidActor(already);
															#line 5887 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 842 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("oneWaitVoidActor(already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 844 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 5893 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 852 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 853 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 854 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(already);
															#line 855 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 5903 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 857 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 5907 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 861 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 862 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 863 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(never);
															#line 864 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(!f.isReady());
															#line 5918 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 866 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("(cancelled) oneWaitActor(never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 867 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(expectActorCount(0));
															#line 5924 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 871 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 872 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 873 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 874 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(p.getFuture());
															#line 875 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 876 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 5939 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 878 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(after): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 5943 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 882 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 883 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 884 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 885 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 886 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(pipe[i].getFuture());
															#line 5956 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 888 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 889 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 890 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 5964 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 892 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(fifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 5968 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 896 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 897 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 898 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 899 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 900 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(pipe[i].getFuture());
															#line 5981 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 902 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = N - 1;i >= 0;i--) {
															#line 903 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 904 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 5989 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 906 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(lifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 5993 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 910 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 911 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 912 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(already, already);
															#line 913 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6004 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 915 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(already, already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6008 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 919 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 920 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 921 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(already, never);
															#line 922 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6019 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 924 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(already, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6023 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 928 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 929 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 930 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(never, already);
															#line 931 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6034 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 933 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(never, already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6038 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 937 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 938 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 939 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(never, never);
															#line 940 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(!f.isReady());
															#line 6049 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 943 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("(cancelled) chooseTwoActor(never, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6053 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 947 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 948 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 949 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 950 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(p.getFuture(), never);
															#line 951 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 952 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6068 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 954 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(after, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6072 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 958 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 959 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 960 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 961 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 962 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(pipe[i].getFuture(), never);
															#line 6085 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 964 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 965 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 966 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6093 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 968 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(fifo, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6097 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 972 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 973 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 974 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 975 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 976 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(pipe[i].getFuture(), pipe[i].getFuture());
															#line 6110 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 978 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 979 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 980 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6118 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 982 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(fifo, fifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6122 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 986 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 987 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 988 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 989 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 990 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(chooseTwoActor(pipe[i].getFuture(), never), never);
															#line 6135 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 992 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 993 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 994 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6143 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 996 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor^2((fifo, never), never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6147 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1000 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1001 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1002 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 1003 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(chooseTwoActor(p.getFuture(), never));
															#line 1004 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 1005 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6162 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1007 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(chooseTwoActor(after, never)): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6166 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1011 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1012 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 1013 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1014 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1015 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(chooseTwoActor(pipe[i].getFuture(), never));
															#line 6179 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1017 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1018 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1019 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6187 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1021 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(chooseTwoActor(fifo, never)): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6191 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1025 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1026 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1027 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 1028 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(p.getFuture(), never);
															#line 1029 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> a = oneWaitActor(f);
															#line 1030 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> b = oneWaitActor(f);
															#line 1031 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 1032 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6210 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1034 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(after, never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6214 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1038 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1039 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1040 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1041 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1042 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1043 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(pipe[i].getFuture(), never);
															#line 1044 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = oneWaitActor(f);
															#line 1045 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = oneWaitActor(f);
															#line 6233 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1047 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1048 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1049 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6241 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1051 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(fifo, never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6245 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1055 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1056 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1057 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1058 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1059 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1060 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(oneWaitActor(pipe[i].getFuture()), never);
															#line 1061 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = oneWaitActor(f);
															#line 1062 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = oneWaitActor(f);
															#line 6264 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1064 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1065 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1066 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6272 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1068 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(oneWaitActor(fifo), never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6276 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1072 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1073 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1074 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1075 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1076 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1077 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					g_cheese = pipe[i].getFuture();
															#line 1078 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(cheeseWaitActor(), never);
															#line 1079 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					g_cheese = f;
															#line 1080 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = cheeseWaitActor();
															#line 1081 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = cheeseWaitActor();
															#line 6299 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1083 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1084 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1085 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6307 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1087 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xcheeseActor(chooseTwoActor(cheeseActor(fifo), never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 1088 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("sizeof(CheeseWaitActorActor) == %zu\n", cheeseWaitActorSize());
															#line 6313 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1092 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				PromiseStream<int> data;
															#line 1093 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1094 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<int> sum = sumActor(data.getFuture());
															#line 1095 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1096 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					data.send(1);
															#line 6326 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1097 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				data.sendError(end_of_stream());
															#line 1098 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(sum.get() == N);
															#line 1099 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("sumActor: %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6334 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1103 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1104 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> ps(3);
															#line 1105 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> fs(3);
															#line 1107 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1108 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ps.clear();
															#line 1109 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ps.resize(3);
															#line 1110 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					for(int j = 0;j < ps.size();j++) {
															#line 1111 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
						fs[j] = ps[j].getFuture();
															#line 6353 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
					}
															#line 1113 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> q = quorum(fs, 2);
															#line 1114 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					for( auto& p : ps ) {
															#line 1115 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
						p.send(Void());
															#line 6361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
					}
				}
															#line 1117 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("quorum(2/3): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6366 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1120 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase814Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase814ActorState(); static_cast<FlowTestCase814Actor*>(this)->destroy(); return 0; }
															#line 6370 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase814Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase814ActorState();
			static_cast<FlowTestCase814Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase814ActorState();
		static_cast<FlowTestCase814Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6394 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase814()
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase814Actor final : public Actor<Void>, public FastAllocated<FlowTestCase814Actor>, public FlowTestCase814ActorState<FlowTestCase814Actor> {
															#line 6399 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase814Actor>::operator new;
	using FastAllocated<FlowTestCase814Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase814Actor(UnitTestParameters const& params) 
															#line 6409 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase814ActorState<FlowTestCase814Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase814");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase814( UnitTestParameters const& params ) {
															#line 814 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase814Actor(params));
															#line 6436 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase814, "#flow/flow/perf/actor patterns")

#line 1122 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

template <class YAM>
struct YAMRandom {
	YAM yam;
	std::vector<Future<Void>> onchanges;
	int kmax;

	YAMRandom() : kmax(3) {}

	void randomOp() {
		if (deterministicRandom()->random01() < 0.01)
			while (!check_yield())
				;

		int k = deterministicRandom()->randomInt(0, kmax);
		int op = deterministicRandom()->randomInt(0, 7);
		// printf("%d",op);
		if (op == 0) {
			onchanges.push_back(yam.onChange(k));
		} else if (op == 1) {
			onchanges.push_back(trigger([this]() { this->randomOp(); }, yam.onChange(k)));
		} else if (op == 2) {
			if (onchanges.size()) {
				int i = deterministicRandom()->randomInt(0, onchanges.size());
				onchanges[i] = onchanges.back();
				onchanges.pop_back();
			}
		} else if (op == 3) {
			onchanges.clear();
		} else if (op == 4) {
			int v = deterministicRandom()->randomInt(0, 3);
			yam.set(k, v);
		} else if (op == 5) {
			yam.trigger(k);
		} else if (op == 6) {
			int a = deterministicRandom()->randomInt(0, kmax);
			int b = deterministicRandom()->randomInt(0, kmax);
			yam.triggerRange(std::min(a, b), std::max(a, b) + 1);
		}
	}
};

															#line 6483 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1164()
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1164Actor>
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1164ActorState {
															#line 6490 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1164ActorState(UnitTestParameters const& params) 
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1165 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yamr(),
															#line 1166 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   it()
															#line 6501 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1164", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1164ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1164", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1167 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			it = 0;
															#line 6516 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1164ActorState();
		static_cast<FlowTestCase1164Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1171 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1164Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1164ActorState(); static_cast<FlowTestCase1164Actor*>(this)->destroy(); return 0; }
															#line 6539 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1164Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1164ActorState();
		static_cast<FlowTestCase1164Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1167 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(it < 100000))
															#line 6558 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1168 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		yamr.randomOp();
															#line 1169 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1169 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1164Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6568 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase1164Actor*>(this)->actor_wait_state = 1;
															#line 1169 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1164Actor, 0, Void >*>(static_cast<FlowTestCase1164Actor*>(this)));
															#line 6573 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1167 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 6595 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1167 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 6604 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1164Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1164Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1164Actor*>(this)->ActorCallback< FlowTestCase1164Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1164Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1164", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1164", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1164Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1164", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1164", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1164Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1164", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1164", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1165 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YAMRandom<YieldedAsyncMap<int, int>> yamr;
															#line 1166 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int it;
															#line 6678 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1164()
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1164Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1164Actor, 0, Void >, public FastAllocated<FlowTestCase1164Actor>, public FlowTestCase1164ActorState<FlowTestCase1164Actor> {
															#line 6683 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1164Actor>::operator new;
	using FastAllocated<FlowTestCase1164Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1164Actor, 0, Void >;
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1164Actor(UnitTestParameters const& params) 
															#line 6694 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1164ActorState<FlowTestCase1164Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1164", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1164");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1164", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1164Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1164( UnitTestParameters const& params ) {
															#line 1164 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1164Actor(params));
															#line 6722 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1164, "/flow/flow/YieldedAsyncMap/randomized")

#line 1173 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6728 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1174()
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1174Actor>
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1174ActorState {
															#line 6735 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1174ActorState(UnitTestParameters const& params) 
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1175 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yamr(),
															#line 1176 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   it()
															#line 6746 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1174", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1174ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1174", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1177 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			it = 0;
															#line 6761 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1174ActorState();
		static_cast<FlowTestCase1174Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1181 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1174Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1174ActorState(); static_cast<FlowTestCase1174Actor*>(this)->destroy(); return 0; }
															#line 6784 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1174Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1174ActorState();
		static_cast<FlowTestCase1174Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1177 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(it < 100000))
															#line 6803 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1178 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		yamr.randomOp();
															#line 1179 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1179 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1174Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6813 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase1174Actor*>(this)->actor_wait_state = 1;
															#line 1179 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1174Actor, 0, Void >*>(static_cast<FlowTestCase1174Actor*>(this)));
															#line 6818 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1177 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 6840 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1177 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 6849 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1174Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1174Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1174Actor*>(this)->ActorCallback< FlowTestCase1174Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1174Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1174", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1174", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1174Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1174", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1174", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1174Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1174", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1174", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1175 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YAMRandom<AsyncMap<int, int>> yamr;
															#line 1176 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int it;
															#line 6923 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1174()
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1174Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1174Actor, 0, Void >, public FastAllocated<FlowTestCase1174Actor>, public FlowTestCase1174ActorState<FlowTestCase1174Actor> {
															#line 6928 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1174Actor>::operator new;
	using FastAllocated<FlowTestCase1174Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1174Actor, 0, Void >;
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1174Actor(UnitTestParameters const& params) 
															#line 6939 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1174ActorState<FlowTestCase1174Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1174", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1174");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1174", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1174Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1174( UnitTestParameters const& params ) {
															#line 1174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1174Actor(params));
															#line 6967 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1174, "/flow/flow/AsyncMap/randomized")

#line 1183 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6973 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1184()
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1184Actor>
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1184ActorState {
															#line 6980 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1184ActorState(UnitTestParameters const& params) 
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1185 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam(),
															#line 1186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y0(yam.onChange(1))
															#line 6991 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1184", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1184ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1184", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1187 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yam.setUnconditional(1, 0);
															#line 1188 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1 = yam.onChange(1);
															#line 1189 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a = yam.onChange(1);
															#line 1190 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b = yam.onChange(1);
															#line 1191 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yam.set(1, 1);
															#line 1195 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y2 = yam.onChange(1);
															#line 1196 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = reportErrors(y0, "Y0");
															#line 1196 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7020 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 1;
															#line 1196 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 0, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7025 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1184ActorState();
		static_cast<FlowTestCase1184Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1197 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = reportErrors(y1, "Y1");
															#line 1197 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7050 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 2;
															#line 1197 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 1, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7055 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1197 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = reportErrors(y1, "Y1");
															#line 1197 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7066 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 2;
															#line 1197 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 1, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7071 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1184Actor*>(this)->ActorCallback< FlowTestCase1184Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1184Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1198 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reportErrors(y1a, "Y1a");
															#line 1198 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7145 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 3;
															#line 1198 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 2, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7150 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1198 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reportErrors(y1a, "Y1a");
															#line 1198 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7161 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 3;
															#line 1198 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 2, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7166 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1184Actor*>(this)->ActorCallback< FlowTestCase1184Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1184Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1199 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = reportErrors(y1b, "Y1b");
															#line 1199 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7240 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 4;
															#line 1199 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 3, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7245 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1199 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = reportErrors(y1b, "Y1b");
															#line 1199 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7256 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 4;
															#line 1199 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 3, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7261 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1184Actor*>(this)->ActorCallback< FlowTestCase1184Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1184Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = reportErrors(timeout(y2, 5, Void()), "Y2");
															#line 1200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7335 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 5;
															#line 1200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 4, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7340 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = reportErrors(timeout(y2, 5, Void()), "Y2");
															#line 1200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7351 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 5;
															#line 1200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1184Actor, 4, Void >*>(static_cast<FlowTestCase1184Actor*>(this)));
															#line 7356 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1184Actor*>(this)->ActorCallback< FlowTestCase1184Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase1184Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1202 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1184Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1184ActorState(); static_cast<FlowTestCase1184Actor*>(this)->destroy(); return 0; }
															#line 7428 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1184Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1184ActorState();
		static_cast<FlowTestCase1184Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1202 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1184Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1184ActorState(); static_cast<FlowTestCase1184Actor*>(this)->destroy(); return 0; }
															#line 7440 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1184Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1184ActorState();
		static_cast<FlowTestCase1184Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1184Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1184Actor*>(this)->ActorCallback< FlowTestCase1184Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1184Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase1184Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1185 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y0;
															#line 1188 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1189 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1a;
															#line 1190 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1b;
															#line 1195 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y2;
															#line 7525 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1184()
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1184Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1184Actor, 0, Void >, public ActorCallback< FlowTestCase1184Actor, 1, Void >, public ActorCallback< FlowTestCase1184Actor, 2, Void >, public ActorCallback< FlowTestCase1184Actor, 3, Void >, public ActorCallback< FlowTestCase1184Actor, 4, Void >, public FastAllocated<FlowTestCase1184Actor>, public FlowTestCase1184ActorState<FlowTestCase1184Actor> {
															#line 7530 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1184Actor>::operator new;
	using FastAllocated<FlowTestCase1184Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1184Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1184Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase1184Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase1184Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase1184Actor, 4, Void >;
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1184Actor(UnitTestParameters const& params) 
															#line 7545 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1184ActorState<FlowTestCase1184Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1184", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1184");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1184", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1184Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1184Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1184Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase1184Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase1184Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1184( UnitTestParameters const& params ) {
															#line 1184 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1184Actor(params));
															#line 7577 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1184, "/flow/flow/YieldedAsyncMap/basic")

#line 1204 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 7583 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1205()
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1205Actor>
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1205ActorState {
															#line 7590 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1205ActorState(UnitTestParameters const& params) 
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1206 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam()
															#line 7599 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1205", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1205ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1205", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1212 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 0);
															#line 1213 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1 = yam.onChange(1);
															#line 1214 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a = yam.onChange(1);
															#line 1215 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b = yam.onChange(1);
															#line 1216 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 1);
															#line 1217 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1.cancel();
															#line 1218 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!y1a.isReady());
															#line 1219 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a.cancel();
															#line 1220 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!y1b.isReady());
															#line 1221 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 1);
															#line 1222 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b.cancel();
															#line 1223 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(y1b.getError().code() == error_code_actor_cancelled);
															#line 1224 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 0);
															#line 1226 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1205Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1205ActorState(); static_cast<FlowTestCase1205Actor*>(this)->destroy(); return 0; }
															#line 7640 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1205Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1205ActorState();
			static_cast<FlowTestCase1205Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1205ActorState();
		static_cast<FlowTestCase1205Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1206 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1213 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1214 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1a;
															#line 1215 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1b;
															#line 7672 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1205()
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1205Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1205Actor>, public FlowTestCase1205ActorState<FlowTestCase1205Actor> {
															#line 7677 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1205Actor>::operator new;
	using FastAllocated<FlowTestCase1205Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1205Actor(UnitTestParameters const& params) 
															#line 7687 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1205ActorState<FlowTestCase1205Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1205", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1205");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1205", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1205( UnitTestParameters const& params ) {
															#line 1205 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1205Actor(params));
															#line 7714 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1205, "/flow/flow/YieldedAsyncMap/cancel")

#line 1228 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 7720 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1229()
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1229Actor>
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1229ActorState {
															#line 7727 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1229ActorState(UnitTestParameters const& params) 
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1230 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam(),
															#line 1232 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y1(yam.onChange(1)),
															#line 1233 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y2(yam.onChange(2))
															#line 7740 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1229", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1229ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1229", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1235 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto* pyam = &yam;
															#line 1236 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			uncancellable(trigger( [pyam]() { printf("Triggered\n"); pyam->triggerAll(); }, delay(1)));
															#line 1243 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = y1;
															#line 1243 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1229Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7761 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1229Actor*>(this)->actor_wait_state = 1;
															#line 1243 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1229Actor, 0, Void >*>(static_cast<FlowTestCase1229Actor*>(this)));
															#line 7766 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1229ActorState();
		static_cast<FlowTestCase1229Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1244 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		printf("Got y1\n");
															#line 1245 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		y2.cancel();
															#line 1247 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1229Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1229ActorState(); static_cast<FlowTestCase1229Actor*>(this)->destroy(); return 0; }
															#line 7793 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1229Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1229ActorState();
		static_cast<FlowTestCase1229Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1244 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		printf("Got y1\n");
															#line 1245 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		y2.cancel();
															#line 1247 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1229Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1229ActorState(); static_cast<FlowTestCase1229Actor*>(this)->destroy(); return 0; }
															#line 7809 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1229Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1229ActorState();
		static_cast<FlowTestCase1229Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1229Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1229Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1229Actor*>(this)->ActorCallback< FlowTestCase1229Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1229Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1229", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1229", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1229Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1229", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1229", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1229Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1229", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1229", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1230 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1232 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1233 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y2;
															#line 7888 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1229()
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1229Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1229Actor, 0, Void >, public FastAllocated<FlowTestCase1229Actor>, public FlowTestCase1229ActorState<FlowTestCase1229Actor> {
															#line 7893 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1229Actor>::operator new;
	using FastAllocated<FlowTestCase1229Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1229Actor, 0, Void >;
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1229Actor(UnitTestParameters const& params) 
															#line 7904 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1229ActorState<FlowTestCase1229Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1229", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1229");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1229", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1229Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1229( UnitTestParameters const& params ) {
															#line 1229 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1229Actor(params));
															#line 7932 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1229, "/flow/flow/YieldedAsyncMap/cancel2")

#line 1249 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 7938 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1250()
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1250Actor>
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1250ActorState {
															#line 7945 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1250ActorState(UnitTestParameters const& params) 
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 7952 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1250", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1250ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1250", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1251 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			AsyncVar<int> av;
															#line 1252 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> ch = av.onChange();
															#line 1253 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ch.isReady());
															#line 1254 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			av.set(5);
															#line 1255 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(ch.isReady());
															#line 1256 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(av.get() == 5);
															#line 1258 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ch = av.onChange();
															#line 1259 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ch.isReady());
															#line 1260 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			av.set(6);
															#line 1261 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(ch.isReady());
															#line 1262 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(av.get() == 6);
															#line 1264 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1250Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1250ActorState(); static_cast<FlowTestCase1250Actor*>(this)->destroy(); return 0; }
															#line 7989 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1250Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1250ActorState();
			static_cast<FlowTestCase1250Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1250ActorState();
		static_cast<FlowTestCase1250Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 8013 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1250()
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1250Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1250Actor>, public FlowTestCase1250ActorState<FlowTestCase1250Actor> {
															#line 8018 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1250Actor>::operator new;
	using FastAllocated<FlowTestCase1250Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1250Actor(UnitTestParameters const& params) 
															#line 8028 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1250ActorState<FlowTestCase1250Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1250", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1250");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1250", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1250( UnitTestParameters const& params ) {
															#line 1250 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1250Actor(params));
															#line 8055 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1250, "/flow/flow/AsyncVar/basic")

#line 1266 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8061 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via waitAfterCancel()
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class WaitAfterCancelActor>
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class WaitAfterCancelActorState {
															#line 8068 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	WaitAfterCancelActorState(int* const& output) 
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : output(output)
															#line 8075 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAfterCancel", reinterpret_cast<unsigned long>(this));

	}
	~WaitAfterCancelActorState() 
	{
		fdb_probe_actor_destroy("waitAfterCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1268 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*output = 0;
															#line 8090 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			try {
															#line 1270 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Never();
															#line 1270 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8096 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 1;
															#line 1270 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAfterCancelActor, 0, Void >*>(static_cast<WaitAfterCancelActor*>(this)));
															#line 8101 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAfterCancelActorState();
		static_cast<WaitAfterCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1274 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 1275 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<WaitAfterCancelActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitAfterCancelActorState(); static_cast<WaitAfterCancelActor*>(this)->destroy(); return 0; }
															#line 8132 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<WaitAfterCancelActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitAfterCancelActorState();
		static_cast<WaitAfterCancelActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1272 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = (*output = 1, Future<Void>(Void()));
															#line 1272 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8147 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 2;
															#line 1272 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAfterCancelActor, 1, Void >*>(static_cast<WaitAfterCancelActor*>(this)));
															#line 8152 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state > 0) static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAfterCancelActor*>(this)->ActorCallback< WaitAfterCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAfterCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state > 0) static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAfterCancelActor*>(this)->ActorCallback< WaitAfterCancelActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitAfterCancelActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* output;
															#line 8328 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via waitAfterCancel()
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class WaitAfterCancelActor final : public Actor<Void>, public ActorCallback< WaitAfterCancelActor, 0, Void >, public ActorCallback< WaitAfterCancelActor, 1, Void >, public FastAllocated<WaitAfterCancelActor>, public WaitAfterCancelActorState<WaitAfterCancelActor> {
															#line 8333 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<WaitAfterCancelActor>::operator new;
	using FastAllocated<WaitAfterCancelActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAfterCancelActor, 0, Void >;
friend struct ActorCallback< WaitAfterCancelActor, 1, Void >;
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	WaitAfterCancelActor(int* const& output) 
															#line 8345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   WaitAfterCancelActorState<WaitAfterCancelActor>(output)
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAfterCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAfterCancelActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitAfterCancelActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> waitAfterCancel( int* const& output ) {
															#line 1267 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new WaitAfterCancelActor(output));
															#line 8374 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1277 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8379 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1278()
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1278Actor>
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1278ActorState {
															#line 8386 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1278ActorState(UnitTestParameters const& params) 
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 8393 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1278", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1278ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1278", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1279 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int a = -1;
															#line 1280 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> f = waitAfterCancel(&a);
															#line 1281 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a == 0);
															#line 1282 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f.cancel();
															#line 1283 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a == 1);
															#line 1284 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1278Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1278ActorState(); static_cast<FlowTestCase1278Actor*>(this)->destroy(); return 0; }
															#line 8418 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1278Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1278ActorState();
			static_cast<FlowTestCase1278Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1278ActorState();
		static_cast<FlowTestCase1278Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 8442 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1278()
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1278Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1278Actor>, public FlowTestCase1278ActorState<FlowTestCase1278Actor> {
															#line 8447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1278Actor>::operator new;
	using FastAllocated<FlowTestCase1278Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1278Actor(UnitTestParameters const& params) 
															#line 8457 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1278ActorState<FlowTestCase1278Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1278", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1278");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1278", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1278( UnitTestParameters const& params ) {
															#line 1278 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1278Actor(params));
															#line 8484 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1278, "/fdbrpc/flow/wait_expression_after_cancel")

#line 1286 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Tests for https://github.com/apple/foundationdb/issues/1226

template <class>
struct ShouldNotGoIntoClassContextStack;

class Foo1 {
public:
	explicit Foo1(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 8499 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo1* const& self );
template <class> friend class Foo1_FooActorActorState;

#line 1297 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 8508 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo1_FooActorActor>
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo1_FooActorActorState {
															#line 8514 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1_FooActorActorState(Foo1* const& self) 
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 8521 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo1_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1302 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1302 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo1_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8538 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo1_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1302 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo1_FooActorActor, 0, Void >*>(static_cast<Foo1_FooActorActor*>(this)));
															#line 8543 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo1_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo1_FooActorActorState(); static_cast<Foo1_FooActorActor*>(this)->destroy(); return 0; }
															#line 8566 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo1_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1303 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo1_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo1_FooActorActorState(); static_cast<Foo1_FooActorActor*>(this)->destroy(); return 0; }
															#line 8578 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo1_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo1_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo1_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo1_FooActorActor*>(this)->ActorCallback< Foo1_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo1_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo1_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo1_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1* self;
															#line 8651 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo1_FooActorActor final : public Actor<int>, public ActorCallback< Foo1_FooActorActor, 0, Void >, public FastAllocated<Foo1_FooActorActor>, public Foo1_FooActorActorState<Foo1_FooActorActor> {
															#line 8656 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo1_FooActorActor>::operator new;
	using FastAllocated<Foo1_FooActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo1_FooActorActor, 0, Void >;
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1_FooActorActor(Foo1* const& self) 
															#line 8667 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo1_FooActorActorState<Foo1_FooActorActor>(self)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo1_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo1::fooActor( Foo1* const& self ) {
															#line 1301 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo1_FooActorActor(self));
															#line 8694 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1305 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

class [[nodiscard]] Foo2 {
public:
	explicit Foo2(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 8703 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo2* const& self );
template <class> friend class Foo2_FooActorActorState;

#line 1311 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 8712 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo2_FooActorActor>
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo2_FooActorActorState {
															#line 8718 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2_FooActorActorState(Foo2* const& self) 
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 8725 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo2_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1316 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1316 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo2_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8742 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo2_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1316 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo2_FooActorActor, 0, Void >*>(static_cast<Foo2_FooActorActor*>(this)));
															#line 8747 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1317 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo2_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo2_FooActorActorState(); static_cast<Foo2_FooActorActor*>(this)->destroy(); return 0; }
															#line 8770 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo2_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1317 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo2_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo2_FooActorActorState(); static_cast<Foo2_FooActorActor*>(this)->destroy(); return 0; }
															#line 8782 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo2_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo2_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo2_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo2_FooActorActor*>(this)->ActorCallback< Foo2_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo2_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo2_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo2_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2* self;
															#line 8855 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo2_FooActorActor final : public Actor<int>, public ActorCallback< Foo2_FooActorActor, 0, Void >, public FastAllocated<Foo2_FooActorActor>, public Foo2_FooActorActorState<Foo2_FooActorActor> {
															#line 8860 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo2_FooActorActor>::operator new;
	using FastAllocated<Foo2_FooActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo2_FooActorActor, 0, Void >;
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2_FooActorActor(Foo2* const& self) 
															#line 8871 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo2_FooActorActorState<Foo2_FooActorActor>(self)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo2_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo2::fooActor( Foo2* const& self ) {
															#line 1315 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo2_FooActorActor(self));
															#line 8898 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1319 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

class alignas(4) Foo3 {
public:
	explicit Foo3(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 8907 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo3* const& self );
template <class> friend class Foo3_FooActorActorState;

#line 1325 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 8916 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo3_FooActorActor>
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo3_FooActorActorState {
															#line 8922 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3_FooActorActorState(Foo3* const& self) 
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 8929 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo3_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1330 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1330 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo3_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8946 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo3_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1330 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo3_FooActorActor, 0, Void >*>(static_cast<Foo3_FooActorActor*>(this)));
															#line 8951 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1331 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo3_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo3_FooActorActorState(); static_cast<Foo3_FooActorActor*>(this)->destroy(); return 0; }
															#line 8974 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo3_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1331 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo3_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo3_FooActorActorState(); static_cast<Foo3_FooActorActor*>(this)->destroy(); return 0; }
															#line 8986 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo3_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo3_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo3_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo3_FooActorActor*>(this)->ActorCallback< Foo3_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo3_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo3_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo3_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3* self;
															#line 9059 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo3_FooActorActor final : public Actor<int>, public ActorCallback< Foo3_FooActorActor, 0, Void >, public FastAllocated<Foo3_FooActorActor>, public Foo3_FooActorActorState<Foo3_FooActorActor> {
															#line 9064 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo3_FooActorActor>::operator new;
	using FastAllocated<Foo3_FooActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo3_FooActorActor, 0, Void >;
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3_FooActorActor(Foo3* const& self) 
															#line 9075 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo3_FooActorActorState<Foo3_FooActorActor>(self)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo3_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo3::fooActor( Foo3* const& self ) {
															#line 1329 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo3_FooActorActor(self));
															#line 9102 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1333 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Super {};

class Foo4 : Super {
public:
	explicit Foo4(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9113 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo4* const& self );
template <class> friend class Foo4_FooActorActorState;

#line 1341 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9122 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo4_FooActorActor>
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo4_FooActorActorState {
															#line 9128 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4_FooActorActorState(Foo4* const& self) 
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9135 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo4_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1346 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1346 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo4_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9152 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo4_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1346 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo4_FooActorActor, 0, Void >*>(static_cast<Foo4_FooActorActor*>(this)));
															#line 9157 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1347 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo4_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo4_FooActorActorState(); static_cast<Foo4_FooActorActor*>(this)->destroy(); return 0; }
															#line 9180 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo4_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1347 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo4_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo4_FooActorActorState(); static_cast<Foo4_FooActorActor*>(this)->destroy(); return 0; }
															#line 9192 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo4_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo4_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo4_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo4_FooActorActor*>(this)->ActorCallback< Foo4_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo4_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo4_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo4_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4* self;
															#line 9265 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo4_FooActorActor final : public Actor<int>, public ActorCallback< Foo4_FooActorActor, 0, Void >, public FastAllocated<Foo4_FooActorActor>, public Foo4_FooActorActorState<Foo4_FooActorActor> {
															#line 9270 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo4_FooActorActor>::operator new;
	using FastAllocated<Foo4_FooActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo4_FooActorActor, 0, Void >;
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4_FooActorActor(Foo4* const& self) 
															#line 9281 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo4_FooActorActorState<Foo4_FooActorActor>(self)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo4_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo4::fooActor( Foo4* const& self ) {
															#line 1345 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo4_FooActorActor(self));
															#line 9308 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Outer {
	class Foo5 : Super {
	public:
		explicit Foo5(int x) : x(x) {}
		Future<int> foo() { return fooActor(this); }
																	#line 9318 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo5* const& self );
template <class> friend class Outer_Foo5_FooActorActorState;

#line 1356 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

	private:
		int x;
	};
};
															#line 9328 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Outer_Foo5_FooActorActor>
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Outer_Foo5_FooActorActorState {
															#line 9334 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer_Foo5_FooActorActorState(Outer::Foo5* const& self) 
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9341 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Outer_Foo5_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1362 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1362 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9358 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1362 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*>(static_cast<Outer_Foo5_FooActorActor*>(this)));
															#line 9363 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1363 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Outer_Foo5_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Outer_Foo5_FooActorActorState(); static_cast<Outer_Foo5_FooActorActor*>(this)->destroy(); return 0; }
															#line 9386 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Outer_Foo5_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1363 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Outer_Foo5_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Outer_Foo5_FooActorActorState(); static_cast<Outer_Foo5_FooActorActor*>(this)->destroy(); return 0; }
															#line 9398 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Outer_Foo5_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Outer_Foo5_FooActorActor*>(this)->ActorCallback< Outer_Foo5_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer::Foo5* self;
															#line 9471 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Outer_Foo5_FooActorActor final : public Actor<int>, public ActorCallback< Outer_Foo5_FooActorActor, 0, Void >, public FastAllocated<Outer_Foo5_FooActorActor>, public Outer_Foo5_FooActorActorState<Outer_Foo5_FooActorActor> {
															#line 9476 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Outer_Foo5_FooActorActor>::operator new;
	using FastAllocated<Outer_Foo5_FooActorActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<int>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< Outer_Foo5_FooActorActor, 0, Void >;
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer_Foo5_FooActorActor(Outer::Foo5* const& self) 
															#line 9487 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Outer_Foo5_FooActorActorState<Outer_Foo5_FooActorActor>(self)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Outer::Foo5::fooActor( Outer::Foo5* const& self ) {
															#line 1361 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Outer_Foo5_FooActorActor(self));
															#line 9514 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1365 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Meant to be run with -fsanitize=undefined
															#line 9520 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1367()
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1367Actor>
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1367ActorState {
															#line 9527 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1367ActorState(UnitTestParameters const& params) 
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 9534 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1367", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1367ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1367", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1368 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(std::numeric_limits<int>::min(), 0);
															#line 1369 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(0, std::numeric_limits<int>::max());
															#line 1370 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(std::numeric_limits<int>::min(), std::numeric_limits<int>::max());
															#line 1371 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt(std::numeric_limits<int>::min(), std::numeric_limits<int>::min() + 1) == std::numeric_limits<int>::min());
															#line 1373 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt(std::numeric_limits<int>::max() - 1, std::numeric_limits<int>::max()) == std::numeric_limits<int>::max() - 1);
															#line 1376 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), 0);
															#line 1377 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(0, std::numeric_limits<int64_t>::max());
															#line 1378 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::max());
															#line 1379 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::min() + 1) == std::numeric_limits<int64_t>::min());
															#line 1382 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::max() - 1, std::numeric_limits<int64_t>::max()) == std::numeric_limits<int64_t>::max() - 1);
															#line 1385 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1367Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1367ActorState(); static_cast<FlowTestCase1367Actor*>(this)->destroy(); return 0; }
															#line 9569 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1367Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1367ActorState();
			static_cast<FlowTestCase1367Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1367ActorState();
		static_cast<FlowTestCase1367Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 9593 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1367()
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1367Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1367Actor>, public FlowTestCase1367ActorState<FlowTestCase1367Actor> {
															#line 9598 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1367Actor>::operator new;
	using FastAllocated<FlowTestCase1367Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1367Actor(UnitTestParameters const& params) 
															#line 9608 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1367ActorState<FlowTestCase1367Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1367", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1367");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1367", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
}
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1367( UnitTestParameters const& params ) {
															#line 1367 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1367Actor(params));
															#line 9635 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1367, "/flow/DeterministicRandom/SignedOverflow")

#line 1387 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Tracker {
	int copied;
	bool moved;
	Tracker(int copied = 0) : copied(copied), moved(false) {}
	Tracker(Tracker&& other) : Tracker(other.copied) {
		ASSERT(!other.moved);
		other.moved = true;
	}
	Tracker& operator=(Tracker&& other) {
		ASSERT(!other.moved);
		other.moved = true;
		this->moved = false;
		this->copied = other.copied;
		return *this;
	}
	Tracker(const Tracker& other) : Tracker(other.copied + 1) { ASSERT(!other.moved); }
	Tracker& operator=(const Tracker& other) {
		ASSERT(!other.moved);
		this->moved = false;
		this->copied = other.copied + 1;
		return *this;
	}
	~Tracker() = default;

																#line 9665 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via listen()
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ListenActor>
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ListenActorState {
															#line 9671 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ListenActorState(FutureStream<Tracker> const& stream) 
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : stream(stream)
															#line 9678 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("listen", reinterpret_cast<unsigned long>(this));

	}
	~ListenActorState() 
	{
		fdb_probe_actor_destroy("listen", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1413 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_0 = stream;
															#line 1413 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ListenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9695 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<ListenActor*>(this)->actor_wait_state = 1;
															#line 1413 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ListenActor, 0, Tracker >*>(static_cast<ListenActor*>(this)));
															#line 9700 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker const& movedTracker,int loopDepth) 
	{
															#line 1414 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1415 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1416 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ListenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListenActorState(); static_cast<ListenActor*>(this)->destroy(); return 0; }
															#line 9727 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ListenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker && movedTracker,int loopDepth) 
	{
															#line 1414 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1415 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1416 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ListenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListenActorState(); static_cast<ListenActor*>(this)->destroy(); return 0; }
															#line 9743 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ListenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tracker const& movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(movedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tracker && movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(movedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListenActor*>(this)->actor_wait_state > 0) static_cast<ListenActor*>(this)->actor_wait_state = 0;
		static_cast<ListenActor*>(this)->ActorSingleCallback< ListenActor, 0, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ListenActor, 0, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ListenActor, 0, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ListenActor, 0, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<Tracker> stream;
															#line 9816 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via listen()
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ListenActor final : public Actor<Void>, public ActorSingleCallback< ListenActor, 0, Tracker >, public FastAllocated<ListenActor>, public ListenActorState<ListenActor> {
															#line 9821 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<ListenActor>::operator new;
	using FastAllocated<ListenActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ListenActor, 0, Tracker >;
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ListenActor(FutureStream<Tracker> const& stream) 
															#line 9832 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   ListenActorState<ListenActor>(stream)
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listen");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ListenActor, 0, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> listen( FutureStream<Tracker> const& stream ) {
															#line 1412 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new ListenActor(stream));
															#line 9859 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1418 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
};

															#line 9865 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1420()
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1420Actor>
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1420ActorState {
															#line 9872 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1420ActorState(UnitTestParameters const& params) 
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1421 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   stream(),
															#line 1422 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   listener()
															#line 9883 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1420", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1420ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1420", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 1426 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				listener = Tracker::listen(stream.getFuture());
															#line 1427 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				stream.send(Tracker{});
															#line 1428 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = listener;
															#line 1428 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9905 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 1;
															#line 1428 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1420Actor, 0, Void >*>(static_cast<FlowTestCase1420Actor*>(this)));
															#line 9910 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1420ActorState();
		static_cast<FlowTestCase1420Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 1434 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			listener = Tracker::listen(stream.getFuture());
															#line 1435 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker;
															#line 1436 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker);
															#line 1437 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = listener;
															#line 1437 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9943 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 2;
															#line 1437 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1420Actor, 1, Void >*>(static_cast<FlowTestCase1420Actor*>(this)));
															#line 9948 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1420Actor*>(this)->ActorCallback< FlowTestCase1420Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1420Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1420Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1420Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		{
															#line 1442 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 1443 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 10036 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1445 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				FutureStream<Tracker> __when_expr_2 = stream.getFuture();
															#line 1445 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10042 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.pop(), loopDepth); };
				static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 3;
															#line 1445 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >*>(static_cast<FlowTestCase1420Actor*>(this)));
															#line 10047 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1420Actor*>(this)->ActorCallback< FlowTestCase1420Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1420Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1420Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1420Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		{
															#line 1458 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker1;
															#line 1459 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker2;
															#line 1460 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker1);
															#line 1461 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker2);
															#line 10140 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1463 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				FutureStream<Tracker> __when_expr_4 = stream.getFuture();
															#line 1463 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10146 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.pop(), loopDepth); };
				static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 5;
															#line 1463 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >*>(static_cast<FlowTestCase1420Actor*>(this)));
															#line 10151 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		{
															#line 1450 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_3 = stream.getFuture();
															#line 1450 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10165 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.pop(), loopDepth); };
			static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 4;
															#line 1450 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >*>(static_cast<FlowTestCase1420Actor*>(this)));
															#line 10170 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1446 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1447 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 10182 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Tracker const& __movedTracker,int loopDepth) 
	{
															#line 1445 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		movedTracker = __movedTracker;
															#line 10191 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Tracker && __movedTracker,int loopDepth) 
	{
		movedTracker = std::move(__movedTracker);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1420Actor*>(this)->ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Tracker const& movedTracker,int loopDepth) 
	{
															#line 1451 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1452 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 10266 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Tracker && movedTracker,int loopDepth) 
	{
															#line 1451 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1452 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 10277 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Tracker const& movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont10(movedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Tracker && movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(movedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1420Actor*>(this)->ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 3);
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 1476 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1420Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1420ActorState(); static_cast<FlowTestCase1420Actor*>(this)->destroy(); return 0; }
															#line 10349 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1420Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1420ActorState();
		static_cast<FlowTestCase1420Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		{
															#line 1469 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_5 = stream.getFuture();
															#line 1469 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10364 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.pop(), loopDepth); };
			static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 6;
															#line 1469 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >*>(static_cast<FlowTestCase1420Actor*>(this)));
															#line 10369 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 1464 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1466 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 10381 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Tracker const& __copiedTracker,int loopDepth) 
	{
															#line 1463 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		copiedTracker = __copiedTracker;
															#line 10390 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Tracker && __copiedTracker,int loopDepth) 
	{
		copiedTracker = std::move(__copiedTracker);
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1420Actor*>(this)->ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 4);
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Tracker const& copiedTracker,int loopDepth) 
	{
															#line 1470 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1472 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 10465 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Tracker && copiedTracker,int loopDepth) 
	{
															#line 1470 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1472 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 10476 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Tracker const& copiedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(copiedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Tracker && copiedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(copiedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1420Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1420Actor*>(this)->ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), 5);
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1421 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	PromiseStream<Tracker> stream;
															#line 1422 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> listener;
															#line 1445 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Tracker movedTracker;
															#line 1463 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Tracker copiedTracker;
															#line 10554 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1420()
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1420Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1420Actor, 0, Void >, public ActorCallback< FlowTestCase1420Actor, 1, Void >, public ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >, public ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >, public ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >, public ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >, public FastAllocated<FlowTestCase1420Actor>, public FlowTestCase1420ActorState<FlowTestCase1420Actor> {
															#line 10559 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1420Actor>::operator new;
	using FastAllocated<FlowTestCase1420Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1420Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1420Actor, 1, Void >;
friend struct ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >;
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1420Actor(UnitTestParameters const& params) 
															#line 10575 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1420ActorState<FlowTestCase1420Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1420", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1420");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1420", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1420Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1420Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< FlowTestCase1420Actor, 2, Tracker >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< FlowTestCase1420Actor, 3, Tracker >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< FlowTestCase1420Actor, 4, Tracker >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorSingleCallback< FlowTestCase1420Actor, 5, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1420( UnitTestParameters const& params ) {
															#line 1420 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1420Actor(params));
															#line 10608 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1420, "/flow/flow/PromiseStream/move")

#line 1478 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 10614 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1479()
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1479Actor>
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1479ActorState {
															#line 10621 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1479ActorState(UnitTestParameters const& params) 
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 10628 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1479", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1479ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1479", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1480 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<Tracker> stream;
															#line 1481 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 1482 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_0 = stream.getFuture();
															#line 1482 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1479Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10649 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<FlowTestCase1479Actor*>(this)->actor_wait_state = 1;
															#line 1482 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >*>(static_cast<FlowTestCase1479Actor*>(this)));
															#line 10654 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1479ActorState();
		static_cast<FlowTestCase1479Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker const& tracker,int loopDepth) 
	{
															#line 1483 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		Tracker movedTracker = std::move(tracker);
															#line 1484 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(tracker.moved);
															#line 1485 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1486 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1487 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1479Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1479ActorState(); static_cast<FlowTestCase1479Actor*>(this)->destroy(); return 0; }
															#line 10685 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1479Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1479ActorState();
		static_cast<FlowTestCase1479Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker && tracker,int loopDepth) 
	{
															#line 1483 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		Tracker movedTracker = std::move(tracker);
															#line 1484 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(tracker.moved);
															#line 1485 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1486 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1487 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1479Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1479ActorState(); static_cast<FlowTestCase1479Actor*>(this)->destroy(); return 0; }
															#line 10705 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1479Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1479ActorState();
		static_cast<FlowTestCase1479Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tracker const& tracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(tracker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tracker && tracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1479Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1479Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1479Actor*>(this)->ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1479", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1479", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1479", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1479", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1479", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1479", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 10778 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1479()
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1479Actor final : public Actor<Void>, public ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >, public FastAllocated<FlowTestCase1479Actor>, public FlowTestCase1479ActorState<FlowTestCase1479Actor> {
															#line 10783 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1479Actor>::operator new;
	using FastAllocated<FlowTestCase1479Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >;
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1479Actor(UnitTestParameters const& params) 
															#line 10794 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1479ActorState<FlowTestCase1479Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1479", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1479");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1479", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FlowTestCase1479Actor, 0, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1479( UnitTestParameters const& params ) {
															#line 1479 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1479Actor(params));
															#line 10822 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1479, "/flow/flow/PromiseStream/move2")

#line 1489 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

constexpr double mutexTestDelay = 0.00001;

															#line 10830 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via mutexTest()
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class MutexTestActor>
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class MutexTestActorState {
															#line 10837 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	MutexTestActorState(int const& id,FlowMutex* const& mutex,int const& n,bool const& allowError,bool* const& verbose) 
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : id(id),
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   mutex(mutex),
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   n(n),
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   allowError(allowError),
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verbose(verbose)
															#line 10852 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("mutexTest", reinterpret_cast<unsigned long>(this));

	}
	~MutexTestActorState() 
	{
		fdb_probe_actor_destroy("mutexTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1493 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 10867 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MutexTestActorState();
		static_cast<MutexTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1536 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 10890 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1537 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d Returning\n", id);
															#line 10894 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1539 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<MutexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MutexTestActorState(); static_cast<MutexTestActor*>(this)->destroy(); return 0; }
															#line 10898 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<MutexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MutexTestActorState();
		static_cast<MutexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1493 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(n-- > 0))
															#line 10917 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1494 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		d = deterministicRandom()->random01() * mutexTestDelay;
															#line 1495 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 10925 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1496 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d wait %f while unlocked\n", id, n, d);
															#line 10929 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1498 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(d);
															#line 1498 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10935 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 1;
															#line 1498 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 0, Void >*>(static_cast<MutexTestActor*>(this)));
															#line 10940 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1500 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 10962 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1501 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locking\n", id, n);
															#line 10966 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<FlowMutex::Lock> __when_expr_1 = mutex->take();
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10972 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 2;
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*>(static_cast<MutexTestActor*>(this)));
															#line 10977 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1500 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 10986 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1501 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locking\n", id, n);
															#line 10990 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<FlowMutex::Lock> __when_expr_1 = mutex->take();
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10996 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 2;
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*>(static_cast<MutexTestActor*>(this)));
															#line 11001 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1504 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 11073 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1505 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locked\n", id, n);
															#line 11077 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1508 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		d = deterministicRandom()->random01() * mutexTestDelay;
															#line 1509 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 11083 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1510 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d wait %f while locked\n", id, n, d);
															#line 11087 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(d);
															#line 1512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11093 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 3;
															#line 1512 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 2, Void >*>(static_cast<MutexTestActor*>(this)));
															#line 11098 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(FlowMutex::Lock const& __lock,int loopDepth) 
	{
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		lock = __lock;
															#line 11107 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(FlowMutex::Lock && __lock,int loopDepth) 
	{
		lock = std::move(__lock);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 1, FlowMutex::Lock >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,FlowMutex::Lock const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,FlowMutex::Lock && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1515 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (n == 0 && allowError)
															#line 11174 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1516 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 11178 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1518 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 11182 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1519 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d sending error\n", id, n);
															#line 11186 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1521 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				lock.error(end_of_stream());
															#line 11190 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			else
			{
															#line 1524 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 11196 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1525 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d dropping promise, returning without unlock\n", id, n);
															#line 11200 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1529 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (*verbose)
															#line 11208 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1530 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("%d:%d unlocking\n", id, n);
															#line 11212 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1532 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			lock.release();
															#line 11216 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1515 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (n == 0 && allowError)
															#line 11226 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1516 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 11230 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1518 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 11234 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1519 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d sending error\n", id, n);
															#line 11238 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1521 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				lock.error(end_of_stream());
															#line 11242 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
			else
			{
															#line 1524 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 11248 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1525 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d dropping promise, returning without unlock\n", id, n);
															#line 11252 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1529 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (*verbose)
															#line 11260 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1530 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("%d:%d unlocking\n", id, n);
															#line 11264 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1532 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			lock.release();
															#line 11268 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int id;
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex* mutex;
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int n;
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool allowError;
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool* verbose;
															#line 1494 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	double d;
															#line 1503 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex::Lock lock;
															#line 11351 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via mutexTest()
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class MutexTestActor final : public Actor<Void>, public ActorCallback< MutexTestActor, 0, Void >, public ActorCallback< MutexTestActor, 1, FlowMutex::Lock >, public ActorCallback< MutexTestActor, 2, Void >, public FastAllocated<MutexTestActor>, public MutexTestActorState<MutexTestActor> {
															#line 11356 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<MutexTestActor>::operator new;
	using FastAllocated<MutexTestActor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< MutexTestActor, 0, Void >;
friend struct ActorCallback< MutexTestActor, 1, FlowMutex::Lock >;
friend struct ActorCallback< MutexTestActor, 2, Void >;
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	MutexTestActor(int const& id,FlowMutex* const& mutex,int const& n,bool const& allowError,bool* const& verbose) 
															#line 11369 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   MutexTestActorState<MutexTestActor>(id, mutex, n, allowError, verbose)
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mutexTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MutexTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MutexTestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<Void> mutexTest( int const& id, FlowMutex* const& mutex, int const& n, bool const& allowError, bool* const& verbose ) {
															#line 1492 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new MutexTestActor(id, mutex, n, allowError, verbose));
															#line 11399 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1541 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 11404 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1542()
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1542Actor>
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1542ActorState {
															#line 11411 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1542ActorState(UnitTestParameters const& params) 
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1543 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   count(100000),
															#line 1546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verboseSetting(false),
															#line 1548 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verboseTestIteration(-1)
															#line 11424 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1542", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1542ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1542", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1551 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				verbose = verboseSetting || count == verboseTestIteration;
															#line 1553 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				;
															#line 11442 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1542ActorState();
		static_cast<FlowTestCase1542Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1609 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1542Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1542ActorState(); static_cast<FlowTestCase1542Actor*>(this)->destroy(); return 0; }
															#line 11471 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1542Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1542ActorState();
		static_cast<FlowTestCase1542Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1605 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("Error at count=%d\n", count + 1);
															#line 1606 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(false);
															#line 11486 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1553 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(--count > 0))
															#line 11514 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1554 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (count % 1000 == 0)
															#line 11520 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1555 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d tests left\n", count);
															#line 11524 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1558 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		mutex = FlowMutex();
															#line 1559 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		tests = std::vector<Future<Void>>();
															#line 1561 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		allowErrors = deterministicRandom()->coinflip();
															#line 1562 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 11534 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1563 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("\nTesting allowErrors=%d\n", allowErrors);
															#line 11538 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1566 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		error = Optional<Error>();
															#line 11542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		try {
															#line 1569 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 1570 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				tests.push_back(mutexTest(i, &mutex, 10, allowErrors, &verbose));
															#line 11548 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1572 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(tests);
															#line 1572 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11554 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state = 1;
															#line 1572 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1542Actor, 0, Void >*>(static_cast<FlowTestCase1542Actor*>(this)));
															#line 11559 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1602 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(error.present() == allowErrors);
															#line 11587 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1581 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 11597 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1582 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Caught error %s\n", e.what());
															#line 11601 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1584 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			error = e;
															#line 1588 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			i = int();
															#line 1589 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 11609 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1590 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Waiting for completions.  Future end states:\n");
															#line 11613 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1592 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			i = 0;
															#line 11617 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1574 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (allowErrors)
															#line 11632 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1575 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 11636 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1576 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Final wait in case error was injected by the last actor to finish\n");
															#line 11640 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1578 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(mutex.take());
															#line 1578 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11646 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state = 2;
															#line 1578 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1542Actor, 1, Void >*>(static_cast<FlowTestCase1542Actor*>(this)));
															#line 11651 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1574 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (allowErrors)
															#line 11665 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1575 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 11669 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1576 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Final wait in case error was injected by the last actor to finish\n");
															#line 11673 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1578 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(mutex.take());
															#line 1578 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11679 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state = 2;
															#line 1578 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1542Actor, 1, Void >*>(static_cast<FlowTestCase1542Actor*>(this)));
															#line 11684 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1542Actor*>(this)->ActorCallback< FlowTestCase1542Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1542Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1542Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1542Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 0);
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1542Actor*>(this)->ActorCallback< FlowTestCase1542Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1542Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1542Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1542Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 1);
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 1592 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(i < tests.size()))
															#line 11868 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1593 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_2 = errorOr(tests[i]);
															#line 1593 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11876 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state = 3;
															#line 1593 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >*>(static_cast<FlowTestCase1542Actor*>(this)));
															#line 11881 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(ErrorOr<Void> const& f,int loopDepth) 
	{
															#line 1594 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 11903 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1595 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("  %d: %s\n", i, f.isError() ? f.getError().what() : "done");
															#line 11907 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1592 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++i;
															#line 11911 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(ErrorOr<Void> && f,int loopDepth) 
	{
															#line 1594 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 11920 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1595 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("  %d: %s\n", i, f.isError() ? f.getError().what() : "done");
															#line 11924 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1592 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++i;
															#line 11928 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(ErrorOr<Void> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(ErrorOr<Void> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1542Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1542Actor*>(this)->ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), 2);
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1543 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int count;
															#line 1546 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool verboseSetting;
															#line 1548 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int verboseTestIteration;
															#line 1551 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool verbose;
															#line 1558 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex mutex;
															#line 1559 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	std::vector<Future<Void>> tests;
															#line 1561 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool allowErrors;
															#line 1566 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Optional<Error> error;
															#line 1588 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int i;
															#line 12029 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1542()
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1542Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1542Actor, 0, Void >, public ActorCallback< FlowTestCase1542Actor, 1, Void >, public ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >, public FastAllocated<FlowTestCase1542Actor>, public FlowTestCase1542ActorState<FlowTestCase1542Actor> {
															#line 12034 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1542Actor>::operator new;
	using FastAllocated<FlowTestCase1542Actor>::operator delete;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
	void destroy() override { ((Actor<Void>*)this)->~Actor(); operator delete(this); }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1542Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1542Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >;
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1542Actor(UnitTestParameters const& params) 
															#line 12047 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1542ActorState<FlowTestCase1542Actor>(params)
	{
		fdb_probe_actor_enter("flowTestCase1542", reinterpret_cast<unsigned long>(this), -1);
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1542");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1542", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1542Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1542Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1542Actor, 2, ErrorOr<Void> >*)0, actor_cancelled()); break;
		}

	}
};
}
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1542( UnitTestParameters const& params ) {
															#line 1542 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1542Actor(params));
															#line 12077 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/build_output/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1542, "/flow/flow/FlowMutex")

#line 1611 "/codebuild/output/src2092818461/src/github.com/apple/foundationdb/fdbrpc/FlowTests.actor.cpp"
