﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/SSMRequest.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace SSM
{
namespace Model
{

  /**
   */
  class AWS_SSM_API DeleteParametersRequest : public SSMRequest
  {
  public:
    DeleteParametersRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DeleteParameters"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline const Aws::Vector<Aws::String>& GetNames() const{ return m_names; }

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline bool NamesHasBeenSet() const { return m_namesHasBeenSet; }

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline void SetNames(const Aws::Vector<Aws::String>& value) { m_namesHasBeenSet = true; m_names = value; }

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline void SetNames(Aws::Vector<Aws::String>&& value) { m_namesHasBeenSet = true; m_names = std::move(value); }

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline DeleteParametersRequest& WithNames(const Aws::Vector<Aws::String>& value) { SetNames(value); return *this;}

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline DeleteParametersRequest& WithNames(Aws::Vector<Aws::String>&& value) { SetNames(std::move(value)); return *this;}

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline DeleteParametersRequest& AddNames(const Aws::String& value) { m_namesHasBeenSet = true; m_names.push_back(value); return *this; }

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline DeleteParametersRequest& AddNames(Aws::String&& value) { m_namesHasBeenSet = true; m_names.push_back(std::move(value)); return *this; }

    /**
     * <p>The names of the parameters to delete. After deleting a parameter, wait for
     * at least 30 seconds to create a parameter with the same name.</p>
     */
    inline DeleteParametersRequest& AddNames(const char* value) { m_namesHasBeenSet = true; m_names.push_back(value); return *this; }

  private:

    Aws::Vector<Aws::String> m_names;
    bool m_namesHasBeenSet;
  };

} // namespace Model
} // namespace SSM
} // namespace Aws
