﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/model/MalwareType.h>
#include <aws/securityhub/model/MalwareState.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A list of malware related to a finding.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Malware">AWS
   * API Reference</a></p>
   */
  class AWS_SECURITYHUB_API Malware
  {
  public:
    Malware();
    Malware(Aws::Utils::Json::JsonView jsonValue);
    Malware& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline const Aws::String& GetName() const{ return m_name; }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline void SetName(const Aws::String& value) { m_nameHasBeenSet = true; m_name = value; }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline void SetName(Aws::String&& value) { m_nameHasBeenSet = true; m_name = std::move(value); }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline void SetName(const char* value) { m_nameHasBeenSet = true; m_name.assign(value); }

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline Malware& WithName(const Aws::String& value) { SetName(value); return *this;}

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline Malware& WithName(Aws::String&& value) { SetName(std::move(value)); return *this;}

    /**
     * <p>The name of the malware that was observed.</p>
     */
    inline Malware& WithName(const char* value) { SetName(value); return *this;}


    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline const MalwareType& GetType() const{ return m_type; }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline void SetType(const MalwareType& value) { m_typeHasBeenSet = true; m_type = value; }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline void SetType(MalwareType&& value) { m_typeHasBeenSet = true; m_type = std::move(value); }

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline Malware& WithType(const MalwareType& value) { SetType(value); return *this;}

    /**
     * <p>The type of the malware that was observed.</p>
     */
    inline Malware& WithType(MalwareType&& value) { SetType(std::move(value)); return *this;}


    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline const Aws::String& GetPath() const{ return m_path; }

    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline bool PathHasBeenSet() const { return m_pathHasBeenSet; }

    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline void SetPath(const Aws::String& value) { m_pathHasBeenSet = true; m_path = value; }

    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline void SetPath(Aws::String&& value) { m_pathHasBeenSet = true; m_path = std::move(value); }

    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline void SetPath(const char* value) { m_pathHasBeenSet = true; m_path.assign(value); }

    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline Malware& WithPath(const Aws::String& value) { SetPath(value); return *this;}

    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline Malware& WithPath(Aws::String&& value) { SetPath(std::move(value)); return *this;}

    /**
     * <p>The file system path of the malware that was observed.</p>
     */
    inline Malware& WithPath(const char* value) { SetPath(value); return *this;}


    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline const MalwareState& GetState() const{ return m_state; }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline void SetState(const MalwareState& value) { m_stateHasBeenSet = true; m_state = value; }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline void SetState(MalwareState&& value) { m_stateHasBeenSet = true; m_state = std::move(value); }

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline Malware& WithState(const MalwareState& value) { SetState(value); return *this;}

    /**
     * <p>The state of the malware that was observed.</p>
     */
    inline Malware& WithState(MalwareState&& value) { SetState(std::move(value)); return *this;}

  private:

    Aws::String m_name;
    bool m_nameHasBeenSet;

    MalwareType m_type;
    bool m_typeHasBeenSet;

    Aws::String m_path;
    bool m_pathHasBeenSet;

    MalwareState m_state;
    bool m_stateHasBeenSet;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
