﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/sagemaker/model/CodeRepositorySortOrder.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace SageMaker
  {
    namespace Model
    {
      namespace CodeRepositorySortOrderMapper
      {

        static const int Ascending_HASH = HashingUtils::HashString("Ascending");
        static const int Descending_HASH = HashingUtils::HashString("Descending");


        CodeRepositorySortOrder GetCodeRepositorySortOrderForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == Ascending_HASH)
          {
            return CodeRepositorySortOrder::Ascending;
          }
          else if (hashCode == Descending_HASH)
          {
            return CodeRepositorySortOrder::Descending;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<CodeRepositorySortOrder>(hashCode);
          }

          return CodeRepositorySortOrder::NOT_SET;
        }

        Aws::String GetNameForCodeRepositorySortOrder(CodeRepositorySortOrder enumValue)
        {
          switch(enumValue)
          {
          case CodeRepositorySortOrder::Ascending:
            return "Ascending";
          case CodeRepositorySortOrder::Descending:
            return "Descending";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace CodeRepositorySortOrderMapper
    } // namespace Model
  } // namespace SageMaker
} // namespace Aws
