﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ram/model/ListPendingInvitationResourcesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::RAM::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

ListPendingInvitationResourcesRequest::ListPendingInvitationResourcesRequest() : 
    m_resourceShareInvitationArnHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false),
    m_resourceRegionScope(ResourceRegionScopeFilter::NOT_SET),
    m_resourceRegionScopeHasBeenSet(false)
{
}

Aws::String ListPendingInvitationResourcesRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_resourceShareInvitationArnHasBeenSet)
  {
   payload.WithString("resourceShareInvitationArn", m_resourceShareInvitationArn);

  }

  if(m_nextTokenHasBeenSet)
  {
   payload.WithString("nextToken", m_nextToken);

  }

  if(m_maxResultsHasBeenSet)
  {
   payload.WithInteger("maxResults", m_maxResults);

  }

  if(m_resourceRegionScopeHasBeenSet)
  {
   payload.WithString("resourceRegionScope", ResourceRegionScopeFilterMapper::GetNameForResourceRegionScopeFilter(m_resourceRegionScope));
  }

  return payload.View().WriteReadable();
}




