﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/nimble/model/GetStreamingSessionStreamResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::NimbleStudio::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetStreamingSessionStreamResult::GetStreamingSessionStreamResult()
{
}

GetStreamingSessionStreamResult::GetStreamingSessionStreamResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

GetStreamingSessionStreamResult& GetStreamingSessionStreamResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("stream"))
  {
    m_stream = jsonValue.GetObject("stream");

  }



  return *this;
}
