﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/logs/model/GetLogGroupFieldsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CloudWatchLogs::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

GetLogGroupFieldsRequest::GetLogGroupFieldsRequest() : 
    m_logGroupNameHasBeenSet(false),
    m_time(0),
    m_timeHasBeenSet(false)
{
}

Aws::String GetLogGroupFieldsRequest::SerializePayload() const
{
  JsonValue payload;

  if(m_logGroupNameHasBeenSet)
  {
   payload.WithString("logGroupName", m_logGroupName);

  }

  if(m_timeHasBeenSet)
  {
   payload.WithInt64("time", m_time);

  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetLogGroupFieldsRequest::GetRequestSpecificHeaders() const
{
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Logs_20140328.GetLogGroupFields"));
  return headers;

}




