﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/iot1click-devices/model/ListDeviceEventsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::IoT1ClickDevicesService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

ListDeviceEventsRequest::ListDeviceEventsRequest() : 
    m_deviceIdHasBeenSet(false),
    m_fromTimeStampHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_toTimeStampHasBeenSet(false)
{
}

Aws::String ListDeviceEventsRequest::SerializePayload() const
{
  return {};
}

void ListDeviceEventsRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_fromTimeStampHasBeenSet)
    {
      ss << m_fromTimeStamp.ToGmtString(DateFormat::ISO_8601);
      uri.AddQueryStringParameter("fromTimeStamp", ss.str());
      ss.str("");
    }

    if(m_maxResultsHasBeenSet)
    {
      ss << m_maxResults;
      uri.AddQueryStringParameter("maxResults", ss.str());
      ss.str("");
    }

    if(m_nextTokenHasBeenSet)
    {
      ss << m_nextToken;
      uri.AddQueryStringParameter("nextToken", ss.str());
      ss.str("");
    }

    if(m_toTimeStampHasBeenSet)
    {
      ss << m_toTimeStamp.ToGmtString(DateFormat::ISO_8601);
      uri.AddQueryStringParameter("toTimeStamp", ss.str());
      ss.str("");
    }

}



