﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/datasync/DataSync_EXPORTS.h>
#include <aws/datasync/model/VerifyMode.h>
#include <aws/datasync/model/OverwriteMode.h>
#include <aws/datasync/model/Atime.h>
#include <aws/datasync/model/Mtime.h>
#include <aws/datasync/model/Uid.h>
#include <aws/datasync/model/Gid.h>
#include <aws/datasync/model/PreserveDeletedFiles.h>
#include <aws/datasync/model/PreserveDevices.h>
#include <aws/datasync/model/PosixPermissions.h>
#include <aws/datasync/model/TaskQueueing.h>
#include <aws/datasync/model/LogLevel.h>
#include <aws/datasync/model/TransferMode.h>
#include <aws/datasync/model/SmbSecurityDescriptorCopyFlags.h>
#include <aws/datasync/model/ObjectTags.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace DataSync
{
namespace Model
{

  /**
   * <p>Represents the options that are available to control the behavior of a <a
   * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>
   * operation. Behavior includes preserving metadata such as user ID (UID), group ID
   * (GID), and file permissions, and also overwriting files in the destination, data
   * integrity verification, and so on.</p> <p>A task has a set of default options
   * associated with it. If you don't specify an option in <a
   * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>,
   * the default value is used. You can override the defaults options on each task
   * execution by specifying an overriding <code>Options</code> value to <a
   * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a>.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/Options">AWS
   * API Reference</a></p>
   */
  class AWS_DATASYNC_API Options
  {
  public:
    Options();
    Options(Aws::Utils::Json::JsonView jsonValue);
    Options& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>A value that determines whether a data integrity verification should be
     * performed at the end of a task execution after all data and metadata have been
     * transferred. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure
     * task settings</a>. </p> <p>Default value: <code>POINT_IN_TIME_CONSISTENT</code>
     * </p> <p> <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification
     * only on files that were transferred. </p> <p>
     * <code>POINT_IN_TIME_CONSISTENT</code>: Scan the entire source and entire
     * destination at the end of the transfer to verify that source and destination are
     * fully synchronized. This option isn't supported when transferring to S3 Glacier
     * Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p> <p>
     * <code>NONE</code>: No additional verification is done at the end of the
     * transfer, but all data transmissions are integrity-checked with checksum
     * verification during the transfer.</p>
     */
    inline const VerifyMode& GetVerifyMode() const{ return m_verifyMode; }

    /**
     * <p>A value that determines whether a data integrity verification should be
     * performed at the end of a task execution after all data and metadata have been
     * transferred. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure
     * task settings</a>. </p> <p>Default value: <code>POINT_IN_TIME_CONSISTENT</code>
     * </p> <p> <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification
     * only on files that were transferred. </p> <p>
     * <code>POINT_IN_TIME_CONSISTENT</code>: Scan the entire source and entire
     * destination at the end of the transfer to verify that source and destination are
     * fully synchronized. This option isn't supported when transferring to S3 Glacier
     * Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p> <p>
     * <code>NONE</code>: No additional verification is done at the end of the
     * transfer, but all data transmissions are integrity-checked with checksum
     * verification during the transfer.</p>
     */
    inline bool VerifyModeHasBeenSet() const { return m_verifyModeHasBeenSet; }

    /**
     * <p>A value that determines whether a data integrity verification should be
     * performed at the end of a task execution after all data and metadata have been
     * transferred. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure
     * task settings</a>. </p> <p>Default value: <code>POINT_IN_TIME_CONSISTENT</code>
     * </p> <p> <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification
     * only on files that were transferred. </p> <p>
     * <code>POINT_IN_TIME_CONSISTENT</code>: Scan the entire source and entire
     * destination at the end of the transfer to verify that source and destination are
     * fully synchronized. This option isn't supported when transferring to S3 Glacier
     * Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p> <p>
     * <code>NONE</code>: No additional verification is done at the end of the
     * transfer, but all data transmissions are integrity-checked with checksum
     * verification during the transfer.</p>
     */
    inline void SetVerifyMode(const VerifyMode& value) { m_verifyModeHasBeenSet = true; m_verifyMode = value; }

    /**
     * <p>A value that determines whether a data integrity verification should be
     * performed at the end of a task execution after all data and metadata have been
     * transferred. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure
     * task settings</a>. </p> <p>Default value: <code>POINT_IN_TIME_CONSISTENT</code>
     * </p> <p> <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification
     * only on files that were transferred. </p> <p>
     * <code>POINT_IN_TIME_CONSISTENT</code>: Scan the entire source and entire
     * destination at the end of the transfer to verify that source and destination are
     * fully synchronized. This option isn't supported when transferring to S3 Glacier
     * Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p> <p>
     * <code>NONE</code>: No additional verification is done at the end of the
     * transfer, but all data transmissions are integrity-checked with checksum
     * verification during the transfer.</p>
     */
    inline void SetVerifyMode(VerifyMode&& value) { m_verifyModeHasBeenSet = true; m_verifyMode = std::move(value); }

    /**
     * <p>A value that determines whether a data integrity verification should be
     * performed at the end of a task execution after all data and metadata have been
     * transferred. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure
     * task settings</a>. </p> <p>Default value: <code>POINT_IN_TIME_CONSISTENT</code>
     * </p> <p> <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification
     * only on files that were transferred. </p> <p>
     * <code>POINT_IN_TIME_CONSISTENT</code>: Scan the entire source and entire
     * destination at the end of the transfer to verify that source and destination are
     * fully synchronized. This option isn't supported when transferring to S3 Glacier
     * Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p> <p>
     * <code>NONE</code>: No additional verification is done at the end of the
     * transfer, but all data transmissions are integrity-checked with checksum
     * verification during the transfer.</p>
     */
    inline Options& WithVerifyMode(const VerifyMode& value) { SetVerifyMode(value); return *this;}

    /**
     * <p>A value that determines whether a data integrity verification should be
     * performed at the end of a task execution after all data and metadata have been
     * transferred. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure
     * task settings</a>. </p> <p>Default value: <code>POINT_IN_TIME_CONSISTENT</code>
     * </p> <p> <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification
     * only on files that were transferred. </p> <p>
     * <code>POINT_IN_TIME_CONSISTENT</code>: Scan the entire source and entire
     * destination at the end of the transfer to verify that source and destination are
     * fully synchronized. This option isn't supported when transferring to S3 Glacier
     * Flexible Retrieval or S3 Glacier Deep Archive storage classes.</p> <p>
     * <code>NONE</code>: No additional verification is done at the end of the
     * transfer, but all data transmissions are integrity-checked with checksum
     * verification during the transfer.</p>
     */
    inline Options& WithVerifyMode(VerifyMode&& value) { SetVerifyMode(std::move(value)); return *this;}


    /**
     * <p>A value that determines whether files at the destination should be
     * overwritten or preserved when copying files. If set to <code>NEVER</code> a
     * destination file will not be replaced by a source file, even if the destination
     * file differs from the source file. If you modify files in the destination and
     * you sync the files, you can use this value to protect against overwriting those
     * changes. </p> <p>Some storage classes have specific behaviors that can affect
     * your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p>
     */
    inline const OverwriteMode& GetOverwriteMode() const{ return m_overwriteMode; }

    /**
     * <p>A value that determines whether files at the destination should be
     * overwritten or preserved when copying files. If set to <code>NEVER</code> a
     * destination file will not be replaced by a source file, even if the destination
     * file differs from the source file. If you modify files in the destination and
     * you sync the files, you can use this value to protect against overwriting those
     * changes. </p> <p>Some storage classes have specific behaviors that can affect
     * your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p>
     */
    inline bool OverwriteModeHasBeenSet() const { return m_overwriteModeHasBeenSet; }

    /**
     * <p>A value that determines whether files at the destination should be
     * overwritten or preserved when copying files. If set to <code>NEVER</code> a
     * destination file will not be replaced by a source file, even if the destination
     * file differs from the source file. If you modify files in the destination and
     * you sync the files, you can use this value to protect against overwriting those
     * changes. </p> <p>Some storage classes have specific behaviors that can affect
     * your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p>
     */
    inline void SetOverwriteMode(const OverwriteMode& value) { m_overwriteModeHasBeenSet = true; m_overwriteMode = value; }

    /**
     * <p>A value that determines whether files at the destination should be
     * overwritten or preserved when copying files. If set to <code>NEVER</code> a
     * destination file will not be replaced by a source file, even if the destination
     * file differs from the source file. If you modify files in the destination and
     * you sync the files, you can use this value to protect against overwriting those
     * changes. </p> <p>Some storage classes have specific behaviors that can affect
     * your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p>
     */
    inline void SetOverwriteMode(OverwriteMode&& value) { m_overwriteModeHasBeenSet = true; m_overwriteMode = std::move(value); }

    /**
     * <p>A value that determines whether files at the destination should be
     * overwritten or preserved when copying files. If set to <code>NEVER</code> a
     * destination file will not be replaced by a source file, even if the destination
     * file differs from the source file. If you modify files in the destination and
     * you sync the files, you can use this value to protect against overwriting those
     * changes. </p> <p>Some storage classes have specific behaviors that can affect
     * your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p>
     */
    inline Options& WithOverwriteMode(const OverwriteMode& value) { SetOverwriteMode(value); return *this;}

    /**
     * <p>A value that determines whether files at the destination should be
     * overwritten or preserved when copying files. If set to <code>NEVER</code> a
     * destination file will not be replaced by a source file, even if the destination
     * file differs from the source file. If you modify files in the destination and
     * you sync the files, you can use this value to protect against overwriting those
     * changes. </p> <p>Some storage classes have specific behaviors that can affect
     * your S3 storage cost. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p>
     */
    inline Options& WithOverwriteMode(OverwriteMode&& value) { SetOverwriteMode(std::move(value)); return *this;}


    /**
     * <p>A file metadata value that shows the last time a file was accessed (that is,
     * when the file was read or written to). If you set <code>Atime</code> to
     * <code>BEST_EFFORT</code>, DataSync attempts to preserve the original
     * <code>Atime</code> attribute on all source files (that is, the version before
     * the <code>PREPARING</code> phase). However, <code>Atime</code>'s behavior is not
     * fully standard across platforms, so DataSync can only do this on a best-effort
     * basis. </p> <p>Default value: <code>BEST_EFFORT</code> </p> <p>
     * <code>BEST_EFFORT</code>: Attempt to preserve the per-file <code>Atime</code>
     * value (recommended).</p> <p> <code>NONE</code>: Ignore <code>Atime</code>.</p>
     *  <p>If <code>Atime</code> is set to <code>BEST_EFFORT</code>,
     * <code>Mtime</code> must be set to <code>PRESERVE</code>. </p> <p>If
     * <code>Atime</code> is set to <code>NONE</code>, <code>Mtime</code> must also be
     * <code>NONE</code>. </p> 
     */
    inline const Atime& GetAtime() const{ return m_atime; }

    /**
     * <p>A file metadata value that shows the last time a file was accessed (that is,
     * when the file was read or written to). If you set <code>Atime</code> to
     * <code>BEST_EFFORT</code>, DataSync attempts to preserve the original
     * <code>Atime</code> attribute on all source files (that is, the version before
     * the <code>PREPARING</code> phase). However, <code>Atime</code>'s behavior is not
     * fully standard across platforms, so DataSync can only do this on a best-effort
     * basis. </p> <p>Default value: <code>BEST_EFFORT</code> </p> <p>
     * <code>BEST_EFFORT</code>: Attempt to preserve the per-file <code>Atime</code>
     * value (recommended).</p> <p> <code>NONE</code>: Ignore <code>Atime</code>.</p>
     *  <p>If <code>Atime</code> is set to <code>BEST_EFFORT</code>,
     * <code>Mtime</code> must be set to <code>PRESERVE</code>. </p> <p>If
     * <code>Atime</code> is set to <code>NONE</code>, <code>Mtime</code> must also be
     * <code>NONE</code>. </p> 
     */
    inline bool AtimeHasBeenSet() const { return m_atimeHasBeenSet; }

    /**
     * <p>A file metadata value that shows the last time a file was accessed (that is,
     * when the file was read or written to). If you set <code>Atime</code> to
     * <code>BEST_EFFORT</code>, DataSync attempts to preserve the original
     * <code>Atime</code> attribute on all source files (that is, the version before
     * the <code>PREPARING</code> phase). However, <code>Atime</code>'s behavior is not
     * fully standard across platforms, so DataSync can only do this on a best-effort
     * basis. </p> <p>Default value: <code>BEST_EFFORT</code> </p> <p>
     * <code>BEST_EFFORT</code>: Attempt to preserve the per-file <code>Atime</code>
     * value (recommended).</p> <p> <code>NONE</code>: Ignore <code>Atime</code>.</p>
     *  <p>If <code>Atime</code> is set to <code>BEST_EFFORT</code>,
     * <code>Mtime</code> must be set to <code>PRESERVE</code>. </p> <p>If
     * <code>Atime</code> is set to <code>NONE</code>, <code>Mtime</code> must also be
     * <code>NONE</code>. </p> 
     */
    inline void SetAtime(const Atime& value) { m_atimeHasBeenSet = true; m_atime = value; }

    /**
     * <p>A file metadata value that shows the last time a file was accessed (that is,
     * when the file was read or written to). If you set <code>Atime</code> to
     * <code>BEST_EFFORT</code>, DataSync attempts to preserve the original
     * <code>Atime</code> attribute on all source files (that is, the version before
     * the <code>PREPARING</code> phase). However, <code>Atime</code>'s behavior is not
     * fully standard across platforms, so DataSync can only do this on a best-effort
     * basis. </p> <p>Default value: <code>BEST_EFFORT</code> </p> <p>
     * <code>BEST_EFFORT</code>: Attempt to preserve the per-file <code>Atime</code>
     * value (recommended).</p> <p> <code>NONE</code>: Ignore <code>Atime</code>.</p>
     *  <p>If <code>Atime</code> is set to <code>BEST_EFFORT</code>,
     * <code>Mtime</code> must be set to <code>PRESERVE</code>. </p> <p>If
     * <code>Atime</code> is set to <code>NONE</code>, <code>Mtime</code> must also be
     * <code>NONE</code>. </p> 
     */
    inline void SetAtime(Atime&& value) { m_atimeHasBeenSet = true; m_atime = std::move(value); }

    /**
     * <p>A file metadata value that shows the last time a file was accessed (that is,
     * when the file was read or written to). If you set <code>Atime</code> to
     * <code>BEST_EFFORT</code>, DataSync attempts to preserve the original
     * <code>Atime</code> attribute on all source files (that is, the version before
     * the <code>PREPARING</code> phase). However, <code>Atime</code>'s behavior is not
     * fully standard across platforms, so DataSync can only do this on a best-effort
     * basis. </p> <p>Default value: <code>BEST_EFFORT</code> </p> <p>
     * <code>BEST_EFFORT</code>: Attempt to preserve the per-file <code>Atime</code>
     * value (recommended).</p> <p> <code>NONE</code>: Ignore <code>Atime</code>.</p>
     *  <p>If <code>Atime</code> is set to <code>BEST_EFFORT</code>,
     * <code>Mtime</code> must be set to <code>PRESERVE</code>. </p> <p>If
     * <code>Atime</code> is set to <code>NONE</code>, <code>Mtime</code> must also be
     * <code>NONE</code>. </p> 
     */
    inline Options& WithAtime(const Atime& value) { SetAtime(value); return *this;}

    /**
     * <p>A file metadata value that shows the last time a file was accessed (that is,
     * when the file was read or written to). If you set <code>Atime</code> to
     * <code>BEST_EFFORT</code>, DataSync attempts to preserve the original
     * <code>Atime</code> attribute on all source files (that is, the version before
     * the <code>PREPARING</code> phase). However, <code>Atime</code>'s behavior is not
     * fully standard across platforms, so DataSync can only do this on a best-effort
     * basis. </p> <p>Default value: <code>BEST_EFFORT</code> </p> <p>
     * <code>BEST_EFFORT</code>: Attempt to preserve the per-file <code>Atime</code>
     * value (recommended).</p> <p> <code>NONE</code>: Ignore <code>Atime</code>.</p>
     *  <p>If <code>Atime</code> is set to <code>BEST_EFFORT</code>,
     * <code>Mtime</code> must be set to <code>PRESERVE</code>. </p> <p>If
     * <code>Atime</code> is set to <code>NONE</code>, <code>Mtime</code> must also be
     * <code>NONE</code>. </p> 
     */
    inline Options& WithAtime(Atime&& value) { SetAtime(std::move(value)); return *this;}


    /**
     * <p>A value that indicates the last time that a file was modified (that is, a
     * file was written to) before the <code>PREPARING</code> phase. This option is
     * required for cases when you need to run the same task more than one time. </p>
     * <p>Default Value: <code>PRESERVE</code> </p> <p> <code>PRESERVE</code>: Preserve
     * original <code>Mtime</code> (recommended)</p> <p> <code>NONE</code>: Ignore
     * <code>Mtime</code>. </p>  <p>If <code>Mtime</code> is set to
     * <code>PRESERVE</code>, <code>Atime</code> must be set to
     * <code>BEST_EFFORT</code>.</p> <p>If <code>Mtime</code> is set to
     * <code>NONE</code>, <code>Atime</code> must also be set to <code>NONE</code>.
     * </p> 
     */
    inline const Mtime& GetMtime() const{ return m_mtime; }

    /**
     * <p>A value that indicates the last time that a file was modified (that is, a
     * file was written to) before the <code>PREPARING</code> phase. This option is
     * required for cases when you need to run the same task more than one time. </p>
     * <p>Default Value: <code>PRESERVE</code> </p> <p> <code>PRESERVE</code>: Preserve
     * original <code>Mtime</code> (recommended)</p> <p> <code>NONE</code>: Ignore
     * <code>Mtime</code>. </p>  <p>If <code>Mtime</code> is set to
     * <code>PRESERVE</code>, <code>Atime</code> must be set to
     * <code>BEST_EFFORT</code>.</p> <p>If <code>Mtime</code> is set to
     * <code>NONE</code>, <code>Atime</code> must also be set to <code>NONE</code>.
     * </p> 
     */
    inline bool MtimeHasBeenSet() const { return m_mtimeHasBeenSet; }

    /**
     * <p>A value that indicates the last time that a file was modified (that is, a
     * file was written to) before the <code>PREPARING</code> phase. This option is
     * required for cases when you need to run the same task more than one time. </p>
     * <p>Default Value: <code>PRESERVE</code> </p> <p> <code>PRESERVE</code>: Preserve
     * original <code>Mtime</code> (recommended)</p> <p> <code>NONE</code>: Ignore
     * <code>Mtime</code>. </p>  <p>If <code>Mtime</code> is set to
     * <code>PRESERVE</code>, <code>Atime</code> must be set to
     * <code>BEST_EFFORT</code>.</p> <p>If <code>Mtime</code> is set to
     * <code>NONE</code>, <code>Atime</code> must also be set to <code>NONE</code>.
     * </p> 
     */
    inline void SetMtime(const Mtime& value) { m_mtimeHasBeenSet = true; m_mtime = value; }

    /**
     * <p>A value that indicates the last time that a file was modified (that is, a
     * file was written to) before the <code>PREPARING</code> phase. This option is
     * required for cases when you need to run the same task more than one time. </p>
     * <p>Default Value: <code>PRESERVE</code> </p> <p> <code>PRESERVE</code>: Preserve
     * original <code>Mtime</code> (recommended)</p> <p> <code>NONE</code>: Ignore
     * <code>Mtime</code>. </p>  <p>If <code>Mtime</code> is set to
     * <code>PRESERVE</code>, <code>Atime</code> must be set to
     * <code>BEST_EFFORT</code>.</p> <p>If <code>Mtime</code> is set to
     * <code>NONE</code>, <code>Atime</code> must also be set to <code>NONE</code>.
     * </p> 
     */
    inline void SetMtime(Mtime&& value) { m_mtimeHasBeenSet = true; m_mtime = std::move(value); }

    /**
     * <p>A value that indicates the last time that a file was modified (that is, a
     * file was written to) before the <code>PREPARING</code> phase. This option is
     * required for cases when you need to run the same task more than one time. </p>
     * <p>Default Value: <code>PRESERVE</code> </p> <p> <code>PRESERVE</code>: Preserve
     * original <code>Mtime</code> (recommended)</p> <p> <code>NONE</code>: Ignore
     * <code>Mtime</code>. </p>  <p>If <code>Mtime</code> is set to
     * <code>PRESERVE</code>, <code>Atime</code> must be set to
     * <code>BEST_EFFORT</code>.</p> <p>If <code>Mtime</code> is set to
     * <code>NONE</code>, <code>Atime</code> must also be set to <code>NONE</code>.
     * </p> 
     */
    inline Options& WithMtime(const Mtime& value) { SetMtime(value); return *this;}

    /**
     * <p>A value that indicates the last time that a file was modified (that is, a
     * file was written to) before the <code>PREPARING</code> phase. This option is
     * required for cases when you need to run the same task more than one time. </p>
     * <p>Default Value: <code>PRESERVE</code> </p> <p> <code>PRESERVE</code>: Preserve
     * original <code>Mtime</code> (recommended)</p> <p> <code>NONE</code>: Ignore
     * <code>Mtime</code>. </p>  <p>If <code>Mtime</code> is set to
     * <code>PRESERVE</code>, <code>Atime</code> must be set to
     * <code>BEST_EFFORT</code>.</p> <p>If <code>Mtime</code> is set to
     * <code>NONE</code>, <code>Atime</code> must also be set to <code>NONE</code>.
     * </p> 
     */
    inline Options& WithMtime(Mtime&& value) { SetMtime(std::move(value)); return *this;}


    /**
     * <p>The POSIX user ID (UID) of the file's owner.</p> <p>For more information, see
     * <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of UID and group ID (GID) (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID. </p>
     */
    inline const Uid& GetUid() const{ return m_uid; }

    /**
     * <p>The POSIX user ID (UID) of the file's owner.</p> <p>For more information, see
     * <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of UID and group ID (GID) (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID. </p>
     */
    inline bool UidHasBeenSet() const { return m_uidHasBeenSet; }

    /**
     * <p>The POSIX user ID (UID) of the file's owner.</p> <p>For more information, see
     * <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of UID and group ID (GID) (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID. </p>
     */
    inline void SetUid(const Uid& value) { m_uidHasBeenSet = true; m_uid = value; }

    /**
     * <p>The POSIX user ID (UID) of the file's owner.</p> <p>For more information, see
     * <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of UID and group ID (GID) (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID. </p>
     */
    inline void SetUid(Uid&& value) { m_uidHasBeenSet = true; m_uid = std::move(value); }

    /**
     * <p>The POSIX user ID (UID) of the file's owner.</p> <p>For more information, see
     * <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of UID and group ID (GID) (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID. </p>
     */
    inline Options& WithUid(const Uid& value) { SetUid(value); return *this;}

    /**
     * <p>The POSIX user ID (UID) of the file's owner.</p> <p>For more information, see
     * <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of UID and group ID (GID) (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID. </p>
     */
    inline Options& WithUid(Uid&& value) { SetUid(std::move(value)); return *this;}


    /**
     * <p>The POSIX group ID (GID) of the file's owners.</p> <p>For more information,
     * see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of user ID (UID) and GID (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID.</p>
     */
    inline const Gid& GetGid() const{ return m_gid; }

    /**
     * <p>The POSIX group ID (GID) of the file's owners.</p> <p>For more information,
     * see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of user ID (UID) and GID (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID.</p>
     */
    inline bool GidHasBeenSet() const { return m_gidHasBeenSet; }

    /**
     * <p>The POSIX group ID (GID) of the file's owners.</p> <p>For more information,
     * see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of user ID (UID) and GID (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID.</p>
     */
    inline void SetGid(const Gid& value) { m_gidHasBeenSet = true; m_gid = value; }

    /**
     * <p>The POSIX group ID (GID) of the file's owners.</p> <p>For more information,
     * see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of user ID (UID) and GID (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID.</p>
     */
    inline void SetGid(Gid&& value) { m_gidHasBeenSet = true; m_gid = std::move(value); }

    /**
     * <p>The POSIX group ID (GID) of the file's owners.</p> <p>For more information,
     * see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of user ID (UID) and GID (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID.</p>
     */
    inline Options& WithGid(const Gid& value) { SetGid(value); return *this;}

    /**
     * <p>The POSIX group ID (GID) of the file's owners.</p> <p>For more information,
     * see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>INT_VALUE</code>. This
     * preserves the integer value of the ID.</p> <p> <code>INT_VALUE</code>: Preserve
     * the integer value of user ID (UID) and GID (recommended).</p> <p>
     * <code>NONE</code>: Ignore UID and GID.</p>
     */
    inline Options& WithGid(Gid&& value) { SetGid(std::move(value)); return *this;}


    /**
     * <p>A value that specifies whether files in the destination that don't exist in
     * the source file system should be preserved. This option can affect your storage
     * cost. If your task deletes objects, you might incur minimum storage duration
     * charges for certain storage classes. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Ignore such destination files (recommended). </p> <p>
     * <code>REMOVE</code>: Delete destination files that aren’t present in the
     * source.</p>
     */
    inline const PreserveDeletedFiles& GetPreserveDeletedFiles() const{ return m_preserveDeletedFiles; }

    /**
     * <p>A value that specifies whether files in the destination that don't exist in
     * the source file system should be preserved. This option can affect your storage
     * cost. If your task deletes objects, you might incur minimum storage duration
     * charges for certain storage classes. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Ignore such destination files (recommended). </p> <p>
     * <code>REMOVE</code>: Delete destination files that aren’t present in the
     * source.</p>
     */
    inline bool PreserveDeletedFilesHasBeenSet() const { return m_preserveDeletedFilesHasBeenSet; }

    /**
     * <p>A value that specifies whether files in the destination that don't exist in
     * the source file system should be preserved. This option can affect your storage
     * cost. If your task deletes objects, you might incur minimum storage duration
     * charges for certain storage classes. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Ignore such destination files (recommended). </p> <p>
     * <code>REMOVE</code>: Delete destination files that aren’t present in the
     * source.</p>
     */
    inline void SetPreserveDeletedFiles(const PreserveDeletedFiles& value) { m_preserveDeletedFilesHasBeenSet = true; m_preserveDeletedFiles = value; }

    /**
     * <p>A value that specifies whether files in the destination that don't exist in
     * the source file system should be preserved. This option can affect your storage
     * cost. If your task deletes objects, you might incur minimum storage duration
     * charges for certain storage classes. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Ignore such destination files (recommended). </p> <p>
     * <code>REMOVE</code>: Delete destination files that aren’t present in the
     * source.</p>
     */
    inline void SetPreserveDeletedFiles(PreserveDeletedFiles&& value) { m_preserveDeletedFilesHasBeenSet = true; m_preserveDeletedFiles = std::move(value); }

    /**
     * <p>A value that specifies whether files in the destination that don't exist in
     * the source file system should be preserved. This option can affect your storage
     * cost. If your task deletes objects, you might incur minimum storage duration
     * charges for certain storage classes. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Ignore such destination files (recommended). </p> <p>
     * <code>REMOVE</code>: Delete destination files that aren’t present in the
     * source.</p>
     */
    inline Options& WithPreserveDeletedFiles(const PreserveDeletedFiles& value) { SetPreserveDeletedFiles(value); return *this;}

    /**
     * <p>A value that specifies whether files in the destination that don't exist in
     * the source file system should be preserved. This option can affect your storage
     * cost. If your task deletes objects, you might incur minimum storage duration
     * charges for certain storage classes. For detailed information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations
     * when working with Amazon S3 storage classes in DataSync </a> in the <i>DataSync
     * User Guide</i>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Ignore such destination files (recommended). </p> <p>
     * <code>REMOVE</code>: Delete destination files that aren’t present in the
     * source.</p>
     */
    inline Options& WithPreserveDeletedFiles(PreserveDeletedFiles&& value) { SetPreserveDeletedFiles(std::move(value)); return *this;}


    /**
     * <p>A value that determines whether DataSync should preserve the metadata of
     * block and character devices in the source file system, and re-create the files
     * with that device name and metadata on the destination. DataSync does not copy
     * the contents of such devices, only the name and metadata. </p> 
     * <p>DataSync can't sync the actual contents of such devices, because they are
     * nonterminal and don't return an end-of-file (EOF) marker.</p>  <p>Default
     * value: <code>NONE</code> </p> <p> <code>NONE</code>: Ignore special devices
     * (recommended). </p> <p> <code>PRESERVE</code>: Preserve character and block
     * device metadata. This option isn't currently supported for Amazon EFS. </p>
     */
    inline const PreserveDevices& GetPreserveDevices() const{ return m_preserveDevices; }

    /**
     * <p>A value that determines whether DataSync should preserve the metadata of
     * block and character devices in the source file system, and re-create the files
     * with that device name and metadata on the destination. DataSync does not copy
     * the contents of such devices, only the name and metadata. </p> 
     * <p>DataSync can't sync the actual contents of such devices, because they are
     * nonterminal and don't return an end-of-file (EOF) marker.</p>  <p>Default
     * value: <code>NONE</code> </p> <p> <code>NONE</code>: Ignore special devices
     * (recommended). </p> <p> <code>PRESERVE</code>: Preserve character and block
     * device metadata. This option isn't currently supported for Amazon EFS. </p>
     */
    inline bool PreserveDevicesHasBeenSet() const { return m_preserveDevicesHasBeenSet; }

    /**
     * <p>A value that determines whether DataSync should preserve the metadata of
     * block and character devices in the source file system, and re-create the files
     * with that device name and metadata on the destination. DataSync does not copy
     * the contents of such devices, only the name and metadata. </p> 
     * <p>DataSync can't sync the actual contents of such devices, because they are
     * nonterminal and don't return an end-of-file (EOF) marker.</p>  <p>Default
     * value: <code>NONE</code> </p> <p> <code>NONE</code>: Ignore special devices
     * (recommended). </p> <p> <code>PRESERVE</code>: Preserve character and block
     * device metadata. This option isn't currently supported for Amazon EFS. </p>
     */
    inline void SetPreserveDevices(const PreserveDevices& value) { m_preserveDevicesHasBeenSet = true; m_preserveDevices = value; }

    /**
     * <p>A value that determines whether DataSync should preserve the metadata of
     * block and character devices in the source file system, and re-create the files
     * with that device name and metadata on the destination. DataSync does not copy
     * the contents of such devices, only the name and metadata. </p> 
     * <p>DataSync can't sync the actual contents of such devices, because they are
     * nonterminal and don't return an end-of-file (EOF) marker.</p>  <p>Default
     * value: <code>NONE</code> </p> <p> <code>NONE</code>: Ignore special devices
     * (recommended). </p> <p> <code>PRESERVE</code>: Preserve character and block
     * device metadata. This option isn't currently supported for Amazon EFS. </p>
     */
    inline void SetPreserveDevices(PreserveDevices&& value) { m_preserveDevicesHasBeenSet = true; m_preserveDevices = std::move(value); }

    /**
     * <p>A value that determines whether DataSync should preserve the metadata of
     * block and character devices in the source file system, and re-create the files
     * with that device name and metadata on the destination. DataSync does not copy
     * the contents of such devices, only the name and metadata. </p> 
     * <p>DataSync can't sync the actual contents of such devices, because they are
     * nonterminal and don't return an end-of-file (EOF) marker.</p>  <p>Default
     * value: <code>NONE</code> </p> <p> <code>NONE</code>: Ignore special devices
     * (recommended). </p> <p> <code>PRESERVE</code>: Preserve character and block
     * device metadata. This option isn't currently supported for Amazon EFS. </p>
     */
    inline Options& WithPreserveDevices(const PreserveDevices& value) { SetPreserveDevices(value); return *this;}

    /**
     * <p>A value that determines whether DataSync should preserve the metadata of
     * block and character devices in the source file system, and re-create the files
     * with that device name and metadata on the destination. DataSync does not copy
     * the contents of such devices, only the name and metadata. </p> 
     * <p>DataSync can't sync the actual contents of such devices, because they are
     * nonterminal and don't return an end-of-file (EOF) marker.</p>  <p>Default
     * value: <code>NONE</code> </p> <p> <code>NONE</code>: Ignore special devices
     * (recommended). </p> <p> <code>PRESERVE</code>: Preserve character and block
     * device metadata. This option isn't currently supported for Amazon EFS. </p>
     */
    inline Options& WithPreserveDevices(PreserveDevices&& value) { SetPreserveDevices(std::move(value)); return *this;}


    /**
     * <p>A value that determines which users or groups can access a file for a
     * specific purpose such as reading, writing, or execution of the file.</p> <p>For
     * more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Preserve POSIX-style permissions (recommended).</p> <p>
     * <code>NONE</code>: Ignore permissions. </p>  <p>DataSync can preserve
     * extant permissions of a source location.</p> 
     */
    inline const PosixPermissions& GetPosixPermissions() const{ return m_posixPermissions; }

    /**
     * <p>A value that determines which users or groups can access a file for a
     * specific purpose such as reading, writing, or execution of the file.</p> <p>For
     * more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Preserve POSIX-style permissions (recommended).</p> <p>
     * <code>NONE</code>: Ignore permissions. </p>  <p>DataSync can preserve
     * extant permissions of a source location.</p> 
     */
    inline bool PosixPermissionsHasBeenSet() const { return m_posixPermissionsHasBeenSet; }

    /**
     * <p>A value that determines which users or groups can access a file for a
     * specific purpose such as reading, writing, or execution of the file.</p> <p>For
     * more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Preserve POSIX-style permissions (recommended).</p> <p>
     * <code>NONE</code>: Ignore permissions. </p>  <p>DataSync can preserve
     * extant permissions of a source location.</p> 
     */
    inline void SetPosixPermissions(const PosixPermissions& value) { m_posixPermissionsHasBeenSet = true; m_posixPermissions = value; }

    /**
     * <p>A value that determines which users or groups can access a file for a
     * specific purpose such as reading, writing, or execution of the file.</p> <p>For
     * more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Preserve POSIX-style permissions (recommended).</p> <p>
     * <code>NONE</code>: Ignore permissions. </p>  <p>DataSync can preserve
     * extant permissions of a source location.</p> 
     */
    inline void SetPosixPermissions(PosixPermissions&& value) { m_posixPermissionsHasBeenSet = true; m_posixPermissions = std::move(value); }

    /**
     * <p>A value that determines which users or groups can access a file for a
     * specific purpose such as reading, writing, or execution of the file.</p> <p>For
     * more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Preserve POSIX-style permissions (recommended).</p> <p>
     * <code>NONE</code>: Ignore permissions. </p>  <p>DataSync can preserve
     * extant permissions of a source location.</p> 
     */
    inline Options& WithPosixPermissions(const PosixPermissions& value) { SetPosixPermissions(value); return *this;}

    /**
     * <p>A value that determines which users or groups can access a file for a
     * specific purpose such as reading, writing, or execution of the file.</p> <p>For
     * more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata
     * copied by DataSync</a>.</p> <p>Default value: <code>PRESERVE</code> </p> <p>
     * <code>PRESERVE</code>: Preserve POSIX-style permissions (recommended).</p> <p>
     * <code>NONE</code>: Ignore permissions. </p>  <p>DataSync can preserve
     * extant permissions of a source location.</p> 
     */
    inline Options& WithPosixPermissions(PosixPermissions&& value) { SetPosixPermissions(std::move(value)); return *this;}


    /**
     * <p>A value that limits the bandwidth used by DataSync. For example, if you want
     * DataSync to use a maximum of 1 MB, set this value to <code>1048576</code>
     * (<code>=1024*1024</code>).</p>
     */
    inline long long GetBytesPerSecond() const{ return m_bytesPerSecond; }

    /**
     * <p>A value that limits the bandwidth used by DataSync. For example, if you want
     * DataSync to use a maximum of 1 MB, set this value to <code>1048576</code>
     * (<code>=1024*1024</code>).</p>
     */
    inline bool BytesPerSecondHasBeenSet() const { return m_bytesPerSecondHasBeenSet; }

    /**
     * <p>A value that limits the bandwidth used by DataSync. For example, if you want
     * DataSync to use a maximum of 1 MB, set this value to <code>1048576</code>
     * (<code>=1024*1024</code>).</p>
     */
    inline void SetBytesPerSecond(long long value) { m_bytesPerSecondHasBeenSet = true; m_bytesPerSecond = value; }

    /**
     * <p>A value that limits the bandwidth used by DataSync. For example, if you want
     * DataSync to use a maximum of 1 MB, set this value to <code>1048576</code>
     * (<code>=1024*1024</code>).</p>
     */
    inline Options& WithBytesPerSecond(long long value) { SetBytesPerSecond(value); return *this;}


    /**
     * <p>A value that determines whether tasks should be queued before executing the
     * tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is
     * <code>ENABLED</code>.</p> <p>If you use the same agent to run multiple tasks,
     * you can enable the tasks to run in series. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing
     * task executions</a>.</p>
     */
    inline const TaskQueueing& GetTaskQueueing() const{ return m_taskQueueing; }

    /**
     * <p>A value that determines whether tasks should be queued before executing the
     * tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is
     * <code>ENABLED</code>.</p> <p>If you use the same agent to run multiple tasks,
     * you can enable the tasks to run in series. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing
     * task executions</a>.</p>
     */
    inline bool TaskQueueingHasBeenSet() const { return m_taskQueueingHasBeenSet; }

    /**
     * <p>A value that determines whether tasks should be queued before executing the
     * tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is
     * <code>ENABLED</code>.</p> <p>If you use the same agent to run multiple tasks,
     * you can enable the tasks to run in series. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing
     * task executions</a>.</p>
     */
    inline void SetTaskQueueing(const TaskQueueing& value) { m_taskQueueingHasBeenSet = true; m_taskQueueing = value; }

    /**
     * <p>A value that determines whether tasks should be queued before executing the
     * tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is
     * <code>ENABLED</code>.</p> <p>If you use the same agent to run multiple tasks,
     * you can enable the tasks to run in series. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing
     * task executions</a>.</p>
     */
    inline void SetTaskQueueing(TaskQueueing&& value) { m_taskQueueingHasBeenSet = true; m_taskQueueing = std::move(value); }

    /**
     * <p>A value that determines whether tasks should be queued before executing the
     * tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is
     * <code>ENABLED</code>.</p> <p>If you use the same agent to run multiple tasks,
     * you can enable the tasks to run in series. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing
     * task executions</a>.</p>
     */
    inline Options& WithTaskQueueing(const TaskQueueing& value) { SetTaskQueueing(value); return *this;}

    /**
     * <p>A value that determines whether tasks should be queued before executing the
     * tasks. If set to <code>ENABLED</code>, the tasks will be queued. The default is
     * <code>ENABLED</code>.</p> <p>If you use the same agent to run multiple tasks,
     * you can enable the tasks to run in series. For more information, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing
     * task executions</a>.</p>
     */
    inline Options& WithTaskQueueing(TaskQueueing&& value) { SetTaskQueueing(std::move(value)); return *this;}


    /**
     * <p>A value that determines the type of logs that DataSync publishes to a log
     * stream in the Amazon CloudWatch log group that you provide. For more information
     * about providing a log group for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>.
     * If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes
     * logs on errors for individual files transferred, and <code>TRANSFER</code>
     * publishes logs for every file or object that is transferred and integrity
     * checked.</p>
     */
    inline const LogLevel& GetLogLevel() const{ return m_logLevel; }

    /**
     * <p>A value that determines the type of logs that DataSync publishes to a log
     * stream in the Amazon CloudWatch log group that you provide. For more information
     * about providing a log group for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>.
     * If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes
     * logs on errors for individual files transferred, and <code>TRANSFER</code>
     * publishes logs for every file or object that is transferred and integrity
     * checked.</p>
     */
    inline bool LogLevelHasBeenSet() const { return m_logLevelHasBeenSet; }

    /**
     * <p>A value that determines the type of logs that DataSync publishes to a log
     * stream in the Amazon CloudWatch log group that you provide. For more information
     * about providing a log group for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>.
     * If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes
     * logs on errors for individual files transferred, and <code>TRANSFER</code>
     * publishes logs for every file or object that is transferred and integrity
     * checked.</p>
     */
    inline void SetLogLevel(const LogLevel& value) { m_logLevelHasBeenSet = true; m_logLevel = value; }

    /**
     * <p>A value that determines the type of logs that DataSync publishes to a log
     * stream in the Amazon CloudWatch log group that you provide. For more information
     * about providing a log group for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>.
     * If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes
     * logs on errors for individual files transferred, and <code>TRANSFER</code>
     * publishes logs for every file or object that is transferred and integrity
     * checked.</p>
     */
    inline void SetLogLevel(LogLevel&& value) { m_logLevelHasBeenSet = true; m_logLevel = std::move(value); }

    /**
     * <p>A value that determines the type of logs that DataSync publishes to a log
     * stream in the Amazon CloudWatch log group that you provide. For more information
     * about providing a log group for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>.
     * If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes
     * logs on errors for individual files transferred, and <code>TRANSFER</code>
     * publishes logs for every file or object that is transferred and integrity
     * checked.</p>
     */
    inline Options& WithLogLevel(const LogLevel& value) { SetLogLevel(value); return *this;}

    /**
     * <p>A value that determines the type of logs that DataSync publishes to a log
     * stream in the Amazon CloudWatch log group that you provide. For more information
     * about providing a log group for DataSync, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a>.
     * If set to <code>OFF</code>, no logs are published. <code>BASIC</code> publishes
     * logs on errors for individual files transferred, and <code>TRANSFER</code>
     * publishes logs for every file or object that is transferred and integrity
     * checked.</p>
     */
    inline Options& WithLogLevel(LogLevel&& value) { SetLogLevel(std::move(value)); return *this;}


    /**
     * <p>A value that determines whether DataSync transfers only the data and metadata
     * that differ between the source and the destination location, or whether DataSync
     * transfers all the content from the source, without comparing to the destination
     * location. </p> <p> <code>CHANGED</code>: DataSync copies only data or metadata
     * that is new or different content from the source location to the destination
     * location.</p> <p> <code>ALL</code>: DataSync copies all source location content
     * to the destination, without comparing to existing content on the
     * destination.</p>
     */
    inline const TransferMode& GetTransferMode() const{ return m_transferMode; }

    /**
     * <p>A value that determines whether DataSync transfers only the data and metadata
     * that differ between the source and the destination location, or whether DataSync
     * transfers all the content from the source, without comparing to the destination
     * location. </p> <p> <code>CHANGED</code>: DataSync copies only data or metadata
     * that is new or different content from the source location to the destination
     * location.</p> <p> <code>ALL</code>: DataSync copies all source location content
     * to the destination, without comparing to existing content on the
     * destination.</p>
     */
    inline bool TransferModeHasBeenSet() const { return m_transferModeHasBeenSet; }

    /**
     * <p>A value that determines whether DataSync transfers only the data and metadata
     * that differ between the source and the destination location, or whether DataSync
     * transfers all the content from the source, without comparing to the destination
     * location. </p> <p> <code>CHANGED</code>: DataSync copies only data or metadata
     * that is new or different content from the source location to the destination
     * location.</p> <p> <code>ALL</code>: DataSync copies all source location content
     * to the destination, without comparing to existing content on the
     * destination.</p>
     */
    inline void SetTransferMode(const TransferMode& value) { m_transferModeHasBeenSet = true; m_transferMode = value; }

    /**
     * <p>A value that determines whether DataSync transfers only the data and metadata
     * that differ between the source and the destination location, or whether DataSync
     * transfers all the content from the source, without comparing to the destination
     * location. </p> <p> <code>CHANGED</code>: DataSync copies only data or metadata
     * that is new or different content from the source location to the destination
     * location.</p> <p> <code>ALL</code>: DataSync copies all source location content
     * to the destination, without comparing to existing content on the
     * destination.</p>
     */
    inline void SetTransferMode(TransferMode&& value) { m_transferModeHasBeenSet = true; m_transferMode = std::move(value); }

    /**
     * <p>A value that determines whether DataSync transfers only the data and metadata
     * that differ between the source and the destination location, or whether DataSync
     * transfers all the content from the source, without comparing to the destination
     * location. </p> <p> <code>CHANGED</code>: DataSync copies only data or metadata
     * that is new or different content from the source location to the destination
     * location.</p> <p> <code>ALL</code>: DataSync copies all source location content
     * to the destination, without comparing to existing content on the
     * destination.</p>
     */
    inline Options& WithTransferMode(const TransferMode& value) { SetTransferMode(value); return *this;}

    /**
     * <p>A value that determines whether DataSync transfers only the data and metadata
     * that differ between the source and the destination location, or whether DataSync
     * transfers all the content from the source, without comparing to the destination
     * location. </p> <p> <code>CHANGED</code>: DataSync copies only data or metadata
     * that is new or different content from the source location to the destination
     * location.</p> <p> <code>ALL</code>: DataSync copies all source location content
     * to the destination, without comparing to existing content on the
     * destination.</p>
     */
    inline Options& WithTransferMode(TransferMode&& value) { SetTransferMode(std::move(value)); return *this;}


    /**
     * <p>A value that determines which components of the SMB security descriptor are
     * copied from source to destination objects. </p> <p>This value is only used for
     * transfers between SMB and Amazon FSx for Windows File Server locations, or
     * between two Amazon FSx for Windows File Server locations. For more information
     * about how DataSync handles metadata, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How
     * DataSync Handles Metadata and Special Files</a>. </p> <p>Default value:
     * <code>OWNER_DACL</code> </p> <p> <code>OWNER_DACL</code>: For each copied
     * object, DataSync copies the following metadata:</p> <ul> <li> <p>Object
     * owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which
     * determine whether to grant access to an object.</p> </li> </ul> <p>When choosing
     * this option, DataSync does NOT copy the NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> <p> <code>OWNER_DACL_SACL</code>: For each copied object, DataSync
     * copies the following metadata:</p> <ul> <li> <p>Object owner.</p> </li> <li>
     * <p>NTFS discretionary access control lists (DACLs), which determine whether to
     * grant access to an object.</p> </li> <li> <p>NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> </li> </ul> <p>Copying SACLs requires granting additional
     * permissions to the Windows user that DataSync uses to access your SMB location.
     * For information about choosing a user that ensures sufficient permissions to
     * files, folders, and metadata, see <a
     * href="create-smb-location.html#SMBuser">user</a>.</p> <p> <code>NONE</code>:
     * None of the SMB security descriptor components are copied. Destination objects
     * are owned by the user that was provided for accessing the destination location.
     * DACLs and SACLs are set based on the destination server’s configuration. </p>
     */
    inline const SmbSecurityDescriptorCopyFlags& GetSecurityDescriptorCopyFlags() const{ return m_securityDescriptorCopyFlags; }

    /**
     * <p>A value that determines which components of the SMB security descriptor are
     * copied from source to destination objects. </p> <p>This value is only used for
     * transfers between SMB and Amazon FSx for Windows File Server locations, or
     * between two Amazon FSx for Windows File Server locations. For more information
     * about how DataSync handles metadata, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How
     * DataSync Handles Metadata and Special Files</a>. </p> <p>Default value:
     * <code>OWNER_DACL</code> </p> <p> <code>OWNER_DACL</code>: For each copied
     * object, DataSync copies the following metadata:</p> <ul> <li> <p>Object
     * owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which
     * determine whether to grant access to an object.</p> </li> </ul> <p>When choosing
     * this option, DataSync does NOT copy the NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> <p> <code>OWNER_DACL_SACL</code>: For each copied object, DataSync
     * copies the following metadata:</p> <ul> <li> <p>Object owner.</p> </li> <li>
     * <p>NTFS discretionary access control lists (DACLs), which determine whether to
     * grant access to an object.</p> </li> <li> <p>NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> </li> </ul> <p>Copying SACLs requires granting additional
     * permissions to the Windows user that DataSync uses to access your SMB location.
     * For information about choosing a user that ensures sufficient permissions to
     * files, folders, and metadata, see <a
     * href="create-smb-location.html#SMBuser">user</a>.</p> <p> <code>NONE</code>:
     * None of the SMB security descriptor components are copied. Destination objects
     * are owned by the user that was provided for accessing the destination location.
     * DACLs and SACLs are set based on the destination server’s configuration. </p>
     */
    inline bool SecurityDescriptorCopyFlagsHasBeenSet() const { return m_securityDescriptorCopyFlagsHasBeenSet; }

    /**
     * <p>A value that determines which components of the SMB security descriptor are
     * copied from source to destination objects. </p> <p>This value is only used for
     * transfers between SMB and Amazon FSx for Windows File Server locations, or
     * between two Amazon FSx for Windows File Server locations. For more information
     * about how DataSync handles metadata, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How
     * DataSync Handles Metadata and Special Files</a>. </p> <p>Default value:
     * <code>OWNER_DACL</code> </p> <p> <code>OWNER_DACL</code>: For each copied
     * object, DataSync copies the following metadata:</p> <ul> <li> <p>Object
     * owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which
     * determine whether to grant access to an object.</p> </li> </ul> <p>When choosing
     * this option, DataSync does NOT copy the NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> <p> <code>OWNER_DACL_SACL</code>: For each copied object, DataSync
     * copies the following metadata:</p> <ul> <li> <p>Object owner.</p> </li> <li>
     * <p>NTFS discretionary access control lists (DACLs), which determine whether to
     * grant access to an object.</p> </li> <li> <p>NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> </li> </ul> <p>Copying SACLs requires granting additional
     * permissions to the Windows user that DataSync uses to access your SMB location.
     * For information about choosing a user that ensures sufficient permissions to
     * files, folders, and metadata, see <a
     * href="create-smb-location.html#SMBuser">user</a>.</p> <p> <code>NONE</code>:
     * None of the SMB security descriptor components are copied. Destination objects
     * are owned by the user that was provided for accessing the destination location.
     * DACLs and SACLs are set based on the destination server’s configuration. </p>
     */
    inline void SetSecurityDescriptorCopyFlags(const SmbSecurityDescriptorCopyFlags& value) { m_securityDescriptorCopyFlagsHasBeenSet = true; m_securityDescriptorCopyFlags = value; }

    /**
     * <p>A value that determines which components of the SMB security descriptor are
     * copied from source to destination objects. </p> <p>This value is only used for
     * transfers between SMB and Amazon FSx for Windows File Server locations, or
     * between two Amazon FSx for Windows File Server locations. For more information
     * about how DataSync handles metadata, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How
     * DataSync Handles Metadata and Special Files</a>. </p> <p>Default value:
     * <code>OWNER_DACL</code> </p> <p> <code>OWNER_DACL</code>: For each copied
     * object, DataSync copies the following metadata:</p> <ul> <li> <p>Object
     * owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which
     * determine whether to grant access to an object.</p> </li> </ul> <p>When choosing
     * this option, DataSync does NOT copy the NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> <p> <code>OWNER_DACL_SACL</code>: For each copied object, DataSync
     * copies the following metadata:</p> <ul> <li> <p>Object owner.</p> </li> <li>
     * <p>NTFS discretionary access control lists (DACLs), which determine whether to
     * grant access to an object.</p> </li> <li> <p>NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> </li> </ul> <p>Copying SACLs requires granting additional
     * permissions to the Windows user that DataSync uses to access your SMB location.
     * For information about choosing a user that ensures sufficient permissions to
     * files, folders, and metadata, see <a
     * href="create-smb-location.html#SMBuser">user</a>.</p> <p> <code>NONE</code>:
     * None of the SMB security descriptor components are copied. Destination objects
     * are owned by the user that was provided for accessing the destination location.
     * DACLs and SACLs are set based on the destination server’s configuration. </p>
     */
    inline void SetSecurityDescriptorCopyFlags(SmbSecurityDescriptorCopyFlags&& value) { m_securityDescriptorCopyFlagsHasBeenSet = true; m_securityDescriptorCopyFlags = std::move(value); }

    /**
     * <p>A value that determines which components of the SMB security descriptor are
     * copied from source to destination objects. </p> <p>This value is only used for
     * transfers between SMB and Amazon FSx for Windows File Server locations, or
     * between two Amazon FSx for Windows File Server locations. For more information
     * about how DataSync handles metadata, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How
     * DataSync Handles Metadata and Special Files</a>. </p> <p>Default value:
     * <code>OWNER_DACL</code> </p> <p> <code>OWNER_DACL</code>: For each copied
     * object, DataSync copies the following metadata:</p> <ul> <li> <p>Object
     * owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which
     * determine whether to grant access to an object.</p> </li> </ul> <p>When choosing
     * this option, DataSync does NOT copy the NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> <p> <code>OWNER_DACL_SACL</code>: For each copied object, DataSync
     * copies the following metadata:</p> <ul> <li> <p>Object owner.</p> </li> <li>
     * <p>NTFS discretionary access control lists (DACLs), which determine whether to
     * grant access to an object.</p> </li> <li> <p>NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> </li> </ul> <p>Copying SACLs requires granting additional
     * permissions to the Windows user that DataSync uses to access your SMB location.
     * For information about choosing a user that ensures sufficient permissions to
     * files, folders, and metadata, see <a
     * href="create-smb-location.html#SMBuser">user</a>.</p> <p> <code>NONE</code>:
     * None of the SMB security descriptor components are copied. Destination objects
     * are owned by the user that was provided for accessing the destination location.
     * DACLs and SACLs are set based on the destination server’s configuration. </p>
     */
    inline Options& WithSecurityDescriptorCopyFlags(const SmbSecurityDescriptorCopyFlags& value) { SetSecurityDescriptorCopyFlags(value); return *this;}

    /**
     * <p>A value that determines which components of the SMB security descriptor are
     * copied from source to destination objects. </p> <p>This value is only used for
     * transfers between SMB and Amazon FSx for Windows File Server locations, or
     * between two Amazon FSx for Windows File Server locations. For more information
     * about how DataSync handles metadata, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How
     * DataSync Handles Metadata and Special Files</a>. </p> <p>Default value:
     * <code>OWNER_DACL</code> </p> <p> <code>OWNER_DACL</code>: For each copied
     * object, DataSync copies the following metadata:</p> <ul> <li> <p>Object
     * owner.</p> </li> <li> <p>NTFS discretionary access control lists (DACLs), which
     * determine whether to grant access to an object.</p> </li> </ul> <p>When choosing
     * this option, DataSync does NOT copy the NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> <p> <code>OWNER_DACL_SACL</code>: For each copied object, DataSync
     * copies the following metadata:</p> <ul> <li> <p>Object owner.</p> </li> <li>
     * <p>NTFS discretionary access control lists (DACLs), which determine whether to
     * grant access to an object.</p> </li> <li> <p>NTFS system access control lists
     * (SACLs), which are used by administrators to log attempts to access a secured
     * object.</p> </li> </ul> <p>Copying SACLs requires granting additional
     * permissions to the Windows user that DataSync uses to access your SMB location.
     * For information about choosing a user that ensures sufficient permissions to
     * files, folders, and metadata, see <a
     * href="create-smb-location.html#SMBuser">user</a>.</p> <p> <code>NONE</code>:
     * None of the SMB security descriptor components are copied. Destination objects
     * are owned by the user that was provided for accessing the destination location.
     * DACLs and SACLs are set based on the destination server’s configuration. </p>
     */
    inline Options& WithSecurityDescriptorCopyFlags(SmbSecurityDescriptorCopyFlags&& value) { SetSecurityDescriptorCopyFlags(std::move(value)); return *this;}


    /**
     * <p>Specifies whether object tags are maintained when transferring between object
     * storage systems. If you want your DataSync task to ignore object tags, specify
     * the <code>NONE</code> value.</p> <p>Default Value: <code>PRESERVE</code> </p>
     */
    inline const ObjectTags& GetObjectTags() const{ return m_objectTags; }

    /**
     * <p>Specifies whether object tags are maintained when transferring between object
     * storage systems. If you want your DataSync task to ignore object tags, specify
     * the <code>NONE</code> value.</p> <p>Default Value: <code>PRESERVE</code> </p>
     */
    inline bool ObjectTagsHasBeenSet() const { return m_objectTagsHasBeenSet; }

    /**
     * <p>Specifies whether object tags are maintained when transferring between object
     * storage systems. If you want your DataSync task to ignore object tags, specify
     * the <code>NONE</code> value.</p> <p>Default Value: <code>PRESERVE</code> </p>
     */
    inline void SetObjectTags(const ObjectTags& value) { m_objectTagsHasBeenSet = true; m_objectTags = value; }

    /**
     * <p>Specifies whether object tags are maintained when transferring between object
     * storage systems. If you want your DataSync task to ignore object tags, specify
     * the <code>NONE</code> value.</p> <p>Default Value: <code>PRESERVE</code> </p>
     */
    inline void SetObjectTags(ObjectTags&& value) { m_objectTagsHasBeenSet = true; m_objectTags = std::move(value); }

    /**
     * <p>Specifies whether object tags are maintained when transferring between object
     * storage systems. If you want your DataSync task to ignore object tags, specify
     * the <code>NONE</code> value.</p> <p>Default Value: <code>PRESERVE</code> </p>
     */
    inline Options& WithObjectTags(const ObjectTags& value) { SetObjectTags(value); return *this;}

    /**
     * <p>Specifies whether object tags are maintained when transferring between object
     * storage systems. If you want your DataSync task to ignore object tags, specify
     * the <code>NONE</code> value.</p> <p>Default Value: <code>PRESERVE</code> </p>
     */
    inline Options& WithObjectTags(ObjectTags&& value) { SetObjectTags(std::move(value)); return *this;}

  private:

    VerifyMode m_verifyMode;
    bool m_verifyModeHasBeenSet;

    OverwriteMode m_overwriteMode;
    bool m_overwriteModeHasBeenSet;

    Atime m_atime;
    bool m_atimeHasBeenSet;

    Mtime m_mtime;
    bool m_mtimeHasBeenSet;

    Uid m_uid;
    bool m_uidHasBeenSet;

    Gid m_gid;
    bool m_gidHasBeenSet;

    PreserveDeletedFiles m_preserveDeletedFiles;
    bool m_preserveDeletedFilesHasBeenSet;

    PreserveDevices m_preserveDevices;
    bool m_preserveDevicesHasBeenSet;

    PosixPermissions m_posixPermissions;
    bool m_posixPermissionsHasBeenSet;

    long long m_bytesPerSecond;
    bool m_bytesPerSecondHasBeenSet;

    TaskQueueing m_taskQueueing;
    bool m_taskQueueingHasBeenSet;

    LogLevel m_logLevel;
    bool m_logLevelHasBeenSet;

    TransferMode m_transferMode;
    bool m_transferModeHasBeenSet;

    SmbSecurityDescriptorCopyFlags m_securityDescriptorCopyFlags;
    bool m_securityDescriptorCopyFlagsHasBeenSet;

    ObjectTags m_objectTags;
    bool m_objectTagsHasBeenSet;
  };

} // namespace Model
} // namespace DataSync
} // namespace Aws
